function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React, { useRef } from 'react';
import PropTypes from "prop-types";
import classNames from 'classnames';
import { OuiRadio, OuiCheckbox } from '../../form';
import { OuiSplitPanel } from '../../panel'; // if `checkableType` is left out or set to 'radio', use OuiRadioProps
// if `checkableType` is set to 'checkbox', use OuiCheckboxProps

export var OuiCheckableCard = function OuiCheckableCard(_ref) {
  var children = _ref.children,
      className = _ref.className,
      _ref$checkableType = _ref.checkableType,
      checkableType = _ref$checkableType === void 0 ? 'radio' : _ref$checkableType,
      label = _ref.label,
      checked = _ref.checked,
      disabled = _ref.disabled,
      hasShadow = _ref.hasShadow,
      _ref$hasBorder = _ref.hasBorder,
      hasBorder = _ref$hasBorder === void 0 ? true : _ref$hasBorder,
      rest = _objectWithoutProperties(_ref, ["children", "className", "checkableType", "label", "checked", "disabled", "hasShadow", "hasBorder"]);

  var id = rest.id;
  var labelEl = useRef(null);
  var classes = classNames('ouiCheckableCard', {
    'ouiCheckableCard-isChecked': checked,
    'ouiCheckableCard-isDisabled': disabled
  }, className);
  var checkableElement;

  if (checkableType === 'radio') {
    checkableElement = /*#__PURE__*/React.createElement(OuiRadio, _extends({
      checked: checked,
      disabled: disabled
    }, rest));
  } else {
    checkableElement = /*#__PURE__*/React.createElement(OuiCheckbox, _extends({
      checked: checked,
      disabled: disabled
    }, rest));
  }

  var labelClasses = classNames('ouiCheckableCard__label', {
    'ouiCheckableCard__label-isDisabled': disabled
  });

  var onChangeAffordance = function onChangeAffordance() {
    if (labelEl.current) {
      labelEl.current.click();
    }
  };

  return /*#__PURE__*/React.createElement(OuiSplitPanel.Outer, {
    responsive: false,
    hasShadow: hasShadow,
    hasBorder: hasBorder,
    direction: "row",
    className: classes
  }, /*#__PURE__*/React.createElement(OuiSplitPanel.Inner, {
    // Bubbles up the change event when clicking on the whole div for extra affordance
    onClick: disabled ? undefined : onChangeAffordance,
    color: checked ? 'primary' : 'subdued',
    grow: false
  }, checkableElement), /*#__PURE__*/React.createElement(OuiSplitPanel.Inner, null, /*#__PURE__*/React.createElement("label", {
    ref: labelEl,
    className: labelClasses,
    htmlFor: id,
    "aria-describedby": children ? "".concat(id, "-details") : undefined
  }, label), children && /*#__PURE__*/React.createElement("div", {
    id: "".concat(id, "-details"),
    className: "ouiCheckableCard__children"
  }, children)));
};
/* OUI -> EUI Aliases: Build-Time */

OuiCheckableCard.propTypes = {
  id: PropTypes.string.isRequired,
  label: PropTypes.node.isRequired,
  hasShadow: PropTypes.any,
  hasBorder: PropTypes.any
};

/* OUI -> EUI Aliases: Build-Time */
export { EuiCheckableCard } from '../../../eui_components/card/checkable_card/checkable_card';