/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ad.util;

import java.time.Clock;
import java.time.Instant;
import java.util.AbstractMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.opensearch.action.ActionRequest;

public class Throttler {
    private final ConcurrentHashMap<String, Map.Entry<ActionRequest, Instant>> negativeCache = new ConcurrentHashMap();
    private final Clock clock;

    public Throttler(Clock clock) {
        this.clock = clock;
    }

    public Throttler() {
        this(Clock.systemUTC());
    }

    public Optional<Map.Entry<ActionRequest, Instant>> getFilteredQuery(String detectorId) {
        return Optional.ofNullable(this.negativeCache.get(detectorId));
    }

    public synchronized boolean insertFilteredQuery(String detectorId, ActionRequest request) {
        return this.negativeCache.putIfAbsent(detectorId, new AbstractMap.SimpleEntry<ActionRequest, Instant>(request, this.clock.instant())) == null;
    }

    public void clearFilteredQuery(String detectorId) {
        this.negativeCache.remove(detectorId);
    }
}

