/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ad.ml;

import com.amazon.randomcutforest.parkservices.ThresholdedRandomCutForest;
import java.util.ArrayDeque;
import java.util.Optional;
import java.util.Queue;
import org.opensearch.ad.model.Entity;

public class EntityModel {
    private Entity entity;
    private Queue<double[]> samples;
    private ThresholdedRandomCutForest trcf;

    public EntityModel(Entity entity, Queue<double[]> samples, ThresholdedRandomCutForest trcf) {
        this.entity = entity;
        this.samples = samples;
        this.trcf = trcf;
    }

    public Optional<Entity> getEntity() {
        return Optional.ofNullable(this.entity);
    }

    public Queue<double[]> getSamples() {
        return this.samples;
    }

    public void setSamples(Queue<double[]> samples) {
        this.samples = samples;
    }

    public void addSample(double[] sample) {
        if (this.samples == null) {
            this.samples = new ArrayDeque<double[]>();
        }
        if (sample != null && sample.length != 0) {
            this.samples.add(sample);
        }
    }

    public void setTrcf(ThresholdedRandomCutForest trcf) {
        this.trcf = trcf;
    }

    public Optional<ThresholdedRandomCutForest> getTrcf() {
        return Optional.ofNullable(this.trcf);
    }

    public void clear() {
        if (this.samples != null) {
            this.samples.clear();
        }
        this.trcf = null;
    }
}

