/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.admin.cluster.repositories.put;

import java.io.IOException;
import java.util.Map;
import org.opensearch.Version;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.action.ValidateActions;
import org.opensearch.action.admin.cluster.crypto.CryptoSettings;
import org.opensearch.action.support.master.AcknowledgedRequest;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.common.settings.Settings;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;

@PublicApi(since="1.0.0")
public class PutRepositoryRequest
extends AcknowledgedRequest<PutRepositoryRequest>
implements ToXContentObject {
    private String name;
    private String type;
    private boolean verify = true;
    private Settings settings = Settings.Builder.EMPTY_SETTINGS;
    private CryptoSettings cryptoSettings;

    public PutRepositoryRequest(StreamInput in) throws IOException {
        super(in);
        this.name = in.readString();
        this.type = in.readString();
        this.settings = Settings.readSettingsFromStream(in);
        this.verify = in.readBoolean();
        if (in.getVersion().onOrAfter(Version.V_2_10_0)) {
            this.cryptoSettings = (CryptoSettings)in.readOptionalWriteable(CryptoSettings::new);
        }
    }

    public PutRepositoryRequest() {
    }

    public PutRepositoryRequest(String name) {
        this.name = name;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.name == null) {
            validationException = ValidateActions.addValidationError("name is missing", validationException);
        }
        if (this.type == null) {
            validationException = ValidateActions.addValidationError("type is missing", validationException);
        }
        if (this.cryptoSettings != null) {
            validationException = this.cryptoSettings.validate();
        }
        return validationException;
    }

    public PutRepositoryRequest name(String name) {
        this.name = name;
        return this;
    }

    public String name() {
        return this.name;
    }

    public PutRepositoryRequest type(String type) {
        this.type = type;
        return this;
    }

    public String type() {
        return this.type;
    }

    public PutRepositoryRequest settings(Settings settings) {
        this.settings = settings;
        return this;
    }

    public PutRepositoryRequest settings(Settings.Builder settings) {
        this.settings = settings.build();
        return this;
    }

    public PutRepositoryRequest settings(String source, MediaType mediaType) {
        this.settings = Settings.builder().loadFromSource(source, mediaType).build();
        return this;
    }

    public PutRepositoryRequest settings(Map<String, Object> source) {
        this.settings = Settings.builder().loadFromMap(source).build();
        return this;
    }

    public Settings settings() {
        return this.settings;
    }

    public PutRepositoryRequest verify(boolean verify) {
        this.verify = verify;
        return this;
    }

    public boolean verify() {
        return this.verify;
    }

    public PutRepositoryRequest cryptoSettings(CryptoSettings cryptoSettings) {
        this.cryptoSettings = cryptoSettings;
        return this;
    }

    public CryptoSettings cryptoSettings() {
        return this.cryptoSettings;
    }

    public PutRepositoryRequest source(Map<String, Object> repositoryDefinition) {
        for (Map.Entry<String, Object> entry : repositoryDefinition.entrySet()) {
            Map sub;
            String name = entry.getKey();
            if (name.equals("type")) {
                this.type(entry.getValue().toString());
                continue;
            }
            if (name.equals("settings")) {
                if (!(entry.getValue() instanceof Map)) {
                    throw new IllegalArgumentException("Malformed settings section, should include an inner object");
                }
                sub = (Map)entry.getValue();
                this.settings(sub);
                continue;
            }
            if (!name.equals("crypto_settings")) continue;
            if (!(entry.getValue() instanceof Map)) {
                throw new IllegalArgumentException("Malformed encryption_settings section, should include an inner object");
            }
            sub = (Map)entry.getValue();
            CryptoSettings cryptoSettings = new CryptoSettings(sub);
            this.cryptoSettings(cryptoSettings);
        }
        return this;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.name);
        out.writeString(this.type);
        Settings.writeSettingsToStream(this.settings, out);
        out.writeBoolean(this.verify);
        if (out.getVersion().onOrAfter(Version.V_2_10_0)) {
            out.writeOptionalWriteable((Writeable)this.cryptoSettings);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("name", this.name);
        builder.field("type", this.type);
        builder.startObject("settings");
        this.settings.toXContent(builder, params);
        builder.endObject();
        builder.field("verify", this.verify);
        if (this.cryptoSettings != null) {
            builder.startObject("crypto_settings");
            this.cryptoSettings.toXContent(builder, params);
            builder.endObject();
        }
        builder.endObject();
        return builder;
    }
}

