/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.util;

import org.directwebremoting.util.LoggingOutput;

public class SystemOutLoggingOutput
implements LoggingOutput {
    private static int level = 3;

    public SystemOutLoggingOutput(Class<?> base) {
    }

    @Override
    public void debug(String message) {
        SystemOutLoggingOutput.log(1, message, null);
    }

    @Override
    public void info(String message) {
        SystemOutLoggingOutput.log(2, message, null);
    }

    @Override
    public void warn(String message) {
        SystemOutLoggingOutput.log(3, message, null);
    }

    @Override
    public void warn(String message, Throwable th) {
        SystemOutLoggingOutput.log(3, message, th);
    }

    @Override
    public void error(String message) {
        SystemOutLoggingOutput.log(4, message, null);
    }

    @Override
    public void error(String message, Throwable th) {
        SystemOutLoggingOutput.log(4, message, th);
    }

    @Override
    public void fatal(String message) {
        SystemOutLoggingOutput.log(5, message, null);
    }

    @Override
    public void fatal(String message, Throwable th) {
        SystemOutLoggingOutput.log(5, message, th);
    }

    private static void log(int loglevel, String message, Throwable th) {
        if (loglevel >= level) {
            if (message != null) {
                System.out.println(message);
            }
            if (th != null) {
                th.printStackTrace();
            }
        }
    }

    public static void setLevel(String logLevel) {
        if ("FATAL".equalsIgnoreCase(logLevel)) {
            SystemOutLoggingOutput.setLevel(5);
        } else if ("ERROR".equalsIgnoreCase(logLevel)) {
            SystemOutLoggingOutput.setLevel(4);
        } else if ("WARN".equalsIgnoreCase(logLevel)) {
            SystemOutLoggingOutput.setLevel(3);
        } else if ("INFO".equalsIgnoreCase(logLevel)) {
            SystemOutLoggingOutput.setLevel(2);
        } else if ("DEBUG".equalsIgnoreCase(logLevel)) {
            SystemOutLoggingOutput.setLevel(1);
        } else {
            throw new IllegalArgumentException("Unknown log level: " + logLevel);
        }
    }

    @Override
    public boolean isDebugEnabled() {
        return level == 1;
    }

    public static void setLevel(int level) {
        SystemOutLoggingOutput.level = level;
    }

    public static int getLevel() {
        return level;
    }
}

