/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.impl;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class HttpClient {
    public static final int MAX_REDIRECTS = 20;

    public static void main(String[] args2) throws Exception {
        if (args2.length != 2 || !args2[0].startsWith("http")) {
            System.out.println("Usage: HttpClient <url> <filename>");
            System.out.println();
            System.out.println("This program demonstrates how to download from java.net's");
            System.out.println("Documents & Files area using URLConnection");
            return;
        }
        File targetFile = new File(args2[1]);
        if (targetFile.exists()) {
            System.out.println("Skipping " + args2[0] + ", file already exists");
            return;
        }
        InputStream httpIn = HttpClient.getInputStream(args2[0]);
        System.out.println("Downloading " + args2[0]);
        BufferedOutputStream fileOut = new BufferedOutputStream(new FileOutputStream(args2[1]));
        HttpClient.pushStreams(httpIn, fileOut);
        ((OutputStream)fileOut).close();
    }

    private static void pushStreams(InputStream source2, OutputStream target) throws IOException {
        int aByte;
        while ((aByte = source2.read()) >= 0) {
            target.write(aByte);
        }
    }

    private static InputStream getInputStream(String url) throws IOException {
        ArrayList cookies = new ArrayList();
        for (int i = 0; i < 20; ++i) {
            HttpURLConnection urlConnection = (HttpURLConnection)new URL(url).openConnection();
            urlConnection.setInstanceFollowRedirects(false);
            HttpClient.writeCookies(cookies, urlConnection);
            urlConnection.connect();
            if (urlConnection.getResponseCode() != 302 && urlConnection.getResponseCode() != 301) {
                return urlConnection.getInputStream();
            }
            url = urlConnection.getHeaderField("Location");
            HttpClient.acceptCookies(cookies, urlConnection);
        }
        throw new IOException("Max redirects 20 exceeded!");
    }

    private static void acceptCookies(List cookies, HttpURLConnection urlConnection) {
        for (Map.Entry<String, List<String>> entry : urlConnection.getHeaderFields().entrySet()) {
            String key = entry.getKey();
            if (!"Set-Cookie".equalsIgnoreCase(key)) continue;
            List<String> values2 = entry.getValue();
            for (String value : values2) {
                String cookie = value.split(";")[0];
                cookies.add(cookie);
            }
        }
    }

    private static void writeCookies(List cookies, HttpURLConnection urlConnection) {
        StringBuffer cookiesString = new StringBuffer();
        Iterator i = cookies.iterator();
        while (i.hasNext()) {
            if (cookiesString.length() > 0) {
                cookiesString.append("; ");
            }
            cookiesString.append(i.next());
        }
        if (cookiesString.length() > 0) {
            urlConnection.addRequestProperty("Cookie", cookiesString.toString());
        }
    }
}

