import { OlmMachine } from "@matrix-org/matrix-sdk-crypto-nodejs";
import * as AsyncLock from "async-lock";
import { MatrixClient } from "../MatrixClient";
import { ICryptoRoomInformation } from "./ICryptoRoomInformation";
/**
 * @internal
 */
export declare const SYNC_LOCK_NAME = "sync";
/**
 * @internal
 */
export declare class RustEngine {
    readonly machine: OlmMachine;
    private client;
    readonly lock: AsyncLock;
    constructor(machine: OlmMachine, client: MatrixClient);
    run(): Promise<void>;
    private runOnly;
    addTrackedUsers(userIds: string[]): Promise<void>;
    prepareEncrypt(roomId: string, roomInfo: ICryptoRoomInformation): Promise<void>;
    private processKeysClaimRequest;
    private processKeysUploadRequest;
    private processKeysQueryRequest;
    private processToDeviceRequest;
    private actuallyProcessToDeviceRequest;
}
