/* Generated by wayland-scanner 1.23.1 */

#ifndef SINGLE_PIXEL_BUFFER_V1_SERVER_PROTOCOL_H
#define SINGLE_PIXEL_BUFFER_V1_SERVER_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-server.h"

#ifdef  __cplusplus
extern "C" {
#endif

struct wl_client;
struct wl_resource;

/**
 * @page page_single_pixel_buffer_v1 The single_pixel_buffer_v1 protocol
 * single pixel buffer factory
 *
 * @section page_desc_single_pixel_buffer_v1 Description
 *
 * This protocol extension allows clients to create single-pixel buffers.
 *
 * Compositors supporting this protocol extension should also support the
 * viewporter protocol extension. Clients may use viewporter to scale a
 * single-pixel buffer to a desired size.
 *
 * Warning! The protocol described in this file is currently in the testing
 * phase. Backward compatible changes may be added together with the
 * corresponding interface version bump. Backward incompatible changes can
 * only be done by creating a new major version of the extension.
 *
 * @section page_ifaces_single_pixel_buffer_v1 Interfaces
 * - @subpage page_iface_wp_single_pixel_buffer_manager_v1 - global factory for single-pixel buffers
 * @section page_copyright_single_pixel_buffer_v1 Copyright
 * <pre>
 *
 * Copyright © 2022 Simon Ser
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 * </pre>
 */
struct wl_buffer;
struct wp_single_pixel_buffer_manager_v1;

#ifndef WP_SINGLE_PIXEL_BUFFER_MANAGER_V1_INTERFACE
#define WP_SINGLE_PIXEL_BUFFER_MANAGER_V1_INTERFACE
/**
 * @page page_iface_wp_single_pixel_buffer_manager_v1 wp_single_pixel_buffer_manager_v1
 * @section page_iface_wp_single_pixel_buffer_manager_v1_desc Description
 *
 * The wp_single_pixel_buffer_manager_v1 interface is a factory for
 * single-pixel buffers.
 * @section page_iface_wp_single_pixel_buffer_manager_v1_api API
 * See @ref iface_wp_single_pixel_buffer_manager_v1.
 */
/**
 * @defgroup iface_wp_single_pixel_buffer_manager_v1 The wp_single_pixel_buffer_manager_v1 interface
 *
 * The wp_single_pixel_buffer_manager_v1 interface is a factory for
 * single-pixel buffers.
 */
extern const struct wl_interface wp_single_pixel_buffer_manager_v1_interface;
#endif

/**
 * @ingroup iface_wp_single_pixel_buffer_manager_v1
 * @struct wp_single_pixel_buffer_manager_v1_interface
 */
struct wp_single_pixel_buffer_manager_v1_interface {
	/**
	 * destroy the manager
	 *
	 * Destroy the wp_single_pixel_buffer_manager_v1 object.
	 *
	 * The child objects created via this interface are unaffected.
	 */
	void (*destroy)(struct wl_client *client,
			struct wl_resource *resource);
	/**
	 * create a 1×1 buffer from 32-bit RGBA values
	 *
	 * Create a single-pixel buffer from four 32-bit RGBA values.
	 *
	 * Unless specified in another protocol extension, the RGBA values
	 * use pre-multiplied alpha.
	 *
	 * The width and height of the buffer are 1.
	 *
	 * The r, g, b and a arguments valid range is from UINT32_MIN (0)
	 * to UINT32_MAX (0xffffffff).
	 *
	 * These arguments should be interpreted as a percentage, i.e. -
	 * UINT32_MIN = 0% of the given color component - UINT32_MAX = 100%
	 * of the given color component
	 * @param r value of the buffer's red channel
	 * @param g value of the buffer's green channel
	 * @param b value of the buffer's blue channel
	 * @param a value of the buffer's alpha channel
	 */
	void (*create_u32_rgba_buffer)(struct wl_client *client,
				       struct wl_resource *resource,
				       uint32_t id,
				       uint32_t r,
				       uint32_t g,
				       uint32_t b,
				       uint32_t a);
};


/**
 * @ingroup iface_wp_single_pixel_buffer_manager_v1
 */
#define WP_SINGLE_PIXEL_BUFFER_MANAGER_V1_DESTROY_SINCE_VERSION 1
/**
 * @ingroup iface_wp_single_pixel_buffer_manager_v1
 */
#define WP_SINGLE_PIXEL_BUFFER_MANAGER_V1_CREATE_U32_RGBA_BUFFER_SINCE_VERSION 1

#ifdef  __cplusplus
}
#endif

#endif
