// This file is generated by kconfig_compiler_kf5 from kopeteappearancesettings.kcfg.
// All changes you do to this file will be lost.
#ifndef KOPETE_APPEARANCESETTINGS_H
#define KOPETE_APPEARANCESETTINGS_H

#include <libkopete_export.h>

#include <kconfigskeleton.h>
#include <QCoreApplication>
#include <QDebug>
#include <QSet>

#include <kstandarddirs.h>
#include <kglobalsettings.h>
#include <kcolorscheme.h>

namespace Kopete {

class LIBKOPETE_EXPORT AppearanceSettings : public KConfigSkeleton
{
  Q_OBJECT
  public:
    class EnumContactListGroupSorting
    {
      public:
      enum type { Manual, Name, COUNT };
    };
    class EnumContactListMetaContactSorting
    {
      public:
      enum type { Manual, Name, Status, COUNT };
    };
    class EnumContactListIconMode
    {
      public:
      enum type { IconPic, IconPhoto, COUNT };
    };
    class EnumContactListResizeAnchor
    {
      public:
      enum type { Top, Bottom, COUNT };
    };

    static AppearanceSettings *self();
    ~AppearanceSettings() override;

    /**
      Set Enable emoticon support in Kopete.
    */
    static
    void setUseEmoticons( bool v )
    {
      if (v != self()->mUseEmoticons && !self()->isUseEmoticonsImmutable()) {
        self()->mUseEmoticons = v;
        self()->mSettingsChanged.insert(signalContactListAppearanceChanged);
        self()->mSettingsChanged.insert(signalMessageOverridesChanged);
      }
    }

    /**
      Get Enable emoticon support in Kopete.
    */
    static
    bool useEmoticons()
    {
      return self()->mUseEmoticons;
    }

    /**
      Is Enable emoticon support in Kopete. Immutable
    */
    static
    bool isUseEmoticonsImmutable()
    {
      return self()->isImmutable( QStringLiteral( "useEmoticons" ) );
    }

    /**
      Set Text color used when highlighting.
    */
    static
    void setHighlightForegroundColor( const QColor & v )
    {
      if (v != self()->mHighlightForegroundColor && !self()->isHighlightForegroundColorImmutable()) {
        self()->mHighlightForegroundColor = v;
        self()->mSettingsChanged.insert(signalAppearanceChanged);
      }
    }

    /**
      Get Text color used when highlighting.
    */
    static
    QColor highlightForegroundColor()
    {
      return self()->mHighlightForegroundColor;
    }

    /**
      Is Text color used when highlighting. Immutable
    */
    static
    bool isHighlightForegroundColorImmutable()
    {
      return self()->isImmutable( QStringLiteral( "highlightForegroundColor" ) );
    }

    /**
      Set Background color used when highlighting.
    */
    static
    void setHighlightBackgroundColor( const QColor & v )
    {
      if (v != self()->mHighlightBackgroundColor && !self()->isHighlightBackgroundColorImmutable()) {
        self()->mHighlightBackgroundColor = v;
        self()->mSettingsChanged.insert(signalAppearanceChanged);
      }
    }

    /**
      Get Background color used when highlighting.
    */
    static
    QColor highlightBackgroundColor()
    {
      return self()->mHighlightBackgroundColor;
    }

    /**
      Is Background color used when highlighting. Immutable
    */
    static
    bool isHighlightBackgroundColorImmutable()
    {
      return self()->isImmutable( QStringLiteral( "highlightBackgroundColor" ) );
    }

    /**
      Set Disable custom formatting set by users.
    */
    static
    void setChatFmtOverride( bool v )
    {
      if (v != self()->mChatFmtOverride && !self()->isChatFmtOverrideImmutable()) {
        self()->mChatFmtOverride = v;
        self()->mSettingsChanged.insert(signalMessageOverridesChanged);
      }
    }

    /**
      Get Disable custom formatting set by users.
    */
    static
    bool chatFmtOverride()
    {
      return self()->mChatFmtOverride;
    }

    /**
      Is Disable custom formatting set by users. Immutable
    */
    static
    bool isChatFmtOverrideImmutable()
    {
      return self()->isImmutable( QStringLiteral( "chatFmtOverride" ) );
    }

    /**
      Set Chat text color.
    */
    static
    void setChatTextColor( const QColor & v )
    {
      if (v != self()->mChatTextColor && !self()->isChatTextColorImmutable()) {
        self()->mChatTextColor = v;
        self()->mSettingsChanged.insert(signalAppearanceChanged);
      }
    }

    /**
      Get Chat text color.
    */
    static
    QColor chatTextColor()
    {
      return self()->mChatTextColor;
    }

    /**
      Is Chat text color. Immutable
    */
    static
    bool isChatTextColorImmutable()
    {
      return self()->isImmutable( QStringLiteral( "chatTextColor" ) );
    }

    /**
      Set Chat background color.
    */
    static
    void setChatBackgroundColor( const QColor & v )
    {
      if (v != self()->mChatBackgroundColor && !self()->isChatBackgroundColorImmutable()) {
        self()->mChatBackgroundColor = v;
        self()->mSettingsChanged.insert(signalAppearanceChanged);
      }
    }

    /**
      Get Chat background color.
    */
    static
    QColor chatBackgroundColor()
    {
      return self()->mChatBackgroundColor;
    }

    /**
      Is Chat background color. Immutable
    */
    static
    bool isChatBackgroundColorImmutable()
    {
      return self()->isImmutable( QStringLiteral( "chatBackgroundColor" ) );
    }

    /**
      Set Chat link color.
    */
    static
    void setChatLinkColor( const QColor & v )
    {
      if (v != self()->mChatLinkColor && !self()->isChatLinkColorImmutable()) {
        self()->mChatLinkColor = v;
        self()->mSettingsChanged.insert(signalAppearanceChanged);
      }
    }

    /**
      Get Chat link color.
    */
    static
    QColor chatLinkColor()
    {
      return self()->mChatLinkColor;
    }

    /**
      Is Chat link color. Immutable
    */
    static
    bool isChatLinkColorImmutable()
    {
      return self()->isImmutable( QStringLiteral( "chatLinkColor" ) );
    }

    /**
      Set Whether using the system font for the chat window.
    */
    static
    void setChatFontSelection( int v )
    {
      if (v != self()->mChatFontSelection && !self()->isChatFontSelectionImmutable()) {
        self()->mChatFontSelection = v;
        self()->mSettingsChanged.insert(signalAppearanceChanged);
      }
    }

    /**
      Get Whether using the system font for the chat window.
    */
    static
    int chatFontSelection()
    {
      return self()->mChatFontSelection;
    }

    /**
      Is Whether using the system font for the chat window. Immutable
    */
    static
    bool isChatFontSelectionImmutable()
    {
      return self()->isImmutable( QStringLiteral( "chatFontSelection" ) );
    }

    /**
      Set Chat font.
    */
    static
    void setChatFont( const QFont & v )
    {
      if (v != self()->mChatFont && !self()->isChatFontImmutable()) {
        self()->mChatFont = v;
        self()->mSettingsChanged.insert(signalAppearanceChanged);
      }
    }

    /**
      Get Chat font.
    */
    static
    QFont chatFont()
    {
      return self()->mChatFont;
    }

    /**
      Is Chat font. Immutable
    */
    static
    bool isChatFontImmutable()
    {
      return self()->isImmutable( QStringLiteral( "chatFont" ) );
    }

    /**
      Set Color used to identify idle contacts.
    */
    static
    void setIdleContactColor( const QColor & v )
    {
      if (v != self()->mIdleContactColor && !self()->isIdleContactColorImmutable()) {
        self()->mIdleContactColor = v;
        self()->mSettingsChanged.insert(signalContactListAppearanceChanged);
      }
    }

    /**
      Get Color used to identify idle contacts.
    */
    static
    QColor idleContactColor()
    {
      return self()->mIdleContactColor;
    }

    /**
      Is Color used to identify idle contacts. Immutable
    */
    static
    bool isIdleContactColorImmutable()
    {
      return self()->isImmutable( QStringLiteral( "idleContactColor" ) );
    }

    /**
      Set Whether to use a different color for idle contacts.
    */
    static
    void setGreyIdleMetaContacts( bool v )
    {
      if (v != self()->mGreyIdleMetaContacts && !self()->isGreyIdleMetaContactsImmutable()) {
        self()->mGreyIdleMetaContacts = v;
        self()->mSettingsChanged.insert(signalContactListAppearanceChanged);
      }
    }

    /**
      Get Whether to use a different color for idle contacts.
    */
    static
    bool greyIdleMetaContacts()
    {
      return self()->mGreyIdleMetaContacts;
    }

    /**
      Is Whether to use a different color for idle contacts. Immutable
    */
    static
    bool isGreyIdleMetaContactsImmutable()
    {
      return self()->isImmutable( QStringLiteral( "greyIdleMetaContacts" ) );
    }

    /**
      Set Contact properties that contact tooltip will show.
    */
    static
    void setToolTipContents( const QStringList & v )
    {
      if (!self()->isToolTipContentsImmutable())
        self()->mToolTipContents = v;
    }

    /**
      Get Contact properties that contact tooltip will show.
    */
    static
    QStringList toolTipContents()
    {
      return self()->mToolTipContents;
    }

    /**
      Is Contact properties that contact tooltip will show. Immutable
    */
    static
    bool isToolTipContentsImmutable()
    {
      return self()->isImmutable( QStringLiteral( "toolTipContents" ) );
    }

    /**
      Set Contact list group sorting
    */
    static
    void setContactListGroupSorting( int v )
    {
      if (v != self()->mContactListGroupSorting && !self()->isContactListGroupSortingImmutable()) {
        self()->mContactListGroupSorting = v;
        self()->mSettingsChanged.insert(signalContactListAppearanceChanged);
      }
    }

    /**
      Get Contact list group sorting
    */
    static
    int contactListGroupSorting()
    {
      return self()->mContactListGroupSorting;
    }

    /**
      Is Contact list group sorting Immutable
    */
    static
    bool isContactListGroupSortingImmutable()
    {
      return self()->isImmutable( QStringLiteral( "contactListGroupSorting" ) );
    }

    /**
      Set Contact list group sorting
    */
    static
    void setContactListMetaContactSorting( int v )
    {
      if (v != self()->mContactListMetaContactSorting && !self()->isContactListMetaContactSortingImmutable()) {
        self()->mContactListMetaContactSorting = v;
        self()->mSettingsChanged.insert(signalContactListAppearanceChanged);
      }
    }

    /**
      Get Contact list group sorting
    */
    static
    int contactListMetaContactSorting()
    {
      return self()->mContactListMetaContactSorting;
    }

    /**
      Is Contact list group sorting Immutable
    */
    static
    bool isContactListMetaContactSortingImmutable()
    {
      return self()->isImmutable( QStringLiteral( "contactListMetaContactSorting" ) );
    }

    /**
      Set Contact list icon display mode. Either the protocol icon or the contact photo.
    */
    static
    void setContactListIconMode( int v )
    {
      if (v != self()->mContactListIconMode && !self()->isContactListIconModeImmutable()) {
        self()->mContactListIconMode = v;
        self()->mSettingsChanged.insert(signalContactListAppearanceChanged);
      }
    }

    /**
      Get Contact list icon display mode. Either the protocol icon or the contact photo.
    */
    static
    int contactListIconMode()
    {
      return self()->mContactListIconMode;
    }

    /**
      Is Contact list icon display mode. Either the protocol icon or the contact photo. Immutable
    */
    static
    bool isContactListIconModeImmutable()
    {
      return self()->isImmutable( QStringLiteral( "contactListIconMode" ) );
    }

    /**
      Set Enable borders on the contact's photo.
    */
    static
    void setContactListIconBorders( bool v )
    {
      if (v != self()->mContactListIconBorders && !self()->isContactListIconBordersImmutable()) {
        self()->mContactListIconBorders = v;
        self()->mSettingsChanged.insert(signalContactListAppearanceChanged);
      }
    }

    /**
      Get Enable borders on the contact's photo.
    */
    static
    bool contactListIconBorders()
    {
      return self()->mContactListIconBorders;
    }

    /**
      Is Enable borders on the contact's photo. Immutable
    */
    static
    bool isContactListIconBordersImmutable()
    {
      return self()->isImmutable( QStringLiteral( "contactListIconBorders" ) );
    }

    /**
      Set Round contact photo corners.
    */
    static
    void setContactListIconRounded( bool v )
    {
      if (v != self()->mContactListIconRounded && !self()->isContactListIconRoundedImmutable()) {
        self()->mContactListIconRounded = v;
        self()->mSettingsChanged.insert(signalContactListAppearanceChanged);
      }
    }

    /**
      Get Round contact photo corners.
    */
    static
    bool contactListIconRounded()
    {
      return self()->mContactListIconRounded;
    }

    /**
      Is Round contact photo corners. Immutable
    */
    static
    bool isContactListIconRoundedImmutable()
    {
      return self()->isImmutable( QStringLiteral( "contactListIconRounded" ) );
    }

    /**
      Set Show contact list as a tree view.
    */
    static
    void setContactListTreeView( bool v )
    {
      if (v != self()->mContactListTreeView && !self()->isContactListTreeViewImmutable()) {
        self()->mContactListTreeView = v;
        self()->mSettingsChanged.insert(signalContactListAppearanceChanged);
      }
    }

    /**
      Get Show contact list as a tree view.
    */
    static
    bool contactListTreeView()
    {
      return self()->mContactListTreeView;
    }

    /**
      Is Show contact list as a tree view. Immutable
    */
    static
    bool isContactListTreeViewImmutable()
    {
      return self()->isImmutable( QStringLiteral( "contactListTreeView" ) );
    }

    /**
      Set Indent contacts if you do not show tree lines.
    */
    static
    void setContactListIndentContact( bool v )
    {
      if (v != self()->mContactListIndentContact && !self()->isContactListIndentContactImmutable()) {
        self()->mContactListIndentContact = v;
        self()->mSettingsChanged.insert(signalContactListAppearanceChanged);
      }
    }

    /**
      Get Indent contacts if you do not show tree lines.
    */
    static
    bool contactListIndentContact()
    {
      return self()->mContactListIndentContact;
    }

    /**
      Is Indent contacts if you do not show tree lines. Immutable
    */
    static
    bool isContactListIndentContactImmutable()
    {
      return self()->isImmutable( QStringLiteral( "contactListIndentContact" ) );
    }

    /**
      Set Hide the vertical scroll bar.
    */
    static
    void setContactListHideVerticalScrollBar( bool v )
    {
      if (v != self()->mContactListHideVerticalScrollBar && !self()->isContactListHideVerticalScrollBarImmutable()) {
        self()->mContactListHideVerticalScrollBar = v;
        self()->mSettingsChanged.insert(signalContactListAppearanceChanged);
      }
    }

    /**
      Get Hide the vertical scroll bar.
    */
    static
    bool contactListHideVerticalScrollBar()
    {
      return self()->mContactListHideVerticalScrollBar;
    }

    /**
      Is Hide the vertical scroll bar. Immutable
    */
    static
    bool isContactListHideVerticalScrollBarImmutable()
    {
      return self()->isImmutable( QStringLiteral( "contactListHideVerticalScrollBar" ) );
    }

    /**
      Set Group contacts by group.
    */
    static
    void setGroupContactByGroup( bool v )
    {
      if (v != self()->mGroupContactByGroup && !self()->isGroupContactByGroupImmutable()) {
        self()->mGroupContactByGroup = v;
        self()->mSettingsChanged.insert(signalContactListAppearanceChanged);
      }
    }

    /**
      Get Group contacts by group.
    */
    static
    bool groupContactByGroup()
    {
      return self()->mGroupContactByGroup;
    }

    /**
      Is Group contacts by group. Immutable
    */
    static
    bool isGroupContactByGroupImmutable()
    {
      return self()->isImmutable( QStringLiteral( "groupContactByGroup" ) );
    }

    /**
      Set Use custom fonts for contact list.
    */
    static
    void setContactListUseCustomFont( bool v )
    {
      if (v != self()->mContactListUseCustomFont && !self()->isContactListUseCustomFontImmutable()) {
        self()->mContactListUseCustomFont = v;
        self()->mSettingsChanged.insert(signalContactListAppearanceChanged);
      }
    }

    /**
      Get Use custom fonts for contact list.
    */
    static
    bool contactListUseCustomFont()
    {
      return self()->mContactListUseCustomFont;
    }

    /**
      Is Use custom fonts for contact list. Immutable
    */
    static
    bool isContactListUseCustomFontImmutable()
    {
      return self()->isImmutable( QStringLiteral( "contactListUseCustomFont" ) );
    }

    /**
      Set Automatically resize the main window.
    */
    static
    void setContactListAutoResize( bool v )
    {
      if (v != self()->mContactListAutoResize && !self()->isContactListAutoResizeImmutable()) {
        self()->mContactListAutoResize = v;
        self()->mSettingsChanged.insert(signalContactListAppearanceChanged);
      }
    }

    /**
      Get Automatically resize the main window.
    */
    static
    bool contactListAutoResize()
    {
      return self()->mContactListAutoResize;
    }

    /**
      Is Automatically resize the main window. Immutable
    */
    static
    bool isContactListAutoResizeImmutable()
    {
      return self()->isImmutable( QStringLiteral( "contactListAutoResize" ) );
    }

    /**
      Set Corner at which to anchor main window when auto-resizing.
    */
    static
    void setContactListResizeAnchor( int v )
    {
      if (v != self()->mContactListResizeAnchor && !self()->isContactListResizeAnchorImmutable()) {
        self()->mContactListResizeAnchor = v;
        self()->mSettingsChanged.insert(signalContactListAppearanceChanged);
      }
    }

    /**
      Get Corner at which to anchor main window when auto-resizing.
    */
    static
    int contactListResizeAnchor()
    {
      return self()->mContactListResizeAnchor;
    }

    /**
      Is Corner at which to anchor main window when auto-resizing. Immutable
    */
    static
    bool isContactListResizeAnchorImmutable()
    {
      return self()->isImmutable( QStringLiteral( "contactListResizeAnchor" ) );
    }

    /**
      Set Normal font for contact list
    */
    static
    void setContactListNormalFont( const QFont & v )
    {
      if (v != self()->mContactListNormalFont && !self()->isContactListNormalFontImmutable()) {
        self()->mContactListNormalFont = v;
        self()->mSettingsChanged.insert(signalContactListAppearanceChanged);
      }
    }

    /**
      Get Normal font for contact list
    */
    static
    QFont contactListNormalFont()
    {
      return self()->mContactListNormalFont;
    }

    /**
      Is Normal font for contact list Immutable
    */
    static
    bool isContactListNormalFontImmutable()
    {
      return self()->isImmutable( QStringLiteral( "contactListNormalFont" ) );
    }

    /**
      Set Small font for contact list (for status message)
    */
    static
    void setContactListSmallFont( const QFont & v )
    {
      if (v != self()->mContactListSmallFont && !self()->isContactListSmallFontImmutable()) {
        self()->mContactListSmallFont = v;
        self()->mSettingsChanged.insert(signalContactListAppearanceChanged);
      }
    }

    /**
      Get Small font for contact list (for status message)
    */
    static
    QFont contactListSmallFont()
    {
      return self()->mContactListSmallFont;
    }

    /**
      Is Small font for contact list (for status message) Immutable
    */
    static
    bool isContactListSmallFontImmutable()
    {
      return self()->isImmutable( QStringLiteral( "contactListSmallFont" ) );
    }

    /**
      Set Color for group name.
    */
    static
    void setGroupNameColor( const QColor & v )
    {
      if (v != self()->mGroupNameColor && !self()->isGroupNameColorImmutable()) {
        self()->mGroupNameColor = v;
        self()->mSettingsChanged.insert(signalContactListAppearanceChanged);
      }
    }

    /**
      Get Color for group name.
    */
    static
    QColor groupNameColor()
    {
      return self()->mGroupNameColor;
    }

    /**
      Is Color for group name. Immutable
    */
    static
    bool isGroupNameColorImmutable()
    {
      return self()->isImmutable( QStringLiteral( "groupNameColor" ) );
    }

    /**
      Set Animate contact list on contact list changes.
    */
    static
    void setContactListAnimateChange( bool v )
    {
      if (v != self()->mContactListAnimateChange && !self()->isContactListAnimateChangeImmutable()) {
        self()->mContactListAnimateChange = v;
        self()->mSettingsChanged.insert(signalContactListAppearanceChanged);
      }
    }

    /**
      Get Animate contact list on contact list changes.
    */
    static
    bool contactListAnimateChange()
    {
      return self()->mContactListAnimateChange;
    }

    /**
      Is Animate contact list on contact list changes. Immutable
    */
    static
    bool isContactListAnimateChangeImmutable()
    {
      return self()->isImmutable( QStringLiteral( "contactListAnimateChange" ) );
    }

    /**
      Set Fade-in/Fade-out on contact status changes.
    */
    static
    void setContactListFading( bool v )
    {
      if (v != self()->mContactListFading && !self()->isContactListFadingImmutable()) {
        self()->mContactListFading = v;
        self()->mSettingsChanged.insert(signalContactListAppearanceChanged);
      }
    }

    /**
      Get Fade-in/Fade-out on contact status changes.
    */
    static
    bool contactListFading()
    {
      return self()->mContactListFading;
    }

    /**
      Is Fade-in/Fade-out on contact status changes. Immutable
    */
    static
    bool isContactListFadingImmutable()
    {
      return self()->isImmutable( QStringLiteral( "contactListFading" ) );
    }

    /**
      Set Fold-in/Fold-out on contact status changes.
    */
    static
    void setContactListFolding( bool v )
    {
      if (v != self()->mContactListFolding && !self()->isContactListFoldingImmutable()) {
        self()->mContactListFolding = v;
        self()->mSettingsChanged.insert(signalContactListAppearanceChanged);
      }
    }

    /**
      Get Fold-in/Fold-out on contact status changes.
    */
    static
    bool contactListFolding()
    {
      return self()->mContactListFolding;
    }

    /**
      Is Fold-in/Fold-out on contact status changes. Immutable
    */
    static
    bool isContactListFoldingImmutable()
    {
      return self()->isImmutable( QStringLiteral( "contactListFolding" ) );
    }

    /**
      Set Auto-hide contact list after a while.
    */
    static
    void setContactListAutoHide( bool v )
    {
      if (v != self()->mContactListAutoHide && !self()->isContactListAutoHideImmutable()) {
        self()->mContactListAutoHide = v;
        self()->mSettingsChanged.insert(signalContactListAppearanceChanged);
      }
    }

    /**
      Get Auto-hide contact list after a while.
    */
    static
    bool contactListAutoHide()
    {
      return self()->mContactListAutoHide;
    }

    /**
      Is Auto-hide contact list after a while. Immutable
    */
    static
    bool isContactListAutoHideImmutable()
    {
      return self()->isImmutable( QStringLiteral( "contactListAutoHide" ) );
    }

    /**
      Set Auto-hide vertical scrollbar in contact list after a while.
    */
    static
    void setContactListAutoHideVScroll( bool v )
    {
      if (v != self()->mContactListAutoHideVScroll && !self()->isContactListAutoHideVScrollImmutable()) {
        self()->mContactListAutoHideVScroll = v;
        self()->mSettingsChanged.insert(signalContactListAppearanceChanged);
      }
    }

    /**
      Get Auto-hide vertical scrollbar in contact list after a while.
    */
    static
    bool contactListAutoHideVScroll()
    {
      return self()->mContactListAutoHideVScroll;
    }

    /**
      Is Auto-hide vertical scrollbar in contact list after a while. Immutable
    */
    static
    bool isContactListAutoHideVScrollImmutable()
    {
      return self()->isImmutable( QStringLiteral( "contactListAutoHideVScroll" ) );
    }

    /**
      Set Auto-hide timeout
    */
    static
    void setContactListAutoHideTimeout( uint v )
    {
      if (v != self()->mContactListAutoHideTimeout && !self()->isContactListAutoHideTimeoutImmutable()) {
        self()->mContactListAutoHideTimeout = v;
        self()->mSettingsChanged.insert(signalContactListAppearanceChanged);
      }
    }

    /**
      Get Auto-hide timeout
    */
    static
    uint contactListAutoHideTimeout()
    {
      return self()->mContactListAutoHideTimeout;
    }

    /**
      Is Auto-hide timeout Immutable
    */
    static
    bool isContactListAutoHideTimeoutImmutable()
    {
      return self()->isImmutable( QStringLiteral( "contactListAutoHideTimeout" ) );
    }

    /**
      Set Show offline users in contact list.
    */
    static
    void setShowOfflineUsers( bool v )
    {
      if (v != self()->mShowOfflineUsers && !self()->isShowOfflineUsersImmutable()) {
        self()->mShowOfflineUsers = v;
        self()->mSettingsChanged.insert(signalContactListAppearanceChanged);
      }
    }

    /**
      Get Show offline users in contact list.
    */
    static
    bool showOfflineUsers()
    {
      return self()->mShowOfflineUsers;
    }

    /**
      Is Show offline users in contact list. Immutable
    */
    static
    bool isShowOfflineUsersImmutable()
    {
      return self()->isImmutable( QStringLiteral( "showOfflineUsers" ) );
    }

    /**
      Set Show empty groups in contact list.
    */
    static
    void setShowEmptyGroups( bool v )
    {
      if (v != self()->mShowEmptyGroups && !self()->isShowEmptyGroupsImmutable()) {
        self()->mShowEmptyGroups = v;
        self()->mSettingsChanged.insert(signalContactListAppearanceChanged);
      }
    }

    /**
      Get Show empty groups in contact list.
    */
    static
    bool showEmptyGroups()
    {
      return self()->mShowEmptyGroups;
    }

    /**
      Is Show empty groups in contact list. Immutable
    */
    static
    bool isShowEmptyGroupsImmutable()
    {
      return self()->isImmutable( QStringLiteral( "showEmptyGroups" ) );
    }

    /**
      Set Show identities in status bar instead of accounts.
    */
    static
    void setShowIdentityIcons( bool v )
    {
      if (!self()->isShowIdentityIconsImmutable())
        self()->mShowIdentityIcons = v;
    }

    /**
      Get Show identities in status bar instead of accounts.
    */
    static
    bool showIdentityIcons()
    {
      return self()->mShowIdentityIcons;
    }

    /**
      Is Show identities in status bar instead of accounts. Immutable
    */
    static
    bool isShowIdentityIconsImmutable()
    {
      return self()->isImmutable( QStringLiteral( "showIdentityIcons" ) );
    }

    /**
      Set Show offline users in a separate group.
    */
    static
    void setShowOfflineGrouped( bool v )
    {
      if (v != self()->mShowOfflineGrouped && !self()->isShowOfflineGroupedImmutable()) {
        self()->mShowOfflineGrouped = v;
        self()->mSettingsChanged.insert(signalContactListAppearanceChanged);
      }
    }

    /**
      Get Show offline users in a separate group.
    */
    static
    bool showOfflineGrouped()
    {
      return self()->mShowOfflineGrouped;
    }

    /**
      Is Show offline users in a separate group. Immutable
    */
    static
    bool isShowOfflineGroupedImmutable()
    {
      return self()->isImmutable( QStringLiteral( "showOfflineGrouped" ) );
    }


    enum {
      signalAppearanceChanged = 1,
      signalMessageOverridesChanged = 2,
      signalContactListAppearanceChanged = 3
    };

  Q_SIGNALS:
    /**
      Emitted when the font and colors settings have changed.
    */
    void appearanceChanged();

    /**
      Emitted when the message overrides settings have changed.
    */
    void messageOverridesChanged();

    /**
      Emitted when the contact list appearance has changed.
    */
    void contactListAppearanceChanged();

  private:
    void itemChanged(quint64 signalFlag);

  protected:
    AppearanceSettings();
    friend class AppearanceSettingsHelper;

    bool usrSave() override;

    // Appearance
    bool mUseEmoticons;
    QColor mHighlightForegroundColor;
    QColor mHighlightBackgroundColor;
    bool mChatFmtOverride;
    QColor mChatTextColor;
    QColor mChatBackgroundColor;
    QColor mChatLinkColor;
    int mChatFontSelection;
    QFont mChatFont;
    QColor mIdleContactColor;
    bool mGreyIdleMetaContacts;
    QStringList mToolTipContents;

    // ContactList
    int mContactListGroupSorting;
    int mContactListMetaContactSorting;
    int mContactListIconMode;
    bool mContactListIconBorders;
    bool mContactListIconRounded;
    bool mContactListTreeView;
    bool mContactListIndentContact;
    bool mContactListHideVerticalScrollBar;
    bool mGroupContactByGroup;
    bool mContactListUseCustomFont;
    bool mContactListAutoResize;
    int mContactListResizeAnchor;
    QFont mContactListNormalFont;
    QFont mContactListSmallFont;
    QColor mGroupNameColor;
    bool mContactListAnimateChange;
    bool mContactListFading;
    bool mContactListFolding;
    bool mContactListAutoHide;
    bool mContactListAutoHideVScroll;
    uint mContactListAutoHideTimeout;
    bool mShowOfflineUsers;
    bool mShowEmptyGroups;
    bool mShowIdentityIcons;
    bool mShowOfflineGrouped;

  private:
    QSet<quint64> mSettingsChanged;
};

}

#endif

