
use builtin;
use str;

set edit:completion:arg-completer[jj] = {|@words|
    fn spaces {|n|
        builtin:repeat $n ' ' | str:join ''
    }
    fn cand {|text desc|
        edit:complex-candidate $text &display=$text' '(spaces (- 14 (wcswidth $text)))$desc
    }
    var command = 'jj'
    for word $words[1..-1] {
        if (str:has-prefix $word '-') {
            break
        }
        set command = $command';'$word
    }
    var completions = [
        &'jj'= {
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output'
            cand --config 'Additional configuration options (can be repeated)'
            cand --config-toml 'Additional configuration options (can be repeated) (DEPRECATED)'
            cand --config-file 'Additional configuration files (can be repeated)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
            cand -V 'Print version'
            cand --version 'Print version'
            cand abandon 'Abandon a revision'
            cand absorb 'Move changes from a revision into the stack of mutable revisions'
            cand backout 'Apply the reverse of given revisions on top of another revision'
            cand bench 'Commands for benchmarking internal operations'
            cand bookmark 'Manage bookmarks [default alias: b]'
            cand commit 'Update the description and create a new change on top'
            cand config 'Manage config options'
            cand debug 'Low-level commands not intended for users'
            cand describe 'Update the change description or other metadata'
            cand desc 'Update the change description or other metadata'
            cand diff 'Compare file contents between two revisions'
            cand diffedit 'Touch up the content changes in a revision with a diff editor'
            cand duplicate 'Create new changes with the same content as existing ones'
            cand edit 'Sets the specified revision as the working-copy revision'
            cand evolog 'Show how a change has evolved over time'
            cand evolution-log 'Show how a change has evolved over time'
            cand file 'File operations'
            cand fix 'Update files with formatting fixes or other changes'
            cand git 'Commands for working with Git remotes and the underlying Git repo'
            cand help 'Print this message or the help of the given subcommand(s)'
            cand interdiff 'Compare the changes of two commits'
            cand log 'Show revision history'
            cand new 'Create a new, empty change and (by default) edit it in the working copy'
            cand next 'Move the working-copy commit to the child revision'
            cand operation 'Commands for working with the operation log'
            cand op 'Commands for working with the operation log'
            cand parallelize 'Parallelize revisions by making them siblings'
            cand prev 'Change the working copy revision relative to the parent revision'
            cand rebase 'Move revisions to different parent(s)'
            cand resolve 'Resolve conflicted files with an external merge tool'
            cand restore 'Restore paths from another revision'
            cand revert 'Apply the reverse of the given revision(s)'
            cand root 'Show the current workspace root directory (shortcut for `jj workspace root`)'
            cand run '(**Stub**, does not work yet) Run a command across a set of revisions.'
            cand show 'Show commit description and changes in a revision'
            cand sign 'Cryptographically sign a revision'
            cand simplify-parents 'Simplify parent edges for the specified revision(s)'
            cand sparse 'Manage which paths from the working-copy commit are present in the working copy'
            cand split 'Split a revision in two'
            cand squash 'Move changes from a revision into another revision'
            cand status 'Show high-level repo status'
            cand st 'Show high-level repo status'
            cand tag 'Manage tags'
            cand undo 'Undo an operation (shortcut for `jj op undo`)'
            cand unsign 'Drop a cryptographic signature'
            cand util 'Infrequently used commands such as for generating shell completions'
            cand version 'Display version information'
            cand workspace 'Commands for working with workspaces'
        }
        &'jj;abandon'= {
            cand -r 'r'
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output'
            cand --config 'Additional configuration options (can be repeated)'
            cand --config-toml 'Additional configuration options (can be repeated) (DEPRECATED)'
            cand --config-file 'Additional configuration files (can be repeated)'
            cand -s 's'
            cand --summary 'summary'
            cand --retain-bookmarks 'Do not delete bookmarks pointing to the revisions to abandon'
            cand --restore-descendants 'Do not modify the content of the children of the abandoned commits'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;absorb'= {
            cand -f 'Source revision to absorb from'
            cand --from 'Source revision to absorb from'
            cand -t 'Destination revisions to absorb into'
            cand --into 'Destination revisions to absorb into'
            cand --to 'Destination revisions to absorb into'
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output'
            cand --config 'Additional configuration options (can be repeated)'
            cand --config-toml 'Additional configuration options (can be repeated) (DEPRECATED)'
            cand --config-file 'Additional configuration files (can be repeated)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;backout'= {
            cand -r 'The revision(s) to apply the reverse of'
            cand --revisions 'The revision(s) to apply the reverse of'
            cand -d 'The revision to apply the reverse changes on top of'
            cand --destination 'The revision to apply the reverse changes on top of'
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output'
            cand --config 'Additional configuration options (can be repeated)'
            cand --config-toml 'Additional configuration options (can be repeated) (DEPRECATED)'
            cand --config-file 'Additional configuration files (can be repeated)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;bench'= {
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output'
            cand --config 'Additional configuration options (can be repeated)'
            cand --config-toml 'Additional configuration options (can be repeated) (DEPRECATED)'
            cand --config-file 'Additional configuration files (can be repeated)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
            cand common-ancestors 'Find the common ancestor(s) of a set of commits'
            cand is-ancestor 'Checks if the first commit is an ancestor of the second commit'
            cand resolve-prefix 'Resolve a commit ID prefix'
            cand revset 'Walk the revisions in the revset'
        }
        &'jj;bench;common-ancestors'= {
            cand -s 'Name of baseline to save results'
            cand --save-baseline 'Name of baseline to save results'
            cand -b 'Name of baseline to compare with'
            cand --baseline 'Name of baseline to compare with'
            cand --sample-size 'Sample size for the benchmarks, which must be at least 10'
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output'
            cand --config 'Additional configuration options (can be repeated)'
            cand --config-toml 'Additional configuration options (can be repeated) (DEPRECATED)'
            cand --config-file 'Additional configuration files (can be repeated)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;bench;is-ancestor'= {
            cand -s 'Name of baseline to save results'
            cand --save-baseline 'Name of baseline to save results'
            cand -b 'Name of baseline to compare with'
            cand --baseline 'Name of baseline to compare with'
            cand --sample-size 'Sample size for the benchmarks, which must be at least 10'
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output'
            cand --config 'Additional configuration options (can be repeated)'
            cand --config-toml 'Additional configuration options (can be repeated) (DEPRECATED)'
            cand --config-file 'Additional configuration files (can be repeated)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;bench;resolve-prefix'= {
            cand -s 'Name of baseline to save results'
            cand --save-baseline 'Name of baseline to save results'
            cand -b 'Name of baseline to compare with'
            cand --baseline 'Name of baseline to compare with'
            cand --sample-size 'Sample size for the benchmarks, which must be at least 10'
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output'
            cand --config 'Additional configuration options (can be repeated)'
            cand --config-toml 'Additional configuration options (can be repeated) (DEPRECATED)'
            cand --config-file 'Additional configuration files (can be repeated)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;bench;revset'= {
            cand -f 'Read revsets from file'
            cand --file 'Read revsets from file'
            cand -s 'Name of baseline to save results'
            cand --save-baseline 'Name of baseline to save results'
            cand -b 'Name of baseline to compare with'
            cand --baseline 'Name of baseline to compare with'
            cand --sample-size 'Sample size for the benchmarks, which must be at least 10'
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output'
            cand --config 'Additional configuration options (can be repeated)'
            cand --config-toml 'Additional configuration options (can be repeated) (DEPRECATED)'
            cand --config-file 'Additional configuration files (can be repeated)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;bookmark'= {
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output'
            cand --config 'Additional configuration options (can be repeated)'
            cand --config-toml 'Additional configuration options (can be repeated) (DEPRECATED)'
            cand --config-file 'Additional configuration files (can be repeated)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
            cand create 'Create a new bookmark'
            cand c 'Create a new bookmark'
            cand delete 'Delete an existing bookmark and propagate the deletion to remotes on the next push'
            cand d 'Delete an existing bookmark and propagate the deletion to remotes on the next push'
            cand forget 'Forget a bookmark without marking it as a deletion to be pushed'
            cand f 'Forget a bookmark without marking it as a deletion to be pushed'
            cand list 'List bookmarks and their targets'
            cand l 'List bookmarks and their targets'
            cand move 'Move existing bookmarks to target revision'
            cand m 'Move existing bookmarks to target revision'
            cand rename 'Rename `old` bookmark name to `new` bookmark name'
            cand r 'Rename `old` bookmark name to `new` bookmark name'
            cand set 'Create or update a bookmark to point to a certain commit'
            cand s 'Create or update a bookmark to point to a certain commit'
            cand track 'Start tracking given remote bookmarks'
            cand t 'Start tracking given remote bookmarks'
            cand untrack 'Stop tracking given remote bookmarks'
        }
        &'jj;bookmark;create'= {
            cand -r 'The bookmark''s target revision'
            cand --revision 'The bookmark''s target revision'
            cand --to 'The bookmark''s target revision'
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output'
            cand --config 'Additional configuration options (can be repeated)'
            cand --config-toml 'Additional configuration options (can be repeated) (DEPRECATED)'
            cand --config-file 'Additional configuration files (can be repeated)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;bookmark;c'= {
            cand -r 'The bookmark''s target revision'
            cand --revision 'The bookmark''s target revision'
            cand --to 'The bookmark''s target revision'
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output'
            cand --config 'Additional configuration options (can be repeated)'
            cand --config-toml 'Additional configuration options (can be repeated) (DEPRECATED)'
            cand --config-file 'Additional configuration files (can be repeated)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;bookmark;delete'= {
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output'
            cand --config 'Additional configuration options (can be repeated)'
            cand --config-toml 'Additional configuration options (can be repeated) (DEPRECATED)'
            cand --config-file 'Additional configuration files (can be repeated)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;bookmark;d'= {
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output'
            cand --config 'Additional configuration options (can be repeated)'
            cand --config-toml 'Additional configuration options (can be repeated) (DEPRECATED)'
            cand --config-file 'Additional configuration files (can be repeated)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;bookmark;forget'= {
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output'
            cand --config 'Additional configuration options (can be repeated)'
            cand --config-toml 'Additional configuration options (can be repeated) (DEPRECATED)'
            cand --config-file 'Additional configuration files (can be repeated)'
            cand --include-remotes 'When forgetting a local bookmark, also forget any corresponding remote bookmarks'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;bookmark;f'= {
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output'
            cand --config 'Additional configuration options (can be repeated)'
            cand --config-toml 'Additional configuration options (can be repeated) (DEPRECATED)'
            cand --config-file 'Additional configuration files (can be repeated)'
            cand --include-remotes 'When forgetting a local bookmark, also forget any corresponding remote bookmarks'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;bookmark;list'= {
            cand --remote 'Show all tracking and non-tracking remote bookmarks belonging to this remote'
            cand -r 'Show bookmarks whose local targets are in the given revisions'
            cand --revisions 'Show bookmarks whose local targets are in the given revisions'
            cand -T 'Render each bookmark using the given template'
            cand --template 'Render each bookmark using the given template'
            cand --sort 'Sort bookmarks based on the given key (or multiple keys)'
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output'
            cand --config 'Additional configuration options (can be repeated)'
            cand --config-toml 'Additional configuration options (can be repeated) (DEPRECATED)'
            cand --config-file 'Additional configuration files (can be repeated)'
            cand -a 'Show all tracking and non-tracking remote bookmarks including the ones whose targets are synchronized with the local bookmarks'
            cand --all-remotes 'Show all tracking and non-tracking remote bookmarks including the ones whose targets are synchronized with the local bookmarks'
            cand -t 'Show remote tracked bookmarks only. Omits local Git-tracking bookmarks by default'
            cand --tracked 'Show remote tracked bookmarks only. Omits local Git-tracking bookmarks by default'
            cand -c 'Show conflicted bookmarks only'
            cand --conflicted 'Show conflicted bookmarks only'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;bookmark;l'= {
            cand --remote 'Show all tracking and non-tracking remote bookmarks belonging to this remote'
            cand -r 'Show bookmarks whose local targets are in the given revisions'
            cand --revisions 'Show bookmarks whose local targets are in the given revisions'
            cand -T 'Render each bookmark using the given template'
            cand --template 'Render each bookmark using the given template'
            cand --sort 'Sort bookmarks based on the given key (or multiple keys)'
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output'
            cand --config 'Additional configuration options (can be repeated)'
            cand --config-toml 'Additional configuration options (can be repeated) (DEPRECATED)'
            cand --config-file 'Additional configuration files (can be repeated)'
            cand -a 'Show all tracking and non-tracking remote bookmarks including the ones whose targets are synchronized with the local bookmarks'
            cand --all-remotes 'Show all tracking and non-tracking remote bookmarks including the ones whose targets are synchronized with the local bookmarks'
            cand -t 'Show remote tracked bookmarks only. Omits local Git-tracking bookmarks by default'
            cand --tracked 'Show remote tracked bookmarks only. Omits local Git-tracking bookmarks by default'
            cand -c 'Show conflicted bookmarks only'
            cand --conflicted 'Show conflicted bookmarks only'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;bookmark;move'= {
            cand -f 'Move bookmarks from the given revisions'
            cand --from 'Move bookmarks from the given revisions'
            cand -t 'Move bookmarks to this revision'
            cand --to 'Move bookmarks to this revision'
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output'
            cand --config 'Additional configuration options (can be repeated)'
            cand --config-toml 'Additional configuration options (can be repeated) (DEPRECATED)'
            cand --config-file 'Additional configuration files (can be repeated)'
            cand -B 'Allow moving bookmarks backwards or sideways'
            cand --allow-backwards 'Allow moving bookmarks backwards or sideways'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;bookmark;m'= {
            cand -f 'Move bookmarks from the given revisions'
            cand --from 'Move bookmarks from the given revisions'
            cand -t 'Move bookmarks to this revision'
            cand --to 'Move bookmarks to this revision'
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output'
            cand --config 'Additional configuration options (can be repeated)'
            cand --config-toml 'Additional configuration options (can be repeated) (DEPRECATED)'
            cand --config-file 'Additional configuration files (can be repeated)'
            cand -B 'Allow moving bookmarks backwards or sideways'
            cand --allow-backwards 'Allow moving bookmarks backwards or sideways'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;bookmark;rename'= {
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output'
            cand --config 'Additional configuration options (can be repeated)'
            cand --config-toml 'Additional configuration options (can be repeated) (DEPRECATED)'
            cand --config-file 'Additional configuration files (can be repeated)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;bookmark;r'= {
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output'
            cand --config 'Additional configuration options (can be repeated)'
            cand --config-toml 'Additional configuration options (can be repeated) (DEPRECATED)'
            cand --config-file 'Additional configuration files (can be repeated)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;bookmark;set'= {
            cand -r 'The bookmark''s target revision'
            cand --revision 'The bookmark''s target revision'
            cand --to 'The bookmark''s target revision'
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output'
            cand --config 'Additional configuration options (can be repeated)'
            cand --config-toml 'Additional configuration options (can be repeated) (DEPRECATED)'
            cand --config-file 'Additional configuration files (can be repeated)'
            cand -B 'Allow moving the bookmark backwards or sideways'
            cand --allow-backwards 'Allow moving the bookmark backwards or sideways'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;bookmark;s'= {
            cand -r 'The bookmark''s target revision'
            cand --revision 'The bookmark''s target revision'
            cand --to 'The bookmark''s target revision'
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output'
            cand --config 'Additional configuration options (can be repeated)'
            cand --config-toml 'Additional configuration options (can be repeated) (DEPRECATED)'
            cand --config-file 'Additional configuration files (can be repeated)'
            cand -B 'Allow moving the bookmark backwards or sideways'
            cand --allow-backwards 'Allow moving the bookmark backwards or sideways'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;bookmark;track'= {
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output'
            cand --config 'Additional configuration options (can be repeated)'
            cand --config-toml 'Additional configuration options (can be repeated) (DEPRECATED)'
            cand --config-file 'Additional configuration files (can be repeated)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;bookmark;t'= {
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output'
            cand --config 'Additional configuration options (can be repeated)'
            cand --config-toml 'Additional configuration options (can be repeated) (DEPRECATED)'
            cand --config-file 'Additional configuration files (can be repeated)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;bookmark;untrack'= {
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output'
            cand --config 'Additional configuration options (can be repeated)'
            cand --config-toml 'Additional configuration options (can be repeated) (DEPRECATED)'
            cand --config-file 'Additional configuration files (can be repeated)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;commit'= {
            cand --tool 'Specify diff editor to be used (implies --interactive)'
            cand -m 'The change description to use (don''t open editor)'
            cand --message 'The change description to use (don''t open editor)'
            cand --author 'Set author to the provided string'
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output'
            cand --config 'Additional configuration options (can be repeated)'
            cand --config-toml 'Additional configuration options (can be repeated) (DEPRECATED)'
            cand --config-file 'Additional configuration files (can be repeated)'
            cand -i 'Interactively choose which changes to include in the first commit'
            cand --interactive 'Interactively choose which changes to include in the first commit'
            cand --reset-author 'Reset the author to the configured user'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;config'= {
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output'
            cand --config 'Additional configuration options (can be repeated)'
            cand --config-toml 'Additional configuration options (can be repeated) (DEPRECATED)'
            cand --config-file 'Additional configuration files (can be repeated)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
            cand edit 'Start an editor on a jj config file'
            cand e 'Start an editor on a jj config file'
            cand get 'Get the value of a given config option.'
            cand g 'Get the value of a given config option.'
            cand list 'List variables set in config files, along with their values'
            cand l 'List variables set in config files, along with their values'
            cand path 'Print the paths to the config files'
            cand p 'Print the paths to the config files'
            cand set 'Update a config file to set the given option to a given value'
            cand s 'Update a config file to set the given option to a given value'
            cand unset 'Update a config file to unset the given option'
            cand u 'Update a config file to unset the given option'
        }
        &'jj;config;edit'= {
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output'
            cand --config 'Additional configuration options (can be repeated)'
            cand --config-toml 'Additional configuration options (can be repeated) (DEPRECATED)'
            cand --config-file 'Additional configuration files (can be repeated)'
            cand --user 'Target the user-level config'
            cand --repo 'Target the repo-level config'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;config;e'= {
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output'
            cand --config 'Additional configuration options (can be repeated)'
            cand --config-toml 'Additional configuration options (can be repeated) (DEPRECATED)'
            cand --config-file 'Additional configuration files (can be repeated)'
            cand --user 'Target the user-level config'
            cand --repo 'Target the repo-level config'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;config;get'= {
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output'
            cand --config 'Additional configuration options (can be repeated)'
            cand --config-toml 'Additional configuration options (can be repeated) (DEPRECATED)'
            cand --config-file 'Additional configuration files (can be repeated)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;config;g'= {
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output'
            cand --config 'Additional configuration options (can be repeated)'
            cand --config-toml 'Additional configuration options (can be repeated) (DEPRECATED)'
            cand --config-file 'Additional configuration files (can be repeated)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;config;list'= {
            cand -T 'Render each variable using the given template'
            cand --template 'Render each variable using the given template'
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output'
            cand --config 'Additional configuration options (can be repeated)'
            cand --config-toml 'Additional configuration options (can be repeated) (DEPRECATED)'
            cand --config-file 'Additional configuration files (can be repeated)'
            cand --include-defaults 'Whether to explicitly include built-in default values in the list'
            cand --include-overridden 'Allow printing overridden values'
            cand --user 'Target the user-level config'
            cand --repo 'Target the repo-level config'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;config;l'= {
            cand -T 'Render each variable using the given template'
            cand --template 'Render each variable using the given template'
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output'
            cand --config 'Additional configuration options (can be repeated)'
            cand --config-toml 'Additional configuration options (can be repeated) (DEPRECATED)'
            cand --config-file 'Additional configuration files (can be repeated)'
            cand --include-defaults 'Whether to explicitly include built-in default values in the list'
            cand --include-overridden 'Allow printing overridden values'
            cand --user 'Target the user-level config'
            cand --repo 'Target the repo-level config'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;config;path'= {
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output'
            cand --config 'Additional configuration options (can be repeated)'
            cand --config-toml 'Additional configuration options (can be repeated) (DEPRECATED)'
            cand --config-file 'Additional configuration files (can be repeated)'
            cand --user 'Target the user-level config'
            cand --repo 'Target the repo-level config'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;config;p'= {
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output'
            cand --config 'Additional configuration options (can be repeated)'
            cand --config-toml 'Additional configuration options (can be repeated) (DEPRECATED)'
            cand --config-file 'Additional configuration files (can be repeated)'
            cand --user 'Target the user-level config'
            cand --repo 'Target the repo-level config'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;config;set'= {
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output'
            cand --config 'Additional configuration options (can be repeated)'
            cand --config-toml 'Additional configuration options (can be repeated) (DEPRECATED)'
            cand --config-file 'Additional configuration files (can be repeated)'
            cand --user 'Target the user-level config'
            cand --repo 'Target the repo-level config'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;config;s'= {
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output'
            cand --config 'Additional configuration options (can be repeated)'
            cand --config-toml 'Additional configuration options (can be repeated) (DEPRECATED)'
            cand --config-file 'Additional configuration files (can be repeated)'
            cand --user 'Target the user-level config'
            cand --repo 'Target the repo-level config'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;config;unset'= {
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output'
            cand --config 'Additional configuration options (can be repeated)'
            cand --config-toml 'Additional configuration options (can be repeated) (DEPRECATED)'
            cand --config-file 'Additional configuration files (can be repeated)'
            cand --user 'Target the user-level config'
            cand --repo 'Target the repo-level config'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;config;u'= {
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output'
            cand --config 'Additional configuration options (can be repeated)'
            cand --config-toml 'Additional configuration options (can be repeated) (DEPRECATED)'
            cand --config-file 'Additional configuration files (can be repeated)'
            cand --user 'Target the user-level config'
            cand --repo 'Target the repo-level config'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;debug'= {
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output'
            cand --config 'Additional configuration options (can be repeated)'
            cand --config-toml 'Additional configuration options (can be repeated) (DEPRECATED)'
            cand --config-file 'Additional configuration files (can be repeated)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
            cand copy-detection 'Show information about file copies detected'
            cand fileset 'Parse fileset expression'
            cand index 'Show commit index stats'
            cand init-simple 'Create a new repo in the given directory using the proof-of-concept simple backend'
            cand local-working-copy 'Show information about the local working copy state'
            cand operation 'Show information about an operation and its view'
            cand view 'Show information about an operation and its view'
            cand reindex 'Rebuild commit index'
            cand revset 'Evaluate revset to full commit IDs'
            cand snapshot 'Trigger a snapshot in the op log'
            cand template 'Parse a template'
            cand tree 'List the recursive entries of a tree'
            cand watchman 'watchman'
            cand working-copy 'Show information about the working copy state'
        }
        &'jj;debug;copy-detection'= {
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output'
            cand --config 'Additional configuration options (can be repeated)'
            cand --config-toml 'Additional configuration options (can be repeated) (DEPRECATED)'
            cand --config-file 'Additional configuration files (can be repeated)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;debug;fileset'= {
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output'
            cand --config 'Additional configuration options (can be repeated)'
            cand --config-toml 'Additional configuration options (can be repeated) (DEPRECATED)'
            cand --config-file 'Additional configuration files (can be repeated)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;debug;index'= {
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output'
            cand --config 'Additional configuration options (can be repeated)'
            cand --config-toml 'Additional configuration options (can be repeated) (DEPRECATED)'
            cand --config-file 'Additional configuration files (can be repeated)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;debug;init-simple'= {
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output'
            cand --config 'Additional configuration options (can be repeated)'
            cand --config-toml 'Additional configuration options (can be repeated) (DEPRECATED)'
            cand --config-file 'Additional configuration files (can be repeated)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;debug;local-working-copy'= {
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output'
            cand --config 'Additional configuration options (can be repeated)'
            cand --config-toml 'Additional configuration options (can be repeated) (DEPRECATED)'
            cand --config-file 'Additional configuration files (can be repeated)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;debug;operation'= {
            cand --display 'display'
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output'
            cand --config 'Additional configuration options (can be repeated)'
            cand --config-toml 'Additional configuration options (can be repeated) (DEPRECATED)'
            cand --config-file 'Additional configuration files (can be repeated)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;debug;view'= {
            cand --display 'display'
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output'
            cand --config 'Additional configuration options (can be repeated)'
            cand --config-toml 'Additional configuration options (can be repeated) (DEPRECATED)'
            cand --config-file 'Additional configuration files (can be repeated)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;debug;reindex'= {
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output'
            cand --config 'Additional configuration options (can be repeated)'
            cand --config-toml 'Additional configuration options (can be repeated) (DEPRECATED)'
            cand --config-file 'Additional configuration files (can be repeated)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;debug;revset'= {
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output'
            cand --config 'Additional configuration options (can be repeated)'
            cand --config-toml 'Additional configuration options (can be repeated) (DEPRECATED)'
            cand --config-file 'Additional configuration files (can be repeated)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;debug;snapshot'= {
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output'
            cand --config 'Additional configuration options (can be repeated)'
            cand --config-toml 'Additional configuration options (can be repeated) (DEPRECATED)'
            cand --config-file 'Additional configuration files (can be repeated)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;debug;template'= {
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output'
            cand --config 'Additional configuration options (can be repeated)'
            cand --config-toml 'Additional configuration options (can be repeated) (DEPRECATED)'
            cand --config-file 'Additional configuration files (can be repeated)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;debug;tree'= {
            cand -r 'r'
            cand --revision 'revision'
            cand --id 'id'
            cand --dir 'dir'
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output'
            cand --config 'Additional configuration options (can be repeated)'
            cand --config-toml 'Additional configuration options (can be repeated) (DEPRECATED)'
            cand --config-file 'Additional configuration files (can be repeated)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;debug;watchman'= {
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output'
            cand --config 'Additional configuration options (can be repeated)'
            cand --config-toml 'Additional configuration options (can be repeated) (DEPRECATED)'
            cand --config-file 'Additional configuration files (can be repeated)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
            cand status 'Check whether `watchman` is enabled and whether it''s correctly installed'
            cand query-clock 'query-clock'
            cand query-changed-files 'query-changed-files'
            cand reset-clock 'reset-clock'
        }
        &'jj;debug;watchman;status'= {
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output'
            cand --config 'Additional configuration options (can be repeated)'
            cand --config-toml 'Additional configuration options (can be repeated) (DEPRECATED)'
            cand --config-file 'Additional configuration files (can be repeated)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;debug;watchman;query-clock'= {
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output'
            cand --config 'Additional configuration options (can be repeated)'
            cand --config-toml 'Additional configuration options (can be repeated) (DEPRECATED)'
            cand --config-file 'Additional configuration files (can be repeated)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;debug;watchman;query-changed-files'= {
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output'
            cand --config 'Additional configuration options (can be repeated)'
            cand --config-toml 'Additional configuration options (can be repeated) (DEPRECATED)'
            cand --config-file 'Additional configuration files (can be repeated)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;debug;watchman;reset-clock'= {
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output'
            cand --config 'Additional configuration options (can be repeated)'
            cand --config-toml 'Additional configuration options (can be repeated) (DEPRECATED)'
            cand --config-file 'Additional configuration files (can be repeated)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;debug;working-copy'= {
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output'
            cand --config 'Additional configuration options (can be repeated)'
            cand --config-toml 'Additional configuration options (can be repeated) (DEPRECATED)'
            cand --config-file 'Additional configuration files (can be repeated)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;describe'= {
            cand -r 'r'
            cand -m 'The change description to use (don''t open editor)'
            cand --message 'The change description to use (don''t open editor)'
            cand --author 'Set author to the provided string'
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output'
            cand --config 'Additional configuration options (can be repeated)'
            cand --config-toml 'Additional configuration options (can be repeated) (DEPRECATED)'
            cand --config-file 'Additional configuration files (can be repeated)'
            cand --stdin 'Read the change description from stdin'
            cand --no-edit 'Don''t open an editor'
            cand --edit 'Open an editor'
            cand --reset-author 'Reset the author to the configured user'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;desc'= {
            cand -r 'r'
            cand -m 'The change description to use (don''t open editor)'
            cand --message 'The change description to use (don''t open editor)'
            cand --author 'Set author to the provided string'
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output'
            cand --config 'Additional configuration options (can be repeated)'
            cand --config-toml 'Additional configuration options (can be repeated) (DEPRECATED)'
            cand --config-file 'Additional configuration files (can be repeated)'
            cand --stdin 'Read the change description from stdin'
            cand --no-edit 'Don''t open an editor'
            cand --edit 'Open an editor'
            cand --reset-author 'Reset the author to the configured user'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;diff'= {
            cand -r 'Show changes in these revisions'
            cand --revisions 'Show changes in these revisions'
            cand -f 'Show changes from this revision'
            cand --from 'Show changes from this revision'
            cand -t 'Show changes to this revision'
            cand --to 'Show changes to this revision'
            cand --tool 'Generate diff by external command'
            cand --context 'Number of lines of context to show'
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output'
            cand --config 'Additional configuration options (can be repeated)'
            cand --config-toml 'Additional configuration options (can be repeated) (DEPRECATED)'
            cand --config-file 'Additional configuration files (can be repeated)'
            cand -s 'For each path, show only whether it was modified, added, or deleted'
            cand --summary 'For each path, show only whether it was modified, added, or deleted'
            cand --stat 'Show a histogram of the changes'
            cand --types 'For each path, show only its type before and after'
            cand --name-only 'For each path, show only its path'
            cand --git 'Show a Git-format diff'
            cand --color-words 'Show a word-level diff with changes indicated only by color'
            cand -w 'Ignore whitespace when comparing lines'
            cand --ignore-all-space 'Ignore whitespace when comparing lines'
            cand -b 'Ignore changes in amount of whitespace when comparing lines'
            cand --ignore-space-change 'Ignore changes in amount of whitespace when comparing lines'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;diffedit'= {
            cand -r 'The revision to touch up'
            cand --revision 'The revision to touch up'
            cand -f 'Show changes from this revision'
            cand --from 'Show changes from this revision'
            cand -t 'Edit changes in this revision'
            cand --to 'Edit changes in this revision'
            cand --tool 'Specify diff editor to be used'
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output'
            cand --config 'Additional configuration options (can be repeated)'
            cand --config-toml 'Additional configuration options (can be repeated) (DEPRECATED)'
            cand --config-file 'Additional configuration files (can be repeated)'
            cand --restore-descendants 'Preserve the content (not the diff) when rebasing descendants'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;duplicate'= {
            cand -r 'r'
            cand -d 'The revision(s) to duplicate onto (can be repeated to create a merge commit)'
            cand --destination 'The revision(s) to duplicate onto (can be repeated to create a merge commit)'
            cand -A 'The revision(s) to insert after (can be repeated to create a merge commit)'
            cand --insert-after 'The revision(s) to insert after (can be repeated to create a merge commit)'
            cand --after 'The revision(s) to insert after (can be repeated to create a merge commit)'
            cand -B 'The revision(s) to insert before (can be repeated to create a merge commit)'
            cand --insert-before 'The revision(s) to insert before (can be repeated to create a merge commit)'
            cand --before 'The revision(s) to insert before (can be repeated to create a merge commit)'
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output'
            cand --config 'Additional configuration options (can be repeated)'
            cand --config-toml 'Additional configuration options (can be repeated) (DEPRECATED)'
            cand --config-file 'Additional configuration files (can be repeated)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;edit'= {
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output'
            cand --config 'Additional configuration options (can be repeated)'
            cand --config-toml 'Additional configuration options (can be repeated) (DEPRECATED)'
            cand --config-file 'Additional configuration files (can be repeated)'
            cand -r 'Ignored (but lets you pass `-r` for consistency with other commands)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;evolog'= {
            cand -r 'r'
            cand --revision 'revision'
            cand -n 'Limit number of revisions to show'
            cand --limit 'Limit number of revisions to show'
            cand -T 'Render each revision using the given template'
            cand --template 'Render each revision using the given template'
            cand --tool 'Generate diff by external command'
            cand --context 'Number of lines of context to show'
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output'
            cand --config 'Additional configuration options (can be repeated)'
            cand --config-toml 'Additional configuration options (can be repeated) (DEPRECATED)'
            cand --config-file 'Additional configuration files (can be repeated)'
            cand --reversed 'Show revisions in the opposite order (older revisions first)'
            cand --no-graph 'Don''t show the graph, show a flat list of revisions'
            cand -p 'Show patch compared to the previous version of this change'
            cand --patch 'Show patch compared to the previous version of this change'
            cand -s 'For each path, show only whether it was modified, added, or deleted'
            cand --summary 'For each path, show only whether it was modified, added, or deleted'
            cand --stat 'Show a histogram of the changes'
            cand --types 'For each path, show only its type before and after'
            cand --name-only 'For each path, show only its path'
            cand --git 'Show a Git-format diff'
            cand --color-words 'Show a word-level diff with changes indicated only by color'
            cand --ignore-all-space 'Ignore whitespace when comparing lines'
            cand --ignore-space-change 'Ignore changes in amount of whitespace when comparing lines'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;evolution-log'= {
            cand -r 'r'
            cand --revision 'revision'
            cand -n 'Limit number of revisions to show'
            cand --limit 'Limit number of revisions to show'
            cand -T 'Render each revision using the given template'
            cand --template 'Render each revision using the given template'
            cand --tool 'Generate diff by external command'
            cand --context 'Number of lines of context to show'
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output'
            cand --config 'Additional configuration options (can be repeated)'
            cand --config-toml 'Additional configuration options (can be repeated) (DEPRECATED)'
            cand --config-file 'Additional configuration files (can be repeated)'
            cand --reversed 'Show revisions in the opposite order (older revisions first)'
            cand --no-graph 'Don''t show the graph, show a flat list of revisions'
            cand -p 'Show patch compared to the previous version of this change'
            cand --patch 'Show patch compared to the previous version of this change'
            cand -s 'For each path, show only whether it was modified, added, or deleted'
            cand --summary 'For each path, show only whether it was modified, added, or deleted'
            cand --stat 'Show a histogram of the changes'
            cand --types 'For each path, show only its type before and after'
            cand --name-only 'For each path, show only its path'
            cand --git 'Show a Git-format diff'
            cand --color-words 'Show a word-level diff with changes indicated only by color'
            cand --ignore-all-space 'Ignore whitespace when comparing lines'
            cand --ignore-space-change 'Ignore changes in amount of whitespace when comparing lines'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;file'= {
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output'
            cand --config 'Additional configuration options (can be repeated)'
            cand --config-toml 'Additional configuration options (can be repeated) (DEPRECATED)'
            cand --config-file 'Additional configuration files (can be repeated)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
            cand annotate 'Show the source change for each line of the target file'
            cand chmod 'Sets or removes the executable bit for paths in the repo'
            cand list 'List files in a revision'
            cand show 'Print contents of files in a revision'
            cand track 'Start tracking specified paths in the working copy'
            cand untrack 'Stop tracking specified paths in the working copy'
        }
        &'jj;file;annotate'= {
            cand -r 'an optional revision to start at'
            cand --revision 'an optional revision to start at'
            cand -T 'Render each line using the given template'
            cand --template 'Render each line using the given template'
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output'
            cand --config 'Additional configuration options (can be repeated)'
            cand --config-toml 'Additional configuration options (can be repeated) (DEPRECATED)'
            cand --config-file 'Additional configuration files (can be repeated)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;file;chmod'= {
            cand -r 'The revision to update'
            cand --revision 'The revision to update'
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output'
            cand --config 'Additional configuration options (can be repeated)'
            cand --config-toml 'Additional configuration options (can be repeated) (DEPRECATED)'
            cand --config-file 'Additional configuration files (can be repeated)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;file;list'= {
            cand -r 'The revision to list files in'
            cand --revision 'The revision to list files in'
            cand -T 'Render each file entry using the given template'
            cand --template 'Render each file entry using the given template'
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output'
            cand --config 'Additional configuration options (can be repeated)'
            cand --config-toml 'Additional configuration options (can be repeated) (DEPRECATED)'
            cand --config-file 'Additional configuration files (can be repeated)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;file;show'= {
            cand -r 'The revision to get the file contents from'
            cand --revision 'The revision to get the file contents from'
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output'
            cand --config 'Additional configuration options (can be repeated)'
            cand --config-toml 'Additional configuration options (can be repeated) (DEPRECATED)'
            cand --config-file 'Additional configuration files (can be repeated)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;file;track'= {
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output'
            cand --config 'Additional configuration options (can be repeated)'
            cand --config-toml 'Additional configuration options (can be repeated) (DEPRECATED)'
            cand --config-file 'Additional configuration files (can be repeated)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;file;untrack'= {
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output'
            cand --config 'Additional configuration options (can be repeated)'
            cand --config-toml 'Additional configuration options (can be repeated) (DEPRECATED)'
            cand --config-file 'Additional configuration files (can be repeated)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;fix'= {
            cand -s 'Fix files in the specified revision(s) and their descendants. If no revisions are specified, this defaults to the `revsets.fix` setting, or `reachable(@, mutable())` if it is not set'
            cand --source 'Fix files in the specified revision(s) and their descendants. If no revisions are specified, this defaults to the `revsets.fix` setting, or `reachable(@, mutable())` if it is not set'
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output'
            cand --config 'Additional configuration options (can be repeated)'
            cand --config-toml 'Additional configuration options (can be repeated) (DEPRECATED)'
            cand --config-file 'Additional configuration files (can be repeated)'
            cand --include-unchanged-files 'Fix unchanged files in addition to changed ones. If no paths are specified, all files in the repo will be fixed'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;git'= {
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output'
            cand --config 'Additional configuration options (can be repeated)'
            cand --config-toml 'Additional configuration options (can be repeated) (DEPRECATED)'
            cand --config-file 'Additional configuration files (can be repeated)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
            cand clone 'Create a new repo backed by a clone of a Git repo'
            cand export 'Update the underlying Git repo with changes made in the repo'
            cand fetch 'Fetch from a Git remote'
            cand import 'Update repo with changes made in the underlying Git repo'
            cand init 'Create a new Git backed repo'
            cand push 'Push to a Git remote'
            cand remote 'Manage Git remotes'
            cand root 'Show the underlying Git directory of a repository using the Git backend'
        }
        &'jj;git;clone'= {
            cand --remote 'Name of the newly created remote'
            cand --depth 'Create a shallow clone of the given depth'
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output'
            cand --config 'Additional configuration options (can be repeated)'
            cand --config-toml 'Additional configuration options (can be repeated) (DEPRECATED)'
            cand --config-file 'Additional configuration files (can be repeated)'
            cand --colocate 'Whether or not to colocate the Jujutsu repo with the git repo'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;git;export'= {
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output'
            cand --config 'Additional configuration options (can be repeated)'
            cand --config-toml 'Additional configuration options (can be repeated) (DEPRECATED)'
            cand --config-file 'Additional configuration files (can be repeated)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;git;fetch'= {
            cand -b 'Fetch only some of the branches'
            cand --branch 'Fetch only some of the branches'
            cand --remote 'The remote to fetch from (only named remotes are supported, can be repeated)'
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output'
            cand --config 'Additional configuration options (can be repeated)'
            cand --config-toml 'Additional configuration options (can be repeated) (DEPRECATED)'
            cand --config-file 'Additional configuration files (can be repeated)'
            cand --all-remotes 'Fetch from all remotes'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;git;import'= {
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output'
            cand --config 'Additional configuration options (can be repeated)'
            cand --config-toml 'Additional configuration options (can be repeated) (DEPRECATED)'
            cand --config-file 'Additional configuration files (can be repeated)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;git;init'= {
            cand --git-repo 'Specifies a path to an **existing** git repository to be used as the backing git repo for the newly created `jj` repo'
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output'
            cand --config 'Additional configuration options (can be repeated)'
            cand --config-toml 'Additional configuration options (can be repeated) (DEPRECATED)'
            cand --config-file 'Additional configuration files (can be repeated)'
            cand --colocate 'Specifies that the `jj` repo should also be a valid `git` repo, allowing the use of both `jj` and `git` commands in the same directory'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;git;push'= {
            cand --remote 'The remote to push to (only named remotes are supported)'
            cand -b 'Push only this bookmark, or bookmarks matching a pattern (can be repeated)'
            cand --bookmark 'Push only this bookmark, or bookmarks matching a pattern (can be repeated)'
            cand -r 'Push bookmarks pointing to these commits (can be repeated)'
            cand --revisions 'Push bookmarks pointing to these commits (can be repeated)'
            cand -c 'Push this commit by creating a bookmark based on its change ID (can be repeated)'
            cand --change 'Push this commit by creating a bookmark based on its change ID (can be repeated)'
            cand --named 'Specify a new bookmark name and a revision to push under that name, e.g. ''--named myfeature=@'''
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output'
            cand --config 'Additional configuration options (can be repeated)'
            cand --config-toml 'Additional configuration options (can be repeated) (DEPRECATED)'
            cand --config-file 'Additional configuration files (can be repeated)'
            cand --all 'Push all bookmarks (including new bookmarks)'
            cand --tracked 'Push all tracked bookmarks'
            cand --deleted 'Push all deleted bookmarks'
            cand -N 'Allow pushing new bookmarks'
            cand --allow-new 'Allow pushing new bookmarks'
            cand --allow-empty-description 'Allow pushing commits with empty descriptions'
            cand --allow-private 'Allow pushing commits that are private'
            cand --dry-run 'Only display what will change on the remote'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;git;remote'= {
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output'
            cand --config 'Additional configuration options (can be repeated)'
            cand --config-toml 'Additional configuration options (can be repeated) (DEPRECATED)'
            cand --config-file 'Additional configuration files (can be repeated)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
            cand add 'Add a Git remote'
            cand list 'List Git remotes'
            cand remove 'Remove a Git remote and forget its bookmarks'
            cand rename 'Rename a Git remote'
            cand set-url 'Set the URL of a Git remote'
        }
        &'jj;git;remote;add'= {
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output'
            cand --config 'Additional configuration options (can be repeated)'
            cand --config-toml 'Additional configuration options (can be repeated) (DEPRECATED)'
            cand --config-file 'Additional configuration files (can be repeated)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;git;remote;list'= {
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output'
            cand --config 'Additional configuration options (can be repeated)'
            cand --config-toml 'Additional configuration options (can be repeated) (DEPRECATED)'
            cand --config-file 'Additional configuration files (can be repeated)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;git;remote;remove'= {
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output'
            cand --config 'Additional configuration options (can be repeated)'
            cand --config-toml 'Additional configuration options (can be repeated) (DEPRECATED)'
            cand --config-file 'Additional configuration files (can be repeated)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;git;remote;rename'= {
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output'
            cand --config 'Additional configuration options (can be repeated)'
            cand --config-toml 'Additional configuration options (can be repeated) (DEPRECATED)'
            cand --config-file 'Additional configuration files (can be repeated)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;git;remote;set-url'= {
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output'
            cand --config 'Additional configuration options (can be repeated)'
            cand --config-toml 'Additional configuration options (can be repeated) (DEPRECATED)'
            cand --config-file 'Additional configuration files (can be repeated)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;git;root'= {
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output'
            cand --config 'Additional configuration options (can be repeated)'
            cand --config-toml 'Additional configuration options (can be repeated) (DEPRECATED)'
            cand --config-file 'Additional configuration files (can be repeated)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;help'= {
            cand -k 'Show help for keywords instead of commands'
            cand --keyword 'Show help for keywords instead of commands'
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output'
            cand --config 'Additional configuration options (can be repeated)'
            cand --config-toml 'Additional configuration options (can be repeated) (DEPRECATED)'
            cand --config-file 'Additional configuration files (can be repeated)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;interdiff'= {
            cand -f 'Show changes from this revision'
            cand --from 'Show changes from this revision'
            cand -t 'Show changes to this revision'
            cand --to 'Show changes to this revision'
            cand --tool 'Generate diff by external command'
            cand --context 'Number of lines of context to show'
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output'
            cand --config 'Additional configuration options (can be repeated)'
            cand --config-toml 'Additional configuration options (can be repeated) (DEPRECATED)'
            cand --config-file 'Additional configuration files (can be repeated)'
            cand -s 'For each path, show only whether it was modified, added, or deleted'
            cand --summary 'For each path, show only whether it was modified, added, or deleted'
            cand --stat 'Show a histogram of the changes'
            cand --types 'For each path, show only its type before and after'
            cand --name-only 'For each path, show only its path'
            cand --git 'Show a Git-format diff'
            cand --color-words 'Show a word-level diff with changes indicated only by color'
            cand -w 'Ignore whitespace when comparing lines'
            cand --ignore-all-space 'Ignore whitespace when comparing lines'
            cand -b 'Ignore changes in amount of whitespace when comparing lines'
            cand --ignore-space-change 'Ignore changes in amount of whitespace when comparing lines'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;log'= {
            cand -r 'Which revisions to show'
            cand --revisions 'Which revisions to show'
            cand -n 'Limit number of revisions to show'
            cand --limit 'Limit number of revisions to show'
            cand -T 'Render each revision using the given template'
            cand --template 'Render each revision using the given template'
            cand --tool 'Generate diff by external command'
            cand --context 'Number of lines of context to show'
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output'
            cand --config 'Additional configuration options (can be repeated)'
            cand --config-toml 'Additional configuration options (can be repeated) (DEPRECATED)'
            cand --config-file 'Additional configuration files (can be repeated)'
            cand --reversed 'Show revisions in the opposite order (older revisions first)'
            cand --no-graph 'Don''t show the graph, show a flat list of revisions'
            cand -p 'Show patch'
            cand --patch 'Show patch'
            cand -s 'For each path, show only whether it was modified, added, or deleted'
            cand --summary 'For each path, show only whether it was modified, added, or deleted'
            cand --stat 'Show a histogram of the changes'
            cand --types 'For each path, show only its type before and after'
            cand --name-only 'For each path, show only its path'
            cand --git 'Show a Git-format diff'
            cand --color-words 'Show a word-level diff with changes indicated only by color'
            cand --ignore-all-space 'Ignore whitespace when comparing lines'
            cand --ignore-space-change 'Ignore changes in amount of whitespace when comparing lines'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;new'= {
            cand -m 'The change description to use'
            cand --message 'The change description to use'
            cand -A 'Insert the new change after the given commit(s)'
            cand --insert-after 'Insert the new change after the given commit(s)'
            cand --after 'Insert the new change after the given commit(s)'
            cand -B 'Insert the new change before the given commit(s)'
            cand --insert-before 'Insert the new change before the given commit(s)'
            cand --before 'Insert the new change before the given commit(s)'
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output'
            cand --config 'Additional configuration options (can be repeated)'
            cand --config-toml 'Additional configuration options (can be repeated) (DEPRECATED)'
            cand --config-file 'Additional configuration files (can be repeated)'
            cand -d 'Ignored (but lets you pass `-d`/`-r` for consistency with other commands)'
            cand --no-edit 'Do not edit the newly created change'
            cand --edit 'No-op flag to pair with --no-edit'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;next'= {
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output'
            cand --config 'Additional configuration options (can be repeated)'
            cand --config-toml 'Additional configuration options (can be repeated) (DEPRECATED)'
            cand --config-file 'Additional configuration files (can be repeated)'
            cand -e 'Instead of creating a new working-copy commit on top of the target commit (like `jj new`), edit the target commit directly (like `jj edit`)'
            cand --edit 'Instead of creating a new working-copy commit on top of the target commit (like `jj new`), edit the target commit directly (like `jj edit`)'
            cand -n 'The inverse of `--edit`'
            cand --no-edit 'The inverse of `--edit`'
            cand --conflict 'Jump to the next conflicted descendant'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;operation'= {
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output'
            cand --config 'Additional configuration options (can be repeated)'
            cand --config-toml 'Additional configuration options (can be repeated) (DEPRECATED)'
            cand --config-file 'Additional configuration files (can be repeated)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
            cand abandon 'Abandon operation history'
            cand diff 'Compare changes to the repository between two operations'
            cand log 'Show the operation log'
            cand restore 'Create a new operation that restores the repo to an earlier state'
            cand show 'Show changes to the repository in an operation'
            cand undo 'Create a new operation that undoes an earlier operation'
        }
        &'jj;op'= {
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output'
            cand --config 'Additional configuration options (can be repeated)'
            cand --config-toml 'Additional configuration options (can be repeated) (DEPRECATED)'
            cand --config-file 'Additional configuration files (can be repeated)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
            cand abandon 'Abandon operation history'
            cand diff 'Compare changes to the repository between two operations'
            cand log 'Show the operation log'
            cand restore 'Create a new operation that restores the repo to an earlier state'
            cand show 'Show changes to the repository in an operation'
            cand undo 'Create a new operation that undoes an earlier operation'
        }
        &'jj;operation;abandon'= {
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output'
            cand --config 'Additional configuration options (can be repeated)'
            cand --config-toml 'Additional configuration options (can be repeated) (DEPRECATED)'
            cand --config-file 'Additional configuration files (can be repeated)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;op;abandon'= {
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output'
            cand --config 'Additional configuration options (can be repeated)'
            cand --config-toml 'Additional configuration options (can be repeated) (DEPRECATED)'
            cand --config-file 'Additional configuration files (can be repeated)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;operation;diff'= {
            cand --operation 'Show repository changes in this operation, compared to its parent'
            cand --op 'Show repository changes in this operation, compared to its parent'
            cand -f 'Show repository changes from this operation'
            cand --from 'Show repository changes from this operation'
            cand -t 'Show repository changes to this operation'
            cand --to 'Show repository changes to this operation'
            cand --tool 'Generate diff by external command'
            cand --context 'Number of lines of context to show'
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output'
            cand --config 'Additional configuration options (can be repeated)'
            cand --config-toml 'Additional configuration options (can be repeated) (DEPRECATED)'
            cand --config-file 'Additional configuration files (can be repeated)'
            cand --no-graph 'Don''t show the graph, show a flat list of modified changes'
            cand -p 'Show patch of modifications to changes'
            cand --patch 'Show patch of modifications to changes'
            cand -s 'For each path, show only whether it was modified, added, or deleted'
            cand --summary 'For each path, show only whether it was modified, added, or deleted'
            cand --stat 'Show a histogram of the changes'
            cand --types 'For each path, show only its type before and after'
            cand --name-only 'For each path, show only its path'
            cand --git 'Show a Git-format diff'
            cand --color-words 'Show a word-level diff with changes indicated only by color'
            cand --ignore-all-space 'Ignore whitespace when comparing lines'
            cand --ignore-space-change 'Ignore changes in amount of whitespace when comparing lines'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;op;diff'= {
            cand --operation 'Show repository changes in this operation, compared to its parent'
            cand --op 'Show repository changes in this operation, compared to its parent'
            cand -f 'Show repository changes from this operation'
            cand --from 'Show repository changes from this operation'
            cand -t 'Show repository changes to this operation'
            cand --to 'Show repository changes to this operation'
            cand --tool 'Generate diff by external command'
            cand --context 'Number of lines of context to show'
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output'
            cand --config 'Additional configuration options (can be repeated)'
            cand --config-toml 'Additional configuration options (can be repeated) (DEPRECATED)'
            cand --config-file 'Additional configuration files (can be repeated)'
            cand --no-graph 'Don''t show the graph, show a flat list of modified changes'
            cand -p 'Show patch of modifications to changes'
            cand --patch 'Show patch of modifications to changes'
            cand -s 'For each path, show only whether it was modified, added, or deleted'
            cand --summary 'For each path, show only whether it was modified, added, or deleted'
            cand --stat 'Show a histogram of the changes'
            cand --types 'For each path, show only its type before and after'
            cand --name-only 'For each path, show only its path'
            cand --git 'Show a Git-format diff'
            cand --color-words 'Show a word-level diff with changes indicated only by color'
            cand --ignore-all-space 'Ignore whitespace when comparing lines'
            cand --ignore-space-change 'Ignore changes in amount of whitespace when comparing lines'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;operation;log'= {
            cand -n 'Limit number of operations to show'
            cand --limit 'Limit number of operations to show'
            cand -T 'Render each operation using the given template'
            cand --template 'Render each operation using the given template'
            cand --tool 'Generate diff by external command'
            cand --context 'Number of lines of context to show'
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output'
            cand --config 'Additional configuration options (can be repeated)'
            cand --config-toml 'Additional configuration options (can be repeated) (DEPRECATED)'
            cand --config-file 'Additional configuration files (can be repeated)'
            cand --reversed 'Show operations in the opposite order (older operations first)'
            cand --no-graph 'Don''t show the graph, show a flat list of operations'
            cand -d 'Show changes to the repository at each operation'
            cand --op-diff 'Show changes to the repository at each operation'
            cand -p 'Show patch of modifications to changes (implies --op-diff)'
            cand --patch 'Show patch of modifications to changes (implies --op-diff)'
            cand -s 'For each path, show only whether it was modified, added, or deleted'
            cand --summary 'For each path, show only whether it was modified, added, or deleted'
            cand --stat 'Show a histogram of the changes'
            cand --types 'For each path, show only its type before and after'
            cand --name-only 'For each path, show only its path'
            cand --git 'Show a Git-format diff'
            cand --color-words 'Show a word-level diff with changes indicated only by color'
            cand --ignore-all-space 'Ignore whitespace when comparing lines'
            cand --ignore-space-change 'Ignore changes in amount of whitespace when comparing lines'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;op;log'= {
            cand -n 'Limit number of operations to show'
            cand --limit 'Limit number of operations to show'
            cand -T 'Render each operation using the given template'
            cand --template 'Render each operation using the given template'
            cand --tool 'Generate diff by external command'
            cand --context 'Number of lines of context to show'
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output'
            cand --config 'Additional configuration options (can be repeated)'
            cand --config-toml 'Additional configuration options (can be repeated) (DEPRECATED)'
            cand --config-file 'Additional configuration files (can be repeated)'
            cand --reversed 'Show operations in the opposite order (older operations first)'
            cand --no-graph 'Don''t show the graph, show a flat list of operations'
            cand -d 'Show changes to the repository at each operation'
            cand --op-diff 'Show changes to the repository at each operation'
            cand -p 'Show patch of modifications to changes (implies --op-diff)'
            cand --patch 'Show patch of modifications to changes (implies --op-diff)'
            cand -s 'For each path, show only whether it was modified, added, or deleted'
            cand --summary 'For each path, show only whether it was modified, added, or deleted'
            cand --stat 'Show a histogram of the changes'
            cand --types 'For each path, show only its type before and after'
            cand --name-only 'For each path, show only its path'
            cand --git 'Show a Git-format diff'
            cand --color-words 'Show a word-level diff with changes indicated only by color'
            cand --ignore-all-space 'Ignore whitespace when comparing lines'
            cand --ignore-space-change 'Ignore changes in amount of whitespace when comparing lines'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;operation;restore'= {
            cand --what 'What portions of the local state to restore (can be repeated)'
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output'
            cand --config 'Additional configuration options (can be repeated)'
            cand --config-toml 'Additional configuration options (can be repeated) (DEPRECATED)'
            cand --config-file 'Additional configuration files (can be repeated)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;op;restore'= {
            cand --what 'What portions of the local state to restore (can be repeated)'
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output'
            cand --config 'Additional configuration options (can be repeated)'
            cand --config-toml 'Additional configuration options (can be repeated) (DEPRECATED)'
            cand --config-file 'Additional configuration files (can be repeated)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;operation;show'= {
            cand --tool 'Generate diff by external command'
            cand --context 'Number of lines of context to show'
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output'
            cand --config 'Additional configuration options (can be repeated)'
            cand --config-toml 'Additional configuration options (can be repeated) (DEPRECATED)'
            cand --config-file 'Additional configuration files (can be repeated)'
            cand --no-graph 'Don''t show the graph, show a flat list of modified changes'
            cand -p 'Show patch of modifications to changes'
            cand --patch 'Show patch of modifications to changes'
            cand -s 'For each path, show only whether it was modified, added, or deleted'
            cand --summary 'For each path, show only whether it was modified, added, or deleted'
            cand --stat 'Show a histogram of the changes'
            cand --types 'For each path, show only its type before and after'
            cand --name-only 'For each path, show only its path'
            cand --git 'Show a Git-format diff'
            cand --color-words 'Show a word-level diff with changes indicated only by color'
            cand --ignore-all-space 'Ignore whitespace when comparing lines'
            cand --ignore-space-change 'Ignore changes in amount of whitespace when comparing lines'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;op;show'= {
            cand --tool 'Generate diff by external command'
            cand --context 'Number of lines of context to show'
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output'
            cand --config 'Additional configuration options (can be repeated)'
            cand --config-toml 'Additional configuration options (can be repeated) (DEPRECATED)'
            cand --config-file 'Additional configuration files (can be repeated)'
            cand --no-graph 'Don''t show the graph, show a flat list of modified changes'
            cand -p 'Show patch of modifications to changes'
            cand --patch 'Show patch of modifications to changes'
            cand -s 'For each path, show only whether it was modified, added, or deleted'
            cand --summary 'For each path, show only whether it was modified, added, or deleted'
            cand --stat 'Show a histogram of the changes'
            cand --types 'For each path, show only its type before and after'
            cand --name-only 'For each path, show only its path'
            cand --git 'Show a Git-format diff'
            cand --color-words 'Show a word-level diff with changes indicated only by color'
            cand --ignore-all-space 'Ignore whitespace when comparing lines'
            cand --ignore-space-change 'Ignore changes in amount of whitespace when comparing lines'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;operation;undo'= {
            cand --what 'What portions of the local state to restore (can be repeated)'
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output'
            cand --config 'Additional configuration options (can be repeated)'
            cand --config-toml 'Additional configuration options (can be repeated) (DEPRECATED)'
            cand --config-file 'Additional configuration files (can be repeated)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;op;undo'= {
            cand --what 'What portions of the local state to restore (can be repeated)'
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output'
            cand --config 'Additional configuration options (can be repeated)'
            cand --config-toml 'Additional configuration options (can be repeated) (DEPRECATED)'
            cand --config-file 'Additional configuration files (can be repeated)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;parallelize'= {
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output'
            cand --config 'Additional configuration options (can be repeated)'
            cand --config-toml 'Additional configuration options (can be repeated) (DEPRECATED)'
            cand --config-file 'Additional configuration files (can be repeated)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;prev'= {
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output'
            cand --config 'Additional configuration options (can be repeated)'
            cand --config-toml 'Additional configuration options (can be repeated) (DEPRECATED)'
            cand --config-file 'Additional configuration files (can be repeated)'
            cand -e 'Edit the parent directly, instead of moving the working-copy commit'
            cand --edit 'Edit the parent directly, instead of moving the working-copy commit'
            cand -n 'The inverse of `--edit`'
            cand --no-edit 'The inverse of `--edit`'
            cand --conflict 'Jump to the previous conflicted ancestor'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;rebase'= {
            cand -b 'Rebase the whole branch relative to destination''s ancestors (can be repeated)'
            cand --branch 'Rebase the whole branch relative to destination''s ancestors (can be repeated)'
            cand -s 'Rebase specified revision(s) together with their trees of descendants (can be repeated)'
            cand --source 'Rebase specified revision(s) together with their trees of descendants (can be repeated)'
            cand -r 'Rebase the given revisions, rebasing descendants onto this revision''s parent(s)'
            cand --revisions 'Rebase the given revisions, rebasing descendants onto this revision''s parent(s)'
            cand -d 'The revision(s) to rebase onto (can be repeated to create a merge commit)'
            cand --destination 'The revision(s) to rebase onto (can be repeated to create a merge commit)'
            cand -A 'The revision(s) to insert after (can be repeated to create a merge commit)'
            cand --insert-after 'The revision(s) to insert after (can be repeated to create a merge commit)'
            cand --after 'The revision(s) to insert after (can be repeated to create a merge commit)'
            cand -B 'The revision(s) to insert before (can be repeated to create a merge commit)'
            cand --insert-before 'The revision(s) to insert before (can be repeated to create a merge commit)'
            cand --before 'The revision(s) to insert before (can be repeated to create a merge commit)'
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output'
            cand --config 'Additional configuration options (can be repeated)'
            cand --config-toml 'Additional configuration options (can be repeated) (DEPRECATED)'
            cand --config-file 'Additional configuration files (can be repeated)'
            cand --skip-emptied 'If true, when rebasing would produce an empty commit, the commit is abandoned. It will not be abandoned if it was already empty before the rebase. Will never skip merge commits with multiple non-empty parents'
            cand --keep-divergent 'Keep divergent commits while rebasing'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;resolve'= {
            cand -r 'r'
            cand --revision 'revision'
            cand --tool 'Specify 3-way merge tool to be used'
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output'
            cand --config 'Additional configuration options (can be repeated)'
            cand --config-toml 'Additional configuration options (can be repeated) (DEPRECATED)'
            cand --config-file 'Additional configuration files (can be repeated)'
            cand -l 'Instead of resolving conflicts, list all the conflicts'
            cand --list 'Instead of resolving conflicts, list all the conflicts'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;restore'= {
            cand -f 'Revision to restore from (source)'
            cand --from 'Revision to restore from (source)'
            cand -t 'Revision to restore into (destination)'
            cand --into 'Revision to restore into (destination)'
            cand --to 'Revision to restore into (destination)'
            cand -c 'Undo the changes in a revision as compared to the merge of its parents'
            cand --changes-in 'Undo the changes in a revision as compared to the merge of its parents'
            cand -r 'Prints an error. DO NOT USE'
            cand --revision 'Prints an error. DO NOT USE'
            cand --tool 'Specify diff editor to be used (implies --interactive)'
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output'
            cand --config 'Additional configuration options (can be repeated)'
            cand --config-toml 'Additional configuration options (can be repeated) (DEPRECATED)'
            cand --config-file 'Additional configuration files (can be repeated)'
            cand -i 'Interactively choose which parts to restore'
            cand --interactive 'Interactively choose which parts to restore'
            cand --restore-descendants 'Preserve the content (not the diff) when rebasing descendants'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;revert'= {
            cand -r 'The revision(s) to apply the reverse of'
            cand --revisions 'The revision(s) to apply the reverse of'
            cand -d 'The revision(s) to apply the reverse changes on top of'
            cand --destination 'The revision(s) to apply the reverse changes on top of'
            cand -A 'The revision(s) to insert the reverse changes after (can be repeated to create a merge commit)'
            cand --insert-after 'The revision(s) to insert the reverse changes after (can be repeated to create a merge commit)'
            cand --after 'The revision(s) to insert the reverse changes after (can be repeated to create a merge commit)'
            cand -B 'The revision(s) to insert the reverse changes before (can be repeated to create a merge commit)'
            cand --insert-before 'The revision(s) to insert the reverse changes before (can be repeated to create a merge commit)'
            cand --before 'The revision(s) to insert the reverse changes before (can be repeated to create a merge commit)'
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output'
            cand --config 'Additional configuration options (can be repeated)'
            cand --config-toml 'Additional configuration options (can be repeated) (DEPRECATED)'
            cand --config-file 'Additional configuration files (can be repeated)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;root'= {
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output'
            cand --config 'Additional configuration options (can be repeated)'
            cand --config-toml 'Additional configuration options (can be repeated) (DEPRECATED)'
            cand --config-file 'Additional configuration files (can be repeated)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;run'= {
            cand -r 'The revisions to change'
            cand --revisions 'The revisions to change'
            cand -j 'How many processes should run in parallel, uses by default all cores'
            cand --jobs 'How many processes should run in parallel, uses by default all cores'
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output'
            cand --config 'Additional configuration options (can be repeated)'
            cand --config-toml 'Additional configuration options (can be repeated) (DEPRECATED)'
            cand --config-file 'Additional configuration files (can be repeated)'
            cand -x 'A no-op option to match the interface of `git rebase -x`'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;show'= {
            cand -T 'Render a revision using the given template'
            cand --template 'Render a revision using the given template'
            cand --tool 'Generate diff by external command'
            cand --context 'Number of lines of context to show'
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output'
            cand --config 'Additional configuration options (can be repeated)'
            cand --config-toml 'Additional configuration options (can be repeated) (DEPRECATED)'
            cand --config-file 'Additional configuration files (can be repeated)'
            cand -r 'Ignored (but lets you pass `-r` for consistency with other commands)'
            cand -s 'For each path, show only whether it was modified, added, or deleted'
            cand --summary 'For each path, show only whether it was modified, added, or deleted'
            cand --stat 'Show a histogram of the changes'
            cand --types 'For each path, show only its type before and after'
            cand --name-only 'For each path, show only its path'
            cand --git 'Show a Git-format diff'
            cand --color-words 'Show a word-level diff with changes indicated only by color'
            cand --no-patch 'Do not show the patch'
            cand -w 'Ignore whitespace when comparing lines'
            cand --ignore-all-space 'Ignore whitespace when comparing lines'
            cand -b 'Ignore changes in amount of whitespace when comparing lines'
            cand --ignore-space-change 'Ignore changes in amount of whitespace when comparing lines'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;sign'= {
            cand -r 'What revision(s) to sign'
            cand --revisions 'What revision(s) to sign'
            cand --key 'The key used for signing'
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output'
            cand --config 'Additional configuration options (can be repeated)'
            cand --config-toml 'Additional configuration options (can be repeated) (DEPRECATED)'
            cand --config-file 'Additional configuration files (can be repeated)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;simplify-parents'= {
            cand -s 'Simplify specified revision(s) together with their trees of descendants (can be repeated)'
            cand --source 'Simplify specified revision(s) together with their trees of descendants (can be repeated)'
            cand -r 'Simplify specified revision(s) (can be repeated)'
            cand --revisions 'Simplify specified revision(s) (can be repeated)'
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output'
            cand --config 'Additional configuration options (can be repeated)'
            cand --config-toml 'Additional configuration options (can be repeated) (DEPRECATED)'
            cand --config-file 'Additional configuration files (can be repeated)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;sparse'= {
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output'
            cand --config 'Additional configuration options (can be repeated)'
            cand --config-toml 'Additional configuration options (can be repeated) (DEPRECATED)'
            cand --config-file 'Additional configuration files (can be repeated)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
            cand edit 'Start an editor to update the patterns that are present in the working copy'
            cand list 'List the patterns that are currently present in the working copy'
            cand reset 'Reset the patterns to include all files in the working copy'
            cand set 'Update the patterns that are present in the working copy'
        }
        &'jj;sparse;edit'= {
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output'
            cand --config 'Additional configuration options (can be repeated)'
            cand --config-toml 'Additional configuration options (can be repeated) (DEPRECATED)'
            cand --config-file 'Additional configuration files (can be repeated)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;sparse;list'= {
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output'
            cand --config 'Additional configuration options (can be repeated)'
            cand --config-toml 'Additional configuration options (can be repeated) (DEPRECATED)'
            cand --config-file 'Additional configuration files (can be repeated)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;sparse;reset'= {
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output'
            cand --config 'Additional configuration options (can be repeated)'
            cand --config-toml 'Additional configuration options (can be repeated) (DEPRECATED)'
            cand --config-file 'Additional configuration files (can be repeated)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;sparse;set'= {
            cand --add 'Patterns to add to the working copy'
            cand --remove 'Patterns to remove from the working copy'
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output'
            cand --config 'Additional configuration options (can be repeated)'
            cand --config-toml 'Additional configuration options (can be repeated) (DEPRECATED)'
            cand --config-file 'Additional configuration files (can be repeated)'
            cand --clear 'Include no files in the working copy (combine with --add)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;split'= {
            cand --tool 'Specify diff editor to be used (implies --interactive)'
            cand -r 'The revision to split'
            cand --revision 'The revision to split'
            cand -d 'The revision(s) to rebase onto (can be repeated to create a merge commit)'
            cand --destination 'The revision(s) to rebase onto (can be repeated to create a merge commit)'
            cand -A 'The revision(s) to insert after (can be repeated to create a merge commit)'
            cand --insert-after 'The revision(s) to insert after (can be repeated to create a merge commit)'
            cand --after 'The revision(s) to insert after (can be repeated to create a merge commit)'
            cand -B 'The revision(s) to insert before (can be repeated to create a merge commit)'
            cand --insert-before 'The revision(s) to insert before (can be repeated to create a merge commit)'
            cand --before 'The revision(s) to insert before (can be repeated to create a merge commit)'
            cand -m 'The change description to use (don''t open editor)'
            cand --message 'The change description to use (don''t open editor)'
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output'
            cand --config 'Additional configuration options (can be repeated)'
            cand --config-toml 'Additional configuration options (can be repeated) (DEPRECATED)'
            cand --config-file 'Additional configuration files (can be repeated)'
            cand -i 'Interactively choose which parts to split'
            cand --interactive 'Interactively choose which parts to split'
            cand -p 'Split the revision into two parallel revisions instead of a parent and child'
            cand --parallel 'Split the revision into two parallel revisions instead of a parent and child'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;squash'= {
            cand -r 'Revision to squash into its parent (default: @)'
            cand --revision 'Revision to squash into its parent (default: @)'
            cand -f 'Revision(s) to squash from (default: @)'
            cand --from 'Revision(s) to squash from (default: @)'
            cand -t 'Revision to squash into (default: @)'
            cand --into 'Revision to squash into (default: @)'
            cand --to 'Revision to squash into (default: @)'
            cand -m 'The description to use for squashed revision (don''t open editor)'
            cand --message 'The description to use for squashed revision (don''t open editor)'
            cand --tool 'Specify diff editor to be used (implies --interactive)'
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output'
            cand --config 'Additional configuration options (can be repeated)'
            cand --config-toml 'Additional configuration options (can be repeated) (DEPRECATED)'
            cand --config-file 'Additional configuration files (can be repeated)'
            cand -u 'Use the description of the destination revision and discard the description(s) of the source revision(s)'
            cand --use-destination-message 'Use the description of the destination revision and discard the description(s) of the source revision(s)'
            cand -i 'Interactively choose which parts to squash'
            cand --interactive 'Interactively choose which parts to squash'
            cand -k 'The source revision will not be abandoned'
            cand --keep-emptied 'The source revision will not be abandoned'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;status'= {
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output'
            cand --config 'Additional configuration options (can be repeated)'
            cand --config-toml 'Additional configuration options (can be repeated) (DEPRECATED)'
            cand --config-file 'Additional configuration files (can be repeated)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;st'= {
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output'
            cand --config 'Additional configuration options (can be repeated)'
            cand --config-toml 'Additional configuration options (can be repeated) (DEPRECATED)'
            cand --config-file 'Additional configuration files (can be repeated)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;tag'= {
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output'
            cand --config 'Additional configuration options (can be repeated)'
            cand --config-toml 'Additional configuration options (can be repeated) (DEPRECATED)'
            cand --config-file 'Additional configuration files (can be repeated)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
            cand list 'List tags'
            cand l 'List tags'
        }
        &'jj;tag;list'= {
            cand -T 'Render each tag using the given template'
            cand --template 'Render each tag using the given template'
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output'
            cand --config 'Additional configuration options (can be repeated)'
            cand --config-toml 'Additional configuration options (can be repeated) (DEPRECATED)'
            cand --config-file 'Additional configuration files (can be repeated)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;tag;l'= {
            cand -T 'Render each tag using the given template'
            cand --template 'Render each tag using the given template'
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output'
            cand --config 'Additional configuration options (can be repeated)'
            cand --config-toml 'Additional configuration options (can be repeated) (DEPRECATED)'
            cand --config-file 'Additional configuration files (can be repeated)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;undo'= {
            cand --what 'What portions of the local state to restore (can be repeated)'
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output'
            cand --config 'Additional configuration options (can be repeated)'
            cand --config-toml 'Additional configuration options (can be repeated) (DEPRECATED)'
            cand --config-file 'Additional configuration files (can be repeated)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;unsign'= {
            cand -r 'What revision(s) to unsign'
            cand --revisions 'What revision(s) to unsign'
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output'
            cand --config 'Additional configuration options (can be repeated)'
            cand --config-toml 'Additional configuration options (can be repeated) (DEPRECATED)'
            cand --config-file 'Additional configuration files (can be repeated)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;util'= {
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output'
            cand --config 'Additional configuration options (can be repeated)'
            cand --config-toml 'Additional configuration options (can be repeated) (DEPRECATED)'
            cand --config-file 'Additional configuration files (can be repeated)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
            cand completion 'Print a command-line-completion script'
            cand config-schema 'Print the JSON schema for the jj TOML config format'
            cand exec 'Execute an external command via jj'
            cand gc 'Run backend-dependent garbage collection'
            cand install-man-pages 'Install Jujutsu''s manpages to the provided path'
            cand markdown-help 'Print the CLI help for all subcommands in Markdown'
        }
        &'jj;util;completion'= {
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output'
            cand --config 'Additional configuration options (can be repeated)'
            cand --config-toml 'Additional configuration options (can be repeated) (DEPRECATED)'
            cand --config-file 'Additional configuration files (can be repeated)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;util;config-schema'= {
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output'
            cand --config 'Additional configuration options (can be repeated)'
            cand --config-toml 'Additional configuration options (can be repeated) (DEPRECATED)'
            cand --config-file 'Additional configuration files (can be repeated)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;util;exec'= {
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output'
            cand --config 'Additional configuration options (can be repeated)'
            cand --config-toml 'Additional configuration options (can be repeated) (DEPRECATED)'
            cand --config-file 'Additional configuration files (can be repeated)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;util;gc'= {
            cand --expire 'Time threshold'
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output'
            cand --config 'Additional configuration options (can be repeated)'
            cand --config-toml 'Additional configuration options (can be repeated) (DEPRECATED)'
            cand --config-file 'Additional configuration files (can be repeated)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;util;install-man-pages'= {
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output'
            cand --config 'Additional configuration options (can be repeated)'
            cand --config-toml 'Additional configuration options (can be repeated) (DEPRECATED)'
            cand --config-file 'Additional configuration files (can be repeated)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;util;markdown-help'= {
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output'
            cand --config 'Additional configuration options (can be repeated)'
            cand --config-toml 'Additional configuration options (can be repeated) (DEPRECATED)'
            cand --config-file 'Additional configuration files (can be repeated)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;version'= {
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output'
            cand --config 'Additional configuration options (can be repeated)'
            cand --config-toml 'Additional configuration options (can be repeated) (DEPRECATED)'
            cand --config-file 'Additional configuration files (can be repeated)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;workspace'= {
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output'
            cand --config 'Additional configuration options (can be repeated)'
            cand --config-toml 'Additional configuration options (can be repeated) (DEPRECATED)'
            cand --config-file 'Additional configuration files (can be repeated)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
            cand add 'Add a workspace'
            cand forget 'Stop tracking a workspace''s working-copy commit in the repo'
            cand list 'List workspaces'
            cand rename 'Renames the current workspace'
            cand root 'Show the current workspace root directory'
            cand update-stale 'Update a workspace that has become stale'
        }
        &'jj;workspace;add'= {
            cand --name 'A name for the workspace'
            cand -r 'A list of parent revisions for the working-copy commit of the newly created workspace. You may specify nothing, or any number of parents'
            cand --revision 'A list of parent revisions for the working-copy commit of the newly created workspace. You may specify nothing, or any number of parents'
            cand --sparse-patterns 'How to handle sparse patterns when creating a new workspace'
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output'
            cand --config 'Additional configuration options (can be repeated)'
            cand --config-toml 'Additional configuration options (can be repeated) (DEPRECATED)'
            cand --config-file 'Additional configuration files (can be repeated)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;workspace;forget'= {
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output'
            cand --config 'Additional configuration options (can be repeated)'
            cand --config-toml 'Additional configuration options (can be repeated) (DEPRECATED)'
            cand --config-file 'Additional configuration files (can be repeated)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;workspace;list'= {
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output'
            cand --config 'Additional configuration options (can be repeated)'
            cand --config-toml 'Additional configuration options (can be repeated) (DEPRECATED)'
            cand --config-file 'Additional configuration files (can be repeated)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;workspace;rename'= {
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output'
            cand --config 'Additional configuration options (can be repeated)'
            cand --config-toml 'Additional configuration options (can be repeated) (DEPRECATED)'
            cand --config-file 'Additional configuration files (can be repeated)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;workspace;root'= {
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output'
            cand --config 'Additional configuration options (can be repeated)'
            cand --config-toml 'Additional configuration options (can be repeated) (DEPRECATED)'
            cand --config-file 'Additional configuration files (can be repeated)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;workspace;update-stale'= {
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output'
            cand --config 'Additional configuration options (can be repeated)'
            cand --config-toml 'Additional configuration options (can be repeated) (DEPRECATED)'
            cand --config-file 'Additional configuration files (can be repeated)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
    ]
    $completions[$command]
}
