/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.conflict.tags;

import java.util.Objects;
import java.util.Optional;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.gui.conflict.tags.RelationMemberConflictDecisionType;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;

public class RelationMemberConflictDecision {
    private final Relation relation;
    private final int pos;
    private final OsmPrimitive originalPrimitive;
    private String role;
    private RelationMemberConflictDecisionType decision;

    public RelationMemberConflictDecision(Relation relation, int pos) {
        CheckParameterUtil.ensureParameterNotNull(relation, "relation");
        RelationMember member = relation.getMember(pos);
        if (member == null) {
            throw new IndexOutOfBoundsException(I18n.tr("Position {0} is out of range. Current number of members is {1}.", pos, relation.getMembersCount()));
        }
        this.relation = relation;
        this.pos = pos;
        this.originalPrimitive = member.getMember();
        this.role = member.hasRole() ? member.getRole() : "";
        this.decision = RelationMemberConflictDecisionType.UNDECIDED;
    }

    public Relation getRelation() {
        return this.relation;
    }

    public int getPos() {
        return this.pos;
    }

    public OsmPrimitive getOriginalPrimitive() {
        return this.originalPrimitive;
    }

    public String getRole() {
        return this.role;
    }

    public RelationMemberConflictDecisionType getDecision() {
        return this.decision;
    }

    public void setRole(String role) {
        this.role = role == null ? "" : role;
    }

    public void decide(RelationMemberConflictDecisionType decision) {
        this.decision = Optional.ofNullable(decision).orElse(RelationMemberConflictDecisionType.UNDECIDED);
    }

    public boolean isDecided() {
        return RelationMemberConflictDecisionType.UNDECIDED != this.decision;
    }

    public boolean matches(Relation relation, int pos) {
        return this.relation == relation && this.pos == pos;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.relation, this.pos, this.originalPrimitive, this.role, this.decision});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        RelationMemberConflictDecision that = (RelationMemberConflictDecision)obj;
        return this.pos == that.pos && this.decision == that.decision && Objects.equals(this.relation, that.relation) && Objects.equals(this.originalPrimitive, that.originalPrimitive) && Objects.equals(this.role, that.role);
    }

    public String toString() {
        return this.originalPrimitive.getPrimitiveId() + " at index " + this.pos + " with role " + this.role + " in " + this.relation.getUniqueId() + " => " + this.decision;
    }
}

