gap> START_TEST("GBNP test12");
gap> ######################### BEGIN COPYRIGHT MESSAGE #########################
gap> # GBNP - computing Gröbner bases of noncommutative polynomials
gap> # Copyright 2001-2010 by Arjeh M. Cohen, Dié A.H. Gijsbers, Jan Willem
gap> # Knopper, Chris Krook. Address: Discrete Algebra and Geometry (DAM) group
gap> # at the Department of Mathematics and Computer Science of Eindhoven
gap> # University of Technology.
gap> # 
gap> # For acknowledgements see the manual. The manual can be found in several
gap> # formats in the doc subdirectory of the GBNP distribution. The
gap> # acknowledgements formatted as text can be found in the file chap0.txt.
gap> # 
gap> # GBNP is free software; you can redistribute it and/or modify it under
gap> # the terms of the Lesser GNU General Public License as published by the
gap> # Free Software Foundation (FSF); either version 2.1 of the License, or
gap> # (at your option) any later version. For details, see the file 'LGPL' in
gap> # the doc subdirectory of the GBNP distribution or see the FSF's own site:
gap> # https://www.gnu.org/licenses/lgpl.html
gap> ########################## END COPYRIGHT MESSAGE ##########################
gap> 
gap> ### file created by jwk - wo 30 mei 2007 11:35:01 CEST
gap> 
gap> # <#GAPDoc Label="Example12">
gap> # <Section Label="Example12"><Heading>The universal enveloping
gap> # algebra of a Lie algebra</Heading>
gap> # Consider the Lie algebra with generators <M>e</M>, <M>f</M> and
gap> # <M>h</M>, and relations <M>[e,f]=h</M>, <M>[e,h]=-2e</M>, <M>[f,h]=2f</M>.
gap> # This is the well-known Lie algebra of type A<M>_1</M>.
gap> # We construct the corresponding universal enveloping algebra of this
gap> # Lie algebra
gap> # and show how one can prove that <M>f^2</M> belongs to the ideal
gap> # generated by <M>e^2</M> in that associative algebra.
gap> # The example is from Knopper's report <Cite Key="Knopper2004"/>.
gap> # <P/>
gap> # First load the package and set the standard infolevel <Ref
gap> # InfoClass="InfoGBNP" Style="Text"/> to 0 and the time infolevel <Ref
gap> # Func="InfoGBNPTime" Style="Text"/> to 0 (for more information about the info
gap> # level, see Chapter <Ref Chap="Info"/>).
gap> 
gap> # <L>
gap> LoadPackage("gbnp", false);
true
gap> SetInfoLevel(InfoGBNP,0);
gap> SetInfoLevel(InfoGBNPTime,0);
gap> # </L>
gap> 
gap> # Then define the algebra and enter the relations as polynomials in GAP. 
gap> 
gap> # <L>
gap> A:=FreeAssociativeAlgebraWithOne(Rationals, "e", "f", "h");
<algebra-with-one over Rationals, with 3 generators>
gap> e:=A.e;; f:=A.f;; h:=A.h;; o:=One(A);;
gap> uerels:=[f*e-e*f+h,h*e-e*h-2*e,h*f-f*h+2*f];
[ (1)*h+(-1)*e*f+(1)*f*e, (-2)*e+(-1)*e*h+(1)*h*e, (2)*f+(-1)*f*h+(1)*h*f ]
gap> # </L>
gap> 
gap> # The relations can be converted to NP format (see <Ref Sect="NP"/>) with the
gap> # function <Ref Func="GP2NPList" Style="Text"/> and can be subsequently
gap> # displayed with <Ref Func="PrintNPList" Style="Text"/>.
gap> 
gap> # <L>
gap> uerelsNP:=GP2NPList(uerels);;
gap> PrintNPList(uerelsNP);
 ba - ab + c 
 ca - ac - 2a 
 cb - bc + 2b 
gap> # </L>
gap> 
gap> # Now configure printing in such a way that this algebra is used with the
gap> # function <Ref Func="GBNP.ConfigPrint" Style="Text"/>.
gap> 
gap> # <L>
gap> GBNP.ConfigPrint(A);
gap> # </L>
gap> 
gap> # The set is actually a Gröbner basis, as can be verified by calculating the
gap> # Gröbner basis with <Ref Func="SGrobner"
gap> # Style="Text"/>.
gap> 
gap> # <L>
gap> GB:=SGrobner(uerelsNP);;
gap> PrintNPList(GB);
 fe - ef + h 
 he - eh - 2e 
 hf - fh + 2f 
gap> # </L>
gap> 
gap> # Determine whether the quotient algebra is finite dimensional by means of <Ref
gap> # Func="FinCheckQA" Style="Text"/>, with arguments the leading monomials of
gap> # <C>GB</C> and 3, the number of variables involved. The leading monomials of
gap> # <C>GB</C> are found by invoking <Ref Func="LMonsNP" Style="Text"/>.
gap> 
gap> # <L>
gap> F:=LMonsNP(GB);
[ [ 2, 1 ], [ 3, 1 ], [ 3, 2 ] ]
gap> FinCheckQA(F,3);
false
gap> # </L>
gap> 
gap> 
gap> 
gap> # Adding the relation <M>e^2=0</M> results in a finite quotient algebra.
gap> 
gap> # <L>
gap> extendedrels:=[f*e-e*f+h,h*e-e*h-2*e,h*f-f*h+2*f,e^2];
[ (1)*h+(-1)*e*f+(1)*f*e, (-2)*e+(-1)*e*h+(1)*h*e, (2)*f+(-1)*f*h+(1)*h*f, 
  (1)*e^2 ]
gap> extendedrelsNP:=GP2NPList(extendedrels);;
gap> # </L>
gap> 
gap> # With the function <Ref Func="SGrobnerTrace" Style="Text"/> it is possible to
gap> # calculate a Gröbner basis with trace information.
gap> 
gap> # <L>
gap> GB:=SGrobnerTrace(extendedrelsNP);;
gap> # </L>
gap> 
gap> # The Gröbner basis can now be displayed with <Ref Func="PrintNPListTrace"
gap> # Style="Text"/>.
gap> 
gap> # <L>
gap> PrintNPListTrace(GB);
 e^2 
 eh + e 
 fe - ef + h 
 f^2 
 fh - f 
 he - e 
 hf + f 
 h^2 - 2ef + h 
gap> # </L>
gap> 
gap> # Note the fourth relation: <M>f^2=0</M>. To view a trace one can use the
gap> # function <Ref Func="PrintTracePol" Style="Text"/>.
gap> 
gap> # <L>
gap> PrintTracePol(GB[4]);
- 1/12G(1)f^2 + 1/12f^2G(1) + 1/12f^2G(1)h - 1/6fG(1)hf + 1/12G(1)hf^2 + 1/
24G(1)ef^3 + 1/24eG(1)f^3 - 1/8fG(1)ef^2 - 1/8feG(1)f^2 + 1/8f^2G(1)ef + 1/
8f^2eG(1)f - 1/24f^3G(1)e - 1/24f^3eG(1) - 1/24G(2)f^3 + 1/8fG(2)f^2 - 1/
8f^2G(2)f + 1/24f^3G(2) + 1/4G(3)f + 1/4fG(3) + 1/12fG(3)h + 1/12fhG(3) - 1/
12G(3)hf - 1/12hG(3)f - 1/12eG(3)f^2 + 1/6feG(3)f - 1/12f^2eG(3) + 1/24G(
4)f^4 - 1/6fG(4)f^3 + 1/4f^2G(4)f^2 - 1/6f^3G(4)f + 1/24f^4G(4) 
gap> # </L>
gap> 
gap> # This proves that <M>f^2=0</M> is a consequence of <M>e^2=0</M> in the
gap> # universal enveloping algebra of the simple Lie algebra of type A<M>_1</M>.
gap> # <P/>
gap> 
gap> # The function <Ref Func="StrongNormalFormTraceDiff" Style="Text"/> can be used
gap> # to trace the difference between an element and its strong normal form in the
gap> # terms of <C>extendedrels</C>. Apparently, in the first example the strong
gap> # normal form of <C>r</C> is <C>r - s.pol=0</C>.
gap> 
gap> # <L>
gap> r := [[[2,2,2,2,1,1,1,1]],[1]];;
gap> s := StrongNormalFormTraceDiff(r, GB);;
gap> 
gap> PrintNP(s.pol);
 f^4e^4 
gap> PrintTracePol(s);
 f^4G(4)e^2 
gap> PrintNP(AddNP(r,s.pol,1,-1));
 0
gap> # </L>
gap> 
gap> # One more example where the strong normal form is not zero.
gap> 
gap> # <L>
gap> r := [[[3,3,3]],[1]];;
gap> s := StrongNormalFormTraceDiff(r, GB);;
gap> 
gap> PrintNP(s.pol);
 h^3 - h 
gap> PrintTracePol(s);
- G(1) - 1/2G(1)ef - 1/6eG(1)f + 1/3efG(1) + 1/2fG(1)e + 1/2feG(1) + G(
1)h^2 + 1/2G(1)efh + 1/2eG(1)fh + 1/3efG(1)h - 1/3eG(1)hf - 1/2fG(1)eh - 1/
2feG(1)h - 1/6eG(1)ef^2 - 1/6e^2G(1)f^2 + 1/3efG(1)ef + 1/3efeG(1)f - 1/
6ef^2G(1)e - 1/6ef^2eG(1) + 1/2G(2)f - 1/2fG(2) - 1/2G(2)fh + 1/2fG(2)h + 1/
6eG(2)f^2 - 1/3efG(2)f + 1/6ef^2G(2) - 2/3eG(3)h + 1/3ehG(3) + 1/3e^2G(3)f - 
1/3efeG(3) - 1/2G(4)f^2 + fG(4)f - 1/2f^2G(4) + 1/2G(4)f^2h - fG(4)fh + 1/
2f^2G(4)h - 1/6eG(4)f^3 + 1/2efG(4)f^2 - 1/2ef^2G(4)f + 1/6ef^3G(4) 
gap> PrintNP(AddNP(r,s.pol,1,-1));
 h 
gap> # </L>
gap> 
gap> # </Section>
gap> # <#/GAPDoc>
gap> 
gap> STOP_TEST("test12.g",10000);
