/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.resources.components;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.File;
import java.util.Arrays;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.filechooser.FileFilter;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.resources.components.IPropertyControl;
import org.freeplane.core.resources.components.PropertyBean;
import org.freeplane.core.ui.LabelAndMnemonicSetter;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.FileUtils;
import org.freeplane.core.util.TextUtils;

public class PathProperty
extends PropertyBean
implements IPropertyControl {
    private final boolean isDir;
    private final String[] suffixes;
    private String value;
    private JTextField filenameField;
    private JButton selectButton;

    public PathProperty(String name, boolean isDir, String[] suffixes) {
        super(name);
        this.isDir = isDir;
        this.suffixes = suffixes;
    }

    private JFileChooser createFileChooser() {
        JFileChooser fileChooser = UITools.newFileChooser(null);
        if (this.value != null) {
            fileChooser.setSelectedFile(new File(this.path()));
        }
        FileFilter filter = null;
        if (this.isDir) {
            fileChooser.setFileSelectionMode(1);
        } else if (this.suffixes != null) {
            filter = new FileFilter(){

                @Override
                public String getDescription() {
                    return Arrays.asList(PathProperty.this.suffixes).toString();
                }

                @Override
                public boolean accept(File f) {
                    String extension = FileUtils.getExtension(f);
                    for (String suffix : PathProperty.this.suffixes) {
                        if (!suffix.equalsIgnoreCase(extension)) continue;
                        return true;
                    }
                    return false;
                }
            };
        }
        fileChooser.setFileFilter(filter);
        fileChooser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent pE) {
                PathProperty.this.firePropertyChangeEvent();
            }
        });
        return fileChooser;
    }

    private String path() {
        if (this.value == null) {
            return null;
        }
        String freeplaneUserDirectory = ResourceController.getResourceController().getFreeplaneUserDirectory();
        String path = TextUtils.replaceAtBegin(this.value, "{freeplaneuserdir}", freeplaneUserDirectory);
        path = TextUtils.replaceAtBegin(path, "{user.home}", System.getProperty("user.home"));
        return path;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public JComponent getValueComponent() {
        return this.selectButton;
    }

    @Override
    public void appendToForm(DefaultFormBuilder builder) {
        Box box = Box.createHorizontalBox();
        box.setBorder(new EmptyBorder(5, 0, 5, 0));
        this.filenameField = new JTextField();
        this.filenameField.setText(this.value);
        this.filenameField.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                String text = PathProperty.this.filenameField.getText();
                if (text == null || text.length() == 0) {
                    PathProperty.this.filenameField.setText(PathProperty.this.value);
                    JOptionPane.showConfirmDialog(e.getComponent(), TextUtils.getText("OptionPanel.path_property_may_not_be_empty"), "", 2);
                } else {
                    PathProperty.this.value = text;
                }
            }

            @Override
            public void focusGained(FocusEvent e) {
            }
        });
        box.add(this.filenameField);
        box.add(Box.createHorizontalStrut(3));
        this.selectButton = new JButton();
        LabelAndMnemonicSetter.setLabelAndMnemonic(this.selectButton, TextUtils.getText("browse"));
        this.selectButton.addActionListener(new SelectFileAction());
        this.selectButton.setMaximumSize(new Dimension(1000, 1000));
        box.add(this.selectButton);
        this.appendToForm(builder, box);
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (this.selectButton != null) {
            this.selectButton.setEnabled(enabled);
        }
        if (this.filenameField != null) {
            this.filenameField.setEnabled(enabled);
        }
        super.setEnabled(enabled);
    }

    @Override
    public void setValue(String value) {
        this.value = value;
        if (this.filenameField != null) {
            this.filenameField.setText(value);
        }
    }

    private class SelectFileAction
    implements ActionListener {
        private SelectFileAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JFileChooser chooser;
            int result;
            Object source = e.getSource();
            if (source == PathProperty.this.selectButton && (result = (chooser = PathProperty.this.createFileChooser()).showOpenDialog(chooser)) == 0) {
                PathProperty.this.setValue(chooser.getSelectedFile().getAbsolutePath());
            }
        }
    }
}

