/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.print;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JLabel;
import org.freeplane.features.print.Preview;

class BrowseAction
extends AbstractAction {
    private static final long serialVersionUID = 1L;
    private final Runnable pageIndexPainter;
    private final JLabel pageNumber;
    protected int pageStep;
    protected Preview preview;

    public BrowseAction(Preview preview, JLabel pageNumber, int pageStep) {
        this.preview = preview;
        this.pageStep = pageStep;
        this.pageNumber = pageNumber;
        this.pageIndexPainter = new Runnable(){

            @Override
            public void run() {
                BrowseAction.this.paintPageIndex();
            }
        };
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.preview.moveIndex(this.pageStep);
        this.paintPageIndex();
        this.preview.repaint();
        EventQueue.invokeLater(this.pageIndexPainter);
    }

    private String getPageIndexText() {
        return "- " + String.valueOf(1 + this.preview.getPageIndex()) + " -";
    }

    private void paintPageIndex() {
        this.pageNumber.setText(this.getPageIndexText());
        this.pageNumber.paintImmediately(0, 0, this.pageNumber.getWidth(), this.pageNumber.getHeight());
    }
}

