/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.icon;

import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import org.freeplane.core.resources.TranslatedObject;
import org.freeplane.core.util.TextUtils;
import org.freeplane.core.util.collection.ExtendedComboBoxModel;
import org.freeplane.features.filter.condition.ASelectableCondition;
import org.freeplane.features.filter.condition.DefaultConditionRenderer;
import org.freeplane.features.filter.condition.IElementaryConditionController;
import org.freeplane.features.icon.IconContainedCondition;
import org.freeplane.features.icon.IconExistsCondition;
import org.freeplane.features.icon.UIIcon;
import org.freeplane.features.mode.Controller;
import org.freeplane.n3.nanoxml.XMLElement;

class IconConditionController
implements IElementaryConditionController {
    static final String FILTER_ICON = "filter_icon";

    @Override
    public boolean canEditValues(Object property, TranslatedObject simpleCond) {
        return false;
    }

    @Override
    public boolean canHandle(Object selectedItem) {
        if (!(selectedItem instanceof TranslatedObject)) {
            return false;
        }
        TranslatedObject namedObject = (TranslatedObject)selectedItem;
        return namedObject.objectEquals(FILTER_ICON);
    }

    @Override
    public boolean canSelectValues(Object property, TranslatedObject simpleCond) {
        return !simpleCond.objectEquals("filter_exist");
    }

    @Override
    public ASelectableCondition createCondition(Object selectedItem, TranslatedObject simpleCond, Object value, boolean matchCase, boolean approximateMatching, boolean ignoreDiacritics) {
        if (simpleCond.objectEquals("filter_contains")) {
            return value instanceof UIIcon ? new IconContainedCondition(((UIIcon)value).getName()) : null;
        }
        if (simpleCond.objectEquals("filter_exist")) {
            return new IconExistsCondition();
        }
        return null;
    }

    @Override
    public ComboBoxModel getConditionsForProperty(Object property) {
        return new DefaultComboBoxModel<Object>(this.getIconConditionNames());
    }

    @Override
    public ListModel getFilteredProperties() {
        DefaultListModel<TranslatedObject> list = new DefaultListModel<TranslatedObject>();
        list.addElement(TextUtils.createTranslatedString(FILTER_ICON));
        return list;
    }

    public Object[] getIconConditionNames() {
        return new TranslatedObject[]{TextUtils.createTranslatedString("filter_contains"), TextUtils.createTranslatedString("filter_exist")};
    }

    @Override
    public ComboBoxEditor getValueEditor(Object selectedProperty, TranslatedObject selectedCondition) {
        return null;
    }

    @Override
    public ComboBoxModel getValuesForProperty(Object property, TranslatedObject simpleCond) {
        ListModel icons = Controller.getCurrentController().getMap().getIconRegistry().getIconsAsListModel();
        ExtendedComboBoxModel extendedComboBoxModel = new ExtendedComboBoxModel();
        extendedComboBoxModel.setExtensionList(icons);
        return extendedComboBoxModel;
    }

    @Override
    public boolean isCaseDependent(Object property, TranslatedObject simpleCond) {
        return false;
    }

    @Override
    public boolean supportsApproximateMatching(Object property, TranslatedObject simpleCond) {
        return false;
    }

    @Override
    public ASelectableCondition loadCondition(XMLElement element) {
        if (element.getName().equalsIgnoreCase("icon_contained_condition")) {
            return IconContainedCondition.load(element);
        }
        if (element.getName().equalsIgnoreCase("icon_exists_condition")) {
            return IconExistsCondition.load(element);
        }
        return null;
    }

    @Override
    public ListCellRenderer getValueRenderer(Object selectedProperty, TranslatedObject selectedCondition) {
        return new DefaultConditionRenderer("", true);
    }
}

