/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.attribute;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import org.freeplane.api.LengthUnit;
import org.freeplane.api.Quantity;
import org.freeplane.core.extension.IExtension;
import org.freeplane.features.attribute.Attribute;
import org.freeplane.features.attribute.AttributeRegistry;
import org.freeplane.features.attribute.AttributeTableLayoutModel;
import org.freeplane.features.attribute.IAttributeTableModel;
import org.freeplane.features.map.NodeModel;

public class NodeAttributeTableModel
implements IExtension,
IAttributeTableModel {
    private static final DefaultTableModel DUMMY = new DefaultTableModel();
    private static final int CAPACITY_INCREMENT = 10;
    public static final NodeAttributeTableModel EMTPY_ATTRIBUTES = new NodeAttributeTableModel();
    private Vector<Attribute> attributes;
    private AttributeTableLayoutModel layout;
    private Set<TableModelListener> listeners;

    public static NodeAttributeTableModel getModel(NodeModel node) {
        NodeAttributeTableModel attributes = node.getExtension(NodeAttributeTableModel.class);
        return attributes != null ? attributes : EMTPY_ATTRIBUTES;
    }

    public NodeAttributeTableModel() {
        this(0);
    }

    public NodeAttributeTableModel(int size) {
        this.allocateAttributes(size);
    }

    public void addRowNoUndo(NodeModel node, Attribute newAttribute) {
        this.allocateAttributes(10);
        int index = this.getRowCount();
        AttributeRegistry registry = AttributeRegistry.getRegistry(node.getMap());
        registry.registry(newAttribute);
        this.attributes.add(newAttribute);
        this.fireTableRowsInserted(node, index, index);
    }

    public void addTableModelListener(TableModelListener listener) {
        if (this.listeners == null) {
            this.listeners = new LinkedHashSet<TableModelListener>();
        }
        this.listeners.add(listener);
    }

    private void allocateAttributes(int size) {
        if (this.attributes == null && size > 0) {
            this.attributes = new Vector(size, 10);
        }
    }

    public void fireTableCellUpdated(NodeModel node, int row, int column) {
        this.fireTableChanged(node, new TableModelEvent(DUMMY, row, row, column));
    }

    private void fireTableChanged(NodeModel node, TableModelEvent e) {
        node.getMap().getNodeChangeAnnouncer().nodeChanged(node, NodeAttributeTableModel.class, null, null);
        if (this.listeners != null) {
            ArrayList<TableModelListener> arrayList = new ArrayList<TableModelListener>(this.listeners);
            for (TableModelListener listener : arrayList) {
                listener.tableChanged(e);
            }
        }
    }

    public void fireTableRowsDeleted(NodeModel node, int firstRow, int lastRow) {
        this.fireTableChanged(node, new TableModelEvent(DUMMY, firstRow, lastRow, -1, -1));
    }

    public void fireTableRowsInserted(NodeModel node, int firstRow, int lastRow) {
        this.fireTableChanged(node, new TableModelEvent(DUMMY, firstRow, lastRow, -1, 1));
    }

    public void fireTableRowsUpdated(NodeModel node, int firstRow, int lastRow) {
        this.fireTableChanged(node, new TableModelEvent(DUMMY, firstRow, lastRow, -1, 0));
    }

    @Override
    public Attribute getAttribute(int row) {
        return this.attributes.get(row);
    }

    public List<String> getAttributeKeyList() {
        Vector<String> returnValue = new Vector<String>();
        for (Attribute attr : this.getAttributes()) {
            returnValue.add(attr.getName());
        }
        return returnValue;
    }

    public int getAttributeIndex(String name) {
        if (name == null) {
            return -1;
        }
        int pos = 0;
        for (Attribute attr : this.getAttributes()) {
            if (name.equals(attr.getName())) {
                return pos;
            }
            ++pos;
        }
        return -1;
    }

    public int getAttributeIndex(Attribute searchedAttribute) {
        int pos = 0;
        for (Attribute attribute : this.getAttributes()) {
            if (attribute == searchedAttribute) {
                return pos;
            }
            ++pos;
        }
        return -1;
    }

    public Vector<Attribute> getAttributes() {
        this.allocateAttributes(10);
        return this.attributes;
    }

    public int getAttributeTableLength() {
        return this.getRowCount();
    }

    @Override
    public Quantity<LengthUnit> getColumnWidth(int col) {
        return this.getLayout().getColumnWidth(col);
    }

    public AttributeTableLayoutModel getLayout() {
        if (this.layout == null) {
            this.layout = new AttributeTableLayoutModel();
        }
        return this.layout;
    }

    public Object getName(int row) {
        Attribute attr = this.attributes.get(row);
        return attr.getName();
    }

    @Override
    public int getRowCount() {
        return this.attributes == null ? 0 : this.attributes.size();
    }

    public Object getValue(int row) {
        Attribute attr = this.attributes.get(row);
        return attr.getValue();
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (this.attributes != null) {
            switch (col) {
                case 0: {
                    return this.getName(row);
                }
                case 1: {
                    return this.getValue(row);
                }
            }
        }
        return null;
    }

    public void removeTableModelListener(TableModelListener listener) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove(listener);
    }

    public void setName(NodeModel node, int row, Object newName) {
        Attribute attr = this.attributes.get(row);
        attr.setName(newName.toString());
        this.fireTableRowsUpdated(node, row, row);
    }

    public void setValue(NodeModel node, int row, Object newValue) {
        Attribute attr = this.attributes.get(row);
        attr.setValue(newValue);
        this.fireTableRowsUpdated(node, row, row);
    }

    public void setValueAt(NodeModel node, Object value, int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                this.setName(node, rowIndex, value);
                return;
            }
            case 1: {
                this.setValue(node, rowIndex, value);
                return;
            }
        }
        throw new ArrayIndexOutOfBoundsException(columnIndex + " >= 2");
    }

    @Override
    public int targetRow(int row) {
        return row;
    }
}

