/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.ui.svgicons;

import com.formdev.flatlaf.FlatLaf;
import com.kitfox.svg.SVGCache;
import com.kitfox.svg.SVGDiagram;
import com.kitfox.svg.SVGUniverse;
import com.kitfox.svg.app.beans.SVGIcon;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Icon;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.ui.svgicons.CachingIcon;
import org.freeplane.core.ui.svgicons.FreeplaneIconFactory;
import org.freeplane.core.ui.svgicons.ReplacingInputStream;
import org.freeplane.core.util.ColorUtils;
import org.freeplane.core.util.Compat;
import org.freeplane.core.util.LogUtils;
import org.freeplane.features.icon.factory.IconFactory;

class SVGIconCreator {
    private static final Pattern PROPERTY_REFERENCE = Pattern.compile("\\$\\{[\\w.]+\\}");
    private static final String UI_COLOR_REPLACEMENTS_PROPERTY_FOR = "uiColorReplacementsFor";
    private static final String DARK_LOOK_AND_FEELS = "DarkLookAndFeels";
    private static final String LIGHT_LOOK_AND_FEELS = "LightLookAndFeels";
    private static final String FLAT_LOOK_AND_FEELS = "FlatLookAndFeels";
    private static String uiColorReplacements = null;
    private final URL url;
    private int heightPixels = -1;
    private int widthPixels = -1;
    private URI svgUri;
    private boolean diagramWasAlreadyLoaded;

    private static void initializeAccentColorReplacements() {
        if (uiColorReplacements == null) {
            LookAndFeel lookAndFeel = UIManager.getLookAndFeel();
            String lookAndFeelId = lookAndFeel.getName().replaceAll("\\W+", "");
            String lafSpecificReplacementPropertyName = UI_COLOR_REPLACEMENTS_PROPERTY_FOR + lookAndFeelId;
            String lafSpecificReplacementPropertyValue = ResourceController.getResourceController().getProperty(lafSpecificReplacementPropertyName, null);
            String uiColorReplacementsWithPlaceholder = null;
            if (lafSpecificReplacementPropertyValue != null && !lafSpecificReplacementPropertyValue.isEmpty()) {
                uiColorReplacementsWithPlaceholder = lafSpecificReplacementPropertyValue;
            } else if (!Compat.isApplet() && lookAndFeel instanceof FlatLaf) {
                String flatReplacementPropertyName = "uiColorReplacementsForFlatLookAndFeels";
                String flatReplacementPropertyValue = ResourceController.getResourceController().getProperty(flatReplacementPropertyName, null);
                if (flatReplacementPropertyValue != null && !flatReplacementPropertyValue.isEmpty()) {
                    uiColorReplacementsWithPlaceholder = flatReplacementPropertyValue;
                }
            }
            if (uiColorReplacementsWithPlaceholder == null) {
                String defaultReplacementPropertyValue;
                String defaultReplacementPropertyName = UI_COLOR_REPLACEMENTS_PROPERTY_FOR + (UITools.isLightLookAndFeelInstalled() ? LIGHT_LOOK_AND_FEELS : DARK_LOOK_AND_FEELS);
                uiColorReplacementsWithPlaceholder = defaultReplacementPropertyValue = ResourceController.getResourceController().getProperty(defaultReplacementPropertyName);
            }
            uiColorReplacements = SVGIconCreator.replacePropertyReferences(uiColorReplacementsWithPlaceholder);
        }
    }

    private static String replacePropertyReferences(String uiColorReplacementsWithPlaceholder) {
        Matcher matcher = PROPERTY_REFERENCE.matcher(uiColorReplacementsWithPlaceholder);
        matcher.reset();
        boolean result = matcher.find();
        if (result) {
            StringBuffer sb = new StringBuffer();
            do {
                String match;
                String propertyName;
                Color accentColor;
                if ((accentColor = UIManager.getColor(propertyName = (match = matcher.group()).substring(2, match.length() - 1))) == null) {
                    accentColor = Color.BLUE;
                    LogUtils.severe("Color property " + propertyName + " required by replacement " + uiColorReplacementsWithPlaceholder + " is not defined, " + accentColor + " is used");
                }
                matcher.appendReplacement(sb, ColorUtils.colorToString(accentColor));
            } while (result = matcher.find());
            matcher.appendTail(sb);
            return sb.toString();
        }
        return uiColorReplacementsWithPlaceholder;
    }

    SVGIconCreator(URL url) {
        this.url = url;
    }

    Icon createIcon() {
        return new CachingIcon(this::createSvgIcon);
    }

    Dimension getSize() {
        SVGIcon icon = this.createSvgIcon();
        int iconWidth = icon.getIconWidth();
        int iconHeight = icon.getIconHeight();
        if (!this.diagramWasAlreadyLoaded) {
            SVGUniverse svgUniverse = SVGCache.getSVGUniverse();
            svgUniverse.removeDocument(this.svgUri);
        }
        return new Dimension(iconWidth, iconHeight);
    }

    Image loadImage() {
        SVGIcon icon = this.createSvgIcon();
        int iconWidth = icon.getIconWidth();
        int iconHeight = icon.getIconHeight();
        BufferedImage image = new BufferedImage(iconWidth, iconHeight, 2);
        Graphics2D graphics = image.createGraphics();
        icon.paintIcon(null, (Graphics)graphics, 0, 0);
        graphics.dispose();
        if (!this.diagramWasAlreadyLoaded) {
            SVGUniverse svgUniverse = SVGCache.getSVGUniverse();
            svgUniverse.removeDocument(this.svgUri);
        }
        return image;
    }

    private SVGIcon createSvgIcon() {
        SVGUniverse svgUniverse = SVGCache.getSVGUniverse();
        SVGIcon icon = new SVGIcon();
        try {
            this.load(svgUniverse);
            SVGDiagram diagram = svgUniverse.getDiagram(this.svgUri);
            if (this.heightPixels >= 0 && this.widthPixels >= 0) {
                icon.setPreferredSize(new Dimension(this.widthPixels, this.heightPixels));
            } else if (this.heightPixels >= 0 || this.widthPixels >= 0) {
                float aspectRatio = diagram.getHeight() / diagram.getWidth();
                if (this.heightPixels >= 0) {
                    icon.setPreferredSize(new Dimension((int)((float)this.heightPixels / aspectRatio), this.heightPixels));
                } else {
                    icon.setPreferredSize(new Dimension(this.widthPixels, (int)((float)this.widthPixels * aspectRatio)));
                }
            }
            icon.setAutosize(4);
            icon.setAntiAlias(FreeplaneIconFactory.isSvgAntialiasEnabled());
            icon.setSvgURI(this.svgUri);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        IconFactory.getInstance().registerIcon((Icon)icon, this.url);
        return icon;
    }

    private void load(SVGUniverse svgUniverse) throws IOException {
        boolean urlContainsAccentColorReplacementQuery = this.url.toString().endsWith("?useAccentColor=true");
        if (!urlContainsAccentColorReplacementQuery) {
            try {
                this.svgUri = new URI(this.url.toString());
                boolean bl = this.diagramWasAlreadyLoaded = svgUniverse.getDiagram(this.svgUri, false) != null;
                if (!this.diagramWasAlreadyLoaded) {
                    svgUniverse.loadSVG(this.url);
                }
                return;
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        String internalUri = this.getInternalUri();
        this.svgUri = svgUniverse.getStreamBuiltURI(internalUri);
        boolean bl = this.diagramWasAlreadyLoaded = svgUniverse.getDiagram(this.svgUri, false) != null;
        if (!this.diagramWasAlreadyLoaded) {
            svgUniverse.loadSVG(this.openStream(urlContainsAccentColorReplacementQuery), internalUri);
        }
    }

    private String getInternalUri() {
        String query = this.url.getQuery();
        return query == null ? this.url.getPath() : this.url.getPath() + "?" + this.url.getQuery();
    }

    private InputStream openStream(boolean urlContainsAccentColorReplacementQuery) throws IOException {
        SVGIconCreator.initializeAccentColorReplacements();
        InputStream stream = (urlContainsAccentColorReplacementQuery ? this.urlWithoutQuery() : this.url).openStream();
        if (!uiColorReplacements.isEmpty() && urlContainsAccentColorReplacementQuery) {
            return ReplacingInputStream.replace(stream, uiColorReplacements);
        }
        return stream;
    }

    private URL urlWithoutQuery() throws MalformedURLException {
        String urlString = this.url.toString();
        int queryIndex = urlString.lastIndexOf(63);
        return new URL(urlString.substring(0, queryIndex));
    }

    SVGIconCreator setHeight(int heightPixels) {
        this.heightPixels = heightPixels;
        return this;
    }

    SVGIconCreator setWidth(int widthPixels) {
        this.widthPixels = widthPixels;
        return this;
    }
}

