"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/index.ts
var index_exports = {};
__export(index_exports, {
  AccessDenied: () => AccessDenied,
  AssociateAliasCommand: () => AssociateAliasCommand,
  AssociateDistributionTenantWebACLCommand: () => AssociateDistributionTenantWebACLCommand,
  AssociateDistributionWebACLCommand: () => AssociateDistributionWebACLCommand,
  BatchTooLarge: () => BatchTooLarge,
  CNAMEAlreadyExists: () => CNAMEAlreadyExists,
  CachePolicyAlreadyExists: () => CachePolicyAlreadyExists,
  CachePolicyCookieBehavior: () => CachePolicyCookieBehavior,
  CachePolicyHeaderBehavior: () => CachePolicyHeaderBehavior,
  CachePolicyInUse: () => CachePolicyInUse,
  CachePolicyQueryStringBehavior: () => CachePolicyQueryStringBehavior,
  CachePolicyType: () => CachePolicyType,
  CannotChangeImmutablePublicKeyFields: () => CannotChangeImmutablePublicKeyFields,
  CannotDeleteEntityWhileInUse: () => CannotDeleteEntityWhileInUse,
  CannotUpdateEntityWhileInUse: () => CannotUpdateEntityWhileInUse,
  CertificateSource: () => CertificateSource,
  CertificateTransparencyLoggingPreference: () => CertificateTransparencyLoggingPreference,
  CloudFront: () => CloudFront,
  CloudFrontClient: () => CloudFrontClient,
  CloudFrontOriginAccessIdentityAlreadyExists: () => CloudFrontOriginAccessIdentityAlreadyExists,
  CloudFrontOriginAccessIdentityInUse: () => CloudFrontOriginAccessIdentityInUse,
  CloudFrontServiceException: () => CloudFrontServiceException,
  ConnectionMode: () => ConnectionMode,
  ContinuousDeploymentPolicyAlreadyExists: () => ContinuousDeploymentPolicyAlreadyExists,
  ContinuousDeploymentPolicyInUse: () => ContinuousDeploymentPolicyInUse,
  ContinuousDeploymentPolicyType: () => ContinuousDeploymentPolicyType,
  CopyDistributionCommand: () => CopyDistributionCommand,
  CopyDistributionResultFilterSensitiveLog: () => CopyDistributionResultFilterSensitiveLog,
  CreateAnycastIpListCommand: () => CreateAnycastIpListCommand,
  CreateCachePolicyCommand: () => CreateCachePolicyCommand,
  CreateCloudFrontOriginAccessIdentityCommand: () => CreateCloudFrontOriginAccessIdentityCommand,
  CreateConnectionGroupCommand: () => CreateConnectionGroupCommand,
  CreateContinuousDeploymentPolicyCommand: () => CreateContinuousDeploymentPolicyCommand,
  CreateDistributionCommand: () => CreateDistributionCommand,
  CreateDistributionRequestFilterSensitiveLog: () => CreateDistributionRequestFilterSensitiveLog,
  CreateDistributionResultFilterSensitiveLog: () => CreateDistributionResultFilterSensitiveLog,
  CreateDistributionTenantCommand: () => CreateDistributionTenantCommand,
  CreateDistributionWithTagsCommand: () => CreateDistributionWithTagsCommand,
  CreateDistributionWithTagsRequestFilterSensitiveLog: () => CreateDistributionWithTagsRequestFilterSensitiveLog,
  CreateDistributionWithTagsResultFilterSensitiveLog: () => CreateDistributionWithTagsResultFilterSensitiveLog,
  CreateFieldLevelEncryptionConfigCommand: () => CreateFieldLevelEncryptionConfigCommand,
  CreateFieldLevelEncryptionProfileCommand: () => CreateFieldLevelEncryptionProfileCommand,
  CreateFunctionCommand: () => CreateFunctionCommand,
  CreateFunctionRequestFilterSensitiveLog: () => CreateFunctionRequestFilterSensitiveLog,
  CreateInvalidationCommand: () => CreateInvalidationCommand,
  CreateInvalidationForDistributionTenantCommand: () => CreateInvalidationForDistributionTenantCommand,
  CreateKeyGroupCommand: () => CreateKeyGroupCommand,
  CreateKeyValueStoreCommand: () => CreateKeyValueStoreCommand,
  CreateMonitoringSubscriptionCommand: () => CreateMonitoringSubscriptionCommand,
  CreateOriginAccessControlCommand: () => CreateOriginAccessControlCommand,
  CreateOriginRequestPolicyCommand: () => CreateOriginRequestPolicyCommand,
  CreatePublicKeyCommand: () => CreatePublicKeyCommand,
  CreateRealtimeLogConfigCommand: () => CreateRealtimeLogConfigCommand,
  CreateResponseHeadersPolicyCommand: () => CreateResponseHeadersPolicyCommand,
  CreateStreamingDistributionCommand: () => CreateStreamingDistributionCommand,
  CreateStreamingDistributionWithTagsCommand: () => CreateStreamingDistributionWithTagsCommand,
  CreateVpcOriginCommand: () => CreateVpcOriginCommand,
  CustomHeadersFilterSensitiveLog: () => CustomHeadersFilterSensitiveLog,
  CustomizationActionType: () => CustomizationActionType,
  DeleteAnycastIpListCommand: () => DeleteAnycastIpListCommand,
  DeleteCachePolicyCommand: () => DeleteCachePolicyCommand,
  DeleteCloudFrontOriginAccessIdentityCommand: () => DeleteCloudFrontOriginAccessIdentityCommand,
  DeleteConnectionGroupCommand: () => DeleteConnectionGroupCommand,
  DeleteContinuousDeploymentPolicyCommand: () => DeleteContinuousDeploymentPolicyCommand,
  DeleteDistributionCommand: () => DeleteDistributionCommand,
  DeleteDistributionTenantCommand: () => DeleteDistributionTenantCommand,
  DeleteFieldLevelEncryptionConfigCommand: () => DeleteFieldLevelEncryptionConfigCommand,
  DeleteFieldLevelEncryptionProfileCommand: () => DeleteFieldLevelEncryptionProfileCommand,
  DeleteFunctionCommand: () => DeleteFunctionCommand,
  DeleteKeyGroupCommand: () => DeleteKeyGroupCommand,
  DeleteKeyValueStoreCommand: () => DeleteKeyValueStoreCommand,
  DeleteMonitoringSubscriptionCommand: () => DeleteMonitoringSubscriptionCommand,
  DeleteOriginAccessControlCommand: () => DeleteOriginAccessControlCommand,
  DeleteOriginRequestPolicyCommand: () => DeleteOriginRequestPolicyCommand,
  DeletePublicKeyCommand: () => DeletePublicKeyCommand,
  DeleteRealtimeLogConfigCommand: () => DeleteRealtimeLogConfigCommand,
  DeleteResponseHeadersPolicyCommand: () => DeleteResponseHeadersPolicyCommand,
  DeleteStreamingDistributionCommand: () => DeleteStreamingDistributionCommand,
  DeleteVpcOriginCommand: () => DeleteVpcOriginCommand,
  DescribeFunctionCommand: () => DescribeFunctionCommand,
  DescribeKeyValueStoreCommand: () => DescribeKeyValueStoreCommand,
  DisassociateDistributionTenantWebACLCommand: () => DisassociateDistributionTenantWebACLCommand,
  DisassociateDistributionWebACLCommand: () => DisassociateDistributionWebACLCommand,
  DistributionAlreadyExists: () => DistributionAlreadyExists,
  DistributionConfigFilterSensitiveLog: () => DistributionConfigFilterSensitiveLog,
  DistributionConfigWithTagsFilterSensitiveLog: () => DistributionConfigWithTagsFilterSensitiveLog,
  DistributionFilterSensitiveLog: () => DistributionFilterSensitiveLog,
  DistributionListFilterSensitiveLog: () => DistributionListFilterSensitiveLog,
  DistributionNotDisabled: () => DistributionNotDisabled,
  DistributionResourceType: () => DistributionResourceType,
  DistributionSummaryFilterSensitiveLog: () => DistributionSummaryFilterSensitiveLog,
  DnsConfigurationStatus: () => DnsConfigurationStatus,
  DomainStatus: () => DomainStatus,
  EntityAlreadyExists: () => EntityAlreadyExists,
  EntityLimitExceeded: () => EntityLimitExceeded,
  EntityNotFound: () => EntityNotFound,
  EntitySizeLimitExceeded: () => EntitySizeLimitExceeded,
  EventType: () => EventType,
  FieldLevelEncryptionConfigAlreadyExists: () => FieldLevelEncryptionConfigAlreadyExists,
  FieldLevelEncryptionConfigInUse: () => FieldLevelEncryptionConfigInUse,
  FieldLevelEncryptionProfileAlreadyExists: () => FieldLevelEncryptionProfileAlreadyExists,
  FieldLevelEncryptionProfileInUse: () => FieldLevelEncryptionProfileInUse,
  FieldLevelEncryptionProfileSizeExceeded: () => FieldLevelEncryptionProfileSizeExceeded,
  Format: () => Format,
  FrameOptionsList: () => FrameOptionsList,
  FunctionAlreadyExists: () => FunctionAlreadyExists,
  FunctionInUse: () => FunctionInUse,
  FunctionRuntime: () => FunctionRuntime,
  FunctionSizeLimitExceeded: () => FunctionSizeLimitExceeded,
  FunctionStage: () => FunctionStage,
  GeoRestrictionType: () => GeoRestrictionType,
  GetAnycastIpListCommand: () => GetAnycastIpListCommand,
  GetCachePolicyCommand: () => GetCachePolicyCommand,
  GetCachePolicyConfigCommand: () => GetCachePolicyConfigCommand,
  GetCloudFrontOriginAccessIdentityCommand: () => GetCloudFrontOriginAccessIdentityCommand,
  GetCloudFrontOriginAccessIdentityConfigCommand: () => GetCloudFrontOriginAccessIdentityConfigCommand,
  GetConnectionGroupByRoutingEndpointCommand: () => GetConnectionGroupByRoutingEndpointCommand,
  GetConnectionGroupCommand: () => GetConnectionGroupCommand,
  GetContinuousDeploymentPolicyCommand: () => GetContinuousDeploymentPolicyCommand,
  GetContinuousDeploymentPolicyConfigCommand: () => GetContinuousDeploymentPolicyConfigCommand,
  GetDistributionCommand: () => GetDistributionCommand,
  GetDistributionConfigCommand: () => GetDistributionConfigCommand,
  GetDistributionConfigResultFilterSensitiveLog: () => GetDistributionConfigResultFilterSensitiveLog,
  GetDistributionResultFilterSensitiveLog: () => GetDistributionResultFilterSensitiveLog,
  GetDistributionTenantByDomainCommand: () => GetDistributionTenantByDomainCommand,
  GetDistributionTenantCommand: () => GetDistributionTenantCommand,
  GetFieldLevelEncryptionCommand: () => GetFieldLevelEncryptionCommand,
  GetFieldLevelEncryptionConfigCommand: () => GetFieldLevelEncryptionConfigCommand,
  GetFieldLevelEncryptionProfileCommand: () => GetFieldLevelEncryptionProfileCommand,
  GetFieldLevelEncryptionProfileConfigCommand: () => GetFieldLevelEncryptionProfileConfigCommand,
  GetFunctionCommand: () => GetFunctionCommand,
  GetFunctionResultFilterSensitiveLog: () => GetFunctionResultFilterSensitiveLog,
  GetInvalidationCommand: () => GetInvalidationCommand,
  GetInvalidationForDistributionTenantCommand: () => GetInvalidationForDistributionTenantCommand,
  GetKeyGroupCommand: () => GetKeyGroupCommand,
  GetKeyGroupConfigCommand: () => GetKeyGroupConfigCommand,
  GetManagedCertificateDetailsCommand: () => GetManagedCertificateDetailsCommand,
  GetMonitoringSubscriptionCommand: () => GetMonitoringSubscriptionCommand,
  GetOriginAccessControlCommand: () => GetOriginAccessControlCommand,
  GetOriginAccessControlConfigCommand: () => GetOriginAccessControlConfigCommand,
  GetOriginRequestPolicyCommand: () => GetOriginRequestPolicyCommand,
  GetOriginRequestPolicyConfigCommand: () => GetOriginRequestPolicyConfigCommand,
  GetPublicKeyCommand: () => GetPublicKeyCommand,
  GetPublicKeyConfigCommand: () => GetPublicKeyConfigCommand,
  GetRealtimeLogConfigCommand: () => GetRealtimeLogConfigCommand,
  GetResponseHeadersPolicyCommand: () => GetResponseHeadersPolicyCommand,
  GetResponseHeadersPolicyConfigCommand: () => GetResponseHeadersPolicyConfigCommand,
  GetStreamingDistributionCommand: () => GetStreamingDistributionCommand,
  GetStreamingDistributionConfigCommand: () => GetStreamingDistributionConfigCommand,
  GetVpcOriginCommand: () => GetVpcOriginCommand,
  HttpVersion: () => HttpVersion,
  ICPRecordalStatus: () => ICPRecordalStatus,
  IllegalDelete: () => IllegalDelete,
  IllegalFieldLevelEncryptionConfigAssociationWithCacheBehavior: () => IllegalFieldLevelEncryptionConfigAssociationWithCacheBehavior,
  IllegalOriginAccessConfiguration: () => IllegalOriginAccessConfiguration,
  IllegalUpdate: () => IllegalUpdate,
  ImportSourceType: () => ImportSourceType,
  InconsistentQuantities: () => InconsistentQuantities,
  InvalidArgument: () => InvalidArgument,
  InvalidAssociation: () => InvalidAssociation,
  InvalidDefaultRootObject: () => InvalidDefaultRootObject,
  InvalidDomainNameForOriginAccessControl: () => InvalidDomainNameForOriginAccessControl,
  InvalidErrorCode: () => InvalidErrorCode,
  InvalidForwardCookies: () => InvalidForwardCookies,
  InvalidFunctionAssociation: () => InvalidFunctionAssociation,
  InvalidGeoRestrictionParameter: () => InvalidGeoRestrictionParameter,
  InvalidHeadersForS3Origin: () => InvalidHeadersForS3Origin,
  InvalidIfMatchVersion: () => InvalidIfMatchVersion,
  InvalidLambdaFunctionAssociation: () => InvalidLambdaFunctionAssociation,
  InvalidLocationCode: () => InvalidLocationCode,
  InvalidMinimumProtocolVersion: () => InvalidMinimumProtocolVersion,
  InvalidOrigin: () => InvalidOrigin,
  InvalidOriginAccessControl: () => InvalidOriginAccessControl,
  InvalidOriginAccessIdentity: () => InvalidOriginAccessIdentity,
  InvalidOriginKeepaliveTimeout: () => InvalidOriginKeepaliveTimeout,
  InvalidOriginReadTimeout: () => InvalidOriginReadTimeout,
  InvalidProtocolSettings: () => InvalidProtocolSettings,
  InvalidQueryStringParameters: () => InvalidQueryStringParameters,
  InvalidRelativePath: () => InvalidRelativePath,
  InvalidRequiredProtocol: () => InvalidRequiredProtocol,
  InvalidResponseCode: () => InvalidResponseCode,
  InvalidTTLOrder: () => InvalidTTLOrder,
  InvalidTagging: () => InvalidTagging,
  InvalidViewerCertificate: () => InvalidViewerCertificate,
  InvalidWebACLId: () => InvalidWebACLId,
  ItemSelection: () => ItemSelection,
  KeyGroupAlreadyExists: () => KeyGroupAlreadyExists,
  ListAnycastIpListsCommand: () => ListAnycastIpListsCommand,
  ListCachePoliciesCommand: () => ListCachePoliciesCommand,
  ListCloudFrontOriginAccessIdentitiesCommand: () => ListCloudFrontOriginAccessIdentitiesCommand,
  ListConflictingAliasesCommand: () => ListConflictingAliasesCommand,
  ListConnectionGroupsCommand: () => ListConnectionGroupsCommand,
  ListContinuousDeploymentPoliciesCommand: () => ListContinuousDeploymentPoliciesCommand,
  ListDistributionTenantsByCustomizationCommand: () => ListDistributionTenantsByCustomizationCommand,
  ListDistributionTenantsCommand: () => ListDistributionTenantsCommand,
  ListDistributionsByAnycastIpListIdCommand: () => ListDistributionsByAnycastIpListIdCommand,
  ListDistributionsByAnycastIpListIdResultFilterSensitiveLog: () => ListDistributionsByAnycastIpListIdResultFilterSensitiveLog,
  ListDistributionsByCachePolicyIdCommand: () => ListDistributionsByCachePolicyIdCommand,
  ListDistributionsByConnectionModeCommand: () => ListDistributionsByConnectionModeCommand,
  ListDistributionsByConnectionModeResultFilterSensitiveLog: () => ListDistributionsByConnectionModeResultFilterSensitiveLog,
  ListDistributionsByKeyGroupCommand: () => ListDistributionsByKeyGroupCommand,
  ListDistributionsByOriginRequestPolicyIdCommand: () => ListDistributionsByOriginRequestPolicyIdCommand,
  ListDistributionsByRealtimeLogConfigCommand: () => ListDistributionsByRealtimeLogConfigCommand,
  ListDistributionsByRealtimeLogConfigResultFilterSensitiveLog: () => ListDistributionsByRealtimeLogConfigResultFilterSensitiveLog,
  ListDistributionsByResponseHeadersPolicyIdCommand: () => ListDistributionsByResponseHeadersPolicyIdCommand,
  ListDistributionsByVpcOriginIdCommand: () => ListDistributionsByVpcOriginIdCommand,
  ListDistributionsByWebACLIdCommand: () => ListDistributionsByWebACLIdCommand,
  ListDistributionsByWebACLIdResultFilterSensitiveLog: () => ListDistributionsByWebACLIdResultFilterSensitiveLog,
  ListDistributionsCommand: () => ListDistributionsCommand,
  ListDistributionsResultFilterSensitiveLog: () => ListDistributionsResultFilterSensitiveLog,
  ListDomainConflictsCommand: () => ListDomainConflictsCommand,
  ListFieldLevelEncryptionConfigsCommand: () => ListFieldLevelEncryptionConfigsCommand,
  ListFieldLevelEncryptionProfilesCommand: () => ListFieldLevelEncryptionProfilesCommand,
  ListFunctionsCommand: () => ListFunctionsCommand,
  ListInvalidationsCommand: () => ListInvalidationsCommand,
  ListInvalidationsForDistributionTenantCommand: () => ListInvalidationsForDistributionTenantCommand,
  ListKeyGroupsCommand: () => ListKeyGroupsCommand,
  ListKeyValueStoresCommand: () => ListKeyValueStoresCommand,
  ListOriginAccessControlsCommand: () => ListOriginAccessControlsCommand,
  ListOriginRequestPoliciesCommand: () => ListOriginRequestPoliciesCommand,
  ListPublicKeysCommand: () => ListPublicKeysCommand,
  ListRealtimeLogConfigsCommand: () => ListRealtimeLogConfigsCommand,
  ListResponseHeadersPoliciesCommand: () => ListResponseHeadersPoliciesCommand,
  ListStreamingDistributionsCommand: () => ListStreamingDistributionsCommand,
  ListTagsForResourceCommand: () => ListTagsForResourceCommand,
  ListVpcOriginsCommand: () => ListVpcOriginsCommand,
  ManagedCertificateStatus: () => ManagedCertificateStatus,
  Method: () => Method,
  MinimumProtocolVersion: () => MinimumProtocolVersion,
  MissingBody: () => MissingBody,
  MonitoringSubscriptionAlreadyExists: () => MonitoringSubscriptionAlreadyExists,
  NoSuchCachePolicy: () => NoSuchCachePolicy,
  NoSuchCloudFrontOriginAccessIdentity: () => NoSuchCloudFrontOriginAccessIdentity,
  NoSuchContinuousDeploymentPolicy: () => NoSuchContinuousDeploymentPolicy,
  NoSuchDistribution: () => NoSuchDistribution,
  NoSuchFieldLevelEncryptionConfig: () => NoSuchFieldLevelEncryptionConfig,
  NoSuchFieldLevelEncryptionProfile: () => NoSuchFieldLevelEncryptionProfile,
  NoSuchFunctionExists: () => NoSuchFunctionExists,
  NoSuchInvalidation: () => NoSuchInvalidation,
  NoSuchMonitoringSubscription: () => NoSuchMonitoringSubscription,
  NoSuchOrigin: () => NoSuchOrigin,
  NoSuchOriginAccessControl: () => NoSuchOriginAccessControl,
  NoSuchOriginRequestPolicy: () => NoSuchOriginRequestPolicy,
  NoSuchPublicKey: () => NoSuchPublicKey,
  NoSuchRealtimeLogConfig: () => NoSuchRealtimeLogConfig,
  NoSuchResource: () => NoSuchResource,
  NoSuchResponseHeadersPolicy: () => NoSuchResponseHeadersPolicy,
  NoSuchStreamingDistribution: () => NoSuchStreamingDistribution,
  OriginAccessControlAlreadyExists: () => OriginAccessControlAlreadyExists,
  OriginAccessControlInUse: () => OriginAccessControlInUse,
  OriginAccessControlOriginTypes: () => OriginAccessControlOriginTypes,
  OriginAccessControlSigningBehaviors: () => OriginAccessControlSigningBehaviors,
  OriginAccessControlSigningProtocols: () => OriginAccessControlSigningProtocols,
  OriginCustomHeaderFilterSensitiveLog: () => OriginCustomHeaderFilterSensitiveLog,
  OriginFilterSensitiveLog: () => OriginFilterSensitiveLog,
  OriginGroupSelectionCriteria: () => OriginGroupSelectionCriteria,
  OriginProtocolPolicy: () => OriginProtocolPolicy,
  OriginRequestPolicyAlreadyExists: () => OriginRequestPolicyAlreadyExists,
  OriginRequestPolicyCookieBehavior: () => OriginRequestPolicyCookieBehavior,
  OriginRequestPolicyHeaderBehavior: () => OriginRequestPolicyHeaderBehavior,
  OriginRequestPolicyInUse: () => OriginRequestPolicyInUse,
  OriginRequestPolicyQueryStringBehavior: () => OriginRequestPolicyQueryStringBehavior,
  OriginRequestPolicyType: () => OriginRequestPolicyType,
  OriginsFilterSensitiveLog: () => OriginsFilterSensitiveLog,
  PreconditionFailed: () => PreconditionFailed,
  PriceClass: () => PriceClass,
  PublicKeyAlreadyExists: () => PublicKeyAlreadyExists,
  PublicKeyInUse: () => PublicKeyInUse,
  PublishFunctionCommand: () => PublishFunctionCommand,
  QueryArgProfileEmpty: () => QueryArgProfileEmpty,
  RealtimeLogConfigAlreadyExists: () => RealtimeLogConfigAlreadyExists,
  RealtimeLogConfigInUse: () => RealtimeLogConfigInUse,
  RealtimeLogConfigOwnerMismatch: () => RealtimeLogConfigOwnerMismatch,
  RealtimeMetricsSubscriptionStatus: () => RealtimeMetricsSubscriptionStatus,
  ReferrerPolicyList: () => ReferrerPolicyList,
  ResourceInUse: () => ResourceInUse,
  ResourceNotDisabled: () => ResourceNotDisabled,
  ResponseHeadersPolicyAccessControlAllowMethodsValues: () => ResponseHeadersPolicyAccessControlAllowMethodsValues,
  ResponseHeadersPolicyAlreadyExists: () => ResponseHeadersPolicyAlreadyExists,
  ResponseHeadersPolicyInUse: () => ResponseHeadersPolicyInUse,
  ResponseHeadersPolicyType: () => ResponseHeadersPolicyType,
  SSLSupportMethod: () => SSLSupportMethod,
  SslProtocol: () => SslProtocol,
  StagingDistributionInUse: () => StagingDistributionInUse,
  StreamingDistributionAlreadyExists: () => StreamingDistributionAlreadyExists,
  StreamingDistributionNotDisabled: () => StreamingDistributionNotDisabled,
  TagResourceCommand: () => TagResourceCommand,
  TestFunctionCommand: () => TestFunctionCommand,
  TestFunctionFailed: () => TestFunctionFailed,
  TestFunctionRequestFilterSensitiveLog: () => TestFunctionRequestFilterSensitiveLog,
  TestFunctionResultFilterSensitiveLog: () => TestFunctionResultFilterSensitiveLog,
  TestResultFilterSensitiveLog: () => TestResultFilterSensitiveLog,
  TooLongCSPInResponseHeadersPolicy: () => TooLongCSPInResponseHeadersPolicy,
  TooManyCacheBehaviors: () => TooManyCacheBehaviors,
  TooManyCachePolicies: () => TooManyCachePolicies,
  TooManyCertificates: () => TooManyCertificates,
  TooManyCloudFrontOriginAccessIdentities: () => TooManyCloudFrontOriginAccessIdentities,
  TooManyContinuousDeploymentPolicies: () => TooManyContinuousDeploymentPolicies,
  TooManyCookieNamesInWhiteList: () => TooManyCookieNamesInWhiteList,
  TooManyCookiesInCachePolicy: () => TooManyCookiesInCachePolicy,
  TooManyCookiesInOriginRequestPolicy: () => TooManyCookiesInOriginRequestPolicy,
  TooManyCustomHeadersInResponseHeadersPolicy: () => TooManyCustomHeadersInResponseHeadersPolicy,
  TooManyDistributionCNAMEs: () => TooManyDistributionCNAMEs,
  TooManyDistributions: () => TooManyDistributions,
  TooManyDistributionsAssociatedToCachePolicy: () => TooManyDistributionsAssociatedToCachePolicy,
  TooManyDistributionsAssociatedToFieldLevelEncryptionConfig: () => TooManyDistributionsAssociatedToFieldLevelEncryptionConfig,
  TooManyDistributionsAssociatedToKeyGroup: () => TooManyDistributionsAssociatedToKeyGroup,
  TooManyDistributionsAssociatedToOriginAccessControl: () => TooManyDistributionsAssociatedToOriginAccessControl,
  TooManyDistributionsAssociatedToOriginRequestPolicy: () => TooManyDistributionsAssociatedToOriginRequestPolicy,
  TooManyDistributionsAssociatedToResponseHeadersPolicy: () => TooManyDistributionsAssociatedToResponseHeadersPolicy,
  TooManyDistributionsWithFunctionAssociations: () => TooManyDistributionsWithFunctionAssociations,
  TooManyDistributionsWithLambdaAssociations: () => TooManyDistributionsWithLambdaAssociations,
  TooManyDistributionsWithSingleFunctionARN: () => TooManyDistributionsWithSingleFunctionARN,
  TooManyFieldLevelEncryptionConfigs: () => TooManyFieldLevelEncryptionConfigs,
  TooManyFieldLevelEncryptionContentTypeProfiles: () => TooManyFieldLevelEncryptionContentTypeProfiles,
  TooManyFieldLevelEncryptionEncryptionEntities: () => TooManyFieldLevelEncryptionEncryptionEntities,
  TooManyFieldLevelEncryptionFieldPatterns: () => TooManyFieldLevelEncryptionFieldPatterns,
  TooManyFieldLevelEncryptionProfiles: () => TooManyFieldLevelEncryptionProfiles,
  TooManyFieldLevelEncryptionQueryArgProfiles: () => TooManyFieldLevelEncryptionQueryArgProfiles,
  TooManyFunctionAssociations: () => TooManyFunctionAssociations,
  TooManyFunctions: () => TooManyFunctions,
  TooManyHeadersInCachePolicy: () => TooManyHeadersInCachePolicy,
  TooManyHeadersInForwardedValues: () => TooManyHeadersInForwardedValues,
  TooManyHeadersInOriginRequestPolicy: () => TooManyHeadersInOriginRequestPolicy,
  TooManyInvalidationsInProgress: () => TooManyInvalidationsInProgress,
  TooManyKeyGroups: () => TooManyKeyGroups,
  TooManyKeyGroupsAssociatedToDistribution: () => TooManyKeyGroupsAssociatedToDistribution,
  TooManyLambdaFunctionAssociations: () => TooManyLambdaFunctionAssociations,
  TooManyOriginAccessControls: () => TooManyOriginAccessControls,
  TooManyOriginCustomHeaders: () => TooManyOriginCustomHeaders,
  TooManyOriginGroupsPerDistribution: () => TooManyOriginGroupsPerDistribution,
  TooManyOriginRequestPolicies: () => TooManyOriginRequestPolicies,
  TooManyOrigins: () => TooManyOrigins,
  TooManyPublicKeys: () => TooManyPublicKeys,
  TooManyPublicKeysInKeyGroup: () => TooManyPublicKeysInKeyGroup,
  TooManyQueryStringParameters: () => TooManyQueryStringParameters,
  TooManyQueryStringsInCachePolicy: () => TooManyQueryStringsInCachePolicy,
  TooManyQueryStringsInOriginRequestPolicy: () => TooManyQueryStringsInOriginRequestPolicy,
  TooManyRealtimeLogConfigs: () => TooManyRealtimeLogConfigs,
  TooManyRemoveHeadersInResponseHeadersPolicy: () => TooManyRemoveHeadersInResponseHeadersPolicy,
  TooManyResponseHeadersPolicies: () => TooManyResponseHeadersPolicies,
  TooManyStreamingDistributionCNAMEs: () => TooManyStreamingDistributionCNAMEs,
  TooManyStreamingDistributions: () => TooManyStreamingDistributions,
  TooManyTrustedSigners: () => TooManyTrustedSigners,
  TrustedKeyGroupDoesNotExist: () => TrustedKeyGroupDoesNotExist,
  TrustedSignerDoesNotExist: () => TrustedSignerDoesNotExist,
  UnsupportedOperation: () => UnsupportedOperation,
  UntagResourceCommand: () => UntagResourceCommand,
  UpdateCachePolicyCommand: () => UpdateCachePolicyCommand,
  UpdateCloudFrontOriginAccessIdentityCommand: () => UpdateCloudFrontOriginAccessIdentityCommand,
  UpdateConnectionGroupCommand: () => UpdateConnectionGroupCommand,
  UpdateContinuousDeploymentPolicyCommand: () => UpdateContinuousDeploymentPolicyCommand,
  UpdateDistributionCommand: () => UpdateDistributionCommand,
  UpdateDistributionRequestFilterSensitiveLog: () => UpdateDistributionRequestFilterSensitiveLog,
  UpdateDistributionResultFilterSensitiveLog: () => UpdateDistributionResultFilterSensitiveLog,
  UpdateDistributionTenantCommand: () => UpdateDistributionTenantCommand,
  UpdateDistributionWithStagingConfigCommand: () => UpdateDistributionWithStagingConfigCommand,
  UpdateDistributionWithStagingConfigResultFilterSensitiveLog: () => UpdateDistributionWithStagingConfigResultFilterSensitiveLog,
  UpdateDomainAssociationCommand: () => UpdateDomainAssociationCommand,
  UpdateFieldLevelEncryptionConfigCommand: () => UpdateFieldLevelEncryptionConfigCommand,
  UpdateFieldLevelEncryptionProfileCommand: () => UpdateFieldLevelEncryptionProfileCommand,
  UpdateFunctionCommand: () => UpdateFunctionCommand,
  UpdateFunctionRequestFilterSensitiveLog: () => UpdateFunctionRequestFilterSensitiveLog,
  UpdateKeyGroupCommand: () => UpdateKeyGroupCommand,
  UpdateKeyValueStoreCommand: () => UpdateKeyValueStoreCommand,
  UpdateOriginAccessControlCommand: () => UpdateOriginAccessControlCommand,
  UpdateOriginRequestPolicyCommand: () => UpdateOriginRequestPolicyCommand,
  UpdatePublicKeyCommand: () => UpdatePublicKeyCommand,
  UpdateRealtimeLogConfigCommand: () => UpdateRealtimeLogConfigCommand,
  UpdateResponseHeadersPolicyCommand: () => UpdateResponseHeadersPolicyCommand,
  UpdateStreamingDistributionCommand: () => UpdateStreamingDistributionCommand,
  UpdateVpcOriginCommand: () => UpdateVpcOriginCommand,
  ValidationTokenHost: () => ValidationTokenHost,
  VerifyDnsConfigurationCommand: () => VerifyDnsConfigurationCommand,
  ViewerProtocolPolicy: () => ViewerProtocolPolicy,
  __Client: () => import_smithy_client.Client,
  paginateListCloudFrontOriginAccessIdentities: () => paginateListCloudFrontOriginAccessIdentities,
  paginateListConnectionGroups: () => paginateListConnectionGroups,
  paginateListDistributionTenants: () => paginateListDistributionTenants,
  paginateListDistributionTenantsByCustomization: () => paginateListDistributionTenantsByCustomization,
  paginateListDistributions: () => paginateListDistributions,
  paginateListDistributionsByConnectionMode: () => paginateListDistributionsByConnectionMode,
  paginateListDomainConflicts: () => paginateListDomainConflicts,
  paginateListInvalidations: () => paginateListInvalidations,
  paginateListInvalidationsForDistributionTenant: () => paginateListInvalidationsForDistributionTenant,
  paginateListKeyValueStores: () => paginateListKeyValueStores,
  paginateListPublicKeys: () => paginateListPublicKeys,
  paginateListStreamingDistributions: () => paginateListStreamingDistributions,
  waitForDistributionDeployed: () => waitForDistributionDeployed,
  waitForInvalidationCompleted: () => waitForInvalidationCompleted,
  waitForInvalidationForDistributionTenantCompleted: () => waitForInvalidationForDistributionTenantCompleted,
  waitForStreamingDistributionDeployed: () => waitForStreamingDistributionDeployed,
  waitUntilDistributionDeployed: () => waitUntilDistributionDeployed,
  waitUntilInvalidationCompleted: () => waitUntilInvalidationCompleted,
  waitUntilInvalidationForDistributionTenantCompleted: () => waitUntilInvalidationForDistributionTenantCompleted,
  waitUntilStreamingDistributionDeployed: () => waitUntilStreamingDistributionDeployed
});
module.exports = __toCommonJS(index_exports);

// src/CloudFrontClient.ts
var import_middleware_host_header = require("@aws-sdk/middleware-host-header");
var import_middleware_logger = require("@aws-sdk/middleware-logger");
var import_middleware_recursion_detection = require("@aws-sdk/middleware-recursion-detection");
var import_middleware_user_agent = require("@aws-sdk/middleware-user-agent");
var import_config_resolver = require("@smithy/config-resolver");
var import_core = require("@smithy/core");
var import_middleware_content_length = require("@smithy/middleware-content-length");
var import_middleware_endpoint = require("@smithy/middleware-endpoint");
var import_middleware_retry = require("@smithy/middleware-retry");

var import_httpAuthSchemeProvider = require("./auth/httpAuthSchemeProvider");

// src/endpoint/EndpointParameters.ts
var resolveClientEndpointParameters = /* @__PURE__ */ __name((options) => {
  return Object.assign(options, {
    useDualstackEndpoint: options.useDualstackEndpoint ?? false,
    useFipsEndpoint: options.useFipsEndpoint ?? false,
    defaultSigningName: "cloudfront"
  });
}, "resolveClientEndpointParameters");
var commonParams = {
  UseFIPS: { type: "builtInParams", name: "useFipsEndpoint" },
  Endpoint: { type: "builtInParams", name: "endpoint" },
  Region: { type: "builtInParams", name: "region" },
  UseDualStack: { type: "builtInParams", name: "useDualstackEndpoint" }
};

// src/CloudFrontClient.ts
var import_runtimeConfig = require("././runtimeConfig");

// src/runtimeExtensions.ts
var import_region_config_resolver = require("@aws-sdk/region-config-resolver");
var import_protocol_http = require("@smithy/protocol-http");
var import_smithy_client = require("@smithy/smithy-client");

// src/auth/httpAuthExtensionConfiguration.ts
var getHttpAuthExtensionConfiguration = /* @__PURE__ */ __name((runtimeConfig) => {
  const _httpAuthSchemes = runtimeConfig.httpAuthSchemes;
  let _httpAuthSchemeProvider = runtimeConfig.httpAuthSchemeProvider;
  let _credentials = runtimeConfig.credentials;
  return {
    setHttpAuthScheme(httpAuthScheme) {
      const index = _httpAuthSchemes.findIndex((scheme) => scheme.schemeId === httpAuthScheme.schemeId);
      if (index === -1) {
        _httpAuthSchemes.push(httpAuthScheme);
      } else {
        _httpAuthSchemes.splice(index, 1, httpAuthScheme);
      }
    },
    httpAuthSchemes() {
      return _httpAuthSchemes;
    },
    setHttpAuthSchemeProvider(httpAuthSchemeProvider) {
      _httpAuthSchemeProvider = httpAuthSchemeProvider;
    },
    httpAuthSchemeProvider() {
      return _httpAuthSchemeProvider;
    },
    setCredentials(credentials) {
      _credentials = credentials;
    },
    credentials() {
      return _credentials;
    }
  };
}, "getHttpAuthExtensionConfiguration");
var resolveHttpAuthRuntimeConfig = /* @__PURE__ */ __name((config) => {
  return {
    httpAuthSchemes: config.httpAuthSchemes(),
    httpAuthSchemeProvider: config.httpAuthSchemeProvider(),
    credentials: config.credentials()
  };
}, "resolveHttpAuthRuntimeConfig");

// src/runtimeExtensions.ts
var resolveRuntimeExtensions = /* @__PURE__ */ __name((runtimeConfig, extensions) => {
  const extensionConfiguration = Object.assign(
    (0, import_region_config_resolver.getAwsRegionExtensionConfiguration)(runtimeConfig),
    (0, import_smithy_client.getDefaultExtensionConfiguration)(runtimeConfig),
    (0, import_protocol_http.getHttpHandlerExtensionConfiguration)(runtimeConfig),
    getHttpAuthExtensionConfiguration(runtimeConfig)
  );
  extensions.forEach((extension) => extension.configure(extensionConfiguration));
  return Object.assign(
    runtimeConfig,
    (0, import_region_config_resolver.resolveAwsRegionExtensionConfiguration)(extensionConfiguration),
    (0, import_smithy_client.resolveDefaultRuntimeConfig)(extensionConfiguration),
    (0, import_protocol_http.resolveHttpHandlerRuntimeConfig)(extensionConfiguration),
    resolveHttpAuthRuntimeConfig(extensionConfiguration)
  );
}, "resolveRuntimeExtensions");

// src/CloudFrontClient.ts
var CloudFrontClient = class extends import_smithy_client.Client {
  static {
    __name(this, "CloudFrontClient");
  }
  /**
   * The resolved configuration of CloudFrontClient class. This is resolved and normalized from the {@link CloudFrontClientConfig | constructor configuration interface}.
   */
  config;
  constructor(...[configuration]) {
    const _config_0 = (0, import_runtimeConfig.getRuntimeConfig)(configuration || {});
    super(_config_0);
    this.initConfig = _config_0;
    const _config_1 = resolveClientEndpointParameters(_config_0);
    const _config_2 = (0, import_middleware_user_agent.resolveUserAgentConfig)(_config_1);
    const _config_3 = (0, import_middleware_retry.resolveRetryConfig)(_config_2);
    const _config_4 = (0, import_config_resolver.resolveRegionConfig)(_config_3);
    const _config_5 = (0, import_middleware_host_header.resolveHostHeaderConfig)(_config_4);
    const _config_6 = (0, import_middleware_endpoint.resolveEndpointConfig)(_config_5);
    const _config_7 = (0, import_httpAuthSchemeProvider.resolveHttpAuthSchemeConfig)(_config_6);
    const _config_8 = resolveRuntimeExtensions(_config_7, configuration?.extensions || []);
    this.config = _config_8;
    this.middlewareStack.use((0, import_middleware_user_agent.getUserAgentPlugin)(this.config));
    this.middlewareStack.use((0, import_middleware_retry.getRetryPlugin)(this.config));
    this.middlewareStack.use((0, import_middleware_content_length.getContentLengthPlugin)(this.config));
    this.middlewareStack.use((0, import_middleware_host_header.getHostHeaderPlugin)(this.config));
    this.middlewareStack.use((0, import_middleware_logger.getLoggerPlugin)(this.config));
    this.middlewareStack.use((0, import_middleware_recursion_detection.getRecursionDetectionPlugin)(this.config));
    this.middlewareStack.use(
      (0, import_core.getHttpAuthSchemeEndpointRuleSetPlugin)(this.config, {
        httpAuthSchemeParametersProvider: import_httpAuthSchemeProvider.defaultCloudFrontHttpAuthSchemeParametersProvider,
        identityProviderConfigProvider: /* @__PURE__ */ __name(async (config) => new import_core.DefaultIdentityProviderConfig({
          "aws.auth#sigv4": config.credentials
        }), "identityProviderConfigProvider")
      })
    );
    this.middlewareStack.use((0, import_core.getHttpSigningPlugin)(this.config));
  }
  /**
   * Destroy underlying resources, like sockets. It's usually not necessary to do this.
   * However in Node.js, it's best to explicitly shut down the client's agent when it is no longer needed.
   * Otherwise, sockets might stay open for quite a long time before the server terminates them.
   */
  destroy() {
    super.destroy();
  }
};

// src/CloudFront.ts


// src/commands/AssociateAliasCommand.ts

var import_middleware_serde = require("@smithy/middleware-serde");


// src/protocols/Aws_restXml.ts
var import_core2 = require("@aws-sdk/core");
var import_xml_builder = require("@aws-sdk/xml-builder");



// src/models/CloudFrontServiceException.ts

var CloudFrontServiceException = class _CloudFrontServiceException extends import_smithy_client.ServiceException {
  static {
    __name(this, "CloudFrontServiceException");
  }
  /**
   * @internal
   */
  constructor(options) {
    super(options);
    Object.setPrototypeOf(this, _CloudFrontServiceException.prototype);
  }
};

// src/models/models_0.ts

var ResponseHeadersPolicyAccessControlAllowMethodsValues = {
  ALL: "ALL",
  DELETE: "DELETE",
  GET: "GET",
  HEAD: "HEAD",
  OPTIONS: "OPTIONS",
  PATCH: "PATCH",
  POST: "POST",
  PUT: "PUT"
};
var AccessDenied = class _AccessDenied extends CloudFrontServiceException {
  static {
    __name(this, "AccessDenied");
  }
  name = "AccessDenied";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "AccessDenied",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _AccessDenied.prototype);
    this.Message = opts.Message;
  }
};
var ICPRecordalStatus = {
  APPROVED: "APPROVED",
  PENDING: "PENDING",
  SUSPENDED: "SUSPENDED"
};
var Method = {
  DELETE: "DELETE",
  GET: "GET",
  HEAD: "HEAD",
  OPTIONS: "OPTIONS",
  PATCH: "PATCH",
  POST: "POST",
  PUT: "PUT"
};
var IllegalUpdate = class _IllegalUpdate extends CloudFrontServiceException {
  static {
    __name(this, "IllegalUpdate");
  }
  name = "IllegalUpdate";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "IllegalUpdate",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _IllegalUpdate.prototype);
    this.Message = opts.Message;
  }
};
var InvalidArgument = class _InvalidArgument extends CloudFrontServiceException {
  static {
    __name(this, "InvalidArgument");
  }
  name = "InvalidArgument";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidArgument",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidArgument.prototype);
    this.Message = opts.Message;
  }
};
var NoSuchDistribution = class _NoSuchDistribution extends CloudFrontServiceException {
  static {
    __name(this, "NoSuchDistribution");
  }
  name = "NoSuchDistribution";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "NoSuchDistribution",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _NoSuchDistribution.prototype);
    this.Message = opts.Message;
  }
};
var TooManyDistributionCNAMEs = class _TooManyDistributionCNAMEs extends CloudFrontServiceException {
  static {
    __name(this, "TooManyDistributionCNAMEs");
  }
  name = "TooManyDistributionCNAMEs";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "TooManyDistributionCNAMEs",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _TooManyDistributionCNAMEs.prototype);
    this.Message = opts.Message;
  }
};
var EntityNotFound = class _EntityNotFound extends CloudFrontServiceException {
  static {
    __name(this, "EntityNotFound");
  }
  name = "EntityNotFound";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "EntityNotFound",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _EntityNotFound.prototype);
    this.Message = opts.Message;
  }
};
var InvalidIfMatchVersion = class _InvalidIfMatchVersion extends CloudFrontServiceException {
  static {
    __name(this, "InvalidIfMatchVersion");
  }
  name = "InvalidIfMatchVersion";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidIfMatchVersion",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidIfMatchVersion.prototype);
    this.Message = opts.Message;
  }
};
var PreconditionFailed = class _PreconditionFailed extends CloudFrontServiceException {
  static {
    __name(this, "PreconditionFailed");
  }
  name = "PreconditionFailed";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "PreconditionFailed",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _PreconditionFailed.prototype);
    this.Message = opts.Message;
  }
};
var BatchTooLarge = class _BatchTooLarge extends CloudFrontServiceException {
  static {
    __name(this, "BatchTooLarge");
  }
  name = "BatchTooLarge";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "BatchTooLarge",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _BatchTooLarge.prototype);
    this.Message = opts.Message;
  }
};
var ItemSelection = {
  all: "all",
  none: "none",
  whitelist: "whitelist"
};
var EventType = {
  origin_request: "origin-request",
  origin_response: "origin-response",
  viewer_request: "viewer-request",
  viewer_response: "viewer-response"
};
var ViewerProtocolPolicy = {
  allow_all: "allow-all",
  https_only: "https-only",
  redirect_to_https: "redirect-to-https"
};
var CachePolicyCookieBehavior = {
  all: "all",
  allExcept: "allExcept",
  none: "none",
  whitelist: "whitelist"
};
var CachePolicyHeaderBehavior = {
  none: "none",
  whitelist: "whitelist"
};
var CachePolicyQueryStringBehavior = {
  all: "all",
  allExcept: "allExcept",
  none: "none",
  whitelist: "whitelist"
};
var CachePolicyAlreadyExists = class _CachePolicyAlreadyExists extends CloudFrontServiceException {
  static {
    __name(this, "CachePolicyAlreadyExists");
  }
  name = "CachePolicyAlreadyExists";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "CachePolicyAlreadyExists",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _CachePolicyAlreadyExists.prototype);
    this.Message = opts.Message;
  }
};
var CachePolicyInUse = class _CachePolicyInUse extends CloudFrontServiceException {
  static {
    __name(this, "CachePolicyInUse");
  }
  name = "CachePolicyInUse";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "CachePolicyInUse",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _CachePolicyInUse.prototype);
    this.Message = opts.Message;
  }
};
var CachePolicyType = {
  custom: "custom",
  managed: "managed"
};
var CannotChangeImmutablePublicKeyFields = class _CannotChangeImmutablePublicKeyFields extends CloudFrontServiceException {
  static {
    __name(this, "CannotChangeImmutablePublicKeyFields");
  }
  name = "CannotChangeImmutablePublicKeyFields";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "CannotChangeImmutablePublicKeyFields",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _CannotChangeImmutablePublicKeyFields.prototype);
    this.Message = opts.Message;
  }
};
var CannotDeleteEntityWhileInUse = class _CannotDeleteEntityWhileInUse extends CloudFrontServiceException {
  static {
    __name(this, "CannotDeleteEntityWhileInUse");
  }
  name = "CannotDeleteEntityWhileInUse";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "CannotDeleteEntityWhileInUse",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _CannotDeleteEntityWhileInUse.prototype);
    this.Message = opts.Message;
  }
};
var CannotUpdateEntityWhileInUse = class _CannotUpdateEntityWhileInUse extends CloudFrontServiceException {
  static {
    __name(this, "CannotUpdateEntityWhileInUse");
  }
  name = "CannotUpdateEntityWhileInUse";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "CannotUpdateEntityWhileInUse",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _CannotUpdateEntityWhileInUse.prototype);
    this.Message = opts.Message;
  }
};
var CertificateSource = {
  acm: "acm",
  cloudfront: "cloudfront",
  iam: "iam"
};
var CertificateTransparencyLoggingPreference = {
  Disabled: "disabled",
  Enabled: "enabled"
};
var CNAMEAlreadyExists = class _CNAMEAlreadyExists extends CloudFrontServiceException {
  static {
    __name(this, "CNAMEAlreadyExists");
  }
  name = "CNAMEAlreadyExists";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "CNAMEAlreadyExists",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _CNAMEAlreadyExists.prototype);
    this.Message = opts.Message;
  }
};
var ConnectionMode = {
  Direct: "direct",
  TenantOnly: "tenant-only"
};
var HttpVersion = {
  http1_1: "http1.1",
  http2: "http2",
  http2and3: "http2and3",
  http3: "http3"
};
var OriginGroupSelectionCriteria = {
  Default: "default",
  MediaQualityBased: "media-quality-based"
};
var OriginProtocolPolicy = {
  http_only: "http-only",
  https_only: "https-only",
  match_viewer: "match-viewer"
};
var SslProtocol = {
  SSLv3: "SSLv3",
  TLSv1: "TLSv1",
  TLSv1_1: "TLSv1.1",
  TLSv1_2: "TLSv1.2"
};
var PriceClass = {
  None: "None",
  PriceClass_100: "PriceClass_100",
  PriceClass_200: "PriceClass_200",
  PriceClass_All: "PriceClass_All"
};
var GeoRestrictionType = {
  blacklist: "blacklist",
  none: "none",
  whitelist: "whitelist"
};
var MinimumProtocolVersion = {
  SSLv3: "SSLv3",
  TLSv1: "TLSv1",
  TLSv1_1_2016: "TLSv1.1_2016",
  TLSv1_2016: "TLSv1_2016",
  TLSv1_2_2018: "TLSv1.2_2018",
  TLSv1_2_2019: "TLSv1.2_2019",
  TLSv1_2_2021: "TLSv1.2_2021"
};
var SSLSupportMethod = {
  sni_only: "sni-only",
  static_ip: "static-ip",
  vip: "vip"
};
var DistributionAlreadyExists = class _DistributionAlreadyExists extends CloudFrontServiceException {
  static {
    __name(this, "DistributionAlreadyExists");
  }
  name = "DistributionAlreadyExists";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "DistributionAlreadyExists",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _DistributionAlreadyExists.prototype);
    this.Message = opts.Message;
  }
};
var IllegalFieldLevelEncryptionConfigAssociationWithCacheBehavior = class _IllegalFieldLevelEncryptionConfigAssociationWithCacheBehavior extends CloudFrontServiceException {
  static {
    __name(this, "IllegalFieldLevelEncryptionConfigAssociationWithCacheBehavior");
  }
  name = "IllegalFieldLevelEncryptionConfigAssociationWithCacheBehavior";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "IllegalFieldLevelEncryptionConfigAssociationWithCacheBehavior",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _IllegalFieldLevelEncryptionConfigAssociationWithCacheBehavior.prototype);
    this.Message = opts.Message;
  }
};
var InconsistentQuantities = class _InconsistentQuantities extends CloudFrontServiceException {
  static {
    __name(this, "InconsistentQuantities");
  }
  name = "InconsistentQuantities";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InconsistentQuantities",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InconsistentQuantities.prototype);
    this.Message = opts.Message;
  }
};
var InvalidDefaultRootObject = class _InvalidDefaultRootObject extends CloudFrontServiceException {
  static {
    __name(this, "InvalidDefaultRootObject");
  }
  name = "InvalidDefaultRootObject";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidDefaultRootObject",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidDefaultRootObject.prototype);
    this.Message = opts.Message;
  }
};
var InvalidErrorCode = class _InvalidErrorCode extends CloudFrontServiceException {
  static {
    __name(this, "InvalidErrorCode");
  }
  name = "InvalidErrorCode";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidErrorCode",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidErrorCode.prototype);
    this.Message = opts.Message;
  }
};
var InvalidForwardCookies = class _InvalidForwardCookies extends CloudFrontServiceException {
  static {
    __name(this, "InvalidForwardCookies");
  }
  name = "InvalidForwardCookies";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidForwardCookies",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidForwardCookies.prototype);
    this.Message = opts.Message;
  }
};
var InvalidFunctionAssociation = class _InvalidFunctionAssociation extends CloudFrontServiceException {
  static {
    __name(this, "InvalidFunctionAssociation");
  }
  name = "InvalidFunctionAssociation";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidFunctionAssociation",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidFunctionAssociation.prototype);
    this.Message = opts.Message;
  }
};
var InvalidGeoRestrictionParameter = class _InvalidGeoRestrictionParameter extends CloudFrontServiceException {
  static {
    __name(this, "InvalidGeoRestrictionParameter");
  }
  name = "InvalidGeoRestrictionParameter";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidGeoRestrictionParameter",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidGeoRestrictionParameter.prototype);
    this.Message = opts.Message;
  }
};
var InvalidHeadersForS3Origin = class _InvalidHeadersForS3Origin extends CloudFrontServiceException {
  static {
    __name(this, "InvalidHeadersForS3Origin");
  }
  name = "InvalidHeadersForS3Origin";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidHeadersForS3Origin",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidHeadersForS3Origin.prototype);
    this.Message = opts.Message;
  }
};
var InvalidLambdaFunctionAssociation = class _InvalidLambdaFunctionAssociation extends CloudFrontServiceException {
  static {
    __name(this, "InvalidLambdaFunctionAssociation");
  }
  name = "InvalidLambdaFunctionAssociation";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidLambdaFunctionAssociation",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidLambdaFunctionAssociation.prototype);
    this.Message = opts.Message;
  }
};
var InvalidLocationCode = class _InvalidLocationCode extends CloudFrontServiceException {
  static {
    __name(this, "InvalidLocationCode");
  }
  name = "InvalidLocationCode";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidLocationCode",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidLocationCode.prototype);
    this.Message = opts.Message;
  }
};
var InvalidMinimumProtocolVersion = class _InvalidMinimumProtocolVersion extends CloudFrontServiceException {
  static {
    __name(this, "InvalidMinimumProtocolVersion");
  }
  name = "InvalidMinimumProtocolVersion";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidMinimumProtocolVersion",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidMinimumProtocolVersion.prototype);
    this.Message = opts.Message;
  }
};
var InvalidOrigin = class _InvalidOrigin extends CloudFrontServiceException {
  static {
    __name(this, "InvalidOrigin");
  }
  name = "InvalidOrigin";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidOrigin",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidOrigin.prototype);
    this.Message = opts.Message;
  }
};
var InvalidOriginAccessControl = class _InvalidOriginAccessControl extends CloudFrontServiceException {
  static {
    __name(this, "InvalidOriginAccessControl");
  }
  name = "InvalidOriginAccessControl";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidOriginAccessControl",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidOriginAccessControl.prototype);
    this.Message = opts.Message;
  }
};
var InvalidOriginAccessIdentity = class _InvalidOriginAccessIdentity extends CloudFrontServiceException {
  static {
    __name(this, "InvalidOriginAccessIdentity");
  }
  name = "InvalidOriginAccessIdentity";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidOriginAccessIdentity",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidOriginAccessIdentity.prototype);
    this.Message = opts.Message;
  }
};
var InvalidOriginKeepaliveTimeout = class _InvalidOriginKeepaliveTimeout extends CloudFrontServiceException {
  static {
    __name(this, "InvalidOriginKeepaliveTimeout");
  }
  name = "InvalidOriginKeepaliveTimeout";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidOriginKeepaliveTimeout",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidOriginKeepaliveTimeout.prototype);
    this.Message = opts.Message;
  }
};
var InvalidOriginReadTimeout = class _InvalidOriginReadTimeout extends CloudFrontServiceException {
  static {
    __name(this, "InvalidOriginReadTimeout");
  }
  name = "InvalidOriginReadTimeout";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidOriginReadTimeout",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidOriginReadTimeout.prototype);
    this.Message = opts.Message;
  }
};
var InvalidProtocolSettings = class _InvalidProtocolSettings extends CloudFrontServiceException {
  static {
    __name(this, "InvalidProtocolSettings");
  }
  name = "InvalidProtocolSettings";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidProtocolSettings",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidProtocolSettings.prototype);
    this.Message = opts.Message;
  }
};
var InvalidQueryStringParameters = class _InvalidQueryStringParameters extends CloudFrontServiceException {
  static {
    __name(this, "InvalidQueryStringParameters");
  }
  name = "InvalidQueryStringParameters";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidQueryStringParameters",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidQueryStringParameters.prototype);
    this.Message = opts.Message;
  }
};
var InvalidRelativePath = class _InvalidRelativePath extends CloudFrontServiceException {
  static {
    __name(this, "InvalidRelativePath");
  }
  name = "InvalidRelativePath";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidRelativePath",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidRelativePath.prototype);
    this.Message = opts.Message;
  }
};
var InvalidRequiredProtocol = class _InvalidRequiredProtocol extends CloudFrontServiceException {
  static {
    __name(this, "InvalidRequiredProtocol");
  }
  name = "InvalidRequiredProtocol";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidRequiredProtocol",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidRequiredProtocol.prototype);
    this.Message = opts.Message;
  }
};
var InvalidResponseCode = class _InvalidResponseCode extends CloudFrontServiceException {
  static {
    __name(this, "InvalidResponseCode");
  }
  name = "InvalidResponseCode";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidResponseCode",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidResponseCode.prototype);
    this.Message = opts.Message;
  }
};
var InvalidTTLOrder = class _InvalidTTLOrder extends CloudFrontServiceException {
  static {
    __name(this, "InvalidTTLOrder");
  }
  name = "InvalidTTLOrder";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidTTLOrder",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidTTLOrder.prototype);
    this.Message = opts.Message;
  }
};
var InvalidViewerCertificate = class _InvalidViewerCertificate extends CloudFrontServiceException {
  static {
    __name(this, "InvalidViewerCertificate");
  }
  name = "InvalidViewerCertificate";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidViewerCertificate",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidViewerCertificate.prototype);
    this.Message = opts.Message;
  }
};
var InvalidWebACLId = class _InvalidWebACLId extends CloudFrontServiceException {
  static {
    __name(this, "InvalidWebACLId");
  }
  name = "InvalidWebACLId";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidWebACLId",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidWebACLId.prototype);
    this.Message = opts.Message;
  }
};
var MissingBody = class _MissingBody extends CloudFrontServiceException {
  static {
    __name(this, "MissingBody");
  }
  name = "MissingBody";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "MissingBody",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _MissingBody.prototype);
    this.Message = opts.Message;
  }
};
var NoSuchCachePolicy = class _NoSuchCachePolicy extends CloudFrontServiceException {
  static {
    __name(this, "NoSuchCachePolicy");
  }
  name = "NoSuchCachePolicy";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "NoSuchCachePolicy",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _NoSuchCachePolicy.prototype);
    this.Message = opts.Message;
  }
};
var NoSuchFieldLevelEncryptionConfig = class _NoSuchFieldLevelEncryptionConfig extends CloudFrontServiceException {
  static {
    __name(this, "NoSuchFieldLevelEncryptionConfig");
  }
  name = "NoSuchFieldLevelEncryptionConfig";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "NoSuchFieldLevelEncryptionConfig",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _NoSuchFieldLevelEncryptionConfig.prototype);
    this.Message = opts.Message;
  }
};
var NoSuchOrigin = class _NoSuchOrigin extends CloudFrontServiceException {
  static {
    __name(this, "NoSuchOrigin");
  }
  name = "NoSuchOrigin";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "NoSuchOrigin",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _NoSuchOrigin.prototype);
    this.Message = opts.Message;
  }
};
var NoSuchOriginRequestPolicy = class _NoSuchOriginRequestPolicy extends CloudFrontServiceException {
  static {
    __name(this, "NoSuchOriginRequestPolicy");
  }
  name = "NoSuchOriginRequestPolicy";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "NoSuchOriginRequestPolicy",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _NoSuchOriginRequestPolicy.prototype);
    this.Message = opts.Message;
  }
};
var NoSuchRealtimeLogConfig = class _NoSuchRealtimeLogConfig extends CloudFrontServiceException {
  static {
    __name(this, "NoSuchRealtimeLogConfig");
  }
  name = "NoSuchRealtimeLogConfig";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "NoSuchRealtimeLogConfig",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _NoSuchRealtimeLogConfig.prototype);
    this.Message = opts.Message;
  }
};
var NoSuchResponseHeadersPolicy = class _NoSuchResponseHeadersPolicy extends CloudFrontServiceException {
  static {
    __name(this, "NoSuchResponseHeadersPolicy");
  }
  name = "NoSuchResponseHeadersPolicy";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "NoSuchResponseHeadersPolicy",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _NoSuchResponseHeadersPolicy.prototype);
    this.Message = opts.Message;
  }
};
var RealtimeLogConfigOwnerMismatch = class _RealtimeLogConfigOwnerMismatch extends CloudFrontServiceException {
  static {
    __name(this, "RealtimeLogConfigOwnerMismatch");
  }
  name = "RealtimeLogConfigOwnerMismatch";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "RealtimeLogConfigOwnerMismatch",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _RealtimeLogConfigOwnerMismatch.prototype);
    this.Message = opts.Message;
  }
};
var TooManyCacheBehaviors = class _TooManyCacheBehaviors extends CloudFrontServiceException {
  static {
    __name(this, "TooManyCacheBehaviors");
  }
  name = "TooManyCacheBehaviors";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "TooManyCacheBehaviors",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _TooManyCacheBehaviors.prototype);
    this.Message = opts.Message;
  }
};
var TooManyCertificates = class _TooManyCertificates extends CloudFrontServiceException {
  static {
    __name(this, "TooManyCertificates");
  }
  name = "TooManyCertificates";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "TooManyCertificates",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _TooManyCertificates.prototype);
    this.Message = opts.Message;
  }
};
var TooManyCookieNamesInWhiteList = class _TooManyCookieNamesInWhiteList extends CloudFrontServiceException {
  static {
    __name(this, "TooManyCookieNamesInWhiteList");
  }
  name = "TooManyCookieNamesInWhiteList";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "TooManyCookieNamesInWhiteList",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _TooManyCookieNamesInWhiteList.prototype);
    this.Message = opts.Message;
  }
};
var TooManyDistributions = class _TooManyDistributions extends CloudFrontServiceException {
  static {
    __name(this, "TooManyDistributions");
  }
  name = "TooManyDistributions";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "TooManyDistributions",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _TooManyDistributions.prototype);
    this.Message = opts.Message;
  }
};
var TooManyDistributionsAssociatedToCachePolicy = class _TooManyDistributionsAssociatedToCachePolicy extends CloudFrontServiceException {
  static {
    __name(this, "TooManyDistributionsAssociatedToCachePolicy");
  }
  name = "TooManyDistributionsAssociatedToCachePolicy";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "TooManyDistributionsAssociatedToCachePolicy",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _TooManyDistributionsAssociatedToCachePolicy.prototype);
    this.Message = opts.Message;
  }
};
var TooManyDistributionsAssociatedToFieldLevelEncryptionConfig = class _TooManyDistributionsAssociatedToFieldLevelEncryptionConfig extends CloudFrontServiceException {
  static {
    __name(this, "TooManyDistributionsAssociatedToFieldLevelEncryptionConfig");
  }
  name = "TooManyDistributionsAssociatedToFieldLevelEncryptionConfig";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "TooManyDistributionsAssociatedToFieldLevelEncryptionConfig",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _TooManyDistributionsAssociatedToFieldLevelEncryptionConfig.prototype);
    this.Message = opts.Message;
  }
};
var TooManyDistributionsAssociatedToKeyGroup = class _TooManyDistributionsAssociatedToKeyGroup extends CloudFrontServiceException {
  static {
    __name(this, "TooManyDistributionsAssociatedToKeyGroup");
  }
  name = "TooManyDistributionsAssociatedToKeyGroup";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "TooManyDistributionsAssociatedToKeyGroup",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _TooManyDistributionsAssociatedToKeyGroup.prototype);
    this.Message = opts.Message;
  }
};
var TooManyDistributionsAssociatedToOriginAccessControl = class _TooManyDistributionsAssociatedToOriginAccessControl extends CloudFrontServiceException {
  static {
    __name(this, "TooManyDistributionsAssociatedToOriginAccessControl");
  }
  name = "TooManyDistributionsAssociatedToOriginAccessControl";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "TooManyDistributionsAssociatedToOriginAccessControl",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _TooManyDistributionsAssociatedToOriginAccessControl.prototype);
    this.Message = opts.Message;
  }
};
var TooManyDistributionsAssociatedToOriginRequestPolicy = class _TooManyDistributionsAssociatedToOriginRequestPolicy extends CloudFrontServiceException {
  static {
    __name(this, "TooManyDistributionsAssociatedToOriginRequestPolicy");
  }
  name = "TooManyDistributionsAssociatedToOriginRequestPolicy";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "TooManyDistributionsAssociatedToOriginRequestPolicy",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _TooManyDistributionsAssociatedToOriginRequestPolicy.prototype);
    this.Message = opts.Message;
  }
};
var TooManyDistributionsAssociatedToResponseHeadersPolicy = class _TooManyDistributionsAssociatedToResponseHeadersPolicy extends CloudFrontServiceException {
  static {
    __name(this, "TooManyDistributionsAssociatedToResponseHeadersPolicy");
  }
  name = "TooManyDistributionsAssociatedToResponseHeadersPolicy";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "TooManyDistributionsAssociatedToResponseHeadersPolicy",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _TooManyDistributionsAssociatedToResponseHeadersPolicy.prototype);
    this.Message = opts.Message;
  }
};
var TooManyDistributionsWithFunctionAssociations = class _TooManyDistributionsWithFunctionAssociations extends CloudFrontServiceException {
  static {
    __name(this, "TooManyDistributionsWithFunctionAssociations");
  }
  name = "TooManyDistributionsWithFunctionAssociations";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "TooManyDistributionsWithFunctionAssociations",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _TooManyDistributionsWithFunctionAssociations.prototype);
    this.Message = opts.Message;
  }
};
var TooManyDistributionsWithLambdaAssociations = class _TooManyDistributionsWithLambdaAssociations extends CloudFrontServiceException {
  static {
    __name(this, "TooManyDistributionsWithLambdaAssociations");
  }
  name = "TooManyDistributionsWithLambdaAssociations";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "TooManyDistributionsWithLambdaAssociations",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _TooManyDistributionsWithLambdaAssociations.prototype);
    this.Message = opts.Message;
  }
};
var TooManyDistributionsWithSingleFunctionARN = class _TooManyDistributionsWithSingleFunctionARN extends CloudFrontServiceException {
  static {
    __name(this, "TooManyDistributionsWithSingleFunctionARN");
  }
  name = "TooManyDistributionsWithSingleFunctionARN";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "TooManyDistributionsWithSingleFunctionARN",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _TooManyDistributionsWithSingleFunctionARN.prototype);
    this.Message = opts.Message;
  }
};
var TooManyFunctionAssociations = class _TooManyFunctionAssociations extends CloudFrontServiceException {
  static {
    __name(this, "TooManyFunctionAssociations");
  }
  name = "TooManyFunctionAssociations";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "TooManyFunctionAssociations",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _TooManyFunctionAssociations.prototype);
    this.Message = opts.Message;
  }
};
var TooManyHeadersInForwardedValues = class _TooManyHeadersInForwardedValues extends CloudFrontServiceException {
  static {
    __name(this, "TooManyHeadersInForwardedValues");
  }
  name = "TooManyHeadersInForwardedValues";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "TooManyHeadersInForwardedValues",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _TooManyHeadersInForwardedValues.prototype);
    this.Message = opts.Message;
  }
};
var TooManyKeyGroupsAssociatedToDistribution = class _TooManyKeyGroupsAssociatedToDistribution extends CloudFrontServiceException {
  static {
    __name(this, "TooManyKeyGroupsAssociatedToDistribution");
  }
  name = "TooManyKeyGroupsAssociatedToDistribution";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "TooManyKeyGroupsAssociatedToDistribution",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _TooManyKeyGroupsAssociatedToDistribution.prototype);
    this.Message = opts.Message;
  }
};
var TooManyLambdaFunctionAssociations = class _TooManyLambdaFunctionAssociations extends CloudFrontServiceException {
  static {
    __name(this, "TooManyLambdaFunctionAssociations");
  }
  name = "TooManyLambdaFunctionAssociations";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "TooManyLambdaFunctionAssociations",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _TooManyLambdaFunctionAssociations.prototype);
    this.Message = opts.Message;
  }
};
var TooManyOriginCustomHeaders = class _TooManyOriginCustomHeaders extends CloudFrontServiceException {
  static {
    __name(this, "TooManyOriginCustomHeaders");
  }
  name = "TooManyOriginCustomHeaders";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "TooManyOriginCustomHeaders",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _TooManyOriginCustomHeaders.prototype);
    this.Message = opts.Message;
  }
};
var TooManyOriginGroupsPerDistribution = class _TooManyOriginGroupsPerDistribution extends CloudFrontServiceException {
  static {
    __name(this, "TooManyOriginGroupsPerDistribution");
  }
  name = "TooManyOriginGroupsPerDistribution";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "TooManyOriginGroupsPerDistribution",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _TooManyOriginGroupsPerDistribution.prototype);
    this.Message = opts.Message;
  }
};
var TooManyOrigins = class _TooManyOrigins extends CloudFrontServiceException {
  static {
    __name(this, "TooManyOrigins");
  }
  name = "TooManyOrigins";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "TooManyOrigins",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _TooManyOrigins.prototype);
    this.Message = opts.Message;
  }
};
var TooManyQueryStringParameters = class _TooManyQueryStringParameters extends CloudFrontServiceException {
  static {
    __name(this, "TooManyQueryStringParameters");
  }
  name = "TooManyQueryStringParameters";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "TooManyQueryStringParameters",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _TooManyQueryStringParameters.prototype);
    this.Message = opts.Message;
  }
};
var TooManyTrustedSigners = class _TooManyTrustedSigners extends CloudFrontServiceException {
  static {
    __name(this, "TooManyTrustedSigners");
  }
  name = "TooManyTrustedSigners";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "TooManyTrustedSigners",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _TooManyTrustedSigners.prototype);
    this.Message = opts.Message;
  }
};
var TrustedKeyGroupDoesNotExist = class _TrustedKeyGroupDoesNotExist extends CloudFrontServiceException {
  static {
    __name(this, "TrustedKeyGroupDoesNotExist");
  }
  name = "TrustedKeyGroupDoesNotExist";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "TrustedKeyGroupDoesNotExist",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _TrustedKeyGroupDoesNotExist.prototype);
    this.Message = opts.Message;
  }
};
var TrustedSignerDoesNotExist = class _TrustedSignerDoesNotExist extends CloudFrontServiceException {
  static {
    __name(this, "TrustedSignerDoesNotExist");
  }
  name = "TrustedSignerDoesNotExist";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "TrustedSignerDoesNotExist",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _TrustedSignerDoesNotExist.prototype);
    this.Message = opts.Message;
  }
};
var EntityAlreadyExists = class _EntityAlreadyExists extends CloudFrontServiceException {
  static {
    __name(this, "EntityAlreadyExists");
  }
  name = "EntityAlreadyExists";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "EntityAlreadyExists",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _EntityAlreadyExists.prototype);
    this.Message = opts.Message;
  }
};
var EntityLimitExceeded = class _EntityLimitExceeded extends CloudFrontServiceException {
  static {
    __name(this, "EntityLimitExceeded");
  }
  name = "EntityLimitExceeded";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "EntityLimitExceeded",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _EntityLimitExceeded.prototype);
    this.Message = opts.Message;
  }
};
var InvalidTagging = class _InvalidTagging extends CloudFrontServiceException {
  static {
    __name(this, "InvalidTagging");
  }
  name = "InvalidTagging";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidTagging",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidTagging.prototype);
    this.Message = opts.Message;
  }
};
var UnsupportedOperation = class _UnsupportedOperation extends CloudFrontServiceException {
  static {
    __name(this, "UnsupportedOperation");
  }
  name = "UnsupportedOperation";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "UnsupportedOperation",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _UnsupportedOperation.prototype);
    this.Message = opts.Message;
  }
};
var TooManyCachePolicies = class _TooManyCachePolicies extends CloudFrontServiceException {
  static {
    __name(this, "TooManyCachePolicies");
  }
  name = "TooManyCachePolicies";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "TooManyCachePolicies",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _TooManyCachePolicies.prototype);
    this.Message = opts.Message;
  }
};
var TooManyCookiesInCachePolicy = class _TooManyCookiesInCachePolicy extends CloudFrontServiceException {
  static {
    __name(this, "TooManyCookiesInCachePolicy");
  }
  name = "TooManyCookiesInCachePolicy";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "TooManyCookiesInCachePolicy",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _TooManyCookiesInCachePolicy.prototype);
    this.Message = opts.Message;
  }
};
var TooManyHeadersInCachePolicy = class _TooManyHeadersInCachePolicy extends CloudFrontServiceException {
  static {
    __name(this, "TooManyHeadersInCachePolicy");
  }
  name = "TooManyHeadersInCachePolicy";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "TooManyHeadersInCachePolicy",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _TooManyHeadersInCachePolicy.prototype);
    this.Message = opts.Message;
  }
};
var TooManyQueryStringsInCachePolicy = class _TooManyQueryStringsInCachePolicy extends CloudFrontServiceException {
  static {
    __name(this, "TooManyQueryStringsInCachePolicy");
  }
  name = "TooManyQueryStringsInCachePolicy";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "TooManyQueryStringsInCachePolicy",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _TooManyQueryStringsInCachePolicy.prototype);
    this.Message = opts.Message;
  }
};
var CloudFrontOriginAccessIdentityAlreadyExists = class _CloudFrontOriginAccessIdentityAlreadyExists extends CloudFrontServiceException {
  static {
    __name(this, "CloudFrontOriginAccessIdentityAlreadyExists");
  }
  name = "CloudFrontOriginAccessIdentityAlreadyExists";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "CloudFrontOriginAccessIdentityAlreadyExists",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _CloudFrontOriginAccessIdentityAlreadyExists.prototype);
    this.Message = opts.Message;
  }
};
var TooManyCloudFrontOriginAccessIdentities = class _TooManyCloudFrontOriginAccessIdentities extends CloudFrontServiceException {
  static {
    __name(this, "TooManyCloudFrontOriginAccessIdentities");
  }
  name = "TooManyCloudFrontOriginAccessIdentities";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "TooManyCloudFrontOriginAccessIdentities",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _TooManyCloudFrontOriginAccessIdentities.prototype);
    this.Message = opts.Message;
  }
};
var ContinuousDeploymentPolicyAlreadyExists = class _ContinuousDeploymentPolicyAlreadyExists extends CloudFrontServiceException {
  static {
    __name(this, "ContinuousDeploymentPolicyAlreadyExists");
  }
  name = "ContinuousDeploymentPolicyAlreadyExists";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "ContinuousDeploymentPolicyAlreadyExists",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _ContinuousDeploymentPolicyAlreadyExists.prototype);
    this.Message = opts.Message;
  }
};
var ContinuousDeploymentPolicyType = {
  SingleHeader: "SingleHeader",
  SingleWeight: "SingleWeight"
};
var StagingDistributionInUse = class _StagingDistributionInUse extends CloudFrontServiceException {
  static {
    __name(this, "StagingDistributionInUse");
  }
  name = "StagingDistributionInUse";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "StagingDistributionInUse",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _StagingDistributionInUse.prototype);
    this.Message = opts.Message;
  }
};
var TooManyContinuousDeploymentPolicies = class _TooManyContinuousDeploymentPolicies extends CloudFrontServiceException {
  static {
    __name(this, "TooManyContinuousDeploymentPolicies");
  }
  name = "TooManyContinuousDeploymentPolicies";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "TooManyContinuousDeploymentPolicies",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _TooManyContinuousDeploymentPolicies.prototype);
    this.Message = opts.Message;
  }
};
var ContinuousDeploymentPolicyInUse = class _ContinuousDeploymentPolicyInUse extends CloudFrontServiceException {
  static {
    __name(this, "ContinuousDeploymentPolicyInUse");
  }
  name = "ContinuousDeploymentPolicyInUse";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "ContinuousDeploymentPolicyInUse",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _ContinuousDeploymentPolicyInUse.prototype);
    this.Message = opts.Message;
  }
};
var IllegalOriginAccessConfiguration = class _IllegalOriginAccessConfiguration extends CloudFrontServiceException {
  static {
    __name(this, "IllegalOriginAccessConfiguration");
  }
  name = "IllegalOriginAccessConfiguration";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "IllegalOriginAccessConfiguration",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _IllegalOriginAccessConfiguration.prototype);
    this.Message = opts.Message;
  }
};
var InvalidDomainNameForOriginAccessControl = class _InvalidDomainNameForOriginAccessControl extends CloudFrontServiceException {
  static {
    __name(this, "InvalidDomainNameForOriginAccessControl");
  }
  name = "InvalidDomainNameForOriginAccessControl";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidDomainNameForOriginAccessControl",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidDomainNameForOriginAccessControl.prototype);
    this.Message = opts.Message;
  }
};
var NoSuchContinuousDeploymentPolicy = class _NoSuchContinuousDeploymentPolicy extends CloudFrontServiceException {
  static {
    __name(this, "NoSuchContinuousDeploymentPolicy");
  }
  name = "NoSuchContinuousDeploymentPolicy";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "NoSuchContinuousDeploymentPolicy",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _NoSuchContinuousDeploymentPolicy.prototype);
    this.Message = opts.Message;
  }
};
var CustomizationActionType = {
  disable: "disable",
  override: "override"
};
var ValidationTokenHost = {
  CloudFront: "cloudfront",
  SelfHosted: "self-hosted"
};
var DomainStatus = {
  Active: "active",
  Inactive: "inactive"
};
var InvalidAssociation = class _InvalidAssociation extends CloudFrontServiceException {
  static {
    __name(this, "InvalidAssociation");
  }
  name = "InvalidAssociation";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidAssociation",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidAssociation.prototype);
    this.Message = opts.Message;
  }
};
var Format = {
  URLEncoded: "URLEncoded"
};
var FieldLevelEncryptionConfigAlreadyExists = class _FieldLevelEncryptionConfigAlreadyExists extends CloudFrontServiceException {
  static {
    __name(this, "FieldLevelEncryptionConfigAlreadyExists");
  }
  name = "FieldLevelEncryptionConfigAlreadyExists";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "FieldLevelEncryptionConfigAlreadyExists",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _FieldLevelEncryptionConfigAlreadyExists.prototype);
    this.Message = opts.Message;
  }
};
var NoSuchFieldLevelEncryptionProfile = class _NoSuchFieldLevelEncryptionProfile extends CloudFrontServiceException {
  static {
    __name(this, "NoSuchFieldLevelEncryptionProfile");
  }
  name = "NoSuchFieldLevelEncryptionProfile";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "NoSuchFieldLevelEncryptionProfile",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _NoSuchFieldLevelEncryptionProfile.prototype);
    this.Message = opts.Message;
  }
};
var QueryArgProfileEmpty = class _QueryArgProfileEmpty extends CloudFrontServiceException {
  static {
    __name(this, "QueryArgProfileEmpty");
  }
  name = "QueryArgProfileEmpty";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "QueryArgProfileEmpty",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _QueryArgProfileEmpty.prototype);
    this.Message = opts.Message;
  }
};
var TooManyFieldLevelEncryptionConfigs = class _TooManyFieldLevelEncryptionConfigs extends CloudFrontServiceException {
  static {
    __name(this, "TooManyFieldLevelEncryptionConfigs");
  }
  name = "TooManyFieldLevelEncryptionConfigs";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "TooManyFieldLevelEncryptionConfigs",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _TooManyFieldLevelEncryptionConfigs.prototype);
    this.Message = opts.Message;
  }
};
var TooManyFieldLevelEncryptionContentTypeProfiles = class _TooManyFieldLevelEncryptionContentTypeProfiles extends CloudFrontServiceException {
  static {
    __name(this, "TooManyFieldLevelEncryptionContentTypeProfiles");
  }
  name = "TooManyFieldLevelEncryptionContentTypeProfiles";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "TooManyFieldLevelEncryptionContentTypeProfiles",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _TooManyFieldLevelEncryptionContentTypeProfiles.prototype);
    this.Message = opts.Message;
  }
};
var TooManyFieldLevelEncryptionQueryArgProfiles = class _TooManyFieldLevelEncryptionQueryArgProfiles extends CloudFrontServiceException {
  static {
    __name(this, "TooManyFieldLevelEncryptionQueryArgProfiles");
  }
  name = "TooManyFieldLevelEncryptionQueryArgProfiles";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "TooManyFieldLevelEncryptionQueryArgProfiles",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _TooManyFieldLevelEncryptionQueryArgProfiles.prototype);
    this.Message = opts.Message;
  }
};
var FieldLevelEncryptionProfileAlreadyExists = class _FieldLevelEncryptionProfileAlreadyExists extends CloudFrontServiceException {
  static {
    __name(this, "FieldLevelEncryptionProfileAlreadyExists");
  }
  name = "FieldLevelEncryptionProfileAlreadyExists";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "FieldLevelEncryptionProfileAlreadyExists",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _FieldLevelEncryptionProfileAlreadyExists.prototype);
    this.Message = opts.Message;
  }
};
var FieldLevelEncryptionProfileSizeExceeded = class _FieldLevelEncryptionProfileSizeExceeded extends CloudFrontServiceException {
  static {
    __name(this, "FieldLevelEncryptionProfileSizeExceeded");
  }
  name = "FieldLevelEncryptionProfileSizeExceeded";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "FieldLevelEncryptionProfileSizeExceeded",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _FieldLevelEncryptionProfileSizeExceeded.prototype);
    this.Message = opts.Message;
  }
};
var NoSuchPublicKey = class _NoSuchPublicKey extends CloudFrontServiceException {
  static {
    __name(this, "NoSuchPublicKey");
  }
  name = "NoSuchPublicKey";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "NoSuchPublicKey",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _NoSuchPublicKey.prototype);
    this.Message = opts.Message;
  }
};
var TooManyFieldLevelEncryptionEncryptionEntities = class _TooManyFieldLevelEncryptionEncryptionEntities extends CloudFrontServiceException {
  static {
    __name(this, "TooManyFieldLevelEncryptionEncryptionEntities");
  }
  name = "TooManyFieldLevelEncryptionEncryptionEntities";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "TooManyFieldLevelEncryptionEncryptionEntities",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _TooManyFieldLevelEncryptionEncryptionEntities.prototype);
    this.Message = opts.Message;
  }
};
var TooManyFieldLevelEncryptionFieldPatterns = class _TooManyFieldLevelEncryptionFieldPatterns extends CloudFrontServiceException {
  static {
    __name(this, "TooManyFieldLevelEncryptionFieldPatterns");
  }
  name = "TooManyFieldLevelEncryptionFieldPatterns";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "TooManyFieldLevelEncryptionFieldPatterns",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _TooManyFieldLevelEncryptionFieldPatterns.prototype);
    this.Message = opts.Message;
  }
};
var TooManyFieldLevelEncryptionProfiles = class _TooManyFieldLevelEncryptionProfiles extends CloudFrontServiceException {
  static {
    __name(this, "TooManyFieldLevelEncryptionProfiles");
  }
  name = "TooManyFieldLevelEncryptionProfiles";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "TooManyFieldLevelEncryptionProfiles",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _TooManyFieldLevelEncryptionProfiles.prototype);
    this.Message = opts.Message;
  }
};
var FunctionRuntime = {
  cloudfront_js_1_0: "cloudfront-js-1.0",
  cloudfront_js_2_0: "cloudfront-js-2.0"
};
var FunctionStage = {
  DEVELOPMENT: "DEVELOPMENT",
  LIVE: "LIVE"
};
var FunctionAlreadyExists = class _FunctionAlreadyExists extends CloudFrontServiceException {
  static {
    __name(this, "FunctionAlreadyExists");
  }
  name = "FunctionAlreadyExists";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "FunctionAlreadyExists",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _FunctionAlreadyExists.prototype);
    this.Message = opts.Message;
  }
};
var FunctionSizeLimitExceeded = class _FunctionSizeLimitExceeded extends CloudFrontServiceException {
  static {
    __name(this, "FunctionSizeLimitExceeded");
  }
  name = "FunctionSizeLimitExceeded";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "FunctionSizeLimitExceeded",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _FunctionSizeLimitExceeded.prototype);
    this.Message = opts.Message;
  }
};
var TooManyFunctions = class _TooManyFunctions extends CloudFrontServiceException {
  static {
    __name(this, "TooManyFunctions");
  }
  name = "TooManyFunctions";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "TooManyFunctions",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _TooManyFunctions.prototype);
    this.Message = opts.Message;
  }
};
var TooManyInvalidationsInProgress = class _TooManyInvalidationsInProgress extends CloudFrontServiceException {
  static {
    __name(this, "TooManyInvalidationsInProgress");
  }
  name = "TooManyInvalidationsInProgress";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "TooManyInvalidationsInProgress",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _TooManyInvalidationsInProgress.prototype);
    this.Message = opts.Message;
  }
};
var KeyGroupAlreadyExists = class _KeyGroupAlreadyExists extends CloudFrontServiceException {
  static {
    __name(this, "KeyGroupAlreadyExists");
  }
  name = "KeyGroupAlreadyExists";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "KeyGroupAlreadyExists",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _KeyGroupAlreadyExists.prototype);
    this.Message = opts.Message;
  }
};
var TooManyKeyGroups = class _TooManyKeyGroups extends CloudFrontServiceException {
  static {
    __name(this, "TooManyKeyGroups");
  }
  name = "TooManyKeyGroups";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "TooManyKeyGroups",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _TooManyKeyGroups.prototype);
    this.Message = opts.Message;
  }
};
var TooManyPublicKeysInKeyGroup = class _TooManyPublicKeysInKeyGroup extends CloudFrontServiceException {
  static {
    __name(this, "TooManyPublicKeysInKeyGroup");
  }
  name = "TooManyPublicKeysInKeyGroup";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "TooManyPublicKeysInKeyGroup",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _TooManyPublicKeysInKeyGroup.prototype);
    this.Message = opts.Message;
  }
};
var ImportSourceType = {
  S3: "S3"
};
var EntitySizeLimitExceeded = class _EntitySizeLimitExceeded extends CloudFrontServiceException {
  static {
    __name(this, "EntitySizeLimitExceeded");
  }
  name = "EntitySizeLimitExceeded";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "EntitySizeLimitExceeded",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _EntitySizeLimitExceeded.prototype);
    this.Message = opts.Message;
  }
};
var RealtimeMetricsSubscriptionStatus = {
  Disabled: "Disabled",
  Enabled: "Enabled"
};
var MonitoringSubscriptionAlreadyExists = class _MonitoringSubscriptionAlreadyExists extends CloudFrontServiceException {
  static {
    __name(this, "MonitoringSubscriptionAlreadyExists");
  }
  name = "MonitoringSubscriptionAlreadyExists";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "MonitoringSubscriptionAlreadyExists",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _MonitoringSubscriptionAlreadyExists.prototype);
    this.Message = opts.Message;
  }
};
var OriginAccessControlOriginTypes = {
  lambda: "lambda",
  mediapackagev2: "mediapackagev2",
  mediastore: "mediastore",
  s3: "s3"
};
var OriginAccessControlSigningBehaviors = {
  always: "always",
  never: "never",
  no_override: "no-override"
};
var OriginAccessControlSigningProtocols = {
  sigv4: "sigv4"
};
var OriginAccessControlAlreadyExists = class _OriginAccessControlAlreadyExists extends CloudFrontServiceException {
  static {
    __name(this, "OriginAccessControlAlreadyExists");
  }
  name = "OriginAccessControlAlreadyExists";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "OriginAccessControlAlreadyExists",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _OriginAccessControlAlreadyExists.prototype);
    this.Message = opts.Message;
  }
};
var OriginCustomHeaderFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.HeaderValue && { HeaderValue: import_smithy_client.SENSITIVE_STRING }
}), "OriginCustomHeaderFilterSensitiveLog");
var CustomHeadersFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.Items && { Items: obj.Items.map((item) => OriginCustomHeaderFilterSensitiveLog(item)) }
}), "CustomHeadersFilterSensitiveLog");
var OriginFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.CustomHeaders && { CustomHeaders: CustomHeadersFilterSensitiveLog(obj.CustomHeaders) }
}), "OriginFilterSensitiveLog");
var OriginsFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj
}), "OriginsFilterSensitiveLog");
var DistributionConfigFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.Comment && { Comment: import_smithy_client.SENSITIVE_STRING }
}), "DistributionConfigFilterSensitiveLog");
var DistributionFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.DistributionConfig && { DistributionConfig: DistributionConfigFilterSensitiveLog(obj.DistributionConfig) }
}), "DistributionFilterSensitiveLog");
var CopyDistributionResultFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.Distribution && { Distribution: DistributionFilterSensitiveLog(obj.Distribution) }
}), "CopyDistributionResultFilterSensitiveLog");
var CreateDistributionRequestFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.DistributionConfig && { DistributionConfig: DistributionConfigFilterSensitiveLog(obj.DistributionConfig) }
}), "CreateDistributionRequestFilterSensitiveLog");
var CreateDistributionResultFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.Distribution && { Distribution: DistributionFilterSensitiveLog(obj.Distribution) }
}), "CreateDistributionResultFilterSensitiveLog");
var DistributionConfigWithTagsFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.DistributionConfig && { DistributionConfig: DistributionConfigFilterSensitiveLog(obj.DistributionConfig) }
}), "DistributionConfigWithTagsFilterSensitiveLog");
var CreateDistributionWithTagsRequestFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.DistributionConfigWithTags && {
    DistributionConfigWithTags: DistributionConfigWithTagsFilterSensitiveLog(obj.DistributionConfigWithTags)
  }
}), "CreateDistributionWithTagsRequestFilterSensitiveLog");
var CreateDistributionWithTagsResultFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.Distribution && { Distribution: DistributionFilterSensitiveLog(obj.Distribution) }
}), "CreateDistributionWithTagsResultFilterSensitiveLog");
var CreateFunctionRequestFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.FunctionCode && { FunctionCode: import_smithy_client.SENSITIVE_STRING }
}), "CreateFunctionRequestFilterSensitiveLog");

// src/models/models_1.ts

var TooManyOriginAccessControls = class _TooManyOriginAccessControls extends CloudFrontServiceException {
  static {
    __name(this, "TooManyOriginAccessControls");
  }
  name = "TooManyOriginAccessControls";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "TooManyOriginAccessControls",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _TooManyOriginAccessControls.prototype);
    this.Message = opts.Message;
  }
};
var OriginRequestPolicyCookieBehavior = {
  all: "all",
  allExcept: "allExcept",
  none: "none",
  whitelist: "whitelist"
};
var OriginRequestPolicyHeaderBehavior = {
  allExcept: "allExcept",
  allViewer: "allViewer",
  allViewerAndWhitelistCloudFront: "allViewerAndWhitelistCloudFront",
  none: "none",
  whitelist: "whitelist"
};
var OriginRequestPolicyQueryStringBehavior = {
  all: "all",
  allExcept: "allExcept",
  none: "none",
  whitelist: "whitelist"
};
var OriginRequestPolicyAlreadyExists = class _OriginRequestPolicyAlreadyExists extends CloudFrontServiceException {
  static {
    __name(this, "OriginRequestPolicyAlreadyExists");
  }
  name = "OriginRequestPolicyAlreadyExists";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "OriginRequestPolicyAlreadyExists",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _OriginRequestPolicyAlreadyExists.prototype);
    this.Message = opts.Message;
  }
};
var TooManyCookiesInOriginRequestPolicy = class _TooManyCookiesInOriginRequestPolicy extends CloudFrontServiceException {
  static {
    __name(this, "TooManyCookiesInOriginRequestPolicy");
  }
  name = "TooManyCookiesInOriginRequestPolicy";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "TooManyCookiesInOriginRequestPolicy",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _TooManyCookiesInOriginRequestPolicy.prototype);
    this.Message = opts.Message;
  }
};
var TooManyHeadersInOriginRequestPolicy = class _TooManyHeadersInOriginRequestPolicy extends CloudFrontServiceException {
  static {
    __name(this, "TooManyHeadersInOriginRequestPolicy");
  }
  name = "TooManyHeadersInOriginRequestPolicy";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "TooManyHeadersInOriginRequestPolicy",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _TooManyHeadersInOriginRequestPolicy.prototype);
    this.Message = opts.Message;
  }
};
var TooManyOriginRequestPolicies = class _TooManyOriginRequestPolicies extends CloudFrontServiceException {
  static {
    __name(this, "TooManyOriginRequestPolicies");
  }
  name = "TooManyOriginRequestPolicies";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "TooManyOriginRequestPolicies",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _TooManyOriginRequestPolicies.prototype);
    this.Message = opts.Message;
  }
};
var TooManyQueryStringsInOriginRequestPolicy = class _TooManyQueryStringsInOriginRequestPolicy extends CloudFrontServiceException {
  static {
    __name(this, "TooManyQueryStringsInOriginRequestPolicy");
  }
  name = "TooManyQueryStringsInOriginRequestPolicy";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "TooManyQueryStringsInOriginRequestPolicy",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _TooManyQueryStringsInOriginRequestPolicy.prototype);
    this.Message = opts.Message;
  }
};
var PublicKeyAlreadyExists = class _PublicKeyAlreadyExists extends CloudFrontServiceException {
  static {
    __name(this, "PublicKeyAlreadyExists");
  }
  name = "PublicKeyAlreadyExists";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "PublicKeyAlreadyExists",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _PublicKeyAlreadyExists.prototype);
    this.Message = opts.Message;
  }
};
var TooManyPublicKeys = class _TooManyPublicKeys extends CloudFrontServiceException {
  static {
    __name(this, "TooManyPublicKeys");
  }
  name = "TooManyPublicKeys";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "TooManyPublicKeys",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _TooManyPublicKeys.prototype);
    this.Message = opts.Message;
  }
};
var RealtimeLogConfigAlreadyExists = class _RealtimeLogConfigAlreadyExists extends CloudFrontServiceException {
  static {
    __name(this, "RealtimeLogConfigAlreadyExists");
  }
  name = "RealtimeLogConfigAlreadyExists";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "RealtimeLogConfigAlreadyExists",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _RealtimeLogConfigAlreadyExists.prototype);
    this.Message = opts.Message;
  }
};
var TooManyRealtimeLogConfigs = class _TooManyRealtimeLogConfigs extends CloudFrontServiceException {
  static {
    __name(this, "TooManyRealtimeLogConfigs");
  }
  name = "TooManyRealtimeLogConfigs";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "TooManyRealtimeLogConfigs",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _TooManyRealtimeLogConfigs.prototype);
    this.Message = opts.Message;
  }
};
var FrameOptionsList = {
  DENY: "DENY",
  SAMEORIGIN: "SAMEORIGIN"
};
var ReferrerPolicyList = {
  no_referrer: "no-referrer",
  no_referrer_when_downgrade: "no-referrer-when-downgrade",
  origin: "origin",
  origin_when_cross_origin: "origin-when-cross-origin",
  same_origin: "same-origin",
  strict_origin: "strict-origin",
  strict_origin_when_cross_origin: "strict-origin-when-cross-origin",
  unsafe_url: "unsafe-url"
};
var ResponseHeadersPolicyAlreadyExists = class _ResponseHeadersPolicyAlreadyExists extends CloudFrontServiceException {
  static {
    __name(this, "ResponseHeadersPolicyAlreadyExists");
  }
  name = "ResponseHeadersPolicyAlreadyExists";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "ResponseHeadersPolicyAlreadyExists",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _ResponseHeadersPolicyAlreadyExists.prototype);
    this.Message = opts.Message;
  }
};
var TooLongCSPInResponseHeadersPolicy = class _TooLongCSPInResponseHeadersPolicy extends CloudFrontServiceException {
  static {
    __name(this, "TooLongCSPInResponseHeadersPolicy");
  }
  name = "TooLongCSPInResponseHeadersPolicy";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "TooLongCSPInResponseHeadersPolicy",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _TooLongCSPInResponseHeadersPolicy.prototype);
    this.Message = opts.Message;
  }
};
var TooManyCustomHeadersInResponseHeadersPolicy = class _TooManyCustomHeadersInResponseHeadersPolicy extends CloudFrontServiceException {
  static {
    __name(this, "TooManyCustomHeadersInResponseHeadersPolicy");
  }
  name = "TooManyCustomHeadersInResponseHeadersPolicy";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "TooManyCustomHeadersInResponseHeadersPolicy",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _TooManyCustomHeadersInResponseHeadersPolicy.prototype);
    this.Message = opts.Message;
  }
};
var TooManyRemoveHeadersInResponseHeadersPolicy = class _TooManyRemoveHeadersInResponseHeadersPolicy extends CloudFrontServiceException {
  static {
    __name(this, "TooManyRemoveHeadersInResponseHeadersPolicy");
  }
  name = "TooManyRemoveHeadersInResponseHeadersPolicy";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "TooManyRemoveHeadersInResponseHeadersPolicy",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _TooManyRemoveHeadersInResponseHeadersPolicy.prototype);
    this.Message = opts.Message;
  }
};
var TooManyResponseHeadersPolicies = class _TooManyResponseHeadersPolicies extends CloudFrontServiceException {
  static {
    __name(this, "TooManyResponseHeadersPolicies");
  }
  name = "TooManyResponseHeadersPolicies";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "TooManyResponseHeadersPolicies",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _TooManyResponseHeadersPolicies.prototype);
    this.Message = opts.Message;
  }
};
var StreamingDistributionAlreadyExists = class _StreamingDistributionAlreadyExists extends CloudFrontServiceException {
  static {
    __name(this, "StreamingDistributionAlreadyExists");
  }
  name = "StreamingDistributionAlreadyExists";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "StreamingDistributionAlreadyExists",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _StreamingDistributionAlreadyExists.prototype);
    this.Message = opts.Message;
  }
};
var TooManyStreamingDistributionCNAMEs = class _TooManyStreamingDistributionCNAMEs extends CloudFrontServiceException {
  static {
    __name(this, "TooManyStreamingDistributionCNAMEs");
  }
  name = "TooManyStreamingDistributionCNAMEs";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "TooManyStreamingDistributionCNAMEs",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _TooManyStreamingDistributionCNAMEs.prototype);
    this.Message = opts.Message;
  }
};
var TooManyStreamingDistributions = class _TooManyStreamingDistributions extends CloudFrontServiceException {
  static {
    __name(this, "TooManyStreamingDistributions");
  }
  name = "TooManyStreamingDistributions";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "TooManyStreamingDistributions",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _TooManyStreamingDistributions.prototype);
    this.Message = opts.Message;
  }
};
var IllegalDelete = class _IllegalDelete extends CloudFrontServiceException {
  static {
    __name(this, "IllegalDelete");
  }
  name = "IllegalDelete";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "IllegalDelete",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _IllegalDelete.prototype);
    this.Message = opts.Message;
  }
};
var CloudFrontOriginAccessIdentityInUse = class _CloudFrontOriginAccessIdentityInUse extends CloudFrontServiceException {
  static {
    __name(this, "CloudFrontOriginAccessIdentityInUse");
  }
  name = "CloudFrontOriginAccessIdentityInUse";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "CloudFrontOriginAccessIdentityInUse",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _CloudFrontOriginAccessIdentityInUse.prototype);
    this.Message = opts.Message;
  }
};
var NoSuchCloudFrontOriginAccessIdentity = class _NoSuchCloudFrontOriginAccessIdentity extends CloudFrontServiceException {
  static {
    __name(this, "NoSuchCloudFrontOriginAccessIdentity");
  }
  name = "NoSuchCloudFrontOriginAccessIdentity";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "NoSuchCloudFrontOriginAccessIdentity",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _NoSuchCloudFrontOriginAccessIdentity.prototype);
    this.Message = opts.Message;
  }
};
var ResourceNotDisabled = class _ResourceNotDisabled extends CloudFrontServiceException {
  static {
    __name(this, "ResourceNotDisabled");
  }
  name = "ResourceNotDisabled";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "ResourceNotDisabled",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _ResourceNotDisabled.prototype);
    this.Message = opts.Message;
  }
};
var DistributionNotDisabled = class _DistributionNotDisabled extends CloudFrontServiceException {
  static {
    __name(this, "DistributionNotDisabled");
  }
  name = "DistributionNotDisabled";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "DistributionNotDisabled",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _DistributionNotDisabled.prototype);
    this.Message = opts.Message;
  }
};
var ResourceInUse = class _ResourceInUse extends CloudFrontServiceException {
  static {
    __name(this, "ResourceInUse");
  }
  name = "ResourceInUse";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "ResourceInUse",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _ResourceInUse.prototype);
    this.Message = opts.Message;
  }
};
var FieldLevelEncryptionConfigInUse = class _FieldLevelEncryptionConfigInUse extends CloudFrontServiceException {
  static {
    __name(this, "FieldLevelEncryptionConfigInUse");
  }
  name = "FieldLevelEncryptionConfigInUse";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "FieldLevelEncryptionConfigInUse",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _FieldLevelEncryptionConfigInUse.prototype);
    this.Message = opts.Message;
  }
};
var FieldLevelEncryptionProfileInUse = class _FieldLevelEncryptionProfileInUse extends CloudFrontServiceException {
  static {
    __name(this, "FieldLevelEncryptionProfileInUse");
  }
  name = "FieldLevelEncryptionProfileInUse";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "FieldLevelEncryptionProfileInUse",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _FieldLevelEncryptionProfileInUse.prototype);
    this.Message = opts.Message;
  }
};
var FunctionInUse = class _FunctionInUse extends CloudFrontServiceException {
  static {
    __name(this, "FunctionInUse");
  }
  name = "FunctionInUse";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "FunctionInUse",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _FunctionInUse.prototype);
    this.Message = opts.Message;
  }
};
var NoSuchFunctionExists = class _NoSuchFunctionExists extends CloudFrontServiceException {
  static {
    __name(this, "NoSuchFunctionExists");
  }
  name = "NoSuchFunctionExists";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "NoSuchFunctionExists",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _NoSuchFunctionExists.prototype);
    this.Message = opts.Message;
  }
};
var NoSuchResource = class _NoSuchResource extends CloudFrontServiceException {
  static {
    __name(this, "NoSuchResource");
  }
  name = "NoSuchResource";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "NoSuchResource",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _NoSuchResource.prototype);
    this.Message = opts.Message;
  }
};
var NoSuchMonitoringSubscription = class _NoSuchMonitoringSubscription extends CloudFrontServiceException {
  static {
    __name(this, "NoSuchMonitoringSubscription");
  }
  name = "NoSuchMonitoringSubscription";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "NoSuchMonitoringSubscription",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _NoSuchMonitoringSubscription.prototype);
    this.Message = opts.Message;
  }
};
var NoSuchOriginAccessControl = class _NoSuchOriginAccessControl extends CloudFrontServiceException {
  static {
    __name(this, "NoSuchOriginAccessControl");
  }
  name = "NoSuchOriginAccessControl";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "NoSuchOriginAccessControl",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _NoSuchOriginAccessControl.prototype);
    this.Message = opts.Message;
  }
};
var OriginAccessControlInUse = class _OriginAccessControlInUse extends CloudFrontServiceException {
  static {
    __name(this, "OriginAccessControlInUse");
  }
  name = "OriginAccessControlInUse";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "OriginAccessControlInUse",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _OriginAccessControlInUse.prototype);
    this.Message = opts.Message;
  }
};
var OriginRequestPolicyInUse = class _OriginRequestPolicyInUse extends CloudFrontServiceException {
  static {
    __name(this, "OriginRequestPolicyInUse");
  }
  name = "OriginRequestPolicyInUse";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "OriginRequestPolicyInUse",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _OriginRequestPolicyInUse.prototype);
    this.Message = opts.Message;
  }
};
var PublicKeyInUse = class _PublicKeyInUse extends CloudFrontServiceException {
  static {
    __name(this, "PublicKeyInUse");
  }
  name = "PublicKeyInUse";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "PublicKeyInUse",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _PublicKeyInUse.prototype);
    this.Message = opts.Message;
  }
};
var RealtimeLogConfigInUse = class _RealtimeLogConfigInUse extends CloudFrontServiceException {
  static {
    __name(this, "RealtimeLogConfigInUse");
  }
  name = "RealtimeLogConfigInUse";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "RealtimeLogConfigInUse",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _RealtimeLogConfigInUse.prototype);
    this.Message = opts.Message;
  }
};
var ResponseHeadersPolicyInUse = class _ResponseHeadersPolicyInUse extends CloudFrontServiceException {
  static {
    __name(this, "ResponseHeadersPolicyInUse");
  }
  name = "ResponseHeadersPolicyInUse";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "ResponseHeadersPolicyInUse",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _ResponseHeadersPolicyInUse.prototype);
    this.Message = opts.Message;
  }
};
var NoSuchStreamingDistribution = class _NoSuchStreamingDistribution extends CloudFrontServiceException {
  static {
    __name(this, "NoSuchStreamingDistribution");
  }
  name = "NoSuchStreamingDistribution";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "NoSuchStreamingDistribution",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _NoSuchStreamingDistribution.prototype);
    this.Message = opts.Message;
  }
};
var StreamingDistributionNotDisabled = class _StreamingDistributionNotDisabled extends CloudFrontServiceException {
  static {
    __name(this, "StreamingDistributionNotDisabled");
  }
  name = "StreamingDistributionNotDisabled";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "StreamingDistributionNotDisabled",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _StreamingDistributionNotDisabled.prototype);
    this.Message = opts.Message;
  }
};
var NoSuchInvalidation = class _NoSuchInvalidation extends CloudFrontServiceException {
  static {
    __name(this, "NoSuchInvalidation");
  }
  name = "NoSuchInvalidation";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "NoSuchInvalidation",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _NoSuchInvalidation.prototype);
    this.Message = opts.Message;
  }
};
var ManagedCertificateStatus = {
  Expired: "expired",
  Failed: "failed",
  Inactive: "inactive",
  Issued: "issued",
  PendingValidation: "pending-validation",
  Revoked: "revoked",
  ValidationTimedOut: "validation-timed-out"
};
var DistributionResourceType = {
  Distribution: "distribution",
  DistributionTenant: "distribution-tenant"
};
var OriginRequestPolicyType = {
  custom: "custom",
  managed: "managed"
};
var ResponseHeadersPolicyType = {
  custom: "custom",
  managed: "managed"
};
var GetDistributionResultFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.Distribution && { Distribution: DistributionFilterSensitiveLog(obj.Distribution) }
}), "GetDistributionResultFilterSensitiveLog");
var GetDistributionConfigResultFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.DistributionConfig && { DistributionConfig: DistributionConfigFilterSensitiveLog(obj.DistributionConfig) }
}), "GetDistributionConfigResultFilterSensitiveLog");
var GetFunctionResultFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.FunctionCode && { FunctionCode: import_smithy_client.SENSITIVE_STRING }
}), "GetFunctionResultFilterSensitiveLog");
var DistributionSummaryFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj
}), "DistributionSummaryFilterSensitiveLog");
var DistributionListFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj
}), "DistributionListFilterSensitiveLog");
var ListDistributionsResultFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj
}), "ListDistributionsResultFilterSensitiveLog");
var ListDistributionsByAnycastIpListIdResultFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj
}), "ListDistributionsByAnycastIpListIdResultFilterSensitiveLog");
var ListDistributionsByConnectionModeResultFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj
}), "ListDistributionsByConnectionModeResultFilterSensitiveLog");
var ListDistributionsByRealtimeLogConfigResultFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj
}), "ListDistributionsByRealtimeLogConfigResultFilterSensitiveLog");
var ListDistributionsByWebACLIdResultFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj
}), "ListDistributionsByWebACLIdResultFilterSensitiveLog");

// src/models/models_2.ts

var TestFunctionFailed = class _TestFunctionFailed extends CloudFrontServiceException {
  static {
    __name(this, "TestFunctionFailed");
  }
  name = "TestFunctionFailed";
  $fault = "server";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "TestFunctionFailed",
      $fault: "server",
      ...opts
    });
    Object.setPrototypeOf(this, _TestFunctionFailed.prototype);
    this.Message = opts.Message;
  }
};
var DnsConfigurationStatus = {
  Invalid: "invalid-configuration",
  Unknown: "unknown-configuration",
  Valid: "valid-configuration"
};
var TestFunctionRequestFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.EventObject && { EventObject: import_smithy_client.SENSITIVE_STRING }
}), "TestFunctionRequestFilterSensitiveLog");
var TestResultFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.FunctionExecutionLogs && { FunctionExecutionLogs: import_smithy_client.SENSITIVE_STRING },
  ...obj.FunctionErrorMessage && { FunctionErrorMessage: import_smithy_client.SENSITIVE_STRING },
  ...obj.FunctionOutput && { FunctionOutput: import_smithy_client.SENSITIVE_STRING }
}), "TestResultFilterSensitiveLog");
var TestFunctionResultFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.TestResult && { TestResult: TestResultFilterSensitiveLog(obj.TestResult) }
}), "TestFunctionResultFilterSensitiveLog");
var UpdateDistributionRequestFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.DistributionConfig && { DistributionConfig: DistributionConfigFilterSensitiveLog(obj.DistributionConfig) }
}), "UpdateDistributionRequestFilterSensitiveLog");
var UpdateDistributionResultFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.Distribution && { Distribution: DistributionFilterSensitiveLog(obj.Distribution) }
}), "UpdateDistributionResultFilterSensitiveLog");
var UpdateDistributionWithStagingConfigResultFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.Distribution && { Distribution: DistributionFilterSensitiveLog(obj.Distribution) }
}), "UpdateDistributionWithStagingConfigResultFilterSensitiveLog");
var UpdateFunctionRequestFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.FunctionCode && { FunctionCode: import_smithy_client.SENSITIVE_STRING }
}), "UpdateFunctionRequestFilterSensitiveLog");

// src/protocols/Aws_restXml.ts
var se_AssociateAliasCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = {};
  b.bp("/2020-05-31/distribution/{TargetDistributionId}/associate-alias");
  b.p("TargetDistributionId", () => input.TargetDistributionId, "{TargetDistributionId}", false);
  const query = (0, import_smithy_client.map)({
    [_A]: [, (0, import_smithy_client.expectNonNull)(input[_A], `Alias`)]
  });
  let body;
  b.m("PUT").h(headers).q(query).b(body);
  return b.build();
}, "se_AssociateAliasCommand");
var se_AssociateDistributionTenantWebACLCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = (0, import_smithy_client.map)({}, import_smithy_client.isSerializableHeaderValue, {
    "content-type": "application/xml",
    [_im]: input[_IM]
  });
  b.bp("/2020-05-31/distribution-tenant/{Id}/associate-web-acl");
  b.p("Id", () => input.Id, "{Id}", false);
  let body;
  body = _ve;
  const bn = new import_xml_builder.XmlNode(_ADTWACLR);
  bn.a("xmlns", "http://cloudfront.amazonaws.com/doc/2020-05-31/");
  if (input[_WACLA] != null) {
    bn.c(import_xml_builder.XmlNode.of(_s, input[_WACLA]).n(_WACLA));
  }
  body += bn.toString();
  b.m("PUT").h(headers).b(body);
  return b.build();
}, "se_AssociateDistributionTenantWebACLCommand");
var se_AssociateDistributionWebACLCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = (0, import_smithy_client.map)({}, import_smithy_client.isSerializableHeaderValue, {
    "content-type": "application/xml",
    [_im]: input[_IM]
  });
  b.bp("/2020-05-31/distribution/{Id}/associate-web-acl");
  b.p("Id", () => input.Id, "{Id}", false);
  let body;
  body = _ve;
  const bn = new import_xml_builder.XmlNode(_ADWACLR);
  bn.a("xmlns", "http://cloudfront.amazonaws.com/doc/2020-05-31/");
  if (input[_WACLA] != null) {
    bn.c(import_xml_builder.XmlNode.of(_s, input[_WACLA]).n(_WACLA));
  }
  body += bn.toString();
  b.m("PUT").h(headers).b(body);
  return b.build();
}, "se_AssociateDistributionWebACLCommand");
var se_CopyDistributionCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = (0, import_smithy_client.map)({}, import_smithy_client.isSerializableHeaderValue, {
    "content-type": "application/xml",
    [_st]: [() => (0, import_smithy_client.isSerializableHeaderValue)(input[_S]), () => input[_S].toString()],
    [_im]: input[_IM]
  });
  b.bp("/2020-05-31/distribution/{PrimaryDistributionId}/copy");
  b.p("PrimaryDistributionId", () => input.PrimaryDistributionId, "{PrimaryDistributionId}", false);
  let body;
  body = _ve;
  const bn = new import_xml_builder.XmlNode(_CDR);
  bn.a("xmlns", "http://cloudfront.amazonaws.com/doc/2020-05-31/");
  if (input[_CR] != null) {
    bn.c(import_xml_builder.XmlNode.of(_s, input[_CR]).n(_CR));
  }
  if (input[_E] != null) {
    bn.c(import_xml_builder.XmlNode.of(_b, String(input[_E])).n(_E));
  }
  body += bn.toString();
  b.m("POST").h(headers).b(body);
  return b.build();
}, "se_CopyDistributionCommand");
var se_CreateAnycastIpListCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = {
    "content-type": "application/xml"
  };
  b.bp("/2020-05-31/anycast-ip-list");
  let body;
  body = _ve;
  const bn = new import_xml_builder.XmlNode(_CAILR);
  bn.a("xmlns", "http://cloudfront.amazonaws.com/doc/2020-05-31/");
  if (input[_IC] != null) {
    bn.c(import_xml_builder.XmlNode.of(_i, String(input[_IC])).n(_IC));
  }
  if (input[_N] != null) {
    bn.c(import_xml_builder.XmlNode.of(_AILN, input[_N]).n(_N));
  }
  if (input[_T] != null) {
    bn.c(se_Tags(input[_T], context).n(_T));
  }
  body += bn.toString();
  b.m("POST").h(headers).b(body);
  return b.build();
}, "se_CreateAnycastIpListCommand");
var se_CreateCachePolicyCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = {
    "content-type": "application/xml"
  };
  b.bp("/2020-05-31/cache-policy");
  let body;
  let contents;
  if (input.CachePolicyConfig !== void 0) {
    contents = se_CachePolicyConfig(input.CachePolicyConfig, context);
    body = _ve;
    contents.a("xmlns", "http://cloudfront.amazonaws.com/doc/2020-05-31/");
    body += contents.toString();
  }
  b.m("POST").h(headers).b(body);
  return b.build();
}, "se_CreateCachePolicyCommand");
var se_CreateCloudFrontOriginAccessIdentityCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = {
    "content-type": "application/xml"
  };
  b.bp("/2020-05-31/origin-access-identity/cloudfront");
  let body;
  let contents;
  if (input.CloudFrontOriginAccessIdentityConfig !== void 0) {
    contents = se_CloudFrontOriginAccessIdentityConfig(input.CloudFrontOriginAccessIdentityConfig, context);
    body = _ve;
    contents.a("xmlns", "http://cloudfront.amazonaws.com/doc/2020-05-31/");
    body += contents.toString();
  }
  b.m("POST").h(headers).b(body);
  return b.build();
}, "se_CreateCloudFrontOriginAccessIdentityCommand");
var se_CreateConnectionGroupCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = {
    "content-type": "application/xml"
  };
  b.bp("/2020-05-31/connection-group");
  let body;
  body = _ve;
  const bn = new import_xml_builder.XmlNode(_CCGR);
  bn.a("xmlns", "http://cloudfront.amazonaws.com/doc/2020-05-31/");
  if (input[_AILI] != null) {
    bn.c(import_xml_builder.XmlNode.of(_s, input[_AILI]).n(_AILI));
  }
  if (input[_E] != null) {
    bn.c(import_xml_builder.XmlNode.of(_b, String(input[_E])).n(_E));
  }
  if (input[_IE] != null) {
    bn.c(import_xml_builder.XmlNode.of(_b, String(input[_IE])).n(_IE));
  }
  if (input[_N] != null) {
    bn.c(import_xml_builder.XmlNode.of(_s, input[_N]).n(_N));
  }
  if (input[_T] != null) {
    bn.c(se_Tags(input[_T], context).n(_T));
  }
  body += bn.toString();
  b.m("POST").h(headers).b(body);
  return b.build();
}, "se_CreateConnectionGroupCommand");
var se_CreateContinuousDeploymentPolicyCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = {
    "content-type": "application/xml"
  };
  b.bp("/2020-05-31/continuous-deployment-policy");
  let body;
  let contents;
  if (input.ContinuousDeploymentPolicyConfig !== void 0) {
    contents = se_ContinuousDeploymentPolicyConfig(input.ContinuousDeploymentPolicyConfig, context);
    body = _ve;
    contents.a("xmlns", "http://cloudfront.amazonaws.com/doc/2020-05-31/");
    body += contents.toString();
  }
  b.m("POST").h(headers).b(body);
  return b.build();
}, "se_CreateContinuousDeploymentPolicyCommand");
var se_CreateDistributionCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = {
    "content-type": "application/xml"
  };
  b.bp("/2020-05-31/distribution");
  let body;
  let contents;
  if (input.DistributionConfig !== void 0) {
    contents = se_DistributionConfig(input.DistributionConfig, context);
    body = _ve;
    contents.a("xmlns", "http://cloudfront.amazonaws.com/doc/2020-05-31/");
    body += contents.toString();
  }
  b.m("POST").h(headers).b(body);
  return b.build();
}, "se_CreateDistributionCommand");
var se_CreateDistributionTenantCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = {
    "content-type": "application/xml"
  };
  b.bp("/2020-05-31/distribution-tenant");
  let body;
  body = _ve;
  const bn = new import_xml_builder.XmlNode(_CDTR);
  bn.a("xmlns", "http://cloudfront.amazonaws.com/doc/2020-05-31/");
  if (input[_CGI] != null) {
    bn.c(import_xml_builder.XmlNode.of(_s, input[_CGI]).n(_CGI));
  }
  if (input[_C] != null) {
    bn.c(se_Customizations(input[_C], context).n(_C));
  }
  if (input[_DI] != null) {
    bn.c(import_xml_builder.XmlNode.of(_s, input[_DI]).n(_DI));
  }
  bn.lc(input, "Domains", "Domains", () => se_DomainList(input[_D], context));
  if (input[_E] != null) {
    bn.c(import_xml_builder.XmlNode.of(_b, String(input[_E])).n(_E));
  }
  if (input[_MCR] != null) {
    bn.c(se_ManagedCertificateRequest(input[_MCR], context).n(_MCR));
  }
  if (input[_N] != null) {
    bn.c(import_xml_builder.XmlNode.of(_s, input[_N]).n(_N));
  }
  bn.lc(input, "Parameters", "Parameters", () => se_Parameters(input[_P], context));
  if (input[_T] != null) {
    bn.c(se_Tags(input[_T], context).n(_T));
  }
  body += bn.toString();
  b.m("POST").h(headers).b(body);
  return b.build();
}, "se_CreateDistributionTenantCommand");
var se_CreateDistributionWithTagsCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = {
    "content-type": "application/xml"
  };
  b.bp("/2020-05-31/distribution");
  const query = (0, import_smithy_client.map)({
    [_WT]: [, ""]
  });
  let body;
  let contents;
  if (input.DistributionConfigWithTags !== void 0) {
    contents = se_DistributionConfigWithTags(input.DistributionConfigWithTags, context);
    body = _ve;
    contents.a("xmlns", "http://cloudfront.amazonaws.com/doc/2020-05-31/");
    body += contents.toString();
  }
  b.m("POST").h(headers).q(query).b(body);
  return b.build();
}, "se_CreateDistributionWithTagsCommand");
var se_CreateFieldLevelEncryptionConfigCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = {
    "content-type": "application/xml"
  };
  b.bp("/2020-05-31/field-level-encryption");
  let body;
  let contents;
  if (input.FieldLevelEncryptionConfig !== void 0) {
    contents = se_FieldLevelEncryptionConfig(input.FieldLevelEncryptionConfig, context);
    body = _ve;
    contents.a("xmlns", "http://cloudfront.amazonaws.com/doc/2020-05-31/");
    body += contents.toString();
  }
  b.m("POST").h(headers).b(body);
  return b.build();
}, "se_CreateFieldLevelEncryptionConfigCommand");
var se_CreateFieldLevelEncryptionProfileCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = {
    "content-type": "application/xml"
  };
  b.bp("/2020-05-31/field-level-encryption-profile");
  let body;
  let contents;
  if (input.FieldLevelEncryptionProfileConfig !== void 0) {
    contents = se_FieldLevelEncryptionProfileConfig(input.FieldLevelEncryptionProfileConfig, context);
    body = _ve;
    contents.a("xmlns", "http://cloudfront.amazonaws.com/doc/2020-05-31/");
    body += contents.toString();
  }
  b.m("POST").h(headers).b(body);
  return b.build();
}, "se_CreateFieldLevelEncryptionProfileCommand");
var se_CreateFunctionCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = {
    "content-type": "application/xml"
  };
  b.bp("/2020-05-31/function");
  let body;
  body = _ve;
  const bn = new import_xml_builder.XmlNode(_CFR);
  bn.a("xmlns", "http://cloudfront.amazonaws.com/doc/2020-05-31/");
  if (input[_FC] != null) {
    bn.c(import_xml_builder.XmlNode.of(_FB, context.base64Encoder(input[_FC])).n(_FC));
  }
  if (input[_FCu] != null) {
    bn.c(se_FunctionConfig(input[_FCu], context).n(_FCu));
  }
  if (input[_N] != null) {
    bn.c(import_xml_builder.XmlNode.of(_FN, input[_N]).n(_N));
  }
  body += bn.toString();
  b.m("POST").h(headers).b(body);
  return b.build();
}, "se_CreateFunctionCommand");
var se_CreateInvalidationCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = {
    "content-type": "application/xml"
  };
  b.bp("/2020-05-31/distribution/{DistributionId}/invalidation");
  b.p("DistributionId", () => input.DistributionId, "{DistributionId}", false);
  let body;
  let contents;
  if (input.InvalidationBatch !== void 0) {
    contents = se_InvalidationBatch(input.InvalidationBatch, context);
    body = _ve;
    contents.a("xmlns", "http://cloudfront.amazonaws.com/doc/2020-05-31/");
    body += contents.toString();
  }
  b.m("POST").h(headers).b(body);
  return b.build();
}, "se_CreateInvalidationCommand");
var se_CreateInvalidationForDistributionTenantCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = {
    "content-type": "application/xml"
  };
  b.bp("/2020-05-31/distribution-tenant/{Id}/invalidation");
  b.p("Id", () => input.Id, "{Id}", false);
  let body;
  let contents;
  if (input.InvalidationBatch !== void 0) {
    contents = se_InvalidationBatch(input.InvalidationBatch, context);
    body = _ve;
    contents.a("xmlns", "http://cloudfront.amazonaws.com/doc/2020-05-31/");
    body += contents.toString();
  }
  b.m("POST").h(headers).b(body);
  return b.build();
}, "se_CreateInvalidationForDistributionTenantCommand");
var se_CreateKeyGroupCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = {
    "content-type": "application/xml"
  };
  b.bp("/2020-05-31/key-group");
  let body;
  let contents;
  if (input.KeyGroupConfig !== void 0) {
    contents = se_KeyGroupConfig(input.KeyGroupConfig, context);
    body = _ve;
    contents.a("xmlns", "http://cloudfront.amazonaws.com/doc/2020-05-31/");
    body += contents.toString();
  }
  b.m("POST").h(headers).b(body);
  return b.build();
}, "se_CreateKeyGroupCommand");
var se_CreateKeyValueStoreCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = {
    "content-type": "application/xml"
  };
  b.bp("/2020-05-31/key-value-store");
  let body;
  body = _ve;
  const bn = new import_xml_builder.XmlNode(_CKVSR);
  bn.a("xmlns", "http://cloudfront.amazonaws.com/doc/2020-05-31/");
  if (input[_Co] != null) {
    bn.c(import_xml_builder.XmlNode.of(_KVSC, input[_Co]).n(_Co));
  }
  if (input[_IS] != null) {
    bn.c(se_ImportSource(input[_IS], context).n(_IS));
  }
  if (input[_N] != null) {
    bn.c(import_xml_builder.XmlNode.of(_KVSN, input[_N]).n(_N));
  }
  body += bn.toString();
  b.m("POST").h(headers).b(body);
  return b.build();
}, "se_CreateKeyValueStoreCommand");
var se_CreateMonitoringSubscriptionCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = {
    "content-type": "application/xml"
  };
  b.bp("/2020-05-31/distributions/{DistributionId}/monitoring-subscription");
  b.p("DistributionId", () => input.DistributionId, "{DistributionId}", false);
  let body;
  let contents;
  if (input.MonitoringSubscription !== void 0) {
    contents = se_MonitoringSubscription(input.MonitoringSubscription, context);
    body = _ve;
    contents.a("xmlns", "http://cloudfront.amazonaws.com/doc/2020-05-31/");
    body += contents.toString();
  }
  b.m("POST").h(headers).b(body);
  return b.build();
}, "se_CreateMonitoringSubscriptionCommand");
var se_CreateOriginAccessControlCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = {
    "content-type": "application/xml"
  };
  b.bp("/2020-05-31/origin-access-control");
  let body;
  let contents;
  if (input.OriginAccessControlConfig !== void 0) {
    contents = se_OriginAccessControlConfig(input.OriginAccessControlConfig, context);
    body = _ve;
    contents.a("xmlns", "http://cloudfront.amazonaws.com/doc/2020-05-31/");
    body += contents.toString();
  }
  b.m("POST").h(headers).b(body);
  return b.build();
}, "se_CreateOriginAccessControlCommand");
var se_CreateOriginRequestPolicyCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = {
    "content-type": "application/xml"
  };
  b.bp("/2020-05-31/origin-request-policy");
  let body;
  let contents;
  if (input.OriginRequestPolicyConfig !== void 0) {
    contents = se_OriginRequestPolicyConfig(input.OriginRequestPolicyConfig, context);
    body = _ve;
    contents.a("xmlns", "http://cloudfront.amazonaws.com/doc/2020-05-31/");
    body += contents.toString();
  }
  b.m("POST").h(headers).b(body);
  return b.build();
}, "se_CreateOriginRequestPolicyCommand");
var se_CreatePublicKeyCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = {
    "content-type": "application/xml"
  };
  b.bp("/2020-05-31/public-key");
  let body;
  let contents;
  if (input.PublicKeyConfig !== void 0) {
    contents = se_PublicKeyConfig(input.PublicKeyConfig, context);
    body = _ve;
    contents.a("xmlns", "http://cloudfront.amazonaws.com/doc/2020-05-31/");
    body += contents.toString();
  }
  b.m("POST").h(headers).b(body);
  return b.build();
}, "se_CreatePublicKeyCommand");
var se_CreateRealtimeLogConfigCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = {
    "content-type": "application/xml"
  };
  b.bp("/2020-05-31/realtime-log-config");
  let body;
  body = _ve;
  const bn = new import_xml_builder.XmlNode(_CRLCR);
  bn.a("xmlns", "http://cloudfront.amazonaws.com/doc/2020-05-31/");
  bn.lc(input, "EndPoints", "EndPoints", () => se_EndPointList(input[_EP], context));
  bn.lc(input, "Fields", "Fields", () => se_FieldList(input[_F], context));
  if (input[_N] != null) {
    bn.c(import_xml_builder.XmlNode.of(_s, input[_N]).n(_N));
  }
  if (input[_SR] != null) {
    bn.c(import_xml_builder.XmlNode.of(_l, String(input[_SR])).n(_SR));
  }
  body += bn.toString();
  b.m("POST").h(headers).b(body);
  return b.build();
}, "se_CreateRealtimeLogConfigCommand");
var se_CreateResponseHeadersPolicyCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = {
    "content-type": "application/xml"
  };
  b.bp("/2020-05-31/response-headers-policy");
  let body;
  let contents;
  if (input.ResponseHeadersPolicyConfig !== void 0) {
    contents = se_ResponseHeadersPolicyConfig(input.ResponseHeadersPolicyConfig, context);
    body = _ve;
    contents.a("xmlns", "http://cloudfront.amazonaws.com/doc/2020-05-31/");
    body += contents.toString();
  }
  b.m("POST").h(headers).b(body);
  return b.build();
}, "se_CreateResponseHeadersPolicyCommand");
var se_CreateStreamingDistributionCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = {
    "content-type": "application/xml"
  };
  b.bp("/2020-05-31/streaming-distribution");
  let body;
  let contents;
  if (input.StreamingDistributionConfig !== void 0) {
    contents = se_StreamingDistributionConfig(input.StreamingDistributionConfig, context);
    body = _ve;
    contents.a("xmlns", "http://cloudfront.amazonaws.com/doc/2020-05-31/");
    body += contents.toString();
  }
  b.m("POST").h(headers).b(body);
  return b.build();
}, "se_CreateStreamingDistributionCommand");
var se_CreateStreamingDistributionWithTagsCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = {
    "content-type": "application/xml"
  };
  b.bp("/2020-05-31/streaming-distribution");
  const query = (0, import_smithy_client.map)({
    [_WT]: [, ""]
  });
  let body;
  let contents;
  if (input.StreamingDistributionConfigWithTags !== void 0) {
    contents = se_StreamingDistributionConfigWithTags(input.StreamingDistributionConfigWithTags, context);
    body = _ve;
    contents.a("xmlns", "http://cloudfront.amazonaws.com/doc/2020-05-31/");
    body += contents.toString();
  }
  b.m("POST").h(headers).q(query).b(body);
  return b.build();
}, "se_CreateStreamingDistributionWithTagsCommand");
var se_CreateVpcOriginCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = {
    "content-type": "application/xml"
  };
  b.bp("/2020-05-31/vpc-origin");
  let body;
  body = _ve;
  const bn = new import_xml_builder.XmlNode(_CVOR);
  bn.a("xmlns", "http://cloudfront.amazonaws.com/doc/2020-05-31/");
  if (input[_T] != null) {
    bn.c(se_Tags(input[_T], context).n(_T));
  }
  if (input[_VOEC] != null) {
    bn.c(se_VpcOriginEndpointConfig(input[_VOEC], context).n(_VOEC));
  }
  body += bn.toString();
  b.m("POST").h(headers).b(body);
  return b.build();
}, "se_CreateVpcOriginCommand");
var se_DeleteAnycastIpListCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = (0, import_smithy_client.map)({}, import_smithy_client.isSerializableHeaderValue, {
    [_im]: input[_IM]
  });
  b.bp("/2020-05-31/anycast-ip-list/{Id}");
  b.p("Id", () => input.Id, "{Id}", false);
  let body;
  b.m("DELETE").h(headers).b(body);
  return b.build();
}, "se_DeleteAnycastIpListCommand");
var se_DeleteCachePolicyCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = (0, import_smithy_client.map)({}, import_smithy_client.isSerializableHeaderValue, {
    [_im]: input[_IM]
  });
  b.bp("/2020-05-31/cache-policy/{Id}");
  b.p("Id", () => input.Id, "{Id}", false);
  let body;
  b.m("DELETE").h(headers).b(body);
  return b.build();
}, "se_DeleteCachePolicyCommand");
var se_DeleteCloudFrontOriginAccessIdentityCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = (0, import_smithy_client.map)({}, import_smithy_client.isSerializableHeaderValue, {
    [_im]: input[_IM]
  });
  b.bp("/2020-05-31/origin-access-identity/cloudfront/{Id}");
  b.p("Id", () => input.Id, "{Id}", false);
  let body;
  b.m("DELETE").h(headers).b(body);
  return b.build();
}, "se_DeleteCloudFrontOriginAccessIdentityCommand");
var se_DeleteConnectionGroupCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = (0, import_smithy_client.map)({}, import_smithy_client.isSerializableHeaderValue, {
    [_im]: input[_IM]
  });
  b.bp("/2020-05-31/connection-group/{Id}");
  b.p("Id", () => input.Id, "{Id}", false);
  let body;
  b.m("DELETE").h(headers).b(body);
  return b.build();
}, "se_DeleteConnectionGroupCommand");
var se_DeleteContinuousDeploymentPolicyCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = (0, import_smithy_client.map)({}, import_smithy_client.isSerializableHeaderValue, {
    [_im]: input[_IM]
  });
  b.bp("/2020-05-31/continuous-deployment-policy/{Id}");
  b.p("Id", () => input.Id, "{Id}", false);
  let body;
  b.m("DELETE").h(headers).b(body);
  return b.build();
}, "se_DeleteContinuousDeploymentPolicyCommand");
var se_DeleteDistributionCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = (0, import_smithy_client.map)({}, import_smithy_client.isSerializableHeaderValue, {
    [_im]: input[_IM]
  });
  b.bp("/2020-05-31/distribution/{Id}");
  b.p("Id", () => input.Id, "{Id}", false);
  let body;
  b.m("DELETE").h(headers).b(body);
  return b.build();
}, "se_DeleteDistributionCommand");
var se_DeleteDistributionTenantCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = (0, import_smithy_client.map)({}, import_smithy_client.isSerializableHeaderValue, {
    [_im]: input[_IM]
  });
  b.bp("/2020-05-31/distribution-tenant/{Id}");
  b.p("Id", () => input.Id, "{Id}", false);
  let body;
  b.m("DELETE").h(headers).b(body);
  return b.build();
}, "se_DeleteDistributionTenantCommand");
var se_DeleteFieldLevelEncryptionConfigCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = (0, import_smithy_client.map)({}, import_smithy_client.isSerializableHeaderValue, {
    [_im]: input[_IM]
  });
  b.bp("/2020-05-31/field-level-encryption/{Id}");
  b.p("Id", () => input.Id, "{Id}", false);
  let body;
  b.m("DELETE").h(headers).b(body);
  return b.build();
}, "se_DeleteFieldLevelEncryptionConfigCommand");
var se_DeleteFieldLevelEncryptionProfileCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = (0, import_smithy_client.map)({}, import_smithy_client.isSerializableHeaderValue, {
    [_im]: input[_IM]
  });
  b.bp("/2020-05-31/field-level-encryption-profile/{Id}");
  b.p("Id", () => input.Id, "{Id}", false);
  let body;
  b.m("DELETE").h(headers).b(body);
  return b.build();
}, "se_DeleteFieldLevelEncryptionProfileCommand");
var se_DeleteFunctionCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = (0, import_smithy_client.map)({}, import_smithy_client.isSerializableHeaderValue, {
    [_im]: input[_IM]
  });
  b.bp("/2020-05-31/function/{Name}");
  b.p("Name", () => input.Name, "{Name}", false);
  let body;
  b.m("DELETE").h(headers).b(body);
  return b.build();
}, "se_DeleteFunctionCommand");
var se_DeleteKeyGroupCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = (0, import_smithy_client.map)({}, import_smithy_client.isSerializableHeaderValue, {
    [_im]: input[_IM]
  });
  b.bp("/2020-05-31/key-group/{Id}");
  b.p("Id", () => input.Id, "{Id}", false);
  let body;
  b.m("DELETE").h(headers).b(body);
  return b.build();
}, "se_DeleteKeyGroupCommand");
var se_DeleteKeyValueStoreCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = (0, import_smithy_client.map)({}, import_smithy_client.isSerializableHeaderValue, {
    [_im]: input[_IM]
  });
  b.bp("/2020-05-31/key-value-store/{Name}");
  b.p("Name", () => input.Name, "{Name}", false);
  let body;
  b.m("DELETE").h(headers).b(body);
  return b.build();
}, "se_DeleteKeyValueStoreCommand");
var se_DeleteMonitoringSubscriptionCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = {};
  b.bp("/2020-05-31/distributions/{DistributionId}/monitoring-subscription");
  b.p("DistributionId", () => input.DistributionId, "{DistributionId}", false);
  let body;
  b.m("DELETE").h(headers).b(body);
  return b.build();
}, "se_DeleteMonitoringSubscriptionCommand");
var se_DeleteOriginAccessControlCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = (0, import_smithy_client.map)({}, import_smithy_client.isSerializableHeaderValue, {
    [_im]: input[_IM]
  });
  b.bp("/2020-05-31/origin-access-control/{Id}");
  b.p("Id", () => input.Id, "{Id}", false);
  let body;
  b.m("DELETE").h(headers).b(body);
  return b.build();
}, "se_DeleteOriginAccessControlCommand");
var se_DeleteOriginRequestPolicyCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = (0, import_smithy_client.map)({}, import_smithy_client.isSerializableHeaderValue, {
    [_im]: input[_IM]
  });
  b.bp("/2020-05-31/origin-request-policy/{Id}");
  b.p("Id", () => input.Id, "{Id}", false);
  let body;
  b.m("DELETE").h(headers).b(body);
  return b.build();
}, "se_DeleteOriginRequestPolicyCommand");
var se_DeletePublicKeyCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = (0, import_smithy_client.map)({}, import_smithy_client.isSerializableHeaderValue, {
    [_im]: input[_IM]
  });
  b.bp("/2020-05-31/public-key/{Id}");
  b.p("Id", () => input.Id, "{Id}", false);
  let body;
  b.m("DELETE").h(headers).b(body);
  return b.build();
}, "se_DeletePublicKeyCommand");
var se_DeleteRealtimeLogConfigCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = {
    "content-type": "application/xml"
  };
  b.bp("/2020-05-31/delete-realtime-log-config");
  let body;
  body = _ve;
  const bn = new import_xml_builder.XmlNode(_DRLCR);
  bn.a("xmlns", "http://cloudfront.amazonaws.com/doc/2020-05-31/");
  if (input[_ARN] != null) {
    bn.c(import_xml_builder.XmlNode.of(_s, input[_ARN]).n(_ARN));
  }
  if (input[_N] != null) {
    bn.c(import_xml_builder.XmlNode.of(_s, input[_N]).n(_N));
  }
  body += bn.toString();
  b.m("POST").h(headers).b(body);
  return b.build();
}, "se_DeleteRealtimeLogConfigCommand");
var se_DeleteResponseHeadersPolicyCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = (0, import_smithy_client.map)({}, import_smithy_client.isSerializableHeaderValue, {
    [_im]: input[_IM]
  });
  b.bp("/2020-05-31/response-headers-policy/{Id}");
  b.p("Id", () => input.Id, "{Id}", false);
  let body;
  b.m("DELETE").h(headers).b(body);
  return b.build();
}, "se_DeleteResponseHeadersPolicyCommand");
var se_DeleteStreamingDistributionCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = (0, import_smithy_client.map)({}, import_smithy_client.isSerializableHeaderValue, {
    [_im]: input[_IM]
  });
  b.bp("/2020-05-31/streaming-distribution/{Id}");
  b.p("Id", () => input.Id, "{Id}", false);
  let body;
  b.m("DELETE").h(headers).b(body);
  return b.build();
}, "se_DeleteStreamingDistributionCommand");
var se_DeleteVpcOriginCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = (0, import_smithy_client.map)({}, import_smithy_client.isSerializableHeaderValue, {
    [_im]: input[_IM]
  });
  b.bp("/2020-05-31/vpc-origin/{Id}");
  b.p("Id", () => input.Id, "{Id}", false);
  let body;
  b.m("DELETE").h(headers).b(body);
  return b.build();
}, "se_DeleteVpcOriginCommand");
var se_DescribeFunctionCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = {};
  b.bp("/2020-05-31/function/{Name}/describe");
  b.p("Name", () => input.Name, "{Name}", false);
  const query = (0, import_smithy_client.map)({
    [_St]: [, input[_St]]
  });
  let body;
  b.m("GET").h(headers).q(query).b(body);
  return b.build();
}, "se_DescribeFunctionCommand");
var se_DescribeKeyValueStoreCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = {};
  b.bp("/2020-05-31/key-value-store/{Name}");
  b.p("Name", () => input.Name, "{Name}", false);
  let body;
  b.m("GET").h(headers).b(body);
  return b.build();
}, "se_DescribeKeyValueStoreCommand");
var se_DisassociateDistributionTenantWebACLCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = (0, import_smithy_client.map)({}, import_smithy_client.isSerializableHeaderValue, {
    [_im]: input[_IM]
  });
  b.bp("/2020-05-31/distribution-tenant/{Id}/disassociate-web-acl");
  b.p("Id", () => input.Id, "{Id}", false);
  let body;
  b.m("PUT").h(headers).b(body);
  return b.build();
}, "se_DisassociateDistributionTenantWebACLCommand");
var se_DisassociateDistributionWebACLCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = (0, import_smithy_client.map)({}, import_smithy_client.isSerializableHeaderValue, {
    [_im]: input[_IM]
  });
  b.bp("/2020-05-31/distribution/{Id}/disassociate-web-acl");
  b.p("Id", () => input.Id, "{Id}", false);
  let body;
  b.m("PUT").h(headers).b(body);
  return b.build();
}, "se_DisassociateDistributionWebACLCommand");
var se_GetAnycastIpListCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = {};
  b.bp("/2020-05-31/anycast-ip-list/{Id}");
  b.p("Id", () => input.Id, "{Id}", false);
  let body;
  b.m("GET").h(headers).b(body);
  return b.build();
}, "se_GetAnycastIpListCommand");
var se_GetCachePolicyCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = {};
  b.bp("/2020-05-31/cache-policy/{Id}");
  b.p("Id", () => input.Id, "{Id}", false);
  let body;
  b.m("GET").h(headers).b(body);
  return b.build();
}, "se_GetCachePolicyCommand");
var se_GetCachePolicyConfigCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = {};
  b.bp("/2020-05-31/cache-policy/{Id}/config");
  b.p("Id", () => input.Id, "{Id}", false);
  let body;
  b.m("GET").h(headers).b(body);
  return b.build();
}, "se_GetCachePolicyConfigCommand");
var se_GetCloudFrontOriginAccessIdentityCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = {};
  b.bp("/2020-05-31/origin-access-identity/cloudfront/{Id}");
  b.p("Id", () => input.Id, "{Id}", false);
  let body;
  b.m("GET").h(headers).b(body);
  return b.build();
}, "se_GetCloudFrontOriginAccessIdentityCommand");
var se_GetCloudFrontOriginAccessIdentityConfigCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = {};
  b.bp("/2020-05-31/origin-access-identity/cloudfront/{Id}/config");
  b.p("Id", () => input.Id, "{Id}", false);
  let body;
  b.m("GET").h(headers).b(body);
  return b.build();
}, "se_GetCloudFrontOriginAccessIdentityConfigCommand");
var se_GetConnectionGroupCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = {};
  b.bp("/2020-05-31/connection-group/{Identifier}");
  b.p("Identifier", () => input.Identifier, "{Identifier}", false);
  let body;
  b.m("GET").h(headers).b(body);
  return b.build();
}, "se_GetConnectionGroupCommand");
var se_GetConnectionGroupByRoutingEndpointCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = {};
  b.bp("/2020-05-31/connection-group");
  const query = (0, import_smithy_client.map)({
    [_RE]: [, (0, import_smithy_client.expectNonNull)(input[_RE], `RoutingEndpoint`)]
  });
  let body;
  b.m("GET").h(headers).q(query).b(body);
  return b.build();
}, "se_GetConnectionGroupByRoutingEndpointCommand");
var se_GetContinuousDeploymentPolicyCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = {};
  b.bp("/2020-05-31/continuous-deployment-policy/{Id}");
  b.p("Id", () => input.Id, "{Id}", false);
  let body;
  b.m("GET").h(headers).b(body);
  return b.build();
}, "se_GetContinuousDeploymentPolicyCommand");
var se_GetContinuousDeploymentPolicyConfigCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = {};
  b.bp("/2020-05-31/continuous-deployment-policy/{Id}/config");
  b.p("Id", () => input.Id, "{Id}", false);
  let body;
  b.m("GET").h(headers).b(body);
  return b.build();
}, "se_GetContinuousDeploymentPolicyConfigCommand");
var se_GetDistributionCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = {};
  b.bp("/2020-05-31/distribution/{Id}");
  b.p("Id", () => input.Id, "{Id}", false);
  let body;
  b.m("GET").h(headers).b(body);
  return b.build();
}, "se_GetDistributionCommand");
var se_GetDistributionConfigCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = {};
  b.bp("/2020-05-31/distribution/{Id}/config");
  b.p("Id", () => input.Id, "{Id}", false);
  let body;
  b.m("GET").h(headers).b(body);
  return b.build();
}, "se_GetDistributionConfigCommand");
var se_GetDistributionTenantCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = {};
  b.bp("/2020-05-31/distribution-tenant/{Identifier}");
  b.p("Identifier", () => input.Identifier, "{Identifier}", false);
  let body;
  b.m("GET").h(headers).b(body);
  return b.build();
}, "se_GetDistributionTenantCommand");
var se_GetDistributionTenantByDomainCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = {};
  b.bp("/2020-05-31/distribution-tenant");
  const query = (0, import_smithy_client.map)({
    [_d]: [, (0, import_smithy_client.expectNonNull)(input[_Do], `Domain`)]
  });
  let body;
  b.m("GET").h(headers).q(query).b(body);
  return b.build();
}, "se_GetDistributionTenantByDomainCommand");
var se_GetFieldLevelEncryptionCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = {};
  b.bp("/2020-05-31/field-level-encryption/{Id}");
  b.p("Id", () => input.Id, "{Id}", false);
  let body;
  b.m("GET").h(headers).b(body);
  return b.build();
}, "se_GetFieldLevelEncryptionCommand");
var se_GetFieldLevelEncryptionConfigCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = {};
  b.bp("/2020-05-31/field-level-encryption/{Id}/config");
  b.p("Id", () => input.Id, "{Id}", false);
  let body;
  b.m("GET").h(headers).b(body);
  return b.build();
}, "se_GetFieldLevelEncryptionConfigCommand");
var se_GetFieldLevelEncryptionProfileCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = {};
  b.bp("/2020-05-31/field-level-encryption-profile/{Id}");
  b.p("Id", () => input.Id, "{Id}", false);
  let body;
  b.m("GET").h(headers).b(body);
  return b.build();
}, "se_GetFieldLevelEncryptionProfileCommand");
var se_GetFieldLevelEncryptionProfileConfigCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = {};
  b.bp("/2020-05-31/field-level-encryption-profile/{Id}/config");
  b.p("Id", () => input.Id, "{Id}", false);
  let body;
  b.m("GET").h(headers).b(body);
  return b.build();
}, "se_GetFieldLevelEncryptionProfileConfigCommand");
var se_GetFunctionCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = {};
  b.bp("/2020-05-31/function/{Name}");
  b.p("Name", () => input.Name, "{Name}", false);
  const query = (0, import_smithy_client.map)({
    [_St]: [, input[_St]]
  });
  let body;
  b.m("GET").h(headers).q(query).b(body);
  return b.build();
}, "se_GetFunctionCommand");
var se_GetInvalidationCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = {};
  b.bp("/2020-05-31/distribution/{DistributionId}/invalidation/{Id}");
  b.p("DistributionId", () => input.DistributionId, "{DistributionId}", false);
  b.p("Id", () => input.Id, "{Id}", false);
  let body;
  b.m("GET").h(headers).b(body);
  return b.build();
}, "se_GetInvalidationCommand");
var se_GetInvalidationForDistributionTenantCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = {};
  b.bp("/2020-05-31/distribution-tenant/{DistributionTenantId}/invalidation/{Id}");
  b.p("DistributionTenantId", () => input.DistributionTenantId, "{DistributionTenantId}", false);
  b.p("Id", () => input.Id, "{Id}", false);
  let body;
  b.m("GET").h(headers).b(body);
  return b.build();
}, "se_GetInvalidationForDistributionTenantCommand");
var se_GetKeyGroupCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = {};
  b.bp("/2020-05-31/key-group/{Id}");
  b.p("Id", () => input.Id, "{Id}", false);
  let body;
  b.m("GET").h(headers).b(body);
  return b.build();
}, "se_GetKeyGroupCommand");
var se_GetKeyGroupConfigCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = {};
  b.bp("/2020-05-31/key-group/{Id}/config");
  b.p("Id", () => input.Id, "{Id}", false);
  let body;
  b.m("GET").h(headers).b(body);
  return b.build();
}, "se_GetKeyGroupConfigCommand");
var se_GetManagedCertificateDetailsCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = {};
  b.bp("/2020-05-31/managed-certificate/{Identifier}");
  b.p("Identifier", () => input.Identifier, "{Identifier}", false);
  let body;
  b.m("GET").h(headers).b(body);
  return b.build();
}, "se_GetManagedCertificateDetailsCommand");
var se_GetMonitoringSubscriptionCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = {};
  b.bp("/2020-05-31/distributions/{DistributionId}/monitoring-subscription");
  b.p("DistributionId", () => input.DistributionId, "{DistributionId}", false);
  let body;
  b.m("GET").h(headers).b(body);
  return b.build();
}, "se_GetMonitoringSubscriptionCommand");
var se_GetOriginAccessControlCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = {};
  b.bp("/2020-05-31/origin-access-control/{Id}");
  b.p("Id", () => input.Id, "{Id}", false);
  let body;
  b.m("GET").h(headers).b(body);
  return b.build();
}, "se_GetOriginAccessControlCommand");
var se_GetOriginAccessControlConfigCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = {};
  b.bp("/2020-05-31/origin-access-control/{Id}/config");
  b.p("Id", () => input.Id, "{Id}", false);
  let body;
  b.m("GET").h(headers).b(body);
  return b.build();
}, "se_GetOriginAccessControlConfigCommand");
var se_GetOriginRequestPolicyCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = {};
  b.bp("/2020-05-31/origin-request-policy/{Id}");
  b.p("Id", () => input.Id, "{Id}", false);
  let body;
  b.m("GET").h(headers).b(body);
  return b.build();
}, "se_GetOriginRequestPolicyCommand");
var se_GetOriginRequestPolicyConfigCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = {};
  b.bp("/2020-05-31/origin-request-policy/{Id}/config");
  b.p("Id", () => input.Id, "{Id}", false);
  let body;
  b.m("GET").h(headers).b(body);
  return b.build();
}, "se_GetOriginRequestPolicyConfigCommand");
var se_GetPublicKeyCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = {};
  b.bp("/2020-05-31/public-key/{Id}");
  b.p("Id", () => input.Id, "{Id}", false);
  let body;
  b.m("GET").h(headers).b(body);
  return b.build();
}, "se_GetPublicKeyCommand");
var se_GetPublicKeyConfigCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = {};
  b.bp("/2020-05-31/public-key/{Id}/config");
  b.p("Id", () => input.Id, "{Id}", false);
  let body;
  b.m("GET").h(headers).b(body);
  return b.build();
}, "se_GetPublicKeyConfigCommand");
var se_GetRealtimeLogConfigCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = {
    "content-type": "application/xml"
  };
  b.bp("/2020-05-31/get-realtime-log-config");
  let body;
  body = _ve;
  const bn = new import_xml_builder.XmlNode(_GRLCR);
  bn.a("xmlns", "http://cloudfront.amazonaws.com/doc/2020-05-31/");
  if (input[_ARN] != null) {
    bn.c(import_xml_builder.XmlNode.of(_s, input[_ARN]).n(_ARN));
  }
  if (input[_N] != null) {
    bn.c(import_xml_builder.XmlNode.of(_s, input[_N]).n(_N));
  }
  body += bn.toString();
  b.m("POST").h(headers).b(body);
  return b.build();
}, "se_GetRealtimeLogConfigCommand");
var se_GetResponseHeadersPolicyCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = {};
  b.bp("/2020-05-31/response-headers-policy/{Id}");
  b.p("Id", () => input.Id, "{Id}", false);
  let body;
  b.m("GET").h(headers).b(body);
  return b.build();
}, "se_GetResponseHeadersPolicyCommand");
var se_GetResponseHeadersPolicyConfigCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = {};
  b.bp("/2020-05-31/response-headers-policy/{Id}/config");
  b.p("Id", () => input.Id, "{Id}", false);
  let body;
  b.m("GET").h(headers).b(body);
  return b.build();
}, "se_GetResponseHeadersPolicyConfigCommand");
var se_GetStreamingDistributionCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = {};
  b.bp("/2020-05-31/streaming-distribution/{Id}");
  b.p("Id", () => input.Id, "{Id}", false);
  let body;
  b.m("GET").h(headers).b(body);
  return b.build();
}, "se_GetStreamingDistributionCommand");
var se_GetStreamingDistributionConfigCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = {};
  b.bp("/2020-05-31/streaming-distribution/{Id}/config");
  b.p("Id", () => input.Id, "{Id}", false);
  let body;
  b.m("GET").h(headers).b(body);
  return b.build();
}, "se_GetStreamingDistributionConfigCommand");
var se_GetVpcOriginCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = {};
  b.bp("/2020-05-31/vpc-origin/{Id}");
  b.p("Id", () => input.Id, "{Id}", false);
  let body;
  b.m("GET").h(headers).b(body);
  return b.build();
}, "se_GetVpcOriginCommand");
var se_ListAnycastIpListsCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = {};
  b.bp("/2020-05-31/anycast-ip-list");
  const query = (0, import_smithy_client.map)({
    [_M]: [, input[_M]],
    [_MI]: [() => input.MaxItems !== void 0, () => input[_MI].toString()]
  });
  let body;
  b.m("GET").h(headers).q(query).b(body);
  return b.build();
}, "se_ListAnycastIpListsCommand");
var se_ListCachePoliciesCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = {};
  b.bp("/2020-05-31/cache-policy");
  const query = (0, import_smithy_client.map)({
    [_Ty]: [, input[_Ty]],
    [_M]: [, input[_M]],
    [_MI]: [() => input.MaxItems !== void 0, () => input[_MI].toString()]
  });
  let body;
  b.m("GET").h(headers).q(query).b(body);
  return b.build();
}, "se_ListCachePoliciesCommand");
var se_ListCloudFrontOriginAccessIdentitiesCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = {};
  b.bp("/2020-05-31/origin-access-identity/cloudfront");
  const query = (0, import_smithy_client.map)({
    [_M]: [, input[_M]],
    [_MI]: [() => input.MaxItems !== void 0, () => input[_MI].toString()]
  });
  let body;
  b.m("GET").h(headers).q(query).b(body);
  return b.build();
}, "se_ListCloudFrontOriginAccessIdentitiesCommand");
var se_ListConflictingAliasesCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = {};
  b.bp("/2020-05-31/conflicting-alias");
  const query = (0, import_smithy_client.map)({
    [_DI]: [, (0, import_smithy_client.expectNonNull)(input[_DI], `DistributionId`)],
    [_A]: [, (0, import_smithy_client.expectNonNull)(input[_A], `Alias`)],
    [_M]: [, input[_M]],
    [_MI]: [() => input.MaxItems !== void 0, () => input[_MI].toString()]
  });
  let body;
  b.m("GET").h(headers).q(query).b(body);
  return b.build();
}, "se_ListConflictingAliasesCommand");
var se_ListConnectionGroupsCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = {
    "content-type": "application/xml"
  };
  b.bp("/2020-05-31/connection-groups");
  let body;
  body = _ve;
  const bn = new import_xml_builder.XmlNode(_LCGR);
  bn.a("xmlns", "http://cloudfront.amazonaws.com/doc/2020-05-31/");
  if (input[_AF] != null) {
    bn.c(se_ConnectionGroupAssociationFilter(input[_AF], context).n(_AF));
  }
  if (input[_M] != null) {
    bn.c(import_xml_builder.XmlNode.of(_s, input[_M]).n(_M));
  }
  if (input[_MI] != null) {
    bn.c(import_xml_builder.XmlNode.of(_i, String(input[_MI])).n(_MI));
  }
  body += bn.toString();
  b.m("POST").h(headers).b(body);
  return b.build();
}, "se_ListConnectionGroupsCommand");
var se_ListContinuousDeploymentPoliciesCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = {};
  b.bp("/2020-05-31/continuous-deployment-policy");
  const query = (0, import_smithy_client.map)({
    [_M]: [, input[_M]],
    [_MI]: [() => input.MaxItems !== void 0, () => input[_MI].toString()]
  });
  let body;
  b.m("GET").h(headers).q(query).b(body);
  return b.build();
}, "se_ListContinuousDeploymentPoliciesCommand");
var se_ListDistributionsCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = {};
  b.bp("/2020-05-31/distribution");
  const query = (0, import_smithy_client.map)({
    [_M]: [, input[_M]],
    [_MI]: [() => input.MaxItems !== void 0, () => input[_MI].toString()]
  });
  let body;
  b.m("GET").h(headers).q(query).b(body);
  return b.build();
}, "se_ListDistributionsCommand");
var se_ListDistributionsByAnycastIpListIdCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = {};
  b.bp("/2020-05-31/distributionsByAnycastIpListId/{AnycastIpListId}");
  b.p("AnycastIpListId", () => input.AnycastIpListId, "{AnycastIpListId}", false);
  const query = (0, import_smithy_client.map)({
    [_M]: [, input[_M]],
    [_MI]: [() => input.MaxItems !== void 0, () => input[_MI].toString()]
  });
  let body;
  b.m("GET").h(headers).q(query).b(body);
  return b.build();
}, "se_ListDistributionsByAnycastIpListIdCommand");
var se_ListDistributionsByCachePolicyIdCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = {};
  b.bp("/2020-05-31/distributionsByCachePolicyId/{CachePolicyId}");
  b.p("CachePolicyId", () => input.CachePolicyId, "{CachePolicyId}", false);
  const query = (0, import_smithy_client.map)({
    [_M]: [, input[_M]],
    [_MI]: [() => input.MaxItems !== void 0, () => input[_MI].toString()]
  });
  let body;
  b.m("GET").h(headers).q(query).b(body);
  return b.build();
}, "se_ListDistributionsByCachePolicyIdCommand");
var se_ListDistributionsByConnectionModeCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = {};
  b.bp("/2020-05-31/distributionsByConnectionMode/{ConnectionMode}");
  b.p("ConnectionMode", () => input.ConnectionMode, "{ConnectionMode}", false);
  const query = (0, import_smithy_client.map)({
    [_M]: [, input[_M]],
    [_MI]: [() => input.MaxItems !== void 0, () => input[_MI].toString()]
  });
  let body;
  b.m("GET").h(headers).q(query).b(body);
  return b.build();
}, "se_ListDistributionsByConnectionModeCommand");
var se_ListDistributionsByKeyGroupCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = {};
  b.bp("/2020-05-31/distributionsByKeyGroupId/{KeyGroupId}");
  b.p("KeyGroupId", () => input.KeyGroupId, "{KeyGroupId}", false);
  const query = (0, import_smithy_client.map)({
    [_M]: [, input[_M]],
    [_MI]: [() => input.MaxItems !== void 0, () => input[_MI].toString()]
  });
  let body;
  b.m("GET").h(headers).q(query).b(body);
  return b.build();
}, "se_ListDistributionsByKeyGroupCommand");
var se_ListDistributionsByOriginRequestPolicyIdCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = {};
  b.bp("/2020-05-31/distributionsByOriginRequestPolicyId/{OriginRequestPolicyId}");
  b.p("OriginRequestPolicyId", () => input.OriginRequestPolicyId, "{OriginRequestPolicyId}", false);
  const query = (0, import_smithy_client.map)({
    [_M]: [, input[_M]],
    [_MI]: [() => input.MaxItems !== void 0, () => input[_MI].toString()]
  });
  let body;
  b.m("GET").h(headers).q(query).b(body);
  return b.build();
}, "se_ListDistributionsByOriginRequestPolicyIdCommand");
var se_ListDistributionsByRealtimeLogConfigCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = {
    "content-type": "application/xml"
  };
  b.bp("/2020-05-31/distributionsByRealtimeLogConfig");
  let body;
  body = _ve;
  const bn = new import_xml_builder.XmlNode(_LDBRLCR);
  bn.a("xmlns", "http://cloudfront.amazonaws.com/doc/2020-05-31/");
  if (input[_M] != null) {
    bn.c(import_xml_builder.XmlNode.of(_s, input[_M]).n(_M));
  }
  if (input[_MI] != null) {
    bn.c(import_xml_builder.XmlNode.of(_i, String(input[_MI])).n(_MI));
  }
  if (input[_RLCA] != null) {
    bn.c(import_xml_builder.XmlNode.of(_s, input[_RLCA]).n(_RLCA));
  }
  if (input[_RLCN] != null) {
    bn.c(import_xml_builder.XmlNode.of(_s, input[_RLCN]).n(_RLCN));
  }
  body += bn.toString();
  b.m("POST").h(headers).b(body);
  return b.build();
}, "se_ListDistributionsByRealtimeLogConfigCommand");
var se_ListDistributionsByResponseHeadersPolicyIdCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = {};
  b.bp("/2020-05-31/distributionsByResponseHeadersPolicyId/{ResponseHeadersPolicyId}");
  b.p("ResponseHeadersPolicyId", () => input.ResponseHeadersPolicyId, "{ResponseHeadersPolicyId}", false);
  const query = (0, import_smithy_client.map)({
    [_M]: [, input[_M]],
    [_MI]: [() => input.MaxItems !== void 0, () => input[_MI].toString()]
  });
  let body;
  b.m("GET").h(headers).q(query).b(body);
  return b.build();
}, "se_ListDistributionsByResponseHeadersPolicyIdCommand");
var se_ListDistributionsByVpcOriginIdCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = {};
  b.bp("/2020-05-31/distributionsByVpcOriginId/{VpcOriginId}");
  b.p("VpcOriginId", () => input.VpcOriginId, "{VpcOriginId}", false);
  const query = (0, import_smithy_client.map)({
    [_M]: [, input[_M]],
    [_MI]: [() => input.MaxItems !== void 0, () => input[_MI].toString()]
  });
  let body;
  b.m("GET").h(headers).q(query).b(body);
  return b.build();
}, "se_ListDistributionsByVpcOriginIdCommand");
var se_ListDistributionsByWebACLIdCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = {};
  b.bp("/2020-05-31/distributionsByWebACLId/{WebACLId}");
  b.p("WebACLId", () => input.WebACLId, "{WebACLId}", false);
  const query = (0, import_smithy_client.map)({
    [_M]: [, input[_M]],
    [_MI]: [() => input.MaxItems !== void 0, () => input[_MI].toString()]
  });
  let body;
  b.m("GET").h(headers).q(query).b(body);
  return b.build();
}, "se_ListDistributionsByWebACLIdCommand");
var se_ListDistributionTenantsCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = {
    "content-type": "application/xml"
  };
  b.bp("/2020-05-31/distribution-tenants");
  let body;
  body = _ve;
  const bn = new import_xml_builder.XmlNode(_LDTR);
  bn.a("xmlns", "http://cloudfront.amazonaws.com/doc/2020-05-31/");
  if (input[_AF] != null) {
    bn.c(se_DistributionTenantAssociationFilter(input[_AF], context).n(_AF));
  }
  if (input[_M] != null) {
    bn.c(import_xml_builder.XmlNode.of(_s, input[_M]).n(_M));
  }
  if (input[_MI] != null) {
    bn.c(import_xml_builder.XmlNode.of(_i, String(input[_MI])).n(_MI));
  }
  body += bn.toString();
  b.m("POST").h(headers).b(body);
  return b.build();
}, "se_ListDistributionTenantsCommand");
var se_ListDistributionTenantsByCustomizationCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = {
    "content-type": "application/xml"
  };
  b.bp("/2020-05-31/distribution-tenants-by-customization");
  let body;
  body = _ve;
  const bn = new import_xml_builder.XmlNode(_LDTBCR);
  bn.a("xmlns", "http://cloudfront.amazonaws.com/doc/2020-05-31/");
  if (input[_CA] != null) {
    bn.c(import_xml_builder.XmlNode.of(_s, input[_CA]).n(_CA));
  }
  if (input[_M] != null) {
    bn.c(import_xml_builder.XmlNode.of(_s, input[_M]).n(_M));
  }
  if (input[_MI] != null) {
    bn.c(import_xml_builder.XmlNode.of(_i, String(input[_MI])).n(_MI));
  }
  if (input[_WACLA] != null) {
    bn.c(import_xml_builder.XmlNode.of(_s, input[_WACLA]).n(_WACLA));
  }
  body += bn.toString();
  b.m("POST").h(headers).b(body);
  return b.build();
}, "se_ListDistributionTenantsByCustomizationCommand");
var se_ListDomainConflictsCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = {
    "content-type": "application/xml"
  };
  b.bp("/2020-05-31/domain-conflicts");
  let body;
  body = _ve;
  const bn = new import_xml_builder.XmlNode(_LDCR);
  bn.a("xmlns", "http://cloudfront.amazonaws.com/doc/2020-05-31/");
  if (input[_Do] != null) {
    bn.c(import_xml_builder.XmlNode.of(_s, input[_Do]).n(_Do));
  }
  if (input[_DCVR] != null) {
    bn.c(se_DistributionResourceId(input[_DCVR], context).n(_DCVR));
  }
  if (input[_M] != null) {
    bn.c(import_xml_builder.XmlNode.of(_s, input[_M]).n(_M));
  }
  if (input[_MI] != null) {
    bn.c(import_xml_builder.XmlNode.of(_i, String(input[_MI])).n(_MI));
  }
  body += bn.toString();
  b.m("POST").h(headers).b(body);
  return b.build();
}, "se_ListDomainConflictsCommand");
var se_ListFieldLevelEncryptionConfigsCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = {};
  b.bp("/2020-05-31/field-level-encryption");
  const query = (0, import_smithy_client.map)({
    [_M]: [, input[_M]],
    [_MI]: [() => input.MaxItems !== void 0, () => input[_MI].toString()]
  });
  let body;
  b.m("GET").h(headers).q(query).b(body);
  return b.build();
}, "se_ListFieldLevelEncryptionConfigsCommand");
var se_ListFieldLevelEncryptionProfilesCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = {};
  b.bp("/2020-05-31/field-level-encryption-profile");
  const query = (0, import_smithy_client.map)({
    [_M]: [, input[_M]],
    [_MI]: [() => input.MaxItems !== void 0, () => input[_MI].toString()]
  });
  let body;
  b.m("GET").h(headers).q(query).b(body);
  return b.build();
}, "se_ListFieldLevelEncryptionProfilesCommand");
var se_ListFunctionsCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = {};
  b.bp("/2020-05-31/function");
  const query = (0, import_smithy_client.map)({
    [_M]: [, input[_M]],
    [_MI]: [() => input.MaxItems !== void 0, () => input[_MI].toString()],
    [_St]: [, input[_St]]
  });
  let body;
  b.m("GET").h(headers).q(query).b(body);
  return b.build();
}, "se_ListFunctionsCommand");
var se_ListInvalidationsCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = {};
  b.bp("/2020-05-31/distribution/{DistributionId}/invalidation");
  b.p("DistributionId", () => input.DistributionId, "{DistributionId}", false);
  const query = (0, import_smithy_client.map)({
    [_M]: [, input[_M]],
    [_MI]: [() => input.MaxItems !== void 0, () => input[_MI].toString()]
  });
  let body;
  b.m("GET").h(headers).q(query).b(body);
  return b.build();
}, "se_ListInvalidationsCommand");
var se_ListInvalidationsForDistributionTenantCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = {};
  b.bp("/2020-05-31/distribution-tenant/{Id}/invalidation");
  b.p("Id", () => input.Id, "{Id}", false);
  const query = (0, import_smithy_client.map)({
    [_M]: [, input[_M]],
    [_MI]: [() => input.MaxItems !== void 0, () => input[_MI].toString()]
  });
  let body;
  b.m("GET").h(headers).q(query).b(body);
  return b.build();
}, "se_ListInvalidationsForDistributionTenantCommand");
var se_ListKeyGroupsCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = {};
  b.bp("/2020-05-31/key-group");
  const query = (0, import_smithy_client.map)({
    [_M]: [, input[_M]],
    [_MI]: [() => input.MaxItems !== void 0, () => input[_MI].toString()]
  });
  let body;
  b.m("GET").h(headers).q(query).b(body);
  return b.build();
}, "se_ListKeyGroupsCommand");
var se_ListKeyValueStoresCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = {};
  b.bp("/2020-05-31/key-value-store");
  const query = (0, import_smithy_client.map)({
    [_M]: [, input[_M]],
    [_MI]: [() => input.MaxItems !== void 0, () => input[_MI].toString()],
    [_Sta]: [, input[_Sta]]
  });
  let body;
  b.m("GET").h(headers).q(query).b(body);
  return b.build();
}, "se_ListKeyValueStoresCommand");
var se_ListOriginAccessControlsCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = {};
  b.bp("/2020-05-31/origin-access-control");
  const query = (0, import_smithy_client.map)({
    [_M]: [, input[_M]],
    [_MI]: [() => input.MaxItems !== void 0, () => input[_MI].toString()]
  });
  let body;
  b.m("GET").h(headers).q(query).b(body);
  return b.build();
}, "se_ListOriginAccessControlsCommand");
var se_ListOriginRequestPoliciesCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = {};
  b.bp("/2020-05-31/origin-request-policy");
  const query = (0, import_smithy_client.map)({
    [_Ty]: [, input[_Ty]],
    [_M]: [, input[_M]],
    [_MI]: [() => input.MaxItems !== void 0, () => input[_MI].toString()]
  });
  let body;
  b.m("GET").h(headers).q(query).b(body);
  return b.build();
}, "se_ListOriginRequestPoliciesCommand");
var se_ListPublicKeysCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = {};
  b.bp("/2020-05-31/public-key");
  const query = (0, import_smithy_client.map)({
    [_M]: [, input[_M]],
    [_MI]: [() => input.MaxItems !== void 0, () => input[_MI].toString()]
  });
  let body;
  b.m("GET").h(headers).q(query).b(body);
  return b.build();
}, "se_ListPublicKeysCommand");
var se_ListRealtimeLogConfigsCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = {};
  b.bp("/2020-05-31/realtime-log-config");
  const query = (0, import_smithy_client.map)({
    [_MI]: [() => input.MaxItems !== void 0, () => input[_MI].toString()],
    [_M]: [, input[_M]]
  });
  let body;
  b.m("GET").h(headers).q(query).b(body);
  return b.build();
}, "se_ListRealtimeLogConfigsCommand");
var se_ListResponseHeadersPoliciesCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = {};
  b.bp("/2020-05-31/response-headers-policy");
  const query = (0, import_smithy_client.map)({
    [_Ty]: [, input[_Ty]],
    [_M]: [, input[_M]],
    [_MI]: [() => input.MaxItems !== void 0, () => input[_MI].toString()]
  });
  let body;
  b.m("GET").h(headers).q(query).b(body);
  return b.build();
}, "se_ListResponseHeadersPoliciesCommand");
var se_ListStreamingDistributionsCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = {};
  b.bp("/2020-05-31/streaming-distribution");
  const query = (0, import_smithy_client.map)({
    [_M]: [, input[_M]],
    [_MI]: [() => input.MaxItems !== void 0, () => input[_MI].toString()]
  });
  let body;
  b.m("GET").h(headers).q(query).b(body);
  return b.build();
}, "se_ListStreamingDistributionsCommand");
var se_ListTagsForResourceCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = {};
  b.bp("/2020-05-31/tagging");
  const query = (0, import_smithy_client.map)({
    [_R]: [, (0, import_smithy_client.expectNonNull)(input[_R], `Resource`)]
  });
  let body;
  b.m("GET").h(headers).q(query).b(body);
  return b.build();
}, "se_ListTagsForResourceCommand");
var se_ListVpcOriginsCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = {};
  b.bp("/2020-05-31/vpc-origin");
  const query = (0, import_smithy_client.map)({
    [_M]: [, input[_M]],
    [_MI]: [() => input.MaxItems !== void 0, () => input[_MI].toString()]
  });
  let body;
  b.m("GET").h(headers).q(query).b(body);
  return b.build();
}, "se_ListVpcOriginsCommand");
var se_PublishFunctionCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = (0, import_smithy_client.map)({}, import_smithy_client.isSerializableHeaderValue, {
    [_im]: input[_IM]
  });
  b.bp("/2020-05-31/function/{Name}/publish");
  b.p("Name", () => input.Name, "{Name}", false);
  let body;
  b.m("POST").h(headers).b(body);
  return b.build();
}, "se_PublishFunctionCommand");
var se_TagResourceCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = {
    "content-type": "application/xml"
  };
  b.bp("/2020-05-31/tagging");
  const query = (0, import_smithy_client.map)({
    [_O]: [, "Tag"],
    [_R]: [, (0, import_smithy_client.expectNonNull)(input[_R], `Resource`)]
  });
  let body;
  let contents;
  if (input.Tags !== void 0) {
    contents = se_Tags(input.Tags, context);
    body = _ve;
    contents.a("xmlns", "http://cloudfront.amazonaws.com/doc/2020-05-31/");
    body += contents.toString();
  }
  b.m("POST").h(headers).q(query).b(body);
  return b.build();
}, "se_TagResourceCommand");
var se_TestFunctionCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = (0, import_smithy_client.map)({}, import_smithy_client.isSerializableHeaderValue, {
    "content-type": "application/xml",
    [_im]: input[_IM]
  });
  b.bp("/2020-05-31/function/{Name}/test");
  b.p("Name", () => input.Name, "{Name}", false);
  let body;
  body = _ve;
  const bn = new import_xml_builder.XmlNode(_TFR);
  bn.a("xmlns", "http://cloudfront.amazonaws.com/doc/2020-05-31/");
  if (input[_EO] != null) {
    bn.c(import_xml_builder.XmlNode.of(_FEO, context.base64Encoder(input[_EO])).n(_EO));
  }
  if (input[_St] != null) {
    bn.c(import_xml_builder.XmlNode.of(_FS, input[_St]).n(_St));
  }
  body += bn.toString();
  b.m("POST").h(headers).b(body);
  return b.build();
}, "se_TestFunctionCommand");
var se_UntagResourceCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = {
    "content-type": "application/xml"
  };
  b.bp("/2020-05-31/tagging");
  const query = (0, import_smithy_client.map)({
    [_O]: [, "Untag"],
    [_R]: [, (0, import_smithy_client.expectNonNull)(input[_R], `Resource`)]
  });
  let body;
  let contents;
  if (input.TagKeys !== void 0) {
    contents = se_TagKeys(input.TagKeys, context);
    body = _ve;
    contents.a("xmlns", "http://cloudfront.amazonaws.com/doc/2020-05-31/");
    body += contents.toString();
  }
  b.m("POST").h(headers).q(query).b(body);
  return b.build();
}, "se_UntagResourceCommand");
var se_UpdateCachePolicyCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = (0, import_smithy_client.map)({}, import_smithy_client.isSerializableHeaderValue, {
    "content-type": "application/xml",
    [_im]: input[_IM]
  });
  b.bp("/2020-05-31/cache-policy/{Id}");
  b.p("Id", () => input.Id, "{Id}", false);
  let body;
  let contents;
  if (input.CachePolicyConfig !== void 0) {
    contents = se_CachePolicyConfig(input.CachePolicyConfig, context);
    body = _ve;
    contents.a("xmlns", "http://cloudfront.amazonaws.com/doc/2020-05-31/");
    body += contents.toString();
  }
  b.m("PUT").h(headers).b(body);
  return b.build();
}, "se_UpdateCachePolicyCommand");
var se_UpdateCloudFrontOriginAccessIdentityCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = (0, import_smithy_client.map)({}, import_smithy_client.isSerializableHeaderValue, {
    "content-type": "application/xml",
    [_im]: input[_IM]
  });
  b.bp("/2020-05-31/origin-access-identity/cloudfront/{Id}/config");
  b.p("Id", () => input.Id, "{Id}", false);
  let body;
  let contents;
  if (input.CloudFrontOriginAccessIdentityConfig !== void 0) {
    contents = se_CloudFrontOriginAccessIdentityConfig(input.CloudFrontOriginAccessIdentityConfig, context);
    body = _ve;
    contents.a("xmlns", "http://cloudfront.amazonaws.com/doc/2020-05-31/");
    body += contents.toString();
  }
  b.m("PUT").h(headers).b(body);
  return b.build();
}, "se_UpdateCloudFrontOriginAccessIdentityCommand");
var se_UpdateConnectionGroupCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = (0, import_smithy_client.map)({}, import_smithy_client.isSerializableHeaderValue, {
    "content-type": "application/xml",
    [_im]: input[_IM]
  });
  b.bp("/2020-05-31/connection-group/{Id}");
  b.p("Id", () => input.Id, "{Id}", false);
  let body;
  body = _ve;
  const bn = new import_xml_builder.XmlNode(_UCGR);
  bn.a("xmlns", "http://cloudfront.amazonaws.com/doc/2020-05-31/");
  if (input[_AILI] != null) {
    bn.c(import_xml_builder.XmlNode.of(_s, input[_AILI]).n(_AILI));
  }
  if (input[_E] != null) {
    bn.c(import_xml_builder.XmlNode.of(_b, String(input[_E])).n(_E));
  }
  if (input[_IE] != null) {
    bn.c(import_xml_builder.XmlNode.of(_b, String(input[_IE])).n(_IE));
  }
  body += bn.toString();
  b.m("PUT").h(headers).b(body);
  return b.build();
}, "se_UpdateConnectionGroupCommand");
var se_UpdateContinuousDeploymentPolicyCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = (0, import_smithy_client.map)({}, import_smithy_client.isSerializableHeaderValue, {
    "content-type": "application/xml",
    [_im]: input[_IM]
  });
  b.bp("/2020-05-31/continuous-deployment-policy/{Id}");
  b.p("Id", () => input.Id, "{Id}", false);
  let body;
  let contents;
  if (input.ContinuousDeploymentPolicyConfig !== void 0) {
    contents = se_ContinuousDeploymentPolicyConfig(input.ContinuousDeploymentPolicyConfig, context);
    body = _ve;
    contents.a("xmlns", "http://cloudfront.amazonaws.com/doc/2020-05-31/");
    body += contents.toString();
  }
  b.m("PUT").h(headers).b(body);
  return b.build();
}, "se_UpdateContinuousDeploymentPolicyCommand");
var se_UpdateDistributionCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = (0, import_smithy_client.map)({}, import_smithy_client.isSerializableHeaderValue, {
    "content-type": "application/xml",
    [_im]: input[_IM]
  });
  b.bp("/2020-05-31/distribution/{Id}/config");
  b.p("Id", () => input.Id, "{Id}", false);
  let body;
  let contents;
  if (input.DistributionConfig !== void 0) {
    contents = se_DistributionConfig(input.DistributionConfig, context);
    body = _ve;
    contents.a("xmlns", "http://cloudfront.amazonaws.com/doc/2020-05-31/");
    body += contents.toString();
  }
  b.m("PUT").h(headers).b(body);
  return b.build();
}, "se_UpdateDistributionCommand");
var se_UpdateDistributionTenantCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = (0, import_smithy_client.map)({}, import_smithy_client.isSerializableHeaderValue, {
    "content-type": "application/xml",
    [_im]: input[_IM]
  });
  b.bp("/2020-05-31/distribution-tenant/{Id}");
  b.p("Id", () => input.Id, "{Id}", false);
  let body;
  body = _ve;
  const bn = new import_xml_builder.XmlNode(_UDTR);
  bn.a("xmlns", "http://cloudfront.amazonaws.com/doc/2020-05-31/");
  if (input[_CGI] != null) {
    bn.c(import_xml_builder.XmlNode.of(_s, input[_CGI]).n(_CGI));
  }
  if (input[_C] != null) {
    bn.c(se_Customizations(input[_C], context).n(_C));
  }
  if (input[_DI] != null) {
    bn.c(import_xml_builder.XmlNode.of(_s, input[_DI]).n(_DI));
  }
  bn.lc(input, "Domains", "Domains", () => se_DomainList(input[_D], context));
  if (input[_E] != null) {
    bn.c(import_xml_builder.XmlNode.of(_b, String(input[_E])).n(_E));
  }
  if (input[_MCR] != null) {
    bn.c(se_ManagedCertificateRequest(input[_MCR], context).n(_MCR));
  }
  bn.lc(input, "Parameters", "Parameters", () => se_Parameters(input[_P], context));
  body += bn.toString();
  b.m("PUT").h(headers).b(body);
  return b.build();
}, "se_UpdateDistributionTenantCommand");
var se_UpdateDistributionWithStagingConfigCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = (0, import_smithy_client.map)({}, import_smithy_client.isSerializableHeaderValue, {
    [_im]: input[_IM]
  });
  b.bp("/2020-05-31/distribution/{Id}/promote-staging-config");
  b.p("Id", () => input.Id, "{Id}", false);
  const query = (0, import_smithy_client.map)({
    [_SDI]: [, input[_SDI]]
  });
  let body;
  b.m("PUT").h(headers).q(query).b(body);
  return b.build();
}, "se_UpdateDistributionWithStagingConfigCommand");
var se_UpdateDomainAssociationCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = (0, import_smithy_client.map)({}, import_smithy_client.isSerializableHeaderValue, {
    "content-type": "application/xml",
    [_im]: input[_IM]
  });
  b.bp("/2020-05-31/domain-association");
  let body;
  body = _ve;
  const bn = new import_xml_builder.XmlNode(_UDAR);
  bn.a("xmlns", "http://cloudfront.amazonaws.com/doc/2020-05-31/");
  if (input[_Do] != null) {
    bn.c(import_xml_builder.XmlNode.of(_s, input[_Do]).n(_Do));
  }
  if (input[_TR] != null) {
    bn.c(se_DistributionResourceId(input[_TR], context).n(_TR));
  }
  body += bn.toString();
  b.m("POST").h(headers).b(body);
  return b.build();
}, "se_UpdateDomainAssociationCommand");
var se_UpdateFieldLevelEncryptionConfigCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = (0, import_smithy_client.map)({}, import_smithy_client.isSerializableHeaderValue, {
    "content-type": "application/xml",
    [_im]: input[_IM]
  });
  b.bp("/2020-05-31/field-level-encryption/{Id}/config");
  b.p("Id", () => input.Id, "{Id}", false);
  let body;
  let contents;
  if (input.FieldLevelEncryptionConfig !== void 0) {
    contents = se_FieldLevelEncryptionConfig(input.FieldLevelEncryptionConfig, context);
    body = _ve;
    contents.a("xmlns", "http://cloudfront.amazonaws.com/doc/2020-05-31/");
    body += contents.toString();
  }
  b.m("PUT").h(headers).b(body);
  return b.build();
}, "se_UpdateFieldLevelEncryptionConfigCommand");
var se_UpdateFieldLevelEncryptionProfileCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = (0, import_smithy_client.map)({}, import_smithy_client.isSerializableHeaderValue, {
    "content-type": "application/xml",
    [_im]: input[_IM]
  });
  b.bp("/2020-05-31/field-level-encryption-profile/{Id}/config");
  b.p("Id", () => input.Id, "{Id}", false);
  let body;
  let contents;
  if (input.FieldLevelEncryptionProfileConfig !== void 0) {
    contents = se_FieldLevelEncryptionProfileConfig(input.FieldLevelEncryptionProfileConfig, context);
    body = _ve;
    contents.a("xmlns", "http://cloudfront.amazonaws.com/doc/2020-05-31/");
    body += contents.toString();
  }
  b.m("PUT").h(headers).b(body);
  return b.build();
}, "se_UpdateFieldLevelEncryptionProfileCommand");
var se_UpdateFunctionCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = (0, import_smithy_client.map)({}, import_smithy_client.isSerializableHeaderValue, {
    "content-type": "application/xml",
    [_im]: input[_IM]
  });
  b.bp("/2020-05-31/function/{Name}");
  b.p("Name", () => input.Name, "{Name}", false);
  let body;
  body = _ve;
  const bn = new import_xml_builder.XmlNode(_UFR);
  bn.a("xmlns", "http://cloudfront.amazonaws.com/doc/2020-05-31/");
  if (input[_FC] != null) {
    bn.c(import_xml_builder.XmlNode.of(_FB, context.base64Encoder(input[_FC])).n(_FC));
  }
  if (input[_FCu] != null) {
    bn.c(se_FunctionConfig(input[_FCu], context).n(_FCu));
  }
  body += bn.toString();
  b.m("PUT").h(headers).b(body);
  return b.build();
}, "se_UpdateFunctionCommand");
var se_UpdateKeyGroupCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = (0, import_smithy_client.map)({}, import_smithy_client.isSerializableHeaderValue, {
    "content-type": "application/xml",
    [_im]: input[_IM]
  });
  b.bp("/2020-05-31/key-group/{Id}");
  b.p("Id", () => input.Id, "{Id}", false);
  let body;
  let contents;
  if (input.KeyGroupConfig !== void 0) {
    contents = se_KeyGroupConfig(input.KeyGroupConfig, context);
    body = _ve;
    contents.a("xmlns", "http://cloudfront.amazonaws.com/doc/2020-05-31/");
    body += contents.toString();
  }
  b.m("PUT").h(headers).b(body);
  return b.build();
}, "se_UpdateKeyGroupCommand");
var se_UpdateKeyValueStoreCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = (0, import_smithy_client.map)({}, import_smithy_client.isSerializableHeaderValue, {
    "content-type": "application/xml",
    [_im]: input[_IM]
  });
  b.bp("/2020-05-31/key-value-store/{Name}");
  b.p("Name", () => input.Name, "{Name}", false);
  let body;
  body = _ve;
  const bn = new import_xml_builder.XmlNode(_UKVSR);
  bn.a("xmlns", "http://cloudfront.amazonaws.com/doc/2020-05-31/");
  if (input[_Co] != null) {
    bn.c(import_xml_builder.XmlNode.of(_KVSC, input[_Co]).n(_Co));
  }
  body += bn.toString();
  b.m("PUT").h(headers).b(body);
  return b.build();
}, "se_UpdateKeyValueStoreCommand");
var se_UpdateOriginAccessControlCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = (0, import_smithy_client.map)({}, import_smithy_client.isSerializableHeaderValue, {
    "content-type": "application/xml",
    [_im]: input[_IM]
  });
  b.bp("/2020-05-31/origin-access-control/{Id}/config");
  b.p("Id", () => input.Id, "{Id}", false);
  let body;
  let contents;
  if (input.OriginAccessControlConfig !== void 0) {
    contents = se_OriginAccessControlConfig(input.OriginAccessControlConfig, context);
    body = _ve;
    contents.a("xmlns", "http://cloudfront.amazonaws.com/doc/2020-05-31/");
    body += contents.toString();
  }
  b.m("PUT").h(headers).b(body);
  return b.build();
}, "se_UpdateOriginAccessControlCommand");
var se_UpdateOriginRequestPolicyCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = (0, import_smithy_client.map)({}, import_smithy_client.isSerializableHeaderValue, {
    "content-type": "application/xml",
    [_im]: input[_IM]
  });
  b.bp("/2020-05-31/origin-request-policy/{Id}");
  b.p("Id", () => input.Id, "{Id}", false);
  let body;
  let contents;
  if (input.OriginRequestPolicyConfig !== void 0) {
    contents = se_OriginRequestPolicyConfig(input.OriginRequestPolicyConfig, context);
    body = _ve;
    contents.a("xmlns", "http://cloudfront.amazonaws.com/doc/2020-05-31/");
    body += contents.toString();
  }
  b.m("PUT").h(headers).b(body);
  return b.build();
}, "se_UpdateOriginRequestPolicyCommand");
var se_UpdatePublicKeyCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = (0, import_smithy_client.map)({}, import_smithy_client.isSerializableHeaderValue, {
    "content-type": "application/xml",
    [_im]: input[_IM]
  });
  b.bp("/2020-05-31/public-key/{Id}/config");
  b.p("Id", () => input.Id, "{Id}", false);
  let body;
  let contents;
  if (input.PublicKeyConfig !== void 0) {
    contents = se_PublicKeyConfig(input.PublicKeyConfig, context);
    body = _ve;
    contents.a("xmlns", "http://cloudfront.amazonaws.com/doc/2020-05-31/");
    body += contents.toString();
  }
  b.m("PUT").h(headers).b(body);
  return b.build();
}, "se_UpdatePublicKeyCommand");
var se_UpdateRealtimeLogConfigCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = {
    "content-type": "application/xml"
  };
  b.bp("/2020-05-31/realtime-log-config");
  let body;
  body = _ve;
  const bn = new import_xml_builder.XmlNode(_URLCR);
  bn.a("xmlns", "http://cloudfront.amazonaws.com/doc/2020-05-31/");
  if (input[_ARN] != null) {
    bn.c(import_xml_builder.XmlNode.of(_s, input[_ARN]).n(_ARN));
  }
  bn.lc(input, "EndPoints", "EndPoints", () => se_EndPointList(input[_EP], context));
  bn.lc(input, "Fields", "Fields", () => se_FieldList(input[_F], context));
  if (input[_N] != null) {
    bn.c(import_xml_builder.XmlNode.of(_s, input[_N]).n(_N));
  }
  if (input[_SR] != null) {
    bn.c(import_xml_builder.XmlNode.of(_l, String(input[_SR])).n(_SR));
  }
  body += bn.toString();
  b.m("PUT").h(headers).b(body);
  return b.build();
}, "se_UpdateRealtimeLogConfigCommand");
var se_UpdateResponseHeadersPolicyCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = (0, import_smithy_client.map)({}, import_smithy_client.isSerializableHeaderValue, {
    "content-type": "application/xml",
    [_im]: input[_IM]
  });
  b.bp("/2020-05-31/response-headers-policy/{Id}");
  b.p("Id", () => input.Id, "{Id}", false);
  let body;
  let contents;
  if (input.ResponseHeadersPolicyConfig !== void 0) {
    contents = se_ResponseHeadersPolicyConfig(input.ResponseHeadersPolicyConfig, context);
    body = _ve;
    contents.a("xmlns", "http://cloudfront.amazonaws.com/doc/2020-05-31/");
    body += contents.toString();
  }
  b.m("PUT").h(headers).b(body);
  return b.build();
}, "se_UpdateResponseHeadersPolicyCommand");
var se_UpdateStreamingDistributionCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = (0, import_smithy_client.map)({}, import_smithy_client.isSerializableHeaderValue, {
    "content-type": "application/xml",
    [_im]: input[_IM]
  });
  b.bp("/2020-05-31/streaming-distribution/{Id}/config");
  b.p("Id", () => input.Id, "{Id}", false);
  let body;
  let contents;
  if (input.StreamingDistributionConfig !== void 0) {
    contents = se_StreamingDistributionConfig(input.StreamingDistributionConfig, context);
    body = _ve;
    contents.a("xmlns", "http://cloudfront.amazonaws.com/doc/2020-05-31/");
    body += contents.toString();
  }
  b.m("PUT").h(headers).b(body);
  return b.build();
}, "se_UpdateStreamingDistributionCommand");
var se_UpdateVpcOriginCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = (0, import_smithy_client.map)({}, import_smithy_client.isSerializableHeaderValue, {
    "content-type": "application/xml",
    [_im]: input[_IM]
  });
  b.bp("/2020-05-31/vpc-origin/{Id}");
  b.p("Id", () => input.Id, "{Id}", false);
  let body;
  let contents;
  if (input.VpcOriginEndpointConfig !== void 0) {
    contents = se_VpcOriginEndpointConfig(input.VpcOriginEndpointConfig, context);
    body = _ve;
    contents.a("xmlns", "http://cloudfront.amazonaws.com/doc/2020-05-31/");
    body += contents.toString();
  }
  b.m("PUT").h(headers).b(body);
  return b.build();
}, "se_UpdateVpcOriginCommand");
var se_VerifyDnsConfigurationCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = {
    "content-type": "application/xml"
  };
  b.bp("/2020-05-31/verify-dns-configuration");
  let body;
  body = _ve;
  const bn = new import_xml_builder.XmlNode(_VDCR);
  bn.a("xmlns", "http://cloudfront.amazonaws.com/doc/2020-05-31/");
  if (input[_Do] != null) {
    bn.c(import_xml_builder.XmlNode.of(_s, input[_Do]).n(_Do));
  }
  if (input[_I] != null) {
    bn.c(import_xml_builder.XmlNode.of(_s, input[_I]).n(_I));
  }
  body += bn.toString();
  b.m("POST").h(headers).b(body);
  return b.build();
}, "se_VerifyDnsConfigurationCommand");
var de_AssociateAliasCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 200 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output)
  });
  await (0, import_smithy_client.collectBody)(output.body, context);
  return contents;
}, "de_AssociateAliasCommand");
var de_AssociateDistributionTenantWebACLCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 200 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output),
    [_ET]: [, output.headers[_e]]
  });
  const data = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.expectObject)(await (0, import_core2.parseXmlBody)(output.body, context)), "body");
  if (data[_Id] != null) {
    contents[_Id] = (0, import_smithy_client.expectString)(data[_Id]);
  }
  if (data[_WACLA] != null) {
    contents[_WACLA] = (0, import_smithy_client.expectString)(data[_WACLA]);
  }
  return contents;
}, "de_AssociateDistributionTenantWebACLCommand");
var de_AssociateDistributionWebACLCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 200 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output),
    [_ET]: [, output.headers[_e]]
  });
  const data = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.expectObject)(await (0, import_core2.parseXmlBody)(output.body, context)), "body");
  if (data[_Id] != null) {
    contents[_Id] = (0, import_smithy_client.expectString)(data[_Id]);
  }
  if (data[_WACLA] != null) {
    contents[_WACLA] = (0, import_smithy_client.expectString)(data[_WACLA]);
  }
  return contents;
}, "de_AssociateDistributionWebACLCommand");
var de_CopyDistributionCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 201 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output),
    [_L]: [, output.headers[_lo]],
    [_ET]: [, output.headers[_e]]
  });
  const data = (0, import_smithy_client.expectObject)(await (0, import_core2.parseXmlBody)(output.body, context));
  contents.Distribution = de_Distribution(data, context);
  return contents;
}, "de_CopyDistributionCommand");
var de_CreateAnycastIpListCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 202 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output),
    [_ET]: [, output.headers[_e]]
  });
  const data = (0, import_smithy_client.expectObject)(await (0, import_core2.parseXmlBody)(output.body, context));
  contents.AnycastIpList = de_AnycastIpList(data, context);
  return contents;
}, "de_CreateAnycastIpListCommand");
var de_CreateCachePolicyCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 201 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output),
    [_L]: [, output.headers[_lo]],
    [_ET]: [, output.headers[_e]]
  });
  const data = (0, import_smithy_client.expectObject)(await (0, import_core2.parseXmlBody)(output.body, context));
  contents.CachePolicy = de_CachePolicy(data, context);
  return contents;
}, "de_CreateCachePolicyCommand");
var de_CreateCloudFrontOriginAccessIdentityCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 201 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output),
    [_L]: [, output.headers[_lo]],
    [_ET]: [, output.headers[_e]]
  });
  const data = (0, import_smithy_client.expectObject)(await (0, import_core2.parseXmlBody)(output.body, context));
  contents.CloudFrontOriginAccessIdentity = de_CloudFrontOriginAccessIdentity(data, context);
  return contents;
}, "de_CreateCloudFrontOriginAccessIdentityCommand");
var de_CreateConnectionGroupCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 201 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output),
    [_ET]: [, output.headers[_e]]
  });
  const data = (0, import_smithy_client.expectObject)(await (0, import_core2.parseXmlBody)(output.body, context));
  contents.ConnectionGroup = de_ConnectionGroup(data, context);
  return contents;
}, "de_CreateConnectionGroupCommand");
var de_CreateContinuousDeploymentPolicyCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 201 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output),
    [_L]: [, output.headers[_lo]],
    [_ET]: [, output.headers[_e]]
  });
  const data = (0, import_smithy_client.expectObject)(await (0, import_core2.parseXmlBody)(output.body, context));
  contents.ContinuousDeploymentPolicy = de_ContinuousDeploymentPolicy(data, context);
  return contents;
}, "de_CreateContinuousDeploymentPolicyCommand");
var de_CreateDistributionCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 201 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output),
    [_L]: [, output.headers[_lo]],
    [_ET]: [, output.headers[_e]]
  });
  const data = (0, import_smithy_client.expectObject)(await (0, import_core2.parseXmlBody)(output.body, context));
  contents.Distribution = de_Distribution(data, context);
  return contents;
}, "de_CreateDistributionCommand");
var de_CreateDistributionTenantCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 201 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output),
    [_ET]: [, output.headers[_e]]
  });
  const data = (0, import_smithy_client.expectObject)(await (0, import_core2.parseXmlBody)(output.body, context));
  contents.DistributionTenant = de_DistributionTenant(data, context);
  return contents;
}, "de_CreateDistributionTenantCommand");
var de_CreateDistributionWithTagsCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 201 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output),
    [_L]: [, output.headers[_lo]],
    [_ET]: [, output.headers[_e]]
  });
  const data = (0, import_smithy_client.expectObject)(await (0, import_core2.parseXmlBody)(output.body, context));
  contents.Distribution = de_Distribution(data, context);
  return contents;
}, "de_CreateDistributionWithTagsCommand");
var de_CreateFieldLevelEncryptionConfigCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 201 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output),
    [_L]: [, output.headers[_lo]],
    [_ET]: [, output.headers[_e]]
  });
  const data = (0, import_smithy_client.expectObject)(await (0, import_core2.parseXmlBody)(output.body, context));
  contents.FieldLevelEncryption = de_FieldLevelEncryption(data, context);
  return contents;
}, "de_CreateFieldLevelEncryptionConfigCommand");
var de_CreateFieldLevelEncryptionProfileCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 201 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output),
    [_L]: [, output.headers[_lo]],
    [_ET]: [, output.headers[_e]]
  });
  const data = (0, import_smithy_client.expectObject)(await (0, import_core2.parseXmlBody)(output.body, context));
  contents.FieldLevelEncryptionProfile = de_FieldLevelEncryptionProfile(data, context);
  return contents;
}, "de_CreateFieldLevelEncryptionProfileCommand");
var de_CreateFunctionCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 201 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output),
    [_L]: [, output.headers[_lo]],
    [_ET]: [, output.headers[_e]]
  });
  const data = (0, import_smithy_client.expectObject)(await (0, import_core2.parseXmlBody)(output.body, context));
  contents.FunctionSummary = de_FunctionSummary(data, context);
  return contents;
}, "de_CreateFunctionCommand");
var de_CreateInvalidationCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 201 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output),
    [_L]: [, output.headers[_lo]]
  });
  const data = (0, import_smithy_client.expectObject)(await (0, import_core2.parseXmlBody)(output.body, context));
  contents.Invalidation = de_Invalidation(data, context);
  return contents;
}, "de_CreateInvalidationCommand");
var de_CreateInvalidationForDistributionTenantCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 201 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output),
    [_L]: [, output.headers[_lo]]
  });
  const data = (0, import_smithy_client.expectObject)(await (0, import_core2.parseXmlBody)(output.body, context));
  contents.Invalidation = de_Invalidation(data, context);
  return contents;
}, "de_CreateInvalidationForDistributionTenantCommand");
var de_CreateKeyGroupCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 201 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output),
    [_L]: [, output.headers[_lo]],
    [_ET]: [, output.headers[_e]]
  });
  const data = (0, import_smithy_client.expectObject)(await (0, import_core2.parseXmlBody)(output.body, context));
  contents.KeyGroup = de_KeyGroup(data, context);
  return contents;
}, "de_CreateKeyGroupCommand");
var de_CreateKeyValueStoreCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 201 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output),
    [_ET]: [, output.headers[_e]],
    [_L]: [, output.headers[_lo]]
  });
  const data = (0, import_smithy_client.expectObject)(await (0, import_core2.parseXmlBody)(output.body, context));
  contents.KeyValueStore = de_KeyValueStore(data, context);
  return contents;
}, "de_CreateKeyValueStoreCommand");
var de_CreateMonitoringSubscriptionCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 200 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output)
  });
  const data = (0, import_smithy_client.expectObject)(await (0, import_core2.parseXmlBody)(output.body, context));
  contents.MonitoringSubscription = de_MonitoringSubscription(data, context);
  return contents;
}, "de_CreateMonitoringSubscriptionCommand");
var de_CreateOriginAccessControlCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 201 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output),
    [_L]: [, output.headers[_lo]],
    [_ET]: [, output.headers[_e]]
  });
  const data = (0, import_smithy_client.expectObject)(await (0, import_core2.parseXmlBody)(output.body, context));
  contents.OriginAccessControl = de_OriginAccessControl(data, context);
  return contents;
}, "de_CreateOriginAccessControlCommand");
var de_CreateOriginRequestPolicyCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 201 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output),
    [_L]: [, output.headers[_lo]],
    [_ET]: [, output.headers[_e]]
  });
  const data = (0, import_smithy_client.expectObject)(await (0, import_core2.parseXmlBody)(output.body, context));
  contents.OriginRequestPolicy = de_OriginRequestPolicy(data, context);
  return contents;
}, "de_CreateOriginRequestPolicyCommand");
var de_CreatePublicKeyCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 201 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output),
    [_L]: [, output.headers[_lo]],
    [_ET]: [, output.headers[_e]]
  });
  const data = (0, import_smithy_client.expectObject)(await (0, import_core2.parseXmlBody)(output.body, context));
  contents.PublicKey = de_PublicKey(data, context);
  return contents;
}, "de_CreatePublicKeyCommand");
var de_CreateRealtimeLogConfigCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 201 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output)
  });
  const data = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.expectObject)(await (0, import_core2.parseXmlBody)(output.body, context)), "body");
  if (data[_RLC] != null) {
    contents[_RLC] = de_RealtimeLogConfig(data[_RLC], context);
  }
  return contents;
}, "de_CreateRealtimeLogConfigCommand");
var de_CreateResponseHeadersPolicyCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 201 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output),
    [_L]: [, output.headers[_lo]],
    [_ET]: [, output.headers[_e]]
  });
  const data = (0, import_smithy_client.expectObject)(await (0, import_core2.parseXmlBody)(output.body, context));
  contents.ResponseHeadersPolicy = de_ResponseHeadersPolicy(data, context);
  return contents;
}, "de_CreateResponseHeadersPolicyCommand");
var de_CreateStreamingDistributionCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 201 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output),
    [_L]: [, output.headers[_lo]],
    [_ET]: [, output.headers[_e]]
  });
  const data = (0, import_smithy_client.expectObject)(await (0, import_core2.parseXmlBody)(output.body, context));
  contents.StreamingDistribution = de_StreamingDistribution(data, context);
  return contents;
}, "de_CreateStreamingDistributionCommand");
var de_CreateStreamingDistributionWithTagsCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 201 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output),
    [_L]: [, output.headers[_lo]],
    [_ET]: [, output.headers[_e]]
  });
  const data = (0, import_smithy_client.expectObject)(await (0, import_core2.parseXmlBody)(output.body, context));
  contents.StreamingDistribution = de_StreamingDistribution(data, context);
  return contents;
}, "de_CreateStreamingDistributionWithTagsCommand");
var de_CreateVpcOriginCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 202 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output),
    [_L]: [, output.headers[_lo]],
    [_ET]: [, output.headers[_e]]
  });
  const data = (0, import_smithy_client.expectObject)(await (0, import_core2.parseXmlBody)(output.body, context));
  contents.VpcOrigin = de_VpcOrigin(data, context);
  return contents;
}, "de_CreateVpcOriginCommand");
var de_DeleteAnycastIpListCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 204 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output)
  });
  await (0, import_smithy_client.collectBody)(output.body, context);
  return contents;
}, "de_DeleteAnycastIpListCommand");
var de_DeleteCachePolicyCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 204 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output)
  });
  await (0, import_smithy_client.collectBody)(output.body, context);
  return contents;
}, "de_DeleteCachePolicyCommand");
var de_DeleteCloudFrontOriginAccessIdentityCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 204 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output)
  });
  await (0, import_smithy_client.collectBody)(output.body, context);
  return contents;
}, "de_DeleteCloudFrontOriginAccessIdentityCommand");
var de_DeleteConnectionGroupCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 204 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output)
  });
  await (0, import_smithy_client.collectBody)(output.body, context);
  return contents;
}, "de_DeleteConnectionGroupCommand");
var de_DeleteContinuousDeploymentPolicyCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 204 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output)
  });
  await (0, import_smithy_client.collectBody)(output.body, context);
  return contents;
}, "de_DeleteContinuousDeploymentPolicyCommand");
var de_DeleteDistributionCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 204 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output)
  });
  await (0, import_smithy_client.collectBody)(output.body, context);
  return contents;
}, "de_DeleteDistributionCommand");
var de_DeleteDistributionTenantCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 204 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output)
  });
  await (0, import_smithy_client.collectBody)(output.body, context);
  return contents;
}, "de_DeleteDistributionTenantCommand");
var de_DeleteFieldLevelEncryptionConfigCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 204 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output)
  });
  await (0, import_smithy_client.collectBody)(output.body, context);
  return contents;
}, "de_DeleteFieldLevelEncryptionConfigCommand");
var de_DeleteFieldLevelEncryptionProfileCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 204 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output)
  });
  await (0, import_smithy_client.collectBody)(output.body, context);
  return contents;
}, "de_DeleteFieldLevelEncryptionProfileCommand");
var de_DeleteFunctionCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 204 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output)
  });
  await (0, import_smithy_client.collectBody)(output.body, context);
  return contents;
}, "de_DeleteFunctionCommand");
var de_DeleteKeyGroupCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 204 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output)
  });
  await (0, import_smithy_client.collectBody)(output.body, context);
  return contents;
}, "de_DeleteKeyGroupCommand");
var de_DeleteKeyValueStoreCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 204 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output)
  });
  await (0, import_smithy_client.collectBody)(output.body, context);
  return contents;
}, "de_DeleteKeyValueStoreCommand");
var de_DeleteMonitoringSubscriptionCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 200 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output)
  });
  await (0, import_smithy_client.collectBody)(output.body, context);
  return contents;
}, "de_DeleteMonitoringSubscriptionCommand");
var de_DeleteOriginAccessControlCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 204 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output)
  });
  await (0, import_smithy_client.collectBody)(output.body, context);
  return contents;
}, "de_DeleteOriginAccessControlCommand");
var de_DeleteOriginRequestPolicyCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 204 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output)
  });
  await (0, import_smithy_client.collectBody)(output.body, context);
  return contents;
}, "de_DeleteOriginRequestPolicyCommand");
var de_DeletePublicKeyCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 204 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output)
  });
  await (0, import_smithy_client.collectBody)(output.body, context);
  return contents;
}, "de_DeletePublicKeyCommand");
var de_DeleteRealtimeLogConfigCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 204 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output)
  });
  await (0, import_smithy_client.collectBody)(output.body, context);
  return contents;
}, "de_DeleteRealtimeLogConfigCommand");
var de_DeleteResponseHeadersPolicyCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 204 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output)
  });
  await (0, import_smithy_client.collectBody)(output.body, context);
  return contents;
}, "de_DeleteResponseHeadersPolicyCommand");
var de_DeleteStreamingDistributionCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 204 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output)
  });
  await (0, import_smithy_client.collectBody)(output.body, context);
  return contents;
}, "de_DeleteStreamingDistributionCommand");
var de_DeleteVpcOriginCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 202 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output),
    [_ET]: [, output.headers[_e]]
  });
  const data = (0, import_smithy_client.expectObject)(await (0, import_core2.parseXmlBody)(output.body, context));
  contents.VpcOrigin = de_VpcOrigin(data, context);
  return contents;
}, "de_DeleteVpcOriginCommand");
var de_DescribeFunctionCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 200 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output),
    [_ET]: [, output.headers[_e]]
  });
  const data = (0, import_smithy_client.expectObject)(await (0, import_core2.parseXmlBody)(output.body, context));
  contents.FunctionSummary = de_FunctionSummary(data, context);
  return contents;
}, "de_DescribeFunctionCommand");
var de_DescribeKeyValueStoreCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 200 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output),
    [_ET]: [, output.headers[_e]]
  });
  const data = (0, import_smithy_client.expectObject)(await (0, import_core2.parseXmlBody)(output.body, context));
  contents.KeyValueStore = de_KeyValueStore(data, context);
  return contents;
}, "de_DescribeKeyValueStoreCommand");
var de_DisassociateDistributionTenantWebACLCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 200 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output),
    [_ET]: [, output.headers[_e]]
  });
  const data = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.expectObject)(await (0, import_core2.parseXmlBody)(output.body, context)), "body");
  if (data[_Id] != null) {
    contents[_Id] = (0, import_smithy_client.expectString)(data[_Id]);
  }
  return contents;
}, "de_DisassociateDistributionTenantWebACLCommand");
var de_DisassociateDistributionWebACLCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 200 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output),
    [_ET]: [, output.headers[_e]]
  });
  const data = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.expectObject)(await (0, import_core2.parseXmlBody)(output.body, context)), "body");
  if (data[_Id] != null) {
    contents[_Id] = (0, import_smithy_client.expectString)(data[_Id]);
  }
  return contents;
}, "de_DisassociateDistributionWebACLCommand");
var de_GetAnycastIpListCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 200 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output),
    [_ET]: [, output.headers[_e]]
  });
  const data = (0, import_smithy_client.expectObject)(await (0, import_core2.parseXmlBody)(output.body, context));
  contents.AnycastIpList = de_AnycastIpList(data, context);
  return contents;
}, "de_GetAnycastIpListCommand");
var de_GetCachePolicyCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 200 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output),
    [_ET]: [, output.headers[_e]]
  });
  const data = (0, import_smithy_client.expectObject)(await (0, import_core2.parseXmlBody)(output.body, context));
  contents.CachePolicy = de_CachePolicy(data, context);
  return contents;
}, "de_GetCachePolicyCommand");
var de_GetCachePolicyConfigCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 200 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output),
    [_ET]: [, output.headers[_e]]
  });
  const data = (0, import_smithy_client.expectObject)(await (0, import_core2.parseXmlBody)(output.body, context));
  contents.CachePolicyConfig = de_CachePolicyConfig(data, context);
  return contents;
}, "de_GetCachePolicyConfigCommand");
var de_GetCloudFrontOriginAccessIdentityCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 200 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output),
    [_ET]: [, output.headers[_e]]
  });
  const data = (0, import_smithy_client.expectObject)(await (0, import_core2.parseXmlBody)(output.body, context));
  contents.CloudFrontOriginAccessIdentity = de_CloudFrontOriginAccessIdentity(data, context);
  return contents;
}, "de_GetCloudFrontOriginAccessIdentityCommand");
var de_GetCloudFrontOriginAccessIdentityConfigCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 200 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output),
    [_ET]: [, output.headers[_e]]
  });
  const data = (0, import_smithy_client.expectObject)(await (0, import_core2.parseXmlBody)(output.body, context));
  contents.CloudFrontOriginAccessIdentityConfig = de_CloudFrontOriginAccessIdentityConfig(data, context);
  return contents;
}, "de_GetCloudFrontOriginAccessIdentityConfigCommand");
var de_GetConnectionGroupCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 200 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output),
    [_ET]: [, output.headers[_e]]
  });
  const data = (0, import_smithy_client.expectObject)(await (0, import_core2.parseXmlBody)(output.body, context));
  contents.ConnectionGroup = de_ConnectionGroup(data, context);
  return contents;
}, "de_GetConnectionGroupCommand");
var de_GetConnectionGroupByRoutingEndpointCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 200 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output),
    [_ET]: [, output.headers[_e]]
  });
  const data = (0, import_smithy_client.expectObject)(await (0, import_core2.parseXmlBody)(output.body, context));
  contents.ConnectionGroup = de_ConnectionGroup(data, context);
  return contents;
}, "de_GetConnectionGroupByRoutingEndpointCommand");
var de_GetContinuousDeploymentPolicyCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 200 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output),
    [_ET]: [, output.headers[_e]]
  });
  const data = (0, import_smithy_client.expectObject)(await (0, import_core2.parseXmlBody)(output.body, context));
  contents.ContinuousDeploymentPolicy = de_ContinuousDeploymentPolicy(data, context);
  return contents;
}, "de_GetContinuousDeploymentPolicyCommand");
var de_GetContinuousDeploymentPolicyConfigCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 200 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output),
    [_ET]: [, output.headers[_e]]
  });
  const data = (0, import_smithy_client.expectObject)(await (0, import_core2.parseXmlBody)(output.body, context));
  contents.ContinuousDeploymentPolicyConfig = de_ContinuousDeploymentPolicyConfig(data, context);
  return contents;
}, "de_GetContinuousDeploymentPolicyConfigCommand");
var de_GetDistributionCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 200 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output),
    [_ET]: [, output.headers[_e]]
  });
  const data = (0, import_smithy_client.expectObject)(await (0, import_core2.parseXmlBody)(output.body, context));
  contents.Distribution = de_Distribution(data, context);
  return contents;
}, "de_GetDistributionCommand");
var de_GetDistributionConfigCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 200 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output),
    [_ET]: [, output.headers[_e]]
  });
  const data = (0, import_smithy_client.expectObject)(await (0, import_core2.parseXmlBody)(output.body, context));
  contents.DistributionConfig = de_DistributionConfig(data, context);
  return contents;
}, "de_GetDistributionConfigCommand");
var de_GetDistributionTenantCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 200 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output),
    [_ET]: [, output.headers[_e]]
  });
  const data = (0, import_smithy_client.expectObject)(await (0, import_core2.parseXmlBody)(output.body, context));
  contents.DistributionTenant = de_DistributionTenant(data, context);
  return contents;
}, "de_GetDistributionTenantCommand");
var de_GetDistributionTenantByDomainCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 200 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output),
    [_ET]: [, output.headers[_e]]
  });
  const data = (0, import_smithy_client.expectObject)(await (0, import_core2.parseXmlBody)(output.body, context));
  contents.DistributionTenant = de_DistributionTenant(data, context);
  return contents;
}, "de_GetDistributionTenantByDomainCommand");
var de_GetFieldLevelEncryptionCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 200 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output),
    [_ET]: [, output.headers[_e]]
  });
  const data = (0, import_smithy_client.expectObject)(await (0, import_core2.parseXmlBody)(output.body, context));
  contents.FieldLevelEncryption = de_FieldLevelEncryption(data, context);
  return contents;
}, "de_GetFieldLevelEncryptionCommand");
var de_GetFieldLevelEncryptionConfigCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 200 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output),
    [_ET]: [, output.headers[_e]]
  });
  const data = (0, import_smithy_client.expectObject)(await (0, import_core2.parseXmlBody)(output.body, context));
  contents.FieldLevelEncryptionConfig = de_FieldLevelEncryptionConfig(data, context);
  return contents;
}, "de_GetFieldLevelEncryptionConfigCommand");
var de_GetFieldLevelEncryptionProfileCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 200 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output),
    [_ET]: [, output.headers[_e]]
  });
  const data = (0, import_smithy_client.expectObject)(await (0, import_core2.parseXmlBody)(output.body, context));
  contents.FieldLevelEncryptionProfile = de_FieldLevelEncryptionProfile(data, context);
  return contents;
}, "de_GetFieldLevelEncryptionProfileCommand");
var de_GetFieldLevelEncryptionProfileConfigCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 200 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output),
    [_ET]: [, output.headers[_e]]
  });
  const data = (0, import_smithy_client.expectObject)(await (0, import_core2.parseXmlBody)(output.body, context));
  contents.FieldLevelEncryptionProfileConfig = de_FieldLevelEncryptionProfileConfig(data, context);
  return contents;
}, "de_GetFieldLevelEncryptionProfileConfigCommand");
var de_GetFunctionCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 200 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output),
    [_ET]: [, output.headers[_e]],
    [_CT]: [, output.headers[_ct]]
  });
  const data = await (0, import_smithy_client.collectBody)(output.body, context);
  contents.FunctionCode = data;
  return contents;
}, "de_GetFunctionCommand");
var de_GetInvalidationCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 200 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output)
  });
  const data = (0, import_smithy_client.expectObject)(await (0, import_core2.parseXmlBody)(output.body, context));
  contents.Invalidation = de_Invalidation(data, context);
  return contents;
}, "de_GetInvalidationCommand");
var de_GetInvalidationForDistributionTenantCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 200 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output)
  });
  const data = (0, import_smithy_client.expectObject)(await (0, import_core2.parseXmlBody)(output.body, context));
  contents.Invalidation = de_Invalidation(data, context);
  return contents;
}, "de_GetInvalidationForDistributionTenantCommand");
var de_GetKeyGroupCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 200 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output),
    [_ET]: [, output.headers[_e]]
  });
  const data = (0, import_smithy_client.expectObject)(await (0, import_core2.parseXmlBody)(output.body, context));
  contents.KeyGroup = de_KeyGroup(data, context);
  return contents;
}, "de_GetKeyGroupCommand");
var de_GetKeyGroupConfigCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 200 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output),
    [_ET]: [, output.headers[_e]]
  });
  const data = (0, import_smithy_client.expectObject)(await (0, import_core2.parseXmlBody)(output.body, context));
  contents.KeyGroupConfig = de_KeyGroupConfig(data, context);
  return contents;
}, "de_GetKeyGroupConfigCommand");
var de_GetManagedCertificateDetailsCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 200 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output)
  });
  const data = (0, import_smithy_client.expectObject)(await (0, import_core2.parseXmlBody)(output.body, context));
  contents.ManagedCertificateDetails = de_ManagedCertificateDetails(data, context);
  return contents;
}, "de_GetManagedCertificateDetailsCommand");
var de_GetMonitoringSubscriptionCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 200 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output)
  });
  const data = (0, import_smithy_client.expectObject)(await (0, import_core2.parseXmlBody)(output.body, context));
  contents.MonitoringSubscription = de_MonitoringSubscription(data, context);
  return contents;
}, "de_GetMonitoringSubscriptionCommand");
var de_GetOriginAccessControlCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 200 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output),
    [_ET]: [, output.headers[_e]]
  });
  const data = (0, import_smithy_client.expectObject)(await (0, import_core2.parseXmlBody)(output.body, context));
  contents.OriginAccessControl = de_OriginAccessControl(data, context);
  return contents;
}, "de_GetOriginAccessControlCommand");
var de_GetOriginAccessControlConfigCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 200 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output),
    [_ET]: [, output.headers[_e]]
  });
  const data = (0, import_smithy_client.expectObject)(await (0, import_core2.parseXmlBody)(output.body, context));
  contents.OriginAccessControlConfig = de_OriginAccessControlConfig(data, context);
  return contents;
}, "de_GetOriginAccessControlConfigCommand");
var de_GetOriginRequestPolicyCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 200 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output),
    [_ET]: [, output.headers[_e]]
  });
  const data = (0, import_smithy_client.expectObject)(await (0, import_core2.parseXmlBody)(output.body, context));
  contents.OriginRequestPolicy = de_OriginRequestPolicy(data, context);
  return contents;
}, "de_GetOriginRequestPolicyCommand");
var de_GetOriginRequestPolicyConfigCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 200 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output),
    [_ET]: [, output.headers[_e]]
  });
  const data = (0, import_smithy_client.expectObject)(await (0, import_core2.parseXmlBody)(output.body, context));
  contents.OriginRequestPolicyConfig = de_OriginRequestPolicyConfig(data, context);
  return contents;
}, "de_GetOriginRequestPolicyConfigCommand");
var de_GetPublicKeyCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 200 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output),
    [_ET]: [, output.headers[_e]]
  });
  const data = (0, import_smithy_client.expectObject)(await (0, import_core2.parseXmlBody)(output.body, context));
  contents.PublicKey = de_PublicKey(data, context);
  return contents;
}, "de_GetPublicKeyCommand");
var de_GetPublicKeyConfigCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 200 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output),
    [_ET]: [, output.headers[_e]]
  });
  const data = (0, import_smithy_client.expectObject)(await (0, import_core2.parseXmlBody)(output.body, context));
  contents.PublicKeyConfig = de_PublicKeyConfig(data, context);
  return contents;
}, "de_GetPublicKeyConfigCommand");
var de_GetRealtimeLogConfigCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 200 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output)
  });
  const data = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.expectObject)(await (0, import_core2.parseXmlBody)(output.body, context)), "body");
  if (data[_RLC] != null) {
    contents[_RLC] = de_RealtimeLogConfig(data[_RLC], context);
  }
  return contents;
}, "de_GetRealtimeLogConfigCommand");
var de_GetResponseHeadersPolicyCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 200 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output),
    [_ET]: [, output.headers[_e]]
  });
  const data = (0, import_smithy_client.expectObject)(await (0, import_core2.parseXmlBody)(output.body, context));
  contents.ResponseHeadersPolicy = de_ResponseHeadersPolicy(data, context);
  return contents;
}, "de_GetResponseHeadersPolicyCommand");
var de_GetResponseHeadersPolicyConfigCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 200 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output),
    [_ET]: [, output.headers[_e]]
  });
  const data = (0, import_smithy_client.expectObject)(await (0, import_core2.parseXmlBody)(output.body, context));
  contents.ResponseHeadersPolicyConfig = de_ResponseHeadersPolicyConfig(data, context);
  return contents;
}, "de_GetResponseHeadersPolicyConfigCommand");
var de_GetStreamingDistributionCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 200 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output),
    [_ET]: [, output.headers[_e]]
  });
  const data = (0, import_smithy_client.expectObject)(await (0, import_core2.parseXmlBody)(output.body, context));
  contents.StreamingDistribution = de_StreamingDistribution(data, context);
  return contents;
}, "de_GetStreamingDistributionCommand");
var de_GetStreamingDistributionConfigCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 200 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output),
    [_ET]: [, output.headers[_e]]
  });
  const data = (0, import_smithy_client.expectObject)(await (0, import_core2.parseXmlBody)(output.body, context));
  contents.StreamingDistributionConfig = de_StreamingDistributionConfig(data, context);
  return contents;
}, "de_GetStreamingDistributionConfigCommand");
var de_GetVpcOriginCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 200 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output),
    [_ET]: [, output.headers[_e]]
  });
  const data = (0, import_smithy_client.expectObject)(await (0, import_core2.parseXmlBody)(output.body, context));
  contents.VpcOrigin = de_VpcOrigin(data, context);
  return contents;
}, "de_GetVpcOriginCommand");
var de_ListAnycastIpListsCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 200 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output)
  });
  const data = (0, import_smithy_client.expectObject)(await (0, import_core2.parseXmlBody)(output.body, context));
  contents.AnycastIpLists = de_AnycastIpListCollection(data, context);
  return contents;
}, "de_ListAnycastIpListsCommand");
var de_ListCachePoliciesCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 200 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output)
  });
  const data = (0, import_smithy_client.expectObject)(await (0, import_core2.parseXmlBody)(output.body, context));
  contents.CachePolicyList = de_CachePolicyList(data, context);
  return contents;
}, "de_ListCachePoliciesCommand");
var de_ListCloudFrontOriginAccessIdentitiesCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 200 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output)
  });
  const data = (0, import_smithy_client.expectObject)(await (0, import_core2.parseXmlBody)(output.body, context));
  contents.CloudFrontOriginAccessIdentityList = de_CloudFrontOriginAccessIdentityList(data, context);
  return contents;
}, "de_ListCloudFrontOriginAccessIdentitiesCommand");
var de_ListConflictingAliasesCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 200 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output)
  });
  const data = (0, import_smithy_client.expectObject)(await (0, import_core2.parseXmlBody)(output.body, context));
  contents.ConflictingAliasesList = de_ConflictingAliasesList(data, context);
  return contents;
}, "de_ListConflictingAliasesCommand");
var de_ListConnectionGroupsCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 200 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output)
  });
  const data = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.expectObject)(await (0, import_core2.parseXmlBody)(output.body, context)), "body");
  if (data.ConnectionGroups === "") {
    contents[_CG] = [];
  } else if (data[_CG] != null && data[_CG][_CGS] != null) {
    contents[_CG] = de_ConnectionGroupSummaryList((0, import_smithy_client.getArrayIfSingleItem)(data[_CG][_CGS]), context);
  }
  if (data[_NM] != null) {
    contents[_NM] = (0, import_smithy_client.expectString)(data[_NM]);
  }
  return contents;
}, "de_ListConnectionGroupsCommand");
var de_ListContinuousDeploymentPoliciesCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 200 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output)
  });
  const data = (0, import_smithy_client.expectObject)(await (0, import_core2.parseXmlBody)(output.body, context));
  contents.ContinuousDeploymentPolicyList = de_ContinuousDeploymentPolicyList(data, context);
  return contents;
}, "de_ListContinuousDeploymentPoliciesCommand");
var de_ListDistributionsCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 200 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output)
  });
  const data = (0, import_smithy_client.expectObject)(await (0, import_core2.parseXmlBody)(output.body, context));
  contents.DistributionList = de_DistributionList(data, context);
  return contents;
}, "de_ListDistributionsCommand");
var de_ListDistributionsByAnycastIpListIdCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 200 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output)
  });
  const data = (0, import_smithy_client.expectObject)(await (0, import_core2.parseXmlBody)(output.body, context));
  contents.DistributionList = de_DistributionList(data, context);
  return contents;
}, "de_ListDistributionsByAnycastIpListIdCommand");
var de_ListDistributionsByCachePolicyIdCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 200 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output)
  });
  const data = (0, import_smithy_client.expectObject)(await (0, import_core2.parseXmlBody)(output.body, context));
  contents.DistributionIdList = de_DistributionIdList(data, context);
  return contents;
}, "de_ListDistributionsByCachePolicyIdCommand");
var de_ListDistributionsByConnectionModeCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 200 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output)
  });
  const data = (0, import_smithy_client.expectObject)(await (0, import_core2.parseXmlBody)(output.body, context));
  contents.DistributionList = de_DistributionList(data, context);
  return contents;
}, "de_ListDistributionsByConnectionModeCommand");
var de_ListDistributionsByKeyGroupCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 200 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output)
  });
  const data = (0, import_smithy_client.expectObject)(await (0, import_core2.parseXmlBody)(output.body, context));
  contents.DistributionIdList = de_DistributionIdList(data, context);
  return contents;
}, "de_ListDistributionsByKeyGroupCommand");
var de_ListDistributionsByOriginRequestPolicyIdCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 200 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output)
  });
  const data = (0, import_smithy_client.expectObject)(await (0, import_core2.parseXmlBody)(output.body, context));
  contents.DistributionIdList = de_DistributionIdList(data, context);
  return contents;
}, "de_ListDistributionsByOriginRequestPolicyIdCommand");
var de_ListDistributionsByRealtimeLogConfigCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 200 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output)
  });
  const data = (0, import_smithy_client.expectObject)(await (0, import_core2.parseXmlBody)(output.body, context));
  contents.DistributionList = de_DistributionList(data, context);
  return contents;
}, "de_ListDistributionsByRealtimeLogConfigCommand");
var de_ListDistributionsByResponseHeadersPolicyIdCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 200 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output)
  });
  const data = (0, import_smithy_client.expectObject)(await (0, import_core2.parseXmlBody)(output.body, context));
  contents.DistributionIdList = de_DistributionIdList(data, context);
  return contents;
}, "de_ListDistributionsByResponseHeadersPolicyIdCommand");
var de_ListDistributionsByVpcOriginIdCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 200 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output)
  });
  const data = (0, import_smithy_client.expectObject)(await (0, import_core2.parseXmlBody)(output.body, context));
  contents.DistributionIdList = de_DistributionIdList(data, context);
  return contents;
}, "de_ListDistributionsByVpcOriginIdCommand");
var de_ListDistributionsByWebACLIdCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 200 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output)
  });
  const data = (0, import_smithy_client.expectObject)(await (0, import_core2.parseXmlBody)(output.body, context));
  contents.DistributionList = de_DistributionList(data, context);
  return contents;
}, "de_ListDistributionsByWebACLIdCommand");
var de_ListDistributionTenantsCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 200 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output)
  });
  const data = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.expectObject)(await (0, import_core2.parseXmlBody)(output.body, context)), "body");
  if (data.DistributionTenantList === "") {
    contents[_DTL] = [];
  } else if (data[_DTL] != null && data[_DTL][_DTS] != null) {
    contents[_DTL] = de_DistributionTenantList((0, import_smithy_client.getArrayIfSingleItem)(data[_DTL][_DTS]), context);
  }
  if (data[_NM] != null) {
    contents[_NM] = (0, import_smithy_client.expectString)(data[_NM]);
  }
  return contents;
}, "de_ListDistributionTenantsCommand");
var de_ListDistributionTenantsByCustomizationCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 200 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output)
  });
  const data = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.expectObject)(await (0, import_core2.parseXmlBody)(output.body, context)), "body");
  if (data.DistributionTenantList === "") {
    contents[_DTL] = [];
  } else if (data[_DTL] != null && data[_DTL][_DTS] != null) {
    contents[_DTL] = de_DistributionTenantList((0, import_smithy_client.getArrayIfSingleItem)(data[_DTL][_DTS]), context);
  }
  if (data[_NM] != null) {
    contents[_NM] = (0, import_smithy_client.expectString)(data[_NM]);
  }
  return contents;
}, "de_ListDistributionTenantsByCustomizationCommand");
var de_ListDomainConflictsCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 200 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output)
  });
  const data = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.expectObject)(await (0, import_core2.parseXmlBody)(output.body, context)), "body");
  if (data.DomainConflicts === "") {
    contents[_DC] = [];
  } else if (data[_DC] != null && data[_DC][_DC] != null) {
    contents[_DC] = de_DomainConflictsList((0, import_smithy_client.getArrayIfSingleItem)(data[_DC][_DC]), context);
  }
  if (data[_NM] != null) {
    contents[_NM] = (0, import_smithy_client.expectString)(data[_NM]);
  }
  return contents;
}, "de_ListDomainConflictsCommand");
var de_ListFieldLevelEncryptionConfigsCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 200 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output)
  });
  const data = (0, import_smithy_client.expectObject)(await (0, import_core2.parseXmlBody)(output.body, context));
  contents.FieldLevelEncryptionList = de_FieldLevelEncryptionList(data, context);
  return contents;
}, "de_ListFieldLevelEncryptionConfigsCommand");
var de_ListFieldLevelEncryptionProfilesCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 200 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output)
  });
  const data = (0, import_smithy_client.expectObject)(await (0, import_core2.parseXmlBody)(output.body, context));
  contents.FieldLevelEncryptionProfileList = de_FieldLevelEncryptionProfileList(data, context);
  return contents;
}, "de_ListFieldLevelEncryptionProfilesCommand");
var de_ListFunctionsCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 200 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output)
  });
  const data = (0, import_smithy_client.expectObject)(await (0, import_core2.parseXmlBody)(output.body, context));
  contents.FunctionList = de_FunctionList(data, context);
  return contents;
}, "de_ListFunctionsCommand");
var de_ListInvalidationsCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 200 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output)
  });
  const data = (0, import_smithy_client.expectObject)(await (0, import_core2.parseXmlBody)(output.body, context));
  contents.InvalidationList = de_InvalidationList(data, context);
  return contents;
}, "de_ListInvalidationsCommand");
var de_ListInvalidationsForDistributionTenantCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 200 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output)
  });
  const data = (0, import_smithy_client.expectObject)(await (0, import_core2.parseXmlBody)(output.body, context));
  contents.InvalidationList = de_InvalidationList(data, context);
  return contents;
}, "de_ListInvalidationsForDistributionTenantCommand");
var de_ListKeyGroupsCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 200 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output)
  });
  const data = (0, import_smithy_client.expectObject)(await (0, import_core2.parseXmlBody)(output.body, context));
  contents.KeyGroupList = de_KeyGroupList(data, context);
  return contents;
}, "de_ListKeyGroupsCommand");
var de_ListKeyValueStoresCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 200 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output)
  });
  const data = (0, import_smithy_client.expectObject)(await (0, import_core2.parseXmlBody)(output.body, context));
  contents.KeyValueStoreList = de_KeyValueStoreList(data, context);
  return contents;
}, "de_ListKeyValueStoresCommand");
var de_ListOriginAccessControlsCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 200 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output)
  });
  const data = (0, import_smithy_client.expectObject)(await (0, import_core2.parseXmlBody)(output.body, context));
  contents.OriginAccessControlList = de_OriginAccessControlList(data, context);
  return contents;
}, "de_ListOriginAccessControlsCommand");
var de_ListOriginRequestPoliciesCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 200 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output)
  });
  const data = (0, import_smithy_client.expectObject)(await (0, import_core2.parseXmlBody)(output.body, context));
  contents.OriginRequestPolicyList = de_OriginRequestPolicyList(data, context);
  return contents;
}, "de_ListOriginRequestPoliciesCommand");
var de_ListPublicKeysCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 200 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output)
  });
  const data = (0, import_smithy_client.expectObject)(await (0, import_core2.parseXmlBody)(output.body, context));
  contents.PublicKeyList = de_PublicKeyList(data, context);
  return contents;
}, "de_ListPublicKeysCommand");
var de_ListRealtimeLogConfigsCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 200 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output)
  });
  const data = (0, import_smithy_client.expectObject)(await (0, import_core2.parseXmlBody)(output.body, context));
  contents.RealtimeLogConfigs = de_RealtimeLogConfigs(data, context);
  return contents;
}, "de_ListRealtimeLogConfigsCommand");
var de_ListResponseHeadersPoliciesCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 200 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output)
  });
  const data = (0, import_smithy_client.expectObject)(await (0, import_core2.parseXmlBody)(output.body, context));
  contents.ResponseHeadersPolicyList = de_ResponseHeadersPolicyList(data, context);
  return contents;
}, "de_ListResponseHeadersPoliciesCommand");
var de_ListStreamingDistributionsCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 200 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output)
  });
  const data = (0, import_smithy_client.expectObject)(await (0, import_core2.parseXmlBody)(output.body, context));
  contents.StreamingDistributionList = de_StreamingDistributionList(data, context);
  return contents;
}, "de_ListStreamingDistributionsCommand");
var de_ListTagsForResourceCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 200 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output)
  });
  const data = (0, import_smithy_client.expectObject)(await (0, import_core2.parseXmlBody)(output.body, context));
  contents.Tags = de_Tags(data, context);
  return contents;
}, "de_ListTagsForResourceCommand");
var de_ListVpcOriginsCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 200 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output)
  });
  const data = (0, import_smithy_client.expectObject)(await (0, import_core2.parseXmlBody)(output.body, context));
  contents.VpcOriginList = de_VpcOriginList(data, context);
  return contents;
}, "de_ListVpcOriginsCommand");
var de_PublishFunctionCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 200 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output)
  });
  const data = (0, import_smithy_client.expectObject)(await (0, import_core2.parseXmlBody)(output.body, context));
  contents.FunctionSummary = de_FunctionSummary(data, context);
  return contents;
}, "de_PublishFunctionCommand");
var de_TagResourceCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 204 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output)
  });
  await (0, import_smithy_client.collectBody)(output.body, context);
  return contents;
}, "de_TagResourceCommand");
var de_TestFunctionCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 200 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output)
  });
  const data = (0, import_smithy_client.expectObject)(await (0, import_core2.parseXmlBody)(output.body, context));
  contents.TestResult = de_TestResult(data, context);
  return contents;
}, "de_TestFunctionCommand");
var de_UntagResourceCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 204 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output)
  });
  await (0, import_smithy_client.collectBody)(output.body, context);
  return contents;
}, "de_UntagResourceCommand");
var de_UpdateCachePolicyCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 200 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output),
    [_ET]: [, output.headers[_e]]
  });
  const data = (0, import_smithy_client.expectObject)(await (0, import_core2.parseXmlBody)(output.body, context));
  contents.CachePolicy = de_CachePolicy(data, context);
  return contents;
}, "de_UpdateCachePolicyCommand");
var de_UpdateCloudFrontOriginAccessIdentityCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 200 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output),
    [_ET]: [, output.headers[_e]]
  });
  const data = (0, import_smithy_client.expectObject)(await (0, import_core2.parseXmlBody)(output.body, context));
  contents.CloudFrontOriginAccessIdentity = de_CloudFrontOriginAccessIdentity(data, context);
  return contents;
}, "de_UpdateCloudFrontOriginAccessIdentityCommand");
var de_UpdateConnectionGroupCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 200 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output),
    [_ET]: [, output.headers[_e]]
  });
  const data = (0, import_smithy_client.expectObject)(await (0, import_core2.parseXmlBody)(output.body, context));
  contents.ConnectionGroup = de_ConnectionGroup(data, context);
  return contents;
}, "de_UpdateConnectionGroupCommand");
var de_UpdateContinuousDeploymentPolicyCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 200 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output),
    [_ET]: [, output.headers[_e]]
  });
  const data = (0, import_smithy_client.expectObject)(await (0, import_core2.parseXmlBody)(output.body, context));
  contents.ContinuousDeploymentPolicy = de_ContinuousDeploymentPolicy(data, context);
  return contents;
}, "de_UpdateContinuousDeploymentPolicyCommand");
var de_UpdateDistributionCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 200 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output),
    [_ET]: [, output.headers[_e]]
  });
  const data = (0, import_smithy_client.expectObject)(await (0, import_core2.parseXmlBody)(output.body, context));
  contents.Distribution = de_Distribution(data, context);
  return contents;
}, "de_UpdateDistributionCommand");
var de_UpdateDistributionTenantCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 200 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output),
    [_ET]: [, output.headers[_e]]
  });
  const data = (0, import_smithy_client.expectObject)(await (0, import_core2.parseXmlBody)(output.body, context));
  contents.DistributionTenant = de_DistributionTenant(data, context);
  return contents;
}, "de_UpdateDistributionTenantCommand");
var de_UpdateDistributionWithStagingConfigCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 200 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output),
    [_ET]: [, output.headers[_e]]
  });
  const data = (0, import_smithy_client.expectObject)(await (0, import_core2.parseXmlBody)(output.body, context));
  contents.Distribution = de_Distribution(data, context);
  return contents;
}, "de_UpdateDistributionWithStagingConfigCommand");
var de_UpdateDomainAssociationCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 200 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output),
    [_ET]: [, output.headers[_e]]
  });
  const data = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.expectObject)(await (0, import_core2.parseXmlBody)(output.body, context)), "body");
  if (data[_Do] != null) {
    contents[_Do] = (0, import_smithy_client.expectString)(data[_Do]);
  }
  if (data[_RI] != null) {
    contents[_RI] = (0, import_smithy_client.expectString)(data[_RI]);
  }
  return contents;
}, "de_UpdateDomainAssociationCommand");
var de_UpdateFieldLevelEncryptionConfigCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 200 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output),
    [_ET]: [, output.headers[_e]]
  });
  const data = (0, import_smithy_client.expectObject)(await (0, import_core2.parseXmlBody)(output.body, context));
  contents.FieldLevelEncryption = de_FieldLevelEncryption(data, context);
  return contents;
}, "de_UpdateFieldLevelEncryptionConfigCommand");
var de_UpdateFieldLevelEncryptionProfileCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 200 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output),
    [_ET]: [, output.headers[_e]]
  });
  const data = (0, import_smithy_client.expectObject)(await (0, import_core2.parseXmlBody)(output.body, context));
  contents.FieldLevelEncryptionProfile = de_FieldLevelEncryptionProfile(data, context);
  return contents;
}, "de_UpdateFieldLevelEncryptionProfileCommand");
var de_UpdateFunctionCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 200 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output),
    [_ET]: [, output.headers[_et]]
  });
  const data = (0, import_smithy_client.expectObject)(await (0, import_core2.parseXmlBody)(output.body, context));
  contents.FunctionSummary = de_FunctionSummary(data, context);
  return contents;
}, "de_UpdateFunctionCommand");
var de_UpdateKeyGroupCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 200 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output),
    [_ET]: [, output.headers[_e]]
  });
  const data = (0, import_smithy_client.expectObject)(await (0, import_core2.parseXmlBody)(output.body, context));
  contents.KeyGroup = de_KeyGroup(data, context);
  return contents;
}, "de_UpdateKeyGroupCommand");
var de_UpdateKeyValueStoreCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 200 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output),
    [_ET]: [, output.headers[_e]]
  });
  const data = (0, import_smithy_client.expectObject)(await (0, import_core2.parseXmlBody)(output.body, context));
  contents.KeyValueStore = de_KeyValueStore(data, context);
  return contents;
}, "de_UpdateKeyValueStoreCommand");
var de_UpdateOriginAccessControlCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 200 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output),
    [_ET]: [, output.headers[_e]]
  });
  const data = (0, import_smithy_client.expectObject)(await (0, import_core2.parseXmlBody)(output.body, context));
  contents.OriginAccessControl = de_OriginAccessControl(data, context);
  return contents;
}, "de_UpdateOriginAccessControlCommand");
var de_UpdateOriginRequestPolicyCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 200 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output),
    [_ET]: [, output.headers[_e]]
  });
  const data = (0, import_smithy_client.expectObject)(await (0, import_core2.parseXmlBody)(output.body, context));
  contents.OriginRequestPolicy = de_OriginRequestPolicy(data, context);
  return contents;
}, "de_UpdateOriginRequestPolicyCommand");
var de_UpdatePublicKeyCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 200 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output),
    [_ET]: [, output.headers[_e]]
  });
  const data = (0, import_smithy_client.expectObject)(await (0, import_core2.parseXmlBody)(output.body, context));
  contents.PublicKey = de_PublicKey(data, context);
  return contents;
}, "de_UpdatePublicKeyCommand");
var de_UpdateRealtimeLogConfigCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 200 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output)
  });
  const data = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.expectObject)(await (0, import_core2.parseXmlBody)(output.body, context)), "body");
  if (data[_RLC] != null) {
    contents[_RLC] = de_RealtimeLogConfig(data[_RLC], context);
  }
  return contents;
}, "de_UpdateRealtimeLogConfigCommand");
var de_UpdateResponseHeadersPolicyCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 200 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output),
    [_ET]: [, output.headers[_e]]
  });
  const data = (0, import_smithy_client.expectObject)(await (0, import_core2.parseXmlBody)(output.body, context));
  contents.ResponseHeadersPolicy = de_ResponseHeadersPolicy(data, context);
  return contents;
}, "de_UpdateResponseHeadersPolicyCommand");
var de_UpdateStreamingDistributionCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 200 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output),
    [_ET]: [, output.headers[_e]]
  });
  const data = (0, import_smithy_client.expectObject)(await (0, import_core2.parseXmlBody)(output.body, context));
  contents.StreamingDistribution = de_StreamingDistribution(data, context);
  return contents;
}, "de_UpdateStreamingDistributionCommand");
var de_UpdateVpcOriginCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 202 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output),
    [_ET]: [, output.headers[_e]]
  });
  const data = (0, import_smithy_client.expectObject)(await (0, import_core2.parseXmlBody)(output.body, context));
  contents.VpcOrigin = de_VpcOrigin(data, context);
  return contents;
}, "de_UpdateVpcOriginCommand");
var de_VerifyDnsConfigurationCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 200 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output)
  });
  const data = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.expectObject)(await (0, import_core2.parseXmlBody)(output.body, context)), "body");
  if (data.DnsConfigurationList === "") {
    contents[_DCL] = [];
  } else if (data[_DCL] != null && data[_DCL][_DCn] != null) {
    contents[_DCL] = de_DnsConfigurationList((0, import_smithy_client.getArrayIfSingleItem)(data[_DCL][_DCn]), context);
  }
  return contents;
}, "de_VerifyDnsConfigurationCommand");
var de_CommandError = /* @__PURE__ */ __name(async (output, context) => {
  const parsedOutput = {
    ...output,
    body: await (0, import_core2.parseXmlErrorBody)(output.body, context)
  };
  const errorCode = (0, import_core2.loadRestXmlErrorCode)(output, parsedOutput.body);
  switch (errorCode) {
    case "AccessDenied":
    case "com.amazonaws.cloudfront#AccessDenied":
      throw await de_AccessDeniedRes(parsedOutput, context);
    case "IllegalUpdate":
    case "com.amazonaws.cloudfront#IllegalUpdate":
      throw await de_IllegalUpdateRes(parsedOutput, context);
    case "InvalidArgument":
    case "com.amazonaws.cloudfront#InvalidArgument":
      throw await de_InvalidArgumentRes(parsedOutput, context);
    case "NoSuchDistribution":
    case "com.amazonaws.cloudfront#NoSuchDistribution":
      throw await de_NoSuchDistributionRes(parsedOutput, context);
    case "TooManyDistributionCNAMEs":
    case "com.amazonaws.cloudfront#TooManyDistributionCNAMEs":
      throw await de_TooManyDistributionCNAMEsRes(parsedOutput, context);
    case "EntityNotFound":
    case "com.amazonaws.cloudfront#EntityNotFound":
      throw await de_EntityNotFoundRes(parsedOutput, context);
    case "InvalidIfMatchVersion":
    case "com.amazonaws.cloudfront#InvalidIfMatchVersion":
      throw await de_InvalidIfMatchVersionRes(parsedOutput, context);
    case "PreconditionFailed":
    case "com.amazonaws.cloudfront#PreconditionFailed":
      throw await de_PreconditionFailedRes(parsedOutput, context);
    case "CNAMEAlreadyExists":
    case "com.amazonaws.cloudfront#CNAMEAlreadyExists":
      throw await de_CNAMEAlreadyExistsRes(parsedOutput, context);
    case "DistributionAlreadyExists":
    case "com.amazonaws.cloudfront#DistributionAlreadyExists":
      throw await de_DistributionAlreadyExistsRes(parsedOutput, context);
    case "IllegalFieldLevelEncryptionConfigAssociationWithCacheBehavior":
    case "com.amazonaws.cloudfront#IllegalFieldLevelEncryptionConfigAssociationWithCacheBehavior":
      throw await de_IllegalFieldLevelEncryptionConfigAssociationWithCacheBehaviorRes(parsedOutput, context);
    case "InconsistentQuantities":
    case "com.amazonaws.cloudfront#InconsistentQuantities":
      throw await de_InconsistentQuantitiesRes(parsedOutput, context);
    case "InvalidDefaultRootObject":
    case "com.amazonaws.cloudfront#InvalidDefaultRootObject":
      throw await de_InvalidDefaultRootObjectRes(parsedOutput, context);
    case "InvalidErrorCode":
    case "com.amazonaws.cloudfront#InvalidErrorCode":
      throw await de_InvalidErrorCodeRes(parsedOutput, context);
    case "InvalidForwardCookies":
    case "com.amazonaws.cloudfront#InvalidForwardCookies":
      throw await de_InvalidForwardCookiesRes(parsedOutput, context);
    case "InvalidFunctionAssociation":
    case "com.amazonaws.cloudfront#InvalidFunctionAssociation":
      throw await de_InvalidFunctionAssociationRes(parsedOutput, context);
    case "InvalidGeoRestrictionParameter":
    case "com.amazonaws.cloudfront#InvalidGeoRestrictionParameter":
      throw await de_InvalidGeoRestrictionParameterRes(parsedOutput, context);
    case "InvalidHeadersForS3Origin":
    case "com.amazonaws.cloudfront#InvalidHeadersForS3Origin":
      throw await de_InvalidHeadersForS3OriginRes(parsedOutput, context);
    case "InvalidLambdaFunctionAssociation":
    case "com.amazonaws.cloudfront#InvalidLambdaFunctionAssociation":
      throw await de_InvalidLambdaFunctionAssociationRes(parsedOutput, context);
    case "InvalidLocationCode":
    case "com.amazonaws.cloudfront#InvalidLocationCode":
      throw await de_InvalidLocationCodeRes(parsedOutput, context);
    case "InvalidMinimumProtocolVersion":
    case "com.amazonaws.cloudfront#InvalidMinimumProtocolVersion":
      throw await de_InvalidMinimumProtocolVersionRes(parsedOutput, context);
    case "InvalidOrigin":
    case "com.amazonaws.cloudfront#InvalidOrigin":
      throw await de_InvalidOriginRes(parsedOutput, context);
    case "InvalidOriginAccessControl":
    case "com.amazonaws.cloudfront#InvalidOriginAccessControl":
      throw await de_InvalidOriginAccessControlRes(parsedOutput, context);
    case "InvalidOriginAccessIdentity":
    case "com.amazonaws.cloudfront#InvalidOriginAccessIdentity":
      throw await de_InvalidOriginAccessIdentityRes(parsedOutput, context);
    case "InvalidOriginKeepaliveTimeout":
    case "com.amazonaws.cloudfront#InvalidOriginKeepaliveTimeout":
      throw await de_InvalidOriginKeepaliveTimeoutRes(parsedOutput, context);
    case "InvalidOriginReadTimeout":
    case "com.amazonaws.cloudfront#InvalidOriginReadTimeout":
      throw await de_InvalidOriginReadTimeoutRes(parsedOutput, context);
    case "InvalidProtocolSettings":
    case "com.amazonaws.cloudfront#InvalidProtocolSettings":
      throw await de_InvalidProtocolSettingsRes(parsedOutput, context);
    case "InvalidQueryStringParameters":
    case "com.amazonaws.cloudfront#InvalidQueryStringParameters":
      throw await de_InvalidQueryStringParametersRes(parsedOutput, context);
    case "InvalidRelativePath":
    case "com.amazonaws.cloudfront#InvalidRelativePath":
      throw await de_InvalidRelativePathRes(parsedOutput, context);
    case "InvalidRequiredProtocol":
    case "com.amazonaws.cloudfront#InvalidRequiredProtocol":
      throw await de_InvalidRequiredProtocolRes(parsedOutput, context);
    case "InvalidResponseCode":
    case "com.amazonaws.cloudfront#InvalidResponseCode":
      throw await de_InvalidResponseCodeRes(parsedOutput, context);
    case "InvalidTTLOrder":
    case "com.amazonaws.cloudfront#InvalidTTLOrder":
      throw await de_InvalidTTLOrderRes(parsedOutput, context);
    case "InvalidViewerCertificate":
    case "com.amazonaws.cloudfront#InvalidViewerCertificate":
      throw await de_InvalidViewerCertificateRes(parsedOutput, context);
    case "InvalidWebACLId":
    case "com.amazonaws.cloudfront#InvalidWebACLId":
      throw await de_InvalidWebACLIdRes(parsedOutput, context);
    case "MissingBody":
    case "com.amazonaws.cloudfront#MissingBody":
      throw await de_MissingBodyRes(parsedOutput, context);
    case "NoSuchCachePolicy":
    case "com.amazonaws.cloudfront#NoSuchCachePolicy":
      throw await de_NoSuchCachePolicyRes(parsedOutput, context);
    case "NoSuchFieldLevelEncryptionConfig":
    case "com.amazonaws.cloudfront#NoSuchFieldLevelEncryptionConfig":
      throw await de_NoSuchFieldLevelEncryptionConfigRes(parsedOutput, context);
    case "NoSuchOrigin":
    case "com.amazonaws.cloudfront#NoSuchOrigin":
      throw await de_NoSuchOriginRes(parsedOutput, context);
    case "NoSuchOriginRequestPolicy":
    case "com.amazonaws.cloudfront#NoSuchOriginRequestPolicy":
      throw await de_NoSuchOriginRequestPolicyRes(parsedOutput, context);
    case "NoSuchRealtimeLogConfig":
    case "com.amazonaws.cloudfront#NoSuchRealtimeLogConfig":
      throw await de_NoSuchRealtimeLogConfigRes(parsedOutput, context);
    case "NoSuchResponseHeadersPolicy":
    case "com.amazonaws.cloudfront#NoSuchResponseHeadersPolicy":
      throw await de_NoSuchResponseHeadersPolicyRes(parsedOutput, context);
    case "RealtimeLogConfigOwnerMismatch":
    case "com.amazonaws.cloudfront#RealtimeLogConfigOwnerMismatch":
      throw await de_RealtimeLogConfigOwnerMismatchRes(parsedOutput, context);
    case "TooManyCacheBehaviors":
    case "com.amazonaws.cloudfront#TooManyCacheBehaviors":
      throw await de_TooManyCacheBehaviorsRes(parsedOutput, context);
    case "TooManyCertificates":
    case "com.amazonaws.cloudfront#TooManyCertificates":
      throw await de_TooManyCertificatesRes(parsedOutput, context);
    case "TooManyCookieNamesInWhiteList":
    case "com.amazonaws.cloudfront#TooManyCookieNamesInWhiteList":
      throw await de_TooManyCookieNamesInWhiteListRes(parsedOutput, context);
    case "TooManyDistributions":
    case "com.amazonaws.cloudfront#TooManyDistributions":
      throw await de_TooManyDistributionsRes(parsedOutput, context);
    case "TooManyDistributionsAssociatedToCachePolicy":
    case "com.amazonaws.cloudfront#TooManyDistributionsAssociatedToCachePolicy":
      throw await de_TooManyDistributionsAssociatedToCachePolicyRes(parsedOutput, context);
    case "TooManyDistributionsAssociatedToFieldLevelEncryptionConfig":
    case "com.amazonaws.cloudfront#TooManyDistributionsAssociatedToFieldLevelEncryptionConfig":
      throw await de_TooManyDistributionsAssociatedToFieldLevelEncryptionConfigRes(parsedOutput, context);
    case "TooManyDistributionsAssociatedToKeyGroup":
    case "com.amazonaws.cloudfront#TooManyDistributionsAssociatedToKeyGroup":
      throw await de_TooManyDistributionsAssociatedToKeyGroupRes(parsedOutput, context);
    case "TooManyDistributionsAssociatedToOriginAccessControl":
    case "com.amazonaws.cloudfront#TooManyDistributionsAssociatedToOriginAccessControl":
      throw await de_TooManyDistributionsAssociatedToOriginAccessControlRes(parsedOutput, context);
    case "TooManyDistributionsAssociatedToOriginRequestPolicy":
    case "com.amazonaws.cloudfront#TooManyDistributionsAssociatedToOriginRequestPolicy":
      throw await de_TooManyDistributionsAssociatedToOriginRequestPolicyRes(parsedOutput, context);
    case "TooManyDistributionsAssociatedToResponseHeadersPolicy":
    case "com.amazonaws.cloudfront#TooManyDistributionsAssociatedToResponseHeadersPolicy":
      throw await de_TooManyDistributionsAssociatedToResponseHeadersPolicyRes(parsedOutput, context);
    case "TooManyDistributionsWithFunctionAssociations":
    case "com.amazonaws.cloudfront#TooManyDistributionsWithFunctionAssociations":
      throw await de_TooManyDistributionsWithFunctionAssociationsRes(parsedOutput, context);
    case "TooManyDistributionsWithLambdaAssociations":
    case "com.amazonaws.cloudfront#TooManyDistributionsWithLambdaAssociations":
      throw await de_TooManyDistributionsWithLambdaAssociationsRes(parsedOutput, context);
    case "TooManyDistributionsWithSingleFunctionARN":
    case "com.amazonaws.cloudfront#TooManyDistributionsWithSingleFunctionARN":
      throw await de_TooManyDistributionsWithSingleFunctionARNRes(parsedOutput, context);
    case "TooManyFunctionAssociations":
    case "com.amazonaws.cloudfront#TooManyFunctionAssociations":
      throw await de_TooManyFunctionAssociationsRes(parsedOutput, context);
    case "TooManyHeadersInForwardedValues":
    case "com.amazonaws.cloudfront#TooManyHeadersInForwardedValues":
      throw await de_TooManyHeadersInForwardedValuesRes(parsedOutput, context);
    case "TooManyKeyGroupsAssociatedToDistribution":
    case "com.amazonaws.cloudfront#TooManyKeyGroupsAssociatedToDistribution":
      throw await de_TooManyKeyGroupsAssociatedToDistributionRes(parsedOutput, context);
    case "TooManyLambdaFunctionAssociations":
    case "com.amazonaws.cloudfront#TooManyLambdaFunctionAssociations":
      throw await de_TooManyLambdaFunctionAssociationsRes(parsedOutput, context);
    case "TooManyOriginCustomHeaders":
    case "com.amazonaws.cloudfront#TooManyOriginCustomHeaders":
      throw await de_TooManyOriginCustomHeadersRes(parsedOutput, context);
    case "TooManyOriginGroupsPerDistribution":
    case "com.amazonaws.cloudfront#TooManyOriginGroupsPerDistribution":
      throw await de_TooManyOriginGroupsPerDistributionRes(parsedOutput, context);
    case "TooManyOrigins":
    case "com.amazonaws.cloudfront#TooManyOrigins":
      throw await de_TooManyOriginsRes(parsedOutput, context);
    case "TooManyQueryStringParameters":
    case "com.amazonaws.cloudfront#TooManyQueryStringParameters":
      throw await de_TooManyQueryStringParametersRes(parsedOutput, context);
    case "TooManyTrustedSigners":
    case "com.amazonaws.cloudfront#TooManyTrustedSigners":
      throw await de_TooManyTrustedSignersRes(parsedOutput, context);
    case "TrustedKeyGroupDoesNotExist":
    case "com.amazonaws.cloudfront#TrustedKeyGroupDoesNotExist":
      throw await de_TrustedKeyGroupDoesNotExistRes(parsedOutput, context);
    case "TrustedSignerDoesNotExist":
    case "com.amazonaws.cloudfront#TrustedSignerDoesNotExist":
      throw await de_TrustedSignerDoesNotExistRes(parsedOutput, context);
    case "EntityAlreadyExists":
    case "com.amazonaws.cloudfront#EntityAlreadyExists":
      throw await de_EntityAlreadyExistsRes(parsedOutput, context);
    case "EntityLimitExceeded":
    case "com.amazonaws.cloudfront#EntityLimitExceeded":
      throw await de_EntityLimitExceededRes(parsedOutput, context);
    case "InvalidTagging":
    case "com.amazonaws.cloudfront#InvalidTagging":
      throw await de_InvalidTaggingRes(parsedOutput, context);
    case "UnsupportedOperation":
    case "com.amazonaws.cloudfront#UnsupportedOperation":
      throw await de_UnsupportedOperationRes(parsedOutput, context);
    case "CachePolicyAlreadyExists":
    case "com.amazonaws.cloudfront#CachePolicyAlreadyExists":
      throw await de_CachePolicyAlreadyExistsRes(parsedOutput, context);
    case "TooManyCachePolicies":
    case "com.amazonaws.cloudfront#TooManyCachePolicies":
      throw await de_TooManyCachePoliciesRes(parsedOutput, context);
    case "TooManyCookiesInCachePolicy":
    case "com.amazonaws.cloudfront#TooManyCookiesInCachePolicy":
      throw await de_TooManyCookiesInCachePolicyRes(parsedOutput, context);
    case "TooManyHeadersInCachePolicy":
    case "com.amazonaws.cloudfront#TooManyHeadersInCachePolicy":
      throw await de_TooManyHeadersInCachePolicyRes(parsedOutput, context);
    case "TooManyQueryStringsInCachePolicy":
    case "com.amazonaws.cloudfront#TooManyQueryStringsInCachePolicy":
      throw await de_TooManyQueryStringsInCachePolicyRes(parsedOutput, context);
    case "CloudFrontOriginAccessIdentityAlreadyExists":
    case "com.amazonaws.cloudfront#CloudFrontOriginAccessIdentityAlreadyExists":
      throw await de_CloudFrontOriginAccessIdentityAlreadyExistsRes(parsedOutput, context);
    case "TooManyCloudFrontOriginAccessIdentities":
    case "com.amazonaws.cloudfront#TooManyCloudFrontOriginAccessIdentities":
      throw await de_TooManyCloudFrontOriginAccessIdentitiesRes(parsedOutput, context);
    case "ContinuousDeploymentPolicyAlreadyExists":
    case "com.amazonaws.cloudfront#ContinuousDeploymentPolicyAlreadyExists":
      throw await de_ContinuousDeploymentPolicyAlreadyExistsRes(parsedOutput, context);
    case "StagingDistributionInUse":
    case "com.amazonaws.cloudfront#StagingDistributionInUse":
      throw await de_StagingDistributionInUseRes(parsedOutput, context);
    case "TooManyContinuousDeploymentPolicies":
    case "com.amazonaws.cloudfront#TooManyContinuousDeploymentPolicies":
      throw await de_TooManyContinuousDeploymentPoliciesRes(parsedOutput, context);
    case "ContinuousDeploymentPolicyInUse":
    case "com.amazonaws.cloudfront#ContinuousDeploymentPolicyInUse":
      throw await de_ContinuousDeploymentPolicyInUseRes(parsedOutput, context);
    case "IllegalOriginAccessConfiguration":
    case "com.amazonaws.cloudfront#IllegalOriginAccessConfiguration":
      throw await de_IllegalOriginAccessConfigurationRes(parsedOutput, context);
    case "InvalidDomainNameForOriginAccessControl":
    case "com.amazonaws.cloudfront#InvalidDomainNameForOriginAccessControl":
      throw await de_InvalidDomainNameForOriginAccessControlRes(parsedOutput, context);
    case "NoSuchContinuousDeploymentPolicy":
    case "com.amazonaws.cloudfront#NoSuchContinuousDeploymentPolicy":
      throw await de_NoSuchContinuousDeploymentPolicyRes(parsedOutput, context);
    case "InvalidAssociation":
    case "com.amazonaws.cloudfront#InvalidAssociation":
      throw await de_InvalidAssociationRes(parsedOutput, context);
    case "FieldLevelEncryptionConfigAlreadyExists":
    case "com.amazonaws.cloudfront#FieldLevelEncryptionConfigAlreadyExists":
      throw await de_FieldLevelEncryptionConfigAlreadyExistsRes(parsedOutput, context);
    case "NoSuchFieldLevelEncryptionProfile":
    case "com.amazonaws.cloudfront#NoSuchFieldLevelEncryptionProfile":
      throw await de_NoSuchFieldLevelEncryptionProfileRes(parsedOutput, context);
    case "QueryArgProfileEmpty":
    case "com.amazonaws.cloudfront#QueryArgProfileEmpty":
      throw await de_QueryArgProfileEmptyRes(parsedOutput, context);
    case "TooManyFieldLevelEncryptionConfigs":
    case "com.amazonaws.cloudfront#TooManyFieldLevelEncryptionConfigs":
      throw await de_TooManyFieldLevelEncryptionConfigsRes(parsedOutput, context);
    case "TooManyFieldLevelEncryptionContentTypeProfiles":
    case "com.amazonaws.cloudfront#TooManyFieldLevelEncryptionContentTypeProfiles":
      throw await de_TooManyFieldLevelEncryptionContentTypeProfilesRes(parsedOutput, context);
    case "TooManyFieldLevelEncryptionQueryArgProfiles":
    case "com.amazonaws.cloudfront#TooManyFieldLevelEncryptionQueryArgProfiles":
      throw await de_TooManyFieldLevelEncryptionQueryArgProfilesRes(parsedOutput, context);
    case "FieldLevelEncryptionProfileAlreadyExists":
    case "com.amazonaws.cloudfront#FieldLevelEncryptionProfileAlreadyExists":
      throw await de_FieldLevelEncryptionProfileAlreadyExistsRes(parsedOutput, context);
    case "FieldLevelEncryptionProfileSizeExceeded":
    case "com.amazonaws.cloudfront#FieldLevelEncryptionProfileSizeExceeded":
      throw await de_FieldLevelEncryptionProfileSizeExceededRes(parsedOutput, context);
    case "NoSuchPublicKey":
    case "com.amazonaws.cloudfront#NoSuchPublicKey":
      throw await de_NoSuchPublicKeyRes(parsedOutput, context);
    case "TooManyFieldLevelEncryptionEncryptionEntities":
    case "com.amazonaws.cloudfront#TooManyFieldLevelEncryptionEncryptionEntities":
      throw await de_TooManyFieldLevelEncryptionEncryptionEntitiesRes(parsedOutput, context);
    case "TooManyFieldLevelEncryptionFieldPatterns":
    case "com.amazonaws.cloudfront#TooManyFieldLevelEncryptionFieldPatterns":
      throw await de_TooManyFieldLevelEncryptionFieldPatternsRes(parsedOutput, context);
    case "TooManyFieldLevelEncryptionProfiles":
    case "com.amazonaws.cloudfront#TooManyFieldLevelEncryptionProfiles":
      throw await de_TooManyFieldLevelEncryptionProfilesRes(parsedOutput, context);
    case "FunctionAlreadyExists":
    case "com.amazonaws.cloudfront#FunctionAlreadyExists":
      throw await de_FunctionAlreadyExistsRes(parsedOutput, context);
    case "FunctionSizeLimitExceeded":
    case "com.amazonaws.cloudfront#FunctionSizeLimitExceeded":
      throw await de_FunctionSizeLimitExceededRes(parsedOutput, context);
    case "TooManyFunctions":
    case "com.amazonaws.cloudfront#TooManyFunctions":
      throw await de_TooManyFunctionsRes(parsedOutput, context);
    case "BatchTooLarge":
    case "com.amazonaws.cloudfront#BatchTooLarge":
      throw await de_BatchTooLargeRes(parsedOutput, context);
    case "TooManyInvalidationsInProgress":
    case "com.amazonaws.cloudfront#TooManyInvalidationsInProgress":
      throw await de_TooManyInvalidationsInProgressRes(parsedOutput, context);
    case "KeyGroupAlreadyExists":
    case "com.amazonaws.cloudfront#KeyGroupAlreadyExists":
      throw await de_KeyGroupAlreadyExistsRes(parsedOutput, context);
    case "TooManyKeyGroups":
    case "com.amazonaws.cloudfront#TooManyKeyGroups":
      throw await de_TooManyKeyGroupsRes(parsedOutput, context);
    case "TooManyPublicKeysInKeyGroup":
    case "com.amazonaws.cloudfront#TooManyPublicKeysInKeyGroup":
      throw await de_TooManyPublicKeysInKeyGroupRes(parsedOutput, context);
    case "EntitySizeLimitExceeded":
    case "com.amazonaws.cloudfront#EntitySizeLimitExceeded":
      throw await de_EntitySizeLimitExceededRes(parsedOutput, context);
    case "MonitoringSubscriptionAlreadyExists":
    case "com.amazonaws.cloudfront#MonitoringSubscriptionAlreadyExists":
      throw await de_MonitoringSubscriptionAlreadyExistsRes(parsedOutput, context);
    case "OriginAccessControlAlreadyExists":
    case "com.amazonaws.cloudfront#OriginAccessControlAlreadyExists":
      throw await de_OriginAccessControlAlreadyExistsRes(parsedOutput, context);
    case "TooManyOriginAccessControls":
    case "com.amazonaws.cloudfront#TooManyOriginAccessControls":
      throw await de_TooManyOriginAccessControlsRes(parsedOutput, context);
    case "OriginRequestPolicyAlreadyExists":
    case "com.amazonaws.cloudfront#OriginRequestPolicyAlreadyExists":
      throw await de_OriginRequestPolicyAlreadyExistsRes(parsedOutput, context);
    case "TooManyCookiesInOriginRequestPolicy":
    case "com.amazonaws.cloudfront#TooManyCookiesInOriginRequestPolicy":
      throw await de_TooManyCookiesInOriginRequestPolicyRes(parsedOutput, context);
    case "TooManyHeadersInOriginRequestPolicy":
    case "com.amazonaws.cloudfront#TooManyHeadersInOriginRequestPolicy":
      throw await de_TooManyHeadersInOriginRequestPolicyRes(parsedOutput, context);
    case "TooManyOriginRequestPolicies":
    case "com.amazonaws.cloudfront#TooManyOriginRequestPolicies":
      throw await de_TooManyOriginRequestPoliciesRes(parsedOutput, context);
    case "TooManyQueryStringsInOriginRequestPolicy":
    case "com.amazonaws.cloudfront#TooManyQueryStringsInOriginRequestPolicy":
      throw await de_TooManyQueryStringsInOriginRequestPolicyRes(parsedOutput, context);
    case "PublicKeyAlreadyExists":
    case "com.amazonaws.cloudfront#PublicKeyAlreadyExists":
      throw await de_PublicKeyAlreadyExistsRes(parsedOutput, context);
    case "TooManyPublicKeys":
    case "com.amazonaws.cloudfront#TooManyPublicKeys":
      throw await de_TooManyPublicKeysRes(parsedOutput, context);
    case "RealtimeLogConfigAlreadyExists":
    case "com.amazonaws.cloudfront#RealtimeLogConfigAlreadyExists":
      throw await de_RealtimeLogConfigAlreadyExistsRes(parsedOutput, context);
    case "TooManyRealtimeLogConfigs":
    case "com.amazonaws.cloudfront#TooManyRealtimeLogConfigs":
      throw await de_TooManyRealtimeLogConfigsRes(parsedOutput, context);
    case "ResponseHeadersPolicyAlreadyExists":
    case "com.amazonaws.cloudfront#ResponseHeadersPolicyAlreadyExists":
      throw await de_ResponseHeadersPolicyAlreadyExistsRes(parsedOutput, context);
    case "TooLongCSPInResponseHeadersPolicy":
    case "com.amazonaws.cloudfront#TooLongCSPInResponseHeadersPolicy":
      throw await de_TooLongCSPInResponseHeadersPolicyRes(parsedOutput, context);
    case "TooManyCustomHeadersInResponseHeadersPolicy":
    case "com.amazonaws.cloudfront#TooManyCustomHeadersInResponseHeadersPolicy":
      throw await de_TooManyCustomHeadersInResponseHeadersPolicyRes(parsedOutput, context);
    case "TooManyRemoveHeadersInResponseHeadersPolicy":
    case "com.amazonaws.cloudfront#TooManyRemoveHeadersInResponseHeadersPolicy":
      throw await de_TooManyRemoveHeadersInResponseHeadersPolicyRes(parsedOutput, context);
    case "TooManyResponseHeadersPolicies":
    case "com.amazonaws.cloudfront#TooManyResponseHeadersPolicies":
      throw await de_TooManyResponseHeadersPoliciesRes(parsedOutput, context);
    case "StreamingDistributionAlreadyExists":
    case "com.amazonaws.cloudfront#StreamingDistributionAlreadyExists":
      throw await de_StreamingDistributionAlreadyExistsRes(parsedOutput, context);
    case "TooManyStreamingDistributionCNAMEs":
    case "com.amazonaws.cloudfront#TooManyStreamingDistributionCNAMEs":
      throw await de_TooManyStreamingDistributionCNAMEsRes(parsedOutput, context);
    case "TooManyStreamingDistributions":
    case "com.amazonaws.cloudfront#TooManyStreamingDistributions":
      throw await de_TooManyStreamingDistributionsRes(parsedOutput, context);
    case "CannotDeleteEntityWhileInUse":
    case "com.amazonaws.cloudfront#CannotDeleteEntityWhileInUse":
      throw await de_CannotDeleteEntityWhileInUseRes(parsedOutput, context);
    case "IllegalDelete":
    case "com.amazonaws.cloudfront#IllegalDelete":
      throw await de_IllegalDeleteRes(parsedOutput, context);
    case "CachePolicyInUse":
    case "com.amazonaws.cloudfront#CachePolicyInUse":
      throw await de_CachePolicyInUseRes(parsedOutput, context);
    case "CloudFrontOriginAccessIdentityInUse":
    case "com.amazonaws.cloudfront#CloudFrontOriginAccessIdentityInUse":
      throw await de_CloudFrontOriginAccessIdentityInUseRes(parsedOutput, context);
    case "NoSuchCloudFrontOriginAccessIdentity":
    case "com.amazonaws.cloudfront#NoSuchCloudFrontOriginAccessIdentity":
      throw await de_NoSuchCloudFrontOriginAccessIdentityRes(parsedOutput, context);
    case "ResourceNotDisabled":
    case "com.amazonaws.cloudfront#ResourceNotDisabled":
      throw await de_ResourceNotDisabledRes(parsedOutput, context);
    case "DistributionNotDisabled":
    case "com.amazonaws.cloudfront#DistributionNotDisabled":
      throw await de_DistributionNotDisabledRes(parsedOutput, context);
    case "ResourceInUse":
    case "com.amazonaws.cloudfront#ResourceInUse":
      throw await de_ResourceInUseRes(parsedOutput, context);
    case "FieldLevelEncryptionConfigInUse":
    case "com.amazonaws.cloudfront#FieldLevelEncryptionConfigInUse":
      throw await de_FieldLevelEncryptionConfigInUseRes(parsedOutput, context);
    case "FieldLevelEncryptionProfileInUse":
    case "com.amazonaws.cloudfront#FieldLevelEncryptionProfileInUse":
      throw await de_FieldLevelEncryptionProfileInUseRes(parsedOutput, context);
    case "FunctionInUse":
    case "com.amazonaws.cloudfront#FunctionInUse":
      throw await de_FunctionInUseRes(parsedOutput, context);
    case "NoSuchFunctionExists":
    case "com.amazonaws.cloudfront#NoSuchFunctionExists":
      throw await de_NoSuchFunctionExistsRes(parsedOutput, context);
    case "NoSuchResource":
    case "com.amazonaws.cloudfront#NoSuchResource":
      throw await de_NoSuchResourceRes(parsedOutput, context);
    case "NoSuchMonitoringSubscription":
    case "com.amazonaws.cloudfront#NoSuchMonitoringSubscription":
      throw await de_NoSuchMonitoringSubscriptionRes(parsedOutput, context);
    case "NoSuchOriginAccessControl":
    case "com.amazonaws.cloudfront#NoSuchOriginAccessControl":
      throw await de_NoSuchOriginAccessControlRes(parsedOutput, context);
    case "OriginAccessControlInUse":
    case "com.amazonaws.cloudfront#OriginAccessControlInUse":
      throw await de_OriginAccessControlInUseRes(parsedOutput, context);
    case "OriginRequestPolicyInUse":
    case "com.amazonaws.cloudfront#OriginRequestPolicyInUse":
      throw await de_OriginRequestPolicyInUseRes(parsedOutput, context);
    case "PublicKeyInUse":
    case "com.amazonaws.cloudfront#PublicKeyInUse":
      throw await de_PublicKeyInUseRes(parsedOutput, context);
    case "RealtimeLogConfigInUse":
    case "com.amazonaws.cloudfront#RealtimeLogConfigInUse":
      throw await de_RealtimeLogConfigInUseRes(parsedOutput, context);
    case "ResponseHeadersPolicyInUse":
    case "com.amazonaws.cloudfront#ResponseHeadersPolicyInUse":
      throw await de_ResponseHeadersPolicyInUseRes(parsedOutput, context);
    case "NoSuchStreamingDistribution":
    case "com.amazonaws.cloudfront#NoSuchStreamingDistribution":
      throw await de_NoSuchStreamingDistributionRes(parsedOutput, context);
    case "StreamingDistributionNotDisabled":
    case "com.amazonaws.cloudfront#StreamingDistributionNotDisabled":
      throw await de_StreamingDistributionNotDisabledRes(parsedOutput, context);
    case "NoSuchInvalidation":
    case "com.amazonaws.cloudfront#NoSuchInvalidation":
      throw await de_NoSuchInvalidationRes(parsedOutput, context);
    case "TestFunctionFailed":
    case "com.amazonaws.cloudfront#TestFunctionFailed":
      throw await de_TestFunctionFailedRes(parsedOutput, context);
    case "CannotChangeImmutablePublicKeyFields":
    case "com.amazonaws.cloudfront#CannotChangeImmutablePublicKeyFields":
      throw await de_CannotChangeImmutablePublicKeyFieldsRes(parsedOutput, context);
    case "CannotUpdateEntityWhileInUse":
    case "com.amazonaws.cloudfront#CannotUpdateEntityWhileInUse":
      throw await de_CannotUpdateEntityWhileInUseRes(parsedOutput, context);
    default:
      const parsedBody = parsedOutput.body;
      return throwDefaultError({
        output,
        parsedBody: parsedBody.Error,
        errorCode
      });
  }
}, "de_CommandError");
var throwDefaultError = (0, import_smithy_client.withBaseException)(CloudFrontServiceException);
var de_AccessDeniedRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const contents = (0, import_smithy_client.map)({});
  const data = parsedOutput.body.Error;
  if (data[_Me] != null) {
    contents[_Me] = (0, import_smithy_client.expectString)(data[_Me]);
  }
  const exception = new AccessDenied({
    $metadata: deserializeMetadata(parsedOutput),
    ...contents
  });
  return (0, import_smithy_client.decorateServiceException)(exception, parsedOutput.body.Error);
}, "de_AccessDeniedRes");
var de_BatchTooLargeRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const contents = (0, import_smithy_client.map)({});
  const data = parsedOutput.body.Error;
  if (data[_Me] != null) {
    contents[_Me] = (0, import_smithy_client.expectString)(data[_Me]);
  }
  const exception = new BatchTooLarge({
    $metadata: deserializeMetadata(parsedOutput),
    ...contents
  });
  return (0, import_smithy_client.decorateServiceException)(exception, parsedOutput.body.Error);
}, "de_BatchTooLargeRes");
var de_CachePolicyAlreadyExistsRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const contents = (0, import_smithy_client.map)({});
  const data = parsedOutput.body.Error;
  if (data[_Me] != null) {
    contents[_Me] = (0, import_smithy_client.expectString)(data[_Me]);
  }
  const exception = new CachePolicyAlreadyExists({
    $metadata: deserializeMetadata(parsedOutput),
    ...contents
  });
  return (0, import_smithy_client.decorateServiceException)(exception, parsedOutput.body.Error);
}, "de_CachePolicyAlreadyExistsRes");
var de_CachePolicyInUseRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const contents = (0, import_smithy_client.map)({});
  const data = parsedOutput.body.Error;
  if (data[_Me] != null) {
    contents[_Me] = (0, import_smithy_client.expectString)(data[_Me]);
  }
  const exception = new CachePolicyInUse({
    $metadata: deserializeMetadata(parsedOutput),
    ...contents
  });
  return (0, import_smithy_client.decorateServiceException)(exception, parsedOutput.body.Error);
}, "de_CachePolicyInUseRes");
var de_CannotChangeImmutablePublicKeyFieldsRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const contents = (0, import_smithy_client.map)({});
  const data = parsedOutput.body.Error;
  if (data[_Me] != null) {
    contents[_Me] = (0, import_smithy_client.expectString)(data[_Me]);
  }
  const exception = new CannotChangeImmutablePublicKeyFields({
    $metadata: deserializeMetadata(parsedOutput),
    ...contents
  });
  return (0, import_smithy_client.decorateServiceException)(exception, parsedOutput.body.Error);
}, "de_CannotChangeImmutablePublicKeyFieldsRes");
var de_CannotDeleteEntityWhileInUseRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const contents = (0, import_smithy_client.map)({});
  const data = parsedOutput.body.Error;
  if (data[_Me] != null) {
    contents[_Me] = (0, import_smithy_client.expectString)(data[_Me]);
  }
  const exception = new CannotDeleteEntityWhileInUse({
    $metadata: deserializeMetadata(parsedOutput),
    ...contents
  });
  return (0, import_smithy_client.decorateServiceException)(exception, parsedOutput.body.Error);
}, "de_CannotDeleteEntityWhileInUseRes");
var de_CannotUpdateEntityWhileInUseRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const contents = (0, import_smithy_client.map)({});
  const data = parsedOutput.body.Error;
  if (data[_Me] != null) {
    contents[_Me] = (0, import_smithy_client.expectString)(data[_Me]);
  }
  const exception = new CannotUpdateEntityWhileInUse({
    $metadata: deserializeMetadata(parsedOutput),
    ...contents
  });
  return (0, import_smithy_client.decorateServiceException)(exception, parsedOutput.body.Error);
}, "de_CannotUpdateEntityWhileInUseRes");
var de_CloudFrontOriginAccessIdentityAlreadyExistsRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const contents = (0, import_smithy_client.map)({});
  const data = parsedOutput.body.Error;
  if (data[_Me] != null) {
    contents[_Me] = (0, import_smithy_client.expectString)(data[_Me]);
  }
  const exception = new CloudFrontOriginAccessIdentityAlreadyExists({
    $metadata: deserializeMetadata(parsedOutput),
    ...contents
  });
  return (0, import_smithy_client.decorateServiceException)(exception, parsedOutput.body.Error);
}, "de_CloudFrontOriginAccessIdentityAlreadyExistsRes");
var de_CloudFrontOriginAccessIdentityInUseRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const contents = (0, import_smithy_client.map)({});
  const data = parsedOutput.body.Error;
  if (data[_Me] != null) {
    contents[_Me] = (0, import_smithy_client.expectString)(data[_Me]);
  }
  const exception = new CloudFrontOriginAccessIdentityInUse({
    $metadata: deserializeMetadata(parsedOutput),
    ...contents
  });
  return (0, import_smithy_client.decorateServiceException)(exception, parsedOutput.body.Error);
}, "de_CloudFrontOriginAccessIdentityInUseRes");
var de_CNAMEAlreadyExistsRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const contents = (0, import_smithy_client.map)({});
  const data = parsedOutput.body.Error;
  if (data[_Me] != null) {
    contents[_Me] = (0, import_smithy_client.expectString)(data[_Me]);
  }
  const exception = new CNAMEAlreadyExists({
    $metadata: deserializeMetadata(parsedOutput),
    ...contents
  });
  return (0, import_smithy_client.decorateServiceException)(exception, parsedOutput.body.Error);
}, "de_CNAMEAlreadyExistsRes");
var de_ContinuousDeploymentPolicyAlreadyExistsRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const contents = (0, import_smithy_client.map)({});
  const data = parsedOutput.body.Error;
  if (data[_Me] != null) {
    contents[_Me] = (0, import_smithy_client.expectString)(data[_Me]);
  }
  const exception = new ContinuousDeploymentPolicyAlreadyExists({
    $metadata: deserializeMetadata(parsedOutput),
    ...contents
  });
  return (0, import_smithy_client.decorateServiceException)(exception, parsedOutput.body.Error);
}, "de_ContinuousDeploymentPolicyAlreadyExistsRes");
var de_ContinuousDeploymentPolicyInUseRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const contents = (0, import_smithy_client.map)({});
  const data = parsedOutput.body.Error;
  if (data[_Me] != null) {
    contents[_Me] = (0, import_smithy_client.expectString)(data[_Me]);
  }
  const exception = new ContinuousDeploymentPolicyInUse({
    $metadata: deserializeMetadata(parsedOutput),
    ...contents
  });
  return (0, import_smithy_client.decorateServiceException)(exception, parsedOutput.body.Error);
}, "de_ContinuousDeploymentPolicyInUseRes");
var de_DistributionAlreadyExistsRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const contents = (0, import_smithy_client.map)({});
  const data = parsedOutput.body.Error;
  if (data[_Me] != null) {
    contents[_Me] = (0, import_smithy_client.expectString)(data[_Me]);
  }
  const exception = new DistributionAlreadyExists({
    $metadata: deserializeMetadata(parsedOutput),
    ...contents
  });
  return (0, import_smithy_client.decorateServiceException)(exception, parsedOutput.body.Error);
}, "de_DistributionAlreadyExistsRes");
var de_DistributionNotDisabledRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const contents = (0, import_smithy_client.map)({});
  const data = parsedOutput.body.Error;
  if (data[_Me] != null) {
    contents[_Me] = (0, import_smithy_client.expectString)(data[_Me]);
  }
  const exception = new DistributionNotDisabled({
    $metadata: deserializeMetadata(parsedOutput),
    ...contents
  });
  return (0, import_smithy_client.decorateServiceException)(exception, parsedOutput.body.Error);
}, "de_DistributionNotDisabledRes");
var de_EntityAlreadyExistsRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const contents = (0, import_smithy_client.map)({});
  const data = parsedOutput.body.Error;
  if (data[_Me] != null) {
    contents[_Me] = (0, import_smithy_client.expectString)(data[_Me]);
  }
  const exception = new EntityAlreadyExists({
    $metadata: deserializeMetadata(parsedOutput),
    ...contents
  });
  return (0, import_smithy_client.decorateServiceException)(exception, parsedOutput.body.Error);
}, "de_EntityAlreadyExistsRes");
var de_EntityLimitExceededRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const contents = (0, import_smithy_client.map)({});
  const data = parsedOutput.body.Error;
  if (data[_Me] != null) {
    contents[_Me] = (0, import_smithy_client.expectString)(data[_Me]);
  }
  const exception = new EntityLimitExceeded({
    $metadata: deserializeMetadata(parsedOutput),
    ...contents
  });
  return (0, import_smithy_client.decorateServiceException)(exception, parsedOutput.body.Error);
}, "de_EntityLimitExceededRes");
var de_EntityNotFoundRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const contents = (0, import_smithy_client.map)({});
  const data = parsedOutput.body.Error;
  if (data[_Me] != null) {
    contents[_Me] = (0, import_smithy_client.expectString)(data[_Me]);
  }
  const exception = new EntityNotFound({
    $metadata: deserializeMetadata(parsedOutput),
    ...contents
  });
  return (0, import_smithy_client.decorateServiceException)(exception, parsedOutput.body.Error);
}, "de_EntityNotFoundRes");
var de_EntitySizeLimitExceededRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const contents = (0, import_smithy_client.map)({});
  const data = parsedOutput.body.Error;
  if (data[_Me] != null) {
    contents[_Me] = (0, import_smithy_client.expectString)(data[_Me]);
  }
  const exception = new EntitySizeLimitExceeded({
    $metadata: deserializeMetadata(parsedOutput),
    ...contents
  });
  return (0, import_smithy_client.decorateServiceException)(exception, parsedOutput.body.Error);
}, "de_EntitySizeLimitExceededRes");
var de_FieldLevelEncryptionConfigAlreadyExistsRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const contents = (0, import_smithy_client.map)({});
  const data = parsedOutput.body.Error;
  if (data[_Me] != null) {
    contents[_Me] = (0, import_smithy_client.expectString)(data[_Me]);
  }
  const exception = new FieldLevelEncryptionConfigAlreadyExists({
    $metadata: deserializeMetadata(parsedOutput),
    ...contents
  });
  return (0, import_smithy_client.decorateServiceException)(exception, parsedOutput.body.Error);
}, "de_FieldLevelEncryptionConfigAlreadyExistsRes");
var de_FieldLevelEncryptionConfigInUseRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const contents = (0, import_smithy_client.map)({});
  const data = parsedOutput.body.Error;
  if (data[_Me] != null) {
    contents[_Me] = (0, import_smithy_client.expectString)(data[_Me]);
  }
  const exception = new FieldLevelEncryptionConfigInUse({
    $metadata: deserializeMetadata(parsedOutput),
    ...contents
  });
  return (0, import_smithy_client.decorateServiceException)(exception, parsedOutput.body.Error);
}, "de_FieldLevelEncryptionConfigInUseRes");
var de_FieldLevelEncryptionProfileAlreadyExistsRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const contents = (0, import_smithy_client.map)({});
  const data = parsedOutput.body.Error;
  if (data[_Me] != null) {
    contents[_Me] = (0, import_smithy_client.expectString)(data[_Me]);
  }
  const exception = new FieldLevelEncryptionProfileAlreadyExists({
    $metadata: deserializeMetadata(parsedOutput),
    ...contents
  });
  return (0, import_smithy_client.decorateServiceException)(exception, parsedOutput.body.Error);
}, "de_FieldLevelEncryptionProfileAlreadyExistsRes");
var de_FieldLevelEncryptionProfileInUseRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const contents = (0, import_smithy_client.map)({});
  const data = parsedOutput.body.Error;
  if (data[_Me] != null) {
    contents[_Me] = (0, import_smithy_client.expectString)(data[_Me]);
  }
  const exception = new FieldLevelEncryptionProfileInUse({
    $metadata: deserializeMetadata(parsedOutput),
    ...contents
  });
  return (0, import_smithy_client.decorateServiceException)(exception, parsedOutput.body.Error);
}, "de_FieldLevelEncryptionProfileInUseRes");
var de_FieldLevelEncryptionProfileSizeExceededRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const contents = (0, import_smithy_client.map)({});
  const data = parsedOutput.body.Error;
  if (data[_Me] != null) {
    contents[_Me] = (0, import_smithy_client.expectString)(data[_Me]);
  }
  const exception = new FieldLevelEncryptionProfileSizeExceeded({
    $metadata: deserializeMetadata(parsedOutput),
    ...contents
  });
  return (0, import_smithy_client.decorateServiceException)(exception, parsedOutput.body.Error);
}, "de_FieldLevelEncryptionProfileSizeExceededRes");
var de_FunctionAlreadyExistsRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const contents = (0, import_smithy_client.map)({});
  const data = parsedOutput.body.Error;
  if (data[_Me] != null) {
    contents[_Me] = (0, import_smithy_client.expectString)(data[_Me]);
  }
  const exception = new FunctionAlreadyExists({
    $metadata: deserializeMetadata(parsedOutput),
    ...contents
  });
  return (0, import_smithy_client.decorateServiceException)(exception, parsedOutput.body.Error);
}, "de_FunctionAlreadyExistsRes");
var de_FunctionInUseRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const contents = (0, import_smithy_client.map)({});
  const data = parsedOutput.body.Error;
  if (data[_Me] != null) {
    contents[_Me] = (0, import_smithy_client.expectString)(data[_Me]);
  }
  const exception = new FunctionInUse({
    $metadata: deserializeMetadata(parsedOutput),
    ...contents
  });
  return (0, import_smithy_client.decorateServiceException)(exception, parsedOutput.body.Error);
}, "de_FunctionInUseRes");
var de_FunctionSizeLimitExceededRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const contents = (0, import_smithy_client.map)({});
  const data = parsedOutput.body.Error;
  if (data[_Me] != null) {
    contents[_Me] = (0, import_smithy_client.expectString)(data[_Me]);
  }
  const exception = new FunctionSizeLimitExceeded({
    $metadata: deserializeMetadata(parsedOutput),
    ...contents
  });
  return (0, import_smithy_client.decorateServiceException)(exception, parsedOutput.body.Error);
}, "de_FunctionSizeLimitExceededRes");
var de_IllegalDeleteRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const contents = (0, import_smithy_client.map)({});
  const data = parsedOutput.body.Error;
  if (data[_Me] != null) {
    contents[_Me] = (0, import_smithy_client.expectString)(data[_Me]);
  }
  const exception = new IllegalDelete({
    $metadata: deserializeMetadata(parsedOutput),
    ...contents
  });
  return (0, import_smithy_client.decorateServiceException)(exception, parsedOutput.body.Error);
}, "de_IllegalDeleteRes");
var de_IllegalFieldLevelEncryptionConfigAssociationWithCacheBehaviorRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const contents = (0, import_smithy_client.map)({});
  const data = parsedOutput.body.Error;
  if (data[_Me] != null) {
    contents[_Me] = (0, import_smithy_client.expectString)(data[_Me]);
  }
  const exception = new IllegalFieldLevelEncryptionConfigAssociationWithCacheBehavior({
    $metadata: deserializeMetadata(parsedOutput),
    ...contents
  });
  return (0, import_smithy_client.decorateServiceException)(exception, parsedOutput.body.Error);
}, "de_IllegalFieldLevelEncryptionConfigAssociationWithCacheBehaviorRes");
var de_IllegalOriginAccessConfigurationRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const contents = (0, import_smithy_client.map)({});
  const data = parsedOutput.body.Error;
  if (data[_Me] != null) {
    contents[_Me] = (0, import_smithy_client.expectString)(data[_Me]);
  }
  const exception = new IllegalOriginAccessConfiguration({
    $metadata: deserializeMetadata(parsedOutput),
    ...contents
  });
  return (0, import_smithy_client.decorateServiceException)(exception, parsedOutput.body.Error);
}, "de_IllegalOriginAccessConfigurationRes");
var de_IllegalUpdateRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const contents = (0, import_smithy_client.map)({});
  const data = parsedOutput.body.Error;
  if (data[_Me] != null) {
    contents[_Me] = (0, import_smithy_client.expectString)(data[_Me]);
  }
  const exception = new IllegalUpdate({
    $metadata: deserializeMetadata(parsedOutput),
    ...contents
  });
  return (0, import_smithy_client.decorateServiceException)(exception, parsedOutput.body.Error);
}, "de_IllegalUpdateRes");
var de_InconsistentQuantitiesRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const contents = (0, import_smithy_client.map)({});
  const data = parsedOutput.body.Error;
  if (data[_Me] != null) {
    contents[_Me] = (0, import_smithy_client.expectString)(data[_Me]);
  }
  const exception = new InconsistentQuantities({
    $metadata: deserializeMetadata(parsedOutput),
    ...contents
  });
  return (0, import_smithy_client.decorateServiceException)(exception, parsedOutput.body.Error);
}, "de_InconsistentQuantitiesRes");
var de_InvalidArgumentRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const contents = (0, import_smithy_client.map)({});
  const data = parsedOutput.body.Error;
  if (data[_Me] != null) {
    contents[_Me] = (0, import_smithy_client.expectString)(data[_Me]);
  }
  const exception = new InvalidArgument({
    $metadata: deserializeMetadata(parsedOutput),
    ...contents
  });
  return (0, import_smithy_client.decorateServiceException)(exception, parsedOutput.body.Error);
}, "de_InvalidArgumentRes");
var de_InvalidAssociationRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const contents = (0, import_smithy_client.map)({});
  const data = parsedOutput.body.Error;
  if (data[_Me] != null) {
    contents[_Me] = (0, import_smithy_client.expectString)(data[_Me]);
  }
  const exception = new InvalidAssociation({
    $metadata: deserializeMetadata(parsedOutput),
    ...contents
  });
  return (0, import_smithy_client.decorateServiceException)(exception, parsedOutput.body.Error);
}, "de_InvalidAssociationRes");
var de_InvalidDefaultRootObjectRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const contents = (0, import_smithy_client.map)({});
  const data = parsedOutput.body.Error;
  if (data[_Me] != null) {
    contents[_Me] = (0, import_smithy_client.expectString)(data[_Me]);
  }
  const exception = new InvalidDefaultRootObject({
    $metadata: deserializeMetadata(parsedOutput),
    ...contents
  });
  return (0, import_smithy_client.decorateServiceException)(exception, parsedOutput.body.Error);
}, "de_InvalidDefaultRootObjectRes");
var de_InvalidDomainNameForOriginAccessControlRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const contents = (0, import_smithy_client.map)({});
  const data = parsedOutput.body.Error;
  if (data[_Me] != null) {
    contents[_Me] = (0, import_smithy_client.expectString)(data[_Me]);
  }
  const exception = new InvalidDomainNameForOriginAccessControl({
    $metadata: deserializeMetadata(parsedOutput),
    ...contents
  });
  return (0, import_smithy_client.decorateServiceException)(exception, parsedOutput.body.Error);
}, "de_InvalidDomainNameForOriginAccessControlRes");
var de_InvalidErrorCodeRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const contents = (0, import_smithy_client.map)({});
  const data = parsedOutput.body.Error;
  if (data[_Me] != null) {
    contents[_Me] = (0, import_smithy_client.expectString)(data[_Me]);
  }
  const exception = new InvalidErrorCode({
    $metadata: deserializeMetadata(parsedOutput),
    ...contents
  });
  return (0, import_smithy_client.decorateServiceException)(exception, parsedOutput.body.Error);
}, "de_InvalidErrorCodeRes");
var de_InvalidForwardCookiesRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const contents = (0, import_smithy_client.map)({});
  const data = parsedOutput.body.Error;
  if (data[_Me] != null) {
    contents[_Me] = (0, import_smithy_client.expectString)(data[_Me]);
  }
  const exception = new InvalidForwardCookies({
    $metadata: deserializeMetadata(parsedOutput),
    ...contents
  });
  return (0, import_smithy_client.decorateServiceException)(exception, parsedOutput.body.Error);
}, "de_InvalidForwardCookiesRes");
var de_InvalidFunctionAssociationRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const contents = (0, import_smithy_client.map)({});
  const data = parsedOutput.body.Error;
  if (data[_Me] != null) {
    contents[_Me] = (0, import_smithy_client.expectString)(data[_Me]);
  }
  const exception = new InvalidFunctionAssociation({
    $metadata: deserializeMetadata(parsedOutput),
    ...contents
  });
  return (0, import_smithy_client.decorateServiceException)(exception, parsedOutput.body.Error);
}, "de_InvalidFunctionAssociationRes");
var de_InvalidGeoRestrictionParameterRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const contents = (0, import_smithy_client.map)({});
  const data = parsedOutput.body.Error;
  if (data[_Me] != null) {
    contents[_Me] = (0, import_smithy_client.expectString)(data[_Me]);
  }
  const exception = new InvalidGeoRestrictionParameter({
    $metadata: deserializeMetadata(parsedOutput),
    ...contents
  });
  return (0, import_smithy_client.decorateServiceException)(exception, parsedOutput.body.Error);
}, "de_InvalidGeoRestrictionParameterRes");
var de_InvalidHeadersForS3OriginRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const contents = (0, import_smithy_client.map)({});
  const data = parsedOutput.body.Error;
  if (data[_Me] != null) {
    contents[_Me] = (0, import_smithy_client.expectString)(data[_Me]);
  }
  const exception = new InvalidHeadersForS3Origin({
    $metadata: deserializeMetadata(parsedOutput),
    ...contents
  });
  return (0, import_smithy_client.decorateServiceException)(exception, parsedOutput.body.Error);
}, "de_InvalidHeadersForS3OriginRes");
var de_InvalidIfMatchVersionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const contents = (0, import_smithy_client.map)({});
  const data = parsedOutput.body.Error;
  if (data[_Me] != null) {
    contents[_Me] = (0, import_smithy_client.expectString)(data[_Me]);
  }
  const exception = new InvalidIfMatchVersion({
    $metadata: deserializeMetadata(parsedOutput),
    ...contents
  });
  return (0, import_smithy_client.decorateServiceException)(exception, parsedOutput.body.Error);
}, "de_InvalidIfMatchVersionRes");
var de_InvalidLambdaFunctionAssociationRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const contents = (0, import_smithy_client.map)({});
  const data = parsedOutput.body.Error;
  if (data[_Me] != null) {
    contents[_Me] = (0, import_smithy_client.expectString)(data[_Me]);
  }
  const exception = new InvalidLambdaFunctionAssociation({
    $metadata: deserializeMetadata(parsedOutput),
    ...contents
  });
  return (0, import_smithy_client.decorateServiceException)(exception, parsedOutput.body.Error);
}, "de_InvalidLambdaFunctionAssociationRes");
var de_InvalidLocationCodeRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const contents = (0, import_smithy_client.map)({});
  const data = parsedOutput.body.Error;
  if (data[_Me] != null) {
    contents[_Me] = (0, import_smithy_client.expectString)(data[_Me]);
  }
  const exception = new InvalidLocationCode({
    $metadata: deserializeMetadata(parsedOutput),
    ...contents
  });
  return (0, import_smithy_client.decorateServiceException)(exception, parsedOutput.body.Error);
}, "de_InvalidLocationCodeRes");
var de_InvalidMinimumProtocolVersionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const contents = (0, import_smithy_client.map)({});
  const data = parsedOutput.body.Error;
  if (data[_Me] != null) {
    contents[_Me] = (0, import_smithy_client.expectString)(data[_Me]);
  }
  const exception = new InvalidMinimumProtocolVersion({
    $metadata: deserializeMetadata(parsedOutput),
    ...contents
  });
  return (0, import_smithy_client.decorateServiceException)(exception, parsedOutput.body.Error);
}, "de_InvalidMinimumProtocolVersionRes");
var de_InvalidOriginRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const contents = (0, import_smithy_client.map)({});
  const data = parsedOutput.body.Error;
  if (data[_Me] != null) {
    contents[_Me] = (0, import_smithy_client.expectString)(data[_Me]);
  }
  const exception = new InvalidOrigin({
    $metadata: deserializeMetadata(parsedOutput),
    ...contents
  });
  return (0, import_smithy_client.decorateServiceException)(exception, parsedOutput.body.Error);
}, "de_InvalidOriginRes");
var de_InvalidOriginAccessControlRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const contents = (0, import_smithy_client.map)({});
  const data = parsedOutput.body.Error;
  if (data[_Me] != null) {
    contents[_Me] = (0, import_smithy_client.expectString)(data[_Me]);
  }
  const exception = new InvalidOriginAccessControl({
    $metadata: deserializeMetadata(parsedOutput),
    ...contents
  });
  return (0, import_smithy_client.decorateServiceException)(exception, parsedOutput.body.Error);
}, "de_InvalidOriginAccessControlRes");
var de_InvalidOriginAccessIdentityRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const contents = (0, import_smithy_client.map)({});
  const data = parsedOutput.body.Error;
  if (data[_Me] != null) {
    contents[_Me] = (0, import_smithy_client.expectString)(data[_Me]);
  }
  const exception = new InvalidOriginAccessIdentity({
    $metadata: deserializeMetadata(parsedOutput),
    ...contents
  });
  return (0, import_smithy_client.decorateServiceException)(exception, parsedOutput.body.Error);
}, "de_InvalidOriginAccessIdentityRes");
var de_InvalidOriginKeepaliveTimeoutRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const contents = (0, import_smithy_client.map)({});
  const data = parsedOutput.body.Error;
  if (data[_Me] != null) {
    contents[_Me] = (0, import_smithy_client.expectString)(data[_Me]);
  }
  const exception = new InvalidOriginKeepaliveTimeout({
    $metadata: deserializeMetadata(parsedOutput),
    ...contents
  });
  return (0, import_smithy_client.decorateServiceException)(exception, parsedOutput.body.Error);
}, "de_InvalidOriginKeepaliveTimeoutRes");
var de_InvalidOriginReadTimeoutRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const contents = (0, import_smithy_client.map)({});
  const data = parsedOutput.body.Error;
  if (data[_Me] != null) {
    contents[_Me] = (0, import_smithy_client.expectString)(data[_Me]);
  }
  const exception = new InvalidOriginReadTimeout({
    $metadata: deserializeMetadata(parsedOutput),
    ...contents
  });
  return (0, import_smithy_client.decorateServiceException)(exception, parsedOutput.body.Error);
}, "de_InvalidOriginReadTimeoutRes");
var de_InvalidProtocolSettingsRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const contents = (0, import_smithy_client.map)({});
  const data = parsedOutput.body.Error;
  if (data[_Me] != null) {
    contents[_Me] = (0, import_smithy_client.expectString)(data[_Me]);
  }
  const exception = new InvalidProtocolSettings({
    $metadata: deserializeMetadata(parsedOutput),
    ...contents
  });
  return (0, import_smithy_client.decorateServiceException)(exception, parsedOutput.body.Error);
}, "de_InvalidProtocolSettingsRes");
var de_InvalidQueryStringParametersRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const contents = (0, import_smithy_client.map)({});
  const data = parsedOutput.body.Error;
  if (data[_Me] != null) {
    contents[_Me] = (0, import_smithy_client.expectString)(data[_Me]);
  }
  const exception = new InvalidQueryStringParameters({
    $metadata: deserializeMetadata(parsedOutput),
    ...contents
  });
  return (0, import_smithy_client.decorateServiceException)(exception, parsedOutput.body.Error);
}, "de_InvalidQueryStringParametersRes");
var de_InvalidRelativePathRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const contents = (0, import_smithy_client.map)({});
  const data = parsedOutput.body.Error;
  if (data[_Me] != null) {
    contents[_Me] = (0, import_smithy_client.expectString)(data[_Me]);
  }
  const exception = new InvalidRelativePath({
    $metadata: deserializeMetadata(parsedOutput),
    ...contents
  });
  return (0, import_smithy_client.decorateServiceException)(exception, parsedOutput.body.Error);
}, "de_InvalidRelativePathRes");
var de_InvalidRequiredProtocolRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const contents = (0, import_smithy_client.map)({});
  const data = parsedOutput.body.Error;
  if (data[_Me] != null) {
    contents[_Me] = (0, import_smithy_client.expectString)(data[_Me]);
  }
  const exception = new InvalidRequiredProtocol({
    $metadata: deserializeMetadata(parsedOutput),
    ...contents
  });
  return (0, import_smithy_client.decorateServiceException)(exception, parsedOutput.body.Error);
}, "de_InvalidRequiredProtocolRes");
var de_InvalidResponseCodeRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const contents = (0, import_smithy_client.map)({});
  const data = parsedOutput.body.Error;
  if (data[_Me] != null) {
    contents[_Me] = (0, import_smithy_client.expectString)(data[_Me]);
  }
  const exception = new InvalidResponseCode({
    $metadata: deserializeMetadata(parsedOutput),
    ...contents
  });
  return (0, import_smithy_client.decorateServiceException)(exception, parsedOutput.body.Error);
}, "de_InvalidResponseCodeRes");
var de_InvalidTaggingRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const contents = (0, import_smithy_client.map)({});
  const data = parsedOutput.body.Error;
  if (data[_Me] != null) {
    contents[_Me] = (0, import_smithy_client.expectString)(data[_Me]);
  }
  const exception = new InvalidTagging({
    $metadata: deserializeMetadata(parsedOutput),
    ...contents
  });
  return (0, import_smithy_client.decorateServiceException)(exception, parsedOutput.body.Error);
}, "de_InvalidTaggingRes");
var de_InvalidTTLOrderRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const contents = (0, import_smithy_client.map)({});
  const data = parsedOutput.body.Error;
  if (data[_Me] != null) {
    contents[_Me] = (0, import_smithy_client.expectString)(data[_Me]);
  }
  const exception = new InvalidTTLOrder({
    $metadata: deserializeMetadata(parsedOutput),
    ...contents
  });
  return (0, import_smithy_client.decorateServiceException)(exception, parsedOutput.body.Error);
}, "de_InvalidTTLOrderRes");
var de_InvalidViewerCertificateRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const contents = (0, import_smithy_client.map)({});
  const data = parsedOutput.body.Error;
  if (data[_Me] != null) {
    contents[_Me] = (0, import_smithy_client.expectString)(data[_Me]);
  }
  const exception = new InvalidViewerCertificate({
    $metadata: deserializeMetadata(parsedOutput),
    ...contents
  });
  return (0, import_smithy_client.decorateServiceException)(exception, parsedOutput.body.Error);
}, "de_InvalidViewerCertificateRes");
var de_InvalidWebACLIdRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const contents = (0, import_smithy_client.map)({});
  const data = parsedOutput.body.Error;
  if (data[_Me] != null) {
    contents[_Me] = (0, import_smithy_client.expectString)(data[_Me]);
  }
  const exception = new InvalidWebACLId({
    $metadata: deserializeMetadata(parsedOutput),
    ...contents
  });
  return (0, import_smithy_client.decorateServiceException)(exception, parsedOutput.body.Error);
}, "de_InvalidWebACLIdRes");
var de_KeyGroupAlreadyExistsRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const contents = (0, import_smithy_client.map)({});
  const data = parsedOutput.body.Error;
  if (data[_Me] != null) {
    contents[_Me] = (0, import_smithy_client.expectString)(data[_Me]);
  }
  const exception = new KeyGroupAlreadyExists({
    $metadata: deserializeMetadata(parsedOutput),
    ...contents
  });
  return (0, import_smithy_client.decorateServiceException)(exception, parsedOutput.body.Error);
}, "de_KeyGroupAlreadyExistsRes");
var de_MissingBodyRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const contents = (0, import_smithy_client.map)({});
  const data = parsedOutput.body.Error;
  if (data[_Me] != null) {
    contents[_Me] = (0, import_smithy_client.expectString)(data[_Me]);
  }
  const exception = new MissingBody({
    $metadata: deserializeMetadata(parsedOutput),
    ...contents
  });
  return (0, import_smithy_client.decorateServiceException)(exception, parsedOutput.body.Error);
}, "de_MissingBodyRes");
var de_MonitoringSubscriptionAlreadyExistsRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const contents = (0, import_smithy_client.map)({});
  const data = parsedOutput.body.Error;
  if (data[_Me] != null) {
    contents[_Me] = (0, import_smithy_client.expectString)(data[_Me]);
  }
  const exception = new MonitoringSubscriptionAlreadyExists({
    $metadata: deserializeMetadata(parsedOutput),
    ...contents
  });
  return (0, import_smithy_client.decorateServiceException)(exception, parsedOutput.body.Error);
}, "de_MonitoringSubscriptionAlreadyExistsRes");
var de_NoSuchCachePolicyRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const contents = (0, import_smithy_client.map)({});
  const data = parsedOutput.body.Error;
  if (data[_Me] != null) {
    contents[_Me] = (0, import_smithy_client.expectString)(data[_Me]);
  }
  const exception = new NoSuchCachePolicy({
    $metadata: deserializeMetadata(parsedOutput),
    ...contents
  });
  return (0, import_smithy_client.decorateServiceException)(exception, parsedOutput.body.Error);
}, "de_NoSuchCachePolicyRes");
var de_NoSuchCloudFrontOriginAccessIdentityRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const contents = (0, import_smithy_client.map)({});
  const data = parsedOutput.body.Error;
  if (data[_Me] != null) {
    contents[_Me] = (0, import_smithy_client.expectString)(data[_Me]);
  }
  const exception = new NoSuchCloudFrontOriginAccessIdentity({
    $metadata: deserializeMetadata(parsedOutput),
    ...contents
  });
  return (0, import_smithy_client.decorateServiceException)(exception, parsedOutput.body.Error);
}, "de_NoSuchCloudFrontOriginAccessIdentityRes");
var de_NoSuchContinuousDeploymentPolicyRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const contents = (0, import_smithy_client.map)({});
  const data = parsedOutput.body.Error;
  if (data[_Me] != null) {
    contents[_Me] = (0, import_smithy_client.expectString)(data[_Me]);
  }
  const exception = new NoSuchContinuousDeploymentPolicy({
    $metadata: deserializeMetadata(parsedOutput),
    ...contents
  });
  return (0, import_smithy_client.decorateServiceException)(exception, parsedOutput.body.Error);
}, "de_NoSuchContinuousDeploymentPolicyRes");
var de_NoSuchDistributionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const contents = (0, import_smithy_client.map)({});
  const data = parsedOutput.body.Error;
  if (data[_Me] != null) {
    contents[_Me] = (0, import_smithy_client.expectString)(data[_Me]);
  }
  const exception = new NoSuchDistribution({
    $metadata: deserializeMetadata(parsedOutput),
    ...contents
  });
  return (0, import_smithy_client.decorateServiceException)(exception, parsedOutput.body.Error);
}, "de_NoSuchDistributionRes");
var de_NoSuchFieldLevelEncryptionConfigRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const contents = (0, import_smithy_client.map)({});
  const data = parsedOutput.body.Error;
  if (data[_Me] != null) {
    contents[_Me] = (0, import_smithy_client.expectString)(data[_Me]);
  }
  const exception = new NoSuchFieldLevelEncryptionConfig({
    $metadata: deserializeMetadata(parsedOutput),
    ...contents
  });
  return (0, import_smithy_client.decorateServiceException)(exception, parsedOutput.body.Error);
}, "de_NoSuchFieldLevelEncryptionConfigRes");
var de_NoSuchFieldLevelEncryptionProfileRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const contents = (0, import_smithy_client.map)({});
  const data = parsedOutput.body.Error;
  if (data[_Me] != null) {
    contents[_Me] = (0, import_smithy_client.expectString)(data[_Me]);
  }
  const exception = new NoSuchFieldLevelEncryptionProfile({
    $metadata: deserializeMetadata(parsedOutput),
    ...contents
  });
  return (0, import_smithy_client.decorateServiceException)(exception, parsedOutput.body.Error);
}, "de_NoSuchFieldLevelEncryptionProfileRes");
var de_NoSuchFunctionExistsRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const contents = (0, import_smithy_client.map)({});
  const data = parsedOutput.body.Error;
  if (data[_Me] != null) {
    contents[_Me] = (0, import_smithy_client.expectString)(data[_Me]);
  }
  const exception = new NoSuchFunctionExists({
    $metadata: deserializeMetadata(parsedOutput),
    ...contents
  });
  return (0, import_smithy_client.decorateServiceException)(exception, parsedOutput.body.Error);
}, "de_NoSuchFunctionExistsRes");
var de_NoSuchInvalidationRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const contents = (0, import_smithy_client.map)({});
  const data = parsedOutput.body.Error;
  if (data[_Me] != null) {
    contents[_Me] = (0, import_smithy_client.expectString)(data[_Me]);
  }
  const exception = new NoSuchInvalidation({
    $metadata: deserializeMetadata(parsedOutput),
    ...contents
  });
  return (0, import_smithy_client.decorateServiceException)(exception, parsedOutput.body.Error);
}, "de_NoSuchInvalidationRes");
var de_NoSuchMonitoringSubscriptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const contents = (0, import_smithy_client.map)({});
  const data = parsedOutput.body.Error;
  if (data[_Me] != null) {
    contents[_Me] = (0, import_smithy_client.expectString)(data[_Me]);
  }
  const exception = new NoSuchMonitoringSubscription({
    $metadata: deserializeMetadata(parsedOutput),
    ...contents
  });
  return (0, import_smithy_client.decorateServiceException)(exception, parsedOutput.body.Error);
}, "de_NoSuchMonitoringSubscriptionRes");
var de_NoSuchOriginRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const contents = (0, import_smithy_client.map)({});
  const data = parsedOutput.body.Error;
  if (data[_Me] != null) {
    contents[_Me] = (0, import_smithy_client.expectString)(data[_Me]);
  }
  const exception = new NoSuchOrigin({
    $metadata: deserializeMetadata(parsedOutput),
    ...contents
  });
  return (0, import_smithy_client.decorateServiceException)(exception, parsedOutput.body.Error);
}, "de_NoSuchOriginRes");
var de_NoSuchOriginAccessControlRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const contents = (0, import_smithy_client.map)({});
  const data = parsedOutput.body.Error;
  if (data[_Me] != null) {
    contents[_Me] = (0, import_smithy_client.expectString)(data[_Me]);
  }
  const exception = new NoSuchOriginAccessControl({
    $metadata: deserializeMetadata(parsedOutput),
    ...contents
  });
  return (0, import_smithy_client.decorateServiceException)(exception, parsedOutput.body.Error);
}, "de_NoSuchOriginAccessControlRes");
var de_NoSuchOriginRequestPolicyRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const contents = (0, import_smithy_client.map)({});
  const data = parsedOutput.body.Error;
  if (data[_Me] != null) {
    contents[_Me] = (0, import_smithy_client.expectString)(data[_Me]);
  }
  const exception = new NoSuchOriginRequestPolicy({
    $metadata: deserializeMetadata(parsedOutput),
    ...contents
  });
  return (0, import_smithy_client.decorateServiceException)(exception, parsedOutput.body.Error);
}, "de_NoSuchOriginRequestPolicyRes");
var de_NoSuchPublicKeyRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const contents = (0, import_smithy_client.map)({});
  const data = parsedOutput.body.Error;
  if (data[_Me] != null) {
    contents[_Me] = (0, import_smithy_client.expectString)(data[_Me]);
  }
  const exception = new NoSuchPublicKey({
    $metadata: deserializeMetadata(parsedOutput),
    ...contents
  });
  return (0, import_smithy_client.decorateServiceException)(exception, parsedOutput.body.Error);
}, "de_NoSuchPublicKeyRes");
var de_NoSuchRealtimeLogConfigRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const contents = (0, import_smithy_client.map)({});
  const data = parsedOutput.body.Error;
  if (data[_Me] != null) {
    contents[_Me] = (0, import_smithy_client.expectString)(data[_Me]);
  }
  const exception = new NoSuchRealtimeLogConfig({
    $metadata: deserializeMetadata(parsedOutput),
    ...contents
  });
  return (0, import_smithy_client.decorateServiceException)(exception, parsedOutput.body.Error);
}, "de_NoSuchRealtimeLogConfigRes");
var de_NoSuchResourceRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const contents = (0, import_smithy_client.map)({});
  const data = parsedOutput.body.Error;
  if (data[_Me] != null) {
    contents[_Me] = (0, import_smithy_client.expectString)(data[_Me]);
  }
  const exception = new NoSuchResource({
    $metadata: deserializeMetadata(parsedOutput),
    ...contents
  });
  return (0, import_smithy_client.decorateServiceException)(exception, parsedOutput.body.Error);
}, "de_NoSuchResourceRes");
var de_NoSuchResponseHeadersPolicyRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const contents = (0, import_smithy_client.map)({});
  const data = parsedOutput.body.Error;
  if (data[_Me] != null) {
    contents[_Me] = (0, import_smithy_client.expectString)(data[_Me]);
  }
  const exception = new NoSuchResponseHeadersPolicy({
    $metadata: deserializeMetadata(parsedOutput),
    ...contents
  });
  return (0, import_smithy_client.decorateServiceException)(exception, parsedOutput.body.Error);
}, "de_NoSuchResponseHeadersPolicyRes");
var de_NoSuchStreamingDistributionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const contents = (0, import_smithy_client.map)({});
  const data = parsedOutput.body.Error;
  if (data[_Me] != null) {
    contents[_Me] = (0, import_smithy_client.expectString)(data[_Me]);
  }
  const exception = new NoSuchStreamingDistribution({
    $metadata: deserializeMetadata(parsedOutput),
    ...contents
  });
  return (0, import_smithy_client.decorateServiceException)(exception, parsedOutput.body.Error);
}, "de_NoSuchStreamingDistributionRes");
var de_OriginAccessControlAlreadyExistsRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const contents = (0, import_smithy_client.map)({});
  const data = parsedOutput.body.Error;
  if (data[_Me] != null) {
    contents[_Me] = (0, import_smithy_client.expectString)(data[_Me]);
  }
  const exception = new OriginAccessControlAlreadyExists({
    $metadata: deserializeMetadata(parsedOutput),
    ...contents
  });
  return (0, import_smithy_client.decorateServiceException)(exception, parsedOutput.body.Error);
}, "de_OriginAccessControlAlreadyExistsRes");
var de_OriginAccessControlInUseRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const contents = (0, import_smithy_client.map)({});
  const data = parsedOutput.body.Error;
  if (data[_Me] != null) {
    contents[_Me] = (0, import_smithy_client.expectString)(data[_Me]);
  }
  const exception = new OriginAccessControlInUse({
    $metadata: deserializeMetadata(parsedOutput),
    ...contents
  });
  return (0, import_smithy_client.decorateServiceException)(exception, parsedOutput.body.Error);
}, "de_OriginAccessControlInUseRes");
var de_OriginRequestPolicyAlreadyExistsRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const contents = (0, import_smithy_client.map)({});
  const data = parsedOutput.body.Error;
  if (data[_Me] != null) {
    contents[_Me] = (0, import_smithy_client.expectString)(data[_Me]);
  }
  const exception = new OriginRequestPolicyAlreadyExists({
    $metadata: deserializeMetadata(parsedOutput),
    ...contents
  });
  return (0, import_smithy_client.decorateServiceException)(exception, parsedOutput.body.Error);
}, "de_OriginRequestPolicyAlreadyExistsRes");
var de_OriginRequestPolicyInUseRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const contents = (0, import_smithy_client.map)({});
  const data = parsedOutput.body.Error;
  if (data[_Me] != null) {
    contents[_Me] = (0, import_smithy_client.expectString)(data[_Me]);
  }
  const exception = new OriginRequestPolicyInUse({
    $metadata: deserializeMetadata(parsedOutput),
    ...contents
  });
  return (0, import_smithy_client.decorateServiceException)(exception, parsedOutput.body.Error);
}, "de_OriginRequestPolicyInUseRes");
var de_PreconditionFailedRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const contents = (0, import_smithy_client.map)({});
  const data = parsedOutput.body.Error;
  if (data[_Me] != null) {
    contents[_Me] = (0, import_smithy_client.expectString)(data[_Me]);
  }
  const exception = new PreconditionFailed({
    $metadata: deserializeMetadata(parsedOutput),
    ...contents
  });
  return (0, import_smithy_client.decorateServiceException)(exception, parsedOutput.body.Error);
}, "de_PreconditionFailedRes");
var de_PublicKeyAlreadyExistsRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const contents = (0, import_smithy_client.map)({});
  const data = parsedOutput.body.Error;
  if (data[_Me] != null) {
    contents[_Me] = (0, import_smithy_client.expectString)(data[_Me]);
  }
  const exception = new PublicKeyAlreadyExists({
    $metadata: deserializeMetadata(parsedOutput),
    ...contents
  });
  return (0, import_smithy_client.decorateServiceException)(exception, parsedOutput.body.Error);
}, "de_PublicKeyAlreadyExistsRes");
var de_PublicKeyInUseRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const contents = (0, import_smithy_client.map)({});
  const data = parsedOutput.body.Error;
  if (data[_Me] != null) {
    contents[_Me] = (0, import_smithy_client.expectString)(data[_Me]);
  }
  const exception = new PublicKeyInUse({
    $metadata: deserializeMetadata(parsedOutput),
    ...contents
  });
  return (0, import_smithy_client.decorateServiceException)(exception, parsedOutput.body.Error);
}, "de_PublicKeyInUseRes");
var de_QueryArgProfileEmptyRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const contents = (0, import_smithy_client.map)({});
  const data = parsedOutput.body.Error;
  if (data[_Me] != null) {
    contents[_Me] = (0, import_smithy_client.expectString)(data[_Me]);
  }
  const exception = new QueryArgProfileEmpty({
    $metadata: deserializeMetadata(parsedOutput),
    ...contents
  });
  return (0, import_smithy_client.decorateServiceException)(exception, parsedOutput.body.Error);
}, "de_QueryArgProfileEmptyRes");
var de_RealtimeLogConfigAlreadyExistsRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const contents = (0, import_smithy_client.map)({});
  const data = parsedOutput.body.Error;
  if (data[_Me] != null) {
    contents[_Me] = (0, import_smithy_client.expectString)(data[_Me]);
  }
  const exception = new RealtimeLogConfigAlreadyExists({
    $metadata: deserializeMetadata(parsedOutput),
    ...contents
  });
  return (0, import_smithy_client.decorateServiceException)(exception, parsedOutput.body.Error);
}, "de_RealtimeLogConfigAlreadyExistsRes");
var de_RealtimeLogConfigInUseRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const contents = (0, import_smithy_client.map)({});
  const data = parsedOutput.body.Error;
  if (data[_Me] != null) {
    contents[_Me] = (0, import_smithy_client.expectString)(data[_Me]);
  }
  const exception = new RealtimeLogConfigInUse({
    $metadata: deserializeMetadata(parsedOutput),
    ...contents
  });
  return (0, import_smithy_client.decorateServiceException)(exception, parsedOutput.body.Error);
}, "de_RealtimeLogConfigInUseRes");
var de_RealtimeLogConfigOwnerMismatchRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const contents = (0, import_smithy_client.map)({});
  const data = parsedOutput.body.Error;
  if (data[_Me] != null) {
    contents[_Me] = (0, import_smithy_client.expectString)(data[_Me]);
  }
  const exception = new RealtimeLogConfigOwnerMismatch({
    $metadata: deserializeMetadata(parsedOutput),
    ...contents
  });
  return (0, import_smithy_client.decorateServiceException)(exception, parsedOutput.body.Error);
}, "de_RealtimeLogConfigOwnerMismatchRes");
var de_ResourceInUseRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const contents = (0, import_smithy_client.map)({});
  const data = parsedOutput.body.Error;
  if (data[_Me] != null) {
    contents[_Me] = (0, import_smithy_client.expectString)(data[_Me]);
  }
  const exception = new ResourceInUse({
    $metadata: deserializeMetadata(parsedOutput),
    ...contents
  });
  return (0, import_smithy_client.decorateServiceException)(exception, parsedOutput.body.Error);
}, "de_ResourceInUseRes");
var de_ResourceNotDisabledRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const contents = (0, import_smithy_client.map)({});
  const data = parsedOutput.body.Error;
  if (data[_Me] != null) {
    contents[_Me] = (0, import_smithy_client.expectString)(data[_Me]);
  }
  const exception = new ResourceNotDisabled({
    $metadata: deserializeMetadata(parsedOutput),
    ...contents
  });
  return (0, import_smithy_client.decorateServiceException)(exception, parsedOutput.body.Error);
}, "de_ResourceNotDisabledRes");
var de_ResponseHeadersPolicyAlreadyExistsRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const contents = (0, import_smithy_client.map)({});
  const data = parsedOutput.body.Error;
  if (data[_Me] != null) {
    contents[_Me] = (0, import_smithy_client.expectString)(data[_Me]);
  }
  const exception = new ResponseHeadersPolicyAlreadyExists({
    $metadata: deserializeMetadata(parsedOutput),
    ...contents
  });
  return (0, import_smithy_client.decorateServiceException)(exception, parsedOutput.body.Error);
}, "de_ResponseHeadersPolicyAlreadyExistsRes");
var de_ResponseHeadersPolicyInUseRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const contents = (0, import_smithy_client.map)({});
  const data = parsedOutput.body.Error;
  if (data[_Me] != null) {
    contents[_Me] = (0, import_smithy_client.expectString)(data[_Me]);
  }
  const exception = new ResponseHeadersPolicyInUse({
    $metadata: deserializeMetadata(parsedOutput),
    ...contents
  });
  return (0, import_smithy_client.decorateServiceException)(exception, parsedOutput.body.Error);
}, "de_ResponseHeadersPolicyInUseRes");
var de_StagingDistributionInUseRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const contents = (0, import_smithy_client.map)({});
  const data = parsedOutput.body.Error;
  if (data[_Me] != null) {
    contents[_Me] = (0, import_smithy_client.expectString)(data[_Me]);
  }
  const exception = new StagingDistributionInUse({
    $metadata: deserializeMetadata(parsedOutput),
    ...contents
  });
  return (0, import_smithy_client.decorateServiceException)(exception, parsedOutput.body.Error);
}, "de_StagingDistributionInUseRes");
var de_StreamingDistributionAlreadyExistsRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const contents = (0, import_smithy_client.map)({});
  const data = parsedOutput.body.Error;
  if (data[_Me] != null) {
    contents[_Me] = (0, import_smithy_client.expectString)(data[_Me]);
  }
  const exception = new StreamingDistributionAlreadyExists({
    $metadata: deserializeMetadata(parsedOutput),
    ...contents
  });
  return (0, import_smithy_client.decorateServiceException)(exception, parsedOutput.body.Error);
}, "de_StreamingDistributionAlreadyExistsRes");
var de_StreamingDistributionNotDisabledRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const contents = (0, import_smithy_client.map)({});
  const data = parsedOutput.body.Error;
  if (data[_Me] != null) {
    contents[_Me] = (0, import_smithy_client.expectString)(data[_Me]);
  }
  const exception = new StreamingDistributionNotDisabled({
    $metadata: deserializeMetadata(parsedOutput),
    ...contents
  });
  return (0, import_smithy_client.decorateServiceException)(exception, parsedOutput.body.Error);
}, "de_StreamingDistributionNotDisabledRes");
var de_TestFunctionFailedRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const contents = (0, import_smithy_client.map)({});
  const data = parsedOutput.body.Error;
  if (data[_Me] != null) {
    contents[_Me] = (0, import_smithy_client.expectString)(data[_Me]);
  }
  const exception = new TestFunctionFailed({
    $metadata: deserializeMetadata(parsedOutput),
    ...contents
  });
  return (0, import_smithy_client.decorateServiceException)(exception, parsedOutput.body.Error);
}, "de_TestFunctionFailedRes");
var de_TooLongCSPInResponseHeadersPolicyRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const contents = (0, import_smithy_client.map)({});
  const data = parsedOutput.body.Error;
  if (data[_Me] != null) {
    contents[_Me] = (0, import_smithy_client.expectString)(data[_Me]);
  }
  const exception = new TooLongCSPInResponseHeadersPolicy({
    $metadata: deserializeMetadata(parsedOutput),
    ...contents
  });
  return (0, import_smithy_client.decorateServiceException)(exception, parsedOutput.body.Error);
}, "de_TooLongCSPInResponseHeadersPolicyRes");
var de_TooManyCacheBehaviorsRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const contents = (0, import_smithy_client.map)({});
  const data = parsedOutput.body.Error;
  if (data[_Me] != null) {
    contents[_Me] = (0, import_smithy_client.expectString)(data[_Me]);
  }
  const exception = new TooManyCacheBehaviors({
    $metadata: deserializeMetadata(parsedOutput),
    ...contents
  });
  return (0, import_smithy_client.decorateServiceException)(exception, parsedOutput.body.Error);
}, "de_TooManyCacheBehaviorsRes");
var de_TooManyCachePoliciesRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const contents = (0, import_smithy_client.map)({});
  const data = parsedOutput.body.Error;
  if (data[_Me] != null) {
    contents[_Me] = (0, import_smithy_client.expectString)(data[_Me]);
  }
  const exception = new TooManyCachePolicies({
    $metadata: deserializeMetadata(parsedOutput),
    ...contents
  });
  return (0, import_smithy_client.decorateServiceException)(exception, parsedOutput.body.Error);
}, "de_TooManyCachePoliciesRes");
var de_TooManyCertificatesRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const contents = (0, import_smithy_client.map)({});
  const data = parsedOutput.body.Error;
  if (data[_Me] != null) {
    contents[_Me] = (0, import_smithy_client.expectString)(data[_Me]);
  }
  const exception = new TooManyCertificates({
    $metadata: deserializeMetadata(parsedOutput),
    ...contents
  });
  return (0, import_smithy_client.decorateServiceException)(exception, parsedOutput.body.Error);
}, "de_TooManyCertificatesRes");
var de_TooManyCloudFrontOriginAccessIdentitiesRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const contents = (0, import_smithy_client.map)({});
  const data = parsedOutput.body.Error;
  if (data[_Me] != null) {
    contents[_Me] = (0, import_smithy_client.expectString)(data[_Me]);
  }
  const exception = new TooManyCloudFrontOriginAccessIdentities({
    $metadata: deserializeMetadata(parsedOutput),
    ...contents
  });
  return (0, import_smithy_client.decorateServiceException)(exception, parsedOutput.body.Error);
}, "de_TooManyCloudFrontOriginAccessIdentitiesRes");
var de_TooManyContinuousDeploymentPoliciesRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const contents = (0, import_smithy_client.map)({});
  const data = parsedOutput.body.Error;
  if (data[_Me] != null) {
    contents[_Me] = (0, import_smithy_client.expectString)(data[_Me]);
  }
  const exception = new TooManyContinuousDeploymentPolicies({
    $metadata: deserializeMetadata(parsedOutput),
    ...contents
  });
  return (0, import_smithy_client.decorateServiceException)(exception, parsedOutput.body.Error);
}, "de_TooManyContinuousDeploymentPoliciesRes");
var de_TooManyCookieNamesInWhiteListRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const contents = (0, import_smithy_client.map)({});
  const data = parsedOutput.body.Error;
  if (data[_Me] != null) {
    contents[_Me] = (0, import_smithy_client.expectString)(data[_Me]);
  }
  const exception = new TooManyCookieNamesInWhiteList({
    $metadata: deserializeMetadata(parsedOutput),
    ...contents
  });
  return (0, import_smithy_client.decorateServiceException)(exception, parsedOutput.body.Error);
}, "de_TooManyCookieNamesInWhiteListRes");
var de_TooManyCookiesInCachePolicyRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const contents = (0, import_smithy_client.map)({});
  const data = parsedOutput.body.Error;
  if (data[_Me] != null) {
    contents[_Me] = (0, import_smithy_client.expectString)(data[_Me]);
  }
  const exception = new TooManyCookiesInCachePolicy({
    $metadata: deserializeMetadata(parsedOutput),
    ...contents
  });
  return (0, import_smithy_client.decorateServiceException)(exception, parsedOutput.body.Error);
}, "de_TooManyCookiesInCachePolicyRes");
var de_TooManyCookiesInOriginRequestPolicyRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const contents = (0, import_smithy_client.map)({});
  const data = parsedOutput.body.Error;
  if (data[_Me] != null) {
    contents[_Me] = (0, import_smithy_client.expectString)(data[_Me]);
  }
  const exception = new TooManyCookiesInOriginRequestPolicy({
    $metadata: deserializeMetadata(parsedOutput),
    ...contents
  });
  return (0, import_smithy_client.decorateServiceException)(exception, parsedOutput.body.Error);
}, "de_TooManyCookiesInOriginRequestPolicyRes");
var de_TooManyCustomHeadersInResponseHeadersPolicyRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const contents = (0, import_smithy_client.map)({});
  const data = parsedOutput.body.Error;
  if (data[_Me] != null) {
    contents[_Me] = (0, import_smithy_client.expectString)(data[_Me]);
  }
  const exception = new TooManyCustomHeadersInResponseHeadersPolicy({
    $metadata: deserializeMetadata(parsedOutput),
    ...contents
  });
  return (0, import_smithy_client.decorateServiceException)(exception, parsedOutput.body.Error);
}, "de_TooManyCustomHeadersInResponseHeadersPolicyRes");
var de_TooManyDistributionCNAMEsRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const contents = (0, import_smithy_client.map)({});
  const data = parsedOutput.body.Error;
  if (data[_Me] != null) {
    contents[_Me] = (0, import_smithy_client.expectString)(data[_Me]);
  }
  const exception = new TooManyDistributionCNAMEs({
    $metadata: deserializeMetadata(parsedOutput),
    ...contents
  });
  return (0, import_smithy_client.decorateServiceException)(exception, parsedOutput.body.Error);
}, "de_TooManyDistributionCNAMEsRes");
var de_TooManyDistributionsRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const contents = (0, import_smithy_client.map)({});
  const data = parsedOutput.body.Error;
  if (data[_Me] != null) {
    contents[_Me] = (0, import_smithy_client.expectString)(data[_Me]);
  }
  const exception = new TooManyDistributions({
    $metadata: deserializeMetadata(parsedOutput),
    ...contents
  });
  return (0, import_smithy_client.decorateServiceException)(exception, parsedOutput.body.Error);
}, "de_TooManyDistributionsRes");
var de_TooManyDistributionsAssociatedToCachePolicyRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const contents = (0, import_smithy_client.map)({});
  const data = parsedOutput.body.Error;
  if (data[_Me] != null) {
    contents[_Me] = (0, import_smithy_client.expectString)(data[_Me]);
  }
  const exception = new TooManyDistributionsAssociatedToCachePolicy({
    $metadata: deserializeMetadata(parsedOutput),
    ...contents
  });
  return (0, import_smithy_client.decorateServiceException)(exception, parsedOutput.body.Error);
}, "de_TooManyDistributionsAssociatedToCachePolicyRes");
var de_TooManyDistributionsAssociatedToFieldLevelEncryptionConfigRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const contents = (0, import_smithy_client.map)({});
  const data = parsedOutput.body.Error;
  if (data[_Me] != null) {
    contents[_Me] = (0, import_smithy_client.expectString)(data[_Me]);
  }
  const exception = new TooManyDistributionsAssociatedToFieldLevelEncryptionConfig({
    $metadata: deserializeMetadata(parsedOutput),
    ...contents
  });
  return (0, import_smithy_client.decorateServiceException)(exception, parsedOutput.body.Error);
}, "de_TooManyDistributionsAssociatedToFieldLevelEncryptionConfigRes");
var de_TooManyDistributionsAssociatedToKeyGroupRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const contents = (0, import_smithy_client.map)({});
  const data = parsedOutput.body.Error;
  if (data[_Me] != null) {
    contents[_Me] = (0, import_smithy_client.expectString)(data[_Me]);
  }
  const exception = new TooManyDistributionsAssociatedToKeyGroup({
    $metadata: deserializeMetadata(parsedOutput),
    ...contents
  });
  return (0, import_smithy_client.decorateServiceException)(exception, parsedOutput.body.Error);
}, "de_TooManyDistributionsAssociatedToKeyGroupRes");
var de_TooManyDistributionsAssociatedToOriginAccessControlRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const contents = (0, import_smithy_client.map)({});
  const data = parsedOutput.body.Error;
  if (data[_Me] != null) {
    contents[_Me] = (0, import_smithy_client.expectString)(data[_Me]);
  }
  const exception = new TooManyDistributionsAssociatedToOriginAccessControl({
    $metadata: deserializeMetadata(parsedOutput),
    ...contents
  });
  return (0, import_smithy_client.decorateServiceException)(exception, parsedOutput.body.Error);
}, "de_TooManyDistributionsAssociatedToOriginAccessControlRes");
var de_TooManyDistributionsAssociatedToOriginRequestPolicyRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const contents = (0, import_smithy_client.map)({});
  const data = parsedOutput.body.Error;
  if (data[_Me] != null) {
    contents[_Me] = (0, import_smithy_client.expectString)(data[_Me]);
  }
  const exception = new TooManyDistributionsAssociatedToOriginRequestPolicy({
    $metadata: deserializeMetadata(parsedOutput),
    ...contents
  });
  return (0, import_smithy_client.decorateServiceException)(exception, parsedOutput.body.Error);
}, "de_TooManyDistributionsAssociatedToOriginRequestPolicyRes");
var de_TooManyDistributionsAssociatedToResponseHeadersPolicyRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const contents = (0, import_smithy_client.map)({});
  const data = parsedOutput.body.Error;
  if (data[_Me] != null) {
    contents[_Me] = (0, import_smithy_client.expectString)(data[_Me]);
  }
  const exception = new TooManyDistributionsAssociatedToResponseHeadersPolicy({
    $metadata: deserializeMetadata(parsedOutput),
    ...contents
  });
  return (0, import_smithy_client.decorateServiceException)(exception, parsedOutput.body.Error);
}, "de_TooManyDistributionsAssociatedToResponseHeadersPolicyRes");
var de_TooManyDistributionsWithFunctionAssociationsRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const contents = (0, import_smithy_client.map)({});
  const data = parsedOutput.body.Error;
  if (data[_Me] != null) {
    contents[_Me] = (0, import_smithy_client.expectString)(data[_Me]);
  }
  const exception = new TooManyDistributionsWithFunctionAssociations({
    $metadata: deserializeMetadata(parsedOutput),
    ...contents
  });
  return (0, import_smithy_client.decorateServiceException)(exception, parsedOutput.body.Error);
}, "de_TooManyDistributionsWithFunctionAssociationsRes");
var de_TooManyDistributionsWithLambdaAssociationsRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const contents = (0, import_smithy_client.map)({});
  const data = parsedOutput.body.Error;
  if (data[_Me] != null) {
    contents[_Me] = (0, import_smithy_client.expectString)(data[_Me]);
  }
  const exception = new TooManyDistributionsWithLambdaAssociations({
    $metadata: deserializeMetadata(parsedOutput),
    ...contents
  });
  return (0, import_smithy_client.decorateServiceException)(exception, parsedOutput.body.Error);
}, "de_TooManyDistributionsWithLambdaAssociationsRes");
var de_TooManyDistributionsWithSingleFunctionARNRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const contents = (0, import_smithy_client.map)({});
  const data = parsedOutput.body.Error;
  if (data[_Me] != null) {
    contents[_Me] = (0, import_smithy_client.expectString)(data[_Me]);
  }
  const exception = new TooManyDistributionsWithSingleFunctionARN({
    $metadata: deserializeMetadata(parsedOutput),
    ...contents
  });
  return (0, import_smithy_client.decorateServiceException)(exception, parsedOutput.body.Error);
}, "de_TooManyDistributionsWithSingleFunctionARNRes");
var de_TooManyFieldLevelEncryptionConfigsRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const contents = (0, import_smithy_client.map)({});
  const data = parsedOutput.body.Error;
  if (data[_Me] != null) {
    contents[_Me] = (0, import_smithy_client.expectString)(data[_Me]);
  }
  const exception = new TooManyFieldLevelEncryptionConfigs({
    $metadata: deserializeMetadata(parsedOutput),
    ...contents
  });
  return (0, import_smithy_client.decorateServiceException)(exception, parsedOutput.body.Error);
}, "de_TooManyFieldLevelEncryptionConfigsRes");
var de_TooManyFieldLevelEncryptionContentTypeProfilesRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const contents = (0, import_smithy_client.map)({});
  const data = parsedOutput.body.Error;
  if (data[_Me] != null) {
    contents[_Me] = (0, import_smithy_client.expectString)(data[_Me]);
  }
  const exception = new TooManyFieldLevelEncryptionContentTypeProfiles({
    $metadata: deserializeMetadata(parsedOutput),
    ...contents
  });
  return (0, import_smithy_client.decorateServiceException)(exception, parsedOutput.body.Error);
}, "de_TooManyFieldLevelEncryptionContentTypeProfilesRes");
var de_TooManyFieldLevelEncryptionEncryptionEntitiesRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const contents = (0, import_smithy_client.map)({});
  const data = parsedOutput.body.Error;
  if (data[_Me] != null) {
    contents[_Me] = (0, import_smithy_client.expectString)(data[_Me]);
  }
  const exception = new TooManyFieldLevelEncryptionEncryptionEntities({
    $metadata: deserializeMetadata(parsedOutput),
    ...contents
  });
  return (0, import_smithy_client.decorateServiceException)(exception, parsedOutput.body.Error);
}, "de_TooManyFieldLevelEncryptionEncryptionEntitiesRes");
var de_TooManyFieldLevelEncryptionFieldPatternsRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const contents = (0, import_smithy_client.map)({});
  const data = parsedOutput.body.Error;
  if (data[_Me] != null) {
    contents[_Me] = (0, import_smithy_client.expectString)(data[_Me]);
  }
  const exception = new TooManyFieldLevelEncryptionFieldPatterns({
    $metadata: deserializeMetadata(parsedOutput),
    ...contents
  });
  return (0, import_smithy_client.decorateServiceException)(exception, parsedOutput.body.Error);
}, "de_TooManyFieldLevelEncryptionFieldPatternsRes");
var de_TooManyFieldLevelEncryptionProfilesRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const contents = (0, import_smithy_client.map)({});
  const data = parsedOutput.body.Error;
  if (data[_Me] != null) {
    contents[_Me] = (0, import_smithy_client.expectString)(data[_Me]);
  }
  const exception = new TooManyFieldLevelEncryptionProfiles({
    $metadata: deserializeMetadata(parsedOutput),
    ...contents
  });
  return (0, import_smithy_client.decorateServiceException)(exception, parsedOutput.body.Error);
}, "de_TooManyFieldLevelEncryptionProfilesRes");
var de_TooManyFieldLevelEncryptionQueryArgProfilesRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const contents = (0, import_smithy_client.map)({});
  const data = parsedOutput.body.Error;
  if (data[_Me] != null) {
    contents[_Me] = (0, import_smithy_client.expectString)(data[_Me]);
  }
  const exception = new TooManyFieldLevelEncryptionQueryArgProfiles({
    $metadata: deserializeMetadata(parsedOutput),
    ...contents
  });
  return (0, import_smithy_client.decorateServiceException)(exception, parsedOutput.body.Error);
}, "de_TooManyFieldLevelEncryptionQueryArgProfilesRes");
var de_TooManyFunctionAssociationsRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const contents = (0, import_smithy_client.map)({});
  const data = parsedOutput.body.Error;
  if (data[_Me] != null) {
    contents[_Me] = (0, import_smithy_client.expectString)(data[_Me]);
  }
  const exception = new TooManyFunctionAssociations({
    $metadata: deserializeMetadata(parsedOutput),
    ...contents
  });
  return (0, import_smithy_client.decorateServiceException)(exception, parsedOutput.body.Error);
}, "de_TooManyFunctionAssociationsRes");
var de_TooManyFunctionsRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const contents = (0, import_smithy_client.map)({});
  const data = parsedOutput.body.Error;
  if (data[_Me] != null) {
    contents[_Me] = (0, import_smithy_client.expectString)(data[_Me]);
  }
  const exception = new TooManyFunctions({
    $metadata: deserializeMetadata(parsedOutput),
    ...contents
  });
  return (0, import_smithy_client.decorateServiceException)(exception, parsedOutput.body.Error);
}, "de_TooManyFunctionsRes");
var de_TooManyHeadersInCachePolicyRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const contents = (0, import_smithy_client.map)({});
  const data = parsedOutput.body.Error;
  if (data[_Me] != null) {
    contents[_Me] = (0, import_smithy_client.expectString)(data[_Me]);
  }
  const exception = new TooManyHeadersInCachePolicy({
    $metadata: deserializeMetadata(parsedOutput),
    ...contents
  });
  return (0, import_smithy_client.decorateServiceException)(exception, parsedOutput.body.Error);
}, "de_TooManyHeadersInCachePolicyRes");
var de_TooManyHeadersInForwardedValuesRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const contents = (0, import_smithy_client.map)({});
  const data = parsedOutput.body.Error;
  if (data[_Me] != null) {
    contents[_Me] = (0, import_smithy_client.expectString)(data[_Me]);
  }
  const exception = new TooManyHeadersInForwardedValues({
    $metadata: deserializeMetadata(parsedOutput),
    ...contents
  });
  return (0, import_smithy_client.decorateServiceException)(exception, parsedOutput.body.Error);
}, "de_TooManyHeadersInForwardedValuesRes");
var de_TooManyHeadersInOriginRequestPolicyRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const contents = (0, import_smithy_client.map)({});
  const data = parsedOutput.body.Error;
  if (data[_Me] != null) {
    contents[_Me] = (0, import_smithy_client.expectString)(data[_Me]);
  }
  const exception = new TooManyHeadersInOriginRequestPolicy({
    $metadata: deserializeMetadata(parsedOutput),
    ...contents
  });
  return (0, import_smithy_client.decorateServiceException)(exception, parsedOutput.body.Error);
}, "de_TooManyHeadersInOriginRequestPolicyRes");
var de_TooManyInvalidationsInProgressRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const contents = (0, import_smithy_client.map)({});
  const data = parsedOutput.body.Error;
  if (data[_Me] != null) {
    contents[_Me] = (0, import_smithy_client.expectString)(data[_Me]);
  }
  const exception = new TooManyInvalidationsInProgress({
    $metadata: deserializeMetadata(parsedOutput),
    ...contents
  });
  return (0, import_smithy_client.decorateServiceException)(exception, parsedOutput.body.Error);
}, "de_TooManyInvalidationsInProgressRes");
var de_TooManyKeyGroupsRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const contents = (0, import_smithy_client.map)({});
  const data = parsedOutput.body.Error;
  if (data[_Me] != null) {
    contents[_Me] = (0, import_smithy_client.expectString)(data[_Me]);
  }
  const exception = new TooManyKeyGroups({
    $metadata: deserializeMetadata(parsedOutput),
    ...contents
  });
  return (0, import_smithy_client.decorateServiceException)(exception, parsedOutput.body.Error);
}, "de_TooManyKeyGroupsRes");
var de_TooManyKeyGroupsAssociatedToDistributionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const contents = (0, import_smithy_client.map)({});
  const data = parsedOutput.body.Error;
  if (data[_Me] != null) {
    contents[_Me] = (0, import_smithy_client.expectString)(data[_Me]);
  }
  const exception = new TooManyKeyGroupsAssociatedToDistribution({
    $metadata: deserializeMetadata(parsedOutput),
    ...contents
  });
  return (0, import_smithy_client.decorateServiceException)(exception, parsedOutput.body.Error);
}, "de_TooManyKeyGroupsAssociatedToDistributionRes");
var de_TooManyLambdaFunctionAssociationsRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const contents = (0, import_smithy_client.map)({});
  const data = parsedOutput.body.Error;
  if (data[_Me] != null) {
    contents[_Me] = (0, import_smithy_client.expectString)(data[_Me]);
  }
  const exception = new TooManyLambdaFunctionAssociations({
    $metadata: deserializeMetadata(parsedOutput),
    ...contents
  });
  return (0, import_smithy_client.decorateServiceException)(exception, parsedOutput.body.Error);
}, "de_TooManyLambdaFunctionAssociationsRes");
var de_TooManyOriginAccessControlsRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const contents = (0, import_smithy_client.map)({});
  const data = parsedOutput.body.Error;
  if (data[_Me] != null) {
    contents[_Me] = (0, import_smithy_client.expectString)(data[_Me]);
  }
  const exception = new TooManyOriginAccessControls({
    $metadata: deserializeMetadata(parsedOutput),
    ...contents
  });
  return (0, import_smithy_client.decorateServiceException)(exception, parsedOutput.body.Error);
}, "de_TooManyOriginAccessControlsRes");
var de_TooManyOriginCustomHeadersRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const contents = (0, import_smithy_client.map)({});
  const data = parsedOutput.body.Error;
  if (data[_Me] != null) {
    contents[_Me] = (0, import_smithy_client.expectString)(data[_Me]);
  }
  const exception = new TooManyOriginCustomHeaders({
    $metadata: deserializeMetadata(parsedOutput),
    ...contents
  });
  return (0, import_smithy_client.decorateServiceException)(exception, parsedOutput.body.Error);
}, "de_TooManyOriginCustomHeadersRes");
var de_TooManyOriginGroupsPerDistributionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const contents = (0, import_smithy_client.map)({});
  const data = parsedOutput.body.Error;
  if (data[_Me] != null) {
    contents[_Me] = (0, import_smithy_client.expectString)(data[_Me]);
  }
  const exception = new TooManyOriginGroupsPerDistribution({
    $metadata: deserializeMetadata(parsedOutput),
    ...contents
  });
  return (0, import_smithy_client.decorateServiceException)(exception, parsedOutput.body.Error);
}, "de_TooManyOriginGroupsPerDistributionRes");
var de_TooManyOriginRequestPoliciesRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const contents = (0, import_smithy_client.map)({});
  const data = parsedOutput.body.Error;
  if (data[_Me] != null) {
    contents[_Me] = (0, import_smithy_client.expectString)(data[_Me]);
  }
  const exception = new TooManyOriginRequestPolicies({
    $metadata: deserializeMetadata(parsedOutput),
    ...contents
  });
  return (0, import_smithy_client.decorateServiceException)(exception, parsedOutput.body.Error);
}, "de_TooManyOriginRequestPoliciesRes");
var de_TooManyOriginsRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const contents = (0, import_smithy_client.map)({});
  const data = parsedOutput.body.Error;
  if (data[_Me] != null) {
    contents[_Me] = (0, import_smithy_client.expectString)(data[_Me]);
  }
  const exception = new TooManyOrigins({
    $metadata: deserializeMetadata(parsedOutput),
    ...contents
  });
  return (0, import_smithy_client.decorateServiceException)(exception, parsedOutput.body.Error);
}, "de_TooManyOriginsRes");
var de_TooManyPublicKeysRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const contents = (0, import_smithy_client.map)({});
  const data = parsedOutput.body.Error;
  if (data[_Me] != null) {
    contents[_Me] = (0, import_smithy_client.expectString)(data[_Me]);
  }
  const exception = new TooManyPublicKeys({
    $metadata: deserializeMetadata(parsedOutput),
    ...contents
  });
  return (0, import_smithy_client.decorateServiceException)(exception, parsedOutput.body.Error);
}, "de_TooManyPublicKeysRes");
var de_TooManyPublicKeysInKeyGroupRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const contents = (0, import_smithy_client.map)({});
  const data = parsedOutput.body.Error;
  if (data[_Me] != null) {
    contents[_Me] = (0, import_smithy_client.expectString)(data[_Me]);
  }
  const exception = new TooManyPublicKeysInKeyGroup({
    $metadata: deserializeMetadata(parsedOutput),
    ...contents
  });
  return (0, import_smithy_client.decorateServiceException)(exception, parsedOutput.body.Error);
}, "de_TooManyPublicKeysInKeyGroupRes");
var de_TooManyQueryStringParametersRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const contents = (0, import_smithy_client.map)({});
  const data = parsedOutput.body.Error;
  if (data[_Me] != null) {
    contents[_Me] = (0, import_smithy_client.expectString)(data[_Me]);
  }
  const exception = new TooManyQueryStringParameters({
    $metadata: deserializeMetadata(parsedOutput),
    ...contents
  });
  return (0, import_smithy_client.decorateServiceException)(exception, parsedOutput.body.Error);
}, "de_TooManyQueryStringParametersRes");
var de_TooManyQueryStringsInCachePolicyRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const contents = (0, import_smithy_client.map)({});
  const data = parsedOutput.body.Error;
  if (data[_Me] != null) {
    contents[_Me] = (0, import_smithy_client.expectString)(data[_Me]);
  }
  const exception = new TooManyQueryStringsInCachePolicy({
    $metadata: deserializeMetadata(parsedOutput),
    ...contents
  });
  return (0, import_smithy_client.decorateServiceException)(exception, parsedOutput.body.Error);
}, "de_TooManyQueryStringsInCachePolicyRes");
var de_TooManyQueryStringsInOriginRequestPolicyRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const contents = (0, import_smithy_client.map)({});
  const data = parsedOutput.body.Error;
  if (data[_Me] != null) {
    contents[_Me] = (0, import_smithy_client.expectString)(data[_Me]);
  }
  const exception = new TooManyQueryStringsInOriginRequestPolicy({
    $metadata: deserializeMetadata(parsedOutput),
    ...contents
  });
  return (0, import_smithy_client.decorateServiceException)(exception, parsedOutput.body.Error);
}, "de_TooManyQueryStringsInOriginRequestPolicyRes");
var de_TooManyRealtimeLogConfigsRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const contents = (0, import_smithy_client.map)({});
  const data = parsedOutput.body.Error;
  if (data[_Me] != null) {
    contents[_Me] = (0, import_smithy_client.expectString)(data[_Me]);
  }
  const exception = new TooManyRealtimeLogConfigs({
    $metadata: deserializeMetadata(parsedOutput),
    ...contents
  });
  return (0, import_smithy_client.decorateServiceException)(exception, parsedOutput.body.Error);
}, "de_TooManyRealtimeLogConfigsRes");
var de_TooManyRemoveHeadersInResponseHeadersPolicyRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const contents = (0, import_smithy_client.map)({});
  const data = parsedOutput.body.Error;
  if (data[_Me] != null) {
    contents[_Me] = (0, import_smithy_client.expectString)(data[_Me]);
  }
  const exception = new TooManyRemoveHeadersInResponseHeadersPolicy({
    $metadata: deserializeMetadata(parsedOutput),
    ...contents
  });
  return (0, import_smithy_client.decorateServiceException)(exception, parsedOutput.body.Error);
}, "de_TooManyRemoveHeadersInResponseHeadersPolicyRes");
var de_TooManyResponseHeadersPoliciesRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const contents = (0, import_smithy_client.map)({});
  const data = parsedOutput.body.Error;
  if (data[_Me] != null) {
    contents[_Me] = (0, import_smithy_client.expectString)(data[_Me]);
  }
  const exception = new TooManyResponseHeadersPolicies({
    $metadata: deserializeMetadata(parsedOutput),
    ...contents
  });
  return (0, import_smithy_client.decorateServiceException)(exception, parsedOutput.body.Error);
}, "de_TooManyResponseHeadersPoliciesRes");
var de_TooManyStreamingDistributionCNAMEsRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const contents = (0, import_smithy_client.map)({});
  const data = parsedOutput.body.Error;
  if (data[_Me] != null) {
    contents[_Me] = (0, import_smithy_client.expectString)(data[_Me]);
  }
  const exception = new TooManyStreamingDistributionCNAMEs({
    $metadata: deserializeMetadata(parsedOutput),
    ...contents
  });
  return (0, import_smithy_client.decorateServiceException)(exception, parsedOutput.body.Error);
}, "de_TooManyStreamingDistributionCNAMEsRes");
var de_TooManyStreamingDistributionsRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const contents = (0, import_smithy_client.map)({});
  const data = parsedOutput.body.Error;
  if (data[_Me] != null) {
    contents[_Me] = (0, import_smithy_client.expectString)(data[_Me]);
  }
  const exception = new TooManyStreamingDistributions({
    $metadata: deserializeMetadata(parsedOutput),
    ...contents
  });
  return (0, import_smithy_client.decorateServiceException)(exception, parsedOutput.body.Error);
}, "de_TooManyStreamingDistributionsRes");
var de_TooManyTrustedSignersRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const contents = (0, import_smithy_client.map)({});
  const data = parsedOutput.body.Error;
  if (data[_Me] != null) {
    contents[_Me] = (0, import_smithy_client.expectString)(data[_Me]);
  }
  const exception = new TooManyTrustedSigners({
    $metadata: deserializeMetadata(parsedOutput),
    ...contents
  });
  return (0, import_smithy_client.decorateServiceException)(exception, parsedOutput.body.Error);
}, "de_TooManyTrustedSignersRes");
var de_TrustedKeyGroupDoesNotExistRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const contents = (0, import_smithy_client.map)({});
  const data = parsedOutput.body.Error;
  if (data[_Me] != null) {
    contents[_Me] = (0, import_smithy_client.expectString)(data[_Me]);
  }
  const exception = new TrustedKeyGroupDoesNotExist({
    $metadata: deserializeMetadata(parsedOutput),
    ...contents
  });
  return (0, import_smithy_client.decorateServiceException)(exception, parsedOutput.body.Error);
}, "de_TrustedKeyGroupDoesNotExistRes");
var de_TrustedSignerDoesNotExistRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const contents = (0, import_smithy_client.map)({});
  const data = parsedOutput.body.Error;
  if (data[_Me] != null) {
    contents[_Me] = (0, import_smithy_client.expectString)(data[_Me]);
  }
  const exception = new TrustedSignerDoesNotExist({
    $metadata: deserializeMetadata(parsedOutput),
    ...contents
  });
  return (0, import_smithy_client.decorateServiceException)(exception, parsedOutput.body.Error);
}, "de_TrustedSignerDoesNotExistRes");
var de_UnsupportedOperationRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const contents = (0, import_smithy_client.map)({});
  const data = parsedOutput.body.Error;
  if (data[_Me] != null) {
    contents[_Me] = (0, import_smithy_client.expectString)(data[_Me]);
  }
  const exception = new UnsupportedOperation({
    $metadata: deserializeMetadata(parsedOutput),
    ...contents
  });
  return (0, import_smithy_client.decorateServiceException)(exception, parsedOutput.body.Error);
}, "de_UnsupportedOperationRes");
var se_AccessControlAllowHeadersList = /* @__PURE__ */ __name((input, context) => {
  return input.filter((e) => e != null).map((entry) => {
    const n = import_xml_builder.XmlNode.of(_s, entry);
    return n.n(_H);
  });
}, "se_AccessControlAllowHeadersList");
var se_AccessControlAllowMethodsList = /* @__PURE__ */ __name((input, context) => {
  return input.filter((e) => e != null).map((entry) => {
    const n = import_xml_builder.XmlNode.of(_RHPACAMV, entry);
    return n.n(_Met);
  });
}, "se_AccessControlAllowMethodsList");
var se_AccessControlAllowOriginsList = /* @__PURE__ */ __name((input, context) => {
  return input.filter((e) => e != null).map((entry) => {
    const n = import_xml_builder.XmlNode.of(_s, entry);
    return n.n(_Or);
  });
}, "se_AccessControlAllowOriginsList");
var se_AccessControlExposeHeadersList = /* @__PURE__ */ __name((input, context) => {
  return input.filter((e) => e != null).map((entry) => {
    const n = import_xml_builder.XmlNode.of(_s, entry);
    return n.n(_H);
  });
}, "se_AccessControlExposeHeadersList");
var se_Aliases = /* @__PURE__ */ __name((input, context) => {
  const bn = new import_xml_builder.XmlNode(_Al);
  if (input[_Q] != null) {
    bn.c(import_xml_builder.XmlNode.of(_i, String(input[_Q])).n(_Q));
  }
  bn.lc(input, "Items", "Items", () => se_AliasList(input[_It], context));
  return bn;
}, "se_Aliases");
var se_AliasList = /* @__PURE__ */ __name((input, context) => {
  return input.filter((e) => e != null).map((entry) => {
    const n = import_xml_builder.XmlNode.of(_s, entry);
    return n.n(_CNAME);
  });
}, "se_AliasList");
var se_AllowedMethods = /* @__PURE__ */ __name((input, context) => {
  const bn = new import_xml_builder.XmlNode(_AM);
  if (input[_Q] != null) {
    bn.c(import_xml_builder.XmlNode.of(_i, String(input[_Q])).n(_Q));
  }
  bn.lc(input, "Items", "Items", () => se_MethodsList(input[_It], context));
  if (input[_CM] != null) {
    bn.c(se_CachedMethods(input[_CM], context).n(_CM));
  }
  return bn;
}, "se_AllowedMethods");
var se_AwsAccountNumberList = /* @__PURE__ */ __name((input, context) => {
  return input.filter((e) => e != null).map((entry) => {
    const n = import_xml_builder.XmlNode.of(_s, entry);
    return n.n(_AAN);
  });
}, "se_AwsAccountNumberList");
var se_CacheBehavior = /* @__PURE__ */ __name((input, context) => {
  const bn = new import_xml_builder.XmlNode(_CB);
  if (input[_PP] != null) {
    bn.c(import_xml_builder.XmlNode.of(_s, input[_PP]).n(_PP));
  }
  if (input[_TOI] != null) {
    bn.c(import_xml_builder.XmlNode.of(_s, input[_TOI]).n(_TOI));
  }
  if (input[_TS] != null) {
    bn.c(se_TrustedSigners(input[_TS], context).n(_TS));
  }
  if (input[_TKG] != null) {
    bn.c(se_TrustedKeyGroups(input[_TKG], context).n(_TKG));
  }
  bn.cc(input, _VPP);
  if (input[_AM] != null) {
    bn.c(se_AllowedMethods(input[_AM], context).n(_AM));
  }
  if (input[_SS] != null) {
    bn.c(import_xml_builder.XmlNode.of(_b, String(input[_SS])).n(_SS));
  }
  if (input[_Com] != null) {
    bn.c(import_xml_builder.XmlNode.of(_b, String(input[_Com])).n(_Com));
  }
  if (input[_LFA] != null) {
    bn.c(se_LambdaFunctionAssociations(input[_LFA], context).n(_LFA));
  }
  if (input[_FA] != null) {
    bn.c(se_FunctionAssociations(input[_FA], context).n(_FA));
  }
  if (input[_FLEI] != null) {
    bn.c(import_xml_builder.XmlNode.of(_s, input[_FLEI]).n(_FLEI));
  }
  if (input[_RLCA] != null) {
    bn.c(import_xml_builder.XmlNode.of(_s, input[_RLCA]).n(_RLCA));
  }
  if (input[_CPI] != null) {
    bn.c(import_xml_builder.XmlNode.of(_s, input[_CPI]).n(_CPI));
  }
  if (input[_ORPI] != null) {
    bn.c(import_xml_builder.XmlNode.of(_s, input[_ORPI]).n(_ORPI));
  }
  if (input[_RHPI] != null) {
    bn.c(import_xml_builder.XmlNode.of(_s, input[_RHPI]).n(_RHPI));
  }
  if (input[_GC] != null) {
    bn.c(se_GrpcConfig(input[_GC], context).n(_GC));
  }
  if (input[_FV] != null) {
    bn.c(se_ForwardedValues(input[_FV], context).n(_FV));
  }
  if (input[_MTTL] != null) {
    bn.c(import_xml_builder.XmlNode.of(_l, String(input[_MTTL])).n(_MTTL));
  }
  if (input[_DTTL] != null) {
    bn.c(import_xml_builder.XmlNode.of(_l, String(input[_DTTL])).n(_DTTL));
  }
  if (input[_MTTLa] != null) {
    bn.c(import_xml_builder.XmlNode.of(_l, String(input[_MTTLa])).n(_MTTLa));
  }
  return bn;
}, "se_CacheBehavior");
var se_CacheBehaviorList = /* @__PURE__ */ __name((input, context) => {
  return input.filter((e) => e != null).map((entry) => {
    const n = se_CacheBehavior(entry, context);
    return n.n(_CB);
  });
}, "se_CacheBehaviorList");
var se_CacheBehaviors = /* @__PURE__ */ __name((input, context) => {
  const bn = new import_xml_builder.XmlNode(_CBa);
  if (input[_Q] != null) {
    bn.c(import_xml_builder.XmlNode.of(_i, String(input[_Q])).n(_Q));
  }
  bn.lc(input, "Items", "Items", () => se_CacheBehaviorList(input[_It], context));
  return bn;
}, "se_CacheBehaviors");
var se_CachedMethods = /* @__PURE__ */ __name((input, context) => {
  const bn = new import_xml_builder.XmlNode(_CM);
  if (input[_Q] != null) {
    bn.c(import_xml_builder.XmlNode.of(_i, String(input[_Q])).n(_Q));
  }
  bn.lc(input, "Items", "Items", () => se_MethodsList(input[_It], context));
  return bn;
}, "se_CachedMethods");
var se_CachePolicyConfig = /* @__PURE__ */ __name((input, context) => {
  const bn = new import_xml_builder.XmlNode(_CPC);
  if (input[_Co] != null) {
    bn.c(import_xml_builder.XmlNode.of(_s, input[_Co]).n(_Co));
  }
  if (input[_N] != null) {
    bn.c(import_xml_builder.XmlNode.of(_s, input[_N]).n(_N));
  }
  if (input[_DTTL] != null) {
    bn.c(import_xml_builder.XmlNode.of(_l, String(input[_DTTL])).n(_DTTL));
  }
  if (input[_MTTLa] != null) {
    bn.c(import_xml_builder.XmlNode.of(_l, String(input[_MTTLa])).n(_MTTLa));
  }
  if (input[_MTTL] != null) {
    bn.c(import_xml_builder.XmlNode.of(_l, String(input[_MTTL])).n(_MTTL));
  }
  if (input[_PICKAFTO] != null) {
    bn.c(se_ParametersInCacheKeyAndForwardedToOrigin(input[_PICKAFTO], context).n(_PICKAFTO));
  }
  return bn;
}, "se_CachePolicyConfig");
var se_CachePolicyCookiesConfig = /* @__PURE__ */ __name((input, context) => {
  const bn = new import_xml_builder.XmlNode(_CPCC);
  if (input[_CBo] != null) {
    bn.c(import_xml_builder.XmlNode.of(_CPCB, input[_CBo]).n(_CBo));
  }
  if (input[_Coo] != null) {
    bn.c(se_CookieNames(input[_Coo], context).n(_Coo));
  }
  return bn;
}, "se_CachePolicyCookiesConfig");
var se_CachePolicyHeadersConfig = /* @__PURE__ */ __name((input, context) => {
  const bn = new import_xml_builder.XmlNode(_CPHC);
  if (input[_HB] != null) {
    bn.c(import_xml_builder.XmlNode.of(_CPHB, input[_HB]).n(_HB));
  }
  if (input[_He] != null) {
    bn.c(se_Headers(input[_He], context).n(_He));
  }
  return bn;
}, "se_CachePolicyHeadersConfig");
var se_CachePolicyQueryStringsConfig = /* @__PURE__ */ __name((input, context) => {
  const bn = new import_xml_builder.XmlNode(_CPQSC);
  if (input[_QSB] != null) {
    bn.c(import_xml_builder.XmlNode.of(_CPQSB, input[_QSB]).n(_QSB));
  }
  if (input[_QS] != null) {
    bn.c(se_QueryStringNames(input[_QS], context).n(_QS));
  }
  return bn;
}, "se_CachePolicyQueryStringsConfig");
var se_Certificate = /* @__PURE__ */ __name((input, context) => {
  const bn = new import_xml_builder.XmlNode(_Ce);
  if (input[_Ar] != null) {
    bn.c(import_xml_builder.XmlNode.of(_s, input[_Ar]).n(_Ar));
  }
  return bn;
}, "se_Certificate");
var se_CloudFrontOriginAccessIdentityConfig = /* @__PURE__ */ __name((input, context) => {
  const bn = new import_xml_builder.XmlNode(_CFOAIC);
  if (input[_CR] != null) {
    bn.c(import_xml_builder.XmlNode.of(_s, input[_CR]).n(_CR));
  }
  if (input[_Co] != null) {
    bn.c(import_xml_builder.XmlNode.of(_s, input[_Co]).n(_Co));
  }
  return bn;
}, "se_CloudFrontOriginAccessIdentityConfig");
var se_ConnectionGroupAssociationFilter = /* @__PURE__ */ __name((input, context) => {
  const bn = new import_xml_builder.XmlNode(_CGAF);
  if (input[_AILI] != null) {
    bn.c(import_xml_builder.XmlNode.of(_s, input[_AILI]).n(_AILI));
  }
  return bn;
}, "se_ConnectionGroupAssociationFilter");
var se_ContentTypeProfile = /* @__PURE__ */ __name((input, context) => {
  const bn = new import_xml_builder.XmlNode(_CTP);
  bn.cc(input, _Fo);
  if (input[_PI] != null) {
    bn.c(import_xml_builder.XmlNode.of(_s, input[_PI]).n(_PI));
  }
  if (input[_CT] != null) {
    bn.c(import_xml_builder.XmlNode.of(_s, input[_CT]).n(_CT));
  }
  return bn;
}, "se_ContentTypeProfile");
var se_ContentTypeProfileConfig = /* @__PURE__ */ __name((input, context) => {
  const bn = new import_xml_builder.XmlNode(_CTPC);
  if (input[_FWCTIU] != null) {
    bn.c(import_xml_builder.XmlNode.of(_b, String(input[_FWCTIU])).n(_FWCTIU));
  }
  if (input[_CTPo] != null) {
    bn.c(se_ContentTypeProfiles(input[_CTPo], context).n(_CTPo));
  }
  return bn;
}, "se_ContentTypeProfileConfig");
var se_ContentTypeProfileList = /* @__PURE__ */ __name((input, context) => {
  return input.filter((e) => e != null).map((entry) => {
    const n = se_ContentTypeProfile(entry, context);
    return n.n(_CTP);
  });
}, "se_ContentTypeProfileList");
var se_ContentTypeProfiles = /* @__PURE__ */ __name((input, context) => {
  const bn = new import_xml_builder.XmlNode(_CTPo);
  if (input[_Q] != null) {
    bn.c(import_xml_builder.XmlNode.of(_i, String(input[_Q])).n(_Q));
  }
  bn.lc(input, "Items", "Items", () => se_ContentTypeProfileList(input[_It], context));
  return bn;
}, "se_ContentTypeProfiles");
var se_ContinuousDeploymentPolicyConfig = /* @__PURE__ */ __name((input, context) => {
  const bn = new import_xml_builder.XmlNode(_CDPC);
  if (input[_SDDN] != null) {
    bn.c(se_StagingDistributionDnsNames(input[_SDDN], context).n(_SDDN));
  }
  if (input[_E] != null) {
    bn.c(import_xml_builder.XmlNode.of(_b, String(input[_E])).n(_E));
  }
  if (input[_TC] != null) {
    bn.c(se_TrafficConfig(input[_TC], context).n(_TC));
  }
  return bn;
}, "se_ContinuousDeploymentPolicyConfig");
var se_ContinuousDeploymentSingleHeaderConfig = /* @__PURE__ */ __name((input, context) => {
  const bn = new import_xml_builder.XmlNode(_CDSHC);
  if (input[_H] != null) {
    bn.c(import_xml_builder.XmlNode.of(_s, input[_H]).n(_H));
  }
  if (input[_V] != null) {
    bn.c(import_xml_builder.XmlNode.of(_s, input[_V]).n(_V));
  }
  return bn;
}, "se_ContinuousDeploymentSingleHeaderConfig");
var se_ContinuousDeploymentSingleWeightConfig = /* @__PURE__ */ __name((input, context) => {
  const bn = new import_xml_builder.XmlNode(_CDSWC);
  if (input[_W] != null) {
    bn.c(import_xml_builder.XmlNode.of(_f, String(input[_W])).n(_W));
  }
  if (input[_SSC] != null) {
    bn.c(se_SessionStickinessConfig(input[_SSC], context).n(_SSC));
  }
  return bn;
}, "se_ContinuousDeploymentSingleWeightConfig");
var se_CookieNameList = /* @__PURE__ */ __name((input, context) => {
  return input.filter((e) => e != null).map((entry) => {
    const n = import_xml_builder.XmlNode.of(_s, entry);
    return n.n(_N);
  });
}, "se_CookieNameList");
var se_CookieNames = /* @__PURE__ */ __name((input, context) => {
  const bn = new import_xml_builder.XmlNode(_CN);
  if (input[_Q] != null) {
    bn.c(import_xml_builder.XmlNode.of(_i, String(input[_Q])).n(_Q));
  }
  bn.lc(input, "Items", "Items", () => se_CookieNameList(input[_It], context));
  return bn;
}, "se_CookieNames");
var se_CookiePreference = /* @__PURE__ */ __name((input, context) => {
  const bn = new import_xml_builder.XmlNode(_CP);
  if (input[_For] != null) {
    bn.c(import_xml_builder.XmlNode.of(_ISt, input[_For]).n(_For));
  }
  if (input[_WN] != null) {
    bn.c(se_CookieNames(input[_WN], context).n(_WN));
  }
  return bn;
}, "se_CookiePreference");
var se_CustomErrorResponse = /* @__PURE__ */ __name((input, context) => {
  const bn = new import_xml_builder.XmlNode(_CER);
  if (input[_EC] != null) {
    bn.c(import_xml_builder.XmlNode.of(_i, String(input[_EC])).n(_EC));
  }
  if (input[_RPP] != null) {
    bn.c(import_xml_builder.XmlNode.of(_s, input[_RPP]).n(_RPP));
  }
  if (input[_RC] != null) {
    bn.c(import_xml_builder.XmlNode.of(_s, input[_RC]).n(_RC));
  }
  if (input[_ECMTTL] != null) {
    bn.c(import_xml_builder.XmlNode.of(_l, String(input[_ECMTTL])).n(_ECMTTL));
  }
  return bn;
}, "se_CustomErrorResponse");
var se_CustomErrorResponseList = /* @__PURE__ */ __name((input, context) => {
  return input.filter((e) => e != null).map((entry) => {
    const n = se_CustomErrorResponse(entry, context);
    return n.n(_CER);
  });
}, "se_CustomErrorResponseList");
var se_CustomErrorResponses = /* @__PURE__ */ __name((input, context) => {
  const bn = new import_xml_builder.XmlNode(_CERu);
  if (input[_Q] != null) {
    bn.c(import_xml_builder.XmlNode.of(_i, String(input[_Q])).n(_Q));
  }
  bn.lc(input, "Items", "Items", () => se_CustomErrorResponseList(input[_It], context));
  return bn;
}, "se_CustomErrorResponses");
var se_CustomHeaders = /* @__PURE__ */ __name((input, context) => {
  const bn = new import_xml_builder.XmlNode(_CH);
  if (input[_Q] != null) {
    bn.c(import_xml_builder.XmlNode.of(_i, String(input[_Q])).n(_Q));
  }
  bn.lc(input, "Items", "Items", () => se_OriginCustomHeadersList(input[_It], context));
  return bn;
}, "se_CustomHeaders");
var se_Customizations = /* @__PURE__ */ __name((input, context) => {
  const bn = new import_xml_builder.XmlNode(_C);
  if (input[_WA] != null) {
    bn.c(se_WebAclCustomization(input[_WA], context).n(_WA));
  }
  if (input[_Ce] != null) {
    bn.c(se_Certificate(input[_Ce], context).n(_Ce));
  }
  if (input[_GR] != null) {
    bn.c(se_GeoRestrictionCustomization(input[_GR], context).n(_GR));
  }
  return bn;
}, "se_Customizations");
var se_CustomOriginConfig = /* @__PURE__ */ __name((input, context) => {
  const bn = new import_xml_builder.XmlNode(_COC);
  if (input[_HTTPP] != null) {
    bn.c(import_xml_builder.XmlNode.of(_i, String(input[_HTTPP])).n(_HTTPP));
  }
  if (input[_HTTPSP] != null) {
    bn.c(import_xml_builder.XmlNode.of(_i, String(input[_HTTPSP])).n(_HTTPSP));
  }
  bn.cc(input, _OPP);
  if (input[_OSP] != null) {
    bn.c(se_OriginSslProtocols(input[_OSP], context).n(_OSP));
  }
  if (input[_ORT] != null) {
    bn.c(import_xml_builder.XmlNode.of(_i, String(input[_ORT])).n(_ORT));
  }
  if (input[_OKT] != null) {
    bn.c(import_xml_builder.XmlNode.of(_i, String(input[_OKT])).n(_OKT));
  }
  return bn;
}, "se_CustomOriginConfig");
var se_DefaultCacheBehavior = /* @__PURE__ */ __name((input, context) => {
  const bn = new import_xml_builder.XmlNode(_DCB);
  if (input[_TOI] != null) {
    bn.c(import_xml_builder.XmlNode.of(_s, input[_TOI]).n(_TOI));
  }
  if (input[_TS] != null) {
    bn.c(se_TrustedSigners(input[_TS], context).n(_TS));
  }
  if (input[_TKG] != null) {
    bn.c(se_TrustedKeyGroups(input[_TKG], context).n(_TKG));
  }
  bn.cc(input, _VPP);
  if (input[_AM] != null) {
    bn.c(se_AllowedMethods(input[_AM], context).n(_AM));
  }
  if (input[_SS] != null) {
    bn.c(import_xml_builder.XmlNode.of(_b, String(input[_SS])).n(_SS));
  }
  if (input[_Com] != null) {
    bn.c(import_xml_builder.XmlNode.of(_b, String(input[_Com])).n(_Com));
  }
  if (input[_LFA] != null) {
    bn.c(se_LambdaFunctionAssociations(input[_LFA], context).n(_LFA));
  }
  if (input[_FA] != null) {
    bn.c(se_FunctionAssociations(input[_FA], context).n(_FA));
  }
  if (input[_FLEI] != null) {
    bn.c(import_xml_builder.XmlNode.of(_s, input[_FLEI]).n(_FLEI));
  }
  if (input[_RLCA] != null) {
    bn.c(import_xml_builder.XmlNode.of(_s, input[_RLCA]).n(_RLCA));
  }
  if (input[_CPI] != null) {
    bn.c(import_xml_builder.XmlNode.of(_s, input[_CPI]).n(_CPI));
  }
  if (input[_ORPI] != null) {
    bn.c(import_xml_builder.XmlNode.of(_s, input[_ORPI]).n(_ORPI));
  }
  if (input[_RHPI] != null) {
    bn.c(import_xml_builder.XmlNode.of(_s, input[_RHPI]).n(_RHPI));
  }
  if (input[_GC] != null) {
    bn.c(se_GrpcConfig(input[_GC], context).n(_GC));
  }
  if (input[_FV] != null) {
    bn.c(se_ForwardedValues(input[_FV], context).n(_FV));
  }
  if (input[_MTTL] != null) {
    bn.c(import_xml_builder.XmlNode.of(_l, String(input[_MTTL])).n(_MTTL));
  }
  if (input[_DTTL] != null) {
    bn.c(import_xml_builder.XmlNode.of(_l, String(input[_DTTL])).n(_DTTL));
  }
  if (input[_MTTLa] != null) {
    bn.c(import_xml_builder.XmlNode.of(_l, String(input[_MTTLa])).n(_MTTLa));
  }
  return bn;
}, "se_DefaultCacheBehavior");
var se_DistributionConfig = /* @__PURE__ */ __name((input, context) => {
  const bn = new import_xml_builder.XmlNode(_DCi);
  if (input[_CR] != null) {
    bn.c(import_xml_builder.XmlNode.of(_s, input[_CR]).n(_CR));
  }
  if (input[_Al] != null) {
    bn.c(se_Aliases(input[_Al], context).n(_Al));
  }
  if (input[_DRO] != null) {
    bn.c(import_xml_builder.XmlNode.of(_s, input[_DRO]).n(_DRO));
  }
  if (input[_Ori] != null) {
    bn.c(se_Origins(input[_Ori], context).n(_Ori));
  }
  if (input[_OG] != null) {
    bn.c(se_OriginGroups(input[_OG], context).n(_OG));
  }
  if (input[_DCB] != null) {
    bn.c(se_DefaultCacheBehavior(input[_DCB], context).n(_DCB));
  }
  if (input[_CBa] != null) {
    bn.c(se_CacheBehaviors(input[_CBa], context).n(_CBa));
  }
  if (input[_CERu] != null) {
    bn.c(se_CustomErrorResponses(input[_CERu], context).n(_CERu));
  }
  if (input[_Co] != null) {
    bn.c(import_xml_builder.XmlNode.of(_CTo, input[_Co]).n(_Co));
  }
  if (input[_Lo] != null) {
    bn.c(se_LoggingConfig(input[_Lo], context).n(_Lo));
  }
  bn.cc(input, _PC);
  if (input[_E] != null) {
    bn.c(import_xml_builder.XmlNode.of(_b, String(input[_E])).n(_E));
  }
  if (input[_VC] != null) {
    bn.c(se_ViewerCertificate(input[_VC], context).n(_VC));
  }
  if (input[_Re] != null) {
    bn.c(se_Restrictions(input[_Re], context).n(_Re));
  }
  if (input[_WACLI] != null) {
    bn.c(import_xml_builder.XmlNode.of(_s, input[_WACLI]).n(_WACLI));
  }
  bn.cc(input, _HV);
  if (input[_IIPVE] != null) {
    bn.c(import_xml_builder.XmlNode.of(_b, String(input[_IIPVE])).n(_IIPVE));
  }
  if (input[_CDPI] != null) {
    bn.c(import_xml_builder.XmlNode.of(_s, input[_CDPI]).n(_CDPI));
  }
  if (input[_S] != null) {
    bn.c(import_xml_builder.XmlNode.of(_b, String(input[_S])).n(_S));
  }
  if (input[_AILI] != null) {
    bn.c(import_xml_builder.XmlNode.of(_s, input[_AILI]).n(_AILI));
  }
  if (input[_TCe] != null) {
    bn.c(se_TenantConfig(input[_TCe], context).n(_TCe));
  }
  bn.cc(input, _CMo);
  return bn;
}, "se_DistributionConfig");
var se_DistributionConfigWithTags = /* @__PURE__ */ __name((input, context) => {
  const bn = new import_xml_builder.XmlNode(_DCWT);
  if (input[_DCi] != null) {
    bn.c(se_DistributionConfig(input[_DCi], context).n(_DCi));
  }
  if (input[_T] != null) {
    bn.c(se_Tags(input[_T], context).n(_T));
  }
  return bn;
}, "se_DistributionConfigWithTags");
var se_DistributionResourceId = /* @__PURE__ */ __name((input, context) => {
  const bn = new import_xml_builder.XmlNode(_DRI);
  if (input[_DI] != null) {
    bn.c(import_xml_builder.XmlNode.of(_s, input[_DI]).n(_DI));
  }
  if (input[_DTI] != null) {
    bn.c(import_xml_builder.XmlNode.of(_s, input[_DTI]).n(_DTI));
  }
  return bn;
}, "se_DistributionResourceId");
var se_DistributionTenantAssociationFilter = /* @__PURE__ */ __name((input, context) => {
  const bn = new import_xml_builder.XmlNode(_DTAF);
  if (input[_DI] != null) {
    bn.c(import_xml_builder.XmlNode.of(_s, input[_DI]).n(_DI));
  }
  if (input[_CGI] != null) {
    bn.c(import_xml_builder.XmlNode.of(_s, input[_CGI]).n(_CGI));
  }
  return bn;
}, "se_DistributionTenantAssociationFilter");
var se_DomainItem = /* @__PURE__ */ __name((input, context) => {
  const bn = new import_xml_builder.XmlNode(_DIo);
  if (input[_Do] != null) {
    bn.c(import_xml_builder.XmlNode.of(_s, input[_Do]).n(_Do));
  }
  return bn;
}, "se_DomainItem");
var se_DomainList = /* @__PURE__ */ __name((input, context) => {
  return input.filter((e) => e != null).map((entry) => {
    const n = se_DomainItem(entry, context);
    return n.n(_m);
  });
}, "se_DomainList");
var se_EncryptionEntities = /* @__PURE__ */ __name((input, context) => {
  const bn = new import_xml_builder.XmlNode(_EE);
  if (input[_Q] != null) {
    bn.c(import_xml_builder.XmlNode.of(_i, String(input[_Q])).n(_Q));
  }
  bn.lc(input, "Items", "Items", () => se_EncryptionEntityList(input[_It], context));
  return bn;
}, "se_EncryptionEntities");
var se_EncryptionEntity = /* @__PURE__ */ __name((input, context) => {
  const bn = new import_xml_builder.XmlNode(_EEn);
  if (input[_PKI] != null) {
    bn.c(import_xml_builder.XmlNode.of(_s, input[_PKI]).n(_PKI));
  }
  if (input[_PIr] != null) {
    bn.c(import_xml_builder.XmlNode.of(_s, input[_PIr]).n(_PIr));
  }
  if (input[_FP] != null) {
    bn.c(se_FieldPatterns(input[_FP], context).n(_FP));
  }
  return bn;
}, "se_EncryptionEntity");
var se_EncryptionEntityList = /* @__PURE__ */ __name((input, context) => {
  return input.filter((e) => e != null).map((entry) => {
    const n = se_EncryptionEntity(entry, context);
    return n.n(_EEn);
  });
}, "se_EncryptionEntityList");
var se_EndPoint = /* @__PURE__ */ __name((input, context) => {
  const bn = new import_xml_builder.XmlNode(_EPn);
  if (input[_ST] != null) {
    bn.c(import_xml_builder.XmlNode.of(_s, input[_ST]).n(_ST));
  }
  if (input[_KSC] != null) {
    bn.c(se_KinesisStreamConfig(input[_KSC], context).n(_KSC));
  }
  return bn;
}, "se_EndPoint");
var se_EndPointList = /* @__PURE__ */ __name((input, context) => {
  return input.filter((e) => e != null).map((entry) => {
    const n = se_EndPoint(entry, context);
    return n.n(_m);
  });
}, "se_EndPointList");
var se_FieldLevelEncryptionConfig = /* @__PURE__ */ __name((input, context) => {
  const bn = new import_xml_builder.XmlNode(_FLEC);
  if (input[_CR] != null) {
    bn.c(import_xml_builder.XmlNode.of(_s, input[_CR]).n(_CR));
  }
  if (input[_Co] != null) {
    bn.c(import_xml_builder.XmlNode.of(_s, input[_Co]).n(_Co));
  }
  if (input[_QAPC] != null) {
    bn.c(se_QueryArgProfileConfig(input[_QAPC], context).n(_QAPC));
  }
  if (input[_CTPC] != null) {
    bn.c(se_ContentTypeProfileConfig(input[_CTPC], context).n(_CTPC));
  }
  return bn;
}, "se_FieldLevelEncryptionConfig");
var se_FieldLevelEncryptionProfileConfig = /* @__PURE__ */ __name((input, context) => {
  const bn = new import_xml_builder.XmlNode(_FLEPC);
  if (input[_N] != null) {
    bn.c(import_xml_builder.XmlNode.of(_s, input[_N]).n(_N));
  }
  if (input[_CR] != null) {
    bn.c(import_xml_builder.XmlNode.of(_s, input[_CR]).n(_CR));
  }
  if (input[_Co] != null) {
    bn.c(import_xml_builder.XmlNode.of(_s, input[_Co]).n(_Co));
  }
  if (input[_EE] != null) {
    bn.c(se_EncryptionEntities(input[_EE], context).n(_EE));
  }
  return bn;
}, "se_FieldLevelEncryptionProfileConfig");
var se_FieldList = /* @__PURE__ */ __name((input, context) => {
  return input.filter((e) => e != null).map((entry) => {
    const n = import_xml_builder.XmlNode.of(_s, entry);
    return n.n(_Fi);
  });
}, "se_FieldList");
var se_FieldPatternList = /* @__PURE__ */ __name((input, context) => {
  return input.filter((e) => e != null).map((entry) => {
    const n = import_xml_builder.XmlNode.of(_s, entry);
    return n.n(_FPi);
  });
}, "se_FieldPatternList");
var se_FieldPatterns = /* @__PURE__ */ __name((input, context) => {
  const bn = new import_xml_builder.XmlNode(_FP);
  if (input[_Q] != null) {
    bn.c(import_xml_builder.XmlNode.of(_i, String(input[_Q])).n(_Q));
  }
  bn.lc(input, "Items", "Items", () => se_FieldPatternList(input[_It], context));
  return bn;
}, "se_FieldPatterns");
var se_ForwardedValues = /* @__PURE__ */ __name((input, context) => {
  const bn = new import_xml_builder.XmlNode(_FV);
  if (input[_QSu] != null) {
    bn.c(import_xml_builder.XmlNode.of(_b, String(input[_QSu])).n(_QSu));
  }
  if (input[_Coo] != null) {
    bn.c(se_CookiePreference(input[_Coo], context).n(_Coo));
  }
  if (input[_He] != null) {
    bn.c(se_Headers(input[_He], context).n(_He));
  }
  if (input[_QSCK] != null) {
    bn.c(se_QueryStringCacheKeys(input[_QSCK], context).n(_QSCK));
  }
  return bn;
}, "se_ForwardedValues");
var se_FunctionAssociation = /* @__PURE__ */ __name((input, context) => {
  const bn = new import_xml_builder.XmlNode(_FAu);
  bn.cc(input, _FARN);
  bn.cc(input, _ETv);
  return bn;
}, "se_FunctionAssociation");
var se_FunctionAssociationList = /* @__PURE__ */ __name((input, context) => {
  return input.filter((e) => e != null).map((entry) => {
    const n = se_FunctionAssociation(entry, context);
    return n.n(_FAu);
  });
}, "se_FunctionAssociationList");
var se_FunctionAssociations = /* @__PURE__ */ __name((input, context) => {
  const bn = new import_xml_builder.XmlNode(_FA);
  if (input[_Q] != null) {
    bn.c(import_xml_builder.XmlNode.of(_i, String(input[_Q])).n(_Q));
  }
  bn.lc(input, "Items", "Items", () => se_FunctionAssociationList(input[_It], context));
  return bn;
}, "se_FunctionAssociations");
var se_FunctionConfig = /* @__PURE__ */ __name((input, context) => {
  const bn = new import_xml_builder.XmlNode(_FCu);
  if (input[_Co] != null) {
    bn.c(import_xml_builder.XmlNode.of(_s, input[_Co]).n(_Co));
  }
  if (input[_Ru] != null) {
    bn.c(import_xml_builder.XmlNode.of(_FR, input[_Ru]).n(_Ru));
  }
  if (input[_KVSA] != null) {
    bn.c(se_KeyValueStoreAssociations(input[_KVSA], context).n(_KVSA));
  }
  return bn;
}, "se_FunctionConfig");
var se_GeoRestriction = /* @__PURE__ */ __name((input, context) => {
  const bn = new import_xml_builder.XmlNode(_GRe);
  if (input[_RT] != null) {
    bn.c(import_xml_builder.XmlNode.of(_GRT, input[_RT]).n(_RT));
  }
  if (input[_Q] != null) {
    bn.c(import_xml_builder.XmlNode.of(_i, String(input[_Q])).n(_Q));
  }
  bn.lc(input, "Items", "Items", () => se_LocationList(input[_It], context));
  return bn;
}, "se_GeoRestriction");
var se_GeoRestrictionCustomization = /* @__PURE__ */ __name((input, context) => {
  const bn = new import_xml_builder.XmlNode(_GRC);
  if (input[_RT] != null) {
    bn.c(import_xml_builder.XmlNode.of(_GRT, input[_RT]).n(_RT));
  }
  bn.lc(input, "Locations", "Locations", () => se_LocationList(input[_Loc], context));
  return bn;
}, "se_GeoRestrictionCustomization");
var se_GrpcConfig = /* @__PURE__ */ __name((input, context) => {
  const bn = new import_xml_builder.XmlNode(_GC);
  if (input[_E] != null) {
    bn.c(import_xml_builder.XmlNode.of(_b, String(input[_E])).n(_E));
  }
  return bn;
}, "se_GrpcConfig");
var se_HeaderList = /* @__PURE__ */ __name((input, context) => {
  return input.filter((e) => e != null).map((entry) => {
    const n = import_xml_builder.XmlNode.of(_s, entry);
    return n.n(_N);
  });
}, "se_HeaderList");
var se_Headers = /* @__PURE__ */ __name((input, context) => {
  const bn = new import_xml_builder.XmlNode(_He);
  if (input[_Q] != null) {
    bn.c(import_xml_builder.XmlNode.of(_i, String(input[_Q])).n(_Q));
  }
  bn.lc(input, "Items", "Items", () => se_HeaderList(input[_It], context));
  return bn;
}, "se_Headers");
var se_ImportSource = /* @__PURE__ */ __name((input, context) => {
  const bn = new import_xml_builder.XmlNode(_IS);
  if (input[_STo] != null) {
    bn.c(import_xml_builder.XmlNode.of(_IST, input[_STo]).n(_STo));
  }
  if (input[_SARN] != null) {
    bn.c(import_xml_builder.XmlNode.of(_s, input[_SARN]).n(_SARN));
  }
  return bn;
}, "se_ImportSource");
var se_InvalidationBatch = /* @__PURE__ */ __name((input, context) => {
  const bn = new import_xml_builder.XmlNode(_IB);
  if (input[_Pa] != null) {
    bn.c(se_Paths(input[_Pa], context).n(_Pa));
  }
  if (input[_CR] != null) {
    bn.c(import_xml_builder.XmlNode.of(_s, input[_CR]).n(_CR));
  }
  return bn;
}, "se_InvalidationBatch");
var se_KeyGroupConfig = /* @__PURE__ */ __name((input, context) => {
  const bn = new import_xml_builder.XmlNode(_KGC);
  if (input[_N] != null) {
    bn.c(import_xml_builder.XmlNode.of(_s, input[_N]).n(_N));
  }
  bn.lc(input, "Items", "Items", () => se_PublicKeyIdList(input[_It], context));
  if (input[_Co] != null) {
    bn.c(import_xml_builder.XmlNode.of(_s, input[_Co]).n(_Co));
  }
  return bn;
}, "se_KeyGroupConfig");
var se_KeyValueStoreAssociation = /* @__PURE__ */ __name((input, context) => {
  const bn = new import_xml_builder.XmlNode(_KVSAe);
  bn.cc(input, _KVSARN);
  return bn;
}, "se_KeyValueStoreAssociation");
var se_KeyValueStoreAssociationList = /* @__PURE__ */ __name((input, context) => {
  return input.filter((e) => e != null).map((entry) => {
    const n = se_KeyValueStoreAssociation(entry, context);
    return n.n(_KVSAe);
  });
}, "se_KeyValueStoreAssociationList");
var se_KeyValueStoreAssociations = /* @__PURE__ */ __name((input, context) => {
  const bn = new import_xml_builder.XmlNode(_KVSA);
  if (input[_Q] != null) {
    bn.c(import_xml_builder.XmlNode.of(_i, String(input[_Q])).n(_Q));
  }
  bn.lc(input, "Items", "Items", () => se_KeyValueStoreAssociationList(input[_It], context));
  return bn;
}, "se_KeyValueStoreAssociations");
var se_KinesisStreamConfig = /* @__PURE__ */ __name((input, context) => {
  const bn = new import_xml_builder.XmlNode(_KSC);
  if (input[_RARN] != null) {
    bn.c(import_xml_builder.XmlNode.of(_s, input[_RARN]).n(_RARN));
  }
  if (input[_SARNt] != null) {
    bn.c(import_xml_builder.XmlNode.of(_s, input[_SARNt]).n(_SARNt));
  }
  return bn;
}, "se_KinesisStreamConfig");
var se_LambdaFunctionAssociation = /* @__PURE__ */ __name((input, context) => {
  const bn = new import_xml_builder.XmlNode(_LFAa);
  bn.cc(input, _LFARN);
  bn.cc(input, _ETv);
  if (input[_IBn] != null) {
    bn.c(import_xml_builder.XmlNode.of(_b, String(input[_IBn])).n(_IBn));
  }
  return bn;
}, "se_LambdaFunctionAssociation");
var se_LambdaFunctionAssociationList = /* @__PURE__ */ __name((input, context) => {
  return input.filter((e) => e != null).map((entry) => {
    const n = se_LambdaFunctionAssociation(entry, context);
    return n.n(_LFAa);
  });
}, "se_LambdaFunctionAssociationList");
var se_LambdaFunctionAssociations = /* @__PURE__ */ __name((input, context) => {
  const bn = new import_xml_builder.XmlNode(_LFA);
  if (input[_Q] != null) {
    bn.c(import_xml_builder.XmlNode.of(_i, String(input[_Q])).n(_Q));
  }
  bn.lc(input, "Items", "Items", () => se_LambdaFunctionAssociationList(input[_It], context));
  return bn;
}, "se_LambdaFunctionAssociations");
var se_LocationList = /* @__PURE__ */ __name((input, context) => {
  return input.filter((e) => e != null).map((entry) => {
    const n = import_xml_builder.XmlNode.of(_s, entry);
    return n.n(_L);
  });
}, "se_LocationList");
var se_LoggingConfig = /* @__PURE__ */ __name((input, context) => {
  const bn = new import_xml_builder.XmlNode(_LC);
  if (input[_E] != null) {
    bn.c(import_xml_builder.XmlNode.of(_b, String(input[_E])).n(_E));
  }
  if (input[_ICn] != null) {
    bn.c(import_xml_builder.XmlNode.of(_b, String(input[_ICn])).n(_ICn));
  }
  if (input[_B] != null) {
    bn.c(import_xml_builder.XmlNode.of(_s, input[_B]).n(_B));
  }
  if (input[_Pr] != null) {
    bn.c(import_xml_builder.XmlNode.of(_s, input[_Pr]).n(_Pr));
  }
  return bn;
}, "se_LoggingConfig");
var se_ManagedCertificateRequest = /* @__PURE__ */ __name((input, context) => {
  const bn = new import_xml_builder.XmlNode(_MCR);
  bn.cc(input, _VTH);
  if (input[_PDN] != null) {
    bn.c(import_xml_builder.XmlNode.of(_s, input[_PDN]).n(_PDN));
  }
  bn.cc(input, _CTLP);
  return bn;
}, "se_ManagedCertificateRequest");
var se_MethodsList = /* @__PURE__ */ __name((input, context) => {
  return input.filter((e) => e != null).map((entry) => {
    const n = import_xml_builder.XmlNode.of(_Met, entry);
    return n.n(_Met);
  });
}, "se_MethodsList");
var se_MonitoringSubscription = /* @__PURE__ */ __name((input, context) => {
  const bn = new import_xml_builder.XmlNode(_MS);
  if (input[_RMSC] != null) {
    bn.c(se_RealtimeMetricsSubscriptionConfig(input[_RMSC], context).n(_RMSC));
  }
  return bn;
}, "se_MonitoringSubscription");
var se_Origin = /* @__PURE__ */ __name((input, context) => {
  const bn = new import_xml_builder.XmlNode(_Or);
  if (input[_Id] != null) {
    bn.c(import_xml_builder.XmlNode.of(_s, input[_Id]).n(_Id));
  }
  if (input[_DN] != null) {
    bn.c(import_xml_builder.XmlNode.of(_s, input[_DN]).n(_DN));
  }
  if (input[_OP] != null) {
    bn.c(import_xml_builder.XmlNode.of(_s, input[_OP]).n(_OP));
  }
  if (input[_CH] != null) {
    bn.c(se_CustomHeaders(input[_CH], context).n(_CH));
  }
  if (input[_SOC] != null) {
    bn.c(se_S3OriginConfig(input[_SOC], context).n(_SOC));
  }
  if (input[_COC] != null) {
    bn.c(se_CustomOriginConfig(input[_COC], context).n(_COC));
  }
  if (input[_VOC] != null) {
    bn.c(se_VpcOriginConfig(input[_VOC], context).n(_VOC));
  }
  if (input[_CAo] != null) {
    bn.c(import_xml_builder.XmlNode.of(_i, String(input[_CAo])).n(_CAo));
  }
  if (input[_CTon] != null) {
    bn.c(import_xml_builder.XmlNode.of(_i, String(input[_CTon])).n(_CTon));
  }
  if (input[_OS] != null) {
    bn.c(se_OriginShield(input[_OS], context).n(_OS));
  }
  if (input[_OACI] != null) {
    bn.c(import_xml_builder.XmlNode.of(_s, input[_OACI]).n(_OACI));
  }
  return bn;
}, "se_Origin");
var se_OriginAccessControlConfig = /* @__PURE__ */ __name((input, context) => {
  const bn = new import_xml_builder.XmlNode(_OACC);
  if (input[_N] != null) {
    bn.c(import_xml_builder.XmlNode.of(_s, input[_N]).n(_N));
  }
  if (input[_De] != null) {
    bn.c(import_xml_builder.XmlNode.of(_s, input[_De]).n(_De));
  }
  if (input[_SP] != null) {
    bn.c(import_xml_builder.XmlNode.of(_OACSP, input[_SP]).n(_SP));
  }
  if (input[_SB] != null) {
    bn.c(import_xml_builder.XmlNode.of(_OACSB, input[_SB]).n(_SB));
  }
  if (input[_OACOT] != null) {
    bn.c(import_xml_builder.XmlNode.of(_OACOTr, input[_OACOT]).n(_OACOT));
  }
  return bn;
}, "se_OriginAccessControlConfig");
var se_OriginCustomHeader = /* @__PURE__ */ __name((input, context) => {
  const bn = new import_xml_builder.XmlNode(_OCH);
  if (input[_HN] != null) {
    bn.c(import_xml_builder.XmlNode.of(_s, input[_HN]).n(_HN));
  }
  if (input[_HVe] != null) {
    bn.c(import_xml_builder.XmlNode.of(_sST, input[_HVe]).n(_HVe));
  }
  return bn;
}, "se_OriginCustomHeader");
var se_OriginCustomHeadersList = /* @__PURE__ */ __name((input, context) => {
  return input.filter((e) => e != null).map((entry) => {
    const n = se_OriginCustomHeader(entry, context);
    return n.n(_OCH);
  });
}, "se_OriginCustomHeadersList");
var se_OriginGroup = /* @__PURE__ */ __name((input, context) => {
  const bn = new import_xml_builder.XmlNode(_OGr);
  if (input[_Id] != null) {
    bn.c(import_xml_builder.XmlNode.of(_s, input[_Id]).n(_Id));
  }
  if (input[_FCa] != null) {
    bn.c(se_OriginGroupFailoverCriteria(input[_FCa], context).n(_FCa));
  }
  if (input[_Mem] != null) {
    bn.c(se_OriginGroupMembers(input[_Mem], context).n(_Mem));
  }
  if (input[_SC] != null) {
    bn.c(import_xml_builder.XmlNode.of(_OGSC, input[_SC]).n(_SC));
  }
  return bn;
}, "se_OriginGroup");
var se_OriginGroupFailoverCriteria = /* @__PURE__ */ __name((input, context) => {
  const bn = new import_xml_builder.XmlNode(_OGFC);
  if (input[_SCt] != null) {
    bn.c(se_StatusCodes(input[_SCt], context).n(_SCt));
  }
  return bn;
}, "se_OriginGroupFailoverCriteria");
var se_OriginGroupList = /* @__PURE__ */ __name((input, context) => {
  return input.filter((e) => e != null).map((entry) => {
    const n = se_OriginGroup(entry, context);
    return n.n(_OGr);
  });
}, "se_OriginGroupList");
var se_OriginGroupMember = /* @__PURE__ */ __name((input, context) => {
  const bn = new import_xml_builder.XmlNode(_OGM);
  if (input[_OI] != null) {
    bn.c(import_xml_builder.XmlNode.of(_s, input[_OI]).n(_OI));
  }
  return bn;
}, "se_OriginGroupMember");
var se_OriginGroupMemberList = /* @__PURE__ */ __name((input, context) => {
  return input.filter((e) => e != null).map((entry) => {
    const n = se_OriginGroupMember(entry, context);
    return n.n(_OGM);
  });
}, "se_OriginGroupMemberList");
var se_OriginGroupMembers = /* @__PURE__ */ __name((input, context) => {
  const bn = new import_xml_builder.XmlNode(_OGMr);
  if (input[_Q] != null) {
    bn.c(import_xml_builder.XmlNode.of(_i, String(input[_Q])).n(_Q));
  }
  bn.lc(input, "Items", "Items", () => se_OriginGroupMemberList(input[_It], context));
  return bn;
}, "se_OriginGroupMembers");
var se_OriginGroups = /* @__PURE__ */ __name((input, context) => {
  const bn = new import_xml_builder.XmlNode(_OG);
  if (input[_Q] != null) {
    bn.c(import_xml_builder.XmlNode.of(_i, String(input[_Q])).n(_Q));
  }
  bn.lc(input, "Items", "Items", () => se_OriginGroupList(input[_It], context));
  return bn;
}, "se_OriginGroups");
var se_OriginList = /* @__PURE__ */ __name((input, context) => {
  return input.filter((e) => e != null).map((entry) => {
    const n = se_Origin(entry, context);
    return n.n(_Or);
  });
}, "se_OriginList");
var se_OriginRequestPolicyConfig = /* @__PURE__ */ __name((input, context) => {
  const bn = new import_xml_builder.XmlNode(_ORPC);
  if (input[_Co] != null) {
    bn.c(import_xml_builder.XmlNode.of(_s, input[_Co]).n(_Co));
  }
  if (input[_N] != null) {
    bn.c(import_xml_builder.XmlNode.of(_s, input[_N]).n(_N));
  }
  if (input[_HC] != null) {
    bn.c(se_OriginRequestPolicyHeadersConfig(input[_HC], context).n(_HC));
  }
  if (input[_CC] != null) {
    bn.c(se_OriginRequestPolicyCookiesConfig(input[_CC], context).n(_CC));
  }
  if (input[_QSC] != null) {
    bn.c(se_OriginRequestPolicyQueryStringsConfig(input[_QSC], context).n(_QSC));
  }
  return bn;
}, "se_OriginRequestPolicyConfig");
var se_OriginRequestPolicyCookiesConfig = /* @__PURE__ */ __name((input, context) => {
  const bn = new import_xml_builder.XmlNode(_ORPCC);
  if (input[_CBo] != null) {
    bn.c(import_xml_builder.XmlNode.of(_ORPCB, input[_CBo]).n(_CBo));
  }
  if (input[_Coo] != null) {
    bn.c(se_CookieNames(input[_Coo], context).n(_Coo));
  }
  return bn;
}, "se_OriginRequestPolicyCookiesConfig");
var se_OriginRequestPolicyHeadersConfig = /* @__PURE__ */ __name((input, context) => {
  const bn = new import_xml_builder.XmlNode(_ORPHC);
  if (input[_HB] != null) {
    bn.c(import_xml_builder.XmlNode.of(_ORPHB, input[_HB]).n(_HB));
  }
  if (input[_He] != null) {
    bn.c(se_Headers(input[_He], context).n(_He));
  }
  return bn;
}, "se_OriginRequestPolicyHeadersConfig");
var se_OriginRequestPolicyQueryStringsConfig = /* @__PURE__ */ __name((input, context) => {
  const bn = new import_xml_builder.XmlNode(_ORPQSC);
  if (input[_QSB] != null) {
    bn.c(import_xml_builder.XmlNode.of(_ORPQSB, input[_QSB]).n(_QSB));
  }
  if (input[_QS] != null) {
    bn.c(se_QueryStringNames(input[_QS], context).n(_QS));
  }
  return bn;
}, "se_OriginRequestPolicyQueryStringsConfig");
var se_Origins = /* @__PURE__ */ __name((input, context) => {
  const bn = new import_xml_builder.XmlNode(_Ori);
  if (input[_Q] != null) {
    bn.c(import_xml_builder.XmlNode.of(_i, String(input[_Q])).n(_Q));
  }
  bn.lc(input, "Items", "Items", () => se_OriginList(input[_It], context));
  return bn;
}, "se_Origins");
var se_OriginShield = /* @__PURE__ */ __name((input, context) => {
  const bn = new import_xml_builder.XmlNode(_OS);
  if (input[_E] != null) {
    bn.c(import_xml_builder.XmlNode.of(_b, String(input[_E])).n(_E));
  }
  bn.cc(input, _OSR);
  return bn;
}, "se_OriginShield");
var se_OriginSslProtocols = /* @__PURE__ */ __name((input, context) => {
  const bn = new import_xml_builder.XmlNode(_OSP);
  if (input[_Q] != null) {
    bn.c(import_xml_builder.XmlNode.of(_i, String(input[_Q])).n(_Q));
  }
  bn.lc(input, "Items", "Items", () => se_SslProtocolsList(input[_It], context));
  return bn;
}, "se_OriginSslProtocols");
var se_Parameter = /* @__PURE__ */ __name((input, context) => {
  const bn = new import_xml_builder.XmlNode(_Par);
  if (input[_N] != null) {
    bn.c(import_xml_builder.XmlNode.of(_PN, input[_N]).n(_N));
  }
  if (input[_V] != null) {
    bn.c(import_xml_builder.XmlNode.of(_PV, input[_V]).n(_V));
  }
  return bn;
}, "se_Parameter");
var se_ParameterDefinition = /* @__PURE__ */ __name((input, context) => {
  const bn = new import_xml_builder.XmlNode(_PD);
  if (input[_N] != null) {
    bn.c(import_xml_builder.XmlNode.of(_PN, input[_N]).n(_N));
  }
  if (input[_Def] != null) {
    bn.c(se_ParameterDefinitionSchema(input[_Def], context).n(_Def));
  }
  return bn;
}, "se_ParameterDefinition");
var se_ParameterDefinitions = /* @__PURE__ */ __name((input, context) => {
  return input.filter((e) => e != null).map((entry) => {
    const n = se_ParameterDefinition(entry, context);
    return n.n(_m);
  });
}, "se_ParameterDefinitions");
var se_ParameterDefinitionSchema = /* @__PURE__ */ __name((input, context) => {
  const bn = new import_xml_builder.XmlNode(_PDS);
  if (input[_SSt] != null) {
    bn.c(se_StringSchemaConfig(input[_SSt], context).n(_SSt));
  }
  return bn;
}, "se_ParameterDefinitionSchema");
var se_Parameters = /* @__PURE__ */ __name((input, context) => {
  return input.filter((e) => e != null).map((entry) => {
    const n = se_Parameter(entry, context);
    return n.n(_m);
  });
}, "se_Parameters");
var se_ParametersInCacheKeyAndForwardedToOrigin = /* @__PURE__ */ __name((input, context) => {
  const bn = new import_xml_builder.XmlNode(_PICKAFTO);
  if (input[_EAEG] != null) {
    bn.c(import_xml_builder.XmlNode.of(_b, String(input[_EAEG])).n(_EAEG));
  }
  if (input[_EAEB] != null) {
    bn.c(import_xml_builder.XmlNode.of(_b, String(input[_EAEB])).n(_EAEB));
  }
  if (input[_HC] != null) {
    bn.c(se_CachePolicyHeadersConfig(input[_HC], context).n(_HC));
  }
  if (input[_CC] != null) {
    bn.c(se_CachePolicyCookiesConfig(input[_CC], context).n(_CC));
  }
  if (input[_QSC] != null) {
    bn.c(se_CachePolicyQueryStringsConfig(input[_QSC], context).n(_QSC));
  }
  return bn;
}, "se_ParametersInCacheKeyAndForwardedToOrigin");
var se_PathList = /* @__PURE__ */ __name((input, context) => {
  return input.filter((e) => e != null).map((entry) => {
    const n = import_xml_builder.XmlNode.of(_s, entry);
    return n.n(_Pat);
  });
}, "se_PathList");
var se_Paths = /* @__PURE__ */ __name((input, context) => {
  const bn = new import_xml_builder.XmlNode(_Pa);
  if (input[_Q] != null) {
    bn.c(import_xml_builder.XmlNode.of(_i, String(input[_Q])).n(_Q));
  }
  bn.lc(input, "Items", "Items", () => se_PathList(input[_It], context));
  return bn;
}, "se_Paths");
var se_PublicKeyConfig = /* @__PURE__ */ __name((input, context) => {
  const bn = new import_xml_builder.XmlNode(_PKC);
  if (input[_CR] != null) {
    bn.c(import_xml_builder.XmlNode.of(_s, input[_CR]).n(_CR));
  }
  if (input[_N] != null) {
    bn.c(import_xml_builder.XmlNode.of(_s, input[_N]).n(_N));
  }
  if (input[_EK] != null) {
    bn.c(import_xml_builder.XmlNode.of(_s, input[_EK]).n(_EK));
  }
  if (input[_Co] != null) {
    bn.c(import_xml_builder.XmlNode.of(_s, input[_Co]).n(_Co));
  }
  return bn;
}, "se_PublicKeyConfig");
var se_PublicKeyIdList = /* @__PURE__ */ __name((input, context) => {
  return input.filter((e) => e != null).map((entry) => {
    const n = import_xml_builder.XmlNode.of(_s, entry);
    return n.n(_PK);
  });
}, "se_PublicKeyIdList");
var se_QueryArgProfile = /* @__PURE__ */ __name((input, context) => {
  const bn = new import_xml_builder.XmlNode(_QAP);
  if (input[_QA] != null) {
    bn.c(import_xml_builder.XmlNode.of(_s, input[_QA]).n(_QA));
  }
  if (input[_PI] != null) {
    bn.c(import_xml_builder.XmlNode.of(_s, input[_PI]).n(_PI));
  }
  return bn;
}, "se_QueryArgProfile");
var se_QueryArgProfileConfig = /* @__PURE__ */ __name((input, context) => {
  const bn = new import_xml_builder.XmlNode(_QAPC);
  if (input[_FWQAPIU] != null) {
    bn.c(import_xml_builder.XmlNode.of(_b, String(input[_FWQAPIU])).n(_FWQAPIU));
  }
  if (input[_QAPu] != null) {
    bn.c(se_QueryArgProfiles(input[_QAPu], context).n(_QAPu));
  }
  return bn;
}, "se_QueryArgProfileConfig");
var se_QueryArgProfileList = /* @__PURE__ */ __name((input, context) => {
  return input.filter((e) => e != null).map((entry) => {
    const n = se_QueryArgProfile(entry, context);
    return n.n(_QAP);
  });
}, "se_QueryArgProfileList");
var se_QueryArgProfiles = /* @__PURE__ */ __name((input, context) => {
  const bn = new import_xml_builder.XmlNode(_QAPu);
  if (input[_Q] != null) {
    bn.c(import_xml_builder.XmlNode.of(_i, String(input[_Q])).n(_Q));
  }
  bn.lc(input, "Items", "Items", () => se_QueryArgProfileList(input[_It], context));
  return bn;
}, "se_QueryArgProfiles");
var se_QueryStringCacheKeys = /* @__PURE__ */ __name((input, context) => {
  const bn = new import_xml_builder.XmlNode(_QSCK);
  if (input[_Q] != null) {
    bn.c(import_xml_builder.XmlNode.of(_i, String(input[_Q])).n(_Q));
  }
  bn.lc(input, "Items", "Items", () => se_QueryStringCacheKeysList(input[_It], context));
  return bn;
}, "se_QueryStringCacheKeys");
var se_QueryStringCacheKeysList = /* @__PURE__ */ __name((input, context) => {
  return input.filter((e) => e != null).map((entry) => {
    const n = import_xml_builder.XmlNode.of(_s, entry);
    return n.n(_N);
  });
}, "se_QueryStringCacheKeysList");
var se_QueryStringNames = /* @__PURE__ */ __name((input, context) => {
  const bn = new import_xml_builder.XmlNode(_QSN);
  if (input[_Q] != null) {
    bn.c(import_xml_builder.XmlNode.of(_i, String(input[_Q])).n(_Q));
  }
  bn.lc(input, "Items", "Items", () => se_QueryStringNamesList(input[_It], context));
  return bn;
}, "se_QueryStringNames");
var se_QueryStringNamesList = /* @__PURE__ */ __name((input, context) => {
  return input.filter((e) => e != null).map((entry) => {
    const n = import_xml_builder.XmlNode.of(_s, entry);
    return n.n(_N);
  });
}, "se_QueryStringNamesList");
var se_RealtimeMetricsSubscriptionConfig = /* @__PURE__ */ __name((input, context) => {
  const bn = new import_xml_builder.XmlNode(_RMSC);
  bn.cc(input, _RMSS);
  return bn;
}, "se_RealtimeMetricsSubscriptionConfig");
var se_ResponseHeadersPolicyAccessControlAllowHeaders = /* @__PURE__ */ __name((input, context) => {
  const bn = new import_xml_builder.XmlNode(_RHPACAH);
  if (input[_Q] != null) {
    bn.c(import_xml_builder.XmlNode.of(_i, String(input[_Q])).n(_Q));
  }
  bn.lc(input, "Items", "Items", () => se_AccessControlAllowHeadersList(input[_It], context));
  return bn;
}, "se_ResponseHeadersPolicyAccessControlAllowHeaders");
var se_ResponseHeadersPolicyAccessControlAllowMethods = /* @__PURE__ */ __name((input, context) => {
  const bn = new import_xml_builder.XmlNode(_RHPACAM);
  if (input[_Q] != null) {
    bn.c(import_xml_builder.XmlNode.of(_i, String(input[_Q])).n(_Q));
  }
  bn.lc(input, "Items", "Items", () => se_AccessControlAllowMethodsList(input[_It], context));
  return bn;
}, "se_ResponseHeadersPolicyAccessControlAllowMethods");
var se_ResponseHeadersPolicyAccessControlAllowOrigins = /* @__PURE__ */ __name((input, context) => {
  const bn = new import_xml_builder.XmlNode(_RHPACAO);
  if (input[_Q] != null) {
    bn.c(import_xml_builder.XmlNode.of(_i, String(input[_Q])).n(_Q));
  }
  bn.lc(input, "Items", "Items", () => se_AccessControlAllowOriginsList(input[_It], context));
  return bn;
}, "se_ResponseHeadersPolicyAccessControlAllowOrigins");
var se_ResponseHeadersPolicyAccessControlExposeHeaders = /* @__PURE__ */ __name((input, context) => {
  const bn = new import_xml_builder.XmlNode(_RHPACEH);
  if (input[_Q] != null) {
    bn.c(import_xml_builder.XmlNode.of(_i, String(input[_Q])).n(_Q));
  }
  bn.lc(input, "Items", "Items", () => se_AccessControlExposeHeadersList(input[_It], context));
  return bn;
}, "se_ResponseHeadersPolicyAccessControlExposeHeaders");
var se_ResponseHeadersPolicyConfig = /* @__PURE__ */ __name((input, context) => {
  const bn = new import_xml_builder.XmlNode(_RHPC);
  if (input[_Co] != null) {
    bn.c(import_xml_builder.XmlNode.of(_s, input[_Co]).n(_Co));
  }
  if (input[_N] != null) {
    bn.c(import_xml_builder.XmlNode.of(_s, input[_N]).n(_N));
  }
  if (input[_CCo] != null) {
    bn.c(se_ResponseHeadersPolicyCorsConfig(input[_CCo], context).n(_CCo));
  }
  if (input[_SHC] != null) {
    bn.c(se_ResponseHeadersPolicySecurityHeadersConfig(input[_SHC], context).n(_SHC));
  }
  if (input[_STHC] != null) {
    bn.c(se_ResponseHeadersPolicyServerTimingHeadersConfig(input[_STHC], context).n(_STHC));
  }
  if (input[_CHC] != null) {
    bn.c(se_ResponseHeadersPolicyCustomHeadersConfig(input[_CHC], context).n(_CHC));
  }
  if (input[_RHC] != null) {
    bn.c(se_ResponseHeadersPolicyRemoveHeadersConfig(input[_RHC], context).n(_RHC));
  }
  return bn;
}, "se_ResponseHeadersPolicyConfig");
var se_ResponseHeadersPolicyContentSecurityPolicy = /* @__PURE__ */ __name((input, context) => {
  const bn = new import_xml_builder.XmlNode(_RHPCSP);
  if (input[_Ov] != null) {
    bn.c(import_xml_builder.XmlNode.of(_b, String(input[_Ov])).n(_Ov));
  }
  if (input[_CSP] != null) {
    bn.c(import_xml_builder.XmlNode.of(_s, input[_CSP]).n(_CSP));
  }
  return bn;
}, "se_ResponseHeadersPolicyContentSecurityPolicy");
var se_ResponseHeadersPolicyContentTypeOptions = /* @__PURE__ */ __name((input, context) => {
  const bn = new import_xml_builder.XmlNode(_RHPCTO);
  if (input[_Ov] != null) {
    bn.c(import_xml_builder.XmlNode.of(_b, String(input[_Ov])).n(_Ov));
  }
  return bn;
}, "se_ResponseHeadersPolicyContentTypeOptions");
var se_ResponseHeadersPolicyCorsConfig = /* @__PURE__ */ __name((input, context) => {
  const bn = new import_xml_builder.XmlNode(_RHPCC);
  if (input[_ACAO] != null) {
    bn.c(se_ResponseHeadersPolicyAccessControlAllowOrigins(input[_ACAO], context).n(_ACAO));
  }
  if (input[_ACAH] != null) {
    bn.c(se_ResponseHeadersPolicyAccessControlAllowHeaders(input[_ACAH], context).n(_ACAH));
  }
  if (input[_ACAM] != null) {
    bn.c(se_ResponseHeadersPolicyAccessControlAllowMethods(input[_ACAM], context).n(_ACAM));
  }
  if (input[_ACAC] != null) {
    bn.c(import_xml_builder.XmlNode.of(_b, String(input[_ACAC])).n(_ACAC));
  }
  if (input[_ACEH] != null) {
    bn.c(se_ResponseHeadersPolicyAccessControlExposeHeaders(input[_ACEH], context).n(_ACEH));
  }
  if (input[_ACMAS] != null) {
    bn.c(import_xml_builder.XmlNode.of(_i, String(input[_ACMAS])).n(_ACMAS));
  }
  if (input[_OO] != null) {
    bn.c(import_xml_builder.XmlNode.of(_b, String(input[_OO])).n(_OO));
  }
  return bn;
}, "se_ResponseHeadersPolicyCorsConfig");
var se_ResponseHeadersPolicyCustomHeader = /* @__PURE__ */ __name((input, context) => {
  const bn = new import_xml_builder.XmlNode(_RHPCH);
  if (input[_H] != null) {
    bn.c(import_xml_builder.XmlNode.of(_s, input[_H]).n(_H));
  }
  if (input[_V] != null) {
    bn.c(import_xml_builder.XmlNode.of(_s, input[_V]).n(_V));
  }
  if (input[_Ov] != null) {
    bn.c(import_xml_builder.XmlNode.of(_b, String(input[_Ov])).n(_Ov));
  }
  return bn;
}, "se_ResponseHeadersPolicyCustomHeader");
var se_ResponseHeadersPolicyCustomHeaderList = /* @__PURE__ */ __name((input, context) => {
  return input.filter((e) => e != null).map((entry) => {
    const n = se_ResponseHeadersPolicyCustomHeader(entry, context);
    return n.n(_RHPCH);
  });
}, "se_ResponseHeadersPolicyCustomHeaderList");
var se_ResponseHeadersPolicyCustomHeadersConfig = /* @__PURE__ */ __name((input, context) => {
  const bn = new import_xml_builder.XmlNode(_RHPCHC);
  if (input[_Q] != null) {
    bn.c(import_xml_builder.XmlNode.of(_i, String(input[_Q])).n(_Q));
  }
  bn.lc(input, "Items", "Items", () => se_ResponseHeadersPolicyCustomHeaderList(input[_It], context));
  return bn;
}, "se_ResponseHeadersPolicyCustomHeadersConfig");
var se_ResponseHeadersPolicyFrameOptions = /* @__PURE__ */ __name((input, context) => {
  const bn = new import_xml_builder.XmlNode(_RHPFO);
  if (input[_Ov] != null) {
    bn.c(import_xml_builder.XmlNode.of(_b, String(input[_Ov])).n(_Ov));
  }
  if (input[_FO] != null) {
    bn.c(import_xml_builder.XmlNode.of(_FOL, input[_FO]).n(_FO));
  }
  return bn;
}, "se_ResponseHeadersPolicyFrameOptions");
var se_ResponseHeadersPolicyReferrerPolicy = /* @__PURE__ */ __name((input, context) => {
  const bn = new import_xml_builder.XmlNode(_RHPRP);
  if (input[_Ov] != null) {
    bn.c(import_xml_builder.XmlNode.of(_b, String(input[_Ov])).n(_Ov));
  }
  if (input[_RP] != null) {
    bn.c(import_xml_builder.XmlNode.of(_RPL, input[_RP]).n(_RP));
  }
  return bn;
}, "se_ResponseHeadersPolicyReferrerPolicy");
var se_ResponseHeadersPolicyRemoveHeader = /* @__PURE__ */ __name((input, context) => {
  const bn = new import_xml_builder.XmlNode(_RHPRH);
  if (input[_H] != null) {
    bn.c(import_xml_builder.XmlNode.of(_s, input[_H]).n(_H));
  }
  return bn;
}, "se_ResponseHeadersPolicyRemoveHeader");
var se_ResponseHeadersPolicyRemoveHeaderList = /* @__PURE__ */ __name((input, context) => {
  return input.filter((e) => e != null).map((entry) => {
    const n = se_ResponseHeadersPolicyRemoveHeader(entry, context);
    return n.n(_RHPRH);
  });
}, "se_ResponseHeadersPolicyRemoveHeaderList");
var se_ResponseHeadersPolicyRemoveHeadersConfig = /* @__PURE__ */ __name((input, context) => {
  const bn = new import_xml_builder.XmlNode(_RHPRHC);
  if (input[_Q] != null) {
    bn.c(import_xml_builder.XmlNode.of(_i, String(input[_Q])).n(_Q));
  }
  bn.lc(input, "Items", "Items", () => se_ResponseHeadersPolicyRemoveHeaderList(input[_It], context));
  return bn;
}, "se_ResponseHeadersPolicyRemoveHeadersConfig");
var se_ResponseHeadersPolicySecurityHeadersConfig = /* @__PURE__ */ __name((input, context) => {
  const bn = new import_xml_builder.XmlNode(_RHPSHC);
  if (input[_XSSP] != null) {
    bn.c(se_ResponseHeadersPolicyXSSProtection(input[_XSSP], context).n(_XSSP));
  }
  if (input[_FOr] != null) {
    bn.c(se_ResponseHeadersPolicyFrameOptions(input[_FOr], context).n(_FOr));
  }
  if (input[_RP] != null) {
    bn.c(se_ResponseHeadersPolicyReferrerPolicy(input[_RP], context).n(_RP));
  }
  if (input[_CSP] != null) {
    bn.c(se_ResponseHeadersPolicyContentSecurityPolicy(input[_CSP], context).n(_CSP));
  }
  if (input[_CTO] != null) {
    bn.c(se_ResponseHeadersPolicyContentTypeOptions(input[_CTO], context).n(_CTO));
  }
  if (input[_STS] != null) {
    bn.c(se_ResponseHeadersPolicyStrictTransportSecurity(input[_STS], context).n(_STS));
  }
  return bn;
}, "se_ResponseHeadersPolicySecurityHeadersConfig");
var se_ResponseHeadersPolicyServerTimingHeadersConfig = /* @__PURE__ */ __name((input, context) => {
  const bn = new import_xml_builder.XmlNode(_RHPSTHC);
  if (input[_E] != null) {
    bn.c(import_xml_builder.XmlNode.of(_b, String(input[_E])).n(_E));
  }
  if (input[_SR] != null) {
    bn.c(import_xml_builder.XmlNode.of(_SR, String(input[_SR])).n(_SR));
  }
  return bn;
}, "se_ResponseHeadersPolicyServerTimingHeadersConfig");
var se_ResponseHeadersPolicyStrictTransportSecurity = /* @__PURE__ */ __name((input, context) => {
  const bn = new import_xml_builder.XmlNode(_RHPSTS);
  if (input[_Ov] != null) {
    bn.c(import_xml_builder.XmlNode.of(_b, String(input[_Ov])).n(_Ov));
  }
  if (input[_ISn] != null) {
    bn.c(import_xml_builder.XmlNode.of(_b, String(input[_ISn])).n(_ISn));
  }
  if (input[_Pre] != null) {
    bn.c(import_xml_builder.XmlNode.of(_b, String(input[_Pre])).n(_Pre));
  }
  if (input[_ACMAS] != null) {
    bn.c(import_xml_builder.XmlNode.of(_i, String(input[_ACMAS])).n(_ACMAS));
  }
  return bn;
}, "se_ResponseHeadersPolicyStrictTransportSecurity");
var se_ResponseHeadersPolicyXSSProtection = /* @__PURE__ */ __name((input, context) => {
  const bn = new import_xml_builder.XmlNode(_RHPXSSP);
  if (input[_Ov] != null) {
    bn.c(import_xml_builder.XmlNode.of(_b, String(input[_Ov])).n(_Ov));
  }
  if (input[_Pro] != null) {
    bn.c(import_xml_builder.XmlNode.of(_b, String(input[_Pro])).n(_Pro));
  }
  if (input[_MB] != null) {
    bn.c(import_xml_builder.XmlNode.of(_b, String(input[_MB])).n(_MB));
  }
  if (input[_RU] != null) {
    bn.c(import_xml_builder.XmlNode.of(_s, input[_RU]).n(_RU));
  }
  return bn;
}, "se_ResponseHeadersPolicyXSSProtection");
var se_Restrictions = /* @__PURE__ */ __name((input, context) => {
  const bn = new import_xml_builder.XmlNode(_Re);
  if (input[_GRe] != null) {
    bn.c(se_GeoRestriction(input[_GRe], context).n(_GRe));
  }
  return bn;
}, "se_Restrictions");
var se_S3Origin = /* @__PURE__ */ __name((input, context) => {
  const bn = new import_xml_builder.XmlNode(_SO);
  if (input[_DN] != null) {
    bn.c(import_xml_builder.XmlNode.of(_s, input[_DN]).n(_DN));
  }
  if (input[_OAI] != null) {
    bn.c(import_xml_builder.XmlNode.of(_s, input[_OAI]).n(_OAI));
  }
  return bn;
}, "se_S3Origin");
var se_S3OriginConfig = /* @__PURE__ */ __name((input, context) => {
  const bn = new import_xml_builder.XmlNode(_SOC);
  if (input[_OAI] != null) {
    bn.c(import_xml_builder.XmlNode.of(_s, input[_OAI]).n(_OAI));
  }
  return bn;
}, "se_S3OriginConfig");
var se_SessionStickinessConfig = /* @__PURE__ */ __name((input, context) => {
  const bn = new import_xml_builder.XmlNode(_SSC);
  if (input[_ITTL] != null) {
    bn.c(import_xml_builder.XmlNode.of(_i, String(input[_ITTL])).n(_ITTL));
  }
  if (input[_MTTLax] != null) {
    bn.c(import_xml_builder.XmlNode.of(_i, String(input[_MTTLax])).n(_MTTLax));
  }
  return bn;
}, "se_SessionStickinessConfig");
var se_SslProtocolsList = /* @__PURE__ */ __name((input, context) => {
  return input.filter((e) => e != null).map((entry) => {
    const n = import_xml_builder.XmlNode.of(_SPs, entry);
    return n.n(_SPs);
  });
}, "se_SslProtocolsList");
var se_StagingDistributionDnsNameList = /* @__PURE__ */ __name((input, context) => {
  return input.filter((e) => e != null).map((entry) => {
    const n = import_xml_builder.XmlNode.of(_s, entry);
    return n.n(_DNn);
  });
}, "se_StagingDistributionDnsNameList");
var se_StagingDistributionDnsNames = /* @__PURE__ */ __name((input, context) => {
  const bn = new import_xml_builder.XmlNode(_SDDN);
  if (input[_Q] != null) {
    bn.c(import_xml_builder.XmlNode.of(_i, String(input[_Q])).n(_Q));
  }
  bn.lc(input, "Items", "Items", () => se_StagingDistributionDnsNameList(input[_It], context));
  return bn;
}, "se_StagingDistributionDnsNames");
var se_StatusCodeList = /* @__PURE__ */ __name((input, context) => {
  return input.filter((e) => e != null).map((entry) => {
    const n = import_xml_builder.XmlNode.of(_i, String(entry));
    return n.n(_SCta);
  });
}, "se_StatusCodeList");
var se_StatusCodes = /* @__PURE__ */ __name((input, context) => {
  const bn = new import_xml_builder.XmlNode(_SCt);
  if (input[_Q] != null) {
    bn.c(import_xml_builder.XmlNode.of(_i, String(input[_Q])).n(_Q));
  }
  bn.lc(input, "Items", "Items", () => se_StatusCodeList(input[_It], context));
  return bn;
}, "se_StatusCodes");
var se_StreamingDistributionConfig = /* @__PURE__ */ __name((input, context) => {
  const bn = new import_xml_builder.XmlNode(_SDC);
  if (input[_CR] != null) {
    bn.c(import_xml_builder.XmlNode.of(_s, input[_CR]).n(_CR));
  }
  if (input[_SO] != null) {
    bn.c(se_S3Origin(input[_SO], context).n(_SO));
  }
  if (input[_Al] != null) {
    bn.c(se_Aliases(input[_Al], context).n(_Al));
  }
  if (input[_Co] != null) {
    bn.c(import_xml_builder.XmlNode.of(_s, input[_Co]).n(_Co));
  }
  if (input[_Lo] != null) {
    bn.c(se_StreamingLoggingConfig(input[_Lo], context).n(_Lo));
  }
  if (input[_TS] != null) {
    bn.c(se_TrustedSigners(input[_TS], context).n(_TS));
  }
  bn.cc(input, _PC);
  if (input[_E] != null) {
    bn.c(import_xml_builder.XmlNode.of(_b, String(input[_E])).n(_E));
  }
  return bn;
}, "se_StreamingDistributionConfig");
var se_StreamingDistributionConfigWithTags = /* @__PURE__ */ __name((input, context) => {
  const bn = new import_xml_builder.XmlNode(_SDCWT);
  if (input[_SDC] != null) {
    bn.c(se_StreamingDistributionConfig(input[_SDC], context).n(_SDC));
  }
  if (input[_T] != null) {
    bn.c(se_Tags(input[_T], context).n(_T));
  }
  return bn;
}, "se_StreamingDistributionConfigWithTags");
var se_StreamingLoggingConfig = /* @__PURE__ */ __name((input, context) => {
  const bn = new import_xml_builder.XmlNode(_SLC);
  if (input[_E] != null) {
    bn.c(import_xml_builder.XmlNode.of(_b, String(input[_E])).n(_E));
  }
  if (input[_B] != null) {
    bn.c(import_xml_builder.XmlNode.of(_s, input[_B]).n(_B));
  }
  if (input[_Pr] != null) {
    bn.c(import_xml_builder.XmlNode.of(_s, input[_Pr]).n(_Pr));
  }
  return bn;
}, "se_StreamingLoggingConfig");
var se_StringSchemaConfig = /* @__PURE__ */ __name((input, context) => {
  const bn = new import_xml_builder.XmlNode(_SSCt);
  if (input[_Co] != null) {
    bn.c(import_xml_builder.XmlNode.of(_s, input[_Co]).n(_Co));
  }
  if (input[_DV] != null) {
    bn.c(import_xml_builder.XmlNode.of(_PV, input[_DV]).n(_DV));
  }
  if (input[_Req] != null) {
    bn.c(import_xml_builder.XmlNode.of(_b, String(input[_Req])).n(_Req));
  }
  return bn;
}, "se_StringSchemaConfig");
var se_Tag = /* @__PURE__ */ __name((input, context) => {
  const bn = new import_xml_builder.XmlNode(_Ta);
  if (input[_K] != null) {
    bn.c(import_xml_builder.XmlNode.of(_TK, input[_K]).n(_K));
  }
  if (input[_V] != null) {
    bn.c(import_xml_builder.XmlNode.of(_TV, input[_V]).n(_V));
  }
  return bn;
}, "se_Tag");
var se_TagKeyList = /* @__PURE__ */ __name((input, context) => {
  return input.filter((e) => e != null).map((entry) => {
    const n = import_xml_builder.XmlNode.of(_TK, entry);
    return n.n(_K);
  });
}, "se_TagKeyList");
var se_TagKeys = /* @__PURE__ */ __name((input, context) => {
  const bn = new import_xml_builder.XmlNode(_TKa);
  bn.lc(input, "Items", "Items", () => se_TagKeyList(input[_It], context));
  return bn;
}, "se_TagKeys");
var se_TagList = /* @__PURE__ */ __name((input, context) => {
  return input.filter((e) => e != null).map((entry) => {
    const n = se_Tag(entry, context);
    return n.n(_Ta);
  });
}, "se_TagList");
var se_Tags = /* @__PURE__ */ __name((input, context) => {
  const bn = new import_xml_builder.XmlNode(_T);
  bn.lc(input, "Items", "Items", () => se_TagList(input[_It], context));
  return bn;
}, "se_Tags");
var se_TenantConfig = /* @__PURE__ */ __name((input, context) => {
  const bn = new import_xml_builder.XmlNode(_TCe);
  bn.lc(input, "ParameterDefinitions", "ParameterDefinitions", () => se_ParameterDefinitions(input[_PDa], context));
  return bn;
}, "se_TenantConfig");
var se_TrafficConfig = /* @__PURE__ */ __name((input, context) => {
  const bn = new import_xml_builder.XmlNode(_TC);
  if (input[_SWC] != null) {
    bn.c(se_ContinuousDeploymentSingleWeightConfig(input[_SWC], context).n(_SWC));
  }
  if (input[_SHCi] != null) {
    bn.c(se_ContinuousDeploymentSingleHeaderConfig(input[_SHCi], context).n(_SHCi));
  }
  if (input[_Ty] != null) {
    bn.c(import_xml_builder.XmlNode.of(_CDPT, input[_Ty]).n(_Ty));
  }
  return bn;
}, "se_TrafficConfig");
var se_TrustedKeyGroupIdList = /* @__PURE__ */ __name((input, context) => {
  return input.filter((e) => e != null).map((entry) => {
    const n = import_xml_builder.XmlNode.of(_s, entry);
    return n.n(_KG);
  });
}, "se_TrustedKeyGroupIdList");
var se_TrustedKeyGroups = /* @__PURE__ */ __name((input, context) => {
  const bn = new import_xml_builder.XmlNode(_TKG);
  if (input[_E] != null) {
    bn.c(import_xml_builder.XmlNode.of(_b, String(input[_E])).n(_E));
  }
  if (input[_Q] != null) {
    bn.c(import_xml_builder.XmlNode.of(_i, String(input[_Q])).n(_Q));
  }
  bn.lc(input, "Items", "Items", () => se_TrustedKeyGroupIdList(input[_It], context));
  return bn;
}, "se_TrustedKeyGroups");
var se_TrustedSigners = /* @__PURE__ */ __name((input, context) => {
  const bn = new import_xml_builder.XmlNode(_TS);
  if (input[_E] != null) {
    bn.c(import_xml_builder.XmlNode.of(_b, String(input[_E])).n(_E));
  }
  if (input[_Q] != null) {
    bn.c(import_xml_builder.XmlNode.of(_i, String(input[_Q])).n(_Q));
  }
  bn.lc(input, "Items", "Items", () => se_AwsAccountNumberList(input[_It], context));
  return bn;
}, "se_TrustedSigners");
var se_ViewerCertificate = /* @__PURE__ */ __name((input, context) => {
  const bn = new import_xml_builder.XmlNode(_VC);
  if (input[_CFDC] != null) {
    bn.c(import_xml_builder.XmlNode.of(_b, String(input[_CFDC])).n(_CFDC));
  }
  if (input[_IAMCI] != null) {
    bn.c(import_xml_builder.XmlNode.of(_s, input[_IAMCI]).n(_IAMCI));
  }
  if (input[_ACMCA] != null) {
    bn.c(import_xml_builder.XmlNode.of(_s, input[_ACMCA]).n(_ACMCA));
  }
  bn.cc(input, _SSLSM);
  bn.cc(input, _MPV);
  if (input[_Ce] != null) {
    bn.c(import_xml_builder.XmlNode.of(_s, input[_Ce]).n(_Ce));
  }
  bn.cc(input, _CS);
  return bn;
}, "se_ViewerCertificate");
var se_VpcOriginConfig = /* @__PURE__ */ __name((input, context) => {
  const bn = new import_xml_builder.XmlNode(_VOC);
  if (input[_VOI] != null) {
    bn.c(import_xml_builder.XmlNode.of(_s, input[_VOI]).n(_VOI));
  }
  if (input[_ORT] != null) {
    bn.c(import_xml_builder.XmlNode.of(_i, String(input[_ORT])).n(_ORT));
  }
  if (input[_OKT] != null) {
    bn.c(import_xml_builder.XmlNode.of(_i, String(input[_OKT])).n(_OKT));
  }
  return bn;
}, "se_VpcOriginConfig");
var se_VpcOriginEndpointConfig = /* @__PURE__ */ __name((input, context) => {
  const bn = new import_xml_builder.XmlNode(_VOEC);
  if (input[_N] != null) {
    bn.c(import_xml_builder.XmlNode.of(_s, input[_N]).n(_N));
  }
  if (input[_Ar] != null) {
    bn.c(import_xml_builder.XmlNode.of(_s, input[_Ar]).n(_Ar));
  }
  if (input[_HTTPP] != null) {
    bn.c(import_xml_builder.XmlNode.of(_i, String(input[_HTTPP])).n(_HTTPP));
  }
  if (input[_HTTPSP] != null) {
    bn.c(import_xml_builder.XmlNode.of(_i, String(input[_HTTPSP])).n(_HTTPSP));
  }
  bn.cc(input, _OPP);
  if (input[_OSP] != null) {
    bn.c(se_OriginSslProtocols(input[_OSP], context).n(_OSP));
  }
  return bn;
}, "se_VpcOriginEndpointConfig");
var se_WebAclCustomization = /* @__PURE__ */ __name((input, context) => {
  const bn = new import_xml_builder.XmlNode(_WAC);
  if (input[_Ac] != null) {
    bn.c(import_xml_builder.XmlNode.of(_CAT, input[_Ac]).n(_Ac));
  }
  if (input[_Ar] != null) {
    bn.c(import_xml_builder.XmlNode.of(_s, input[_Ar]).n(_Ar));
  }
  return bn;
}, "se_WebAclCustomization");
var de_AccessControlAllowHeadersList = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return (0, import_smithy_client.expectString)(entry);
  });
}, "de_AccessControlAllowHeadersList");
var de_AccessControlAllowMethodsList = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return (0, import_smithy_client.expectString)(entry);
  });
}, "de_AccessControlAllowMethodsList");
var de_AccessControlAllowOriginsList = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return (0, import_smithy_client.expectString)(entry);
  });
}, "de_AccessControlAllowOriginsList");
var de_AccessControlExposeHeadersList = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return (0, import_smithy_client.expectString)(entry);
  });
}, "de_AccessControlExposeHeadersList");
var de_ActiveTrustedKeyGroups = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_E] != null) {
    contents[_E] = (0, import_smithy_client.parseBoolean)(output[_E]);
  }
  if (output[_Q] != null) {
    contents[_Q] = (0, import_smithy_client.strictParseInt32)(output[_Q]);
  }
  if (output.Items === "") {
    contents[_It] = [];
  } else if (output[_It] != null && output[_It][_KG] != null) {
    contents[_It] = de_KGKeyPairIdsList((0, import_smithy_client.getArrayIfSingleItem)(output[_It][_KG]), context);
  }
  return contents;
}, "de_ActiveTrustedKeyGroups");
var de_ActiveTrustedSigners = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_E] != null) {
    contents[_E] = (0, import_smithy_client.parseBoolean)(output[_E]);
  }
  if (output[_Q] != null) {
    contents[_Q] = (0, import_smithy_client.strictParseInt32)(output[_Q]);
  }
  if (output.Items === "") {
    contents[_It] = [];
  } else if (output[_It] != null && output[_It][_Si] != null) {
    contents[_It] = de_SignerList((0, import_smithy_client.getArrayIfSingleItem)(output[_It][_Si]), context);
  }
  return contents;
}, "de_ActiveTrustedSigners");
var de_Aliases = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_Q] != null) {
    contents[_Q] = (0, import_smithy_client.strictParseInt32)(output[_Q]);
  }
  if (output.Items === "") {
    contents[_It] = [];
  } else if (output[_It] != null && output[_It][_CNAME] != null) {
    contents[_It] = de_AliasList((0, import_smithy_client.getArrayIfSingleItem)(output[_It][_CNAME]), context);
  }
  return contents;
}, "de_Aliases");
var de_AliasICPRecordal = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_CNAME] != null) {
    contents[_CNAME] = (0, import_smithy_client.expectString)(output[_CNAME]);
  }
  if (output[_ICPRS] != null) {
    contents[_ICPRS] = (0, import_smithy_client.expectString)(output[_ICPRS]);
  }
  return contents;
}, "de_AliasICPRecordal");
var de_AliasICPRecordals = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_AliasICPRecordal(entry, context);
  });
}, "de_AliasICPRecordals");
var de_AliasList = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return (0, import_smithy_client.expectString)(entry);
  });
}, "de_AliasList");
var de_AllowedMethods = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_Q] != null) {
    contents[_Q] = (0, import_smithy_client.strictParseInt32)(output[_Q]);
  }
  if (output.Items === "") {
    contents[_It] = [];
  } else if (output[_It] != null && output[_It][_Met] != null) {
    contents[_It] = de_MethodsList((0, import_smithy_client.getArrayIfSingleItem)(output[_It][_Met]), context);
  }
  if (output[_CM] != null) {
    contents[_CM] = de_CachedMethods(output[_CM], context);
  }
  return contents;
}, "de_AllowedMethods");
var de_AnycastIpList = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_Id] != null) {
    contents[_Id] = (0, import_smithy_client.expectString)(output[_Id]);
  }
  if (output[_N] != null) {
    contents[_N] = (0, import_smithy_client.expectString)(output[_N]);
  }
  if (output[_Sta] != null) {
    contents[_Sta] = (0, import_smithy_client.expectString)(output[_Sta]);
  }
  if (output[_Ar] != null) {
    contents[_Ar] = (0, import_smithy_client.expectString)(output[_Ar]);
  }
  if (output.AnycastIps === "") {
    contents[_AI] = [];
  } else if (output[_AI] != null && output[_AI][_AIn] != null) {
    contents[_AI] = de_AnycastIps((0, import_smithy_client.getArrayIfSingleItem)(output[_AI][_AIn]), context);
  }
  if (output[_IC] != null) {
    contents[_IC] = (0, import_smithy_client.strictParseInt32)(output[_IC]);
  }
  if (output[_LMT] != null) {
    contents[_LMT] = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseRfc3339DateTimeWithOffset)(output[_LMT]));
  }
  return contents;
}, "de_AnycastIpList");
var de_AnycastIpListCollection = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output.Items === "") {
    contents[_It] = [];
  } else if (output[_It] != null && output[_It][_AILS] != null) {
    contents[_It] = de_AnycastIpListSummaries((0, import_smithy_client.getArrayIfSingleItem)(output[_It][_AILS]), context);
  }
  if (output[_M] != null) {
    contents[_M] = (0, import_smithy_client.expectString)(output[_M]);
  }
  if (output[_NM] != null) {
    contents[_NM] = (0, import_smithy_client.expectString)(output[_NM]);
  }
  if (output[_MI] != null) {
    contents[_MI] = (0, import_smithy_client.strictParseInt32)(output[_MI]);
  }
  if (output[_IT] != null) {
    contents[_IT] = (0, import_smithy_client.parseBoolean)(output[_IT]);
  }
  if (output[_Q] != null) {
    contents[_Q] = (0, import_smithy_client.strictParseInt32)(output[_Q]);
  }
  return contents;
}, "de_AnycastIpListCollection");
var de_AnycastIpListSummaries = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_AnycastIpListSummary(entry, context);
  });
}, "de_AnycastIpListSummaries");
var de_AnycastIpListSummary = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_Id] != null) {
    contents[_Id] = (0, import_smithy_client.expectString)(output[_Id]);
  }
  if (output[_N] != null) {
    contents[_N] = (0, import_smithy_client.expectString)(output[_N]);
  }
  if (output[_Sta] != null) {
    contents[_Sta] = (0, import_smithy_client.expectString)(output[_Sta]);
  }
  if (output[_Ar] != null) {
    contents[_Ar] = (0, import_smithy_client.expectString)(output[_Ar]);
  }
  if (output[_IC] != null) {
    contents[_IC] = (0, import_smithy_client.strictParseInt32)(output[_IC]);
  }
  if (output[_LMT] != null) {
    contents[_LMT] = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseRfc3339DateTimeWithOffset)(output[_LMT]));
  }
  return contents;
}, "de_AnycastIpListSummary");
var de_AnycastIps = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return (0, import_smithy_client.expectString)(entry);
  });
}, "de_AnycastIps");
var de_AwsAccountNumberList = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return (0, import_smithy_client.expectString)(entry);
  });
}, "de_AwsAccountNumberList");
var de_CacheBehavior = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_PP] != null) {
    contents[_PP] = (0, import_smithy_client.expectString)(output[_PP]);
  }
  if (output[_TOI] != null) {
    contents[_TOI] = (0, import_smithy_client.expectString)(output[_TOI]);
  }
  if (output[_TS] != null) {
    contents[_TS] = de_TrustedSigners(output[_TS], context);
  }
  if (output[_TKG] != null) {
    contents[_TKG] = de_TrustedKeyGroups(output[_TKG], context);
  }
  if (output[_VPP] != null) {
    contents[_VPP] = (0, import_smithy_client.expectString)(output[_VPP]);
  }
  if (output[_AM] != null) {
    contents[_AM] = de_AllowedMethods(output[_AM], context);
  }
  if (output[_SS] != null) {
    contents[_SS] = (0, import_smithy_client.parseBoolean)(output[_SS]);
  }
  if (output[_Com] != null) {
    contents[_Com] = (0, import_smithy_client.parseBoolean)(output[_Com]);
  }
  if (output[_LFA] != null) {
    contents[_LFA] = de_LambdaFunctionAssociations(output[_LFA], context);
  }
  if (output[_FA] != null) {
    contents[_FA] = de_FunctionAssociations(output[_FA], context);
  }
  if (output[_FLEI] != null) {
    contents[_FLEI] = (0, import_smithy_client.expectString)(output[_FLEI]);
  }
  if (output[_RLCA] != null) {
    contents[_RLCA] = (0, import_smithy_client.expectString)(output[_RLCA]);
  }
  if (output[_CPI] != null) {
    contents[_CPI] = (0, import_smithy_client.expectString)(output[_CPI]);
  }
  if (output[_ORPI] != null) {
    contents[_ORPI] = (0, import_smithy_client.expectString)(output[_ORPI]);
  }
  if (output[_RHPI] != null) {
    contents[_RHPI] = (0, import_smithy_client.expectString)(output[_RHPI]);
  }
  if (output[_GC] != null) {
    contents[_GC] = de_GrpcConfig(output[_GC], context);
  }
  if (output[_FV] != null) {
    contents[_FV] = de_ForwardedValues(output[_FV], context);
  }
  if (output[_MTTL] != null) {
    contents[_MTTL] = (0, import_smithy_client.strictParseLong)(output[_MTTL]);
  }
  if (output[_DTTL] != null) {
    contents[_DTTL] = (0, import_smithy_client.strictParseLong)(output[_DTTL]);
  }
  if (output[_MTTLa] != null) {
    contents[_MTTLa] = (0, import_smithy_client.strictParseLong)(output[_MTTLa]);
  }
  return contents;
}, "de_CacheBehavior");
var de_CacheBehaviorList = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_CacheBehavior(entry, context);
  });
}, "de_CacheBehaviorList");
var de_CacheBehaviors = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_Q] != null) {
    contents[_Q] = (0, import_smithy_client.strictParseInt32)(output[_Q]);
  }
  if (output.Items === "") {
    contents[_It] = [];
  } else if (output[_It] != null && output[_It][_CB] != null) {
    contents[_It] = de_CacheBehaviorList((0, import_smithy_client.getArrayIfSingleItem)(output[_It][_CB]), context);
  }
  return contents;
}, "de_CacheBehaviors");
var de_CachedMethods = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_Q] != null) {
    contents[_Q] = (0, import_smithy_client.strictParseInt32)(output[_Q]);
  }
  if (output.Items === "") {
    contents[_It] = [];
  } else if (output[_It] != null && output[_It][_Met] != null) {
    contents[_It] = de_MethodsList((0, import_smithy_client.getArrayIfSingleItem)(output[_It][_Met]), context);
  }
  return contents;
}, "de_CachedMethods");
var de_CachePolicy = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_Id] != null) {
    contents[_Id] = (0, import_smithy_client.expectString)(output[_Id]);
  }
  if (output[_LMT] != null) {
    contents[_LMT] = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseRfc3339DateTimeWithOffset)(output[_LMT]));
  }
  if (output[_CPC] != null) {
    contents[_CPC] = de_CachePolicyConfig(output[_CPC], context);
  }
  return contents;
}, "de_CachePolicy");
var de_CachePolicyConfig = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_Co] != null) {
    contents[_Co] = (0, import_smithy_client.expectString)(output[_Co]);
  }
  if (output[_N] != null) {
    contents[_N] = (0, import_smithy_client.expectString)(output[_N]);
  }
  if (output[_DTTL] != null) {
    contents[_DTTL] = (0, import_smithy_client.strictParseLong)(output[_DTTL]);
  }
  if (output[_MTTLa] != null) {
    contents[_MTTLa] = (0, import_smithy_client.strictParseLong)(output[_MTTLa]);
  }
  if (output[_MTTL] != null) {
    contents[_MTTL] = (0, import_smithy_client.strictParseLong)(output[_MTTL]);
  }
  if (output[_PICKAFTO] != null) {
    contents[_PICKAFTO] = de_ParametersInCacheKeyAndForwardedToOrigin(output[_PICKAFTO], context);
  }
  return contents;
}, "de_CachePolicyConfig");
var de_CachePolicyCookiesConfig = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_CBo] != null) {
    contents[_CBo] = (0, import_smithy_client.expectString)(output[_CBo]);
  }
  if (output[_Coo] != null) {
    contents[_Coo] = de_CookieNames(output[_Coo], context);
  }
  return contents;
}, "de_CachePolicyCookiesConfig");
var de_CachePolicyHeadersConfig = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_HB] != null) {
    contents[_HB] = (0, import_smithy_client.expectString)(output[_HB]);
  }
  if (output[_He] != null) {
    contents[_He] = de_Headers(output[_He], context);
  }
  return contents;
}, "de_CachePolicyHeadersConfig");
var de_CachePolicyList = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_NM] != null) {
    contents[_NM] = (0, import_smithy_client.expectString)(output[_NM]);
  }
  if (output[_MI] != null) {
    contents[_MI] = (0, import_smithy_client.strictParseInt32)(output[_MI]);
  }
  if (output[_Q] != null) {
    contents[_Q] = (0, import_smithy_client.strictParseInt32)(output[_Q]);
  }
  if (output.Items === "") {
    contents[_It] = [];
  } else if (output[_It] != null && output[_It][_CPS] != null) {
    contents[_It] = de_CachePolicySummaryList((0, import_smithy_client.getArrayIfSingleItem)(output[_It][_CPS]), context);
  }
  return contents;
}, "de_CachePolicyList");
var de_CachePolicyQueryStringsConfig = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_QSB] != null) {
    contents[_QSB] = (0, import_smithy_client.expectString)(output[_QSB]);
  }
  if (output[_QS] != null) {
    contents[_QS] = de_QueryStringNames(output[_QS], context);
  }
  return contents;
}, "de_CachePolicyQueryStringsConfig");
var de_CachePolicySummary = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_Ty] != null) {
    contents[_Ty] = (0, import_smithy_client.expectString)(output[_Ty]);
  }
  if (output[_CPa] != null) {
    contents[_CPa] = de_CachePolicy(output[_CPa], context);
  }
  return contents;
}, "de_CachePolicySummary");
var de_CachePolicySummaryList = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_CachePolicySummary(entry, context);
  });
}, "de_CachePolicySummaryList");
var de_Certificate = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_Ar] != null) {
    contents[_Ar] = (0, import_smithy_client.expectString)(output[_Ar]);
  }
  return contents;
}, "de_Certificate");
var de_CloudFrontOriginAccessIdentity = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_Id] != null) {
    contents[_Id] = (0, import_smithy_client.expectString)(output[_Id]);
  }
  if (output[_SCUI] != null) {
    contents[_SCUI] = (0, import_smithy_client.expectString)(output[_SCUI]);
  }
  if (output[_CFOAIC] != null) {
    contents[_CFOAIC] = de_CloudFrontOriginAccessIdentityConfig(output[_CFOAIC], context);
  }
  return contents;
}, "de_CloudFrontOriginAccessIdentity");
var de_CloudFrontOriginAccessIdentityConfig = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_CR] != null) {
    contents[_CR] = (0, import_smithy_client.expectString)(output[_CR]);
  }
  if (output[_Co] != null) {
    contents[_Co] = (0, import_smithy_client.expectString)(output[_Co]);
  }
  return contents;
}, "de_CloudFrontOriginAccessIdentityConfig");
var de_CloudFrontOriginAccessIdentityList = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_M] != null) {
    contents[_M] = (0, import_smithy_client.expectString)(output[_M]);
  }
  if (output[_NM] != null) {
    contents[_NM] = (0, import_smithy_client.expectString)(output[_NM]);
  }
  if (output[_MI] != null) {
    contents[_MI] = (0, import_smithy_client.strictParseInt32)(output[_MI]);
  }
  if (output[_IT] != null) {
    contents[_IT] = (0, import_smithy_client.parseBoolean)(output[_IT]);
  }
  if (output[_Q] != null) {
    contents[_Q] = (0, import_smithy_client.strictParseInt32)(output[_Q]);
  }
  if (output.Items === "") {
    contents[_It] = [];
  } else if (output[_It] != null && output[_It][_CFOAIS] != null) {
    contents[_It] = de_CloudFrontOriginAccessIdentitySummaryList((0, import_smithy_client.getArrayIfSingleItem)(output[_It][_CFOAIS]), context);
  }
  return contents;
}, "de_CloudFrontOriginAccessIdentityList");
var de_CloudFrontOriginAccessIdentitySummary = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_Id] != null) {
    contents[_Id] = (0, import_smithy_client.expectString)(output[_Id]);
  }
  if (output[_SCUI] != null) {
    contents[_SCUI] = (0, import_smithy_client.expectString)(output[_SCUI]);
  }
  if (output[_Co] != null) {
    contents[_Co] = (0, import_smithy_client.expectString)(output[_Co]);
  }
  return contents;
}, "de_CloudFrontOriginAccessIdentitySummary");
var de_CloudFrontOriginAccessIdentitySummaryList = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_CloudFrontOriginAccessIdentitySummary(entry, context);
  });
}, "de_CloudFrontOriginAccessIdentitySummaryList");
var de_ConflictingAlias = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_A] != null) {
    contents[_A] = (0, import_smithy_client.expectString)(output[_A]);
  }
  if (output[_DI] != null) {
    contents[_DI] = (0, import_smithy_client.expectString)(output[_DI]);
  }
  if (output[_AIc] != null) {
    contents[_AIc] = (0, import_smithy_client.expectString)(output[_AIc]);
  }
  return contents;
}, "de_ConflictingAlias");
var de_ConflictingAliases = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_ConflictingAlias(entry, context);
  });
}, "de_ConflictingAliases");
var de_ConflictingAliasesList = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_NM] != null) {
    contents[_NM] = (0, import_smithy_client.expectString)(output[_NM]);
  }
  if (output[_MI] != null) {
    contents[_MI] = (0, import_smithy_client.strictParseInt32)(output[_MI]);
  }
  if (output[_Q] != null) {
    contents[_Q] = (0, import_smithy_client.strictParseInt32)(output[_Q]);
  }
  if (output.Items === "") {
    contents[_It] = [];
  } else if (output[_It] != null && output[_It][_CAon] != null) {
    contents[_It] = de_ConflictingAliases((0, import_smithy_client.getArrayIfSingleItem)(output[_It][_CAon]), context);
  }
  return contents;
}, "de_ConflictingAliasesList");
var de_ConnectionGroup = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_Id] != null) {
    contents[_Id] = (0, import_smithy_client.expectString)(output[_Id]);
  }
  if (output[_N] != null) {
    contents[_N] = (0, import_smithy_client.expectString)(output[_N]);
  }
  if (output[_Ar] != null) {
    contents[_Ar] = (0, import_smithy_client.expectString)(output[_Ar]);
  }
  if (output[_CTr] != null) {
    contents[_CTr] = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseRfc3339DateTimeWithOffset)(output[_CTr]));
  }
  if (output[_LMT] != null) {
    contents[_LMT] = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseRfc3339DateTimeWithOffset)(output[_LMT]));
  }
  if (output[_T] != null) {
    contents[_T] = de_Tags(output[_T], context);
  }
  if (output[_IE] != null) {
    contents[_IE] = (0, import_smithy_client.parseBoolean)(output[_IE]);
  }
  if (output[_RE] != null) {
    contents[_RE] = (0, import_smithy_client.expectString)(output[_RE]);
  }
  if (output[_AILI] != null) {
    contents[_AILI] = (0, import_smithy_client.expectString)(output[_AILI]);
  }
  if (output[_Sta] != null) {
    contents[_Sta] = (0, import_smithy_client.expectString)(output[_Sta]);
  }
  if (output[_E] != null) {
    contents[_E] = (0, import_smithy_client.parseBoolean)(output[_E]);
  }
  if (output[_ID] != null) {
    contents[_ID] = (0, import_smithy_client.parseBoolean)(output[_ID]);
  }
  return contents;
}, "de_ConnectionGroup");
var de_ConnectionGroupSummary = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_Id] != null) {
    contents[_Id] = (0, import_smithy_client.expectString)(output[_Id]);
  }
  if (output[_N] != null) {
    contents[_N] = (0, import_smithy_client.expectString)(output[_N]);
  }
  if (output[_Ar] != null) {
    contents[_Ar] = (0, import_smithy_client.expectString)(output[_Ar]);
  }
  if (output[_RE] != null) {
    contents[_RE] = (0, import_smithy_client.expectString)(output[_RE]);
  }
  if (output[_CTr] != null) {
    contents[_CTr] = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseRfc3339DateTimeWithOffset)(output[_CTr]));
  }
  if (output[_LMT] != null) {
    contents[_LMT] = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseRfc3339DateTimeWithOffset)(output[_LMT]));
  }
  if (output[_ET] != null) {
    contents[_ET] = (0, import_smithy_client.expectString)(output[_ET]);
  }
  if (output[_AILI] != null) {
    contents[_AILI] = (0, import_smithy_client.expectString)(output[_AILI]);
  }
  if (output[_E] != null) {
    contents[_E] = (0, import_smithy_client.parseBoolean)(output[_E]);
  }
  if (output[_Sta] != null) {
    contents[_Sta] = (0, import_smithy_client.expectString)(output[_Sta]);
  }
  if (output[_ID] != null) {
    contents[_ID] = (0, import_smithy_client.parseBoolean)(output[_ID]);
  }
  return contents;
}, "de_ConnectionGroupSummary");
var de_ConnectionGroupSummaryList = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_ConnectionGroupSummary(entry, context);
  });
}, "de_ConnectionGroupSummaryList");
var de_ContentTypeProfile = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_Fo] != null) {
    contents[_Fo] = (0, import_smithy_client.expectString)(output[_Fo]);
  }
  if (output[_PI] != null) {
    contents[_PI] = (0, import_smithy_client.expectString)(output[_PI]);
  }
  if (output[_CT] != null) {
    contents[_CT] = (0, import_smithy_client.expectString)(output[_CT]);
  }
  return contents;
}, "de_ContentTypeProfile");
var de_ContentTypeProfileConfig = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_FWCTIU] != null) {
    contents[_FWCTIU] = (0, import_smithy_client.parseBoolean)(output[_FWCTIU]);
  }
  if (output[_CTPo] != null) {
    contents[_CTPo] = de_ContentTypeProfiles(output[_CTPo], context);
  }
  return contents;
}, "de_ContentTypeProfileConfig");
var de_ContentTypeProfileList = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_ContentTypeProfile(entry, context);
  });
}, "de_ContentTypeProfileList");
var de_ContentTypeProfiles = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_Q] != null) {
    contents[_Q] = (0, import_smithy_client.strictParseInt32)(output[_Q]);
  }
  if (output.Items === "") {
    contents[_It] = [];
  } else if (output[_It] != null && output[_It][_CTP] != null) {
    contents[_It] = de_ContentTypeProfileList((0, import_smithy_client.getArrayIfSingleItem)(output[_It][_CTP]), context);
  }
  return contents;
}, "de_ContentTypeProfiles");
var de_ContinuousDeploymentPolicy = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_Id] != null) {
    contents[_Id] = (0, import_smithy_client.expectString)(output[_Id]);
  }
  if (output[_LMT] != null) {
    contents[_LMT] = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseRfc3339DateTimeWithOffset)(output[_LMT]));
  }
  if (output[_CDPC] != null) {
    contents[_CDPC] = de_ContinuousDeploymentPolicyConfig(output[_CDPC], context);
  }
  return contents;
}, "de_ContinuousDeploymentPolicy");
var de_ContinuousDeploymentPolicyConfig = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_SDDN] != null) {
    contents[_SDDN] = de_StagingDistributionDnsNames(output[_SDDN], context);
  }
  if (output[_E] != null) {
    contents[_E] = (0, import_smithy_client.parseBoolean)(output[_E]);
  }
  if (output[_TC] != null) {
    contents[_TC] = de_TrafficConfig(output[_TC], context);
  }
  return contents;
}, "de_ContinuousDeploymentPolicyConfig");
var de_ContinuousDeploymentPolicyList = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_NM] != null) {
    contents[_NM] = (0, import_smithy_client.expectString)(output[_NM]);
  }
  if (output[_MI] != null) {
    contents[_MI] = (0, import_smithy_client.strictParseInt32)(output[_MI]);
  }
  if (output[_Q] != null) {
    contents[_Q] = (0, import_smithy_client.strictParseInt32)(output[_Q]);
  }
  if (output.Items === "") {
    contents[_It] = [];
  } else if (output[_It] != null && output[_It][_CDPS] != null) {
    contents[_It] = de_ContinuousDeploymentPolicySummaryList((0, import_smithy_client.getArrayIfSingleItem)(output[_It][_CDPS]), context);
  }
  return contents;
}, "de_ContinuousDeploymentPolicyList");
var de_ContinuousDeploymentPolicySummary = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_CDP] != null) {
    contents[_CDP] = de_ContinuousDeploymentPolicy(output[_CDP], context);
  }
  return contents;
}, "de_ContinuousDeploymentPolicySummary");
var de_ContinuousDeploymentPolicySummaryList = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_ContinuousDeploymentPolicySummary(entry, context);
  });
}, "de_ContinuousDeploymentPolicySummaryList");
var de_ContinuousDeploymentSingleHeaderConfig = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_H] != null) {
    contents[_H] = (0, import_smithy_client.expectString)(output[_H]);
  }
  if (output[_V] != null) {
    contents[_V] = (0, import_smithy_client.expectString)(output[_V]);
  }
  return contents;
}, "de_ContinuousDeploymentSingleHeaderConfig");
var de_ContinuousDeploymentSingleWeightConfig = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_W] != null) {
    contents[_W] = (0, import_smithy_client.strictParseFloat)(output[_W]);
  }
  if (output[_SSC] != null) {
    contents[_SSC] = de_SessionStickinessConfig(output[_SSC], context);
  }
  return contents;
}, "de_ContinuousDeploymentSingleWeightConfig");
var de_CookieNameList = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return (0, import_smithy_client.expectString)(entry);
  });
}, "de_CookieNameList");
var de_CookieNames = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_Q] != null) {
    contents[_Q] = (0, import_smithy_client.strictParseInt32)(output[_Q]);
  }
  if (output.Items === "") {
    contents[_It] = [];
  } else if (output[_It] != null && output[_It][_N] != null) {
    contents[_It] = de_CookieNameList((0, import_smithy_client.getArrayIfSingleItem)(output[_It][_N]), context);
  }
  return contents;
}, "de_CookieNames");
var de_CookiePreference = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_For] != null) {
    contents[_For] = (0, import_smithy_client.expectString)(output[_For]);
  }
  if (output[_WN] != null) {
    contents[_WN] = de_CookieNames(output[_WN], context);
  }
  return contents;
}, "de_CookiePreference");
var de_CustomErrorResponse = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_EC] != null) {
    contents[_EC] = (0, import_smithy_client.strictParseInt32)(output[_EC]);
  }
  if (output[_RPP] != null) {
    contents[_RPP] = (0, import_smithy_client.expectString)(output[_RPP]);
  }
  if (output[_RC] != null) {
    contents[_RC] = (0, import_smithy_client.expectString)(output[_RC]);
  }
  if (output[_ECMTTL] != null) {
    contents[_ECMTTL] = (0, import_smithy_client.strictParseLong)(output[_ECMTTL]);
  }
  return contents;
}, "de_CustomErrorResponse");
var de_CustomErrorResponseList = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_CustomErrorResponse(entry, context);
  });
}, "de_CustomErrorResponseList");
var de_CustomErrorResponses = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_Q] != null) {
    contents[_Q] = (0, import_smithy_client.strictParseInt32)(output[_Q]);
  }
  if (output.Items === "") {
    contents[_It] = [];
  } else if (output[_It] != null && output[_It][_CER] != null) {
    contents[_It] = de_CustomErrorResponseList((0, import_smithy_client.getArrayIfSingleItem)(output[_It][_CER]), context);
  }
  return contents;
}, "de_CustomErrorResponses");
var de_CustomHeaders = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_Q] != null) {
    contents[_Q] = (0, import_smithy_client.strictParseInt32)(output[_Q]);
  }
  if (output.Items === "") {
    contents[_It] = [];
  } else if (output[_It] != null && output[_It][_OCH] != null) {
    contents[_It] = de_OriginCustomHeadersList((0, import_smithy_client.getArrayIfSingleItem)(output[_It][_OCH]), context);
  }
  return contents;
}, "de_CustomHeaders");
var de_Customizations = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_WA] != null) {
    contents[_WA] = de_WebAclCustomization(output[_WA], context);
  }
  if (output[_Ce] != null) {
    contents[_Ce] = de_Certificate(output[_Ce], context);
  }
  if (output[_GR] != null) {
    contents[_GR] = de_GeoRestrictionCustomization(output[_GR], context);
  }
  return contents;
}, "de_Customizations");
var de_CustomOriginConfig = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_HTTPP] != null) {
    contents[_HTTPP] = (0, import_smithy_client.strictParseInt32)(output[_HTTPP]);
  }
  if (output[_HTTPSP] != null) {
    contents[_HTTPSP] = (0, import_smithy_client.strictParseInt32)(output[_HTTPSP]);
  }
  if (output[_OPP] != null) {
    contents[_OPP] = (0, import_smithy_client.expectString)(output[_OPP]);
  }
  if (output[_OSP] != null) {
    contents[_OSP] = de_OriginSslProtocols(output[_OSP], context);
  }
  if (output[_ORT] != null) {
    contents[_ORT] = (0, import_smithy_client.strictParseInt32)(output[_ORT]);
  }
  if (output[_OKT] != null) {
    contents[_OKT] = (0, import_smithy_client.strictParseInt32)(output[_OKT]);
  }
  return contents;
}, "de_CustomOriginConfig");
var de_DefaultCacheBehavior = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_TOI] != null) {
    contents[_TOI] = (0, import_smithy_client.expectString)(output[_TOI]);
  }
  if (output[_TS] != null) {
    contents[_TS] = de_TrustedSigners(output[_TS], context);
  }
  if (output[_TKG] != null) {
    contents[_TKG] = de_TrustedKeyGroups(output[_TKG], context);
  }
  if (output[_VPP] != null) {
    contents[_VPP] = (0, import_smithy_client.expectString)(output[_VPP]);
  }
  if (output[_AM] != null) {
    contents[_AM] = de_AllowedMethods(output[_AM], context);
  }
  if (output[_SS] != null) {
    contents[_SS] = (0, import_smithy_client.parseBoolean)(output[_SS]);
  }
  if (output[_Com] != null) {
    contents[_Com] = (0, import_smithy_client.parseBoolean)(output[_Com]);
  }
  if (output[_LFA] != null) {
    contents[_LFA] = de_LambdaFunctionAssociations(output[_LFA], context);
  }
  if (output[_FA] != null) {
    contents[_FA] = de_FunctionAssociations(output[_FA], context);
  }
  if (output[_FLEI] != null) {
    contents[_FLEI] = (0, import_smithy_client.expectString)(output[_FLEI]);
  }
  if (output[_RLCA] != null) {
    contents[_RLCA] = (0, import_smithy_client.expectString)(output[_RLCA]);
  }
  if (output[_CPI] != null) {
    contents[_CPI] = (0, import_smithy_client.expectString)(output[_CPI]);
  }
  if (output[_ORPI] != null) {
    contents[_ORPI] = (0, import_smithy_client.expectString)(output[_ORPI]);
  }
  if (output[_RHPI] != null) {
    contents[_RHPI] = (0, import_smithy_client.expectString)(output[_RHPI]);
  }
  if (output[_GC] != null) {
    contents[_GC] = de_GrpcConfig(output[_GC], context);
  }
  if (output[_FV] != null) {
    contents[_FV] = de_ForwardedValues(output[_FV], context);
  }
  if (output[_MTTL] != null) {
    contents[_MTTL] = (0, import_smithy_client.strictParseLong)(output[_MTTL]);
  }
  if (output[_DTTL] != null) {
    contents[_DTTL] = (0, import_smithy_client.strictParseLong)(output[_DTTL]);
  }
  if (output[_MTTLa] != null) {
    contents[_MTTLa] = (0, import_smithy_client.strictParseLong)(output[_MTTLa]);
  }
  return contents;
}, "de_DefaultCacheBehavior");
var de_Distribution = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_Id] != null) {
    contents[_Id] = (0, import_smithy_client.expectString)(output[_Id]);
  }
  if (output[_ARN] != null) {
    contents[_ARN] = (0, import_smithy_client.expectString)(output[_ARN]);
  }
  if (output[_Sta] != null) {
    contents[_Sta] = (0, import_smithy_client.expectString)(output[_Sta]);
  }
  if (output[_LMT] != null) {
    contents[_LMT] = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseRfc3339DateTimeWithOffset)(output[_LMT]));
  }
  if (output[_IPIB] != null) {
    contents[_IPIB] = (0, import_smithy_client.strictParseInt32)(output[_IPIB]);
  }
  if (output[_DN] != null) {
    contents[_DN] = (0, import_smithy_client.expectString)(output[_DN]);
  }
  if (output[_ATS] != null) {
    contents[_ATS] = de_ActiveTrustedSigners(output[_ATS], context);
  }
  if (output[_ATKG] != null) {
    contents[_ATKG] = de_ActiveTrustedKeyGroups(output[_ATKG], context);
  }
  if (output[_DCi] != null) {
    contents[_DCi] = de_DistributionConfig(output[_DCi], context);
  }
  if (output.AliasICPRecordals === "") {
    contents[_AICPR] = [];
  } else if (output[_AICPR] != null && output[_AICPR][_AICPRl] != null) {
    contents[_AICPR] = de_AliasICPRecordals((0, import_smithy_client.getArrayIfSingleItem)(output[_AICPR][_AICPRl]), context);
  }
  return contents;
}, "de_Distribution");
var de_DistributionConfig = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_CR] != null) {
    contents[_CR] = (0, import_smithy_client.expectString)(output[_CR]);
  }
  if (output[_Al] != null) {
    contents[_Al] = de_Aliases(output[_Al], context);
  }
  if (output[_DRO] != null) {
    contents[_DRO] = (0, import_smithy_client.expectString)(output[_DRO]);
  }
  if (output[_Ori] != null) {
    contents[_Ori] = de_Origins(output[_Ori], context);
  }
  if (output[_OG] != null) {
    contents[_OG] = de_OriginGroups(output[_OG], context);
  }
  if (output[_DCB] != null) {
    contents[_DCB] = de_DefaultCacheBehavior(output[_DCB], context);
  }
  if (output[_CBa] != null) {
    contents[_CBa] = de_CacheBehaviors(output[_CBa], context);
  }
  if (output[_CERu] != null) {
    contents[_CERu] = de_CustomErrorResponses(output[_CERu], context);
  }
  if (output[_Co] != null) {
    contents[_Co] = (0, import_smithy_client.expectString)(output[_Co]);
  }
  if (output[_Lo] != null) {
    contents[_Lo] = de_LoggingConfig(output[_Lo], context);
  }
  if (output[_PC] != null) {
    contents[_PC] = (0, import_smithy_client.expectString)(output[_PC]);
  }
  if (output[_E] != null) {
    contents[_E] = (0, import_smithy_client.parseBoolean)(output[_E]);
  }
  if (output[_VC] != null) {
    contents[_VC] = de_ViewerCertificate(output[_VC], context);
  }
  if (output[_Re] != null) {
    contents[_Re] = de_Restrictions(output[_Re], context);
  }
  if (output[_WACLI] != null) {
    contents[_WACLI] = (0, import_smithy_client.expectString)(output[_WACLI]);
  }
  if (output[_HV] != null) {
    contents[_HV] = (0, import_smithy_client.expectString)(output[_HV]);
  }
  if (output[_IIPVE] != null) {
    contents[_IIPVE] = (0, import_smithy_client.parseBoolean)(output[_IIPVE]);
  }
  if (output[_CDPI] != null) {
    contents[_CDPI] = (0, import_smithy_client.expectString)(output[_CDPI]);
  }
  if (output[_S] != null) {
    contents[_S] = (0, import_smithy_client.parseBoolean)(output[_S]);
  }
  if (output[_AILI] != null) {
    contents[_AILI] = (0, import_smithy_client.expectString)(output[_AILI]);
  }
  if (output[_TCe] != null) {
    contents[_TCe] = de_TenantConfig(output[_TCe], context);
  }
  if (output[_CMo] != null) {
    contents[_CMo] = (0, import_smithy_client.expectString)(output[_CMo]);
  }
  return contents;
}, "de_DistributionConfig");
var de_DistributionIdList = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_M] != null) {
    contents[_M] = (0, import_smithy_client.expectString)(output[_M]);
  }
  if (output[_NM] != null) {
    contents[_NM] = (0, import_smithy_client.expectString)(output[_NM]);
  }
  if (output[_MI] != null) {
    contents[_MI] = (0, import_smithy_client.strictParseInt32)(output[_MI]);
  }
  if (output[_IT] != null) {
    contents[_IT] = (0, import_smithy_client.parseBoolean)(output[_IT]);
  }
  if (output[_Q] != null) {
    contents[_Q] = (0, import_smithy_client.strictParseInt32)(output[_Q]);
  }
  if (output.Items === "") {
    contents[_It] = [];
  } else if (output[_It] != null && output[_It][_DI] != null) {
    contents[_It] = de_DistributionIdListSummary((0, import_smithy_client.getArrayIfSingleItem)(output[_It][_DI]), context);
  }
  return contents;
}, "de_DistributionIdList");
var de_DistributionIdListSummary = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return (0, import_smithy_client.expectString)(entry);
  });
}, "de_DistributionIdListSummary");
var de_DistributionList = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_M] != null) {
    contents[_M] = (0, import_smithy_client.expectString)(output[_M]);
  }
  if (output[_NM] != null) {
    contents[_NM] = (0, import_smithy_client.expectString)(output[_NM]);
  }
  if (output[_MI] != null) {
    contents[_MI] = (0, import_smithy_client.strictParseInt32)(output[_MI]);
  }
  if (output[_IT] != null) {
    contents[_IT] = (0, import_smithy_client.parseBoolean)(output[_IT]);
  }
  if (output[_Q] != null) {
    contents[_Q] = (0, import_smithy_client.strictParseInt32)(output[_Q]);
  }
  if (output.Items === "") {
    contents[_It] = [];
  } else if (output[_It] != null && output[_It][_DS] != null) {
    contents[_It] = de_DistributionSummaryList((0, import_smithy_client.getArrayIfSingleItem)(output[_It][_DS]), context);
  }
  return contents;
}, "de_DistributionList");
var de_DistributionSummary = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_Id] != null) {
    contents[_Id] = (0, import_smithy_client.expectString)(output[_Id]);
  }
  if (output[_ARN] != null) {
    contents[_ARN] = (0, import_smithy_client.expectString)(output[_ARN]);
  }
  if (output[_ET] != null) {
    contents[_ET] = (0, import_smithy_client.expectString)(output[_ET]);
  }
  if (output[_Sta] != null) {
    contents[_Sta] = (0, import_smithy_client.expectString)(output[_Sta]);
  }
  if (output[_LMT] != null) {
    contents[_LMT] = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseRfc3339DateTimeWithOffset)(output[_LMT]));
  }
  if (output[_DN] != null) {
    contents[_DN] = (0, import_smithy_client.expectString)(output[_DN]);
  }
  if (output[_Al] != null) {
    contents[_Al] = de_Aliases(output[_Al], context);
  }
  if (output[_Ori] != null) {
    contents[_Ori] = de_Origins(output[_Ori], context);
  }
  if (output[_OG] != null) {
    contents[_OG] = de_OriginGroups(output[_OG], context);
  }
  if (output[_DCB] != null) {
    contents[_DCB] = de_DefaultCacheBehavior(output[_DCB], context);
  }
  if (output[_CBa] != null) {
    contents[_CBa] = de_CacheBehaviors(output[_CBa], context);
  }
  if (output[_CERu] != null) {
    contents[_CERu] = de_CustomErrorResponses(output[_CERu], context);
  }
  if (output[_Co] != null) {
    contents[_Co] = (0, import_smithy_client.expectString)(output[_Co]);
  }
  if (output[_PC] != null) {
    contents[_PC] = (0, import_smithy_client.expectString)(output[_PC]);
  }
  if (output[_E] != null) {
    contents[_E] = (0, import_smithy_client.parseBoolean)(output[_E]);
  }
  if (output[_VC] != null) {
    contents[_VC] = de_ViewerCertificate(output[_VC], context);
  }
  if (output[_Re] != null) {
    contents[_Re] = de_Restrictions(output[_Re], context);
  }
  if (output[_WACLI] != null) {
    contents[_WACLI] = (0, import_smithy_client.expectString)(output[_WACLI]);
  }
  if (output[_HV] != null) {
    contents[_HV] = (0, import_smithy_client.expectString)(output[_HV]);
  }
  if (output[_IIPVE] != null) {
    contents[_IIPVE] = (0, import_smithy_client.parseBoolean)(output[_IIPVE]);
  }
  if (output.AliasICPRecordals === "") {
    contents[_AICPR] = [];
  } else if (output[_AICPR] != null && output[_AICPR][_AICPRl] != null) {
    contents[_AICPR] = de_AliasICPRecordals((0, import_smithy_client.getArrayIfSingleItem)(output[_AICPR][_AICPRl]), context);
  }
  if (output[_S] != null) {
    contents[_S] = (0, import_smithy_client.parseBoolean)(output[_S]);
  }
  if (output[_CMo] != null) {
    contents[_CMo] = (0, import_smithy_client.expectString)(output[_CMo]);
  }
  if (output[_AILI] != null) {
    contents[_AILI] = (0, import_smithy_client.expectString)(output[_AILI]);
  }
  return contents;
}, "de_DistributionSummary");
var de_DistributionSummaryList = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_DistributionSummary(entry, context);
  });
}, "de_DistributionSummaryList");
var de_DistributionTenant = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_Id] != null) {
    contents[_Id] = (0, import_smithy_client.expectString)(output[_Id]);
  }
  if (output[_DI] != null) {
    contents[_DI] = (0, import_smithy_client.expectString)(output[_DI]);
  }
  if (output[_N] != null) {
    contents[_N] = (0, import_smithy_client.expectString)(output[_N]);
  }
  if (output[_Ar] != null) {
    contents[_Ar] = (0, import_smithy_client.expectString)(output[_Ar]);
  }
  if (output.Domains === "") {
    contents[_D] = [];
  } else if (output[_D] != null && output[_D][_m] != null) {
    contents[_D] = de_DomainResultList((0, import_smithy_client.getArrayIfSingleItem)(output[_D][_m]), context);
  }
  if (output[_T] != null) {
    contents[_T] = de_Tags(output[_T], context);
  }
  if (output[_C] != null) {
    contents[_C] = de_Customizations(output[_C], context);
  }
  if (output.Parameters === "") {
    contents[_P] = [];
  } else if (output[_P] != null && output[_P][_m] != null) {
    contents[_P] = de_Parameters((0, import_smithy_client.getArrayIfSingleItem)(output[_P][_m]), context);
  }
  if (output[_CGI] != null) {
    contents[_CGI] = (0, import_smithy_client.expectString)(output[_CGI]);
  }
  if (output[_CTr] != null) {
    contents[_CTr] = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseRfc3339DateTimeWithOffset)(output[_CTr]));
  }
  if (output[_LMT] != null) {
    contents[_LMT] = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseRfc3339DateTimeWithOffset)(output[_LMT]));
  }
  if (output[_E] != null) {
    contents[_E] = (0, import_smithy_client.parseBoolean)(output[_E]);
  }
  if (output[_Sta] != null) {
    contents[_Sta] = (0, import_smithy_client.expectString)(output[_Sta]);
  }
  return contents;
}, "de_DistributionTenant");
var de_DistributionTenantList = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_DistributionTenantSummary(entry, context);
  });
}, "de_DistributionTenantList");
var de_DistributionTenantSummary = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_Id] != null) {
    contents[_Id] = (0, import_smithy_client.expectString)(output[_Id]);
  }
  if (output[_DI] != null) {
    contents[_DI] = (0, import_smithy_client.expectString)(output[_DI]);
  }
  if (output[_N] != null) {
    contents[_N] = (0, import_smithy_client.expectString)(output[_N]);
  }
  if (output[_Ar] != null) {
    contents[_Ar] = (0, import_smithy_client.expectString)(output[_Ar]);
  }
  if (output.Domains === "") {
    contents[_D] = [];
  } else if (output[_D] != null && output[_D][_m] != null) {
    contents[_D] = de_DomainResultList((0, import_smithy_client.getArrayIfSingleItem)(output[_D][_m]), context);
  }
  if (output[_CGI] != null) {
    contents[_CGI] = (0, import_smithy_client.expectString)(output[_CGI]);
  }
  if (output[_C] != null) {
    contents[_C] = de_Customizations(output[_C], context);
  }
  if (output[_CTr] != null) {
    contents[_CTr] = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseRfc3339DateTimeWithOffset)(output[_CTr]));
  }
  if (output[_LMT] != null) {
    contents[_LMT] = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseRfc3339DateTimeWithOffset)(output[_LMT]));
  }
  if (output[_ET] != null) {
    contents[_ET] = (0, import_smithy_client.expectString)(output[_ET]);
  }
  if (output[_E] != null) {
    contents[_E] = (0, import_smithy_client.parseBoolean)(output[_E]);
  }
  if (output[_Sta] != null) {
    contents[_Sta] = (0, import_smithy_client.expectString)(output[_Sta]);
  }
  return contents;
}, "de_DistributionTenantSummary");
var de_DnsConfiguration = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_Do] != null) {
    contents[_Do] = (0, import_smithy_client.expectString)(output[_Do]);
  }
  if (output[_Sta] != null) {
    contents[_Sta] = (0, import_smithy_client.expectString)(output[_Sta]);
  }
  if (output[_Rea] != null) {
    contents[_Rea] = (0, import_smithy_client.expectString)(output[_Rea]);
  }
  return contents;
}, "de_DnsConfiguration");
var de_DnsConfigurationList = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_DnsConfiguration(entry, context);
  });
}, "de_DnsConfigurationList");
var de_DomainConflict = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_Do] != null) {
    contents[_Do] = (0, import_smithy_client.expectString)(output[_Do]);
  }
  if (output[_RTe] != null) {
    contents[_RTe] = (0, import_smithy_client.expectString)(output[_RTe]);
  }
  if (output[_RI] != null) {
    contents[_RI] = (0, import_smithy_client.expectString)(output[_RI]);
  }
  if (output[_AIc] != null) {
    contents[_AIc] = (0, import_smithy_client.expectString)(output[_AIc]);
  }
  return contents;
}, "de_DomainConflict");
var de_DomainConflictsList = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_DomainConflict(entry, context);
  });
}, "de_DomainConflictsList");
var de_DomainResult = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_Do] != null) {
    contents[_Do] = (0, import_smithy_client.expectString)(output[_Do]);
  }
  if (output[_Sta] != null) {
    contents[_Sta] = (0, import_smithy_client.expectString)(output[_Sta]);
  }
  return contents;
}, "de_DomainResult");
var de_DomainResultList = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_DomainResult(entry, context);
  });
}, "de_DomainResultList");
var de_EncryptionEntities = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_Q] != null) {
    contents[_Q] = (0, import_smithy_client.strictParseInt32)(output[_Q]);
  }
  if (output.Items === "") {
    contents[_It] = [];
  } else if (output[_It] != null && output[_It][_EEn] != null) {
    contents[_It] = de_EncryptionEntityList((0, import_smithy_client.getArrayIfSingleItem)(output[_It][_EEn]), context);
  }
  return contents;
}, "de_EncryptionEntities");
var de_EncryptionEntity = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_PKI] != null) {
    contents[_PKI] = (0, import_smithy_client.expectString)(output[_PKI]);
  }
  if (output[_PIr] != null) {
    contents[_PIr] = (0, import_smithy_client.expectString)(output[_PIr]);
  }
  if (output[_FP] != null) {
    contents[_FP] = de_FieldPatterns(output[_FP], context);
  }
  return contents;
}, "de_EncryptionEntity");
var de_EncryptionEntityList = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_EncryptionEntity(entry, context);
  });
}, "de_EncryptionEntityList");
var de_EndPoint = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_ST] != null) {
    contents[_ST] = (0, import_smithy_client.expectString)(output[_ST]);
  }
  if (output[_KSC] != null) {
    contents[_KSC] = de_KinesisStreamConfig(output[_KSC], context);
  }
  return contents;
}, "de_EndPoint");
var de_EndPointList = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_EndPoint(entry, context);
  });
}, "de_EndPointList");
var de_FieldLevelEncryption = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_Id] != null) {
    contents[_Id] = (0, import_smithy_client.expectString)(output[_Id]);
  }
  if (output[_LMT] != null) {
    contents[_LMT] = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseRfc3339DateTimeWithOffset)(output[_LMT]));
  }
  if (output[_FLEC] != null) {
    contents[_FLEC] = de_FieldLevelEncryptionConfig(output[_FLEC], context);
  }
  return contents;
}, "de_FieldLevelEncryption");
var de_FieldLevelEncryptionConfig = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_CR] != null) {
    contents[_CR] = (0, import_smithy_client.expectString)(output[_CR]);
  }
  if (output[_Co] != null) {
    contents[_Co] = (0, import_smithy_client.expectString)(output[_Co]);
  }
  if (output[_QAPC] != null) {
    contents[_QAPC] = de_QueryArgProfileConfig(output[_QAPC], context);
  }
  if (output[_CTPC] != null) {
    contents[_CTPC] = de_ContentTypeProfileConfig(output[_CTPC], context);
  }
  return contents;
}, "de_FieldLevelEncryptionConfig");
var de_FieldLevelEncryptionList = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_NM] != null) {
    contents[_NM] = (0, import_smithy_client.expectString)(output[_NM]);
  }
  if (output[_MI] != null) {
    contents[_MI] = (0, import_smithy_client.strictParseInt32)(output[_MI]);
  }
  if (output[_Q] != null) {
    contents[_Q] = (0, import_smithy_client.strictParseInt32)(output[_Q]);
  }
  if (output.Items === "") {
    contents[_It] = [];
  } else if (output[_It] != null && output[_It][_FLES] != null) {
    contents[_It] = de_FieldLevelEncryptionSummaryList((0, import_smithy_client.getArrayIfSingleItem)(output[_It][_FLES]), context);
  }
  return contents;
}, "de_FieldLevelEncryptionList");
var de_FieldLevelEncryptionProfile = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_Id] != null) {
    contents[_Id] = (0, import_smithy_client.expectString)(output[_Id]);
  }
  if (output[_LMT] != null) {
    contents[_LMT] = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseRfc3339DateTimeWithOffset)(output[_LMT]));
  }
  if (output[_FLEPC] != null) {
    contents[_FLEPC] = de_FieldLevelEncryptionProfileConfig(output[_FLEPC], context);
  }
  return contents;
}, "de_FieldLevelEncryptionProfile");
var de_FieldLevelEncryptionProfileConfig = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_N] != null) {
    contents[_N] = (0, import_smithy_client.expectString)(output[_N]);
  }
  if (output[_CR] != null) {
    contents[_CR] = (0, import_smithy_client.expectString)(output[_CR]);
  }
  if (output[_Co] != null) {
    contents[_Co] = (0, import_smithy_client.expectString)(output[_Co]);
  }
  if (output[_EE] != null) {
    contents[_EE] = de_EncryptionEntities(output[_EE], context);
  }
  return contents;
}, "de_FieldLevelEncryptionProfileConfig");
var de_FieldLevelEncryptionProfileList = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_NM] != null) {
    contents[_NM] = (0, import_smithy_client.expectString)(output[_NM]);
  }
  if (output[_MI] != null) {
    contents[_MI] = (0, import_smithy_client.strictParseInt32)(output[_MI]);
  }
  if (output[_Q] != null) {
    contents[_Q] = (0, import_smithy_client.strictParseInt32)(output[_Q]);
  }
  if (output.Items === "") {
    contents[_It] = [];
  } else if (output[_It] != null && output[_It][_FLEPS] != null) {
    contents[_It] = de_FieldLevelEncryptionProfileSummaryList((0, import_smithy_client.getArrayIfSingleItem)(output[_It][_FLEPS]), context);
  }
  return contents;
}, "de_FieldLevelEncryptionProfileList");
var de_FieldLevelEncryptionProfileSummary = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_Id] != null) {
    contents[_Id] = (0, import_smithy_client.expectString)(output[_Id]);
  }
  if (output[_LMT] != null) {
    contents[_LMT] = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseRfc3339DateTimeWithOffset)(output[_LMT]));
  }
  if (output[_N] != null) {
    contents[_N] = (0, import_smithy_client.expectString)(output[_N]);
  }
  if (output[_EE] != null) {
    contents[_EE] = de_EncryptionEntities(output[_EE], context);
  }
  if (output[_Co] != null) {
    contents[_Co] = (0, import_smithy_client.expectString)(output[_Co]);
  }
  return contents;
}, "de_FieldLevelEncryptionProfileSummary");
var de_FieldLevelEncryptionProfileSummaryList = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_FieldLevelEncryptionProfileSummary(entry, context);
  });
}, "de_FieldLevelEncryptionProfileSummaryList");
var de_FieldLevelEncryptionSummary = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_Id] != null) {
    contents[_Id] = (0, import_smithy_client.expectString)(output[_Id]);
  }
  if (output[_LMT] != null) {
    contents[_LMT] = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseRfc3339DateTimeWithOffset)(output[_LMT]));
  }
  if (output[_Co] != null) {
    contents[_Co] = (0, import_smithy_client.expectString)(output[_Co]);
  }
  if (output[_QAPC] != null) {
    contents[_QAPC] = de_QueryArgProfileConfig(output[_QAPC], context);
  }
  if (output[_CTPC] != null) {
    contents[_CTPC] = de_ContentTypeProfileConfig(output[_CTPC], context);
  }
  return contents;
}, "de_FieldLevelEncryptionSummary");
var de_FieldLevelEncryptionSummaryList = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_FieldLevelEncryptionSummary(entry, context);
  });
}, "de_FieldLevelEncryptionSummaryList");
var de_FieldList = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return (0, import_smithy_client.expectString)(entry);
  });
}, "de_FieldList");
var de_FieldPatternList = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return (0, import_smithy_client.expectString)(entry);
  });
}, "de_FieldPatternList");
var de_FieldPatterns = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_Q] != null) {
    contents[_Q] = (0, import_smithy_client.strictParseInt32)(output[_Q]);
  }
  if (output.Items === "") {
    contents[_It] = [];
  } else if (output[_It] != null && output[_It][_FPi] != null) {
    contents[_It] = de_FieldPatternList((0, import_smithy_client.getArrayIfSingleItem)(output[_It][_FPi]), context);
  }
  return contents;
}, "de_FieldPatterns");
var de_ForwardedValues = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_QSu] != null) {
    contents[_QSu] = (0, import_smithy_client.parseBoolean)(output[_QSu]);
  }
  if (output[_Coo] != null) {
    contents[_Coo] = de_CookiePreference(output[_Coo], context);
  }
  if (output[_He] != null) {
    contents[_He] = de_Headers(output[_He], context);
  }
  if (output[_QSCK] != null) {
    contents[_QSCK] = de_QueryStringCacheKeys(output[_QSCK], context);
  }
  return contents;
}, "de_ForwardedValues");
var de_FunctionAssociation = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_FARN] != null) {
    contents[_FARN] = (0, import_smithy_client.expectString)(output[_FARN]);
  }
  if (output[_ETv] != null) {
    contents[_ETv] = (0, import_smithy_client.expectString)(output[_ETv]);
  }
  return contents;
}, "de_FunctionAssociation");
var de_FunctionAssociationList = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_FunctionAssociation(entry, context);
  });
}, "de_FunctionAssociationList");
var de_FunctionAssociations = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_Q] != null) {
    contents[_Q] = (0, import_smithy_client.strictParseInt32)(output[_Q]);
  }
  if (output.Items === "") {
    contents[_It] = [];
  } else if (output[_It] != null && output[_It][_FAu] != null) {
    contents[_It] = de_FunctionAssociationList((0, import_smithy_client.getArrayIfSingleItem)(output[_It][_FAu]), context);
  }
  return contents;
}, "de_FunctionAssociations");
var de_FunctionConfig = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_Co] != null) {
    contents[_Co] = (0, import_smithy_client.expectString)(output[_Co]);
  }
  if (output[_Ru] != null) {
    contents[_Ru] = (0, import_smithy_client.expectString)(output[_Ru]);
  }
  if (output[_KVSA] != null) {
    contents[_KVSA] = de_KeyValueStoreAssociations(output[_KVSA], context);
  }
  return contents;
}, "de_FunctionConfig");
var de_FunctionExecutionLogList = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return (0, import_smithy_client.expectString)(entry);
  });
}, "de_FunctionExecutionLogList");
var de_FunctionList = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_NM] != null) {
    contents[_NM] = (0, import_smithy_client.expectString)(output[_NM]);
  }
  if (output[_MI] != null) {
    contents[_MI] = (0, import_smithy_client.strictParseInt32)(output[_MI]);
  }
  if (output[_Q] != null) {
    contents[_Q] = (0, import_smithy_client.strictParseInt32)(output[_Q]);
  }
  if (output.Items === "") {
    contents[_It] = [];
  } else if (output[_It] != null && output[_It][_FSu] != null) {
    contents[_It] = de_FunctionSummaryList((0, import_smithy_client.getArrayIfSingleItem)(output[_It][_FSu]), context);
  }
  return contents;
}, "de_FunctionList");
var de_FunctionMetadata = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_FARN] != null) {
    contents[_FARN] = (0, import_smithy_client.expectString)(output[_FARN]);
  }
  if (output[_St] != null) {
    contents[_St] = (0, import_smithy_client.expectString)(output[_St]);
  }
  if (output[_CTr] != null) {
    contents[_CTr] = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseRfc3339DateTimeWithOffset)(output[_CTr]));
  }
  if (output[_LMT] != null) {
    contents[_LMT] = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseRfc3339DateTimeWithOffset)(output[_LMT]));
  }
  return contents;
}, "de_FunctionMetadata");
var de_FunctionSummary = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_N] != null) {
    contents[_N] = (0, import_smithy_client.expectString)(output[_N]);
  }
  if (output[_Sta] != null) {
    contents[_Sta] = (0, import_smithy_client.expectString)(output[_Sta]);
  }
  if (output[_FCu] != null) {
    contents[_FCu] = de_FunctionConfig(output[_FCu], context);
  }
  if (output[_FM] != null) {
    contents[_FM] = de_FunctionMetadata(output[_FM], context);
  }
  return contents;
}, "de_FunctionSummary");
var de_FunctionSummaryList = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_FunctionSummary(entry, context);
  });
}, "de_FunctionSummaryList");
var de_GeoRestriction = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_RT] != null) {
    contents[_RT] = (0, import_smithy_client.expectString)(output[_RT]);
  }
  if (output[_Q] != null) {
    contents[_Q] = (0, import_smithy_client.strictParseInt32)(output[_Q]);
  }
  if (output.Items === "") {
    contents[_It] = [];
  } else if (output[_It] != null && output[_It][_L] != null) {
    contents[_It] = de_LocationList((0, import_smithy_client.getArrayIfSingleItem)(output[_It][_L]), context);
  }
  return contents;
}, "de_GeoRestriction");
var de_GeoRestrictionCustomization = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_RT] != null) {
    contents[_RT] = (0, import_smithy_client.expectString)(output[_RT]);
  }
  if (output.Locations === "") {
    contents[_Loc] = [];
  } else if (output[_Loc] != null && output[_Loc][_L] != null) {
    contents[_Loc] = de_LocationList((0, import_smithy_client.getArrayIfSingleItem)(output[_Loc][_L]), context);
  }
  return contents;
}, "de_GeoRestrictionCustomization");
var de_GrpcConfig = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_E] != null) {
    contents[_E] = (0, import_smithy_client.parseBoolean)(output[_E]);
  }
  return contents;
}, "de_GrpcConfig");
var de_HeaderList = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return (0, import_smithy_client.expectString)(entry);
  });
}, "de_HeaderList");
var de_Headers = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_Q] != null) {
    contents[_Q] = (0, import_smithy_client.strictParseInt32)(output[_Q]);
  }
  if (output.Items === "") {
    contents[_It] = [];
  } else if (output[_It] != null && output[_It][_N] != null) {
    contents[_It] = de_HeaderList((0, import_smithy_client.getArrayIfSingleItem)(output[_It][_N]), context);
  }
  return contents;
}, "de_Headers");
var de_Invalidation = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_Id] != null) {
    contents[_Id] = (0, import_smithy_client.expectString)(output[_Id]);
  }
  if (output[_Sta] != null) {
    contents[_Sta] = (0, import_smithy_client.expectString)(output[_Sta]);
  }
  if (output[_CTre] != null) {
    contents[_CTre] = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseRfc3339DateTimeWithOffset)(output[_CTre]));
  }
  if (output[_IB] != null) {
    contents[_IB] = de_InvalidationBatch(output[_IB], context);
  }
  return contents;
}, "de_Invalidation");
var de_InvalidationBatch = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_Pa] != null) {
    contents[_Pa] = de_Paths(output[_Pa], context);
  }
  if (output[_CR] != null) {
    contents[_CR] = (0, import_smithy_client.expectString)(output[_CR]);
  }
  return contents;
}, "de_InvalidationBatch");
var de_InvalidationList = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_M] != null) {
    contents[_M] = (0, import_smithy_client.expectString)(output[_M]);
  }
  if (output[_NM] != null) {
    contents[_NM] = (0, import_smithy_client.expectString)(output[_NM]);
  }
  if (output[_MI] != null) {
    contents[_MI] = (0, import_smithy_client.strictParseInt32)(output[_MI]);
  }
  if (output[_IT] != null) {
    contents[_IT] = (0, import_smithy_client.parseBoolean)(output[_IT]);
  }
  if (output[_Q] != null) {
    contents[_Q] = (0, import_smithy_client.strictParseInt32)(output[_Q]);
  }
  if (output.Items === "") {
    contents[_It] = [];
  } else if (output[_It] != null && output[_It][_ISnv] != null) {
    contents[_It] = de_InvalidationSummaryList((0, import_smithy_client.getArrayIfSingleItem)(output[_It][_ISnv]), context);
  }
  return contents;
}, "de_InvalidationList");
var de_InvalidationSummary = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_Id] != null) {
    contents[_Id] = (0, import_smithy_client.expectString)(output[_Id]);
  }
  if (output[_CTre] != null) {
    contents[_CTre] = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseRfc3339DateTimeWithOffset)(output[_CTre]));
  }
  if (output[_Sta] != null) {
    contents[_Sta] = (0, import_smithy_client.expectString)(output[_Sta]);
  }
  return contents;
}, "de_InvalidationSummary");
var de_InvalidationSummaryList = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_InvalidationSummary(entry, context);
  });
}, "de_InvalidationSummaryList");
var de_KeyGroup = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_Id] != null) {
    contents[_Id] = (0, import_smithy_client.expectString)(output[_Id]);
  }
  if (output[_LMT] != null) {
    contents[_LMT] = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseRfc3339DateTimeWithOffset)(output[_LMT]));
  }
  if (output[_KGC] != null) {
    contents[_KGC] = de_KeyGroupConfig(output[_KGC], context);
  }
  return contents;
}, "de_KeyGroup");
var de_KeyGroupConfig = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_N] != null) {
    contents[_N] = (0, import_smithy_client.expectString)(output[_N]);
  }
  if (output.Items === "") {
    contents[_It] = [];
  } else if (output[_It] != null && output[_It][_PK] != null) {
    contents[_It] = de_PublicKeyIdList((0, import_smithy_client.getArrayIfSingleItem)(output[_It][_PK]), context);
  }
  if (output[_Co] != null) {
    contents[_Co] = (0, import_smithy_client.expectString)(output[_Co]);
  }
  return contents;
}, "de_KeyGroupConfig");
var de_KeyGroupList = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_NM] != null) {
    contents[_NM] = (0, import_smithy_client.expectString)(output[_NM]);
  }
  if (output[_MI] != null) {
    contents[_MI] = (0, import_smithy_client.strictParseInt32)(output[_MI]);
  }
  if (output[_Q] != null) {
    contents[_Q] = (0, import_smithy_client.strictParseInt32)(output[_Q]);
  }
  if (output.Items === "") {
    contents[_It] = [];
  } else if (output[_It] != null && output[_It][_KGS] != null) {
    contents[_It] = de_KeyGroupSummaryList((0, import_smithy_client.getArrayIfSingleItem)(output[_It][_KGS]), context);
  }
  return contents;
}, "de_KeyGroupList");
var de_KeyGroupSummary = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_KG] != null) {
    contents[_KG] = de_KeyGroup(output[_KG], context);
  }
  return contents;
}, "de_KeyGroupSummary");
var de_KeyGroupSummaryList = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_KeyGroupSummary(entry, context);
  });
}, "de_KeyGroupSummaryList");
var de_KeyPairIdList = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return (0, import_smithy_client.expectString)(entry);
  });
}, "de_KeyPairIdList");
var de_KeyPairIds = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_Q] != null) {
    contents[_Q] = (0, import_smithy_client.strictParseInt32)(output[_Q]);
  }
  if (output.Items === "") {
    contents[_It] = [];
  } else if (output[_It] != null && output[_It][_KPI] != null) {
    contents[_It] = de_KeyPairIdList((0, import_smithy_client.getArrayIfSingleItem)(output[_It][_KPI]), context);
  }
  return contents;
}, "de_KeyPairIds");
var de_KeyValueStore = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_N] != null) {
    contents[_N] = (0, import_smithy_client.expectString)(output[_N]);
  }
  if (output[_Id] != null) {
    contents[_Id] = (0, import_smithy_client.expectString)(output[_Id]);
  }
  if (output[_Co] != null) {
    contents[_Co] = (0, import_smithy_client.expectString)(output[_Co]);
  }
  if (output[_ARN] != null) {
    contents[_ARN] = (0, import_smithy_client.expectString)(output[_ARN]);
  }
  if (output[_Sta] != null) {
    contents[_Sta] = (0, import_smithy_client.expectString)(output[_Sta]);
  }
  if (output[_LMT] != null) {
    contents[_LMT] = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseRfc3339DateTimeWithOffset)(output[_LMT]));
  }
  return contents;
}, "de_KeyValueStore");
var de_KeyValueStoreAssociation = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_KVSARN] != null) {
    contents[_KVSARN] = (0, import_smithy_client.expectString)(output[_KVSARN]);
  }
  return contents;
}, "de_KeyValueStoreAssociation");
var de_KeyValueStoreAssociationList = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_KeyValueStoreAssociation(entry, context);
  });
}, "de_KeyValueStoreAssociationList");
var de_KeyValueStoreAssociations = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_Q] != null) {
    contents[_Q] = (0, import_smithy_client.strictParseInt32)(output[_Q]);
  }
  if (output.Items === "") {
    contents[_It] = [];
  } else if (output[_It] != null && output[_It][_KVSAe] != null) {
    contents[_It] = de_KeyValueStoreAssociationList((0, import_smithy_client.getArrayIfSingleItem)(output[_It][_KVSAe]), context);
  }
  return contents;
}, "de_KeyValueStoreAssociations");
var de_KeyValueStoreList = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_NM] != null) {
    contents[_NM] = (0, import_smithy_client.expectString)(output[_NM]);
  }
  if (output[_MI] != null) {
    contents[_MI] = (0, import_smithy_client.strictParseInt32)(output[_MI]);
  }
  if (output[_Q] != null) {
    contents[_Q] = (0, import_smithy_client.strictParseInt32)(output[_Q]);
  }
  if (output.Items === "") {
    contents[_It] = [];
  } else if (output[_It] != null && output[_It][_KVS] != null) {
    contents[_It] = de_KeyValueStoreSummaryList((0, import_smithy_client.getArrayIfSingleItem)(output[_It][_KVS]), context);
  }
  return contents;
}, "de_KeyValueStoreList");
var de_KeyValueStoreSummaryList = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_KeyValueStore(entry, context);
  });
}, "de_KeyValueStoreSummaryList");
var de_KGKeyPairIds = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_KGI] != null) {
    contents[_KGI] = (0, import_smithy_client.expectString)(output[_KGI]);
  }
  if (output[_KPIe] != null) {
    contents[_KPIe] = de_KeyPairIds(output[_KPIe], context);
  }
  return contents;
}, "de_KGKeyPairIds");
var de_KGKeyPairIdsList = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_KGKeyPairIds(entry, context);
  });
}, "de_KGKeyPairIdsList");
var de_KinesisStreamConfig = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_RARN] != null) {
    contents[_RARN] = (0, import_smithy_client.expectString)(output[_RARN]);
  }
  if (output[_SARNt] != null) {
    contents[_SARNt] = (0, import_smithy_client.expectString)(output[_SARNt]);
  }
  return contents;
}, "de_KinesisStreamConfig");
var de_LambdaFunctionAssociation = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_LFARN] != null) {
    contents[_LFARN] = (0, import_smithy_client.expectString)(output[_LFARN]);
  }
  if (output[_ETv] != null) {
    contents[_ETv] = (0, import_smithy_client.expectString)(output[_ETv]);
  }
  if (output[_IBn] != null) {
    contents[_IBn] = (0, import_smithy_client.parseBoolean)(output[_IBn]);
  }
  return contents;
}, "de_LambdaFunctionAssociation");
var de_LambdaFunctionAssociationList = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_LambdaFunctionAssociation(entry, context);
  });
}, "de_LambdaFunctionAssociationList");
var de_LambdaFunctionAssociations = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_Q] != null) {
    contents[_Q] = (0, import_smithy_client.strictParseInt32)(output[_Q]);
  }
  if (output.Items === "") {
    contents[_It] = [];
  } else if (output[_It] != null && output[_It][_LFAa] != null) {
    contents[_It] = de_LambdaFunctionAssociationList((0, import_smithy_client.getArrayIfSingleItem)(output[_It][_LFAa]), context);
  }
  return contents;
}, "de_LambdaFunctionAssociations");
var de_LocationList = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return (0, import_smithy_client.expectString)(entry);
  });
}, "de_LocationList");
var de_LoggingConfig = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_E] != null) {
    contents[_E] = (0, import_smithy_client.parseBoolean)(output[_E]);
  }
  if (output[_ICn] != null) {
    contents[_ICn] = (0, import_smithy_client.parseBoolean)(output[_ICn]);
  }
  if (output[_B] != null) {
    contents[_B] = (0, import_smithy_client.expectString)(output[_B]);
  }
  if (output[_Pr] != null) {
    contents[_Pr] = (0, import_smithy_client.expectString)(output[_Pr]);
  }
  return contents;
}, "de_LoggingConfig");
var de_ManagedCertificateDetails = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_CA] != null) {
    contents[_CA] = (0, import_smithy_client.expectString)(output[_CA]);
  }
  if (output[_CSe] != null) {
    contents[_CSe] = (0, import_smithy_client.expectString)(output[_CSe]);
  }
  if (output[_VTH] != null) {
    contents[_VTH] = (0, import_smithy_client.expectString)(output[_VTH]);
  }
  if (output.ValidationTokenDetails === "") {
    contents[_VTD] = [];
  } else if (output[_VTD] != null && output[_VTD][_m] != null) {
    contents[_VTD] = de_ValidationTokenDetailList((0, import_smithy_client.getArrayIfSingleItem)(output[_VTD][_m]), context);
  }
  return contents;
}, "de_ManagedCertificateDetails");
var de_MethodsList = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return (0, import_smithy_client.expectString)(entry);
  });
}, "de_MethodsList");
var de_MonitoringSubscription = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_RMSC] != null) {
    contents[_RMSC] = de_RealtimeMetricsSubscriptionConfig(output[_RMSC], context);
  }
  return contents;
}, "de_MonitoringSubscription");
var de_Origin = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_Id] != null) {
    contents[_Id] = (0, import_smithy_client.expectString)(output[_Id]);
  }
  if (output[_DN] != null) {
    contents[_DN] = (0, import_smithy_client.expectString)(output[_DN]);
  }
  if (output[_OP] != null) {
    contents[_OP] = (0, import_smithy_client.expectString)(output[_OP]);
  }
  if (output[_CH] != null) {
    contents[_CH] = de_CustomHeaders(output[_CH], context);
  }
  if (output[_SOC] != null) {
    contents[_SOC] = de_S3OriginConfig(output[_SOC], context);
  }
  if (output[_COC] != null) {
    contents[_COC] = de_CustomOriginConfig(output[_COC], context);
  }
  if (output[_VOC] != null) {
    contents[_VOC] = de_VpcOriginConfig(output[_VOC], context);
  }
  if (output[_CAo] != null) {
    contents[_CAo] = (0, import_smithy_client.strictParseInt32)(output[_CAo]);
  }
  if (output[_CTon] != null) {
    contents[_CTon] = (0, import_smithy_client.strictParseInt32)(output[_CTon]);
  }
  if (output[_OS] != null) {
    contents[_OS] = de_OriginShield(output[_OS], context);
  }
  if (output[_OACI] != null) {
    contents[_OACI] = (0, import_smithy_client.expectString)(output[_OACI]);
  }
  return contents;
}, "de_Origin");
var de_OriginAccessControl = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_Id] != null) {
    contents[_Id] = (0, import_smithy_client.expectString)(output[_Id]);
  }
  if (output[_OACC] != null) {
    contents[_OACC] = de_OriginAccessControlConfig(output[_OACC], context);
  }
  return contents;
}, "de_OriginAccessControl");
var de_OriginAccessControlConfig = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_N] != null) {
    contents[_N] = (0, import_smithy_client.expectString)(output[_N]);
  }
  if (output[_De] != null) {
    contents[_De] = (0, import_smithy_client.expectString)(output[_De]);
  }
  if (output[_SP] != null) {
    contents[_SP] = (0, import_smithy_client.expectString)(output[_SP]);
  }
  if (output[_SB] != null) {
    contents[_SB] = (0, import_smithy_client.expectString)(output[_SB]);
  }
  if (output[_OACOT] != null) {
    contents[_OACOT] = (0, import_smithy_client.expectString)(output[_OACOT]);
  }
  return contents;
}, "de_OriginAccessControlConfig");
var de_OriginAccessControlList = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_M] != null) {
    contents[_M] = (0, import_smithy_client.expectString)(output[_M]);
  }
  if (output[_NM] != null) {
    contents[_NM] = (0, import_smithy_client.expectString)(output[_NM]);
  }
  if (output[_MI] != null) {
    contents[_MI] = (0, import_smithy_client.strictParseInt32)(output[_MI]);
  }
  if (output[_IT] != null) {
    contents[_IT] = (0, import_smithy_client.parseBoolean)(output[_IT]);
  }
  if (output[_Q] != null) {
    contents[_Q] = (0, import_smithy_client.strictParseInt32)(output[_Q]);
  }
  if (output.Items === "") {
    contents[_It] = [];
  } else if (output[_It] != null && output[_It][_OACS] != null) {
    contents[_It] = de_OriginAccessControlSummaryList((0, import_smithy_client.getArrayIfSingleItem)(output[_It][_OACS]), context);
  }
  return contents;
}, "de_OriginAccessControlList");
var de_OriginAccessControlSummary = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_Id] != null) {
    contents[_Id] = (0, import_smithy_client.expectString)(output[_Id]);
  }
  if (output[_De] != null) {
    contents[_De] = (0, import_smithy_client.expectString)(output[_De]);
  }
  if (output[_N] != null) {
    contents[_N] = (0, import_smithy_client.expectString)(output[_N]);
  }
  if (output[_SP] != null) {
    contents[_SP] = (0, import_smithy_client.expectString)(output[_SP]);
  }
  if (output[_SB] != null) {
    contents[_SB] = (0, import_smithy_client.expectString)(output[_SB]);
  }
  if (output[_OACOT] != null) {
    contents[_OACOT] = (0, import_smithy_client.expectString)(output[_OACOT]);
  }
  return contents;
}, "de_OriginAccessControlSummary");
var de_OriginAccessControlSummaryList = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_OriginAccessControlSummary(entry, context);
  });
}, "de_OriginAccessControlSummaryList");
var de_OriginCustomHeader = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_HN] != null) {
    contents[_HN] = (0, import_smithy_client.expectString)(output[_HN]);
  }
  if (output[_HVe] != null) {
    contents[_HVe] = (0, import_smithy_client.expectString)(output[_HVe]);
  }
  return contents;
}, "de_OriginCustomHeader");
var de_OriginCustomHeadersList = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_OriginCustomHeader(entry, context);
  });
}, "de_OriginCustomHeadersList");
var de_OriginGroup = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_Id] != null) {
    contents[_Id] = (0, import_smithy_client.expectString)(output[_Id]);
  }
  if (output[_FCa] != null) {
    contents[_FCa] = de_OriginGroupFailoverCriteria(output[_FCa], context);
  }
  if (output[_Mem] != null) {
    contents[_Mem] = de_OriginGroupMembers(output[_Mem], context);
  }
  if (output[_SC] != null) {
    contents[_SC] = (0, import_smithy_client.expectString)(output[_SC]);
  }
  return contents;
}, "de_OriginGroup");
var de_OriginGroupFailoverCriteria = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_SCt] != null) {
    contents[_SCt] = de_StatusCodes(output[_SCt], context);
  }
  return contents;
}, "de_OriginGroupFailoverCriteria");
var de_OriginGroupList = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_OriginGroup(entry, context);
  });
}, "de_OriginGroupList");
var de_OriginGroupMember = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_OI] != null) {
    contents[_OI] = (0, import_smithy_client.expectString)(output[_OI]);
  }
  return contents;
}, "de_OriginGroupMember");
var de_OriginGroupMemberList = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_OriginGroupMember(entry, context);
  });
}, "de_OriginGroupMemberList");
var de_OriginGroupMembers = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_Q] != null) {
    contents[_Q] = (0, import_smithy_client.strictParseInt32)(output[_Q]);
  }
  if (output.Items === "") {
    contents[_It] = [];
  } else if (output[_It] != null && output[_It][_OGM] != null) {
    contents[_It] = de_OriginGroupMemberList((0, import_smithy_client.getArrayIfSingleItem)(output[_It][_OGM]), context);
  }
  return contents;
}, "de_OriginGroupMembers");
var de_OriginGroups = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_Q] != null) {
    contents[_Q] = (0, import_smithy_client.strictParseInt32)(output[_Q]);
  }
  if (output.Items === "") {
    contents[_It] = [];
  } else if (output[_It] != null && output[_It][_OGr] != null) {
    contents[_It] = de_OriginGroupList((0, import_smithy_client.getArrayIfSingleItem)(output[_It][_OGr]), context);
  }
  return contents;
}, "de_OriginGroups");
var de_OriginList = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_Origin(entry, context);
  });
}, "de_OriginList");
var de_OriginRequestPolicy = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_Id] != null) {
    contents[_Id] = (0, import_smithy_client.expectString)(output[_Id]);
  }
  if (output[_LMT] != null) {
    contents[_LMT] = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseRfc3339DateTimeWithOffset)(output[_LMT]));
  }
  if (output[_ORPC] != null) {
    contents[_ORPC] = de_OriginRequestPolicyConfig(output[_ORPC], context);
  }
  return contents;
}, "de_OriginRequestPolicy");
var de_OriginRequestPolicyConfig = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_Co] != null) {
    contents[_Co] = (0, import_smithy_client.expectString)(output[_Co]);
  }
  if (output[_N] != null) {
    contents[_N] = (0, import_smithy_client.expectString)(output[_N]);
  }
  if (output[_HC] != null) {
    contents[_HC] = de_OriginRequestPolicyHeadersConfig(output[_HC], context);
  }
  if (output[_CC] != null) {
    contents[_CC] = de_OriginRequestPolicyCookiesConfig(output[_CC], context);
  }
  if (output[_QSC] != null) {
    contents[_QSC] = de_OriginRequestPolicyQueryStringsConfig(output[_QSC], context);
  }
  return contents;
}, "de_OriginRequestPolicyConfig");
var de_OriginRequestPolicyCookiesConfig = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_CBo] != null) {
    contents[_CBo] = (0, import_smithy_client.expectString)(output[_CBo]);
  }
  if (output[_Coo] != null) {
    contents[_Coo] = de_CookieNames(output[_Coo], context);
  }
  return contents;
}, "de_OriginRequestPolicyCookiesConfig");
var de_OriginRequestPolicyHeadersConfig = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_HB] != null) {
    contents[_HB] = (0, import_smithy_client.expectString)(output[_HB]);
  }
  if (output[_He] != null) {
    contents[_He] = de_Headers(output[_He], context);
  }
  return contents;
}, "de_OriginRequestPolicyHeadersConfig");
var de_OriginRequestPolicyList = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_NM] != null) {
    contents[_NM] = (0, import_smithy_client.expectString)(output[_NM]);
  }
  if (output[_MI] != null) {
    contents[_MI] = (0, import_smithy_client.strictParseInt32)(output[_MI]);
  }
  if (output[_Q] != null) {
    contents[_Q] = (0, import_smithy_client.strictParseInt32)(output[_Q]);
  }
  if (output.Items === "") {
    contents[_It] = [];
  } else if (output[_It] != null && output[_It][_ORPS] != null) {
    contents[_It] = de_OriginRequestPolicySummaryList((0, import_smithy_client.getArrayIfSingleItem)(output[_It][_ORPS]), context);
  }
  return contents;
}, "de_OriginRequestPolicyList");
var de_OriginRequestPolicyQueryStringsConfig = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_QSB] != null) {
    contents[_QSB] = (0, import_smithy_client.expectString)(output[_QSB]);
  }
  if (output[_QS] != null) {
    contents[_QS] = de_QueryStringNames(output[_QS], context);
  }
  return contents;
}, "de_OriginRequestPolicyQueryStringsConfig");
var de_OriginRequestPolicySummary = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_Ty] != null) {
    contents[_Ty] = (0, import_smithy_client.expectString)(output[_Ty]);
  }
  if (output[_ORP] != null) {
    contents[_ORP] = de_OriginRequestPolicy(output[_ORP], context);
  }
  return contents;
}, "de_OriginRequestPolicySummary");
var de_OriginRequestPolicySummaryList = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_OriginRequestPolicySummary(entry, context);
  });
}, "de_OriginRequestPolicySummaryList");
var de_Origins = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_Q] != null) {
    contents[_Q] = (0, import_smithy_client.strictParseInt32)(output[_Q]);
  }
  if (output.Items === "") {
    contents[_It] = [];
  } else if (output[_It] != null && output[_It][_Or] != null) {
    contents[_It] = de_OriginList((0, import_smithy_client.getArrayIfSingleItem)(output[_It][_Or]), context);
  }
  return contents;
}, "de_Origins");
var de_OriginShield = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_E] != null) {
    contents[_E] = (0, import_smithy_client.parseBoolean)(output[_E]);
  }
  if (output[_OSR] != null) {
    contents[_OSR] = (0, import_smithy_client.expectString)(output[_OSR]);
  }
  return contents;
}, "de_OriginShield");
var de_OriginSslProtocols = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_Q] != null) {
    contents[_Q] = (0, import_smithy_client.strictParseInt32)(output[_Q]);
  }
  if (output.Items === "") {
    contents[_It] = [];
  } else if (output[_It] != null && output[_It][_SPs] != null) {
    contents[_It] = de_SslProtocolsList((0, import_smithy_client.getArrayIfSingleItem)(output[_It][_SPs]), context);
  }
  return contents;
}, "de_OriginSslProtocols");
var de_Parameter = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_N] != null) {
    contents[_N] = (0, import_smithy_client.expectString)(output[_N]);
  }
  if (output[_V] != null) {
    contents[_V] = (0, import_smithy_client.expectString)(output[_V]);
  }
  return contents;
}, "de_Parameter");
var de_ParameterDefinition = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_N] != null) {
    contents[_N] = (0, import_smithy_client.expectString)(output[_N]);
  }
  if (output[_Def] != null) {
    contents[_Def] = de_ParameterDefinitionSchema(output[_Def], context);
  }
  return contents;
}, "de_ParameterDefinition");
var de_ParameterDefinitions = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_ParameterDefinition(entry, context);
  });
}, "de_ParameterDefinitions");
var de_ParameterDefinitionSchema = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_SSt] != null) {
    contents[_SSt] = de_StringSchemaConfig(output[_SSt], context);
  }
  return contents;
}, "de_ParameterDefinitionSchema");
var de_Parameters = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_Parameter(entry, context);
  });
}, "de_Parameters");
var de_ParametersInCacheKeyAndForwardedToOrigin = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_EAEG] != null) {
    contents[_EAEG] = (0, import_smithy_client.parseBoolean)(output[_EAEG]);
  }
  if (output[_EAEB] != null) {
    contents[_EAEB] = (0, import_smithy_client.parseBoolean)(output[_EAEB]);
  }
  if (output[_HC] != null) {
    contents[_HC] = de_CachePolicyHeadersConfig(output[_HC], context);
  }
  if (output[_CC] != null) {
    contents[_CC] = de_CachePolicyCookiesConfig(output[_CC], context);
  }
  if (output[_QSC] != null) {
    contents[_QSC] = de_CachePolicyQueryStringsConfig(output[_QSC], context);
  }
  return contents;
}, "de_ParametersInCacheKeyAndForwardedToOrigin");
var de_PathList = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return (0, import_smithy_client.expectString)(entry);
  });
}, "de_PathList");
var de_Paths = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_Q] != null) {
    contents[_Q] = (0, import_smithy_client.strictParseInt32)(output[_Q]);
  }
  if (output.Items === "") {
    contents[_It] = [];
  } else if (output[_It] != null && output[_It][_Pat] != null) {
    contents[_It] = de_PathList((0, import_smithy_client.getArrayIfSingleItem)(output[_It][_Pat]), context);
  }
  return contents;
}, "de_Paths");
var de_PublicKey = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_Id] != null) {
    contents[_Id] = (0, import_smithy_client.expectString)(output[_Id]);
  }
  if (output[_CTr] != null) {
    contents[_CTr] = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseRfc3339DateTimeWithOffset)(output[_CTr]));
  }
  if (output[_PKC] != null) {
    contents[_PKC] = de_PublicKeyConfig(output[_PKC], context);
  }
  return contents;
}, "de_PublicKey");
var de_PublicKeyConfig = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_CR] != null) {
    contents[_CR] = (0, import_smithy_client.expectString)(output[_CR]);
  }
  if (output[_N] != null) {
    contents[_N] = (0, import_smithy_client.expectString)(output[_N]);
  }
  if (output[_EK] != null) {
    contents[_EK] = (0, import_smithy_client.expectString)(output[_EK]);
  }
  if (output[_Co] != null) {
    contents[_Co] = (0, import_smithy_client.expectString)(output[_Co]);
  }
  return contents;
}, "de_PublicKeyConfig");
var de_PublicKeyIdList = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return (0, import_smithy_client.expectString)(entry);
  });
}, "de_PublicKeyIdList");
var de_PublicKeyList = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_NM] != null) {
    contents[_NM] = (0, import_smithy_client.expectString)(output[_NM]);
  }
  if (output[_MI] != null) {
    contents[_MI] = (0, import_smithy_client.strictParseInt32)(output[_MI]);
  }
  if (output[_Q] != null) {
    contents[_Q] = (0, import_smithy_client.strictParseInt32)(output[_Q]);
  }
  if (output.Items === "") {
    contents[_It] = [];
  } else if (output[_It] != null && output[_It][_PKS] != null) {
    contents[_It] = de_PublicKeySummaryList((0, import_smithy_client.getArrayIfSingleItem)(output[_It][_PKS]), context);
  }
  return contents;
}, "de_PublicKeyList");
var de_PublicKeySummary = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_Id] != null) {
    contents[_Id] = (0, import_smithy_client.expectString)(output[_Id]);
  }
  if (output[_N] != null) {
    contents[_N] = (0, import_smithy_client.expectString)(output[_N]);
  }
  if (output[_CTr] != null) {
    contents[_CTr] = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseRfc3339DateTimeWithOffset)(output[_CTr]));
  }
  if (output[_EK] != null) {
    contents[_EK] = (0, import_smithy_client.expectString)(output[_EK]);
  }
  if (output[_Co] != null) {
    contents[_Co] = (0, import_smithy_client.expectString)(output[_Co]);
  }
  return contents;
}, "de_PublicKeySummary");
var de_PublicKeySummaryList = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_PublicKeySummary(entry, context);
  });
}, "de_PublicKeySummaryList");
var de_QueryArgProfile = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_QA] != null) {
    contents[_QA] = (0, import_smithy_client.expectString)(output[_QA]);
  }
  if (output[_PI] != null) {
    contents[_PI] = (0, import_smithy_client.expectString)(output[_PI]);
  }
  return contents;
}, "de_QueryArgProfile");
var de_QueryArgProfileConfig = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_FWQAPIU] != null) {
    contents[_FWQAPIU] = (0, import_smithy_client.parseBoolean)(output[_FWQAPIU]);
  }
  if (output[_QAPu] != null) {
    contents[_QAPu] = de_QueryArgProfiles(output[_QAPu], context);
  }
  return contents;
}, "de_QueryArgProfileConfig");
var de_QueryArgProfileList = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_QueryArgProfile(entry, context);
  });
}, "de_QueryArgProfileList");
var de_QueryArgProfiles = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_Q] != null) {
    contents[_Q] = (0, import_smithy_client.strictParseInt32)(output[_Q]);
  }
  if (output.Items === "") {
    contents[_It] = [];
  } else if (output[_It] != null && output[_It][_QAP] != null) {
    contents[_It] = de_QueryArgProfileList((0, import_smithy_client.getArrayIfSingleItem)(output[_It][_QAP]), context);
  }
  return contents;
}, "de_QueryArgProfiles");
var de_QueryStringCacheKeys = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_Q] != null) {
    contents[_Q] = (0, import_smithy_client.strictParseInt32)(output[_Q]);
  }
  if (output.Items === "") {
    contents[_It] = [];
  } else if (output[_It] != null && output[_It][_N] != null) {
    contents[_It] = de_QueryStringCacheKeysList((0, import_smithy_client.getArrayIfSingleItem)(output[_It][_N]), context);
  }
  return contents;
}, "de_QueryStringCacheKeys");
var de_QueryStringCacheKeysList = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return (0, import_smithy_client.expectString)(entry);
  });
}, "de_QueryStringCacheKeysList");
var de_QueryStringNames = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_Q] != null) {
    contents[_Q] = (0, import_smithy_client.strictParseInt32)(output[_Q]);
  }
  if (output.Items === "") {
    contents[_It] = [];
  } else if (output[_It] != null && output[_It][_N] != null) {
    contents[_It] = de_QueryStringNamesList((0, import_smithy_client.getArrayIfSingleItem)(output[_It][_N]), context);
  }
  return contents;
}, "de_QueryStringNames");
var de_QueryStringNamesList = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return (0, import_smithy_client.expectString)(entry);
  });
}, "de_QueryStringNamesList");
var de_RealtimeLogConfig = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_ARN] != null) {
    contents[_ARN] = (0, import_smithy_client.expectString)(output[_ARN]);
  }
  if (output[_N] != null) {
    contents[_N] = (0, import_smithy_client.expectString)(output[_N]);
  }
  if (output[_SR] != null) {
    contents[_SR] = (0, import_smithy_client.strictParseLong)(output[_SR]);
  }
  if (output.EndPoints === "") {
    contents[_EP] = [];
  } else if (output[_EP] != null && output[_EP][_m] != null) {
    contents[_EP] = de_EndPointList((0, import_smithy_client.getArrayIfSingleItem)(output[_EP][_m]), context);
  }
  if (output.Fields === "") {
    contents[_F] = [];
  } else if (output[_F] != null && output[_F][_Fi] != null) {
    contents[_F] = de_FieldList((0, import_smithy_client.getArrayIfSingleItem)(output[_F][_Fi]), context);
  }
  return contents;
}, "de_RealtimeLogConfig");
var de_RealtimeLogConfigList = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_RealtimeLogConfig(entry, context);
  });
}, "de_RealtimeLogConfigList");
var de_RealtimeLogConfigs = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_MI] != null) {
    contents[_MI] = (0, import_smithy_client.strictParseInt32)(output[_MI]);
  }
  if (output.Items === "") {
    contents[_It] = [];
  } else if (output[_It] != null && output[_It][_m] != null) {
    contents[_It] = de_RealtimeLogConfigList((0, import_smithy_client.getArrayIfSingleItem)(output[_It][_m]), context);
  }
  if (output[_IT] != null) {
    contents[_IT] = (0, import_smithy_client.parseBoolean)(output[_IT]);
  }
  if (output[_M] != null) {
    contents[_M] = (0, import_smithy_client.expectString)(output[_M]);
  }
  if (output[_NM] != null) {
    contents[_NM] = (0, import_smithy_client.expectString)(output[_NM]);
  }
  return contents;
}, "de_RealtimeLogConfigs");
var de_RealtimeMetricsSubscriptionConfig = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_RMSS] != null) {
    contents[_RMSS] = (0, import_smithy_client.expectString)(output[_RMSS]);
  }
  return contents;
}, "de_RealtimeMetricsSubscriptionConfig");
var de_ResponseHeadersPolicy = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_Id] != null) {
    contents[_Id] = (0, import_smithy_client.expectString)(output[_Id]);
  }
  if (output[_LMT] != null) {
    contents[_LMT] = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseRfc3339DateTimeWithOffset)(output[_LMT]));
  }
  if (output[_RHPC] != null) {
    contents[_RHPC] = de_ResponseHeadersPolicyConfig(output[_RHPC], context);
  }
  return contents;
}, "de_ResponseHeadersPolicy");
var de_ResponseHeadersPolicyAccessControlAllowHeaders = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_Q] != null) {
    contents[_Q] = (0, import_smithy_client.strictParseInt32)(output[_Q]);
  }
  if (output.Items === "") {
    contents[_It] = [];
  } else if (output[_It] != null && output[_It][_H] != null) {
    contents[_It] = de_AccessControlAllowHeadersList((0, import_smithy_client.getArrayIfSingleItem)(output[_It][_H]), context);
  }
  return contents;
}, "de_ResponseHeadersPolicyAccessControlAllowHeaders");
var de_ResponseHeadersPolicyAccessControlAllowMethods = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_Q] != null) {
    contents[_Q] = (0, import_smithy_client.strictParseInt32)(output[_Q]);
  }
  if (output.Items === "") {
    contents[_It] = [];
  } else if (output[_It] != null && output[_It][_Met] != null) {
    contents[_It] = de_AccessControlAllowMethodsList((0, import_smithy_client.getArrayIfSingleItem)(output[_It][_Met]), context);
  }
  return contents;
}, "de_ResponseHeadersPolicyAccessControlAllowMethods");
var de_ResponseHeadersPolicyAccessControlAllowOrigins = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_Q] != null) {
    contents[_Q] = (0, import_smithy_client.strictParseInt32)(output[_Q]);
  }
  if (output.Items === "") {
    contents[_It] = [];
  } else if (output[_It] != null && output[_It][_Or] != null) {
    contents[_It] = de_AccessControlAllowOriginsList((0, import_smithy_client.getArrayIfSingleItem)(output[_It][_Or]), context);
  }
  return contents;
}, "de_ResponseHeadersPolicyAccessControlAllowOrigins");
var de_ResponseHeadersPolicyAccessControlExposeHeaders = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_Q] != null) {
    contents[_Q] = (0, import_smithy_client.strictParseInt32)(output[_Q]);
  }
  if (output.Items === "") {
    contents[_It] = [];
  } else if (output[_It] != null && output[_It][_H] != null) {
    contents[_It] = de_AccessControlExposeHeadersList((0, import_smithy_client.getArrayIfSingleItem)(output[_It][_H]), context);
  }
  return contents;
}, "de_ResponseHeadersPolicyAccessControlExposeHeaders");
var de_ResponseHeadersPolicyConfig = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_Co] != null) {
    contents[_Co] = (0, import_smithy_client.expectString)(output[_Co]);
  }
  if (output[_N] != null) {
    contents[_N] = (0, import_smithy_client.expectString)(output[_N]);
  }
  if (output[_CCo] != null) {
    contents[_CCo] = de_ResponseHeadersPolicyCorsConfig(output[_CCo], context);
  }
  if (output[_SHC] != null) {
    contents[_SHC] = de_ResponseHeadersPolicySecurityHeadersConfig(output[_SHC], context);
  }
  if (output[_STHC] != null) {
    contents[_STHC] = de_ResponseHeadersPolicyServerTimingHeadersConfig(output[_STHC], context);
  }
  if (output[_CHC] != null) {
    contents[_CHC] = de_ResponseHeadersPolicyCustomHeadersConfig(output[_CHC], context);
  }
  if (output[_RHC] != null) {
    contents[_RHC] = de_ResponseHeadersPolicyRemoveHeadersConfig(output[_RHC], context);
  }
  return contents;
}, "de_ResponseHeadersPolicyConfig");
var de_ResponseHeadersPolicyContentSecurityPolicy = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_Ov] != null) {
    contents[_Ov] = (0, import_smithy_client.parseBoolean)(output[_Ov]);
  }
  if (output[_CSP] != null) {
    contents[_CSP] = (0, import_smithy_client.expectString)(output[_CSP]);
  }
  return contents;
}, "de_ResponseHeadersPolicyContentSecurityPolicy");
var de_ResponseHeadersPolicyContentTypeOptions = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_Ov] != null) {
    contents[_Ov] = (0, import_smithy_client.parseBoolean)(output[_Ov]);
  }
  return contents;
}, "de_ResponseHeadersPolicyContentTypeOptions");
var de_ResponseHeadersPolicyCorsConfig = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_ACAO] != null) {
    contents[_ACAO] = de_ResponseHeadersPolicyAccessControlAllowOrigins(output[_ACAO], context);
  }
  if (output[_ACAH] != null) {
    contents[_ACAH] = de_ResponseHeadersPolicyAccessControlAllowHeaders(output[_ACAH], context);
  }
  if (output[_ACAM] != null) {
    contents[_ACAM] = de_ResponseHeadersPolicyAccessControlAllowMethods(output[_ACAM], context);
  }
  if (output[_ACAC] != null) {
    contents[_ACAC] = (0, import_smithy_client.parseBoolean)(output[_ACAC]);
  }
  if (output[_ACEH] != null) {
    contents[_ACEH] = de_ResponseHeadersPolicyAccessControlExposeHeaders(output[_ACEH], context);
  }
  if (output[_ACMAS] != null) {
    contents[_ACMAS] = (0, import_smithy_client.strictParseInt32)(output[_ACMAS]);
  }
  if (output[_OO] != null) {
    contents[_OO] = (0, import_smithy_client.parseBoolean)(output[_OO]);
  }
  return contents;
}, "de_ResponseHeadersPolicyCorsConfig");
var de_ResponseHeadersPolicyCustomHeader = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_H] != null) {
    contents[_H] = (0, import_smithy_client.expectString)(output[_H]);
  }
  if (output[_V] != null) {
    contents[_V] = (0, import_smithy_client.expectString)(output[_V]);
  }
  if (output[_Ov] != null) {
    contents[_Ov] = (0, import_smithy_client.parseBoolean)(output[_Ov]);
  }
  return contents;
}, "de_ResponseHeadersPolicyCustomHeader");
var de_ResponseHeadersPolicyCustomHeaderList = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_ResponseHeadersPolicyCustomHeader(entry, context);
  });
}, "de_ResponseHeadersPolicyCustomHeaderList");
var de_ResponseHeadersPolicyCustomHeadersConfig = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_Q] != null) {
    contents[_Q] = (0, import_smithy_client.strictParseInt32)(output[_Q]);
  }
  if (output.Items === "") {
    contents[_It] = [];
  } else if (output[_It] != null && output[_It][_RHPCH] != null) {
    contents[_It] = de_ResponseHeadersPolicyCustomHeaderList((0, import_smithy_client.getArrayIfSingleItem)(output[_It][_RHPCH]), context);
  }
  return contents;
}, "de_ResponseHeadersPolicyCustomHeadersConfig");
var de_ResponseHeadersPolicyFrameOptions = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_Ov] != null) {
    contents[_Ov] = (0, import_smithy_client.parseBoolean)(output[_Ov]);
  }
  if (output[_FO] != null) {
    contents[_FO] = (0, import_smithy_client.expectString)(output[_FO]);
  }
  return contents;
}, "de_ResponseHeadersPolicyFrameOptions");
var de_ResponseHeadersPolicyList = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_NM] != null) {
    contents[_NM] = (0, import_smithy_client.expectString)(output[_NM]);
  }
  if (output[_MI] != null) {
    contents[_MI] = (0, import_smithy_client.strictParseInt32)(output[_MI]);
  }
  if (output[_Q] != null) {
    contents[_Q] = (0, import_smithy_client.strictParseInt32)(output[_Q]);
  }
  if (output.Items === "") {
    contents[_It] = [];
  } else if (output[_It] != null && output[_It][_RHPS] != null) {
    contents[_It] = de_ResponseHeadersPolicySummaryList((0, import_smithy_client.getArrayIfSingleItem)(output[_It][_RHPS]), context);
  }
  return contents;
}, "de_ResponseHeadersPolicyList");
var de_ResponseHeadersPolicyReferrerPolicy = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_Ov] != null) {
    contents[_Ov] = (0, import_smithy_client.parseBoolean)(output[_Ov]);
  }
  if (output[_RP] != null) {
    contents[_RP] = (0, import_smithy_client.expectString)(output[_RP]);
  }
  return contents;
}, "de_ResponseHeadersPolicyReferrerPolicy");
var de_ResponseHeadersPolicyRemoveHeader = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_H] != null) {
    contents[_H] = (0, import_smithy_client.expectString)(output[_H]);
  }
  return contents;
}, "de_ResponseHeadersPolicyRemoveHeader");
var de_ResponseHeadersPolicyRemoveHeaderList = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_ResponseHeadersPolicyRemoveHeader(entry, context);
  });
}, "de_ResponseHeadersPolicyRemoveHeaderList");
var de_ResponseHeadersPolicyRemoveHeadersConfig = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_Q] != null) {
    contents[_Q] = (0, import_smithy_client.strictParseInt32)(output[_Q]);
  }
  if (output.Items === "") {
    contents[_It] = [];
  } else if (output[_It] != null && output[_It][_RHPRH] != null) {
    contents[_It] = de_ResponseHeadersPolicyRemoveHeaderList((0, import_smithy_client.getArrayIfSingleItem)(output[_It][_RHPRH]), context);
  }
  return contents;
}, "de_ResponseHeadersPolicyRemoveHeadersConfig");
var de_ResponseHeadersPolicySecurityHeadersConfig = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_XSSP] != null) {
    contents[_XSSP] = de_ResponseHeadersPolicyXSSProtection(output[_XSSP], context);
  }
  if (output[_FOr] != null) {
    contents[_FOr] = de_ResponseHeadersPolicyFrameOptions(output[_FOr], context);
  }
  if (output[_RP] != null) {
    contents[_RP] = de_ResponseHeadersPolicyReferrerPolicy(output[_RP], context);
  }
  if (output[_CSP] != null) {
    contents[_CSP] = de_ResponseHeadersPolicyContentSecurityPolicy(output[_CSP], context);
  }
  if (output[_CTO] != null) {
    contents[_CTO] = de_ResponseHeadersPolicyContentTypeOptions(output[_CTO], context);
  }
  if (output[_STS] != null) {
    contents[_STS] = de_ResponseHeadersPolicyStrictTransportSecurity(output[_STS], context);
  }
  return contents;
}, "de_ResponseHeadersPolicySecurityHeadersConfig");
var de_ResponseHeadersPolicyServerTimingHeadersConfig = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_E] != null) {
    contents[_E] = (0, import_smithy_client.parseBoolean)(output[_E]);
  }
  if (output[_SR] != null) {
    contents[_SR] = (0, import_smithy_client.strictParseFloat)(output[_SR]);
  }
  return contents;
}, "de_ResponseHeadersPolicyServerTimingHeadersConfig");
var de_ResponseHeadersPolicyStrictTransportSecurity = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_Ov] != null) {
    contents[_Ov] = (0, import_smithy_client.parseBoolean)(output[_Ov]);
  }
  if (output[_ISn] != null) {
    contents[_ISn] = (0, import_smithy_client.parseBoolean)(output[_ISn]);
  }
  if (output[_Pre] != null) {
    contents[_Pre] = (0, import_smithy_client.parseBoolean)(output[_Pre]);
  }
  if (output[_ACMAS] != null) {
    contents[_ACMAS] = (0, import_smithy_client.strictParseInt32)(output[_ACMAS]);
  }
  return contents;
}, "de_ResponseHeadersPolicyStrictTransportSecurity");
var de_ResponseHeadersPolicySummary = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_Ty] != null) {
    contents[_Ty] = (0, import_smithy_client.expectString)(output[_Ty]);
  }
  if (output[_RHP] != null) {
    contents[_RHP] = de_ResponseHeadersPolicy(output[_RHP], context);
  }
  return contents;
}, "de_ResponseHeadersPolicySummary");
var de_ResponseHeadersPolicySummaryList = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_ResponseHeadersPolicySummary(entry, context);
  });
}, "de_ResponseHeadersPolicySummaryList");
var de_ResponseHeadersPolicyXSSProtection = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_Ov] != null) {
    contents[_Ov] = (0, import_smithy_client.parseBoolean)(output[_Ov]);
  }
  if (output[_Pro] != null) {
    contents[_Pro] = (0, import_smithy_client.parseBoolean)(output[_Pro]);
  }
  if (output[_MB] != null) {
    contents[_MB] = (0, import_smithy_client.parseBoolean)(output[_MB]);
  }
  if (output[_RU] != null) {
    contents[_RU] = (0, import_smithy_client.expectString)(output[_RU]);
  }
  return contents;
}, "de_ResponseHeadersPolicyXSSProtection");
var de_Restrictions = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_GRe] != null) {
    contents[_GRe] = de_GeoRestriction(output[_GRe], context);
  }
  return contents;
}, "de_Restrictions");
var de_S3Origin = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_DN] != null) {
    contents[_DN] = (0, import_smithy_client.expectString)(output[_DN]);
  }
  if (output[_OAI] != null) {
    contents[_OAI] = (0, import_smithy_client.expectString)(output[_OAI]);
  }
  return contents;
}, "de_S3Origin");
var de_S3OriginConfig = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_OAI] != null) {
    contents[_OAI] = (0, import_smithy_client.expectString)(output[_OAI]);
  }
  return contents;
}, "de_S3OriginConfig");
var de_SessionStickinessConfig = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_ITTL] != null) {
    contents[_ITTL] = (0, import_smithy_client.strictParseInt32)(output[_ITTL]);
  }
  if (output[_MTTLax] != null) {
    contents[_MTTLax] = (0, import_smithy_client.strictParseInt32)(output[_MTTLax]);
  }
  return contents;
}, "de_SessionStickinessConfig");
var de_Signer = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_AAN] != null) {
    contents[_AAN] = (0, import_smithy_client.expectString)(output[_AAN]);
  }
  if (output[_KPIe] != null) {
    contents[_KPIe] = de_KeyPairIds(output[_KPIe], context);
  }
  return contents;
}, "de_Signer");
var de_SignerList = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_Signer(entry, context);
  });
}, "de_SignerList");
var de_SslProtocolsList = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return (0, import_smithy_client.expectString)(entry);
  });
}, "de_SslProtocolsList");
var de_StagingDistributionDnsNameList = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return (0, import_smithy_client.expectString)(entry);
  });
}, "de_StagingDistributionDnsNameList");
var de_StagingDistributionDnsNames = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_Q] != null) {
    contents[_Q] = (0, import_smithy_client.strictParseInt32)(output[_Q]);
  }
  if (output.Items === "") {
    contents[_It] = [];
  } else if (output[_It] != null && output[_It][_DNn] != null) {
    contents[_It] = de_StagingDistributionDnsNameList((0, import_smithy_client.getArrayIfSingleItem)(output[_It][_DNn]), context);
  }
  return contents;
}, "de_StagingDistributionDnsNames");
var de_StatusCodeList = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return (0, import_smithy_client.strictParseInt32)(entry);
  });
}, "de_StatusCodeList");
var de_StatusCodes = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_Q] != null) {
    contents[_Q] = (0, import_smithy_client.strictParseInt32)(output[_Q]);
  }
  if (output.Items === "") {
    contents[_It] = [];
  } else if (output[_It] != null && output[_It][_SCta] != null) {
    contents[_It] = de_StatusCodeList((0, import_smithy_client.getArrayIfSingleItem)(output[_It][_SCta]), context);
  }
  return contents;
}, "de_StatusCodes");
var de_StreamingDistribution = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_Id] != null) {
    contents[_Id] = (0, import_smithy_client.expectString)(output[_Id]);
  }
  if (output[_ARN] != null) {
    contents[_ARN] = (0, import_smithy_client.expectString)(output[_ARN]);
  }
  if (output[_Sta] != null) {
    contents[_Sta] = (0, import_smithy_client.expectString)(output[_Sta]);
  }
  if (output[_LMT] != null) {
    contents[_LMT] = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseRfc3339DateTimeWithOffset)(output[_LMT]));
  }
  if (output[_DN] != null) {
    contents[_DN] = (0, import_smithy_client.expectString)(output[_DN]);
  }
  if (output[_ATS] != null) {
    contents[_ATS] = de_ActiveTrustedSigners(output[_ATS], context);
  }
  if (output[_SDC] != null) {
    contents[_SDC] = de_StreamingDistributionConfig(output[_SDC], context);
  }
  return contents;
}, "de_StreamingDistribution");
var de_StreamingDistributionConfig = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_CR] != null) {
    contents[_CR] = (0, import_smithy_client.expectString)(output[_CR]);
  }
  if (output[_SO] != null) {
    contents[_SO] = de_S3Origin(output[_SO], context);
  }
  if (output[_Al] != null) {
    contents[_Al] = de_Aliases(output[_Al], context);
  }
  if (output[_Co] != null) {
    contents[_Co] = (0, import_smithy_client.expectString)(output[_Co]);
  }
  if (output[_Lo] != null) {
    contents[_Lo] = de_StreamingLoggingConfig(output[_Lo], context);
  }
  if (output[_TS] != null) {
    contents[_TS] = de_TrustedSigners(output[_TS], context);
  }
  if (output[_PC] != null) {
    contents[_PC] = (0, import_smithy_client.expectString)(output[_PC]);
  }
  if (output[_E] != null) {
    contents[_E] = (0, import_smithy_client.parseBoolean)(output[_E]);
  }
  return contents;
}, "de_StreamingDistributionConfig");
var de_StreamingDistributionList = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_M] != null) {
    contents[_M] = (0, import_smithy_client.expectString)(output[_M]);
  }
  if (output[_NM] != null) {
    contents[_NM] = (0, import_smithy_client.expectString)(output[_NM]);
  }
  if (output[_MI] != null) {
    contents[_MI] = (0, import_smithy_client.strictParseInt32)(output[_MI]);
  }
  if (output[_IT] != null) {
    contents[_IT] = (0, import_smithy_client.parseBoolean)(output[_IT]);
  }
  if (output[_Q] != null) {
    contents[_Q] = (0, import_smithy_client.strictParseInt32)(output[_Q]);
  }
  if (output.Items === "") {
    contents[_It] = [];
  } else if (output[_It] != null && output[_It][_SDS] != null) {
    contents[_It] = de_StreamingDistributionSummaryList((0, import_smithy_client.getArrayIfSingleItem)(output[_It][_SDS]), context);
  }
  return contents;
}, "de_StreamingDistributionList");
var de_StreamingDistributionSummary = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_Id] != null) {
    contents[_Id] = (0, import_smithy_client.expectString)(output[_Id]);
  }
  if (output[_ARN] != null) {
    contents[_ARN] = (0, import_smithy_client.expectString)(output[_ARN]);
  }
  if (output[_Sta] != null) {
    contents[_Sta] = (0, import_smithy_client.expectString)(output[_Sta]);
  }
  if (output[_LMT] != null) {
    contents[_LMT] = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseRfc3339DateTimeWithOffset)(output[_LMT]));
  }
  if (output[_DN] != null) {
    contents[_DN] = (0, import_smithy_client.expectString)(output[_DN]);
  }
  if (output[_SO] != null) {
    contents[_SO] = de_S3Origin(output[_SO], context);
  }
  if (output[_Al] != null) {
    contents[_Al] = de_Aliases(output[_Al], context);
  }
  if (output[_TS] != null) {
    contents[_TS] = de_TrustedSigners(output[_TS], context);
  }
  if (output[_Co] != null) {
    contents[_Co] = (0, import_smithy_client.expectString)(output[_Co]);
  }
  if (output[_PC] != null) {
    contents[_PC] = (0, import_smithy_client.expectString)(output[_PC]);
  }
  if (output[_E] != null) {
    contents[_E] = (0, import_smithy_client.parseBoolean)(output[_E]);
  }
  return contents;
}, "de_StreamingDistributionSummary");
var de_StreamingDistributionSummaryList = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_StreamingDistributionSummary(entry, context);
  });
}, "de_StreamingDistributionSummaryList");
var de_StreamingLoggingConfig = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_E] != null) {
    contents[_E] = (0, import_smithy_client.parseBoolean)(output[_E]);
  }
  if (output[_B] != null) {
    contents[_B] = (0, import_smithy_client.expectString)(output[_B]);
  }
  if (output[_Pr] != null) {
    contents[_Pr] = (0, import_smithy_client.expectString)(output[_Pr]);
  }
  return contents;
}, "de_StreamingLoggingConfig");
var de_StringSchemaConfig = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_Co] != null) {
    contents[_Co] = (0, import_smithy_client.expectString)(output[_Co]);
  }
  if (output[_DV] != null) {
    contents[_DV] = (0, import_smithy_client.expectString)(output[_DV]);
  }
  if (output[_Req] != null) {
    contents[_Req] = (0, import_smithy_client.parseBoolean)(output[_Req]);
  }
  return contents;
}, "de_StringSchemaConfig");
var de_Tag = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_K] != null) {
    contents[_K] = (0, import_smithy_client.expectString)(output[_K]);
  }
  if (output[_V] != null) {
    contents[_V] = (0, import_smithy_client.expectString)(output[_V]);
  }
  return contents;
}, "de_Tag");
var de_TagList = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_Tag(entry, context);
  });
}, "de_TagList");
var de_Tags = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output.Items === "") {
    contents[_It] = [];
  } else if (output[_It] != null && output[_It][_Ta] != null) {
    contents[_It] = de_TagList((0, import_smithy_client.getArrayIfSingleItem)(output[_It][_Ta]), context);
  }
  return contents;
}, "de_Tags");
var de_TenantConfig = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output.ParameterDefinitions === "") {
    contents[_PDa] = [];
  } else if (output[_PDa] != null && output[_PDa][_m] != null) {
    contents[_PDa] = de_ParameterDefinitions((0, import_smithy_client.getArrayIfSingleItem)(output[_PDa][_m]), context);
  }
  return contents;
}, "de_TenantConfig");
var de_TestResult = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_FSu] != null) {
    contents[_FSu] = de_FunctionSummary(output[_FSu], context);
  }
  if (output[_CU] != null) {
    contents[_CU] = (0, import_smithy_client.expectString)(output[_CU]);
  }
  if (output.FunctionExecutionLogs === "") {
    contents[_FEL] = [];
  } else if (output[_FEL] != null && output[_FEL][_m] != null) {
    contents[_FEL] = de_FunctionExecutionLogList((0, import_smithy_client.getArrayIfSingleItem)(output[_FEL][_m]), context);
  }
  if (output[_FEM] != null) {
    contents[_FEM] = (0, import_smithy_client.expectString)(output[_FEM]);
  }
  if (output[_FOu] != null) {
    contents[_FOu] = (0, import_smithy_client.expectString)(output[_FOu]);
  }
  return contents;
}, "de_TestResult");
var de_TrafficConfig = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_SWC] != null) {
    contents[_SWC] = de_ContinuousDeploymentSingleWeightConfig(output[_SWC], context);
  }
  if (output[_SHCi] != null) {
    contents[_SHCi] = de_ContinuousDeploymentSingleHeaderConfig(output[_SHCi], context);
  }
  if (output[_Ty] != null) {
    contents[_Ty] = (0, import_smithy_client.expectString)(output[_Ty]);
  }
  return contents;
}, "de_TrafficConfig");
var de_TrustedKeyGroupIdList = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return (0, import_smithy_client.expectString)(entry);
  });
}, "de_TrustedKeyGroupIdList");
var de_TrustedKeyGroups = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_E] != null) {
    contents[_E] = (0, import_smithy_client.parseBoolean)(output[_E]);
  }
  if (output[_Q] != null) {
    contents[_Q] = (0, import_smithy_client.strictParseInt32)(output[_Q]);
  }
  if (output.Items === "") {
    contents[_It] = [];
  } else if (output[_It] != null && output[_It][_KG] != null) {
    contents[_It] = de_TrustedKeyGroupIdList((0, import_smithy_client.getArrayIfSingleItem)(output[_It][_KG]), context);
  }
  return contents;
}, "de_TrustedKeyGroups");
var de_TrustedSigners = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_E] != null) {
    contents[_E] = (0, import_smithy_client.parseBoolean)(output[_E]);
  }
  if (output[_Q] != null) {
    contents[_Q] = (0, import_smithy_client.strictParseInt32)(output[_Q]);
  }
  if (output.Items === "") {
    contents[_It] = [];
  } else if (output[_It] != null && output[_It][_AAN] != null) {
    contents[_It] = de_AwsAccountNumberList((0, import_smithy_client.getArrayIfSingleItem)(output[_It][_AAN]), context);
  }
  return contents;
}, "de_TrustedSigners");
var de_ValidationTokenDetail = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_Do] != null) {
    contents[_Do] = (0, import_smithy_client.expectString)(output[_Do]);
  }
  if (output[_RTed] != null) {
    contents[_RTed] = (0, import_smithy_client.expectString)(output[_RTed]);
  }
  if (output[_RF] != null) {
    contents[_RF] = (0, import_smithy_client.expectString)(output[_RF]);
  }
  return contents;
}, "de_ValidationTokenDetail");
var de_ValidationTokenDetailList = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_ValidationTokenDetail(entry, context);
  });
}, "de_ValidationTokenDetailList");
var de_ViewerCertificate = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_CFDC] != null) {
    contents[_CFDC] = (0, import_smithy_client.parseBoolean)(output[_CFDC]);
  }
  if (output[_IAMCI] != null) {
    contents[_IAMCI] = (0, import_smithy_client.expectString)(output[_IAMCI]);
  }
  if (output[_ACMCA] != null) {
    contents[_ACMCA] = (0, import_smithy_client.expectString)(output[_ACMCA]);
  }
  if (output[_SSLSM] != null) {
    contents[_SSLSM] = (0, import_smithy_client.expectString)(output[_SSLSM]);
  }
  if (output[_MPV] != null) {
    contents[_MPV] = (0, import_smithy_client.expectString)(output[_MPV]);
  }
  if (output[_Ce] != null) {
    contents[_Ce] = (0, import_smithy_client.expectString)(output[_Ce]);
  }
  if (output[_CS] != null) {
    contents[_CS] = (0, import_smithy_client.expectString)(output[_CS]);
  }
  return contents;
}, "de_ViewerCertificate");
var de_VpcOrigin = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_Id] != null) {
    contents[_Id] = (0, import_smithy_client.expectString)(output[_Id]);
  }
  if (output[_Ar] != null) {
    contents[_Ar] = (0, import_smithy_client.expectString)(output[_Ar]);
  }
  if (output[_Sta] != null) {
    contents[_Sta] = (0, import_smithy_client.expectString)(output[_Sta]);
  }
  if (output[_CTr] != null) {
    contents[_CTr] = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseRfc3339DateTimeWithOffset)(output[_CTr]));
  }
  if (output[_LMT] != null) {
    contents[_LMT] = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseRfc3339DateTimeWithOffset)(output[_LMT]));
  }
  if (output[_VOEC] != null) {
    contents[_VOEC] = de_VpcOriginEndpointConfig(output[_VOEC], context);
  }
  return contents;
}, "de_VpcOrigin");
var de_VpcOriginConfig = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_VOI] != null) {
    contents[_VOI] = (0, import_smithy_client.expectString)(output[_VOI]);
  }
  if (output[_ORT] != null) {
    contents[_ORT] = (0, import_smithy_client.strictParseInt32)(output[_ORT]);
  }
  if (output[_OKT] != null) {
    contents[_OKT] = (0, import_smithy_client.strictParseInt32)(output[_OKT]);
  }
  return contents;
}, "de_VpcOriginConfig");
var de_VpcOriginEndpointConfig = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_N] != null) {
    contents[_N] = (0, import_smithy_client.expectString)(output[_N]);
  }
  if (output[_Ar] != null) {
    contents[_Ar] = (0, import_smithy_client.expectString)(output[_Ar]);
  }
  if (output[_HTTPP] != null) {
    contents[_HTTPP] = (0, import_smithy_client.strictParseInt32)(output[_HTTPP]);
  }
  if (output[_HTTPSP] != null) {
    contents[_HTTPSP] = (0, import_smithy_client.strictParseInt32)(output[_HTTPSP]);
  }
  if (output[_OPP] != null) {
    contents[_OPP] = (0, import_smithy_client.expectString)(output[_OPP]);
  }
  if (output[_OSP] != null) {
    contents[_OSP] = de_OriginSslProtocols(output[_OSP], context);
  }
  return contents;
}, "de_VpcOriginEndpointConfig");
var de_VpcOriginList = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_M] != null) {
    contents[_M] = (0, import_smithy_client.expectString)(output[_M]);
  }
  if (output[_NM] != null) {
    contents[_NM] = (0, import_smithy_client.expectString)(output[_NM]);
  }
  if (output[_MI] != null) {
    contents[_MI] = (0, import_smithy_client.strictParseInt32)(output[_MI]);
  }
  if (output[_IT] != null) {
    contents[_IT] = (0, import_smithy_client.parseBoolean)(output[_IT]);
  }
  if (output[_Q] != null) {
    contents[_Q] = (0, import_smithy_client.strictParseInt32)(output[_Q]);
  }
  if (output.Items === "") {
    contents[_It] = [];
  } else if (output[_It] != null && output[_It][_VOS] != null) {
    contents[_It] = de_VpcOriginSummaryList((0, import_smithy_client.getArrayIfSingleItem)(output[_It][_VOS]), context);
  }
  return contents;
}, "de_VpcOriginList");
var de_VpcOriginSummary = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_Id] != null) {
    contents[_Id] = (0, import_smithy_client.expectString)(output[_Id]);
  }
  if (output[_N] != null) {
    contents[_N] = (0, import_smithy_client.expectString)(output[_N]);
  }
  if (output[_Sta] != null) {
    contents[_Sta] = (0, import_smithy_client.expectString)(output[_Sta]);
  }
  if (output[_CTr] != null) {
    contents[_CTr] = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseRfc3339DateTimeWithOffset)(output[_CTr]));
  }
  if (output[_LMT] != null) {
    contents[_LMT] = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseRfc3339DateTimeWithOffset)(output[_LMT]));
  }
  if (output[_Ar] != null) {
    contents[_Ar] = (0, import_smithy_client.expectString)(output[_Ar]);
  }
  if (output[_OEA] != null) {
    contents[_OEA] = (0, import_smithy_client.expectString)(output[_OEA]);
  }
  return contents;
}, "de_VpcOriginSummary");
var de_VpcOriginSummaryList = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_VpcOriginSummary(entry, context);
  });
}, "de_VpcOriginSummaryList");
var de_WebAclCustomization = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_Ac] != null) {
    contents[_Ac] = (0, import_smithy_client.expectString)(output[_Ac]);
  }
  if (output[_Ar] != null) {
    contents[_Ar] = (0, import_smithy_client.expectString)(output[_Ar]);
  }
  return contents;
}, "de_WebAclCustomization");
var deserializeMetadata = /* @__PURE__ */ __name((output) => ({
  httpStatusCode: output.statusCode,
  requestId: output.headers["x-amzn-requestid"] ?? output.headers["x-amzn-request-id"] ?? output.headers["x-amz-request-id"],
  extendedRequestId: output.headers["x-amz-id-2"],
  cfId: output.headers["x-amz-cf-id"]
}), "deserializeMetadata");
var _A = "Alias";
var _AAN = "AwsAccountNumber";
var _ACAC = "AccessControlAllowCredentials";
var _ACAH = "AccessControlAllowHeaders";
var _ACAM = "AccessControlAllowMethods";
var _ACAO = "AccessControlAllowOrigins";
var _ACEH = "AccessControlExposeHeaders";
var _ACMAS = "AccessControlMaxAgeSec";
var _ACMCA = "ACMCertificateArn";
var _ADTWACLR = "AssociateDistributionTenantWebACLRequest";
var _ADWACLR = "AssociateDistributionWebACLRequest";
var _AF = "AssociationFilter";
var _AI = "AnycastIps";
var _AICPR = "AliasICPRecordals";
var _AICPRl = "AliasICPRecordal";
var _AILI = "AnycastIpListId";
var _AILN = "AnycastIpListName";
var _AILS = "AnycastIpListSummary";
var _AIc = "AccountId";
var _AIn = "AnycastIp";
var _AM = "AllowedMethods";
var _ARN = "ARN";
var _ATKG = "ActiveTrustedKeyGroups";
var _ATS = "ActiveTrustedSigners";
var _Ac = "Action";
var _Al = "Aliases";
var _Ar = "Arn";
var _B = "Bucket";
var _C = "Customizations";
var _CA = "CertificateArn";
var _CAILR = "CreateAnycastIpListRequest";
var _CAT = "CustomizationActionType";
var _CAo = "ConnectionAttempts";
var _CAon = "ConflictingAlias";
var _CB = "CacheBehavior";
var _CBa = "CacheBehaviors";
var _CBo = "CookieBehavior";
var _CC = "CookiesConfig";
var _CCGR = "CreateConnectionGroupRequest";
var _CCo = "CorsConfig";
var _CDP = "ContinuousDeploymentPolicy";
var _CDPC = "ContinuousDeploymentPolicyConfig";
var _CDPI = "ContinuousDeploymentPolicyId";
var _CDPS = "ContinuousDeploymentPolicySummary";
var _CDPT = "ContinuousDeploymentPolicyType";
var _CDR = "CopyDistributionRequest";
var _CDSHC = "ContinuousDeploymentSingleHeaderConfig";
var _CDSWC = "ContinuousDeploymentSingleWeightConfig";
var _CDTR = "CreateDistributionTenantRequest";
var _CER = "CustomErrorResponse";
var _CERu = "CustomErrorResponses";
var _CFDC = "CloudFrontDefaultCertificate";
var _CFOAIC = "CloudFrontOriginAccessIdentityConfig";
var _CFOAIS = "CloudFrontOriginAccessIdentitySummary";
var _CFR = "CreateFunctionRequest";
var _CG = "ConnectionGroups";
var _CGAF = "ConnectionGroupAssociationFilter";
var _CGI = "ConnectionGroupId";
var _CGS = "ConnectionGroupSummary";
var _CH = "CustomHeaders";
var _CHC = "CustomHeadersConfig";
var _CKVSR = "CreateKeyValueStoreRequest";
var _CM = "CachedMethods";
var _CMo = "ConnectionMode";
var _CN = "CookieNames";
var _CNAME = "CNAME";
var _COC = "CustomOriginConfig";
var _CP = "CookiePreference";
var _CPC = "CachePolicyConfig";
var _CPCB = "CachePolicyCookieBehavior";
var _CPCC = "CachePolicyCookiesConfig";
var _CPHB = "CachePolicyHeaderBehavior";
var _CPHC = "CachePolicyHeadersConfig";
var _CPI = "CachePolicyId";
var _CPQSB = "CachePolicyQueryStringBehavior";
var _CPQSC = "CachePolicyQueryStringsConfig";
var _CPS = "CachePolicySummary";
var _CPa = "CachePolicy";
var _CR = "CallerReference";
var _CRLCR = "CreateRealtimeLogConfigRequest";
var _CS = "CertificateSource";
var _CSP = "ContentSecurityPolicy";
var _CSe = "CertificateStatus";
var _CT = "ContentType";
var _CTLP = "CertificateTransparencyLoggingPreference";
var _CTO = "ContentTypeOptions";
var _CTP = "ContentTypeProfile";
var _CTPC = "ContentTypeProfileConfig";
var _CTPo = "ContentTypeProfiles";
var _CTo = "CommentType";
var _CTon = "ConnectionTimeout";
var _CTr = "CreatedTime";
var _CTre = "CreateTime";
var _CU = "ComputeUtilization";
var _CVOR = "CreateVpcOriginRequest";
var _Ce = "Certificate";
var _Co = "Comment";
var _Com = "Compress";
var _Coo = "Cookies";
var _D = "Domains";
var _DC = "DomainConflicts";
var _DCB = "DefaultCacheBehavior";
var _DCL = "DnsConfigurationList";
var _DCVR = "DomainControlValidationResource";
var _DCWT = "DistributionConfigWithTags";
var _DCi = "DistributionConfig";
var _DCn = "DnsConfiguration";
var _DI = "DistributionId";
var _DIo = "DomainItem";
var _DN = "DomainName";
var _DNn = "DnsName";
var _DRI = "DistributionResourceId";
var _DRLCR = "DeleteRealtimeLogConfigRequest";
var _DRO = "DefaultRootObject";
var _DS = "DistributionSummary";
var _DTAF = "DistributionTenantAssociationFilter";
var _DTI = "DistributionTenantId";
var _DTL = "DistributionTenantList";
var _DTS = "DistributionTenantSummary";
var _DTTL = "DefaultTTL";
var _DV = "DefaultValue";
var _De = "Description";
var _Def = "Definition";
var _Do = "Domain";
var _E = "Enabled";
var _EAEB = "EnableAcceptEncodingBrotli";
var _EAEG = "EnableAcceptEncodingGzip";
var _EC = "ErrorCode";
var _ECMTTL = "ErrorCachingMinTTL";
var _EE = "EncryptionEntities";
var _EEn = "EncryptionEntity";
var _EK = "EncodedKey";
var _EO = "EventObject";
var _EP = "EndPoints";
var _EPn = "EndPoint";
var _ET = "ETag";
var _ETv = "EventType";
var _F = "Fields";
var _FA = "FunctionAssociations";
var _FARN = "FunctionARN";
var _FAu = "FunctionAssociation";
var _FB = "FunctionBlob";
var _FC = "FunctionCode";
var _FCa = "FailoverCriteria";
var _FCu = "FunctionConfig";
var _FEL = "FunctionExecutionLogs";
var _FEM = "FunctionErrorMessage";
var _FEO = "FunctionEventObject";
var _FLEC = "FieldLevelEncryptionConfig";
var _FLEI = "FieldLevelEncryptionId";
var _FLEPC = "FieldLevelEncryptionProfileConfig";
var _FLEPS = "FieldLevelEncryptionProfileSummary";
var _FLES = "FieldLevelEncryptionSummary";
var _FM = "FunctionMetadata";
var _FN = "FunctionName";
var _FO = "FrameOption";
var _FOL = "FrameOptionsList";
var _FOr = "FrameOptions";
var _FOu = "FunctionOutput";
var _FP = "FieldPatterns";
var _FPi = "FieldPattern";
var _FR = "FunctionRuntime";
var _FS = "FunctionStage";
var _FSu = "FunctionSummary";
var _FV = "ForwardedValues";
var _FWCTIU = "ForwardWhenContentTypeIsUnknown";
var _FWQAPIU = "ForwardWhenQueryArgProfileIsUnknown";
var _Fi = "Field";
var _Fo = "Format";
var _For = "Forward";
var _GC = "GrpcConfig";
var _GR = "GeoRestrictions";
var _GRC = "GeoRestrictionCustomization";
var _GRLCR = "GetRealtimeLogConfigRequest";
var _GRT = "GeoRestrictionType";
var _GRe = "GeoRestriction";
var _H = "Header";
var _HB = "HeaderBehavior";
var _HC = "HeadersConfig";
var _HN = "HeaderName";
var _HTTPP = "HTTPPort";
var _HTTPSP = "HTTPSPort";
var _HV = "HttpVersion";
var _HVe = "HeaderValue";
var _He = "Headers";
var _I = "Identifier";
var _IAMCI = "IAMCertificateId";
var _IB = "InvalidationBatch";
var _IBn = "IncludeBody";
var _IC = "IpCount";
var _ICPRS = "ICPRecordalStatus";
var _ICn = "IncludeCookies";
var _ID = "IsDefault";
var _IE = "Ipv6Enabled";
var _IIPVE = "IsIPV6Enabled";
var _IM = "IfMatch";
var _IPIB = "InProgressInvalidationBatches";
var _IS = "ImportSource";
var _IST = "ImportSourceType";
var _ISn = "IncludeSubdomains";
var _ISnv = "InvalidationSummary";
var _ISt = "ItemSelection";
var _IT = "IsTruncated";
var _ITTL = "IdleTTL";
var _Id = "Id";
var _It = "Items";
var _K = "Key";
var _KG = "KeyGroup";
var _KGC = "KeyGroupConfig";
var _KGI = "KeyGroupId";
var _KGS = "KeyGroupSummary";
var _KPI = "KeyPairId";
var _KPIe = "KeyPairIds";
var _KSC = "KinesisStreamConfig";
var _KVS = "KeyValueStore";
var _KVSA = "KeyValueStoreAssociations";
var _KVSARN = "KeyValueStoreARN";
var _KVSAe = "KeyValueStoreAssociation";
var _KVSC = "KeyValueStoreComment";
var _KVSN = "KeyValueStoreName";
var _L = "Location";
var _LC = "LoggingConfig";
var _LCGR = "ListConnectionGroupsRequest";
var _LDBRLCR = "ListDistributionsByRealtimeLogConfigRequest";
var _LDCR = "ListDomainConflictsRequest";
var _LDTBCR = "ListDistributionTenantsByCustomizationRequest";
var _LDTR = "ListDistributionTenantsRequest";
var _LFA = "LambdaFunctionAssociations";
var _LFARN = "LambdaFunctionARN";
var _LFAa = "LambdaFunctionAssociation";
var _LMT = "LastModifiedTime";
var _Lo = "Logging";
var _Loc = "Locations";
var _M = "Marker";
var _MB = "ModeBlock";
var _MCR = "ManagedCertificateRequest";
var _MI = "MaxItems";
var _MPV = "MinimumProtocolVersion";
var _MS = "MonitoringSubscription";
var _MTTL = "MinTTL";
var _MTTLa = "MaxTTL";
var _MTTLax = "MaximumTTL";
var _Me = "Message";
var _Mem = "Members";
var _Met = "Method";
var _N = "Name";
var _NM = "NextMarker";
var _O = "Operation";
var _OACC = "OriginAccessControlConfig";
var _OACI = "OriginAccessControlId";
var _OACOT = "OriginAccessControlOriginType";
var _OACOTr = "OriginAccessControlOriginTypes";
var _OACS = "OriginAccessControlSummary";
var _OACSB = "OriginAccessControlSigningBehaviors";
var _OACSP = "OriginAccessControlSigningProtocols";
var _OAI = "OriginAccessIdentity";
var _OCH = "OriginCustomHeader";
var _OEA = "OriginEndpointArn";
var _OG = "OriginGroups";
var _OGFC = "OriginGroupFailoverCriteria";
var _OGM = "OriginGroupMember";
var _OGMr = "OriginGroupMembers";
var _OGSC = "OriginGroupSelectionCriteria";
var _OGr = "OriginGroup";
var _OI = "OriginId";
var _OKT = "OriginKeepaliveTimeout";
var _OO = "OriginOverride";
var _OP = "OriginPath";
var _OPP = "OriginProtocolPolicy";
var _ORP = "OriginRequestPolicy";
var _ORPC = "OriginRequestPolicyConfig";
var _ORPCB = "OriginRequestPolicyCookieBehavior";
var _ORPCC = "OriginRequestPolicyCookiesConfig";
var _ORPHB = "OriginRequestPolicyHeaderBehavior";
var _ORPHC = "OriginRequestPolicyHeadersConfig";
var _ORPI = "OriginRequestPolicyId";
var _ORPQSB = "OriginRequestPolicyQueryStringBehavior";
var _ORPQSC = "OriginRequestPolicyQueryStringsConfig";
var _ORPS = "OriginRequestPolicySummary";
var _ORT = "OriginReadTimeout";
var _OS = "OriginShield";
var _OSP = "OriginSslProtocols";
var _OSR = "OriginShieldRegion";
var _Or = "Origin";
var _Ori = "Origins";
var _Ov = "Override";
var _P = "Parameters";
var _PC = "PriceClass";
var _PD = "ParameterDefinition";
var _PDN = "PrimaryDomainName";
var _PDS = "ParameterDefinitionSchema";
var _PDa = "ParameterDefinitions";
var _PI = "ProfileId";
var _PICKAFTO = "ParametersInCacheKeyAndForwardedToOrigin";
var _PIr = "ProviderId";
var _PK = "PublicKey";
var _PKC = "PublicKeyConfig";
var _PKI = "PublicKeyId";
var _PKS = "PublicKeySummary";
var _PN = "ParameterName";
var _PP = "PathPattern";
var _PV = "ParameterValue";
var _Pa = "Paths";
var _Par = "Parameter";
var _Pat = "Path";
var _Pr = "Prefix";
var _Pre = "Preload";
var _Pro = "Protection";
var _Q = "Quantity";
var _QA = "QueryArg";
var _QAP = "QueryArgProfile";
var _QAPC = "QueryArgProfileConfig";
var _QAPu = "QueryArgProfiles";
var _QS = "QueryStrings";
var _QSB = "QueryStringBehavior";
var _QSC = "QueryStringsConfig";
var _QSCK = "QueryStringCacheKeys";
var _QSN = "QueryStringNames";
var _QSu = "QueryString";
var _R = "Resource";
var _RARN = "RoleARN";
var _RC = "ResponseCode";
var _RE = "RoutingEndpoint";
var _RF = "RedirectFrom";
var _RHC = "RemoveHeadersConfig";
var _RHP = "ResponseHeadersPolicy";
var _RHPACAH = "ResponseHeadersPolicyAccessControlAllowHeaders";
var _RHPACAM = "ResponseHeadersPolicyAccessControlAllowMethods";
var _RHPACAMV = "ResponseHeadersPolicyAccessControlAllowMethodsValues";
var _RHPACAO = "ResponseHeadersPolicyAccessControlAllowOrigins";
var _RHPACEH = "ResponseHeadersPolicyAccessControlExposeHeaders";
var _RHPC = "ResponseHeadersPolicyConfig";
var _RHPCC = "ResponseHeadersPolicyCorsConfig";
var _RHPCH = "ResponseHeadersPolicyCustomHeader";
var _RHPCHC = "ResponseHeadersPolicyCustomHeadersConfig";
var _RHPCSP = "ResponseHeadersPolicyContentSecurityPolicy";
var _RHPCTO = "ResponseHeadersPolicyContentTypeOptions";
var _RHPFO = "ResponseHeadersPolicyFrameOptions";
var _RHPI = "ResponseHeadersPolicyId";
var _RHPRH = "ResponseHeadersPolicyRemoveHeader";
var _RHPRHC = "ResponseHeadersPolicyRemoveHeadersConfig";
var _RHPRP = "ResponseHeadersPolicyReferrerPolicy";
var _RHPS = "ResponseHeadersPolicySummary";
var _RHPSHC = "ResponseHeadersPolicySecurityHeadersConfig";
var _RHPSTHC = "ResponseHeadersPolicyServerTimingHeadersConfig";
var _RHPSTS = "ResponseHeadersPolicyStrictTransportSecurity";
var _RHPXSSP = "ResponseHeadersPolicyXSSProtection";
var _RI = "ResourceId";
var _RLC = "RealtimeLogConfig";
var _RLCA = "RealtimeLogConfigArn";
var _RLCN = "RealtimeLogConfigName";
var _RMSC = "RealtimeMetricsSubscriptionConfig";
var _RMSS = "RealtimeMetricsSubscriptionStatus";
var _RP = "ReferrerPolicy";
var _RPL = "ReferrerPolicyList";
var _RPP = "ResponsePagePath";
var _RT = "RestrictionType";
var _RTe = "ResourceType";
var _RTed = "RedirectTo";
var _RU = "ReportUri";
var _Re = "Restrictions";
var _Rea = "Reason";
var _Req = "Required";
var _Ru = "Runtime";
var _S = "Staging";
var _SARN = "SourceARN";
var _SARNt = "StreamARN";
var _SB = "SigningBehavior";
var _SC = "SelectionCriteria";
var _SCUI = "S3CanonicalUserId";
var _SCt = "StatusCodes";
var _SCta = "StatusCode";
var _SDC = "StreamingDistributionConfig";
var _SDCWT = "StreamingDistributionConfigWithTags";
var _SDDN = "StagingDistributionDnsNames";
var _SDI = "StagingDistributionId";
var _SDS = "StreamingDistributionSummary";
var _SHC = "SecurityHeadersConfig";
var _SHCi = "SingleHeaderConfig";
var _SLC = "StreamingLoggingConfig";
var _SO = "S3Origin";
var _SOC = "S3OriginConfig";
var _SP = "SigningProtocol";
var _SPs = "SslProtocol";
var _SR = "SamplingRate";
var _SS = "SmoothStreaming";
var _SSC = "SessionStickinessConfig";
var _SSCt = "StringSchemaConfig";
var _SSLSM = "SSLSupportMethod";
var _SSt = "StringSchema";
var _ST = "StreamType";
var _STHC = "ServerTimingHeadersConfig";
var _STS = "StrictTransportSecurity";
var _STo = "SourceType";
var _SWC = "SingleWeightConfig";
var _Si = "Signer";
var _St = "Stage";
var _Sta = "Status";
var _T = "Tags";
var _TC = "TrafficConfig";
var _TCe = "TenantConfig";
var _TFR = "TestFunctionRequest";
var _TK = "TagKey";
var _TKG = "TrustedKeyGroups";
var _TKa = "TagKeys";
var _TOI = "TargetOriginId";
var _TR = "TargetResource";
var _TS = "TrustedSigners";
var _TV = "TagValue";
var _Ta = "Tag";
var _Ty = "Type";
var _UCGR = "UpdateConnectionGroupRequest";
var _UDAR = "UpdateDomainAssociationRequest";
var _UDTR = "UpdateDistributionTenantRequest";
var _UFR = "UpdateFunctionRequest";
var _UKVSR = "UpdateKeyValueStoreRequest";
var _URLCR = "UpdateRealtimeLogConfigRequest";
var _V = "Value";
var _VC = "ViewerCertificate";
var _VDCR = "VerifyDnsConfigurationRequest";
var _VOC = "VpcOriginConfig";
var _VOEC = "VpcOriginEndpointConfig";
var _VOI = "VpcOriginId";
var _VOS = "VpcOriginSummary";
var _VPP = "ViewerProtocolPolicy";
var _VTD = "ValidationTokenDetails";
var _VTH = "ValidationTokenHost";
var _W = "Weight";
var _WA = "WebAcl";
var _WAC = "WebAclCustomization";
var _WACLA = "WebACLArn";
var _WACLI = "WebACLId";
var _WN = "WhitelistedNames";
var _WT = "WithTags";
var _XSSP = "XSSProtection";
var _b = "boolean";
var _ct = "content-type";
var _d = "domain";
var _e = "etag";
var _et = "ettag";
var _f = "float";
var _i = "integer";
var _im = "if-match";
var _l = "long";
var _lo = "location";
var _m = "member";
var _s = "string";
var _sST = "sensitiveStringType";
var _st = "staging";
var _ve = '<?xml version="1.0" encoding="UTF-8"?>';

// src/commands/AssociateAliasCommand.ts
var AssociateAliasCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("Cloudfront2020_05_31", "AssociateAlias", {}).n("CloudFrontClient", "AssociateAliasCommand").f(void 0, void 0).ser(se_AssociateAliasCommand).de(de_AssociateAliasCommand).build() {
  static {
    __name(this, "AssociateAliasCommand");
  }
};

// src/commands/AssociateDistributionTenantWebACLCommand.ts



var AssociateDistributionTenantWebACLCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("Cloudfront2020_05_31", "AssociateDistributionTenantWebACL", {}).n("CloudFrontClient", "AssociateDistributionTenantWebACLCommand").f(void 0, void 0).ser(se_AssociateDistributionTenantWebACLCommand).de(de_AssociateDistributionTenantWebACLCommand).build() {
  static {
    __name(this, "AssociateDistributionTenantWebACLCommand");
  }
};

// src/commands/AssociateDistributionWebACLCommand.ts



var AssociateDistributionWebACLCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("Cloudfront2020_05_31", "AssociateDistributionWebACL", {}).n("CloudFrontClient", "AssociateDistributionWebACLCommand").f(void 0, void 0).ser(se_AssociateDistributionWebACLCommand).de(de_AssociateDistributionWebACLCommand).build() {
  static {
    __name(this, "AssociateDistributionWebACLCommand");
  }
};

// src/commands/CopyDistributionCommand.ts



var CopyDistributionCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("Cloudfront2020_05_31", "CopyDistribution", {}).n("CloudFrontClient", "CopyDistributionCommand").f(void 0, CopyDistributionResultFilterSensitiveLog).ser(se_CopyDistributionCommand).de(de_CopyDistributionCommand).build() {
  static {
    __name(this, "CopyDistributionCommand");
  }
};

// src/commands/CreateAnycastIpListCommand.ts



var CreateAnycastIpListCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("Cloudfront2020_05_31", "CreateAnycastIpList", {}).n("CloudFrontClient", "CreateAnycastIpListCommand").f(void 0, void 0).ser(se_CreateAnycastIpListCommand).de(de_CreateAnycastIpListCommand).build() {
  static {
    __name(this, "CreateAnycastIpListCommand");
  }
};

// src/commands/CreateCachePolicyCommand.ts



var CreateCachePolicyCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("Cloudfront2020_05_31", "CreateCachePolicy", {}).n("CloudFrontClient", "CreateCachePolicyCommand").f(void 0, void 0).ser(se_CreateCachePolicyCommand).de(de_CreateCachePolicyCommand).build() {
  static {
    __name(this, "CreateCachePolicyCommand");
  }
};

// src/commands/CreateCloudFrontOriginAccessIdentityCommand.ts



var CreateCloudFrontOriginAccessIdentityCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("Cloudfront2020_05_31", "CreateCloudFrontOriginAccessIdentity", {}).n("CloudFrontClient", "CreateCloudFrontOriginAccessIdentityCommand").f(void 0, void 0).ser(se_CreateCloudFrontOriginAccessIdentityCommand).de(de_CreateCloudFrontOriginAccessIdentityCommand).build() {
  static {
    __name(this, "CreateCloudFrontOriginAccessIdentityCommand");
  }
};

// src/commands/CreateConnectionGroupCommand.ts



var CreateConnectionGroupCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("Cloudfront2020_05_31", "CreateConnectionGroup", {}).n("CloudFrontClient", "CreateConnectionGroupCommand").f(void 0, void 0).ser(se_CreateConnectionGroupCommand).de(de_CreateConnectionGroupCommand).build() {
  static {
    __name(this, "CreateConnectionGroupCommand");
  }
};

// src/commands/CreateContinuousDeploymentPolicyCommand.ts



var CreateContinuousDeploymentPolicyCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("Cloudfront2020_05_31", "CreateContinuousDeploymentPolicy", {}).n("CloudFrontClient", "CreateContinuousDeploymentPolicyCommand").f(void 0, void 0).ser(se_CreateContinuousDeploymentPolicyCommand).de(de_CreateContinuousDeploymentPolicyCommand).build() {
  static {
    __name(this, "CreateContinuousDeploymentPolicyCommand");
  }
};

// src/commands/CreateDistributionCommand.ts



var CreateDistributionCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("Cloudfront2020_05_31", "CreateDistribution", {}).n("CloudFrontClient", "CreateDistributionCommand").f(CreateDistributionRequestFilterSensitiveLog, CreateDistributionResultFilterSensitiveLog).ser(se_CreateDistributionCommand).de(de_CreateDistributionCommand).build() {
  static {
    __name(this, "CreateDistributionCommand");
  }
};

// src/commands/CreateDistributionTenantCommand.ts



var CreateDistributionTenantCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("Cloudfront2020_05_31", "CreateDistributionTenant", {}).n("CloudFrontClient", "CreateDistributionTenantCommand").f(void 0, void 0).ser(se_CreateDistributionTenantCommand).de(de_CreateDistributionTenantCommand).build() {
  static {
    __name(this, "CreateDistributionTenantCommand");
  }
};

// src/commands/CreateDistributionWithTagsCommand.ts



var CreateDistributionWithTagsCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("Cloudfront2020_05_31", "CreateDistributionWithTags", {}).n("CloudFrontClient", "CreateDistributionWithTagsCommand").f(CreateDistributionWithTagsRequestFilterSensitiveLog, CreateDistributionWithTagsResultFilterSensitiveLog).ser(se_CreateDistributionWithTagsCommand).de(de_CreateDistributionWithTagsCommand).build() {
  static {
    __name(this, "CreateDistributionWithTagsCommand");
  }
};

// src/commands/CreateFieldLevelEncryptionConfigCommand.ts



var CreateFieldLevelEncryptionConfigCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("Cloudfront2020_05_31", "CreateFieldLevelEncryptionConfig", {}).n("CloudFrontClient", "CreateFieldLevelEncryptionConfigCommand").f(void 0, void 0).ser(se_CreateFieldLevelEncryptionConfigCommand).de(de_CreateFieldLevelEncryptionConfigCommand).build() {
  static {
    __name(this, "CreateFieldLevelEncryptionConfigCommand");
  }
};

// src/commands/CreateFieldLevelEncryptionProfileCommand.ts



var CreateFieldLevelEncryptionProfileCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("Cloudfront2020_05_31", "CreateFieldLevelEncryptionProfile", {}).n("CloudFrontClient", "CreateFieldLevelEncryptionProfileCommand").f(void 0, void 0).ser(se_CreateFieldLevelEncryptionProfileCommand).de(de_CreateFieldLevelEncryptionProfileCommand).build() {
  static {
    __name(this, "CreateFieldLevelEncryptionProfileCommand");
  }
};

// src/commands/CreateFunctionCommand.ts



var CreateFunctionCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("Cloudfront2020_05_31", "CreateFunction", {}).n("CloudFrontClient", "CreateFunctionCommand").f(CreateFunctionRequestFilterSensitiveLog, void 0).ser(se_CreateFunctionCommand).de(de_CreateFunctionCommand).build() {
  static {
    __name(this, "CreateFunctionCommand");
  }
};

// src/commands/CreateInvalidationCommand.ts



var CreateInvalidationCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("Cloudfront2020_05_31", "CreateInvalidation", {}).n("CloudFrontClient", "CreateInvalidationCommand").f(void 0, void 0).ser(se_CreateInvalidationCommand).de(de_CreateInvalidationCommand).build() {
  static {
    __name(this, "CreateInvalidationCommand");
  }
};

// src/commands/CreateInvalidationForDistributionTenantCommand.ts



var CreateInvalidationForDistributionTenantCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("Cloudfront2020_05_31", "CreateInvalidationForDistributionTenant", {}).n("CloudFrontClient", "CreateInvalidationForDistributionTenantCommand").f(void 0, void 0).ser(se_CreateInvalidationForDistributionTenantCommand).de(de_CreateInvalidationForDistributionTenantCommand).build() {
  static {
    __name(this, "CreateInvalidationForDistributionTenantCommand");
  }
};

// src/commands/CreateKeyGroupCommand.ts



var CreateKeyGroupCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("Cloudfront2020_05_31", "CreateKeyGroup", {}).n("CloudFrontClient", "CreateKeyGroupCommand").f(void 0, void 0).ser(se_CreateKeyGroupCommand).de(de_CreateKeyGroupCommand).build() {
  static {
    __name(this, "CreateKeyGroupCommand");
  }
};

// src/commands/CreateKeyValueStoreCommand.ts



var CreateKeyValueStoreCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("Cloudfront2020_05_31", "CreateKeyValueStore", {}).n("CloudFrontClient", "CreateKeyValueStoreCommand").f(void 0, void 0).ser(se_CreateKeyValueStoreCommand).de(de_CreateKeyValueStoreCommand).build() {
  static {
    __name(this, "CreateKeyValueStoreCommand");
  }
};

// src/commands/CreateMonitoringSubscriptionCommand.ts



var CreateMonitoringSubscriptionCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("Cloudfront2020_05_31", "CreateMonitoringSubscription", {}).n("CloudFrontClient", "CreateMonitoringSubscriptionCommand").f(void 0, void 0).ser(se_CreateMonitoringSubscriptionCommand).de(de_CreateMonitoringSubscriptionCommand).build() {
  static {
    __name(this, "CreateMonitoringSubscriptionCommand");
  }
};

// src/commands/CreateOriginAccessControlCommand.ts



var CreateOriginAccessControlCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("Cloudfront2020_05_31", "CreateOriginAccessControl", {}).n("CloudFrontClient", "CreateOriginAccessControlCommand").f(void 0, void 0).ser(se_CreateOriginAccessControlCommand).de(de_CreateOriginAccessControlCommand).build() {
  static {
    __name(this, "CreateOriginAccessControlCommand");
  }
};

// src/commands/CreateOriginRequestPolicyCommand.ts



var CreateOriginRequestPolicyCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("Cloudfront2020_05_31", "CreateOriginRequestPolicy", {}).n("CloudFrontClient", "CreateOriginRequestPolicyCommand").f(void 0, void 0).ser(se_CreateOriginRequestPolicyCommand).de(de_CreateOriginRequestPolicyCommand).build() {
  static {
    __name(this, "CreateOriginRequestPolicyCommand");
  }
};

// src/commands/CreatePublicKeyCommand.ts



var CreatePublicKeyCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("Cloudfront2020_05_31", "CreatePublicKey", {}).n("CloudFrontClient", "CreatePublicKeyCommand").f(void 0, void 0).ser(se_CreatePublicKeyCommand).de(de_CreatePublicKeyCommand).build() {
  static {
    __name(this, "CreatePublicKeyCommand");
  }
};

// src/commands/CreateRealtimeLogConfigCommand.ts



var CreateRealtimeLogConfigCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("Cloudfront2020_05_31", "CreateRealtimeLogConfig", {}).n("CloudFrontClient", "CreateRealtimeLogConfigCommand").f(void 0, void 0).ser(se_CreateRealtimeLogConfigCommand).de(de_CreateRealtimeLogConfigCommand).build() {
  static {
    __name(this, "CreateRealtimeLogConfigCommand");
  }
};

// src/commands/CreateResponseHeadersPolicyCommand.ts



var CreateResponseHeadersPolicyCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("Cloudfront2020_05_31", "CreateResponseHeadersPolicy", {}).n("CloudFrontClient", "CreateResponseHeadersPolicyCommand").f(void 0, void 0).ser(se_CreateResponseHeadersPolicyCommand).de(de_CreateResponseHeadersPolicyCommand).build() {
  static {
    __name(this, "CreateResponseHeadersPolicyCommand");
  }
};

// src/commands/CreateStreamingDistributionCommand.ts



var CreateStreamingDistributionCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("Cloudfront2020_05_31", "CreateStreamingDistribution", {}).n("CloudFrontClient", "CreateStreamingDistributionCommand").f(void 0, void 0).ser(se_CreateStreamingDistributionCommand).de(de_CreateStreamingDistributionCommand).build() {
  static {
    __name(this, "CreateStreamingDistributionCommand");
  }
};

// src/commands/CreateStreamingDistributionWithTagsCommand.ts



var CreateStreamingDistributionWithTagsCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("Cloudfront2020_05_31", "CreateStreamingDistributionWithTags", {}).n("CloudFrontClient", "CreateStreamingDistributionWithTagsCommand").f(void 0, void 0).ser(se_CreateStreamingDistributionWithTagsCommand).de(de_CreateStreamingDistributionWithTagsCommand).build() {
  static {
    __name(this, "CreateStreamingDistributionWithTagsCommand");
  }
};

// src/commands/CreateVpcOriginCommand.ts



var CreateVpcOriginCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("Cloudfront2020_05_31", "CreateVpcOrigin", {}).n("CloudFrontClient", "CreateVpcOriginCommand").f(void 0, void 0).ser(se_CreateVpcOriginCommand).de(de_CreateVpcOriginCommand).build() {
  static {
    __name(this, "CreateVpcOriginCommand");
  }
};

// src/commands/DeleteAnycastIpListCommand.ts



var DeleteAnycastIpListCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("Cloudfront2020_05_31", "DeleteAnycastIpList", {}).n("CloudFrontClient", "DeleteAnycastIpListCommand").f(void 0, void 0).ser(se_DeleteAnycastIpListCommand).de(de_DeleteAnycastIpListCommand).build() {
  static {
    __name(this, "DeleteAnycastIpListCommand");
  }
};

// src/commands/DeleteCachePolicyCommand.ts



var DeleteCachePolicyCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("Cloudfront2020_05_31", "DeleteCachePolicy", {}).n("CloudFrontClient", "DeleteCachePolicyCommand").f(void 0, void 0).ser(se_DeleteCachePolicyCommand).de(de_DeleteCachePolicyCommand).build() {
  static {
    __name(this, "DeleteCachePolicyCommand");
  }
};

// src/commands/DeleteCloudFrontOriginAccessIdentityCommand.ts



var DeleteCloudFrontOriginAccessIdentityCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("Cloudfront2020_05_31", "DeleteCloudFrontOriginAccessIdentity", {}).n("CloudFrontClient", "DeleteCloudFrontOriginAccessIdentityCommand").f(void 0, void 0).ser(se_DeleteCloudFrontOriginAccessIdentityCommand).de(de_DeleteCloudFrontOriginAccessIdentityCommand).build() {
  static {
    __name(this, "DeleteCloudFrontOriginAccessIdentityCommand");
  }
};

// src/commands/DeleteConnectionGroupCommand.ts



var DeleteConnectionGroupCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("Cloudfront2020_05_31", "DeleteConnectionGroup", {}).n("CloudFrontClient", "DeleteConnectionGroupCommand").f(void 0, void 0).ser(se_DeleteConnectionGroupCommand).de(de_DeleteConnectionGroupCommand).build() {
  static {
    __name(this, "DeleteConnectionGroupCommand");
  }
};

// src/commands/DeleteContinuousDeploymentPolicyCommand.ts



var DeleteContinuousDeploymentPolicyCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("Cloudfront2020_05_31", "DeleteContinuousDeploymentPolicy", {}).n("CloudFrontClient", "DeleteContinuousDeploymentPolicyCommand").f(void 0, void 0).ser(se_DeleteContinuousDeploymentPolicyCommand).de(de_DeleteContinuousDeploymentPolicyCommand).build() {
  static {
    __name(this, "DeleteContinuousDeploymentPolicyCommand");
  }
};

// src/commands/DeleteDistributionCommand.ts



var DeleteDistributionCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("Cloudfront2020_05_31", "DeleteDistribution", {}).n("CloudFrontClient", "DeleteDistributionCommand").f(void 0, void 0).ser(se_DeleteDistributionCommand).de(de_DeleteDistributionCommand).build() {
  static {
    __name(this, "DeleteDistributionCommand");
  }
};

// src/commands/DeleteDistributionTenantCommand.ts



var DeleteDistributionTenantCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("Cloudfront2020_05_31", "DeleteDistributionTenant", {}).n("CloudFrontClient", "DeleteDistributionTenantCommand").f(void 0, void 0).ser(se_DeleteDistributionTenantCommand).de(de_DeleteDistributionTenantCommand).build() {
  static {
    __name(this, "DeleteDistributionTenantCommand");
  }
};

// src/commands/DeleteFieldLevelEncryptionConfigCommand.ts



var DeleteFieldLevelEncryptionConfigCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("Cloudfront2020_05_31", "DeleteFieldLevelEncryptionConfig", {}).n("CloudFrontClient", "DeleteFieldLevelEncryptionConfigCommand").f(void 0, void 0).ser(se_DeleteFieldLevelEncryptionConfigCommand).de(de_DeleteFieldLevelEncryptionConfigCommand).build() {
  static {
    __name(this, "DeleteFieldLevelEncryptionConfigCommand");
  }
};

// src/commands/DeleteFieldLevelEncryptionProfileCommand.ts



var DeleteFieldLevelEncryptionProfileCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("Cloudfront2020_05_31", "DeleteFieldLevelEncryptionProfile", {}).n("CloudFrontClient", "DeleteFieldLevelEncryptionProfileCommand").f(void 0, void 0).ser(se_DeleteFieldLevelEncryptionProfileCommand).de(de_DeleteFieldLevelEncryptionProfileCommand).build() {
  static {
    __name(this, "DeleteFieldLevelEncryptionProfileCommand");
  }
};

// src/commands/DeleteFunctionCommand.ts



var DeleteFunctionCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("Cloudfront2020_05_31", "DeleteFunction", {}).n("CloudFrontClient", "DeleteFunctionCommand").f(void 0, void 0).ser(se_DeleteFunctionCommand).de(de_DeleteFunctionCommand).build() {
  static {
    __name(this, "DeleteFunctionCommand");
  }
};

// src/commands/DeleteKeyGroupCommand.ts



var DeleteKeyGroupCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("Cloudfront2020_05_31", "DeleteKeyGroup", {}).n("CloudFrontClient", "DeleteKeyGroupCommand").f(void 0, void 0).ser(se_DeleteKeyGroupCommand).de(de_DeleteKeyGroupCommand).build() {
  static {
    __name(this, "DeleteKeyGroupCommand");
  }
};

// src/commands/DeleteKeyValueStoreCommand.ts



var DeleteKeyValueStoreCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("Cloudfront2020_05_31", "DeleteKeyValueStore", {}).n("CloudFrontClient", "DeleteKeyValueStoreCommand").f(void 0, void 0).ser(se_DeleteKeyValueStoreCommand).de(de_DeleteKeyValueStoreCommand).build() {
  static {
    __name(this, "DeleteKeyValueStoreCommand");
  }
};

// src/commands/DeleteMonitoringSubscriptionCommand.ts



var DeleteMonitoringSubscriptionCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("Cloudfront2020_05_31", "DeleteMonitoringSubscription", {}).n("CloudFrontClient", "DeleteMonitoringSubscriptionCommand").f(void 0, void 0).ser(se_DeleteMonitoringSubscriptionCommand).de(de_DeleteMonitoringSubscriptionCommand).build() {
  static {
    __name(this, "DeleteMonitoringSubscriptionCommand");
  }
};

// src/commands/DeleteOriginAccessControlCommand.ts



var DeleteOriginAccessControlCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("Cloudfront2020_05_31", "DeleteOriginAccessControl", {}).n("CloudFrontClient", "DeleteOriginAccessControlCommand").f(void 0, void 0).ser(se_DeleteOriginAccessControlCommand).de(de_DeleteOriginAccessControlCommand).build() {
  static {
    __name(this, "DeleteOriginAccessControlCommand");
  }
};

// src/commands/DeleteOriginRequestPolicyCommand.ts



var DeleteOriginRequestPolicyCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("Cloudfront2020_05_31", "DeleteOriginRequestPolicy", {}).n("CloudFrontClient", "DeleteOriginRequestPolicyCommand").f(void 0, void 0).ser(se_DeleteOriginRequestPolicyCommand).de(de_DeleteOriginRequestPolicyCommand).build() {
  static {
    __name(this, "DeleteOriginRequestPolicyCommand");
  }
};

// src/commands/DeletePublicKeyCommand.ts



var DeletePublicKeyCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("Cloudfront2020_05_31", "DeletePublicKey", {}).n("CloudFrontClient", "DeletePublicKeyCommand").f(void 0, void 0).ser(se_DeletePublicKeyCommand).de(de_DeletePublicKeyCommand).build() {
  static {
    __name(this, "DeletePublicKeyCommand");
  }
};

// src/commands/DeleteRealtimeLogConfigCommand.ts



var DeleteRealtimeLogConfigCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("Cloudfront2020_05_31", "DeleteRealtimeLogConfig", {}).n("CloudFrontClient", "DeleteRealtimeLogConfigCommand").f(void 0, void 0).ser(se_DeleteRealtimeLogConfigCommand).de(de_DeleteRealtimeLogConfigCommand).build() {
  static {
    __name(this, "DeleteRealtimeLogConfigCommand");
  }
};

// src/commands/DeleteResponseHeadersPolicyCommand.ts



var DeleteResponseHeadersPolicyCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("Cloudfront2020_05_31", "DeleteResponseHeadersPolicy", {}).n("CloudFrontClient", "DeleteResponseHeadersPolicyCommand").f(void 0, void 0).ser(se_DeleteResponseHeadersPolicyCommand).de(de_DeleteResponseHeadersPolicyCommand).build() {
  static {
    __name(this, "DeleteResponseHeadersPolicyCommand");
  }
};

// src/commands/DeleteStreamingDistributionCommand.ts



var DeleteStreamingDistributionCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("Cloudfront2020_05_31", "DeleteStreamingDistribution", {}).n("CloudFrontClient", "DeleteStreamingDistributionCommand").f(void 0, void 0).ser(se_DeleteStreamingDistributionCommand).de(de_DeleteStreamingDistributionCommand).build() {
  static {
    __name(this, "DeleteStreamingDistributionCommand");
  }
};

// src/commands/DeleteVpcOriginCommand.ts



var DeleteVpcOriginCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("Cloudfront2020_05_31", "DeleteVpcOrigin", {}).n("CloudFrontClient", "DeleteVpcOriginCommand").f(void 0, void 0).ser(se_DeleteVpcOriginCommand).de(de_DeleteVpcOriginCommand).build() {
  static {
    __name(this, "DeleteVpcOriginCommand");
  }
};

// src/commands/DescribeFunctionCommand.ts



var DescribeFunctionCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("Cloudfront2020_05_31", "DescribeFunction", {}).n("CloudFrontClient", "DescribeFunctionCommand").f(void 0, void 0).ser(se_DescribeFunctionCommand).de(de_DescribeFunctionCommand).build() {
  static {
    __name(this, "DescribeFunctionCommand");
  }
};

// src/commands/DescribeKeyValueStoreCommand.ts



var DescribeKeyValueStoreCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("Cloudfront2020_05_31", "DescribeKeyValueStore", {}).n("CloudFrontClient", "DescribeKeyValueStoreCommand").f(void 0, void 0).ser(se_DescribeKeyValueStoreCommand).de(de_DescribeKeyValueStoreCommand).build() {
  static {
    __name(this, "DescribeKeyValueStoreCommand");
  }
};

// src/commands/DisassociateDistributionTenantWebACLCommand.ts



var DisassociateDistributionTenantWebACLCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("Cloudfront2020_05_31", "DisassociateDistributionTenantWebACL", {}).n("CloudFrontClient", "DisassociateDistributionTenantWebACLCommand").f(void 0, void 0).ser(se_DisassociateDistributionTenantWebACLCommand).de(de_DisassociateDistributionTenantWebACLCommand).build() {
  static {
    __name(this, "DisassociateDistributionTenantWebACLCommand");
  }
};

// src/commands/DisassociateDistributionWebACLCommand.ts



var DisassociateDistributionWebACLCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("Cloudfront2020_05_31", "DisassociateDistributionWebACL", {}).n("CloudFrontClient", "DisassociateDistributionWebACLCommand").f(void 0, void 0).ser(se_DisassociateDistributionWebACLCommand).de(de_DisassociateDistributionWebACLCommand).build() {
  static {
    __name(this, "DisassociateDistributionWebACLCommand");
  }
};

// src/commands/GetAnycastIpListCommand.ts



var GetAnycastIpListCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("Cloudfront2020_05_31", "GetAnycastIpList", {}).n("CloudFrontClient", "GetAnycastIpListCommand").f(void 0, void 0).ser(se_GetAnycastIpListCommand).de(de_GetAnycastIpListCommand).build() {
  static {
    __name(this, "GetAnycastIpListCommand");
  }
};

// src/commands/GetCachePolicyCommand.ts



var GetCachePolicyCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("Cloudfront2020_05_31", "GetCachePolicy", {}).n("CloudFrontClient", "GetCachePolicyCommand").f(void 0, void 0).ser(se_GetCachePolicyCommand).de(de_GetCachePolicyCommand).build() {
  static {
    __name(this, "GetCachePolicyCommand");
  }
};

// src/commands/GetCachePolicyConfigCommand.ts



var GetCachePolicyConfigCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("Cloudfront2020_05_31", "GetCachePolicyConfig", {}).n("CloudFrontClient", "GetCachePolicyConfigCommand").f(void 0, void 0).ser(se_GetCachePolicyConfigCommand).de(de_GetCachePolicyConfigCommand).build() {
  static {
    __name(this, "GetCachePolicyConfigCommand");
  }
};

// src/commands/GetCloudFrontOriginAccessIdentityCommand.ts



var GetCloudFrontOriginAccessIdentityCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("Cloudfront2020_05_31", "GetCloudFrontOriginAccessIdentity", {}).n("CloudFrontClient", "GetCloudFrontOriginAccessIdentityCommand").f(void 0, void 0).ser(se_GetCloudFrontOriginAccessIdentityCommand).de(de_GetCloudFrontOriginAccessIdentityCommand).build() {
  static {
    __name(this, "GetCloudFrontOriginAccessIdentityCommand");
  }
};

// src/commands/GetCloudFrontOriginAccessIdentityConfigCommand.ts



var GetCloudFrontOriginAccessIdentityConfigCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("Cloudfront2020_05_31", "GetCloudFrontOriginAccessIdentityConfig", {}).n("CloudFrontClient", "GetCloudFrontOriginAccessIdentityConfigCommand").f(void 0, void 0).ser(se_GetCloudFrontOriginAccessIdentityConfigCommand).de(de_GetCloudFrontOriginAccessIdentityConfigCommand).build() {
  static {
    __name(this, "GetCloudFrontOriginAccessIdentityConfigCommand");
  }
};

// src/commands/GetConnectionGroupByRoutingEndpointCommand.ts



var GetConnectionGroupByRoutingEndpointCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("Cloudfront2020_05_31", "GetConnectionGroupByRoutingEndpoint", {}).n("CloudFrontClient", "GetConnectionGroupByRoutingEndpointCommand").f(void 0, void 0).ser(se_GetConnectionGroupByRoutingEndpointCommand).de(de_GetConnectionGroupByRoutingEndpointCommand).build() {
  static {
    __name(this, "GetConnectionGroupByRoutingEndpointCommand");
  }
};

// src/commands/GetConnectionGroupCommand.ts



var GetConnectionGroupCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("Cloudfront2020_05_31", "GetConnectionGroup", {}).n("CloudFrontClient", "GetConnectionGroupCommand").f(void 0, void 0).ser(se_GetConnectionGroupCommand).de(de_GetConnectionGroupCommand).build() {
  static {
    __name(this, "GetConnectionGroupCommand");
  }
};

// src/commands/GetContinuousDeploymentPolicyCommand.ts



var GetContinuousDeploymentPolicyCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("Cloudfront2020_05_31", "GetContinuousDeploymentPolicy", {}).n("CloudFrontClient", "GetContinuousDeploymentPolicyCommand").f(void 0, void 0).ser(se_GetContinuousDeploymentPolicyCommand).de(de_GetContinuousDeploymentPolicyCommand).build() {
  static {
    __name(this, "GetContinuousDeploymentPolicyCommand");
  }
};

// src/commands/GetContinuousDeploymentPolicyConfigCommand.ts



var GetContinuousDeploymentPolicyConfigCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("Cloudfront2020_05_31", "GetContinuousDeploymentPolicyConfig", {}).n("CloudFrontClient", "GetContinuousDeploymentPolicyConfigCommand").f(void 0, void 0).ser(se_GetContinuousDeploymentPolicyConfigCommand).de(de_GetContinuousDeploymentPolicyConfigCommand).build() {
  static {
    __name(this, "GetContinuousDeploymentPolicyConfigCommand");
  }
};

// src/commands/GetDistributionCommand.ts



var GetDistributionCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("Cloudfront2020_05_31", "GetDistribution", {}).n("CloudFrontClient", "GetDistributionCommand").f(void 0, GetDistributionResultFilterSensitiveLog).ser(se_GetDistributionCommand).de(de_GetDistributionCommand).build() {
  static {
    __name(this, "GetDistributionCommand");
  }
};

// src/commands/GetDistributionConfigCommand.ts



var GetDistributionConfigCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("Cloudfront2020_05_31", "GetDistributionConfig", {}).n("CloudFrontClient", "GetDistributionConfigCommand").f(void 0, GetDistributionConfigResultFilterSensitiveLog).ser(se_GetDistributionConfigCommand).de(de_GetDistributionConfigCommand).build() {
  static {
    __name(this, "GetDistributionConfigCommand");
  }
};

// src/commands/GetDistributionTenantByDomainCommand.ts



var GetDistributionTenantByDomainCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("Cloudfront2020_05_31", "GetDistributionTenantByDomain", {}).n("CloudFrontClient", "GetDistributionTenantByDomainCommand").f(void 0, void 0).ser(se_GetDistributionTenantByDomainCommand).de(de_GetDistributionTenantByDomainCommand).build() {
  static {
    __name(this, "GetDistributionTenantByDomainCommand");
  }
};

// src/commands/GetDistributionTenantCommand.ts



var GetDistributionTenantCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("Cloudfront2020_05_31", "GetDistributionTenant", {}).n("CloudFrontClient", "GetDistributionTenantCommand").f(void 0, void 0).ser(se_GetDistributionTenantCommand).de(de_GetDistributionTenantCommand).build() {
  static {
    __name(this, "GetDistributionTenantCommand");
  }
};

// src/commands/GetFieldLevelEncryptionCommand.ts



var GetFieldLevelEncryptionCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("Cloudfront2020_05_31", "GetFieldLevelEncryption", {}).n("CloudFrontClient", "GetFieldLevelEncryptionCommand").f(void 0, void 0).ser(se_GetFieldLevelEncryptionCommand).de(de_GetFieldLevelEncryptionCommand).build() {
  static {
    __name(this, "GetFieldLevelEncryptionCommand");
  }
};

// src/commands/GetFieldLevelEncryptionConfigCommand.ts



var GetFieldLevelEncryptionConfigCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("Cloudfront2020_05_31", "GetFieldLevelEncryptionConfig", {}).n("CloudFrontClient", "GetFieldLevelEncryptionConfigCommand").f(void 0, void 0).ser(se_GetFieldLevelEncryptionConfigCommand).de(de_GetFieldLevelEncryptionConfigCommand).build() {
  static {
    __name(this, "GetFieldLevelEncryptionConfigCommand");
  }
};

// src/commands/GetFieldLevelEncryptionProfileCommand.ts



var GetFieldLevelEncryptionProfileCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("Cloudfront2020_05_31", "GetFieldLevelEncryptionProfile", {}).n("CloudFrontClient", "GetFieldLevelEncryptionProfileCommand").f(void 0, void 0).ser(se_GetFieldLevelEncryptionProfileCommand).de(de_GetFieldLevelEncryptionProfileCommand).build() {
  static {
    __name(this, "GetFieldLevelEncryptionProfileCommand");
  }
};

// src/commands/GetFieldLevelEncryptionProfileConfigCommand.ts



var GetFieldLevelEncryptionProfileConfigCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("Cloudfront2020_05_31", "GetFieldLevelEncryptionProfileConfig", {}).n("CloudFrontClient", "GetFieldLevelEncryptionProfileConfigCommand").f(void 0, void 0).ser(se_GetFieldLevelEncryptionProfileConfigCommand).de(de_GetFieldLevelEncryptionProfileConfigCommand).build() {
  static {
    __name(this, "GetFieldLevelEncryptionProfileConfigCommand");
  }
};

// src/commands/GetFunctionCommand.ts



var GetFunctionCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("Cloudfront2020_05_31", "GetFunction", {}).n("CloudFrontClient", "GetFunctionCommand").f(void 0, GetFunctionResultFilterSensitiveLog).ser(se_GetFunctionCommand).de(de_GetFunctionCommand).build() {
  static {
    __name(this, "GetFunctionCommand");
  }
};

// src/commands/GetInvalidationCommand.ts



var GetInvalidationCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("Cloudfront2020_05_31", "GetInvalidation", {}).n("CloudFrontClient", "GetInvalidationCommand").f(void 0, void 0).ser(se_GetInvalidationCommand).de(de_GetInvalidationCommand).build() {
  static {
    __name(this, "GetInvalidationCommand");
  }
};

// src/commands/GetInvalidationForDistributionTenantCommand.ts



var GetInvalidationForDistributionTenantCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("Cloudfront2020_05_31", "GetInvalidationForDistributionTenant", {}).n("CloudFrontClient", "GetInvalidationForDistributionTenantCommand").f(void 0, void 0).ser(se_GetInvalidationForDistributionTenantCommand).de(de_GetInvalidationForDistributionTenantCommand).build() {
  static {
    __name(this, "GetInvalidationForDistributionTenantCommand");
  }
};

// src/commands/GetKeyGroupCommand.ts



var GetKeyGroupCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("Cloudfront2020_05_31", "GetKeyGroup", {}).n("CloudFrontClient", "GetKeyGroupCommand").f(void 0, void 0).ser(se_GetKeyGroupCommand).de(de_GetKeyGroupCommand).build() {
  static {
    __name(this, "GetKeyGroupCommand");
  }
};

// src/commands/GetKeyGroupConfigCommand.ts



var GetKeyGroupConfigCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("Cloudfront2020_05_31", "GetKeyGroupConfig", {}).n("CloudFrontClient", "GetKeyGroupConfigCommand").f(void 0, void 0).ser(se_GetKeyGroupConfigCommand).de(de_GetKeyGroupConfigCommand).build() {
  static {
    __name(this, "GetKeyGroupConfigCommand");
  }
};

// src/commands/GetManagedCertificateDetailsCommand.ts



var GetManagedCertificateDetailsCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("Cloudfront2020_05_31", "GetManagedCertificateDetails", {}).n("CloudFrontClient", "GetManagedCertificateDetailsCommand").f(void 0, void 0).ser(se_GetManagedCertificateDetailsCommand).de(de_GetManagedCertificateDetailsCommand).build() {
  static {
    __name(this, "GetManagedCertificateDetailsCommand");
  }
};

// src/commands/GetMonitoringSubscriptionCommand.ts



var GetMonitoringSubscriptionCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("Cloudfront2020_05_31", "GetMonitoringSubscription", {}).n("CloudFrontClient", "GetMonitoringSubscriptionCommand").f(void 0, void 0).ser(se_GetMonitoringSubscriptionCommand).de(de_GetMonitoringSubscriptionCommand).build() {
  static {
    __name(this, "GetMonitoringSubscriptionCommand");
  }
};

// src/commands/GetOriginAccessControlCommand.ts



var GetOriginAccessControlCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("Cloudfront2020_05_31", "GetOriginAccessControl", {}).n("CloudFrontClient", "GetOriginAccessControlCommand").f(void 0, void 0).ser(se_GetOriginAccessControlCommand).de(de_GetOriginAccessControlCommand).build() {
  static {
    __name(this, "GetOriginAccessControlCommand");
  }
};

// src/commands/GetOriginAccessControlConfigCommand.ts



var GetOriginAccessControlConfigCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("Cloudfront2020_05_31", "GetOriginAccessControlConfig", {}).n("CloudFrontClient", "GetOriginAccessControlConfigCommand").f(void 0, void 0).ser(se_GetOriginAccessControlConfigCommand).de(de_GetOriginAccessControlConfigCommand).build() {
  static {
    __name(this, "GetOriginAccessControlConfigCommand");
  }
};

// src/commands/GetOriginRequestPolicyCommand.ts



var GetOriginRequestPolicyCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("Cloudfront2020_05_31", "GetOriginRequestPolicy", {}).n("CloudFrontClient", "GetOriginRequestPolicyCommand").f(void 0, void 0).ser(se_GetOriginRequestPolicyCommand).de(de_GetOriginRequestPolicyCommand).build() {
  static {
    __name(this, "GetOriginRequestPolicyCommand");
  }
};

// src/commands/GetOriginRequestPolicyConfigCommand.ts



var GetOriginRequestPolicyConfigCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("Cloudfront2020_05_31", "GetOriginRequestPolicyConfig", {}).n("CloudFrontClient", "GetOriginRequestPolicyConfigCommand").f(void 0, void 0).ser(se_GetOriginRequestPolicyConfigCommand).de(de_GetOriginRequestPolicyConfigCommand).build() {
  static {
    __name(this, "GetOriginRequestPolicyConfigCommand");
  }
};

// src/commands/GetPublicKeyCommand.ts



var GetPublicKeyCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("Cloudfront2020_05_31", "GetPublicKey", {}).n("CloudFrontClient", "GetPublicKeyCommand").f(void 0, void 0).ser(se_GetPublicKeyCommand).de(de_GetPublicKeyCommand).build() {
  static {
    __name(this, "GetPublicKeyCommand");
  }
};

// src/commands/GetPublicKeyConfigCommand.ts



var GetPublicKeyConfigCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("Cloudfront2020_05_31", "GetPublicKeyConfig", {}).n("CloudFrontClient", "GetPublicKeyConfigCommand").f(void 0, void 0).ser(se_GetPublicKeyConfigCommand).de(de_GetPublicKeyConfigCommand).build() {
  static {
    __name(this, "GetPublicKeyConfigCommand");
  }
};

// src/commands/GetRealtimeLogConfigCommand.ts



var GetRealtimeLogConfigCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("Cloudfront2020_05_31", "GetRealtimeLogConfig", {}).n("CloudFrontClient", "GetRealtimeLogConfigCommand").f(void 0, void 0).ser(se_GetRealtimeLogConfigCommand).de(de_GetRealtimeLogConfigCommand).build() {
  static {
    __name(this, "GetRealtimeLogConfigCommand");
  }
};

// src/commands/GetResponseHeadersPolicyCommand.ts



var GetResponseHeadersPolicyCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("Cloudfront2020_05_31", "GetResponseHeadersPolicy", {}).n("CloudFrontClient", "GetResponseHeadersPolicyCommand").f(void 0, void 0).ser(se_GetResponseHeadersPolicyCommand).de(de_GetResponseHeadersPolicyCommand).build() {
  static {
    __name(this, "GetResponseHeadersPolicyCommand");
  }
};

// src/commands/GetResponseHeadersPolicyConfigCommand.ts



var GetResponseHeadersPolicyConfigCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("Cloudfront2020_05_31", "GetResponseHeadersPolicyConfig", {}).n("CloudFrontClient", "GetResponseHeadersPolicyConfigCommand").f(void 0, void 0).ser(se_GetResponseHeadersPolicyConfigCommand).de(de_GetResponseHeadersPolicyConfigCommand).build() {
  static {
    __name(this, "GetResponseHeadersPolicyConfigCommand");
  }
};

// src/commands/GetStreamingDistributionCommand.ts



var GetStreamingDistributionCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("Cloudfront2020_05_31", "GetStreamingDistribution", {}).n("CloudFrontClient", "GetStreamingDistributionCommand").f(void 0, void 0).ser(se_GetStreamingDistributionCommand).de(de_GetStreamingDistributionCommand).build() {
  static {
    __name(this, "GetStreamingDistributionCommand");
  }
};

// src/commands/GetStreamingDistributionConfigCommand.ts



var GetStreamingDistributionConfigCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("Cloudfront2020_05_31", "GetStreamingDistributionConfig", {}).n("CloudFrontClient", "GetStreamingDistributionConfigCommand").f(void 0, void 0).ser(se_GetStreamingDistributionConfigCommand).de(de_GetStreamingDistributionConfigCommand).build() {
  static {
    __name(this, "GetStreamingDistributionConfigCommand");
  }
};

// src/commands/GetVpcOriginCommand.ts



var GetVpcOriginCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("Cloudfront2020_05_31", "GetVpcOrigin", {}).n("CloudFrontClient", "GetVpcOriginCommand").f(void 0, void 0).ser(se_GetVpcOriginCommand).de(de_GetVpcOriginCommand).build() {
  static {
    __name(this, "GetVpcOriginCommand");
  }
};

// src/commands/ListAnycastIpListsCommand.ts



var ListAnycastIpListsCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("Cloudfront2020_05_31", "ListAnycastIpLists", {}).n("CloudFrontClient", "ListAnycastIpListsCommand").f(void 0, void 0).ser(se_ListAnycastIpListsCommand).de(de_ListAnycastIpListsCommand).build() {
  static {
    __name(this, "ListAnycastIpListsCommand");
  }
};

// src/commands/ListCachePoliciesCommand.ts



var ListCachePoliciesCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("Cloudfront2020_05_31", "ListCachePolicies", {}).n("CloudFrontClient", "ListCachePoliciesCommand").f(void 0, void 0).ser(se_ListCachePoliciesCommand).de(de_ListCachePoliciesCommand).build() {
  static {
    __name(this, "ListCachePoliciesCommand");
  }
};

// src/commands/ListCloudFrontOriginAccessIdentitiesCommand.ts



var ListCloudFrontOriginAccessIdentitiesCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("Cloudfront2020_05_31", "ListCloudFrontOriginAccessIdentities", {}).n("CloudFrontClient", "ListCloudFrontOriginAccessIdentitiesCommand").f(void 0, void 0).ser(se_ListCloudFrontOriginAccessIdentitiesCommand).de(de_ListCloudFrontOriginAccessIdentitiesCommand).build() {
  static {
    __name(this, "ListCloudFrontOriginAccessIdentitiesCommand");
  }
};

// src/commands/ListConflictingAliasesCommand.ts



var ListConflictingAliasesCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("Cloudfront2020_05_31", "ListConflictingAliases", {}).n("CloudFrontClient", "ListConflictingAliasesCommand").f(void 0, void 0).ser(se_ListConflictingAliasesCommand).de(de_ListConflictingAliasesCommand).build() {
  static {
    __name(this, "ListConflictingAliasesCommand");
  }
};

// src/commands/ListConnectionGroupsCommand.ts



var ListConnectionGroupsCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("Cloudfront2020_05_31", "ListConnectionGroups", {}).n("CloudFrontClient", "ListConnectionGroupsCommand").f(void 0, void 0).ser(se_ListConnectionGroupsCommand).de(de_ListConnectionGroupsCommand).build() {
  static {
    __name(this, "ListConnectionGroupsCommand");
  }
};

// src/commands/ListContinuousDeploymentPoliciesCommand.ts



var ListContinuousDeploymentPoliciesCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("Cloudfront2020_05_31", "ListContinuousDeploymentPolicies", {}).n("CloudFrontClient", "ListContinuousDeploymentPoliciesCommand").f(void 0, void 0).ser(se_ListContinuousDeploymentPoliciesCommand).de(de_ListContinuousDeploymentPoliciesCommand).build() {
  static {
    __name(this, "ListContinuousDeploymentPoliciesCommand");
  }
};

// src/commands/ListDistributionsByAnycastIpListIdCommand.ts



var ListDistributionsByAnycastIpListIdCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("Cloudfront2020_05_31", "ListDistributionsByAnycastIpListId", {}).n("CloudFrontClient", "ListDistributionsByAnycastIpListIdCommand").f(void 0, ListDistributionsByAnycastIpListIdResultFilterSensitiveLog).ser(se_ListDistributionsByAnycastIpListIdCommand).de(de_ListDistributionsByAnycastIpListIdCommand).build() {
  static {
    __name(this, "ListDistributionsByAnycastIpListIdCommand");
  }
};

// src/commands/ListDistributionsByCachePolicyIdCommand.ts



var ListDistributionsByCachePolicyIdCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("Cloudfront2020_05_31", "ListDistributionsByCachePolicyId", {}).n("CloudFrontClient", "ListDistributionsByCachePolicyIdCommand").f(void 0, void 0).ser(se_ListDistributionsByCachePolicyIdCommand).de(de_ListDistributionsByCachePolicyIdCommand).build() {
  static {
    __name(this, "ListDistributionsByCachePolicyIdCommand");
  }
};

// src/commands/ListDistributionsByConnectionModeCommand.ts



var ListDistributionsByConnectionModeCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("Cloudfront2020_05_31", "ListDistributionsByConnectionMode", {}).n("CloudFrontClient", "ListDistributionsByConnectionModeCommand").f(void 0, ListDistributionsByConnectionModeResultFilterSensitiveLog).ser(se_ListDistributionsByConnectionModeCommand).de(de_ListDistributionsByConnectionModeCommand).build() {
  static {
    __name(this, "ListDistributionsByConnectionModeCommand");
  }
};

// src/commands/ListDistributionsByKeyGroupCommand.ts



var ListDistributionsByKeyGroupCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("Cloudfront2020_05_31", "ListDistributionsByKeyGroup", {}).n("CloudFrontClient", "ListDistributionsByKeyGroupCommand").f(void 0, void 0).ser(se_ListDistributionsByKeyGroupCommand).de(de_ListDistributionsByKeyGroupCommand).build() {
  static {
    __name(this, "ListDistributionsByKeyGroupCommand");
  }
};

// src/commands/ListDistributionsByOriginRequestPolicyIdCommand.ts



var ListDistributionsByOriginRequestPolicyIdCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("Cloudfront2020_05_31", "ListDistributionsByOriginRequestPolicyId", {}).n("CloudFrontClient", "ListDistributionsByOriginRequestPolicyIdCommand").f(void 0, void 0).ser(se_ListDistributionsByOriginRequestPolicyIdCommand).de(de_ListDistributionsByOriginRequestPolicyIdCommand).build() {
  static {
    __name(this, "ListDistributionsByOriginRequestPolicyIdCommand");
  }
};

// src/commands/ListDistributionsByRealtimeLogConfigCommand.ts



var ListDistributionsByRealtimeLogConfigCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("Cloudfront2020_05_31", "ListDistributionsByRealtimeLogConfig", {}).n("CloudFrontClient", "ListDistributionsByRealtimeLogConfigCommand").f(void 0, ListDistributionsByRealtimeLogConfigResultFilterSensitiveLog).ser(se_ListDistributionsByRealtimeLogConfigCommand).de(de_ListDistributionsByRealtimeLogConfigCommand).build() {
  static {
    __name(this, "ListDistributionsByRealtimeLogConfigCommand");
  }
};

// src/commands/ListDistributionsByResponseHeadersPolicyIdCommand.ts



var ListDistributionsByResponseHeadersPolicyIdCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("Cloudfront2020_05_31", "ListDistributionsByResponseHeadersPolicyId", {}).n("CloudFrontClient", "ListDistributionsByResponseHeadersPolicyIdCommand").f(void 0, void 0).ser(se_ListDistributionsByResponseHeadersPolicyIdCommand).de(de_ListDistributionsByResponseHeadersPolicyIdCommand).build() {
  static {
    __name(this, "ListDistributionsByResponseHeadersPolicyIdCommand");
  }
};

// src/commands/ListDistributionsByVpcOriginIdCommand.ts



var ListDistributionsByVpcOriginIdCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("Cloudfront2020_05_31", "ListDistributionsByVpcOriginId", {}).n("CloudFrontClient", "ListDistributionsByVpcOriginIdCommand").f(void 0, void 0).ser(se_ListDistributionsByVpcOriginIdCommand).de(de_ListDistributionsByVpcOriginIdCommand).build() {
  static {
    __name(this, "ListDistributionsByVpcOriginIdCommand");
  }
};

// src/commands/ListDistributionsByWebACLIdCommand.ts



var ListDistributionsByWebACLIdCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("Cloudfront2020_05_31", "ListDistributionsByWebACLId", {}).n("CloudFrontClient", "ListDistributionsByWebACLIdCommand").f(void 0, ListDistributionsByWebACLIdResultFilterSensitiveLog).ser(se_ListDistributionsByWebACLIdCommand).de(de_ListDistributionsByWebACLIdCommand).build() {
  static {
    __name(this, "ListDistributionsByWebACLIdCommand");
  }
};

// src/commands/ListDistributionsCommand.ts



var ListDistributionsCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("Cloudfront2020_05_31", "ListDistributions", {}).n("CloudFrontClient", "ListDistributionsCommand").f(void 0, ListDistributionsResultFilterSensitiveLog).ser(se_ListDistributionsCommand).de(de_ListDistributionsCommand).build() {
  static {
    __name(this, "ListDistributionsCommand");
  }
};

// src/commands/ListDistributionTenantsByCustomizationCommand.ts



var ListDistributionTenantsByCustomizationCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("Cloudfront2020_05_31", "ListDistributionTenantsByCustomization", {}).n("CloudFrontClient", "ListDistributionTenantsByCustomizationCommand").f(void 0, void 0).ser(se_ListDistributionTenantsByCustomizationCommand).de(de_ListDistributionTenantsByCustomizationCommand).build() {
  static {
    __name(this, "ListDistributionTenantsByCustomizationCommand");
  }
};

// src/commands/ListDistributionTenantsCommand.ts



var ListDistributionTenantsCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("Cloudfront2020_05_31", "ListDistributionTenants", {}).n("CloudFrontClient", "ListDistributionTenantsCommand").f(void 0, void 0).ser(se_ListDistributionTenantsCommand).de(de_ListDistributionTenantsCommand).build() {
  static {
    __name(this, "ListDistributionTenantsCommand");
  }
};

// src/commands/ListDomainConflictsCommand.ts



var ListDomainConflictsCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("Cloudfront2020_05_31", "ListDomainConflicts", {}).n("CloudFrontClient", "ListDomainConflictsCommand").f(void 0, void 0).ser(se_ListDomainConflictsCommand).de(de_ListDomainConflictsCommand).build() {
  static {
    __name(this, "ListDomainConflictsCommand");
  }
};

// src/commands/ListFieldLevelEncryptionConfigsCommand.ts



var ListFieldLevelEncryptionConfigsCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("Cloudfront2020_05_31", "ListFieldLevelEncryptionConfigs", {}).n("CloudFrontClient", "ListFieldLevelEncryptionConfigsCommand").f(void 0, void 0).ser(se_ListFieldLevelEncryptionConfigsCommand).de(de_ListFieldLevelEncryptionConfigsCommand).build() {
  static {
    __name(this, "ListFieldLevelEncryptionConfigsCommand");
  }
};

// src/commands/ListFieldLevelEncryptionProfilesCommand.ts



var ListFieldLevelEncryptionProfilesCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("Cloudfront2020_05_31", "ListFieldLevelEncryptionProfiles", {}).n("CloudFrontClient", "ListFieldLevelEncryptionProfilesCommand").f(void 0, void 0).ser(se_ListFieldLevelEncryptionProfilesCommand).de(de_ListFieldLevelEncryptionProfilesCommand).build() {
  static {
    __name(this, "ListFieldLevelEncryptionProfilesCommand");
  }
};

// src/commands/ListFunctionsCommand.ts



var ListFunctionsCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("Cloudfront2020_05_31", "ListFunctions", {}).n("CloudFrontClient", "ListFunctionsCommand").f(void 0, void 0).ser(se_ListFunctionsCommand).de(de_ListFunctionsCommand).build() {
  static {
    __name(this, "ListFunctionsCommand");
  }
};

// src/commands/ListInvalidationsCommand.ts



var ListInvalidationsCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("Cloudfront2020_05_31", "ListInvalidations", {}).n("CloudFrontClient", "ListInvalidationsCommand").f(void 0, void 0).ser(se_ListInvalidationsCommand).de(de_ListInvalidationsCommand).build() {
  static {
    __name(this, "ListInvalidationsCommand");
  }
};

// src/commands/ListInvalidationsForDistributionTenantCommand.ts



var ListInvalidationsForDistributionTenantCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("Cloudfront2020_05_31", "ListInvalidationsForDistributionTenant", {}).n("CloudFrontClient", "ListInvalidationsForDistributionTenantCommand").f(void 0, void 0).ser(se_ListInvalidationsForDistributionTenantCommand).de(de_ListInvalidationsForDistributionTenantCommand).build() {
  static {
    __name(this, "ListInvalidationsForDistributionTenantCommand");
  }
};

// src/commands/ListKeyGroupsCommand.ts



var ListKeyGroupsCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("Cloudfront2020_05_31", "ListKeyGroups", {}).n("CloudFrontClient", "ListKeyGroupsCommand").f(void 0, void 0).ser(se_ListKeyGroupsCommand).de(de_ListKeyGroupsCommand).build() {
  static {
    __name(this, "ListKeyGroupsCommand");
  }
};

// src/commands/ListKeyValueStoresCommand.ts



var ListKeyValueStoresCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("Cloudfront2020_05_31", "ListKeyValueStores", {}).n("CloudFrontClient", "ListKeyValueStoresCommand").f(void 0, void 0).ser(se_ListKeyValueStoresCommand).de(de_ListKeyValueStoresCommand).build() {
  static {
    __name(this, "ListKeyValueStoresCommand");
  }
};

// src/commands/ListOriginAccessControlsCommand.ts



var ListOriginAccessControlsCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("Cloudfront2020_05_31", "ListOriginAccessControls", {}).n("CloudFrontClient", "ListOriginAccessControlsCommand").f(void 0, void 0).ser(se_ListOriginAccessControlsCommand).de(de_ListOriginAccessControlsCommand).build() {
  static {
    __name(this, "ListOriginAccessControlsCommand");
  }
};

// src/commands/ListOriginRequestPoliciesCommand.ts



var ListOriginRequestPoliciesCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("Cloudfront2020_05_31", "ListOriginRequestPolicies", {}).n("CloudFrontClient", "ListOriginRequestPoliciesCommand").f(void 0, void 0).ser(se_ListOriginRequestPoliciesCommand).de(de_ListOriginRequestPoliciesCommand).build() {
  static {
    __name(this, "ListOriginRequestPoliciesCommand");
  }
};

// src/commands/ListPublicKeysCommand.ts



var ListPublicKeysCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("Cloudfront2020_05_31", "ListPublicKeys", {}).n("CloudFrontClient", "ListPublicKeysCommand").f(void 0, void 0).ser(se_ListPublicKeysCommand).de(de_ListPublicKeysCommand).build() {
  static {
    __name(this, "ListPublicKeysCommand");
  }
};

// src/commands/ListRealtimeLogConfigsCommand.ts



var ListRealtimeLogConfigsCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("Cloudfront2020_05_31", "ListRealtimeLogConfigs", {}).n("CloudFrontClient", "ListRealtimeLogConfigsCommand").f(void 0, void 0).ser(se_ListRealtimeLogConfigsCommand).de(de_ListRealtimeLogConfigsCommand).build() {
  static {
    __name(this, "ListRealtimeLogConfigsCommand");
  }
};

// src/commands/ListResponseHeadersPoliciesCommand.ts



var ListResponseHeadersPoliciesCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("Cloudfront2020_05_31", "ListResponseHeadersPolicies", {}).n("CloudFrontClient", "ListResponseHeadersPoliciesCommand").f(void 0, void 0).ser(se_ListResponseHeadersPoliciesCommand).de(de_ListResponseHeadersPoliciesCommand).build() {
  static {
    __name(this, "ListResponseHeadersPoliciesCommand");
  }
};

// src/commands/ListStreamingDistributionsCommand.ts



var ListStreamingDistributionsCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("Cloudfront2020_05_31", "ListStreamingDistributions", {}).n("CloudFrontClient", "ListStreamingDistributionsCommand").f(void 0, void 0).ser(se_ListStreamingDistributionsCommand).de(de_ListStreamingDistributionsCommand).build() {
  static {
    __name(this, "ListStreamingDistributionsCommand");
  }
};

// src/commands/ListTagsForResourceCommand.ts



var ListTagsForResourceCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("Cloudfront2020_05_31", "ListTagsForResource", {}).n("CloudFrontClient", "ListTagsForResourceCommand").f(void 0, void 0).ser(se_ListTagsForResourceCommand).de(de_ListTagsForResourceCommand).build() {
  static {
    __name(this, "ListTagsForResourceCommand");
  }
};

// src/commands/ListVpcOriginsCommand.ts



var ListVpcOriginsCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("Cloudfront2020_05_31", "ListVpcOrigins", {}).n("CloudFrontClient", "ListVpcOriginsCommand").f(void 0, void 0).ser(se_ListVpcOriginsCommand).de(de_ListVpcOriginsCommand).build() {
  static {
    __name(this, "ListVpcOriginsCommand");
  }
};

// src/commands/PublishFunctionCommand.ts



var PublishFunctionCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("Cloudfront2020_05_31", "PublishFunction", {}).n("CloudFrontClient", "PublishFunctionCommand").f(void 0, void 0).ser(se_PublishFunctionCommand).de(de_PublishFunctionCommand).build() {
  static {
    __name(this, "PublishFunctionCommand");
  }
};

// src/commands/TagResourceCommand.ts



var TagResourceCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("Cloudfront2020_05_31", "TagResource", {}).n("CloudFrontClient", "TagResourceCommand").f(void 0, void 0).ser(se_TagResourceCommand).de(de_TagResourceCommand).build() {
  static {
    __name(this, "TagResourceCommand");
  }
};

// src/commands/TestFunctionCommand.ts



var TestFunctionCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("Cloudfront2020_05_31", "TestFunction", {}).n("CloudFrontClient", "TestFunctionCommand").f(TestFunctionRequestFilterSensitiveLog, TestFunctionResultFilterSensitiveLog).ser(se_TestFunctionCommand).de(de_TestFunctionCommand).build() {
  static {
    __name(this, "TestFunctionCommand");
  }
};

// src/commands/UntagResourceCommand.ts



var UntagResourceCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("Cloudfront2020_05_31", "UntagResource", {}).n("CloudFrontClient", "UntagResourceCommand").f(void 0, void 0).ser(se_UntagResourceCommand).de(de_UntagResourceCommand).build() {
  static {
    __name(this, "UntagResourceCommand");
  }
};

// src/commands/UpdateCachePolicyCommand.ts



var UpdateCachePolicyCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("Cloudfront2020_05_31", "UpdateCachePolicy", {}).n("CloudFrontClient", "UpdateCachePolicyCommand").f(void 0, void 0).ser(se_UpdateCachePolicyCommand).de(de_UpdateCachePolicyCommand).build() {
  static {
    __name(this, "UpdateCachePolicyCommand");
  }
};

// src/commands/UpdateCloudFrontOriginAccessIdentityCommand.ts



var UpdateCloudFrontOriginAccessIdentityCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("Cloudfront2020_05_31", "UpdateCloudFrontOriginAccessIdentity", {}).n("CloudFrontClient", "UpdateCloudFrontOriginAccessIdentityCommand").f(void 0, void 0).ser(se_UpdateCloudFrontOriginAccessIdentityCommand).de(de_UpdateCloudFrontOriginAccessIdentityCommand).build() {
  static {
    __name(this, "UpdateCloudFrontOriginAccessIdentityCommand");
  }
};

// src/commands/UpdateConnectionGroupCommand.ts



var UpdateConnectionGroupCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("Cloudfront2020_05_31", "UpdateConnectionGroup", {}).n("CloudFrontClient", "UpdateConnectionGroupCommand").f(void 0, void 0).ser(se_UpdateConnectionGroupCommand).de(de_UpdateConnectionGroupCommand).build() {
  static {
    __name(this, "UpdateConnectionGroupCommand");
  }
};

// src/commands/UpdateContinuousDeploymentPolicyCommand.ts



var UpdateContinuousDeploymentPolicyCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("Cloudfront2020_05_31", "UpdateContinuousDeploymentPolicy", {}).n("CloudFrontClient", "UpdateContinuousDeploymentPolicyCommand").f(void 0, void 0).ser(se_UpdateContinuousDeploymentPolicyCommand).de(de_UpdateContinuousDeploymentPolicyCommand).build() {
  static {
    __name(this, "UpdateContinuousDeploymentPolicyCommand");
  }
};

// src/commands/UpdateDistributionCommand.ts



var UpdateDistributionCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("Cloudfront2020_05_31", "UpdateDistribution", {}).n("CloudFrontClient", "UpdateDistributionCommand").f(UpdateDistributionRequestFilterSensitiveLog, UpdateDistributionResultFilterSensitiveLog).ser(se_UpdateDistributionCommand).de(de_UpdateDistributionCommand).build() {
  static {
    __name(this, "UpdateDistributionCommand");
  }
};

// src/commands/UpdateDistributionTenantCommand.ts



var UpdateDistributionTenantCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("Cloudfront2020_05_31", "UpdateDistributionTenant", {}).n("CloudFrontClient", "UpdateDistributionTenantCommand").f(void 0, void 0).ser(se_UpdateDistributionTenantCommand).de(de_UpdateDistributionTenantCommand).build() {
  static {
    __name(this, "UpdateDistributionTenantCommand");
  }
};

// src/commands/UpdateDistributionWithStagingConfigCommand.ts



var UpdateDistributionWithStagingConfigCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("Cloudfront2020_05_31", "UpdateDistributionWithStagingConfig", {}).n("CloudFrontClient", "UpdateDistributionWithStagingConfigCommand").f(void 0, UpdateDistributionWithStagingConfigResultFilterSensitiveLog).ser(se_UpdateDistributionWithStagingConfigCommand).de(de_UpdateDistributionWithStagingConfigCommand).build() {
  static {
    __name(this, "UpdateDistributionWithStagingConfigCommand");
  }
};

// src/commands/UpdateDomainAssociationCommand.ts



var UpdateDomainAssociationCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("Cloudfront2020_05_31", "UpdateDomainAssociation", {}).n("CloudFrontClient", "UpdateDomainAssociationCommand").f(void 0, void 0).ser(se_UpdateDomainAssociationCommand).de(de_UpdateDomainAssociationCommand).build() {
  static {
    __name(this, "UpdateDomainAssociationCommand");
  }
};

// src/commands/UpdateFieldLevelEncryptionConfigCommand.ts



var UpdateFieldLevelEncryptionConfigCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("Cloudfront2020_05_31", "UpdateFieldLevelEncryptionConfig", {}).n("CloudFrontClient", "UpdateFieldLevelEncryptionConfigCommand").f(void 0, void 0).ser(se_UpdateFieldLevelEncryptionConfigCommand).de(de_UpdateFieldLevelEncryptionConfigCommand).build() {
  static {
    __name(this, "UpdateFieldLevelEncryptionConfigCommand");
  }
};

// src/commands/UpdateFieldLevelEncryptionProfileCommand.ts



var UpdateFieldLevelEncryptionProfileCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("Cloudfront2020_05_31", "UpdateFieldLevelEncryptionProfile", {}).n("CloudFrontClient", "UpdateFieldLevelEncryptionProfileCommand").f(void 0, void 0).ser(se_UpdateFieldLevelEncryptionProfileCommand).de(de_UpdateFieldLevelEncryptionProfileCommand).build() {
  static {
    __name(this, "UpdateFieldLevelEncryptionProfileCommand");
  }
};

// src/commands/UpdateFunctionCommand.ts



var UpdateFunctionCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("Cloudfront2020_05_31", "UpdateFunction", {}).n("CloudFrontClient", "UpdateFunctionCommand").f(UpdateFunctionRequestFilterSensitiveLog, void 0).ser(se_UpdateFunctionCommand).de(de_UpdateFunctionCommand).build() {
  static {
    __name(this, "UpdateFunctionCommand");
  }
};

// src/commands/UpdateKeyGroupCommand.ts



var UpdateKeyGroupCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("Cloudfront2020_05_31", "UpdateKeyGroup", {}).n("CloudFrontClient", "UpdateKeyGroupCommand").f(void 0, void 0).ser(se_UpdateKeyGroupCommand).de(de_UpdateKeyGroupCommand).build() {
  static {
    __name(this, "UpdateKeyGroupCommand");
  }
};

// src/commands/UpdateKeyValueStoreCommand.ts



var UpdateKeyValueStoreCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("Cloudfront2020_05_31", "UpdateKeyValueStore", {}).n("CloudFrontClient", "UpdateKeyValueStoreCommand").f(void 0, void 0).ser(se_UpdateKeyValueStoreCommand).de(de_UpdateKeyValueStoreCommand).build() {
  static {
    __name(this, "UpdateKeyValueStoreCommand");
  }
};

// src/commands/UpdateOriginAccessControlCommand.ts



var UpdateOriginAccessControlCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("Cloudfront2020_05_31", "UpdateOriginAccessControl", {}).n("CloudFrontClient", "UpdateOriginAccessControlCommand").f(void 0, void 0).ser(se_UpdateOriginAccessControlCommand).de(de_UpdateOriginAccessControlCommand).build() {
  static {
    __name(this, "UpdateOriginAccessControlCommand");
  }
};

// src/commands/UpdateOriginRequestPolicyCommand.ts



var UpdateOriginRequestPolicyCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("Cloudfront2020_05_31", "UpdateOriginRequestPolicy", {}).n("CloudFrontClient", "UpdateOriginRequestPolicyCommand").f(void 0, void 0).ser(se_UpdateOriginRequestPolicyCommand).de(de_UpdateOriginRequestPolicyCommand).build() {
  static {
    __name(this, "UpdateOriginRequestPolicyCommand");
  }
};

// src/commands/UpdatePublicKeyCommand.ts



var UpdatePublicKeyCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("Cloudfront2020_05_31", "UpdatePublicKey", {}).n("CloudFrontClient", "UpdatePublicKeyCommand").f(void 0, void 0).ser(se_UpdatePublicKeyCommand).de(de_UpdatePublicKeyCommand).build() {
  static {
    __name(this, "UpdatePublicKeyCommand");
  }
};

// src/commands/UpdateRealtimeLogConfigCommand.ts



var UpdateRealtimeLogConfigCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("Cloudfront2020_05_31", "UpdateRealtimeLogConfig", {}).n("CloudFrontClient", "UpdateRealtimeLogConfigCommand").f(void 0, void 0).ser(se_UpdateRealtimeLogConfigCommand).de(de_UpdateRealtimeLogConfigCommand).build() {
  static {
    __name(this, "UpdateRealtimeLogConfigCommand");
  }
};

// src/commands/UpdateResponseHeadersPolicyCommand.ts



var UpdateResponseHeadersPolicyCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("Cloudfront2020_05_31", "UpdateResponseHeadersPolicy", {}).n("CloudFrontClient", "UpdateResponseHeadersPolicyCommand").f(void 0, void 0).ser(se_UpdateResponseHeadersPolicyCommand).de(de_UpdateResponseHeadersPolicyCommand).build() {
  static {
    __name(this, "UpdateResponseHeadersPolicyCommand");
  }
};

// src/commands/UpdateStreamingDistributionCommand.ts



var UpdateStreamingDistributionCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("Cloudfront2020_05_31", "UpdateStreamingDistribution", {}).n("CloudFrontClient", "UpdateStreamingDistributionCommand").f(void 0, void 0).ser(se_UpdateStreamingDistributionCommand).de(de_UpdateStreamingDistributionCommand).build() {
  static {
    __name(this, "UpdateStreamingDistributionCommand");
  }
};

// src/commands/UpdateVpcOriginCommand.ts



var UpdateVpcOriginCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("Cloudfront2020_05_31", "UpdateVpcOrigin", {}).n("CloudFrontClient", "UpdateVpcOriginCommand").f(void 0, void 0).ser(se_UpdateVpcOriginCommand).de(de_UpdateVpcOriginCommand).build() {
  static {
    __name(this, "UpdateVpcOriginCommand");
  }
};

// src/commands/VerifyDnsConfigurationCommand.ts



var VerifyDnsConfigurationCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("Cloudfront2020_05_31", "VerifyDnsConfiguration", {}).n("CloudFrontClient", "VerifyDnsConfigurationCommand").f(void 0, void 0).ser(se_VerifyDnsConfigurationCommand).de(de_VerifyDnsConfigurationCommand).build() {
  static {
    __name(this, "VerifyDnsConfigurationCommand");
  }
};

// src/CloudFront.ts
var commands = {
  AssociateAliasCommand,
  AssociateDistributionTenantWebACLCommand,
  AssociateDistributionWebACLCommand,
  CopyDistributionCommand,
  CreateAnycastIpListCommand,
  CreateCachePolicyCommand,
  CreateCloudFrontOriginAccessIdentityCommand,
  CreateConnectionGroupCommand,
  CreateContinuousDeploymentPolicyCommand,
  CreateDistributionCommand,
  CreateDistributionTenantCommand,
  CreateDistributionWithTagsCommand,
  CreateFieldLevelEncryptionConfigCommand,
  CreateFieldLevelEncryptionProfileCommand,
  CreateFunctionCommand,
  CreateInvalidationCommand,
  CreateInvalidationForDistributionTenantCommand,
  CreateKeyGroupCommand,
  CreateKeyValueStoreCommand,
  CreateMonitoringSubscriptionCommand,
  CreateOriginAccessControlCommand,
  CreateOriginRequestPolicyCommand,
  CreatePublicKeyCommand,
  CreateRealtimeLogConfigCommand,
  CreateResponseHeadersPolicyCommand,
  CreateStreamingDistributionCommand,
  CreateStreamingDistributionWithTagsCommand,
  CreateVpcOriginCommand,
  DeleteAnycastIpListCommand,
  DeleteCachePolicyCommand,
  DeleteCloudFrontOriginAccessIdentityCommand,
  DeleteConnectionGroupCommand,
  DeleteContinuousDeploymentPolicyCommand,
  DeleteDistributionCommand,
  DeleteDistributionTenantCommand,
  DeleteFieldLevelEncryptionConfigCommand,
  DeleteFieldLevelEncryptionProfileCommand,
  DeleteFunctionCommand,
  DeleteKeyGroupCommand,
  DeleteKeyValueStoreCommand,
  DeleteMonitoringSubscriptionCommand,
  DeleteOriginAccessControlCommand,
  DeleteOriginRequestPolicyCommand,
  DeletePublicKeyCommand,
  DeleteRealtimeLogConfigCommand,
  DeleteResponseHeadersPolicyCommand,
  DeleteStreamingDistributionCommand,
  DeleteVpcOriginCommand,
  DescribeFunctionCommand,
  DescribeKeyValueStoreCommand,
  DisassociateDistributionTenantWebACLCommand,
  DisassociateDistributionWebACLCommand,
  GetAnycastIpListCommand,
  GetCachePolicyCommand,
  GetCachePolicyConfigCommand,
  GetCloudFrontOriginAccessIdentityCommand,
  GetCloudFrontOriginAccessIdentityConfigCommand,
  GetConnectionGroupCommand,
  GetConnectionGroupByRoutingEndpointCommand,
  GetContinuousDeploymentPolicyCommand,
  GetContinuousDeploymentPolicyConfigCommand,
  GetDistributionCommand,
  GetDistributionConfigCommand,
  GetDistributionTenantCommand,
  GetDistributionTenantByDomainCommand,
  GetFieldLevelEncryptionCommand,
  GetFieldLevelEncryptionConfigCommand,
  GetFieldLevelEncryptionProfileCommand,
  GetFieldLevelEncryptionProfileConfigCommand,
  GetFunctionCommand,
  GetInvalidationCommand,
  GetInvalidationForDistributionTenantCommand,
  GetKeyGroupCommand,
  GetKeyGroupConfigCommand,
  GetManagedCertificateDetailsCommand,
  GetMonitoringSubscriptionCommand,
  GetOriginAccessControlCommand,
  GetOriginAccessControlConfigCommand,
  GetOriginRequestPolicyCommand,
  GetOriginRequestPolicyConfigCommand,
  GetPublicKeyCommand,
  GetPublicKeyConfigCommand,
  GetRealtimeLogConfigCommand,
  GetResponseHeadersPolicyCommand,
  GetResponseHeadersPolicyConfigCommand,
  GetStreamingDistributionCommand,
  GetStreamingDistributionConfigCommand,
  GetVpcOriginCommand,
  ListAnycastIpListsCommand,
  ListCachePoliciesCommand,
  ListCloudFrontOriginAccessIdentitiesCommand,
  ListConflictingAliasesCommand,
  ListConnectionGroupsCommand,
  ListContinuousDeploymentPoliciesCommand,
  ListDistributionsCommand,
  ListDistributionsByAnycastIpListIdCommand,
  ListDistributionsByCachePolicyIdCommand,
  ListDistributionsByConnectionModeCommand,
  ListDistributionsByKeyGroupCommand,
  ListDistributionsByOriginRequestPolicyIdCommand,
  ListDistributionsByRealtimeLogConfigCommand,
  ListDistributionsByResponseHeadersPolicyIdCommand,
  ListDistributionsByVpcOriginIdCommand,
  ListDistributionsByWebACLIdCommand,
  ListDistributionTenantsCommand,
  ListDistributionTenantsByCustomizationCommand,
  ListDomainConflictsCommand,
  ListFieldLevelEncryptionConfigsCommand,
  ListFieldLevelEncryptionProfilesCommand,
  ListFunctionsCommand,
  ListInvalidationsCommand,
  ListInvalidationsForDistributionTenantCommand,
  ListKeyGroupsCommand,
  ListKeyValueStoresCommand,
  ListOriginAccessControlsCommand,
  ListOriginRequestPoliciesCommand,
  ListPublicKeysCommand,
  ListRealtimeLogConfigsCommand,
  ListResponseHeadersPoliciesCommand,
  ListStreamingDistributionsCommand,
  ListTagsForResourceCommand,
  ListVpcOriginsCommand,
  PublishFunctionCommand,
  TagResourceCommand,
  TestFunctionCommand,
  UntagResourceCommand,
  UpdateCachePolicyCommand,
  UpdateCloudFrontOriginAccessIdentityCommand,
  UpdateConnectionGroupCommand,
  UpdateContinuousDeploymentPolicyCommand,
  UpdateDistributionCommand,
  UpdateDistributionTenantCommand,
  UpdateDistributionWithStagingConfigCommand,
  UpdateDomainAssociationCommand,
  UpdateFieldLevelEncryptionConfigCommand,
  UpdateFieldLevelEncryptionProfileCommand,
  UpdateFunctionCommand,
  UpdateKeyGroupCommand,
  UpdateKeyValueStoreCommand,
  UpdateOriginAccessControlCommand,
  UpdateOriginRequestPolicyCommand,
  UpdatePublicKeyCommand,
  UpdateRealtimeLogConfigCommand,
  UpdateResponseHeadersPolicyCommand,
  UpdateStreamingDistributionCommand,
  UpdateVpcOriginCommand,
  VerifyDnsConfigurationCommand
};
var CloudFront = class extends CloudFrontClient {
  static {
    __name(this, "CloudFront");
  }
};
(0, import_smithy_client.createAggregatedClient)(commands, CloudFront);

// src/pagination/ListCloudFrontOriginAccessIdentitiesPaginator.ts

var paginateListCloudFrontOriginAccessIdentities = (0, import_core.createPaginator)(
  CloudFrontClient,
  ListCloudFrontOriginAccessIdentitiesCommand,
  "Marker",
  "CloudFrontOriginAccessIdentityList.NextMarker",
  "MaxItems"
);

// src/pagination/ListConnectionGroupsPaginator.ts

var paginateListConnectionGroups = (0, import_core.createPaginator)(CloudFrontClient, ListConnectionGroupsCommand, "Marker", "NextMarker", "MaxItems");

// src/pagination/ListDistributionTenantsByCustomizationPaginator.ts

var paginateListDistributionTenantsByCustomization = (0, import_core.createPaginator)(CloudFrontClient, ListDistributionTenantsByCustomizationCommand, "Marker", "NextMarker", "MaxItems");

// src/pagination/ListDistributionTenantsPaginator.ts

var paginateListDistributionTenants = (0, import_core.createPaginator)(CloudFrontClient, ListDistributionTenantsCommand, "Marker", "NextMarker", "MaxItems");

// src/pagination/ListDistributionsByConnectionModePaginator.ts

var paginateListDistributionsByConnectionMode = (0, import_core.createPaginator)(CloudFrontClient, ListDistributionsByConnectionModeCommand, "Marker", "DistributionList.NextMarker", "MaxItems");

// src/pagination/ListDistributionsPaginator.ts

var paginateListDistributions = (0, import_core.createPaginator)(CloudFrontClient, ListDistributionsCommand, "Marker", "DistributionList.NextMarker", "MaxItems");

// src/pagination/ListDomainConflictsPaginator.ts

var paginateListDomainConflicts = (0, import_core.createPaginator)(CloudFrontClient, ListDomainConflictsCommand, "Marker", "NextMarker", "MaxItems");

// src/pagination/ListInvalidationsForDistributionTenantPaginator.ts

var paginateListInvalidationsForDistributionTenant = (0, import_core.createPaginator)(CloudFrontClient, ListInvalidationsForDistributionTenantCommand, "Marker", "InvalidationList.NextMarker", "MaxItems");

// src/pagination/ListInvalidationsPaginator.ts

var paginateListInvalidations = (0, import_core.createPaginator)(CloudFrontClient, ListInvalidationsCommand, "Marker", "InvalidationList.NextMarker", "MaxItems");

// src/pagination/ListKeyValueStoresPaginator.ts

var paginateListKeyValueStores = (0, import_core.createPaginator)(CloudFrontClient, ListKeyValueStoresCommand, "Marker", "KeyValueStoreList.NextMarker", "MaxItems");

// src/pagination/ListPublicKeysPaginator.ts

var paginateListPublicKeys = (0, import_core.createPaginator)(CloudFrontClient, ListPublicKeysCommand, "Marker", "PublicKeyList.NextMarker", "MaxItems");

// src/pagination/ListStreamingDistributionsPaginator.ts

var paginateListStreamingDistributions = (0, import_core.createPaginator)(CloudFrontClient, ListStreamingDistributionsCommand, "Marker", "StreamingDistributionList.NextMarker", "MaxItems");

// src/waiters/waitForDistributionDeployed.ts
var import_util_waiter = require("@smithy/util-waiter");
var checkState = /* @__PURE__ */ __name(async (client, input) => {
  let reason;
  try {
    const result = await client.send(new GetDistributionCommand(input));
    reason = result;
    try {
      const returnComparator = /* @__PURE__ */ __name(() => {
        return result.Distribution.Status;
      }, "returnComparator");
      if (returnComparator() === "Deployed") {
        return { state: import_util_waiter.WaiterState.SUCCESS, reason };
      }
    } catch (e) {
    }
  } catch (exception) {
    reason = exception;
  }
  return { state: import_util_waiter.WaiterState.RETRY, reason };
}, "checkState");
var waitForDistributionDeployed = /* @__PURE__ */ __name(async (params, input) => {
  const serviceDefaults = { minDelay: 60, maxDelay: 2100 };
  return (0, import_util_waiter.createWaiter)({ ...serviceDefaults, ...params }, input, checkState);
}, "waitForDistributionDeployed");
var waitUntilDistributionDeployed = /* @__PURE__ */ __name(async (params, input) => {
  const serviceDefaults = { minDelay: 60, maxDelay: 2100 };
  const result = await (0, import_util_waiter.createWaiter)({ ...serviceDefaults, ...params }, input, checkState);
  return (0, import_util_waiter.checkExceptions)(result);
}, "waitUntilDistributionDeployed");

// src/waiters/waitForInvalidationCompleted.ts

var checkState2 = /* @__PURE__ */ __name(async (client, input) => {
  let reason;
  try {
    const result = await client.send(new GetInvalidationCommand(input));
    reason = result;
    try {
      const returnComparator = /* @__PURE__ */ __name(() => {
        return result.Invalidation.Status;
      }, "returnComparator");
      if (returnComparator() === "Completed") {
        return { state: import_util_waiter.WaiterState.SUCCESS, reason };
      }
    } catch (e) {
    }
  } catch (exception) {
    reason = exception;
  }
  return { state: import_util_waiter.WaiterState.RETRY, reason };
}, "checkState");
var waitForInvalidationCompleted = /* @__PURE__ */ __name(async (params, input) => {
  const serviceDefaults = { minDelay: 20, maxDelay: 600 };
  return (0, import_util_waiter.createWaiter)({ ...serviceDefaults, ...params }, input, checkState2);
}, "waitForInvalidationCompleted");
var waitUntilInvalidationCompleted = /* @__PURE__ */ __name(async (params, input) => {
  const serviceDefaults = { minDelay: 20, maxDelay: 600 };
  const result = await (0, import_util_waiter.createWaiter)({ ...serviceDefaults, ...params }, input, checkState2);
  return (0, import_util_waiter.checkExceptions)(result);
}, "waitUntilInvalidationCompleted");

// src/waiters/waitForInvalidationForDistributionTenantCompleted.ts

var checkState3 = /* @__PURE__ */ __name(async (client, input) => {
  let reason;
  try {
    const result = await client.send(new GetInvalidationForDistributionTenantCommand(input));
    reason = result;
    try {
      const returnComparator = /* @__PURE__ */ __name(() => {
        return result.Invalidation.Status;
      }, "returnComparator");
      if (returnComparator() === "Completed") {
        return { state: import_util_waiter.WaiterState.SUCCESS, reason };
      }
    } catch (e) {
    }
  } catch (exception) {
    reason = exception;
  }
  return { state: import_util_waiter.WaiterState.RETRY, reason };
}, "checkState");
var waitForInvalidationForDistributionTenantCompleted = /* @__PURE__ */ __name(async (params, input) => {
  const serviceDefaults = { minDelay: 20, maxDelay: 600 };
  return (0, import_util_waiter.createWaiter)({ ...serviceDefaults, ...params }, input, checkState3);
}, "waitForInvalidationForDistributionTenantCompleted");
var waitUntilInvalidationForDistributionTenantCompleted = /* @__PURE__ */ __name(async (params, input) => {
  const serviceDefaults = { minDelay: 20, maxDelay: 600 };
  const result = await (0, import_util_waiter.createWaiter)({ ...serviceDefaults, ...params }, input, checkState3);
  return (0, import_util_waiter.checkExceptions)(result);
}, "waitUntilInvalidationForDistributionTenantCompleted");

// src/waiters/waitForStreamingDistributionDeployed.ts

var checkState4 = /* @__PURE__ */ __name(async (client, input) => {
  let reason;
  try {
    const result = await client.send(new GetStreamingDistributionCommand(input));
    reason = result;
    try {
      const returnComparator = /* @__PURE__ */ __name(() => {
        return result.StreamingDistribution.Status;
      }, "returnComparator");
      if (returnComparator() === "Deployed") {
        return { state: import_util_waiter.WaiterState.SUCCESS, reason };
      }
    } catch (e) {
    }
  } catch (exception) {
    reason = exception;
  }
  return { state: import_util_waiter.WaiterState.RETRY, reason };
}, "checkState");
var waitForStreamingDistributionDeployed = /* @__PURE__ */ __name(async (params, input) => {
  const serviceDefaults = { minDelay: 60, maxDelay: 1500 };
  return (0, import_util_waiter.createWaiter)({ ...serviceDefaults, ...params }, input, checkState4);
}, "waitForStreamingDistributionDeployed");
var waitUntilStreamingDistributionDeployed = /* @__PURE__ */ __name(async (params, input) => {
  const serviceDefaults = { minDelay: 60, maxDelay: 1500 };
  const result = await (0, import_util_waiter.createWaiter)({ ...serviceDefaults, ...params }, input, checkState4);
  return (0, import_util_waiter.checkExceptions)(result);
}, "waitUntilStreamingDistributionDeployed");
// Annotate the CommonJS export names for ESM import in node:

0 && (module.exports = {
  CloudFrontServiceException,
  __Client,
  CloudFrontClient,
  CloudFront,
  $Command,
  AssociateAliasCommand,
  AssociateDistributionTenantWebACLCommand,
  AssociateDistributionWebACLCommand,
  CopyDistributionCommand,
  CreateAnycastIpListCommand,
  CreateCachePolicyCommand,
  CreateCloudFrontOriginAccessIdentityCommand,
  CreateConnectionGroupCommand,
  CreateContinuousDeploymentPolicyCommand,
  CreateDistributionCommand,
  CreateDistributionTenantCommand,
  CreateDistributionWithTagsCommand,
  CreateFieldLevelEncryptionConfigCommand,
  CreateFieldLevelEncryptionProfileCommand,
  CreateFunctionCommand,
  CreateInvalidationCommand,
  CreateInvalidationForDistributionTenantCommand,
  CreateKeyGroupCommand,
  CreateKeyValueStoreCommand,
  CreateMonitoringSubscriptionCommand,
  CreateOriginAccessControlCommand,
  CreateOriginRequestPolicyCommand,
  CreatePublicKeyCommand,
  CreateRealtimeLogConfigCommand,
  CreateResponseHeadersPolicyCommand,
  CreateStreamingDistributionCommand,
  CreateStreamingDistributionWithTagsCommand,
  CreateVpcOriginCommand,
  DeleteAnycastIpListCommand,
  DeleteCachePolicyCommand,
  DeleteCloudFrontOriginAccessIdentityCommand,
  DeleteConnectionGroupCommand,
  DeleteContinuousDeploymentPolicyCommand,
  DeleteDistributionCommand,
  DeleteDistributionTenantCommand,
  DeleteFieldLevelEncryptionConfigCommand,
  DeleteFieldLevelEncryptionProfileCommand,
  DeleteFunctionCommand,
  DeleteKeyGroupCommand,
  DeleteKeyValueStoreCommand,
  DeleteMonitoringSubscriptionCommand,
  DeleteOriginAccessControlCommand,
  DeleteOriginRequestPolicyCommand,
  DeletePublicKeyCommand,
  DeleteRealtimeLogConfigCommand,
  DeleteResponseHeadersPolicyCommand,
  DeleteStreamingDistributionCommand,
  DeleteVpcOriginCommand,
  DescribeFunctionCommand,
  DescribeKeyValueStoreCommand,
  DisassociateDistributionTenantWebACLCommand,
  DisassociateDistributionWebACLCommand,
  GetAnycastIpListCommand,
  GetCachePolicyCommand,
  GetCachePolicyConfigCommand,
  GetCloudFrontOriginAccessIdentityCommand,
  GetCloudFrontOriginAccessIdentityConfigCommand,
  GetConnectionGroupByRoutingEndpointCommand,
  GetConnectionGroupCommand,
  GetContinuousDeploymentPolicyCommand,
  GetContinuousDeploymentPolicyConfigCommand,
  GetDistributionCommand,
  GetDistributionConfigCommand,
  GetDistributionTenantByDomainCommand,
  GetDistributionTenantCommand,
  GetFieldLevelEncryptionCommand,
  GetFieldLevelEncryptionConfigCommand,
  GetFieldLevelEncryptionProfileCommand,
  GetFieldLevelEncryptionProfileConfigCommand,
  GetFunctionCommand,
  GetInvalidationCommand,
  GetInvalidationForDistributionTenantCommand,
  GetKeyGroupCommand,
  GetKeyGroupConfigCommand,
  GetManagedCertificateDetailsCommand,
  GetMonitoringSubscriptionCommand,
  GetOriginAccessControlCommand,
  GetOriginAccessControlConfigCommand,
  GetOriginRequestPolicyCommand,
  GetOriginRequestPolicyConfigCommand,
  GetPublicKeyCommand,
  GetPublicKeyConfigCommand,
  GetRealtimeLogConfigCommand,
  GetResponseHeadersPolicyCommand,
  GetResponseHeadersPolicyConfigCommand,
  GetStreamingDistributionCommand,
  GetStreamingDistributionConfigCommand,
  GetVpcOriginCommand,
  ListAnycastIpListsCommand,
  ListCachePoliciesCommand,
  ListCloudFrontOriginAccessIdentitiesCommand,
  ListConflictingAliasesCommand,
  ListConnectionGroupsCommand,
  ListContinuousDeploymentPoliciesCommand,
  ListDistributionsByAnycastIpListIdCommand,
  ListDistributionTenantsCommand,
  ListDistributionsByCachePolicyIdCommand,
  ListDistributionTenantsByCustomizationCommand,
  ListDistributionsByConnectionModeCommand,
  ListDistributionsByKeyGroupCommand,
  ListDistributionsByOriginRequestPolicyIdCommand,
  ListDistributionsByRealtimeLogConfigCommand,
  ListDistributionsByResponseHeadersPolicyIdCommand,
  ListDistributionsByVpcOriginIdCommand,
  ListDistributionsCommand,
  ListDistributionsByWebACLIdCommand,
  ListDomainConflictsCommand,
  ListFieldLevelEncryptionConfigsCommand,
  ListFieldLevelEncryptionProfilesCommand,
  ListFunctionsCommand,
  ListInvalidationsCommand,
  ListInvalidationsForDistributionTenantCommand,
  ListKeyGroupsCommand,
  ListKeyValueStoresCommand,
  ListOriginAccessControlsCommand,
  ListOriginRequestPoliciesCommand,
  ListPublicKeysCommand,
  ListRealtimeLogConfigsCommand,
  ListResponseHeadersPoliciesCommand,
  ListStreamingDistributionsCommand,
  ListTagsForResourceCommand,
  ListVpcOriginsCommand,
  PublishFunctionCommand,
  TagResourceCommand,
  TestFunctionCommand,
  UntagResourceCommand,
  UpdateCachePolicyCommand,
  UpdateCloudFrontOriginAccessIdentityCommand,
  UpdateConnectionGroupCommand,
  UpdateContinuousDeploymentPolicyCommand,
  UpdateDistributionCommand,
  UpdateDistributionTenantCommand,
  UpdateDistributionWithStagingConfigCommand,
  UpdateDomainAssociationCommand,
  UpdateFieldLevelEncryptionConfigCommand,
  UpdateFieldLevelEncryptionProfileCommand,
  UpdateFunctionCommand,
  UpdateKeyGroupCommand,
  UpdateKeyValueStoreCommand,
  UpdateOriginAccessControlCommand,
  UpdateOriginRequestPolicyCommand,
  UpdatePublicKeyCommand,
  UpdateRealtimeLogConfigCommand,
  UpdateResponseHeadersPolicyCommand,
  UpdateStreamingDistributionCommand,
  UpdateVpcOriginCommand,
  VerifyDnsConfigurationCommand,
  paginateListCloudFrontOriginAccessIdentities,
  paginateListConnectionGroups,
  paginateListDistributionTenantsByCustomization,
  paginateListDistributionTenants,
  paginateListDistributionsByConnectionMode,
  paginateListDistributions,
  paginateListDomainConflicts,
  paginateListInvalidationsForDistributionTenant,
  paginateListInvalidations,
  paginateListKeyValueStores,
  paginateListPublicKeys,
  paginateListStreamingDistributions,
  waitForDistributionDeployed,
  waitUntilDistributionDeployed,
  waitForInvalidationCompleted,
  waitUntilInvalidationCompleted,
  waitForInvalidationForDistributionTenantCompleted,
  waitUntilInvalidationForDistributionTenantCompleted,
  waitForStreamingDistributionDeployed,
  waitUntilStreamingDistributionDeployed,
  ResponseHeadersPolicyAccessControlAllowMethodsValues,
  AccessDenied,
  ICPRecordalStatus,
  Method,
  IllegalUpdate,
  InvalidArgument,
  NoSuchDistribution,
  TooManyDistributionCNAMEs,
  EntityNotFound,
  InvalidIfMatchVersion,
  PreconditionFailed,
  BatchTooLarge,
  ItemSelection,
  EventType,
  ViewerProtocolPolicy,
  CachePolicyCookieBehavior,
  CachePolicyHeaderBehavior,
  CachePolicyQueryStringBehavior,
  CachePolicyAlreadyExists,
  CachePolicyInUse,
  CachePolicyType,
  CannotChangeImmutablePublicKeyFields,
  CannotDeleteEntityWhileInUse,
  CannotUpdateEntityWhileInUse,
  CertificateSource,
  CertificateTransparencyLoggingPreference,
  CNAMEAlreadyExists,
  ConnectionMode,
  HttpVersion,
  OriginGroupSelectionCriteria,
  OriginProtocolPolicy,
  SslProtocol,
  PriceClass,
  GeoRestrictionType,
  MinimumProtocolVersion,
  SSLSupportMethod,
  DistributionAlreadyExists,
  IllegalFieldLevelEncryptionConfigAssociationWithCacheBehavior,
  InconsistentQuantities,
  InvalidDefaultRootObject,
  InvalidErrorCode,
  InvalidForwardCookies,
  InvalidFunctionAssociation,
  InvalidGeoRestrictionParameter,
  InvalidHeadersForS3Origin,
  InvalidLambdaFunctionAssociation,
  InvalidLocationCode,
  InvalidMinimumProtocolVersion,
  InvalidOrigin,
  InvalidOriginAccessControl,
  InvalidOriginAccessIdentity,
  InvalidOriginKeepaliveTimeout,
  InvalidOriginReadTimeout,
  InvalidProtocolSettings,
  InvalidQueryStringParameters,
  InvalidRelativePath,
  InvalidRequiredProtocol,
  InvalidResponseCode,
  InvalidTTLOrder,
  InvalidViewerCertificate,
  InvalidWebACLId,
  MissingBody,
  NoSuchCachePolicy,
  NoSuchFieldLevelEncryptionConfig,
  NoSuchOrigin,
  NoSuchOriginRequestPolicy,
  NoSuchRealtimeLogConfig,
  NoSuchResponseHeadersPolicy,
  RealtimeLogConfigOwnerMismatch,
  TooManyCacheBehaviors,
  TooManyCertificates,
  TooManyCookieNamesInWhiteList,
  TooManyDistributions,
  TooManyDistributionsAssociatedToCachePolicy,
  TooManyDistributionsAssociatedToFieldLevelEncryptionConfig,
  TooManyDistributionsAssociatedToKeyGroup,
  TooManyDistributionsAssociatedToOriginAccessControl,
  TooManyDistributionsAssociatedToOriginRequestPolicy,
  TooManyDistributionsAssociatedToResponseHeadersPolicy,
  TooManyDistributionsWithFunctionAssociations,
  TooManyDistributionsWithLambdaAssociations,
  TooManyDistributionsWithSingleFunctionARN,
  TooManyFunctionAssociations,
  TooManyHeadersInForwardedValues,
  TooManyKeyGroupsAssociatedToDistribution,
  TooManyLambdaFunctionAssociations,
  TooManyOriginCustomHeaders,
  TooManyOriginGroupsPerDistribution,
  TooManyOrigins,
  TooManyQueryStringParameters,
  TooManyTrustedSigners,
  TrustedKeyGroupDoesNotExist,
  TrustedSignerDoesNotExist,
  EntityAlreadyExists,
  EntityLimitExceeded,
  InvalidTagging,
  UnsupportedOperation,
  TooManyCachePolicies,
  TooManyCookiesInCachePolicy,
  TooManyHeadersInCachePolicy,
  TooManyQueryStringsInCachePolicy,
  CloudFrontOriginAccessIdentityAlreadyExists,
  TooManyCloudFrontOriginAccessIdentities,
  ContinuousDeploymentPolicyAlreadyExists,
  ContinuousDeploymentPolicyType,
  StagingDistributionInUse,
  TooManyContinuousDeploymentPolicies,
  ContinuousDeploymentPolicyInUse,
  IllegalOriginAccessConfiguration,
  InvalidDomainNameForOriginAccessControl,
  NoSuchContinuousDeploymentPolicy,
  CustomizationActionType,
  ValidationTokenHost,
  DomainStatus,
  InvalidAssociation,
  Format,
  FieldLevelEncryptionConfigAlreadyExists,
  NoSuchFieldLevelEncryptionProfile,
  QueryArgProfileEmpty,
  TooManyFieldLevelEncryptionConfigs,
  TooManyFieldLevelEncryptionContentTypeProfiles,
  TooManyFieldLevelEncryptionQueryArgProfiles,
  FieldLevelEncryptionProfileAlreadyExists,
  FieldLevelEncryptionProfileSizeExceeded,
  NoSuchPublicKey,
  TooManyFieldLevelEncryptionEncryptionEntities,
  TooManyFieldLevelEncryptionFieldPatterns,
  TooManyFieldLevelEncryptionProfiles,
  FunctionRuntime,
  FunctionStage,
  FunctionAlreadyExists,
  FunctionSizeLimitExceeded,
  TooManyFunctions,
  TooManyInvalidationsInProgress,
  KeyGroupAlreadyExists,
  TooManyKeyGroups,
  TooManyPublicKeysInKeyGroup,
  ImportSourceType,
  EntitySizeLimitExceeded,
  RealtimeMetricsSubscriptionStatus,
  MonitoringSubscriptionAlreadyExists,
  OriginAccessControlOriginTypes,
  OriginAccessControlSigningBehaviors,
  OriginAccessControlSigningProtocols,
  OriginAccessControlAlreadyExists,
  OriginCustomHeaderFilterSensitiveLog,
  CustomHeadersFilterSensitiveLog,
  OriginFilterSensitiveLog,
  OriginsFilterSensitiveLog,
  DistributionConfigFilterSensitiveLog,
  DistributionFilterSensitiveLog,
  CopyDistributionResultFilterSensitiveLog,
  CreateDistributionRequestFilterSensitiveLog,
  CreateDistributionResultFilterSensitiveLog,
  DistributionConfigWithTagsFilterSensitiveLog,
  CreateDistributionWithTagsRequestFilterSensitiveLog,
  CreateDistributionWithTagsResultFilterSensitiveLog,
  CreateFunctionRequestFilterSensitiveLog,
  TooManyOriginAccessControls,
  OriginRequestPolicyCookieBehavior,
  OriginRequestPolicyHeaderBehavior,
  OriginRequestPolicyQueryStringBehavior,
  OriginRequestPolicyAlreadyExists,
  TooManyCookiesInOriginRequestPolicy,
  TooManyHeadersInOriginRequestPolicy,
  TooManyOriginRequestPolicies,
  TooManyQueryStringsInOriginRequestPolicy,
  PublicKeyAlreadyExists,
  TooManyPublicKeys,
  RealtimeLogConfigAlreadyExists,
  TooManyRealtimeLogConfigs,
  FrameOptionsList,
  ReferrerPolicyList,
  ResponseHeadersPolicyAlreadyExists,
  TooLongCSPInResponseHeadersPolicy,
  TooManyCustomHeadersInResponseHeadersPolicy,
  TooManyRemoveHeadersInResponseHeadersPolicy,
  TooManyResponseHeadersPolicies,
  StreamingDistributionAlreadyExists,
  TooManyStreamingDistributionCNAMEs,
  TooManyStreamingDistributions,
  IllegalDelete,
  CloudFrontOriginAccessIdentityInUse,
  NoSuchCloudFrontOriginAccessIdentity,
  ResourceNotDisabled,
  DistributionNotDisabled,
  ResourceInUse,
  FieldLevelEncryptionConfigInUse,
  FieldLevelEncryptionProfileInUse,
  FunctionInUse,
  NoSuchFunctionExists,
  NoSuchResource,
  NoSuchMonitoringSubscription,
  NoSuchOriginAccessControl,
  OriginAccessControlInUse,
  OriginRequestPolicyInUse,
  PublicKeyInUse,
  RealtimeLogConfigInUse,
  ResponseHeadersPolicyInUse,
  NoSuchStreamingDistribution,
  StreamingDistributionNotDisabled,
  NoSuchInvalidation,
  ManagedCertificateStatus,
  DistributionResourceType,
  OriginRequestPolicyType,
  ResponseHeadersPolicyType,
  GetDistributionResultFilterSensitiveLog,
  GetDistributionConfigResultFilterSensitiveLog,
  GetFunctionResultFilterSensitiveLog,
  DistributionSummaryFilterSensitiveLog,
  DistributionListFilterSensitiveLog,
  ListDistributionsResultFilterSensitiveLog,
  ListDistributionsByAnycastIpListIdResultFilterSensitiveLog,
  ListDistributionsByConnectionModeResultFilterSensitiveLog,
  ListDistributionsByRealtimeLogConfigResultFilterSensitiveLog,
  ListDistributionsByWebACLIdResultFilterSensitiveLog,
  TestFunctionFailed,
  DnsConfigurationStatus,
  TestFunctionRequestFilterSensitiveLog,
  TestResultFilterSensitiveLog,
  TestFunctionResultFilterSensitiveLog,
  UpdateDistributionRequestFilterSensitiveLog,
  UpdateDistributionResultFilterSensitiveLog,
  UpdateDistributionWithStagingConfigResultFilterSensitiveLog,
  UpdateFunctionRequestFilterSensitiveLog
});

