/**
 * ./src/components/title.tsx
 * penguins-eggs v.10.0.0 / ecmascript 2020
 * author: Piero Proietti
 * email: piero.proietti@gmail.com
 * license: MIT
 */
import React from 'react';
import { Text, Box, Newline } from 'ink';
// pjson
import { createRequire } from 'module';
const require = createRequire(import.meta.url);
const pjson = require('../../../package.json');
export default function Title({ title = "", version = "" }) {
    if (title == "")
        title = pjson.name;
    if (version == "")
        version = pjson.version;
    return (React.createElement(React.Fragment, null,
        React.createElement(Box, { flexDirection: "column" },
            React.createElement(Box, null),
            React.createElement(Box, null,
                React.createElement(Text, null, "E G G S: reproductive system of penguins")),
            React.createElement(Newline, null)),
        React.createElement(Box, { flexDirection: "row" },
            React.createElement(Text, { backgroundColor: "green" },
                "     ",
                title,
                "      "),
            React.createElement(Text, { backgroundColor: "white", color: "blue" }, " Perri's brewery edition "),
            React.createElement(Text, { backgroundColor: "red" },
                "       ver. ",
                version,
                "       "))));
}
