/**
 * ./src/classes/utils.d/architecture.ts
 * penguins-eggs v.10.0.0 / ecmascript 2020
 * Architecture detection utilities - UEFI, arch-specific paths
 * author: Piero Proietti
 * email: piero.proietti@gmail.com
 * license: MIT
 */
export default class Architecture {
    /**
     * Return true if i686 architecture
     * @remarks to move in Utils
     * @returns {boolean} true se l'architettura è i686
     */
    static isi686(): boolean;
    /**
     * uefiArch
     * @returns arch
     */
    static uefiArch(): string;
    /**
     * i386-pc,
     * i386-efi,
     * x86_64-efi,
     * arm64-efi,
     *
     * ATTEMZIONE: install efibootmgr
     *
     * Fedora/RHEL have i386-pc
     */
    static uefiFormat(): string;
    /**
     *
     * @returns
     */
    static usrLibPath(): string;
    /**
     * get the kernel version
     */
    static kernelVersion(): string;
}
