/**
 * ./src/classes/families/debian.ts
 * penguins-eggs v.10.0.0 / ecmascript 2020
 * author: Piero Proietti
 * email: piero.proietti@gmail.com
 * license: MIT
 */
/**
 * Debian
 * @remarks all the utilities
 */
export default class Debian {
    static debs4calamares: string[];
    /**
     * Debian: calamaresInstall
     */
    static calamaresInstall(verbose?: boolean): Promise<void>;
    /**
     * Debian: calamaresPolicies
     */
    static calamaresPolicies(verbose?: boolean): Promise<void>;
    /**
     * Debian: calamaresRemove
     */
    static calamaresRemove(verbose?: boolean): Promise<boolean>;
    /**
     * Debian: isInstalledWayland
     * @returns true if wayland is installed
     */
    static isInstalledWayland(): boolean;
    /**
     * Debian: isInstalledXorg
     * @returns true if xorg is installed
     */
    static isInstalledXorg(): boolean;
    /**
     * Debian: liveInstallerPolicies
     * liveInstallerPolicies is NOT USED
     */
    static liveInstallerPolicies(): Promise<void>;
    /**
     * Debian: packageAptAvailable
     * return TRUE if package is present on repository
     * @param debPackage
     */
    static packageAptAvailable(packageName: string): Promise<boolean>;
    /**
     * Debian: packageAptLast
     * @param debPackage
     * @returns version
     */
    static packageAptLast(debPackage: string): Promise<string>;
    /**
     * Debian: packageInstall
     * @param packageName {string} Pacchetto Debian da installare
     * @returns {boolean} True if success
     */
    static packageInstall(packageName: string): Promise<boolean>;
    /**
     * Debian: packageIsInstalled
     * restuisce VERO se il pacchetto è installato
     * @param debPackage
     */
    static packageIsInstalled(debPackage: string): boolean;
}
