/**
 * ./src/classes/ovary.d/merge.ts
 * penguins-eggs v.10.0.0 / ecmascript 2020
 * author: Piero Proietti
 * email: piero.proietti@gmail.com
 * license: MIT
 */
// packages
import path from 'node:path';
// _dirname
const __dirname = path.dirname(new URL(import.meta.url).pathname);
/**
 * Ritorna true se c'è bisogno del mount --bind
 *
 * Ci sono quattro tipologie:
 *
 * - copied
 * - mergedAndOverlay
 * - merged
 * - just create
 */
export function copied(dir) {
    let copied = false;
    let copiedDirs = [
        'boot',
        'etc',
    ];
    for (const copiedDir of copiedDirs) {
        if (dir === copiedDir) {
            copied = true;
        }
    }
    return copied;
}
/**
 *
 */
export function mergedAndOverlay(dir) {
    // per Alpine ho agginto bin
    const moDirs = ['bin', 'usr', 'var'];
    let mergedOverlay = false;
    for (const moDir of moDirs) {
        if (moDir === dir) {
            mergedOverlay = true;
        }
    }
    return mergedOverlay;
}
/**
 * merged
 */
export function merged(dir) {
    let merged = true;
    if (dir === 'home') {
        merged = this.clone;
    }
    else {
        const justMks = [
            'cdrom',
            'dev',
            'media',
            'mnt',
            'proc',
            'run',
            'swapfile',
            'sys',
            'tmp'
        ];
        // deepiin
        justMks.push('data', 'recovery');
        for (const justMk of justMks) {
            if (dir === justMk) {
                merged = false;
            }
        }
    }
    return merged;
}
