/**
 * ./src/classes/incubation/distros/jessie.ts
 * penguins-eggs v.10.0.0 / ecmascript 2020
 * author: Piero Proietti
 * email: piero.proietti@gmail.com
 * license: MIT
 */
import Fisherman from '../fisherman.js';
/**
 *
 */
export class Jessie {
    distro;
    installer = {};
    release = false;
    remix;
    user_opt;
    verbose = false;
    /**
     * @param remix
     * @param distro
     * @param displaymanager
     * @param verbose
     */
    constructor(installer, remix, distro, user_opt, release = false, verbose = false) {
        this.installer = installer;
        this.remix = remix;
        this.distro = distro;
        this.user_opt = user_opt;
        this.verbose = verbose;
        this.release = release; // nel senso di --final
    }
    /**
     * partitions can come from themes
     */
    async create() {
        const fisherman = new Fisherman(this.distro, this.installer, this.verbose);
        await fisherman.createCalamaresSettings(this.remix.branding);
        await fisherman.buildModule('partition', this.remix.branding);
        await fisherman.buildCalamaresModule('sources-yolk', true);
        await fisherman.moduleRemoveuser(this.user_opt);
        await fisherman.buildCalamaresModule('sources-yolk-undo', false);
    }
}
