/* local_config.c generated by valac 0.56.17, the Vala compiler
 * generated from local_config.vala, do not modify */

/*
 *  pamac-vala
 *
 *  Copyright (C) 2019-2023 Guillaume Benoit <guillaume@manjaro.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a get of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "pamac-gtk.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	PAMAC_LOCAL_CONFIG_0_PROPERTY,
	PAMAC_LOCAL_CONFIG_CONF_PATH_PROPERTY,
	PAMAC_LOCAL_CONFIG_WIDTH_PROPERTY,
	PAMAC_LOCAL_CONFIG_HEIGHT_PROPERTY,
	PAMAC_LOCAL_CONFIG_MAXIMIZED_PROPERTY,
	PAMAC_LOCAL_CONFIG_SOFTWARE_MODE_PROPERTY,
	PAMAC_LOCAL_CONFIG_NUM_PROPERTIES
};
static GParamSpec* pamac_local_config_properties[PAMAC_LOCAL_CONFIG_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

struct _PamacLocalConfigPrivate {
	gchar* _conf_path;
	guint64 _width;
	guint64 _height;
	gboolean _maximized;
	gboolean _software_mode;
};

static gint PamacLocalConfig_private_offset;
static gpointer pamac_local_config_parent_class = NULL;

static void pamac_local_config_set_width (PamacLocalConfig* self,
                                   guint64 value);
static void pamac_local_config_set_height (PamacLocalConfig* self,
                                    guint64 value);
static void pamac_local_config_set_maximized (PamacLocalConfig* self,
                                       gboolean value);
static void pamac_local_config_parse_file (PamacLocalConfig* self);
static GObject * pamac_local_config_constructor (GType type,
                                          guint n_construct_properties,
                                          GObjectConstructParam * construct_properties);
static void pamac_local_config_finalize (GObject * obj);
static GType pamac_local_config_get_type_once (void);
static void _vala_pamac_local_config_get_property (GObject * object,
                                            guint property_id,
                                            GValue * value,
                                            GParamSpec * pspec);
static void _vala_pamac_local_config_set_property (GObject * object,
                                            guint property_id,
                                            const GValue * value,
                                            GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
pamac_local_config_get_instance_private (PamacLocalConfig* self)
{
	return G_STRUCT_MEMBER_P (self, PamacLocalConfig_private_offset);
}

PamacLocalConfig*
pamac_local_config_construct (GType object_type,
                              const gchar* conf_path)
{
	PamacLocalConfig * self = NULL;
	g_return_val_if_fail (conf_path != NULL, NULL);
	self = (PamacLocalConfig*) g_object_new (object_type, "conf-path", conf_path, NULL);
	return self;
}

PamacLocalConfig*
pamac_local_config_new (const gchar* conf_path)
{
	return pamac_local_config_construct (PAMAC_TYPE_LOCAL_CONFIG, conf_path);
}

void
pamac_local_config_reload (PamacLocalConfig* self)
{
	g_return_if_fail (self != NULL);
	pamac_local_config_set_width (self, (guint64) 950);
	pamac_local_config_set_height (self, (guint64) 550);
	pamac_local_config_set_maximized (self, FALSE);
	pamac_local_config_set_software_mode (self, FALSE);
	pamac_local_config_parse_file (self);
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

static guint64
uint64_parse (const gchar* str,
              guint _base)
{
	guint64 result;
	g_return_val_if_fail (str != NULL, 0ULL);
	result = g_ascii_strtoull (str, NULL, _base);
	return result;
}

static gboolean
bool_parse (const gchar* str)
{
	gboolean result;
	g_return_val_if_fail (str != NULL, FALSE);
	if (g_strcmp0 (str, "true") == 0) {
		result = TRUE;
		return result;
	} else {
		result = FALSE;
		return result;
	}
}

static void
pamac_local_config_parse_file (PamacLocalConfig* self)
{
	GFile* file = NULL;
	const gchar* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_conf_path;
	_tmp1_ = g_file_new_for_path (_tmp0_);
	file = _tmp1_;
	_tmp2_ = file;
	if (g_file_query_exists (_tmp2_, NULL)) {
		{
			GFileInputStream* _tmp3_ = NULL;
			GFile* _tmp4_;
			GFileInputStream* _tmp5_;
			GDataInputStream* dis = NULL;
			GDataInputStream* _tmp6_;
			gchar* line = NULL;
			_tmp4_ = file;
			_tmp5_ = g_file_read (_tmp4_, NULL, &_inner_error0_);
			_tmp3_ = _tmp5_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp6_ = g_data_input_stream_new ((GInputStream*) _tmp3_);
			dis = _tmp6_;
			while (TRUE) {
				gchar* _tmp7_ = NULL;
				GDataInputStream* _tmp8_;
				gchar* _tmp9_;
				gchar* _tmp10_;
				const gchar* _tmp11_;
				const gchar* _tmp12_;
				gint _tmp13_;
				gint _tmp14_;
				gchar** splitted = NULL;
				const gchar* _tmp15_;
				gchar** _tmp16_;
				gchar** _tmp17_;
				gint splitted_length1;
				gint _splitted_size_;
				gchar** _tmp18_;
				gint _tmp18__length1;
				const gchar* _tmp19_;
				gchar* _tmp20_;
				const gchar* _tmp21_;
				gint _tmp22_;
				gint _tmp23_;
				const gchar* _tmp24_;
				gchar** _tmp25_;
				gchar** _tmp26_;
				const gchar* key = NULL;
				gchar** _tmp27_;
				gint _tmp27__length1;
				const gchar* _tmp28_;
				const gchar* _tmp29_;
				const gchar* _tmp30_;
				_tmp8_ = dis;
				_tmp9_ = g_data_input_stream_read_line (_tmp8_, NULL, NULL, &_inner_error0_);
				_tmp7_ = _tmp9_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_free0 (line);
					_g_object_unref0 (dis);
					_g_object_unref0 (_tmp3_);
					goto __catch0_g_error;
				}
				_tmp10_ = _tmp7_;
				_tmp7_ = NULL;
				_g_free0 (line);
				line = _tmp10_;
				_tmp11_ = line;
				if (!(_tmp11_ != NULL)) {
					_g_free0 (_tmp7_);
					break;
				}
				_tmp12_ = line;
				_tmp13_ = strlen (_tmp12_);
				_tmp14_ = _tmp13_;
				if (_tmp14_ == 0) {
					_g_free0 (_tmp7_);
					continue;
				}
				_tmp15_ = line;
				_tmp17_ = _tmp16_ = g_strsplit (_tmp15_, "#", 2);
				splitted = _tmp17_;
				splitted_length1 = _vala_array_length (_tmp16_);
				_splitted_size_ = splitted_length1;
				_tmp18_ = splitted;
				_tmp18__length1 = splitted_length1;
				_tmp19_ = _tmp18_[0];
				_tmp20_ = string_strip (_tmp19_);
				_g_free0 (line);
				line = _tmp20_;
				_tmp21_ = line;
				_tmp22_ = strlen (_tmp21_);
				_tmp23_ = _tmp22_;
				if (_tmp23_ == 0) {
					splitted = (_vala_array_free (splitted, splitted_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (_tmp7_);
					continue;
				}
				_tmp24_ = line;
				_tmp26_ = _tmp25_ = g_strsplit (_tmp24_, "=", 2);
				splitted = (_vala_array_free (splitted, splitted_length1, (GDestroyNotify) g_free), NULL);
				splitted = _tmp26_;
				splitted_length1 = _vala_array_length (_tmp25_);
				_splitted_size_ = splitted_length1;
				_tmp27_ = splitted;
				_tmp27__length1 = splitted_length1;
				_tmp28_ = _tmp27_[0];
				_tmp29_ = g_strstrip (_tmp28_);
				key = _tmp29_;
				_tmp30_ = key;
				if (g_strcmp0 (_tmp30_, "width") == 0) {
					gchar** _tmp31_;
					gint _tmp31__length1;
					_tmp31_ = splitted;
					_tmp31__length1 = splitted_length1;
					if (_tmp31__length1 == 2) {
						const gchar* val = NULL;
						gchar** _tmp32_;
						gint _tmp32__length1;
						const gchar* _tmp33_;
						const gchar* _tmp34_;
						const gchar* _tmp35_;
						_tmp32_ = splitted;
						_tmp32__length1 = splitted_length1;
						_tmp33_ = _tmp32_[1];
						_tmp34_ = g_strstrip (_tmp33_);
						val = _tmp34_;
						_tmp35_ = val;
						pamac_local_config_set_width (self, uint64_parse (_tmp35_, (guint) 0));
					}
				} else {
					const gchar* _tmp36_;
					_tmp36_ = key;
					if (g_strcmp0 (_tmp36_, "height") == 0) {
						gchar** _tmp37_;
						gint _tmp37__length1;
						_tmp37_ = splitted;
						_tmp37__length1 = splitted_length1;
						if (_tmp37__length1 == 2) {
							const gchar* val = NULL;
							gchar** _tmp38_;
							gint _tmp38__length1;
							const gchar* _tmp39_;
							const gchar* _tmp40_;
							const gchar* _tmp41_;
							_tmp38_ = splitted;
							_tmp38__length1 = splitted_length1;
							_tmp39_ = _tmp38_[1];
							_tmp40_ = g_strstrip (_tmp39_);
							val = _tmp40_;
							_tmp41_ = val;
							pamac_local_config_set_height (self, uint64_parse (_tmp41_, (guint) 0));
						}
					} else {
						const gchar* _tmp42_;
						_tmp42_ = key;
						if (g_strcmp0 (_tmp42_, "maximized") == 0) {
							gchar** _tmp43_;
							gint _tmp43__length1;
							_tmp43_ = splitted;
							_tmp43__length1 = splitted_length1;
							if (_tmp43__length1 == 2) {
								const gchar* val = NULL;
								gchar** _tmp44_;
								gint _tmp44__length1;
								const gchar* _tmp45_;
								const gchar* _tmp46_;
								const gchar* _tmp47_;
								_tmp44_ = splitted;
								_tmp44__length1 = splitted_length1;
								_tmp45_ = _tmp44_[1];
								_tmp46_ = g_strstrip (_tmp45_);
								val = _tmp46_;
								_tmp47_ = val;
								pamac_local_config_set_maximized (self, bool_parse (_tmp47_));
							}
						} else {
							const gchar* _tmp48_;
							_tmp48_ = key;
							if (g_strcmp0 (_tmp48_, "software_mode") == 0) {
								gchar** _tmp49_;
								gint _tmp49__length1;
								_tmp49_ = splitted;
								_tmp49__length1 = splitted_length1;
								if (_tmp49__length1 == 2) {
									const gchar* val = NULL;
									gchar** _tmp50_;
									gint _tmp50__length1;
									const gchar* _tmp51_;
									const gchar* _tmp52_;
									const gchar* _tmp53_;
									_tmp50_ = splitted;
									_tmp50__length1 = splitted_length1;
									_tmp51_ = _tmp50_[1];
									_tmp52_ = g_strstrip (_tmp51_);
									val = _tmp52_;
									_tmp53_ = val;
									pamac_local_config_set_software_mode (self, bool_parse (_tmp53_));
								}
							}
						}
					}
				}
				splitted = (_vala_array_free (splitted, splitted_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (_tmp7_);
			}
			_g_free0 (line);
			_g_object_unref0 (dis);
			_g_object_unref0 (_tmp3_);
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp54_;
			const gchar* _tmp55_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp54_ = e;
			_tmp55_ = _tmp54_->message;
			g_warning ("local_config.vala:89: %s", _tmp55_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (file);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_g_object_unref0 (file);
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

void
pamac_local_config_write (PamacLocalConfig* self,
                          GHashTable* new_conf)
{
	GFile* file = NULL;
	const gchar* _tmp0_;
	GFile* _tmp1_;
	GString* data = NULL;
	GString* _tmp2_;
	GFile* _tmp3_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (new_conf != NULL);
	_tmp0_ = self->priv->_conf_path;
	_tmp1_ = g_file_new_for_path (_tmp0_);
	file = _tmp1_;
	_tmp2_ = g_string_new ("");
	data = _tmp2_;
	_tmp3_ = file;
	if (g_file_query_exists (_tmp3_, NULL)) {
		{
			GFileInputStream* _tmp4_ = NULL;
			GFile* _tmp5_;
			GFileInputStream* _tmp6_;
			GDataInputStream* dis = NULL;
			GDataInputStream* _tmp7_;
			gchar* line = NULL;
			GFile* _tmp58_;
			_tmp5_ = file;
			_tmp6_ = g_file_read (_tmp5_, NULL, &_inner_error0_);
			_tmp4_ = _tmp6_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp7_ = g_data_input_stream_new ((GInputStream*) _tmp4_);
			dis = _tmp7_;
			while (TRUE) {
				gchar* _tmp8_ = NULL;
				GDataInputStream* _tmp9_;
				gchar* _tmp10_;
				gchar* _tmp11_;
				const gchar* _tmp12_;
				const gchar* _tmp13_;
				gint _tmp14_;
				gint _tmp15_;
				GVariant* variant = NULL;
				const gchar* _tmp17_;
				_tmp9_ = dis;
				_tmp10_ = g_data_input_stream_read_line (_tmp9_, NULL, NULL, &_inner_error0_);
				_tmp8_ = _tmp10_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_free0 (line);
					_g_object_unref0 (dis);
					_g_object_unref0 (_tmp4_);
					goto __catch0_g_error;
				}
				_tmp11_ = _tmp8_;
				_tmp8_ = NULL;
				_g_free0 (line);
				line = _tmp11_;
				_tmp12_ = line;
				if (!(_tmp12_ != NULL)) {
					_g_free0 (_tmp8_);
					break;
				}
				_tmp13_ = line;
				_tmp14_ = strlen (_tmp13_);
				_tmp15_ = _tmp14_;
				if (_tmp15_ == 0) {
					GString* _tmp16_;
					_tmp16_ = data;
					g_string_append (_tmp16_, "\n");
					_g_free0 (_tmp8_);
					continue;
				}
				_tmp17_ = line;
				if (string_contains (_tmp17_, "width")) {
					gconstpointer _tmp18_ = NULL;
					gboolean _tmp19_;
					_tmp19_ = g_hash_table_lookup_extended (new_conf, "width", NULL, &_tmp18_);
					variant = (GVariant*) _tmp18_;
					if (_tmp19_) {
						GString* _tmp20_;
						GVariant* _tmp21_;
						gchar* _tmp22_;
						gchar* _tmp23_;
						_tmp20_ = data;
						_tmp21_ = variant;
						_tmp22_ = g_strdup_printf ("width = %llu\n", g_variant_get_uint64 (_tmp21_));
						_tmp23_ = _tmp22_;
						g_string_append (_tmp20_, _tmp23_);
						_g_free0 (_tmp23_);
						g_hash_table_remove (new_conf, "width");
					} else {
						GString* _tmp24_;
						const gchar* _tmp25_;
						GString* _tmp26_;
						_tmp24_ = data;
						_tmp25_ = line;
						g_string_append (_tmp24_, _tmp25_);
						_tmp26_ = data;
						g_string_append (_tmp26_, "\n");
					}
				} else {
					const gchar* _tmp27_;
					_tmp27_ = line;
					if (string_contains (_tmp27_, "height")) {
						gconstpointer _tmp28_ = NULL;
						gboolean _tmp29_;
						_tmp29_ = g_hash_table_lookup_extended (new_conf, "height", NULL, &_tmp28_);
						variant = (GVariant*) _tmp28_;
						if (_tmp29_) {
							GString* _tmp30_;
							GVariant* _tmp31_;
							gchar* _tmp32_;
							gchar* _tmp33_;
							_tmp30_ = data;
							_tmp31_ = variant;
							_tmp32_ = g_strdup_printf ("height = %llu\n", g_variant_get_uint64 (_tmp31_));
							_tmp33_ = _tmp32_;
							g_string_append (_tmp30_, _tmp33_);
							_g_free0 (_tmp33_);
							g_hash_table_remove (new_conf, "height");
						} else {
							GString* _tmp34_;
							const gchar* _tmp35_;
							GString* _tmp36_;
							_tmp34_ = data;
							_tmp35_ = line;
							g_string_append (_tmp34_, _tmp35_);
							_tmp36_ = data;
							g_string_append (_tmp36_, "\n");
						}
					} else {
						const gchar* _tmp37_;
						_tmp37_ = line;
						if (string_contains (_tmp37_, "maximized")) {
							gconstpointer _tmp38_ = NULL;
							gboolean _tmp39_;
							_tmp39_ = g_hash_table_lookup_extended (new_conf, "maximized", NULL, &_tmp38_);
							variant = (GVariant*) _tmp38_;
							if (_tmp39_) {
								GVariant* _tmp40_;
								_tmp40_ = variant;
								if (g_variant_get_boolean (_tmp40_)) {
									GString* _tmp41_;
									_tmp41_ = data;
									g_string_append (_tmp41_, "maximized = true\n");
								} else {
									GString* _tmp42_;
									_tmp42_ = data;
									g_string_append (_tmp42_, "maximized = false\n");
								}
								g_hash_table_remove (new_conf, "maximized");
							} else {
								GString* _tmp43_;
								const gchar* _tmp44_;
								GString* _tmp45_;
								_tmp43_ = data;
								_tmp44_ = line;
								g_string_append (_tmp43_, _tmp44_);
								_tmp45_ = data;
								g_string_append (_tmp45_, "\n");
							}
						} else {
							const gchar* _tmp46_;
							_tmp46_ = line;
							if (string_contains (_tmp46_, "software_mode")) {
								gconstpointer _tmp47_ = NULL;
								gboolean _tmp48_;
								_tmp48_ = g_hash_table_lookup_extended (new_conf, "software_mode", NULL, &_tmp47_);
								variant = (GVariant*) _tmp47_;
								if (_tmp48_) {
									GVariant* _tmp49_;
									_tmp49_ = variant;
									if (g_variant_get_boolean (_tmp49_)) {
										GString* _tmp50_;
										_tmp50_ = data;
										g_string_append (_tmp50_, "software_mode = true\n");
									} else {
										GString* _tmp51_;
										_tmp51_ = data;
										g_string_append (_tmp51_, "software_mode = false\n");
									}
									g_hash_table_remove (new_conf, "software_mode");
								} else {
									GString* _tmp52_;
									const gchar* _tmp53_;
									GString* _tmp54_;
									_tmp52_ = data;
									_tmp53_ = line;
									g_string_append (_tmp52_, _tmp53_);
									_tmp54_ = data;
									g_string_append (_tmp54_, "\n");
								}
							} else {
								GString* _tmp55_;
								const gchar* _tmp56_;
								GString* _tmp57_;
								_tmp55_ = data;
								_tmp56_ = line;
								g_string_append (_tmp55_, _tmp56_);
								_tmp57_ = data;
								g_string_append (_tmp57_, "\n");
							}
						}
					}
				}
				_g_free0 (_tmp8_);
			}
			_tmp58_ = file;
			g_file_delete (_tmp58_, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_free0 (line);
				_g_object_unref0 (dis);
				_g_object_unref0 (_tmp4_);
				goto __catch0_g_error;
			}
			_g_free0 (line);
			_g_object_unref0 (dis);
			_g_object_unref0 (_tmp4_);
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp59_;
			const gchar* _tmp60_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp59_ = e;
			_tmp60_ = _tmp59_->message;
			g_warning ("local_config.vala:158: %s", _tmp60_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_string_free0 (data);
			_g_object_unref0 (file);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	} else {
		{
			GFile* parent = NULL;
			GFile* _tmp61_;
			GFile* _tmp62_;
			gboolean _tmp63_ = FALSE;
			GFile* _tmp64_;
			_tmp61_ = file;
			_tmp62_ = g_file_get_parent (_tmp61_);
			parent = _tmp62_;
			_tmp64_ = parent;
			if (_tmp64_ != NULL) {
				GFile* _tmp65_;
				_tmp65_ = parent;
				_tmp63_ = !g_file_query_exists (_tmp65_, NULL);
			} else {
				_tmp63_ = FALSE;
			}
			if (_tmp63_) {
				GFile* _tmp66_;
				_tmp66_ = parent;
				g_file_make_directory_with_parents (_tmp66_, NULL, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_object_unref0 (parent);
					goto __catch1_g_error;
				}
			}
			_g_object_unref0 (parent);
		}
		goto __finally1;
		__catch1_g_error:
		{
			GError* e = NULL;
			GError* _tmp67_;
			const gchar* _tmp68_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp67_ = e;
			_tmp68_ = _tmp67_->message;
			g_warning ("local_config.vala:167: %s", _tmp68_);
			_g_error_free0 (e);
		}
		__finally1:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_string_free0 (data);
			_g_object_unref0 (file);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	if (g_hash_table_size (new_conf) != ((guint) 0)) {
		GHashTableIter iter = {0};
		const gchar* key = NULL;
		GVariant* val = NULL;
		g_hash_table_iter_init (&iter, new_conf);
		while (TRUE) {
			gconstpointer _tmp69_ = NULL;
			gconstpointer _tmp70_ = NULL;
			gboolean _tmp71_;
			const gchar* _tmp72_;
			_tmp71_ = g_hash_table_iter_next (&iter, (gpointer*) (&_tmp69_), (gpointer*) (&_tmp70_));
			key = (const gchar*) _tmp69_;
			val = (GVariant*) _tmp70_;
			if (!_tmp71_) {
				break;
			}
			_tmp72_ = key;
			if (g_strcmp0 (_tmp72_, "width") == 0) {
				GString* _tmp73_;
				GVariant* _tmp74_;
				gchar* _tmp75_;
				gchar* _tmp76_;
				_tmp73_ = data;
				_tmp74_ = val;
				_tmp75_ = g_strdup_printf ("width = %llu\n", g_variant_get_uint64 (_tmp74_));
				_tmp76_ = _tmp75_;
				g_string_append (_tmp73_, _tmp76_);
				_g_free0 (_tmp76_);
			} else {
				const gchar* _tmp77_;
				_tmp77_ = key;
				if (g_strcmp0 (_tmp77_, "height") == 0) {
					GString* _tmp78_;
					GVariant* _tmp79_;
					gchar* _tmp80_;
					gchar* _tmp81_;
					_tmp78_ = data;
					_tmp79_ = val;
					_tmp80_ = g_strdup_printf ("height = %llu\n", g_variant_get_uint64 (_tmp79_));
					_tmp81_ = _tmp80_;
					g_string_append (_tmp78_, _tmp81_);
					_g_free0 (_tmp81_);
				} else {
					const gchar* _tmp82_;
					_tmp82_ = key;
					if (g_strcmp0 (_tmp82_, "maximized") == 0) {
						GVariant* _tmp83_;
						_tmp83_ = val;
						if (g_variant_get_boolean (_tmp83_)) {
							GString* _tmp84_;
							_tmp84_ = data;
							g_string_append (_tmp84_, "maximized = true\n");
						} else {
							GString* _tmp85_;
							_tmp85_ = data;
							g_string_append (_tmp85_, "maximized = false\n");
						}
					} else {
						const gchar* _tmp86_;
						_tmp86_ = key;
						if (g_strcmp0 (_tmp86_, "software_mode") == 0) {
							GVariant* _tmp87_;
							_tmp87_ = val;
							if (g_variant_get_boolean (_tmp87_)) {
								GString* _tmp88_;
								_tmp88_ = data;
								g_string_append (_tmp88_, "software_mode = true\n");
							} else {
								GString* _tmp89_;
								_tmp89_ = data;
								g_string_append (_tmp89_, "software_mode = false\n");
							}
						}
					}
				}
			}
		}
	}
	{
		GFileOutputStream* _tmp90_ = NULL;
		GFile* _tmp91_;
		GFileOutputStream* _tmp92_;
		GDataOutputStream* dos = NULL;
		GDataOutputStream* _tmp93_;
		GDataOutputStream* _tmp94_;
		GString* _tmp95_;
		const gchar* _tmp96_;
		_tmp91_ = file;
		_tmp92_ = g_file_create (_tmp91_, G_FILE_CREATE_REPLACE_DESTINATION, NULL, &_inner_error0_);
		_tmp90_ = _tmp92_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch2_g_error;
		}
		_tmp93_ = g_data_output_stream_new ((GOutputStream*) _tmp90_);
		dos = _tmp93_;
		_tmp94_ = dos;
		_tmp95_ = data;
		_tmp96_ = _tmp95_->str;
		g_data_output_stream_put_string (_tmp94_, _tmp96_, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (dos);
			_g_object_unref0 (_tmp90_);
			goto __catch2_g_error;
		}
		_g_object_unref0 (dos);
		_g_object_unref0 (_tmp90_);
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* e = NULL;
		GError* _tmp97_;
		const gchar* _tmp98_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp97_ = e;
		_tmp98_ = _tmp97_->message;
		g_warning ("local_config.vala:201: %s", _tmp98_);
		_g_error_free0 (e);
	}
	__finally2:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_string_free0 (data);
		_g_object_unref0 (file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_string_free0 (data);
	_g_object_unref0 (file);
}

const gchar*
pamac_local_config_get_conf_path (PamacLocalConfig* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_conf_path;
	result = _tmp0_;
	return result;
}

static void
pamac_local_config_set_conf_path (PamacLocalConfig* self,
                                  const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = pamac_local_config_get_conf_path (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_conf_path);
		self->priv->_conf_path = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, pamac_local_config_properties[PAMAC_LOCAL_CONFIG_CONF_PATH_PROPERTY]);
	}
}

guint64
pamac_local_config_get_width (PamacLocalConfig* self)
{
	guint64 result;
	g_return_val_if_fail (self != NULL, 0ULL);
	result = self->priv->_width;
	return result;
}

static void
pamac_local_config_set_width (PamacLocalConfig* self,
                              guint64 value)
{
	guint64 old_value;
	g_return_if_fail (self != NULL);
	old_value = pamac_local_config_get_width (self);
	if (old_value != value) {
		self->priv->_width = value;
		g_object_notify_by_pspec ((GObject *) self, pamac_local_config_properties[PAMAC_LOCAL_CONFIG_WIDTH_PROPERTY]);
	}
}

guint64
pamac_local_config_get_height (PamacLocalConfig* self)
{
	guint64 result;
	g_return_val_if_fail (self != NULL, 0ULL);
	result = self->priv->_height;
	return result;
}

static void
pamac_local_config_set_height (PamacLocalConfig* self,
                               guint64 value)
{
	guint64 old_value;
	g_return_if_fail (self != NULL);
	old_value = pamac_local_config_get_height (self);
	if (old_value != value) {
		self->priv->_height = value;
		g_object_notify_by_pspec ((GObject *) self, pamac_local_config_properties[PAMAC_LOCAL_CONFIG_HEIGHT_PROPERTY]);
	}
}

gboolean
pamac_local_config_get_maximized (PamacLocalConfig* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_maximized;
	return result;
}

static void
pamac_local_config_set_maximized (PamacLocalConfig* self,
                                  gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = pamac_local_config_get_maximized (self);
	if (old_value != value) {
		self->priv->_maximized = value;
		g_object_notify_by_pspec ((GObject *) self, pamac_local_config_properties[PAMAC_LOCAL_CONFIG_MAXIMIZED_PROPERTY]);
	}
}

gboolean
pamac_local_config_get_software_mode (PamacLocalConfig* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_software_mode;
	return result;
}

void
pamac_local_config_set_software_mode (PamacLocalConfig* self,
                                      gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = pamac_local_config_get_software_mode (self);
	if (old_value != value) {
		self->priv->_software_mode = value;
		g_object_notify_by_pspec ((GObject *) self, pamac_local_config_properties[PAMAC_LOCAL_CONFIG_SOFTWARE_MODE_PROPERTY]);
	}
}

static GObject *
pamac_local_config_constructor (GType type,
                                guint n_construct_properties,
                                GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	PamacLocalConfig * self;
	parent_class = G_OBJECT_CLASS (pamac_local_config_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PAMAC_TYPE_LOCAL_CONFIG, PamacLocalConfig);
	pamac_local_config_reload (self);
	return obj;
}

static void
pamac_local_config_class_init (PamacLocalConfigClass * klass,
                               gpointer klass_data)
{
	pamac_local_config_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PamacLocalConfig_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_pamac_local_config_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_pamac_local_config_set_property;
	G_OBJECT_CLASS (klass)->constructor = pamac_local_config_constructor;
	G_OBJECT_CLASS (klass)->finalize = pamac_local_config_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), PAMAC_LOCAL_CONFIG_CONF_PATH_PROPERTY, pamac_local_config_properties[PAMAC_LOCAL_CONFIG_CONF_PATH_PROPERTY] = g_param_spec_string ("conf-path", "conf-path", "conf-path", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PAMAC_LOCAL_CONFIG_WIDTH_PROPERTY, pamac_local_config_properties[PAMAC_LOCAL_CONFIG_WIDTH_PROPERTY] = g_param_spec_uint64 ("width", "width", "width", 0, G_MAXUINT64, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PAMAC_LOCAL_CONFIG_HEIGHT_PROPERTY, pamac_local_config_properties[PAMAC_LOCAL_CONFIG_HEIGHT_PROPERTY] = g_param_spec_uint64 ("height", "height", "height", 0, G_MAXUINT64, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PAMAC_LOCAL_CONFIG_MAXIMIZED_PROPERTY, pamac_local_config_properties[PAMAC_LOCAL_CONFIG_MAXIMIZED_PROPERTY] = g_param_spec_boolean ("maximized", "maximized", "maximized", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PAMAC_LOCAL_CONFIG_SOFTWARE_MODE_PROPERTY, pamac_local_config_properties[PAMAC_LOCAL_CONFIG_SOFTWARE_MODE_PROPERTY] = g_param_spec_boolean ("software-mode", "software-mode", "software-mode", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
pamac_local_config_instance_init (PamacLocalConfig * self,
                                  gpointer klass)
{
	self->priv = pamac_local_config_get_instance_private (self);
}

static void
pamac_local_config_finalize (GObject * obj)
{
	PamacLocalConfig * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PAMAC_TYPE_LOCAL_CONFIG, PamacLocalConfig);
	_g_free0 (self->priv->_conf_path);
	G_OBJECT_CLASS (pamac_local_config_parent_class)->finalize (obj);
}

static GType
pamac_local_config_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PamacLocalConfigClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pamac_local_config_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PamacLocalConfig), 0, (GInstanceInitFunc) pamac_local_config_instance_init, NULL };
	GType pamac_local_config_type_id;
	pamac_local_config_type_id = g_type_register_static (G_TYPE_OBJECT, "PamacLocalConfig", &g_define_type_info, 0);
	PamacLocalConfig_private_offset = g_type_add_instance_private (pamac_local_config_type_id, sizeof (PamacLocalConfigPrivate));
	return pamac_local_config_type_id;
}

GType
pamac_local_config_get_type (void)
{
	static volatile gsize pamac_local_config_type_id__once = 0;
	if (g_once_init_enter (&pamac_local_config_type_id__once)) {
		GType pamac_local_config_type_id;
		pamac_local_config_type_id = pamac_local_config_get_type_once ();
		g_once_init_leave (&pamac_local_config_type_id__once, pamac_local_config_type_id);
	}
	return pamac_local_config_type_id__once;
}

static void
_vala_pamac_local_config_get_property (GObject * object,
                                       guint property_id,
                                       GValue * value,
                                       GParamSpec * pspec)
{
	PamacLocalConfig * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PAMAC_TYPE_LOCAL_CONFIG, PamacLocalConfig);
	switch (property_id) {
		case PAMAC_LOCAL_CONFIG_CONF_PATH_PROPERTY:
		g_value_set_string (value, pamac_local_config_get_conf_path (self));
		break;
		case PAMAC_LOCAL_CONFIG_WIDTH_PROPERTY:
		g_value_set_uint64 (value, pamac_local_config_get_width (self));
		break;
		case PAMAC_LOCAL_CONFIG_HEIGHT_PROPERTY:
		g_value_set_uint64 (value, pamac_local_config_get_height (self));
		break;
		case PAMAC_LOCAL_CONFIG_MAXIMIZED_PROPERTY:
		g_value_set_boolean (value, pamac_local_config_get_maximized (self));
		break;
		case PAMAC_LOCAL_CONFIG_SOFTWARE_MODE_PROPERTY:
		g_value_set_boolean (value, pamac_local_config_get_software_mode (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_pamac_local_config_set_property (GObject * object,
                                       guint property_id,
                                       const GValue * value,
                                       GParamSpec * pspec)
{
	PamacLocalConfig * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PAMAC_TYPE_LOCAL_CONFIG, PamacLocalConfig);
	switch (property_id) {
		case PAMAC_LOCAL_CONFIG_CONF_PATH_PROPERTY:
		pamac_local_config_set_conf_path (self, g_value_get_string (value));
		break;
		case PAMAC_LOCAL_CONFIG_WIDTH_PROPERTY:
		pamac_local_config_set_width (self, g_value_get_uint64 (value));
		break;
		case PAMAC_LOCAL_CONFIG_HEIGHT_PROPERTY:
		pamac_local_config_set_height (self, g_value_get_uint64 (value));
		break;
		case PAMAC_LOCAL_CONFIG_MAXIMIZED_PROPERTY:
		pamac_local_config_set_maximized (self, g_value_get_boolean (value));
		break;
		case PAMAC_LOCAL_CONFIG_SOFTWARE_MODE_PROPERTY:
		pamac_local_config_set_software_mode (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

