/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.naming;

import com.intellij.lang.javascript.highlighting.JSFixFactory;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.psi.PsiElement;
import com.sixrr.inspectjs.BaseInspectionVisitor;
import com.sixrr.inspectjs.InspectionJSBundle;
import com.sixrr.inspectjs.InspectionJSFix;
import com.sixrr.inspectjs.naming.ConventionInspection;
import org.jetbrains.annotations.NonNls;

public class LocalVariableNamingConventionJSInspection
extends ConventionInspection {
    private static final int DEFAULT_MIN_LENGTH = 1;
    private static final int DEFAULT_MAX_LENGTH = 32;

    @Override
    protected InspectionJSFix buildFix(PsiElement location) {
        return JSFixFactory.getInstance().renameFix();
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Override
    public String buildErrorString(Object ... args) {
        JSVariable variable = (JSVariable)((PsiElement)args[0]).getParent();
        assert (variable != null);
        String variableName = variable.getName();
        if (variableName.length() < this.getMinLength()) {
            return InspectionJSBundle.message("variable.name.is.too.short.error.string", new Object[0]);
        }
        if (variableName.length() > this.getMaxLength()) {
            return InspectionJSBundle.message("variable.name.is.too.long.error.string", new Object[0]);
        }
        return InspectionJSBundle.message("variable.name.doesnt.match.regex.error.string", this.getRegex());
    }

    @Override
    @NonNls
    protected String getDefaultRegex() {
        return "[a-z][A-Za-z]*";
    }

    @Override
    protected int getDefaultMinLength() {
        return 1;
    }

    @Override
    protected int getDefaultMaxLength() {
        return 32;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    private class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        public void visitJSVarStatement(JSVarStatement jsVarStatement) {
            JSVariable[] variables;
            super.visitJSVarStatement(jsVarStatement);
            if (jsVarStatement.getParent() instanceof JSFile) {
                return;
            }
            for (JSVariable variable : variables = jsVarStatement.getVariables()) {
                String name;
                JSAttributeList attributeList = variable.getAttributeList();
                if (attributeList != null && attributeList.hasModifier(JSAttributeList.ModifierType.STATIC) && variable.isConst() || (name = variable.getName()) == null || LocalVariableNamingConventionJSInspection.this.isValid(name)) continue;
                this.registerVariableError(variable);
            }
        }
    }
}

