/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.functionmetrics;

import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.sixrr.inspectjs.BaseInspectionVisitor;
import com.sixrr.inspectjs.InspectionJSBundle;
import com.sixrr.inspectjs.functionmetrics.FunctionMetricsInspection;
import com.sixrr.inspectjs.functionmetrics.StatementCountVisitor;
import org.jetbrains.annotations.NotNull;

public class StatementsPerFunctionJSInspection
extends FunctionMetricsInspection {
    @Override
    protected int getDefaultLimit() {
        return 30;
    }

    @Override
    protected String getConfigurationLabel() {
        return InspectionJSBundle.message("maximum.statements.per.function", new Object[0]);
    }

    @Override
    public String buildErrorString(Object ... args) {
        JSFunction function2 = (JSFunction)((PsiElement)args[0]).getParent();
        assert (function2 != null);
        PsiElement lastChild = function2.getLastChild();
        StatementCountVisitor visitor = new StatementCountVisitor();
        assert (lastChild != null);
        lastChild.accept((PsiElementVisitor)visitor);
        int coupling = visitor.getStatementCount();
        if (StatementsPerFunctionJSInspection.functionHasIdentifier(function2)) {
            return InspectionJSBundle.message("function.is.overly.long.statement.error.string", coupling);
        }
        return InspectionJSBundle.message("anonymous.function.is.overly.long.statement.error.string", coupling);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    private class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        public void visitJSFunctionDeclaration(@NotNull JSFunction function2) {
            PsiElement lastChild;
            if (function2 == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            if (!((lastChild = function2.getLastChild()) instanceof JSBlockStatement)) {
                return;
            }
            StatementCountVisitor visitor = new StatementCountVisitor();
            lastChild.accept((PsiElementVisitor)visitor);
            int statementCount = visitor.getStatementCount();
            if (statementCount <= StatementsPerFunctionJSInspection.this.getLimit()) {
                return;
            }
            this.registerFunctionError(function2);
        }

        public void visitJSFunctionExpression(JSFunctionExpression node) {
            this.visitJSFunctionDeclaration((JSFunction)node);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/sixrr/inspectjs/functionmetrics/StatementsPerFunctionJSInspection$Visitor", "visitJSFunctionDeclaration"));
        }
    }
}

