/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation.fixes;

import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.inspections.NewLineEraser;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.impl.JSPsiElementFactory;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.psi.util.SideEffectChecker;
import com.intellij.lang.javascript.validation.fixes.RemoveASTNodeFix;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoveUnusedAssignmentFix
extends LocalQuickFixAndIntentionActionOnPsiElement {
    private final boolean myAllInDestructuring;

    public RemoveUnusedAssignmentFix(@Nullable PsiElement element, boolean allInDestructuring) {
        super(element);
        this.myAllInDestructuring = allInDestructuring;
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file2, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        JSExpression operand;
        if (project == null) {
            RemoveUnusedAssignmentFix.$$$reportNull$$$0(0);
        }
        if (file2 == null) {
            RemoveUnusedAssignmentFix.$$$reportNull$$$0(1);
        }
        if (startElement == null) {
            RemoveUnusedAssignmentFix.$$$reportNull$$$0(2);
        }
        if (endElement == null) {
            RemoveUnusedAssignmentFix.$$$reportNull$$$0(3);
        }
        if (startElement instanceof JSAssignmentExpression && (operand = ((JSAssignmentExpression)startElement).getROperand()) != null && SideEffectChecker.mayHaveSideEffects(operand)) {
            startElement.replace((PsiElement)JSPsiElementFactory.createJSExpression(operand.getText(), startElement));
            return;
        }
        PsiElement assignmentParent = this.getAssignmentParent(startElement);
        if (assignmentParent == null) {
            return;
        }
        NewLineEraser eraser = new NewLineEraser(assignmentParent);
        new RemoveASTNodeFix("js.remove.unused.assignment", assignmentParent).invoke(project, file2, editor, assignmentParent, assignmentParent);
        eraser.process();
    }

    public boolean isAvailable(@NotNull Project project, @NotNull PsiFile file2, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project == null) {
            RemoveUnusedAssignmentFix.$$$reportNull$$$0(4);
        }
        if (file2 == null) {
            RemoveUnusedAssignmentFix.$$$reportNull$$$0(5);
        }
        if (startElement == null) {
            RemoveUnusedAssignmentFix.$$$reportNull$$$0(6);
        }
        if (endElement == null) {
            RemoveUnusedAssignmentFix.$$$reportNull$$$0(7);
        }
        if (!super.isAvailable(project, file2, editor, startElement, endElement)) {
            return false;
        }
        return this.getAssignmentParent(startElement) instanceof JSExpressionStatement;
    }

    @Nullable
    private PsiElement getAssignmentParent(@NotNull PsiElement startElement) {
        if (startElement == null) {
            RemoveUnusedAssignmentFix.$$$reportNull$$$0(8);
        }
        return this.myAllInDestructuring ? JSUtils.getParentSkipParentheses(PsiTreeUtil.getParentOfType((PsiElement)startElement, JSAssignmentExpression.class)) : JSUtils.getParentSkipParentheses(startElement);
    }

    @NotNull
    public String getText() {
        String string = this.getFamilyName();
        if (string == null) {
            RemoveUnusedAssignmentFix.$$$reportNull$$$0(9);
        }
        return string;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string = JavaScriptBundle.message((String)"js.remove.unused.assignment", (Object[])new Object[0]);
        if (string == null) {
            RemoveUnusedAssignmentFix.$$$reportNull$$$0(10);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/validation/fixes/RemoveUnusedAssignmentFix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/validation/fixes/RemoveUnusedAssignmentFix";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getAssignmentParent";
                break;
            }
            case 9: 
            case 10: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

