/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation.fixes;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.validation.fixes.JSAttributeListWrapper;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.IncorrectOperationException;
import com.sixrr.inspectjs.InspectionJSFix;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class JSRemoveReadonlyModifierFix
extends InspectionJSFix {
    @NotNull
    private final SmartPsiElementPointer<JSAttributeListOwner> myNodePointer;

    public JSRemoveReadonlyModifierFix(@NotNull JSAttributeListOwner attributeList) {
        if (attributeList == null) {
            JSRemoveReadonlyModifierFix.$$$reportNull$$$0(0);
        }
        this.myNodePointer = SmartPointerManager.getInstance((Project)attributeList.getProject()).createSmartPsiElementPointer((PsiElement)attributeList);
    }

    @Override
    protected void doFix(Project project, ProblemDescriptor descriptor2) throws IncorrectOperationException {
        JSAttributeListOwner element = (JSAttributeListOwner)this.myNodePointer.getElement();
        if (element == null) {
            return;
        }
        JSAttributeListWrapper attributeListWrapper = new JSAttributeListWrapper(element);
        attributeListWrapper.overrideModifier(JSAttributeList.ModifierType.READONLY, false);
        attributeListWrapper.applyTo(element);
    }

    @NotNull
    public String getName() {
        String string = JavaScriptBundle.message((String)"javascript.validation.message.assignment.to.const.fix.remove.readonly", (Object[])new Object[0]);
        if (string == null) {
            JSRemoveReadonlyModifierFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string = JavaScriptBundle.message((String)"javascript.validation.message.assignment.to.const", (Object[])new Object[0]);
        if (string == null) {
            JSRemoveReadonlyModifierFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributeList";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/validation/fixes/JSRemoveReadonlyModifierFix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/validation/fixes/JSRemoveReadonlyModifierFix";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

