/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation;

import com.intellij.codeInsight.daemon.impl.analysis.HighlightInfoHolder;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSKeywordSets;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.highlighting.JSHighlighter;
import com.intellij.lang.javascript.highlighting.TypeScriptHighlighter;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptAwaitedType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptCastExpression;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptImportStatement;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptInferType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptMappedType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeAlias;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeOperator;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypePredicate;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.validation.ES6KeywordHighlighterVisitor;
import com.intellij.lang.javascript.validation.JSKeywordHighlighterVisitor;
import com.intellij.lang.typescript.psi.TypeScriptExternalModuleReference;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class TypeScriptKeywordHighlighterVisitor
extends ES6KeywordHighlighterVisitor {
    public static final Collection<IElementType> MODIFIERS_KEYWORDS = ContainerUtil.immutableList((Object[])new IElementType[]{JSTokenTypes.DECLARE_KEYWORD, JSTokenTypes.ABSTRACT_KEYWORD, JSTokenTypes.READONLY_KEYWORD});

    public TypeScriptKeywordHighlighterVisitor(@NotNull HighlightInfoHolder holder) {
        if (holder == null) {
            TypeScriptKeywordHighlighterVisitor.$$$reportNull$$$0(0);
        }
        this(holder, new TypeScriptHighlighter(true));
    }

    protected TypeScriptKeywordHighlighterVisitor(HighlightInfoHolder holder, JSHighlighter highlighter) {
        super(holder, highlighter);
    }

    public void visitTypeScriptModule(TypeScriptModule element) {
        this.highlightChildKeywordOfTypes((PsiElement)element, JSKeywordSets.MODULES_AND_GLOBAL_KEYWORDS);
        super.visitTypeScriptModule(element);
    }

    @Override
    @NotNull
    protected TextAttributesKey annotatePrimitiveType(ASTNode keyword) {
        ASTNode identifier;
        if (keyword.getElementType() == JSTokenTypes.SYMBOL_KEYWORD && (identifier = TreeUtil.findSiblingBackward((ASTNode)keyword, (IElementType)JSTokenTypes.IDENTIFIER)) != null && "unique".equals(identifier.getText())) {
            this.myHolder.add(JSKeywordHighlighterVisitor.highlightKeyword(identifier, TypeScriptHighlighter.TS_PRIMITIVE_TYPES));
        }
        TextAttributesKey textAttributesKey = TypeScriptHighlighter.TS_PRIMITIVE_TYPES;
        if (textAttributesKey == null) {
            TypeScriptKeywordHighlighterVisitor.$$$reportNull$$$0(1);
        }
        return textAttributesKey;
    }

    public void visitTypeScriptTypeAlias(TypeScriptTypeAlias element) {
        this.highlightChildKeywordOfType((PsiElement)element, JSTokenTypes.TYPE_KEYWORD);
        super.visitTypeScriptTypeAlias(element);
    }

    public void visitTypeScriptInferType(TypeScriptInferType element) {
        this.highlightChildKeywordOfType((PsiElement)element, JSTokenTypes.INFER_KEYWORD);
        super.visitTypeScriptInferType(element);
    }

    public void visitTypeScriptTypeOperator(TypeScriptTypeOperator element) {
        this.highlightChildKeywordOfType((PsiElement)element, JSTokenTypes.KEYOF_KEYWORD);
        super.visitTypeScriptTypeOperator(element);
    }

    public void visitTypeScriptAwaitedType(TypeScriptAwaitedType typeOperator) {
        this.highlightChildKeywordOfType((PsiElement)typeOperator, JSTokenTypes.AWAITED_KEYWORD);
        super.visitTypeScriptAwaitedType(typeOperator);
    }

    @Override
    public void visitJSAttributeList(JSAttributeList element) {
        this.highlightModifierKeywords(element);
        super.visitJSAttributeList(element);
    }

    public void visitTypeScriptImportStatement(TypeScriptImportStatement importStatement) {
        TypeScriptExternalModuleReference externalModuleReference = importStatement.getExternalModuleReference();
        if (externalModuleReference != null) {
            this.highlightChildKeywordOfType((PsiElement)externalModuleReference, JSTokenTypes.REQUIRE_KEYWORD);
        }
        super.visitTypeScriptImportStatement(importStatement);
    }

    public void highlightModifierKeywords(JSAttributeList element) {
        for (IElementType modifier : this.getModifiers()) {
            this.highlightChildKeywordOfType((PsiElement)element, modifier);
        }
    }

    public void visitTypeScriptTypePredicate(TypeScriptTypePredicate predicate) {
        this.highlightChildKeywordOfType((PsiElement)predicate, JSTokenTypes.ASSERTS_KEYWORD);
        this.highlightChildKeywordOfType((PsiElement)predicate, JSTokenTypes.IS_KEYWORD);
        super.visitTypeScriptTypePredicate(predicate);
    }

    @NotNull
    protected Collection<IElementType> getModifiers() {
        Collection<IElementType> collection = MODIFIERS_KEYWORDS;
        if (collection == null) {
            TypeScriptKeywordHighlighterVisitor.$$$reportNull$$$0(2);
        }
        return collection;
    }

    public void visitTypeScriptCastExpression(TypeScriptCastExpression node) {
        this.highlightChildKeywordOfType((PsiElement)node, JSTokenTypes.AS_KEYWORD);
        super.visitTypeScriptCastExpression(node);
    }

    public void visitTypeScriptMappedType(TypeScriptMappedType mappedType) {
        this.highlightChildKeywordOfType((PsiElement)mappedType, JSTokenTypes.READONLY_KEYWORD);
        super.visitTypeScriptMappedType(mappedType);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/validation/TypeScriptKeywordHighlighterVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/validation/TypeScriptKeywordHighlighterVisitor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "annotatePrimitiveType";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getModifiers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

