/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.analysis.XmlHighlightVisitor;
import com.intellij.codeInsight.highlighting.ReadWriteAccessDetector;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.codeInspection.LocalQuickFixProvider;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.ecmascript6.psi.ES6AssignmentProperty;
import com.intellij.lang.ecmascript6.psi.ES6ComputedName;
import com.intellij.lang.ecmascript6.psi.ES6ExportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment;
import com.intellij.lang.ecmascript6.psi.ES6ExportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifierAlias;
import com.intellij.lang.ecmascript6.psi.ES6ImportedBinding;
import com.intellij.lang.ecmascript6.psi.ES6Property;
import com.intellij.lang.ecmascript6.psi.Es6MetaProperty;
import com.intellij.lang.ecmascript6.psi.JSClassExpression;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSKeywordSets;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JSNumberParser;
import com.intellij.lang.javascript.JSStringLiteralLexer;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.dialects.JSLanguageLevel;
import com.intellij.lang.javascript.findUsages.JSReadWriteAccessDetector;
import com.intellij.lang.javascript.frameworks.extjs.ExtXTypeReference;
import com.intellij.lang.javascript.highlighting.JSFixFactory;
import com.intellij.lang.javascript.highlighting.JSHighlighter;
import com.intellij.lang.javascript.highlighting.JSSemanticHighlightingUtil;
import com.intellij.lang.javascript.inspections.JSFileReferencesInspection;
import com.intellij.lang.javascript.presentable.JSFormatUtil;
import com.intellij.lang.javascript.psi.JSArrayComprehension;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSBreakStatement;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSCaseClause;
import com.intellij.lang.javascript.psi.JSCatchBlock;
import com.intellij.lang.javascript.psi.JSContinueStatement;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSDestructuringArrayRestElement;
import com.intellij.lang.javascript.psi.JSDestructuringContainer;
import com.intellij.lang.javascript.psi.JSDestructuringElement;
import com.intellij.lang.javascript.psi.JSDestructuringProperty;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSExecutionScope;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSForInStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSFunctionProperty;
import com.intellij.lang.javascript.psi.JSGeneratorExpression;
import com.intellij.lang.javascript.psi.JSInitializerOwner;
import com.intellij.lang.javascript.psi.JSLabeledStatement;
import com.intellij.lang.javascript.psi.JSLetStatement;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpressionKind;
import com.intellij.lang.javascript.psi.JSLoopStatement;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSPostfixExpression;
import com.intellij.lang.javascript.psi.JSPrefixExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSPsiNamedElementBase;
import com.intellij.lang.javascript.psi.JSPsiReferenceElement;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSStatementWithLabelReference;
import com.intellij.lang.javascript.psi.JSSwitchStatement;
import com.intellij.lang.javascript.psi.JSTryStatement;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.JSWithStatement;
import com.intellij.lang.javascript.psi.JSXmlLiteralExpression;
import com.intellij.lang.javascript.psi.JSYieldExpression;
import com.intellij.lang.javascript.psi.ecma6.ES6Decorator;
import com.intellij.lang.javascript.psi.ecma6.JSStringTemplateExpression;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnum;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptInterface;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeAlias;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceList;
import com.intellij.lang.javascript.psi.ecmal4.JSSuperExpression;
import com.intellij.lang.javascript.psi.ecmal4.XmlBackedJSClass;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.ImplicitJSVariableImpl;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSScopeNamesCache;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSUnionType;
import com.intellij.lang.javascript.psi.types.JSUnknownType;
import com.intellij.lang.javascript.psi.types.primitives.JSVoidType;
import com.intellij.lang.javascript.psi.util.JSClassUtils;
import com.intellij.lang.javascript.psi.util.JSDestructuringUtil;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.validation.DuplicatesCheckUtil;
import com.intellij.lang.javascript.validation.HighlightSeverityHolder;
import com.intellij.lang.javascript.validation.JSAnnotatorProblemReporter;
import com.intellij.lang.javascript.validation.JSConstructorChecker;
import com.intellij.lang.javascript.validation.JSNavigateToAlreadyDeclaredVariableFix;
import com.intellij.lang.javascript.validation.JSValidateExpressionUtil;
import com.intellij.lang.javascript.validation.fixes.ChangeLanguageLevelFix;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.StringEscapesTokenTypes;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTagChild;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CharArrayUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;

public abstract class JSAnnotatingVisitor
extends JSElementVisitor {
    private static final String OCTAL_SEQUENCE_START = "\\0";
    private static final String EVAL_FUNCTION_NAME = "eval";
    public static final String VOID_TYPE_NAME = "void";
    @NotNull
    protected final AnnotationHolder myHolder;
    @NotNull
    protected final JSAnnotatorProblemReporter myProblemReporter;
    @NotNull
    protected final JSHighlighter myHighlighter;

    public JSAnnotatingVisitor(@NotNull PsiElement psiElement, @NotNull AnnotationHolder holder) {
        if (psiElement == null) {
            JSAnnotatingVisitor.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            JSAnnotatingVisitor.$$$reportNull$$$0(1);
        }
        this.myHolder = holder;
        this.myHighlighter = JSAnnotatingVisitor.getHighlighter(psiElement);
        this.myProblemReporter = this.createProblemReporter(psiElement);
    }

    public static JSHighlighter getHighlighter(PsiElement psiElement) {
        return JSAnnotatingVisitor.getHighlighter(DialectDetector.languageOfElement(psiElement));
    }

    @NotNull
    public static JSHighlighter getHighlighter(@Nullable Language dialect) {
        return dialect instanceof JSLanguageDialect ? (JSHighlighter)SyntaxHighlighterFactory.getSyntaxHighlighter((Language)dialect, null, null) : new JSHighlighter(JavascriptLanguage.E4X_OPTION_HOLDER, true);
    }

    @NotNull
    protected JSAnnotatorProblemReporter createProblemReporter(PsiElement context) {
        return new JSAnnotatorProblemReporter(this.myHolder);
    }

    @NotNull
    protected JSConstructorChecker createConstructorChecker() {
        return new JSConstructorChecker(this.myProblemReporter);
    }

    public void visitElement(@NotNull PsiElement element) {
        if (element == null) {
            JSAnnotatingVisitor.$$$reportNull$$$0(2);
        }
        if (JSKeywordSets.IDENTIFIER_NAMES.contains(element.getNode().getElementType())) {
            JSNamedElement namedElement = JSPsiImplUtils.findElementFromNameIdentifier(element);
            if (namedElement instanceof JSParameter) {
                JSSemanticHighlightingUtil.highlight((JSVariable)((JSParameter)namedElement), this.myHighlighter, this.myHolder);
            } else if (namedElement instanceof JSVariable) {
                JSSemanticHighlightingUtil.highlight((JSVariable)namedElement, this.myHighlighter, this.myHolder);
            } else if (namedElement instanceof JSProperty) {
                JSSemanticHighlightingUtil.highlight((JSProperty)namedElement, this.myHighlighter, this.myHolder);
            } else if (namedElement instanceof JSDestructuringProperty) {
                JSSemanticHighlightingUtil.highlight((JSDestructuringProperty)namedElement, this.myHighlighter, this.myHolder);
            } else if (namedElement instanceof JSFunction) {
                IElementType elementType = namedElement.getNode().getElementType();
                if (JSElementTypes.FUNCTION_DECLARATIONS.contains(elementType)) {
                    this.checkFunctionDeclaration((JSFunction)namedElement);
                }
            } else if (namedElement instanceof TypeScriptModule) {
                JSSemanticHighlightingUtil.highlight((TypeScriptModule)namedElement, this.myHighlighter, this.myHolder);
            }
        }
        super.visitElement(element);
    }

    public void visitJSLiteralExpression(@NotNull JSLiteralExpression node) {
        JSLiteralExpressionKind expressionKind;
        if (node == null) {
            JSAnnotatingVisitor.$$$reportNull$$$0(3);
        }
        if (node.isQuotedLiteral()) {
            this.checkReferences((PsiElement)node);
        }
        if ((expressionKind = node.getExpressionKind(true)) == JSLiteralExpressionKind.OCT || expressionKind.isBin()) {
            this.checkElementInCurrentLanguageLevel((PsiElement)node, JSLanguageFeature.BINARY_AND_OCTAL_LITERALS);
        } else if (expressionKind.isBigInteger()) {
            this.checkElementInCurrentLanguageLevel((PsiElement)node, JSLanguageFeature.BIG_INT);
        } else if (expressionKind == JSLiteralExpressionKind.QUOTED) {
            IElementType tokenType;
            boolean checkUnicodeEscapesWithBraces;
            boolean checkOctalLiteral = node.textContains('0') && JSResolveUtil.isEcmaScript5((PsiElement)node);
            boolean allowsUnicodeEscapesWithBraces = DialectDetector.isJavaScriptFamily((PsiElement)node);
            boolean bl = checkUnicodeEscapesWithBraces = allowsUnicodeEscapesWithBraces && node.textContains('{');
            if (!checkOctalLiteral && !checkUnicodeEscapesWithBraces) {
                return;
            }
            String text = node.getText();
            if (!(checkOctalLiteral &= text.contains(OCTAL_SEQUENCE_START)) && !(checkUnicodeEscapesWithBraces &= text.contains("\\u{"))) {
                return;
            }
            JSStringLiteralLexer literalLexer = new JSStringLiteralLexer(text.charAt(0), node.getNode().getFirstChildNode().getElementType(), "/v", true, allowsUnicodeEscapesWithBraces, text.charAt(0) == '`');
            literalLexer.start(text);
            int literalStart = node.getTextOffset();
            while ((tokenType = literalLexer.getTokenType()) != null) {
                int end;
                int start;
                if (checkUnicodeEscapesWithBraces && tokenType == StringEscapesTokenTypes.VALID_STRING_ESCAPE_TOKEN && literalLexer.getTokenText().startsWith("\\u{")) {
                    TextRange errorRange = new TextRange(literalStart + literalLexer.getTokenStart(), literalStart + literalLexer.getTokenEnd());
                    this.checkElementInCurrentLanguageLevel((PsiElement)node, errorRange, JSLanguageFeature.UNICODE_ESCAPES_WITH_BRACES);
                    String tokenText = literalLexer.getTokenText();
                    Double numericValue = JSNumberParser.tryParseNumericValue("0x" + tokenText.substring(3, tokenText.length() - 1), false);
                    if (numericValue != null && (numericValue < 0.0 || numericValue > 1114111.0)) {
                        this.myProblemReporter.registerProblem(null, new TextRange(errorRange.getStartOffset() + 3, errorRange.getEndOffset() - 1), JavaScriptBundle.message((String)"javascript.invalid.extended.unicode.escape", (Object[])new Object[0]), ProblemHighlightType.GENERIC_ERROR, null, LocalQuickFix.EMPTY_ARRAY, IntentionAction.EMPTY_ARRAY);
                    }
                }
                if (checkOctalLiteral && (tokenType == StringEscapesTokenTypes.INVALID_CHARACTER_ESCAPE_TOKEN || tokenType == StringEscapesTokenTypes.VALID_STRING_ESCAPE_TOKEN) && CharArrayUtil.indexOf((CharSequence)text, (CharSequence)OCTAL_SEQUENCE_START, (int)(start = literalLexer.getTokenStart()), (int)(end = literalLexer.getTokenEnd())) == start && end - start > 2) {
                    TextRange errorRange = new TextRange(literalStart + start, literalStart + end);
                    this.myProblemReporter.registerProblem(null, errorRange, JavaScriptBundle.message((String)"javascript.octal.sequences.are.not.allowed.message", (Object[])new Object[0]), ProblemHighlightType.GENERIC_ERROR, null, LocalQuickFix.EMPTY_ARRAY, IntentionAction.EMPTY_ARRAY);
                }
                literalLexer.advance();
            }
        }
    }

    protected ProblemHighlightType getHighlightTypeForTypeOrSignatureProblem(@NotNull PsiElement node) {
        if (node == null) {
            JSAnnotatingVisitor.$$$reportNull$$$0(4);
        }
        return ProblemHighlightType.WEAK_WARNING;
    }

    protected boolean checkReferences(@NotNull PsiElement element) {
        if (element == null) {
            JSAnnotatingVisitor.$$$reportNull$$$0(5);
        }
        return this.checkReferences(element, null);
    }

    protected boolean checkReferences(PsiElement element, @Nullable ProblemHighlightType problemHighlightType) {
        if (element instanceof JSXmlLiteralExpression) {
            return true;
        }
        boolean ok = true;
        for (PsiReference ref : element.getReferences()) {
            if (ref.isSoft() || ref instanceof FileReference && JSFileReferencesInspection.acceptsReference((FileReference)ref) || ref instanceof ExtXTypeReference) continue;
            if (ref instanceof PsiPolyVariantReference) {
                ok &= this.checkReference(problemHighlightType, (PsiPolyVariantReference)ref);
            } else if (ref.resolve() == null) {
                ok = false;
                this.registerProblemForReference(ref, null, problemHighlightType);
            }
            if (DialectDetector.isTypeScript(element) && !ok) break;
        }
        return ok;
    }

    protected boolean checkReference(@Nullable ProblemHighlightType problemHighlightType, @NotNull PsiPolyVariantReference ref) {
        ResolveResult result2;
        ResolveResult[] results;
        if (ref == null) {
            JSAnnotatingVisitor.$$$reportNull$$$0(6);
        }
        if ((results = ref.multiResolve(false)).length == 0) {
            this.registerProblemForReference((PsiReference)ref, null, problemHighlightType);
            return false;
        }
        if (results.length == 1 && !(result2 = results[0]).isValidResult()) {
            String key;
            String message = null;
            if (result2 instanceof JSResolveResult && (key = ((JSResolveResult)result2).getResolveProblemKey()) != null) {
                message = JavaScriptBundle.message((String)key, (Object[])new Object[0]);
            }
            this.registerProblemForReference((PsiReference)ref, message, problemHighlightType);
            return false;
        }
        return true;
    }

    protected void registerProblemForReference(@NotNull PsiReference ref, @Nullable String unresolvedMessage, @Nullable ProblemHighlightType problemHighlightType) {
        String message;
        if (ref == null) {
            JSAnnotatingVisitor.$$$reportNull$$$0(7);
        }
        TextRange range = JSAnnotatingVisitor.calcRangeForReferences(ref);
        String string = message = unresolvedMessage != null ? unresolvedMessage : XmlHighlightVisitor.getErrorDescription((PsiReference)ref);
        if (problemHighlightType == null && ref instanceof HighlightSeverityHolder) {
            problemHighlightType = HighlightInfo.convertSeverityToProblemHighlight((HighlightSeverity)((HighlightSeverityHolder)ref).getUnresolvedReferenceSeverity());
        }
        if (problemHighlightType == null) {
            problemHighlightType = ProblemHighlightType.ERROR;
        }
        LocalQuickFix[] fixes = this.getQuickFixesForReferenceProblem(ref, message);
        this.myProblemReporter.registerProblem(ref.getElement(), range, message, problemHighlightType, null, fixes, IntentionAction.EMPTY_ARRAY);
    }

    protected LocalQuickFix @NotNull [] getQuickFixesForReferenceProblem(@NotNull PsiReference ref, @Nullable String message) {
        if (ref == null) {
            JSAnnotatingVisitor.$$$reportNull$$$0(8);
        }
        if (ref instanceof LocalQuickFixProvider) {
            LocalQuickFix[] localQuickFixArray = (LocalQuickFix[])ObjectUtils.notNull((Object)((LocalQuickFixProvider)ref).getQuickFixes(), (Object)LocalQuickFix.EMPTY_ARRAY);
            if (localQuickFixArray == null) {
                JSAnnotatingVisitor.$$$reportNull$$$0(9);
            }
            return localQuickFixArray;
        }
        if (LocalQuickFix.EMPTY_ARRAY == null) {
            JSAnnotatingVisitor.$$$reportNull$$$0(10);
        }
        return LocalQuickFix.EMPTY_ARRAY;
    }

    protected static TextRange calcRangeForReferences(PsiReference ref) {
        TextRange elementRange = ref.getElement().getTextRange();
        TextRange textRange = ref.getRangeInElement();
        return new TextRange(elementRange.getStartOffset() + textRange.getStartOffset(), elementRange.getStartOffset() + textRange.getEndOffset());
    }

    public void visitJSCallExpression(JSCallExpression node) {
        JSFunction fun;
        JSExpression methodExpression = node.getMethodExpression();
        if (methodExpression instanceof JSParenthesizedExpression) {
            methodExpression = JSUtils.unparenthesize(methodExpression);
        }
        if (methodExpression instanceof JSLiteralExpression && !(methodExpression instanceof JSStringTemplateExpression)) {
            this.myProblemReporter.registerGenericError((PsiElement)methodExpression, JavaScriptBundle.message((String)"javascript.parser.message.expected.function.name", (Object[])new Object[0]), new IntentionAction[0]);
        } else if (methodExpression instanceof JSSuperExpression && JSClassUtils.canHaveClasses((PsiElement)node) && ((fun = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)node, JSFunction.class)) == null || !fun.isConstructor())) {
            String message = JavaScriptBundle.message((String)"javascript.validation.message.super.constructor.call.should.be.in.constructor", (Object[])new Object[0]);
            this.myProblemReporter.registerGenericError((PsiElement)node, message, new IntentionAction[0]);
        }
    }

    public void visitJSArrayComprehension(JSArrayComprehension arrayComprehension) {
        this.checkElementInCurrentLanguageLevel((PsiElement)arrayComprehension, JSLanguageFeature.ARRAY_COMPREHENSIONS);
    }

    public void visitJSDestructuringArrayRestElement(JSDestructuringArrayRestElement jsDestructuringArrayRest) {
        this.validateNoCommaAfter((PsiElement)jsDestructuringArrayRest, JSTokenTypes.RBRACKET);
    }

    public void visitJSYieldExpression(JSYieldExpression expression) {
        JSElement containerParent;
        DialectOptionHolder dialectOptionHolder;
        JSExpression subExpression = expression.getExpression();
        if (!(subExpression instanceof JSParenthesizedExpression)) {
            this.checkElementInCurrentLanguageLevel((PsiElement)expression, JSLanguageFeature.YIELD_GENERATORS);
        }
        if (!((dialectOptionHolder = DialectDetector.dialectOfElement((PsiElement)expression)) == null || !dialectOptionHolder.isECMA6 && !dialectOptionHolder.isTypeScript || (containerParent = (JSElement)PsiTreeUtil.getParentOfType((PsiElement)expression, (Class[])new Class[]{JSExecutionScope.class, JSClass.class, ES6Decorator.class, JSParameterListElement.class})) instanceof JSFunction && ((JSFunction)containerParent).isGenerator() && !((JSFunction)containerParent).isArrowFunction())) {
            this.myProblemReporter.registerGenericError((PsiElement)expression, JavaScriptBundle.message((String)"javascript.validation.generators.yield.not.in.generator", (Object[])new Object[0]), new IntentionAction[0]);
        }
    }

    public void visitJSBindExpression(JSExpression bindExpression) {
        this.checkElementInCurrentLanguageLevel((PsiElement)bindExpression, JSLanguageFeature.BIND_EXPRESSIONS);
    }

    protected void checkElementInCurrentLanguageLevel(@NotNull PsiElement elementToHighlight, @NotNull JSLanguageFeature languageFeature) {
        if (elementToHighlight == null) {
            JSAnnotatingVisitor.$$$reportNull$$$0(11);
        }
        if (languageFeature == null) {
            JSAnnotatingVisitor.$$$reportNull$$$0(12);
        }
        this.checkElementInCurrentLanguageLevel(elementToHighlight, null, languageFeature);
    }

    private void checkElementInCurrentLanguageLevel(@NotNull PsiElement elementToHighlight, @Nullable TextRange range, @NotNull JSLanguageFeature languageFeature) {
        JSLanguageLevel currentLevel;
        if (elementToHighlight == null) {
            JSAnnotatingVisitor.$$$reportNull$$$0(13);
        }
        if (languageFeature == null) {
            JSAnnotatingVisitor.$$$reportNull$$$0(14);
        }
        if ((currentLevel = JSLanguageLevel.ofElement(elementToHighlight)) != null && !currentLevel.getDialect().getOptionHolder().hasFeature(languageFeature)) {
            String message = JavaScriptBundle.message((String)"javascript.parser.message.are.not.supported.by.dialect", (Object[])new Object[]{languageFeature});
            ArrayList<ChangeLanguageLevelFix> fixes = new ArrayList<ChangeLanguageLevelFix>(2);
            JSLanguageLevel proposedLevel = ChangeLanguageLevelFix.defineMinimalLanguageLevel(languageFeature, currentLevel);
            if (DialectOptionHolder.ECMA_6.hasFeature(languageFeature) && proposedLevel != null && JSLanguageLevel.JS_1_8_5.isAtLeast(proposedLevel)) {
                proposedLevel = JSLanguageLevel.ES6;
            }
            if (proposedLevel != null) {
                fixes.add(new ChangeLanguageLevelFix(proposedLevel));
            }
            if (range == null) {
                this.myProblemReporter.registerProblem(elementToHighlight, null, message, ProblemHighlightType.GENERIC_ERROR, null, LocalQuickFix.EMPTY_ARRAY, fixes.toArray(IntentionAction.EMPTY_ARRAY));
            } else {
                this.myProblemReporter.registerProblem(elementToHighlight, range, message, ProblemHighlightType.GENERIC_ERROR, null, LocalQuickFix.EMPTY_ARRAY, fixes.toArray(IntentionAction.EMPTY_ARRAY));
            }
        }
    }

    public void visitJSLetStatement(JSLetStatement statement) {
        this.checkElementInCurrentLanguageLevel((PsiElement)statement, JSLanguageFeature.LET_SCOPE);
    }

    public void visitComment(@NotNull PsiComment comment) {
        if (comment == null) {
            JSAnnotatingVisitor.$$$reportNull$$$0(15);
        }
        super.visitComment(comment);
        String text = comment.getText();
        if (text.startsWith("/*") && !text.endsWith("*/") && PsiTreeUtil.getNextSiblingOfType((PsiElement)comment, OuterLanguageElement.class) == null) {
            TextRange r = comment.getTextRange();
            TextRange errorRange = TextRange.create((int)Math.max(r.getStartOffset(), r.getEndOffset() - 1), (int)r.getEndOffset());
            this.myHolder.newAnnotation(HighlightSeverity.ERROR, JavaScriptBundle.message((String)"javascript.parser.message.unclosed.comment", (Object[])new Object[0])).range(errorRange).afterEndOfLine().create();
        }
    }

    public void visitJSVarStatement(JSVarStatement node) {
        ASTNode keyword = node.getNode().findChildByType(JSTokenTypes.VAR_MODIFIERS);
        if (keyword != null && keyword.getElementType() == JSTokenTypes.LET_KEYWORD) {
            this.checkElementInCurrentLanguageLevel(keyword.getPsi(), JSLanguageFeature.LET_DEFINITIONS);
        }
        if (keyword != null && keyword.getElementType() == JSTokenTypes.CONST_KEYWORD) {
            this.checkElementInCurrentLanguageLevel(keyword.getPsi(), JSLanguageFeature.CONST_DEFINITIONS);
        }
    }

    public void visitJSDestructuringProperty(JSDestructuringProperty destructuringProperty) {
        if (destructuringProperty.isRest()) {
            this.validateNoCommaAfter((PsiElement)destructuringProperty, JSTokenTypes.RBRACE);
        }
    }

    public void visitJSDestructuringElement(JSDestructuringElement destructuringElement) {
        JSDestructuringContainer target = destructuringElement.getTarget();
        if (target == null) {
            return;
        }
        this.checkElementInCurrentLanguageLevel((PsiElement)target, JSLanguageFeature.DESTRUCTURING_ASSIGNMENT);
        PsiElement parent = destructuringElement.getParent();
        if (!(!(parent instanceof JSVarStatement) || parent.getParent() instanceof JSForInStatement || parent.getParent() instanceof JSExpression || destructuringElement.hasInitializer() || PsiTreeUtil.hasErrorElements((PsiElement)target))) {
            this.myProblemReporter.registerProblem((PsiElement)target, null, JavaScriptBundle.message((String)"javascript.validation.destructuring.without.initializer", (Object[])new Object[0]), ProblemHighlightType.GENERIC_ERROR, null, LocalQuickFix.EMPTY_ARRAY, IntentionAction.EMPTY_ARRAY);
        }
    }

    public void visitJSExpressionStatement(JSExpressionStatement node) {
        PsiElement prevSibling = node.getPrevSibling();
        if (prevSibling instanceof PsiWhiteSpace) {
            prevSibling = prevSibling.getPrevSibling();
        }
        if (prevSibling instanceof JSSourceElement) {
            JSFunction function2;
            PsiElement prev = PsiTreeUtil.prevLeaf((PsiElement)node);
            if (prev instanceof PsiWhiteSpace) {
                prev = PsiTreeUtil.prevLeaf((PsiElement)prev);
            }
            if (prev instanceof PsiErrorElement && (function2 = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)prev, JSFunction.class)) != null && function2.getBlock() == null) {
                this.checkElementInCurrentLanguageLevel((PsiElement)node, JSLanguageFeature.EXPRESSION_CLOSURES);
            }
        }
        super.visitJSExpressionStatement(node);
    }

    public void visitJSGeneratorExpression(JSGeneratorExpression generatorExpression) {
        this.checkElementInCurrentLanguageLevel((PsiElement)generatorExpression, JSLanguageFeature.GENERATOR_EXPRESSIONS);
    }

    public void visitJSReferenceExpression(JSReferenceExpression node) {
        JSSemanticHighlightingUtil.highlight((JSPsiReferenceElement)node, this.myHighlighter, this.myHolder);
        PsiElement parent = node.getParent();
        boolean doCheckForReferencingUnallowedMembers = false;
        if (parent instanceof JSNamedElement) {
            JSNamedElement namedElement = (JSNamedElement)parent;
            PsiElement nameIdentifier = namedElement.getNameIdentifier();
            if (nameIdentifier != node && parent instanceof JSDefinitionExpression) {
                doCheckForReferencingUnallowedMembers = true;
            }
        } else {
            doCheckForReferencingUnallowedMembers = true;
        }
        if (doCheckForReferencingUnallowedMembers) {
            String referencedName = node.getReferenceName();
            PsiElement referenceNameElement = node.getReferenceNameElement();
            assert (referencedName == null || referenceNameElement != null) : referencedName;
            if (("caller".equals(referencedName) || "callee".equals(referencedName)) && JSResolveUtil.isEcmaScript5((PsiElement)node)) {
                PsiElement resolve;
                JSExpression qualifier = node.getQualifier();
                if (qualifier instanceof JSReferenceExpression && ((resolve = ((JSReferenceExpression)qualifier).resolve()) instanceof ImplicitJSVariableImpl || resolve instanceof JSFunction)) {
                    this.myProblemReporter.registerGenericError(referenceNameElement, JavaScriptBundle.message((String)"javascript.validation.message.referencing.arguments.caller.callee.is.not.allowed", (Object[])new Object[0]), new IntentionAction[0]);
                }
            } else if ("arguments".equals(referencedName) && JSResolveUtil.isEcmaScript5((PsiElement)node)) {
                if (node.getQualifier() != null) {
                    JSType type = JSResolveUtil.getExpressionJSType(node.getQualifier());
                    if (!(type == null || type instanceof JSAnyType || type instanceof JSUnionType && ((JSUnionType)type).isAnyType())) {
                        if (JSTypeUtils.hasFunctionType(type, false, (PsiElement)node)) {
                            this.myProblemReporter.registerProblem(referenceNameElement, null, JavaScriptBundle.message((String)"javascript.validation.message.referencing.function.arguments.property.is.not.allowed", (Object[])new Object[0]), null, null, LocalQuickFix.EMPTY_ARRAY, IntentionAction.EMPTY_ARRAY);
                        } else if (!type.getSource().isStrict()) {
                            this.myProblemReporter.registerProblem(referenceNameElement, null, JavaScriptBundle.message((String)"javascript.validation.message.referencing.function.arguments.property.is.not.allowed", (Object[])new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, null, LocalQuickFix.EMPTY_ARRAY, IntentionAction.EMPTY_ARRAY);
                        }
                    }
                } else if (parent instanceof JSDefinitionExpression) {
                    this.myProblemReporter.registerGenericError((PsiElement)node, JavaScriptBundle.message((String)"javascript.validation.message.arguments.is.readonly", (Object[])new Object[0]), new IntentionAction[0]);
                }
            } else if (EVAL_FUNCTION_NAME.equals(referencedName) && node.getQualifier() == null && JSResolveUtil.isEcmaScript5((PsiElement)node)) {
                if (!JSAnnotatingVisitor.isEvalAllowed(node)) {
                    this.myProblemReporter.registerGenericError(referenceNameElement, JavaScriptBundle.message((String)"javascript.validation.message.eval.cannot.be.assigned", (Object[])new Object[0]), new IntentionAction[0]);
                }
            } else if (referenceNameElement != null && JSKeywordSets.JS_STRICT_KEYWORDS.contains(referenceNameElement.getNode().getElementType()) && JSResolveUtil.isEcmaScript5((PsiElement)node)) {
                this.myProblemReporter.registerGenericError(referenceNameElement, JavaScriptBundle.message((String)"javascript.validation.message.identifier.not.allowed.in.strict.mode", (Object[])new Object[]{node.getReferenceName()}), new IntentionAction[0]);
            }
        }
    }

    protected void checkSetterReturnType(@NotNull JSFunction function2) {
        JSType type;
        if (function2 == null) {
            JSAnnotatingVisitor.$$$reportNull$$$0(16);
        }
        if ((type = function2.getReturnType()) != null && !(type instanceof JSVoidType) && !(type instanceof JSUnknownType)) {
            PsiElement returnTypeElement = function2.getReturnTypeElement();
            PsiElement nameIdentifier = returnTypeElement != null ? returnTypeElement : JSAnnotatingVisitor.getPlaceForNamedElementProblem((PsiNameIdentifierOwner)function2);
            this.myProblemReporter.registerProblem(nameIdentifier, null, JavaScriptBundle.message((String)"javascript.validation.message.set.method.should.be.void.or.without.type", (Object[])new Object[0]), this.getHighlightTypeForTypeOrSignatureProblem((PsiElement)function2), null, LocalQuickFix.EMPTY_ARRAY, IntentionAction.EMPTY_ARRAY);
        }
    }

    protected void validateSetter(@NotNull JSFunction setter, @NotNull JSFunction getter, JSParameterListElement param, JSType setterType, JSType retType) {
        if (setter == null) {
            JSAnnotatingVisitor.$$$reportNull$$$0(17);
        }
        if (getter == null) {
            JSAnnotatingVisitor.$$$reportNull$$$0(18);
        }
    }

    protected void validateGetter(@NotNull JSFunction getter, @Nullable JSFunction setter, JSType type) {
        if (getter == null) {
            JSAnnotatingVisitor.$$$reportNull$$$0(19);
        }
    }

    private static boolean isEvalAllowed(@NotNull JSReferenceExpression node) {
        if (node == null) {
            JSAnnotatingVisitor.$$$reportNull$$$0(20);
        }
        return JSReadWriteAccessDetector.ourInstance.getExpressionAccess((PsiElement)node) == ReadWriteAccessDetector.Access.Read;
    }

    protected static boolean isBindable(JSClass clazz) {
        if (clazz instanceof XmlBackedJSClass) {
            return true;
        }
        JSAttributeList attributeList = clazz.getAttributeList();
        return attributeList != null && attributeList.getAttributesByName("Bindable").length > 0;
    }

    protected void checkAccessorAccessTypeMatch(@NotNull JSFunction function2, @NotNull JSFunction getter, String s) {
        if (function2 == null) {
            JSAnnotatingVisitor.$$$reportNull$$$0(21);
        }
        if (getter == null) {
            JSAnnotatingVisitor.$$$reportNull$$$0(22);
        }
        JSAttributeList getterAttrList = getter.getAttributeList();
        JSAttributeList attributeList = function2.getAttributeList();
        if (JSAnnotatingVisitor.differentAccessType(attributeList, getterAttrList)) {
            PsiElement typeElement = attributeList != null ? attributeList.findAccessTypeElement() : null;
            JSAttributeList.AccessType getterAccessType = getterAttrList != null ? getterAttrList.getAccessType() : JSAttributeList.AccessType.PACKAGE_LOCAL;
            JSAttributeList.AccessType attributeListAccessType = attributeList != null ? attributeList.getAccessType() : JSAttributeList.AccessType.PACKAGE_LOCAL;
            this.myProblemReporter.registerGenericError(typeElement != null ? typeElement : function2.getNameIdentifier(), JavaScriptBundle.message((String)s, (Object[])new Object[]{JSFormatUtil.formatVisibility(getterAccessType)}), new IntentionAction[]{JSFixFactory.getInstance().createChangeVisibilityFix((JSAttributeListOwner)function2, getterAccessType, null), JSFixFactory.getInstance().createChangeVisibilityFix((JSAttributeListOwner)getter, attributeListAccessType, null)});
        }
    }

    private static boolean differentAccessType(@Nullable JSAttributeList attributeList, @Nullable JSAttributeList setterAttrList) {
        if (attributeList != null && setterAttrList != null) {
            JSAttributeList.AccessType setterAccessType;
            JSAttributeList.AccessType accessType = attributeList.getAccessType();
            if (accessType != (setterAccessType = setterAttrList.getAccessType())) {
                return (accessType != JSAttributeList.AccessType.PACKAGE_LOCAL || attributeList.getNamespaceElement() == null) && (setterAccessType != JSAttributeList.AccessType.PACKAGE_LOCAL || setterAttrList.getNamespaceElement() == null);
            }
            return false;
        }
        return attributeList != setterAttrList;
    }

    public void visitJSSwitchStatement(JSSwitchStatement node) {
        boolean encounteredDefault = false;
        for (JSCaseClause clause : node.getCaseClauses()) {
            if (!clause.isDefault()) continue;
            if (encounteredDefault) {
                this.reportNotAllowedElementErrorWithRemoveFix((PsiElement)clause, "javascript.validation.message.only.one.default.is.allowed", "javascript.fix.remove.default");
            }
            encounteredDefault = true;
        }
    }

    public void visitJSParameter(JSParameter node) {
        super.visitJSParameter(node);
        if (!node.isOptional()) {
            return;
        }
        JSExpression initializer = node.getInitializer();
        if (initializer == null) {
            return;
        }
        ASTNode questionMark = node.getNode().findChildByType(JSTokenTypes.QUEST);
        if (questionMark == null) {
            return;
        }
        Pair<ASTNode, ASTNode> initializerNodes = JSAnnotatingVisitor.getNodesBefore((PsiElement)initializer, JSTokenTypes.EQ);
        this.myProblemReporter.registerGenericError((PsiElement)node, JavaScriptBundle.message((String)"typescript.validate.optional.parameter.inspection.error", (Object[])new Object[0]), new IntentionAction[]{JSFixFactory.getInstance().removeASTNodeFix("javascript.fix.remove.initializer", false, ((ASTNode)initializerNodes.first).getPsi(), ((ASTNode)initializerNodes.second).getPsi()), JSFixFactory.getInstance().removeASTNodeFix("typescript.validate.optional.parameter.inspection.fix.question", questionMark.getPsi())});
    }

    public void visitJSParameterList(JSParameterList node) {
        JSParameterListElement restParameter = null;
        boolean initializerPresent = false;
        for (JSParameterListElement parameter : node.getParameters()) {
            boolean hasInitializer;
            JSExpression initializer = parameter.getInitializer();
            boolean bl = hasInitializer = initializer != null;
            if (hasInitializer && !initializerPresent) {
                initializerPresent = true;
            }
            if (!hasInitializer && initializerPresent && this.needsInitializer(parameter)) {
                this.myProblemReporter.registerGenericError((PsiElement)parameter, JavaScriptBundle.message((String)"javascript.validation.message.parameter.should.be.initialized", (Object[])new Object[0]), new IntentionAction[]{JSFixFactory.getInstance().createInitializeParameterFix(parameter, JSTypeUtils.defaultValueOfType(parameter.getJSType())), JSFixFactory.getInstance().removeASTNodeFix("javascript.fix.remove.parameter", (PsiElement)parameter)});
            } else if (hasInitializer && parameter.isRest()) {
                Pair<ASTNode, ASTNode> nodesBefore = JSAnnotatingVisitor.getNodesBefore((PsiElement)initializer, JSTokenTypes.EQ);
                this.myProblemReporter.registerGenericError((PsiElement)parameter, JavaScriptBundle.message((String)"javascript.validation.message.rest.parameter.should.not.be.initialized", (Object[])new Object[0]), new IntentionAction[]{JSFixFactory.getInstance().removeASTNodeFix("javascript.fix.remove.initializer", false, ((ASTNode)nodesBefore.first).getPsi(), ((ASTNode)nodesBefore.second).getPsi())});
            }
            if (parameter.isRest() && restParameter == null) {
                restParameter = parameter;
                this.validateRestParameterType(parameter);
                continue;
            }
            if (restParameter == null) continue;
            this.reportNotAllowedElementErrorWithRemoveFix((PsiElement)parameter, "javascript.validation.message.parameter.is.not.allowed.after.rest.parameter", "javascript.fix.remove.parameter");
        }
        if (restParameter != null) {
            this.validateNoCommaAfter((PsiElement)restParameter, JSTokenTypes.RPAR);
        }
    }

    private void validateNoCommaAfter(@NotNull PsiElement element, @NotNull IElementType reportBefore) {
        PsiElement nextAfterRest;
        if (element == null) {
            JSAnnotatingVisitor.$$$reportNull$$$0(23);
        }
        if (reportBefore == null) {
            JSAnnotatingVisitor.$$$reportNull$$$0(24);
        }
        if ((nextAfterRest = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)element)) != null && PsiUtilCore.getElementType((PsiElement)nextAfterRest) == JSTokenTypes.COMMA) {
            IElementType nextElementType;
            PsiElement overOne = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)nextAfterRest);
            if (overOne != null && (nextElementType = PsiUtilCore.getElementType((PsiElement)overOne)) != reportBefore && nextElementType != JSTokenTypes.COMMA) {
                return;
            }
            this.reportNotAllowedElementErrorWithRemoveFix(nextAfterRest, "javascript.validation.message.comma.is.not.allowed.after.rest.element", "javascript.fix.remove.comma");
        }
    }

    protected void reportNotAllowedElementErrorWithRemoveFix(@NotNull PsiElement elementToReport, @PropertyKey(resourceBundle="messages.JavaScriptBundle") String errorMessageId, @PropertyKey(resourceBundle="messages.JavaScriptBundle") String quickFixMessageId) {
        if (elementToReport == null) {
            JSAnnotatingVisitor.$$$reportNull$$$0(25);
        }
        this.myProblemReporter.registerGenericError(elementToReport, JavaScriptBundle.message((String)errorMessageId, (Object[])new Object[0]), new IntentionAction[]{JSFixFactory.getInstance().removeASTNodeFix(quickFixMessageId, elementToReport)});
    }

    public void visitJSClass(JSClass aClass) {
        if (JSClassUtils.isES6ClassImplementation((PsiElement)aClass) && !(aClass instanceof JSClassExpression)) {
            this.checkDuplicates((JSPsiNamedElementBase)aClass);
        }
        this.checkElementInCurrentLanguageLevel(JSAnnotatingVisitor.getPlaceForNamedElementProblem((PsiNameIdentifierOwner)aClass), JSLanguageFeature.CLASSES);
        JSReferenceList list2 = aClass.getImplementsList();
        if (list2 != null && !DialectDetector.hasFeature((PsiElement)aClass, JSLanguageFeature.TYPES)) {
            this.myProblemReporter.registerProblem(list2.getFirstChild(), null, JavaScriptBundle.message((String)"javascript.validation.message.implements.is.not.allowed", (Object[])new Object[0]), ProblemHighlightType.GENERIC_ERROR, null, LocalQuickFix.EMPTY_ARRAY, new IntentionAction[]{new ChangeLanguageLevelFix(JSLanguageLevel.FLOW)});
        }
    }

    protected boolean needsInitializer(JSParameterListElement parameter) {
        return false;
    }

    protected void validateRestParameterType(JSParameterListElement parameter) {
    }

    protected static Pair<ASTNode, ASTNode> getNodesBefore(PsiElement initializer, IElementType eq) {
        ASTNode end;
        ASTNode start = end = initializer.getNode();
        PsiElement element = initializer.getPrevSibling();
        if (element instanceof PsiWhiteSpace) {
            element = element.getPrevSibling();
        }
        if (element != null && element.getNode().getElementType() == eq) {
            start = element.getNode();
        }
        return Pair.create((Object)start, (Object)end);
    }

    public void visitJSAssignmentExpression(JSAssignmentExpression expression) {
        JSExpression lExpr = expression.getLOperand();
        if (lExpr == null) {
            return;
        }
        if (lExpr instanceof JSDefinitionExpression) {
            lExpr = ((JSDefinitionExpression)lExpr).getExpression();
        }
        if (lExpr == null) {
            return;
        }
        this.checkLhs(lExpr, "assignment expression");
    }

    private void checkLhs(JSExpression lExpr, @NotNull String contextTerm) {
        if (contextTerm == null) {
            JSAnnotatingVisitor.$$$reportNull$$$0(26);
        }
        if (!JSValidateExpressionUtil.isLHSExpression(lExpr)) {
            this.myProblemReporter.registerGenericError((PsiElement)lExpr, JavaScriptBundle.message((String)"javascript.validation.message.must.be.lvalue", (Object[])new Object[]{contextTerm}), new IntentionAction[0]);
        }
    }

    public void visitJSTryStatement(JSTryStatement node) {
        JSCatchBlock[] blocks = node.getAllCatchBlocks();
        if (blocks.length > 1) {
            THashSet typeToCatch = new THashSet();
            for (JSCatchBlock block : blocks) {
                String typeText;
                JSParameter p = block.getParameter();
                if (p == null) continue;
                JSType parameterType = p.getJSType();
                String string = typeText = parameterType == null ? "" : parameterType.getTypeText(JSType.TypeTextFormat.SIMPLE);
                if (typeToCatch.contains(typeText)) {
                    LocalQuickFixAndIntentionActionOnPsiElement fix = JSFixFactory.getInstance().removeASTNodeFix("javascript.validation.message.duplicate.catch.block.fix", true, (PsiElement)block, (PsiElement)block);
                    this.myProblemReporter.registerGenericError((PsiElement)block, JavaScriptBundle.message((String)"javascript.validation.message.duplicate.catch.block", (Object[])new Object[0]), new IntentionAction[]{fix});
                    continue;
                }
                typeToCatch.add(typeText);
            }
        } else if (blocks.length == 0 && node.getFinallyStatement() == null && node.getVarDeclaration() == null && node.getResourceExpression() == null) {
            PsiElement place = PsiTreeUtil.lastChild((PsiElement)node);
            this.myProblemReporter.registerGenericError(place, JavaScriptBundle.message((String)"javascript.validation.message.missing.catch.or.finally", (Object[])new Object[0]), new IntentionAction[0]);
        }
    }

    public void visitJSVariable(@NotNull JSVariable var) {
        PsiElement nameIdentifier;
        if (var == null) {
            JSAnnotatingVisitor.$$$reportNull$$$0(27);
        }
        if (var.getNode() != null && var.getNode().findChildByType(JSKeywordSets.JS_STRICT_KEYWORDS) != null && JSResolveUtil.isEcmaScript5((PsiElement)var) && (nameIdentifier = var.getNameIdentifier()) != null) {
            String message = JavaScriptBundle.message((String)"javascript.validation.message.identifier.not.allowed.in.strict.mode", (Object[])new Object[]{var.getName()});
            this.myProblemReporter.registerGenericError(nameIdentifier, message, new IntentionAction[0]);
        }
        if (var.isConst() && !var.hasInitializer() && this.isConstNeedInitializer(var)) {
            JSVarStatement statement;
            boolean reportError;
            JSAttributeList attributeList = var.getAttributeList();
            boolean bl = reportError = attributeList == null || attributeList.getAttributesByName("Embed").length == 0;
            if (reportError && PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)var) instanceof OuterLanguageElement) {
                reportError = false;
            }
            if (reportError && (statement = var.getStatement()) != null && PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)statement) instanceof OuterLanguageElement) {
                reportError = false;
            }
            if (reportError) {
                if (DialectDetector.isES6((PsiElement)var)) {
                    this.myProblemReporter.registerGenericError((PsiElement)var, JavaScriptBundle.message((String)"es6.validation.message.const.variable.without.initializer", (Object[])new Object[0]), new IntentionAction[0]);
                } else if (!DialectDetector.isTypeScript((PsiElement)var) || !TypeScriptPsiUtil.isAmbientDeclaration((PsiElement)var)) {
                    this.myProblemReporter.registerProblem((PsiElement)var, null, JavaScriptBundle.message((String)"javascript.validation.message.const.variable.without.initializer", (Object[])new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, null, LocalQuickFix.EMPTY_ARRAY, IntentionAction.EMPTY_ARRAY);
                }
            }
        }
        this.checkForbiddenNameRedefining((JSNamedElement)var);
        if (var instanceof JSField) {
            this.visitField((JSField)var);
        }
        if (var.getJSType() instanceof JSVoidType && !DialectDetector.isTypeScript((PsiElement)var)) {
            PsiElement typeElement = var.getTypeElement();
            PsiElement nameIdentifier2 = typeElement != null ? typeElement : var;
            this.myProblemReporter.registerProblem(nameIdentifier2, null, JavaScriptBundle.message((String)"javascript.illegal.variable.type.void", (Object[])new Object[0]), this.getHighlightTypeForTypeOrSignatureProblem((PsiElement)var), null, LocalQuickFix.EMPTY_ARRAY, IntentionAction.EMPTY_ARRAY);
        }
        DuplicatesCheckUtil.JSDuplicatesCheckError error = DuplicatesCheckUtil.checkDuplicatesForVariable(var);
        this.reportDuplicateError((PsiElement)var, error);
    }

    private void visitField(@NotNull JSField var) {
        if (var == null) {
            JSAnnotatingVisitor.$$$reportNull$$$0(28);
        }
        if (JSClassUtils.isES6ClassImplementation((PsiElement)var) && StringUtil.equals((CharSequence)var.getName(), (CharSequence)"constructor") && !JSPsiImplUtils.hasModifier((JSAttributeListOwner)var, JSAttributeList.ModifierType.STATIC)) {
            JSClass containingClass = JSUtils.getMemberContainingClass((PsiElement)var);
            if (containingClass instanceof TypeScriptEnum || containingClass instanceof TypeScriptInterface || containingClass instanceof TypeScriptTypeAlias) {
                return;
            }
            PsiElement identifier = var.getNameIdentifier();
            if (identifier != null) {
                this.myProblemReporter.registerGenericError(identifier, JavaScriptBundle.message((String)"javascript.validation.message.constructor.field.not.allowed", (Object[])new Object[0]), new IntentionAction[0]);
            }
        }
    }

    protected boolean isConstNeedInitializer(JSVariable var) {
        return !JSUtils.isMember((PsiElement)var);
    }

    public void visitJSContinueStatement(JSContinueStatement node) {
        super.visitJSContinueStatement(node);
        if (node.getStatementToContinue() == null) {
            this.myProblemReporter.registerGenericError((PsiElement)node, JavaScriptBundle.message((String)"javascript.validation.message.continue.without.target", (Object[])new Object[0]), new IntentionAction[0]);
        }
        if (!(PsiTreeUtil.getParentOfType((PsiElement)node, (Class[])new Class[]{JSExecutionScope.class, JSLoopStatement.class}) instanceof JSLoopStatement)) {
            this.myProblemReporter.registerGenericError((PsiElement)node, JavaScriptBundle.message((String)"javascript.validation.message.continue.outside.loop", (Object[])new Object[0]), new IntentionAction[0]);
        }
    }

    public void visitJSBreakStatement(JSBreakStatement node) {
        super.visitJSBreakStatement(node);
        if (node.getStatementToBreak() == null) {
            this.myProblemReporter.registerGenericError((PsiElement)node, JavaScriptBundle.message((String)"javascript.validation.message.break.without.target", (Object[])new Object[0]), new IntentionAction[0]);
        }
    }

    public void visitJSStatementWithLabelReference(JSStatementWithLabelReference statementWithLabelReference) {
        JSSemanticHighlightingUtil.highlight(statementWithLabelReference, this.myHighlighter, this.myHolder);
    }

    protected void checkGetterAndSetter(@NotNull JSFunction function2) {
        PsiElement nameIdentifier;
        if (function2 == null) {
            JSAnnotatingVisitor.$$$reportNull$$$0(29);
        }
        if ((nameIdentifier = function2.getNameIdentifier()) == null) {
            return;
        }
        if (function2.isSetProperty()) {
            JSParameterListElement[] params;
            this.checkSetterReturnType(function2);
            JSParameterList parameterList = function2.getParameterList();
            JSParameterListElement[] jSParameterListElementArray = params = parameterList != null ? parameterList.getParameters() : JSParameterListElement.EMPTY_ARRAY;
            if (params.length != 1) {
                this.myProblemReporter.registerGenericError((PsiElement)(parameterList != null ? parameterList : nameIdentifier), JavaScriptBundle.message((String)"javascript.validation.message.set.method.should.have.one.parameter", (Object[])new Object[0]), new IntentionAction[0]);
            } else {
                JSFunction getter;
                PsiElement element = JSResolveUtil.findParent((PsiElement)function2);
                if (element instanceof JSClass && !JSAnnotatingVisitor.isBindable((JSClass)element) && (getter = ((JSClass)element).findFunctionByNameAndKind(function2.getName(), JSFunction.FunctionKind.GETTER)) != null) {
                    JSType retType = getter.getReturnType();
                    JSType setterType = params[0].getJSType();
                    this.validateSetter(function2, getter, params[0], setterType, retType);
                }
                if (params[0].hasInitializer()) {
                    JSExpression inititializer = params[0].getInitializer();
                    ASTNode first = params[0].getNode().findChildByType(JSTokenTypes.EQ);
                    if (first != null && inititializer != null) {
                        LocalQuickFixAndIntentionActionOnPsiElement fix = JSFixFactory.getInstance().removeASTNodeFix("javascript.fix.remove.setter.parameter.initializer", false, first.getPsi(), (PsiElement)inititializer);
                        this.myProblemReporter.registerGenericError((PsiElement)inititializer, JavaScriptBundle.message((String)"javascript.validation.message.setter.parameter.cannot.have.initializer", (Object[])new Object[0]), new IntentionAction[]{fix});
                    }
                }
            }
        } else if (function2.isGetProperty()) {
            JSParameterListElement[] parameters;
            JSType type = function2.getReturnType();
            PsiElement element = JSResolveUtil.findParent((PsiElement)function2);
            JSFunction setter = element instanceof JSClass && !JSAnnotatingVisitor.isBindable((JSClass)element) ? ((JSClass)element).findFunctionByNameAndKind(function2.getName(), JSFunction.FunctionKind.SETTER) : null;
            this.validateGetter(function2, setter, type);
            JSParameterList parameterList = function2.getParameterList();
            if (parameterList != null && (parameters = parameterList.getParameters()).length != 0) {
                String key = parameters.length > 1 ? "javascript.fix.remove.parameters" : "javascript.fix.remove.parameter";
                LocalQuickFixAndIntentionActionOnPsiElement fix = JSFixFactory.getInstance().removeASTNodeFix(key, false, (PsiElement)parameters[0], (PsiElement)parameters[parameters.length - 1]);
                this.myProblemReporter.registerGenericError((PsiElement)parameterList, JavaScriptBundle.message((String)"javascript.validation.message.get.method.should.have.no.parameter", (Object[])new Object[0]), new IntentionAction[]{fix});
            }
        }
        if (JSPsiImplUtils.isGetterOrSetter((JSFunctionItem)function2) && !(function2.getParent() instanceof JSProperty) && !(function2 instanceof JSFunctionProperty) && PsiTreeUtil.getParentOfType((PsiElement)function2, JSFunction.class, (boolean)true, (Class[])new Class[]{JSClass.class}) != null) {
            this.myProblemReporter.registerGenericError(nameIdentifier, JavaScriptBundle.message((String)"javascript.validation.message.accessor.could.not.be.nested.under.other.function", (Object[])new Object[0]), new IntentionAction[0]);
        }
    }

    public void visitJSProperty(@NotNull JSProperty node) {
        if (node == null) {
            JSAnnotatingVisitor.$$$reportNull$$$0(30);
        }
        this.checkReferences((PsiElement)node);
        JSExpression value = node.getValue();
        if (!JSDestructuringUtil.parentIsDestructuringAssignmentLHS(value)) {
            this.checkDuplicates((JSPsiNamedElementBase)node);
        }
        if (node instanceof ES6Property) {
            ES6ComputedName propertyName;
            if (((ES6Property)node).isShorthanded()) {
                this.checkElementInCurrentLanguageLevel((PsiElement)node, JSLanguageFeature.SHORTHAND_PROPERTY_NAMES);
            }
            if ((propertyName = ((ES6Property)node).getComputedPropertyName()) != null) {
                this.checkElementInCurrentLanguageLevel((PsiElement)propertyName, JSLanguageFeature.COMPUTED_PROPERTY_NAMES);
            }
        }
    }

    public void visitJSReturnStatement(@NotNull JSReturnStatement node) {
        PsiElement element;
        if (node == null) {
            JSAnnotatingVisitor.$$$reportNull$$$0(31);
        }
        if ((element = PsiTreeUtil.getParentOfType((PsiElement)node, (Class[])new Class[]{JSFunction.class, XmlTagChild.class, XmlAttributeValue.class, JSFile.class})) instanceof JSFile && !(element.getContext() instanceof PsiLanguageInjectionHost) && !((JSFile)element).isCommonJSModule() || element instanceof XmlTagChild && !(element.getParent() instanceof XmlAttributeValue)) {
            this.myProblemReporter.registerProblem((PsiElement)node, null, JavaScriptBundle.message((String)"javascript.validation.message.return.outside.function.definition", (Object[])new Object[0]), null, null, LocalQuickFix.EMPTY_ARRAY, IntentionAction.EMPTY_ARRAY);
        }
    }

    public void visitJSLabeledStatement(JSLabeledStatement node) {
        String label = node.getLabel();
        if (label != null) {
            JSSemanticHighlightingUtil.highlight(node, this.myHighlighter, this.myHolder);
            for (PsiElement run = node.getParent(); run != null; run = run.getParent()) {
                if (run instanceof JSLabeledStatement && label.equals(((JSLabeledStatement)run).getLabel())) {
                    this.myProblemReporter.registerGenericError(node.getLabelIdentifier(), JavaScriptBundle.message((String)"javascript.validation.message.duplicate.label", (Object[])new Object[0]), new IntentionAction[0]);
                    break;
                }
                if (run instanceof JSFunction) break;
            }
        }
    }

    public void visitJSWithStatement(JSWithStatement node) {
        if (JSResolveUtil.isEcmaScript5((PsiElement)node)) {
            this.myProblemReporter.registerGenericError(node.getFirstChild(), JavaScriptBundle.message((String)"javascript.with.statement.is.not.allowed.in.strict.mode.message", (Object[])new Object[0]), new IntentionAction[0]);
        }
    }

    public void visitJSPostfixExpression(JSPostfixExpression node) {
        this.checkLhs(node.getExpression(), "postfix expression");
    }

    public void visitJSPrefixExpression(JSPrefixExpression node) {
        JSBinaryExpression binaryExpression;
        PsiElement parent;
        PsiElement resolve;
        IElementType operationSign;
        JSExpression expression = node.getExpression();
        if (expression != null && JSReadWriteAccessDetector.ourInstance.getExpressionAccess((PsiElement)expression) == ReadWriteAccessDetector.Access.ReadWrite) {
            this.checkLhs(expression, "prefix expression");
        }
        if ((operationSign = node.getOperationSign()) == JSTokenTypes.DELETE_KEYWORD && expression instanceof JSReferenceExpression && JSAnnotatingVisitor.isInvalidDeleteTarget(resolve = ((JSReferenceExpression)expression).resolve())) {
            String message = JavaScriptBundle.message((String)"javascript.invalid.delete.target.message", (Object[])new Object[0]);
            if (node.getContainingFile().getLanguage().isKindOf((Language)JavaScriptSupportLoader.ECMA_SCRIPT_L4) || JSResolveUtil.isEcmaScript5((PsiElement)expression)) {
                this.myProblemReporter.registerProblem((PsiElement)expression, null, message, ProblemHighlightType.ERROR, null, LocalQuickFix.EMPTY_ARRAY, IntentionAction.EMPTY_ARRAY);
            } else {
                this.myProblemReporter.registerProblem((PsiElement)expression, null, message, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, null, LocalQuickFix.EMPTY_ARRAY, IntentionAction.EMPTY_ARRAY);
            }
        }
        if (operationSign != JSTokenTypes.PLUSPLUS & operationSign != JSTokenTypes.MINUSMINUS && (parent = node.getParent()) instanceof JSBinaryExpression && (binaryExpression = (JSBinaryExpression)parent).getOperationSign() == JSTokenTypes.MULTMULT && binaryExpression.getLOperand() == node) {
            ASTNode operationNode = node.getOperationNode();
            if (operationNode == null) {
                Logger.getInstance(JSAnnotatingVisitor.class).error("Node is null, sign is not", new Attachment[]{new Attachment("unaryExpression.txt", node.getText())});
                return;
            }
            String message = JavaScriptBundle.message((String)"js.annotator.unary.operator.within.exponential", (Object[])new Object[]{operationNode.getText()});
            this.myProblemReporter.registerGenericError((PsiElement)node, message, new IntentionAction[0]);
        }
    }

    private static boolean isInvalidDeleteTarget(@Nullable PsiElement resolve) {
        if (resolve instanceof JSParameter) {
            return !TypeScriptPsiUtil.isFieldParameter((JSParameter)resolve);
        }
        if (resolve instanceof JSFunction) {
            return !(JSResolveUtil.findParent(resolve) instanceof JSClass) && !(resolve.getContext() instanceof JSObjectLiteralExpression);
        }
        if (resolve instanceof JSField) {
            return false;
        }
        return resolve instanceof JSVariable;
    }

    public void visitJSForInStatement(JSForInStatement node) {
        JSExpression expression;
        JSVarStatement statement;
        ASTNode ofKeyword = node.getNode().findChildByType(JSTokenTypes.OF_KEYWORD);
        if (ofKeyword != null) {
            this.checkElementInCurrentLanguageLevel(ofKeyword.getPsi(), JSLanguageFeature.FOR_OF);
        }
        if ((statement = node.getVarDeclaration()) != null) {
            JSExpression initializer;
            JSInitializerOwner[] variables = statement.getDeclarations();
            if (variables.length > 1) {
                this.myProblemReporter.registerGenericError((PsiElement)variables[1], JavaScriptBundle.message((String)"javascript.validation.multiple.var.in.for.loop", (Object[])new Object[]{ofKeyword != null ? "for-of" : "for-in"}), new IntentionAction[0]);
            } else if (variables.length == 1 && (initializer = variables[0].getInitializer()) != null) {
                this.myProblemReporter.registerGenericError((PsiElement)initializer, JavaScriptBundle.message((String)"javascript.validation.initialized.var.in.for.loop", (Object[])new Object[]{ofKeyword != null ? "for-of" : "for-in"}), new IntentionAction[0]);
            }
        }
        if ((expression = node.getVariableExpression()) != null) {
            this.checkLhs(expression, "for loop");
        }
    }

    public void visitES6ImportDeclaration(ES6ImportDeclaration importDeclaration) {
        this.checkElementInCurrentLanguageLevel((PsiElement)importDeclaration, JSLanguageFeature.IMPORT_DECLARATIONS);
        super.visitES6ImportDeclaration(importDeclaration);
    }

    public void visitES6ExportDeclaration(ES6ExportDeclaration exportDeclaration) {
        this.checkElementInCurrentLanguageLevel((PsiElement)exportDeclaration, JSLanguageFeature.EXPORT_DECLARATIONS);
        super.visitES6ExportDeclaration(exportDeclaration);
    }

    public void visitES6ExportDefaultAssignment(ES6ExportDefaultAssignment node) {
        this.checkElementInCurrentLanguageLevel((PsiElement)node, JSLanguageFeature.EXPORT_DECLARATIONS);
        super.visitES6ExportDefaultAssignment(node);
    }

    public void visitJSAttributeList(JSAttributeList attributeList) {
        ASTNode exportKeyword = attributeList.getNode().findChildByType(JSTokenTypes.EXPORT_KEYWORD);
        if (exportKeyword != null) {
            this.checkElementInCurrentLanguageLevel(exportKeyword.getPsi(), JSLanguageFeature.EXPORT_DECLARATIONS);
        }
        super.visitJSAttributeList(attributeList);
    }

    @NotNull
    public static PsiElement getPlaceForNamedElementProblem(@NotNull PsiNameIdentifierOwner element) {
        IElementType type;
        PsiElement nameIdentifier;
        if (element == null) {
            JSAnnotatingVisitor.$$$reportNull$$$0(32);
        }
        if ((nameIdentifier = element.getNameIdentifier()) != null) {
            ASTNode node = nameIdentifier.getNode();
            ASTNode realIdentifier = node.findChildByType(JSKeywordSets.IDENTIFIER_NAMES);
            if (realIdentifier != null) {
                nameIdentifier = realIdentifier.getPsi();
            }
            PsiElement psiElement = nameIdentifier;
            if (psiElement == null) {
                JSAnnotatingVisitor.$$$reportNull$$$0(33);
            }
            return psiElement;
        }
        PsiElement firstChild = element.getFirstChild();
        if (firstChild instanceof JSAttributeList) {
            firstChild = firstChild.getNextSibling();
        }
        if (firstChild != null && JSKeywordSets.IDENTIFIER_NAMES.contains(type = firstChild.getNode().getElementType())) {
            PsiElement psiElement = firstChild;
            if (psiElement == null) {
                JSAnnotatingVisitor.$$$reportNull$$$0(34);
            }
            return psiElement;
        }
        PsiNameIdentifierOwner psiNameIdentifierOwner = element;
        if (psiNameIdentifierOwner == null) {
            JSAnnotatingVisitor.$$$reportNull$$$0(35);
        }
        return psiNameIdentifierOwner;
    }

    public void visitImportSpecifier(ES6ImportSpecifier node) {
        this.checkDuplicates((JSPsiNamedElementBase)node);
        DialectOptionHolder holder = DialectDetector.dialectOfElement((PsiElement)node);
        if (holder != null && holder.hasFeature(JSLanguageFeature.IMPORT_DECLARATIONS)) {
            JSSemanticHighlightingUtil.highlight((JSPsiReferenceElement)node, this.myHighlighter, this.myHolder);
        }
    }

    public void visitES6ImportedBinding(ES6ImportedBinding importedBinding) {
        super.visitES6ImportedBinding(importedBinding);
        this.checkDuplicates((JSPsiNamedElementBase)importedBinding);
        DialectOptionHolder holder = DialectDetector.dialectOfElement((PsiElement)importedBinding);
        if (holder == null || !holder.hasFeature(JSLanguageFeature.IMPORT_DECLARATIONS)) {
            return;
        }
        Collection referencedElements = importedBinding.findReferencedElements();
        PsiElement resolveResult = (PsiElement)ContainerUtil.getFirstItem((Collection)referencedElements);
        if (resolveResult != null) {
            resolveResult = JSStubBasedPsiTreeUtil.calculateMeaningfulElement(resolveResult);
            JSSemanticHighlightingUtil.highlight((PsiElement)importedBinding, resolveResult, this.myHighlighter, this.myHolder);
        }
    }

    public void visitES6ImportSpecifierAlias(ES6ImportSpecifierAlias specifierAlias) {
        this.checkDuplicates((JSPsiNamedElementBase)specifierAlias);
    }

    public void visitES6ExportSpecifier(ES6ExportSpecifier node) {
        DialectOptionHolder holder = DialectDetector.dialectOfElement((PsiElement)node);
        if (holder != null && holder.hasFeature(JSLanguageFeature.EXPORT_DECLARATIONS)) {
            JSSemanticHighlightingUtil.highlight((JSPsiReferenceElement)node, this.myHighlighter, this.myHolder);
        }
    }

    protected void checkFunctionDeclaration(@NotNull JSFunction function2) {
        if (function2 == null) {
            JSAnnotatingVisitor.$$$reportNull$$$0(36);
        }
        if (function2.isGenerator()) {
            this.checkElementInCurrentLanguageLevel(JSAnnotatingVisitor.getPlaceForNamedElementProblem((PsiNameIdentifierOwner)function2), JSLanguageFeature.YIELD_GENERATORS);
        }
        if (!TypeScriptPsiUtil.isAmbientDeclaration((PsiElement)function2)) {
            this.checkDuplicates((JSPsiNamedElementBase)function2);
        }
        JSSemanticHighlightingUtil.highlight((PsiElement)function2, (PsiElement)function2, this.myHighlighter, this.myHolder);
        this.checkForbiddenNameRedefining((JSNamedElement)function2);
        PsiElement functionParent = JSResolveUtil.findParent((PsiElement)function2);
        if (!(functionParent instanceof JSFile || functionParent instanceof JSEmbeddedContent || functionParent instanceof JSClass || functionParent instanceof TypeScriptModule || functionParent instanceof JSBlockStatement && functionParent.getParent() instanceof JSFunction || DialectDetector.isES6OrES6Target((PsiElement)function2) || !JSResolveUtil.isEcmaScript5((PsiElement)function2))) {
            this.myProblemReporter.registerGenericError(JSAnnotatingVisitor.getPlaceForNamedElementProblem((PsiNameIdentifierOwner)function2), JavaScriptBundle.message((String)"javascript.validation.message.es5.function.declarations.allowed.on.top.level.or.function", (Object[])new Object[0]), new IntentionAction[0]);
        }
        if (function2.isConstructor() && functionParent instanceof JSClass) {
            this.createConstructorChecker().checkConstructor(function2, (JSClass)functionParent);
        }
        this.checkGetterAndSetter(function2);
    }

    private void checkForbiddenNameRedefining(@NotNull JSNamedElement element) {
        String name;
        if (element == null) {
            JSAnnotatingVisitor.$$$reportNull$$$0(37);
        }
        if ((EVAL_FUNCTION_NAME.equals(name = element.getName()) || "arguments".equals(name)) && JSScopeNamesCache.canBeReferencedLocallyWithoutQualifier((JSElement)element) && JSResolveUtil.isEcmaScript5((PsiElement)element)) {
            this.myProblemReporter.registerGenericError(JSAnnotatingVisitor.getPlaceForNamedElementProblem((PsiNameIdentifierOwner)element), JavaScriptBundle.message((String)"javascript.validation.message.redefining.is.not.allowed", (Object[])new Object[]{name}), new IntentionAction[0]);
        }
    }

    public void visitJSFunctionProperty(JSFunctionProperty functionProperty) {
        this.checkGetterAndSetter((JSFunction)functionProperty);
        this.checkDuplicates((JSPsiNamedElementBase)functionProperty);
        JSSemanticHighlightingUtil.highlight((PsiElement)functionProperty, (PsiElement)functionProperty, this.myHighlighter, this.myHolder);
        if (!functionProperty.isGetProperty() && !functionProperty.isSetProperty()) {
            this.checkElementInCurrentLanguageLevel(JSAnnotatingVisitor.getPlaceForNamedElementProblem((PsiNameIdentifierOwner)functionProperty), JSLanguageFeature.METHOD_DEFINITION_SHORTHANDS);
        }
    }

    public void visitJSFunctionExpression(@NotNull JSFunctionExpression node) {
        ASTNode prev;
        ASTNode arrowNode;
        if (node == null) {
            JSAnnotatingVisitor.$$$reportNull$$$0(38);
        }
        this.checkGetterAndSetter((JSFunction)node);
        PsiElement ownNameIdentifier = node.getOwnNameIdentifier();
        if (ownNameIdentifier != null) {
            JSSemanticHighlightingUtil.highlight(ownNameIdentifier, (PsiElement)node, this.myHighlighter, this.myHolder);
        }
        if ((arrowNode = JSPsiImplUtils.getFunctionArrowNode((JSFunction)node)) == null) {
            return;
        }
        this.checkElementInCurrentLanguageLevel(arrowNode.getPsi(), JSLanguageFeature.ARROW_FUNCTIONS);
        if (arrowNode.getElementType() == JSTokenTypes.MINUSGT) {
            ReplaceWithFatArrowFix fix = new ReplaceWithFatArrowFix(arrowNode.getPsi());
            this.myProblemReporter.registerProblem(arrowNode.getPsi(), null, JavaScriptBundle.message((String)"js.annotator.thin.arrow.used", (Object[])new Object[0]), null, null, LocalQuickFix.EMPTY_ARRAY, new IntentionAction[]{fix});
        }
        if ((prev = arrowNode.getTreePrev()) instanceof PsiWhiteSpace && prev.textContains('\n')) {
            this.myProblemReporter.registerProblem(arrowNode.getPsi(), null, JavaScriptBundle.message((String)"js.annotator.newline.before.arrow", (Object[])new Object[0]), null, null, LocalQuickFix.EMPTY_ARRAY, IntentionAction.EMPTY_ARRAY);
        }
    }

    public void visitJSStringTemplateExpression(JSStringTemplateExpression stringTemplateExpression) {
        this.checkElementInCurrentLanguageLevel((PsiElement)stringTemplateExpression, JSLanguageFeature.STRING_TEMPLATES);
    }

    public void visitJSCatchBlock(JSCatchBlock node) {
        if (!node.hasParameter()) {
            this.checkElementInCurrentLanguageLevel((PsiElement)node, JSLanguageFeature.OPTIONAL_CATCH_BINDING);
        }
    }

    public void visitES6AssignmentProperty(ES6AssignmentProperty assignmentProperty) {
        super.visitES6AssignmentProperty(assignmentProperty);
        PsiElement parent = assignmentProperty.getParent();
        boolean isOnLeftSide = false;
        while (parent != null && !(parent instanceof PsiFile)) {
            PsiElement grandParent = parent.getParent();
            if (grandParent instanceof JSAssignmentExpression) {
                isOnLeftSide = ((JSAssignmentExpression)grandParent).getLOperand() == parent;
                break;
            }
            parent = grandParent;
        }
        if (!isOnLeftSide) {
            this.myProblemReporter.registerProblem((PsiElement)assignmentProperty, null, JavaScriptBundle.message((String)"js.annotator.assignment.pattern.rhs", (Object[])new Object[0]), null, null, LocalQuickFix.EMPTY_ARRAY, IntentionAction.EMPTY_ARRAY);
        }
    }

    public void visitES6MetaProperty(@NotNull Es6MetaProperty property) {
        JSFunction containingFunction;
        if (property == null) {
            JSAnnotatingVisitor.$$$reportNull$$$0(39);
        }
        JSSemanticHighlightingUtil.highlight(property, this.myHighlighter, this.myHolder);
        if (property.getKind() == Es6MetaProperty.Kind.NewTarget && ((containingFunction = JSPsiImplUtils.getParentFunctionThroughLambdas((PsiElement)property)) == null || JSUtils.isMember((PsiElement)containingFunction) && !containingFunction.isConstructor())) {
            this.myProblemReporter.registerGenericError((PsiElement)property, JavaScriptBundle.message((String)"javascript.validation.new.target.not.in.function", (Object[])new Object[0]), new IntentionAction[0]);
        }
    }

    protected void checkDuplicates(@NotNull JSPsiNamedElementBase namedElement) {
        if (namedElement == null) {
            JSAnnotatingVisitor.$$$reportNull$$$0(40);
        }
        this.reportDuplicateError((PsiElement)namedElement, DuplicatesCheckUtil.checkDuplicates(namedElement));
    }

    protected void reportDuplicateError(@NotNull PsiElement element, @Nullable DuplicatesCheckUtil.JSDuplicatesCheckError error) {
        IntentionAction[] intentionActionArray;
        PsiElement nameIdentifier;
        if (element == null) {
            JSAnnotatingVisitor.$$$reportNull$$$0(41);
        }
        if (error == null || !error.hasErrorSeverity()) {
            return;
        }
        PsiElement psiElement = nameIdentifier = element instanceof PsiNameIdentifierOwner ? ((PsiNameIdentifierOwner)element).getNameIdentifier() : null;
        if (nameIdentifier == null) {
            nameIdentifier = element;
        }
        if (error.getDuplicatedElement() instanceof JSElement) {
            IntentionAction[] intentionActionArray2 = new IntentionAction[1];
            intentionActionArray = intentionActionArray2;
            intentionActionArray2[0] = new JSNavigateToAlreadyDeclaredVariableFix((JSElement)error.getDuplicatedElement());
        } else {
            intentionActionArray = IntentionAction.EMPTY_ARRAY;
        }
        IntentionAction[] actions = intentionActionArray;
        this.myProblemReporter.registerProblem(nameIdentifier, null, error.getMessage(), ProblemHighlightType.GENERIC_ERROR, null, LocalQuickFix.EMPTY_ARRAY, actions);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 10: 
            case 33: 
            case 34: 
            case 35: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 10: 
            case 33: 
            case 34: 
            case 35: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: 
            case 5: 
            case 23: 
            case 32: 
            case 37: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: 
            case 4: 
            case 20: 
            case 30: 
            case 31: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 9: 
            case 10: 
            case 33: 
            case 34: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/validation/JSAnnotatingVisitor";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementToHighlight";
                break;
            }
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageFeature";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comment";
                break;
            }
            case 16: 
            case 21: 
            case 29: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "setter";
                break;
            }
            case 18: 
            case 19: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "getter";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reportBefore";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementToReport";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextTerm";
                break;
            }
            case 27: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "var";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namedElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/validation/JSAnnotatingVisitor";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getQuickFixesForReferenceProblem";
                break;
            }
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlaceForNamedElementProblem";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "visitElement";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "visitJSLiteralExpression";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getHighlightTypeForTypeOrSignatureProblem";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "checkReferences";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "checkReference";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "registerProblemForReference";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getQuickFixesForReferenceProblem";
                break;
            }
            case 9: 
            case 10: 
            case 33: 
            case 34: 
            case 35: {
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "checkElementInCurrentLanguageLevel";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "visitComment";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "checkSetterReturnType";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "validateSetter";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "validateGetter";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isEvalAllowed";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "checkAccessorAccessTypeMatch";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "validateNoCommaAfter";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "reportNotAllowedElementErrorWithRemoveFix";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "checkLhs";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "visitJSVariable";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "visitField";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "checkGetterAndSetter";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "visitJSProperty";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "visitJSReturnStatement";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getPlaceForNamedElementProblem";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "checkFunctionDeclaration";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "checkForbiddenNameRedefining";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "visitJSFunctionExpression";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "visitES6MetaProperty";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "checkDuplicates";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "reportDuplicateError";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 10: 
            case 33: 
            case 34: 
            case 35: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ReplaceWithFatArrowFix
    extends LocalQuickFixAndIntentionActionOnPsiElement {
        private ReplaceWithFatArrowFix(@Nullable PsiElement element) {
            super(element);
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = JavaScriptBundle.message((String)"js.annotator.replace.with.fat.arrow", (Object[])new Object[0]);
            if (string == null) {
                ReplaceWithFatArrowFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getText() {
            String string = this.getFamilyName();
            if (string == null) {
                ReplaceWithFatArrowFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile file2, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            if (project == null) {
                ReplaceWithFatArrowFix.$$$reportNull$$$0(2);
            }
            if (file2 == null) {
                ReplaceWithFatArrowFix.$$$reportNull$$$0(3);
            }
            if (startElement == null) {
                ReplaceWithFatArrowFix.$$$reportNull$$$0(4);
            }
            if (endElement == null) {
                ReplaceWithFatArrowFix.$$$reportNull$$$0(5);
            }
            startElement.replace(JSChangeUtil.createTokenElement(startElement, JSTokenTypes.EQGT, "=>"));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/validation/JSAnnotatingVisitor$ReplaceWithFatArrowFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "endElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/validation/JSAnnotatingVisitor$ReplaceWithFatArrowFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public class SimpleErrorReportingClient
    implements ErrorReportingClient {
        @Override
        public void reportError(ASTNode nameIdentifier, String s, ErrorReportingClient.ProblemKind kind, IntentionAction ... fixes) {
            if (fixes == null) {
                SimpleErrorReportingClient.$$$reportNull$$$0(0);
            }
            if (kind == ErrorReportingClient.ProblemKind.ERROR) {
                JSAnnotatingVisitor.this.myProblemReporter.registerGenericError(nameIdentifier, s, fixes);
            } else {
                JSAnnotatingVisitor.this.myProblemReporter.registerProblem(nameIdentifier.getPsi(), null, s, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, null, LocalQuickFix.EMPTY_ARRAY, fixes);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fixes", "com/intellij/lang/javascript/validation/JSAnnotatingVisitor$SimpleErrorReportingClient", "reportError"));
        }
    }

    protected static enum SignatureMatchResult {
        PARAMETERS_DIFFERS,
        RETURN_TYPE_DIFFERS,
        FUNCTION_KIND_DIFFERS,
        COMPATIBLE_SIGNATURE;

    }

    public static interface ErrorReportingClient {
        public void reportError(ASTNode var1, String var2, ProblemKind var3, IntentionAction ... var4);

        public static enum ProblemKind {
            ERROR,
            WARNING;

        }
    }
}

