/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.introduceVariable;

import com.intellij.DynamicBundle;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.refactoring.introduce.BasicIntroducedEntityInfoProvider;
import com.intellij.lang.javascript.refactoring.introduce.JSBaseIntroduceDialog;
import com.intellij.lang.javascript.refactoring.introduceVariable.JSIntroduceVariableHandler;
import com.intellij.lang.javascript.refactoring.introduceVariable.Settings;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.ui.NameSuggestionsField;
import com.intellij.ui.EditorComboBox;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class JSIntroduceVariableDialog
extends JSBaseIntroduceDialog<BasicIntroducedEntityInfoProvider>
implements Settings {
    private JCheckBox myReplaceAllCheckBox;
    private NameSuggestionsField myNameField;
    private JPanel myPanel;
    private JRadioButton myLetRadioButton;
    private JRadioButton myConstRadioButton;
    private JRadioButton myVarRadioButton;
    private EditorComboBox myVarType;
    private JLabel myVariableTypeLabel;
    private JLabel myNameLabel;
    private JPanel myKindPanel;
    private JCheckBox myMakeConstant;
    private Settings.IntroducedVarType myIntroducedVarType;
    protected final boolean myEcma;

    protected JSIntroduceVariableDialog(Project project, JSExpression[] occurrences, JSExpression mainOccurrence, PsiElement scope, Settings.IntroducedVarType lastSelected) {
        super(project, new BasicIntroducedEntityInfoProvider(mainOccurrence, occurrences, scope), "javascript.introduce.variable.title");
        boolean selectedSomething = false;
        this.$$$setupUI$$$();
        DialectOptionHolder holder = DialectDetector.dialectOfElement((PsiElement)mainOccurrence);
        boolean letEnabled = JSIntroduceVariableHandler.varTypeEnabled(holder, Settings.IntroducedVarType.LET);
        boolean constEnabled = JSIntroduceVariableHandler.varTypeEnabled(holder, Settings.IntroducedVarType.CONST);
        boolean bl = this.myEcma = holder != null && holder.isECMA4;
        if (!this.myEcma) {
            this.myVariableTypeLabel.setVisible(false);
            this.myVarType.setVisible(false);
            this.myKindPanel.setVisible(true);
            this.myMakeConstant.setVisible(false);
        } else {
            this.myKindPanel.setVisible(false);
            this.myMakeConstant.setVisible(true);
        }
        if (!letEnabled && !constEnabled) {
            this.myKindPanel.setVisible(false);
        }
        if (!letEnabled) {
            this.myLetRadioButton.setVisible(false);
        }
        if (!constEnabled) {
            this.myConstRadioButton.setVisible(false);
        }
        if (lastSelected == Settings.IntroducedVarType.CONST) {
            this.myConstRadioButton.setSelected(true);
            this.myMakeConstant.setSelected(true);
            selectedSomething = true;
        } else if (lastSelected == Settings.IntroducedVarType.LET) {
            this.myLetRadioButton.setSelected(true);
            selectedSomething = true;
        }
        if (lastSelected == Settings.IntroducedVarType.VAR || !selectedSomething) {
            this.myVarRadioButton.setSelected(true);
        }
        this.doInit();
    }

    @Override
    protected NameSuggestionsField getNameField() {
        return this.myNameField;
    }

    @Override
    protected JLabel getNameLabel() {
        return this.myNameLabel;
    }

    @Override
    protected JPanel getPanel() {
        return this.myPanel;
    }

    @Override
    protected JCheckBox getReplaceAllCheckBox() {
        return this.myReplaceAllCheckBox;
    }

    @Override
    protected void doOKAction() {
        super.doOKAction();
        if (!this.isShowing()) {
            this.myIntroducedVarType = this.myKindPanel.isVisible() ? (this.myConstRadioButton.isSelected() ? Settings.IntroducedVarType.CONST : (this.myLetRadioButton.isSelected() ? Settings.IntroducedVarType.LET : Settings.IntroducedVarType.VAR)) : (this.myMakeConstant.isSelected() ? Settings.IntroducedVarType.CONST : Settings.IntroducedVarType.VAR);
            JSIntroduceVariableHandler.setLastIntroduceType(this.myProject, this.myIntroducedVarType);
        }
    }

    @Override
    public JComboBox getVarTypeField() {
        return this.myVarType;
    }

    @Override
    public Settings.IntroducedVarType getIntroducedVarType() {
        return this.myIntroducedVarType;
    }

    private void createUIComponents() {
        this.myNameField = this.configureNameField();
        this.myVarType = this.configureTypeField();
    }

    protected String getHelpId() {
        return this.myEcma ? "refactoring.introduceVariable.ActionScript" : "refactoring.introduceVariable.JavaScript";
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JLabel jLabel;
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        JRadioButton jRadioButton3;
        JPanel jPanel;
        JCheckBox jCheckBox2;
        JLabel jLabel2;
        JPanel jPanel2;
        this.createUIComponents();
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(6, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myNameLabel = jLabel2 = new JLabel();
        jLabel2.setRequestFocusEnabled(false);
        this.$$$loadLabelText$$$(jLabel2, DynamicBundle.getBundle((String)"messages/JavaScriptBundle", JSIntroduceVariableDialog.class).getString("javascript.introduce.variable.name.prompt"));
        jPanel2.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        NameSuggestionsField nameSuggestionsField = this.myNameField;
        jPanel2.add((Component)nameSuggestionsField, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myReplaceAllCheckBox = jCheckBox2 = new JCheckBox();
        jCheckBox2.setActionCommand("");
        jCheckBox2.setContentAreaFilled(false);
        jCheckBox2.setFocusable(false);
        jCheckBox2.setMargin(new Insets(2, 0, 2, 3));
        jCheckBox2.setText("");
        jPanel2.add((Component)jCheckBox2, new GridConstraints(2, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myKindPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel2.add((Component)jPanel, new GridConstraints(4, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        jPanel.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)"Variable declaration", (int)0, (int)0, null, null));
        this.myConstRadioButton = jRadioButton3 = new JRadioButton();
        jRadioButton3.setMargin(new Insets(2, 0, 2, 3));
        jRadioButton3.setText("const");
        jRadioButton3.setMnemonic('C');
        jRadioButton3.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jRadioButton3, new GridConstraints(2, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myLetRadioButton = jRadioButton2 = new JRadioButton();
        jRadioButton2.setActionCommand("");
        jRadioButton2.setContentAreaFilled(false);
        jRadioButton2.setMargin(new Insets(2, 0, 2, 3));
        jRadioButton2.setText("let");
        jRadioButton2.setMnemonic('L');
        jRadioButton2.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jRadioButton2, new GridConstraints(0, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myVarRadioButton = jRadioButton = new JRadioButton();
        jRadioButton.setMargin(new Insets(2, 0, 2, 3));
        jRadioButton.setText("var");
        jRadioButton.setMnemonic('V');
        jRadioButton.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jRadioButton, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myVariableTypeLabel = jLabel = new JLabel();
        jLabel.setText("Variable of type:");
        jLabel.setDisplayedMnemonic('T');
        jLabel.setDisplayedMnemonicIndex(12);
        jPanel2.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        EditorComboBox editorComboBox = this.myVarType;
        jPanel2.add((Component)editorComboBox, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        this.myMakeConstant = jCheckBox = new JCheckBox();
        jCheckBox.setActionCommand("");
        jCheckBox.setContentAreaFilled(false);
        jCheckBox.setFocusable(false);
        jCheckBox.setMargin(new Insets(2, 0, 2, 3));
        jCheckBox.setText("Make constant");
        jCheckBox.setMnemonic('C');
        jCheckBox.setDisplayedMnemonicIndex(5);
        jPanel2.add((Component)jCheckBox, new GridConstraints(3, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(5, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        jLabel.setLabelFor((Component)editorComboBox);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(jRadioButton3);
        buttonGroup.add(jRadioButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }
}

