/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.introduceVariable;

import com.intellij.lang.javascript.ActionScriptFileType;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.refactoring.introduce.BaseIntroduceSettings;
import com.intellij.lang.javascript.refactoring.introduce.JSBaseIntroduceDialog;
import com.intellij.lang.javascript.refactoring.introduce.JSBaseIntroduceHandler;
import com.intellij.lang.javascript.refactoring.introduceVariable.JSIntroduceVariableHandler;
import com.intellij.lang.javascript.refactoring.introduceVariable.JSVariableInplaceIntroducerBase;
import com.intellij.lang.javascript.refactoring.introduceVariable.Settings;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.ui.NonFocusableCheckBox;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class ASVariableInplaceIntroducer
extends JSVariableInplaceIntroducerBase {
    private final Runnable myCallback;
    private JCheckBox myMakeConstant;

    public ASVariableInplaceIntroducer(Project project, Editor editor, JSExpression[] occurrences, JSBaseIntroduceHandler<? extends JSElement, BaseIntroduceSettings, ? extends JSBaseIntroduceDialog> handler, JSBaseIntroduceHandler.BaseIntroduceContext<BaseIntroduceSettings> context, Runnable callback) {
        super(project, editor, occurrences, (FileType)ActionScriptFileType.INSTANCE, handler, context);
        this.myCallback = callback;
    }

    @Override
    protected Settings getInplaceIntroduceSettings(final String name) {
        return new Settings(){

            @Override
            public Settings.IntroducedVarType getIntroducedVarType() {
                return ASVariableInplaceIntroducer.this.myMakeConstant != null && ASVariableInplaceIntroducer.this.myMakeConstant.isSelected() ? Settings.IntroducedVarType.CONST : Settings.IntroducedVarType.VAR;
            }

            @Override
            public boolean isReplaceAllOccurrences() {
                return ASVariableInplaceIntroducer.this.myInitialSettings.isReplaceAllOccurrences();
            }

            @Override
            public String getVariableName() {
                return name;
            }

            @Override
            public String getVariableType() {
                return ASVariableInplaceIntroducer.this.myInitialSettings.getVariableType();
            }
        };
    }

    protected JComponent getComponent() {
        this.myMakeConstant = new NonFocusableCheckBox("Make constant");
        Settings.IntroducedVarType lastSelected = JSIntroduceVariableHandler.getLastIntroduceType(this.myProject, DialectOptionHolder.ECMA_4);
        this.myMakeConstant.setSelected(lastSelected == Settings.IntroducedVarType.CONST);
        this.myMakeConstant.setMnemonic('c');
        this.myMakeConstant.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getSource() instanceof NonFocusableCheckBox) {
                    NonFocusableCheckBox checkBox = (NonFocusableCheckBox)e.getSource();
                    Settings.IntroducedVarType newVarModifier = checkBox.isSelected() ? Settings.IntroducedVarType.CONST : Settings.IntroducedVarType.VAR;
                    JSIntroduceVariableHandler.setLastIntroduceType(ASVariableInplaceIntroducer.this.myProject, newVarModifier);
                    ASVariableInplaceIntroducer.this.restartInplaceIntroduceTemplate();
                }
            }
        });
        JPanel panel2 = new JPanel();
        panel2.setLayout(new BoxLayout(panel2, 1));
        panel2.setBorder(null);
        panel2.add(this.myMakeConstant);
        return panel2;
    }

    protected void performPostIntroduceTasks() {
        super.performPostIntroduceTasks();
        this.myCallback.run();
    }
}

