/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.gjslint;

import com.intellij.execution.configurations.PathEnvironmentVariableUtil;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.lang.javascript.linter.JSLinterConfiguration;
import com.intellij.lang.javascript.linter.JSLinterInspection;
import com.intellij.lang.javascript.linter.gjslint.GjsLintInspection;
import com.intellij.lang.javascript.linter.gjslint.GjsLintState;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Text;
import org.jetbrains.annotations.NotNull;

@State(name="JSClosureLinterConfiguration", storages={@Storage(value="jsLinters/gjslint.xml")})
public class GjsLintConfiguration
extends JSLinterConfiguration<GjsLintState> {
    public static final String DEFAULT_EXE_FILE_BASE_NAME = SystemInfo.isWindows ? "gjslint.exe" : "gjslint";
    private static final String LINTER_EXE_FILE_PATH = "linter-exe-file-path";
    private static final String ROOT_ELEMENT_NAME = "gjslint";
    private static final String CONFIG_FILE_PATH = "config-file";
    private volatile GjsLintState DEFAULT_STATE;

    public GjsLintConfiguration(@NotNull Project project) {
        if (project == null) {
            GjsLintConfiguration.$$$reportNull$$$0(0);
        }
        super(project);
    }

    @Override
    protected void savePrivateSettings(@NotNull GjsLintState state) {
        if (state == null) {
            GjsLintConfiguration.$$$reportNull$$$0(1);
        }
    }

    @Override
    @NotNull
    protected GjsLintState loadPrivateSettings(@NotNull GjsLintState state) {
        if (state == null) {
            GjsLintConfiguration.$$$reportNull$$$0(2);
        }
        GjsLintState gjsLintState = state;
        if (gjsLintState == null) {
            GjsLintConfiguration.$$$reportNull$$$0(3);
        }
        return gjsLintState;
    }

    @Override
    @NotNull
    protected Class<? extends JSLinterInspection> getInspectionClass() {
        return GjsLintInspection.class;
    }

    @NotNull
    public static GjsLintConfiguration getInstance(@NotNull Project project) {
        if (project == null) {
            GjsLintConfiguration.$$$reportNull$$$0(4);
        }
        GjsLintConfiguration gjsLintConfiguration = JSLinterConfiguration.getInstance(project, GjsLintConfiguration.class);
        if (gjsLintConfiguration == null) {
            GjsLintConfiguration.$$$reportNull$$$0(5);
        }
        return gjsLintConfiguration;
    }

    @Override
    @NotNull
    protected Element toXml(@NotNull GjsLintState state) {
        if (state == null) {
            GjsLintConfiguration.$$$reportNull$$$0(6);
        }
        Element root = new Element(ROOT_ELEMENT_NAME);
        String configFilePath = state.getConfigFilePath();
        Element child = new Element(CONFIG_FILE_PATH);
        child.setContent((Content)new Text(FileUtil.toSystemIndependentName((String)configFilePath)));
        root.addContent(child);
        GjsLintConfiguration.storeLinterExeFilePath(state.getLinterExePath());
        Element element = root;
        if (element == null) {
            GjsLintConfiguration.$$$reportNull$$$0(7);
        }
        return element;
    }

    private static void storeLinterExeFilePath(@NotNull String linterExeFilePath) {
        if (linterExeFilePath == null) {
            GjsLintConfiguration.$$$reportNull$$$0(8);
        }
        PropertiesComponent propertiesComponent = PropertiesComponent.getInstance();
        propertiesComponent.setValue(LINTER_EXE_FILE_PATH, linterExeFilePath);
    }

    @NotNull
    private static String restoreLinterExeFilePath() {
        PropertiesComponent propertiesComponent = PropertiesComponent.getInstance();
        String string = StringUtil.notNullize((String)propertiesComponent.getValue(LINTER_EXE_FILE_PATH));
        if (string == null) {
            GjsLintConfiguration.$$$reportNull$$$0(9);
        }
        return string;
    }

    @Override
    @NotNull
    protected GjsLintState fromXml(@NotNull Element element) {
        if (element == null) {
            GjsLintConfiguration.$$$reportNull$$$0(10);
        }
        GjsLintState.Builder builder = new GjsLintState.Builder();
        Element configFileElement = element.getChild(CONFIG_FILE_PATH);
        String configFilePath = "";
        if (configFileElement != null) {
            configFilePath = FileUtil.toSystemDependentName((String)configFileElement.getText());
        }
        builder.setConfigFilePath(configFilePath);
        String linterExeFilePath = GjsLintConfiguration.restoreLinterExeFilePath();
        if (linterExeFilePath.isEmpty()) {
            linterExeFilePath = this.getDefaultState().getLinterExePath();
        }
        builder.setLinterExePath(linterExeFilePath);
        GjsLintState gjsLintState = builder.build();
        if (gjsLintState == null) {
            GjsLintConfiguration.$$$reportNull$$$0(11);
        }
        return gjsLintState;
    }

    @Override
    @NotNull
    protected GjsLintState getDefaultState() {
        GjsLintState state = this.DEFAULT_STATE;
        if (state == null) {
            GjsLintState.Builder builder = new GjsLintState.Builder();
            File exeFile = PathEnvironmentVariableUtil.findInPath((String)DEFAULT_EXE_FILE_BASE_NAME);
            if (exeFile != null) {
                builder.setLinterExePath(exeFile.getAbsolutePath());
            }
            this.DEFAULT_STATE = state = builder.build();
        }
        GjsLintState gjsLintState = state;
        if (gjsLintState == null) {
            GjsLintConfiguration.$$$reportNull$$$0(12);
        }
        return gjsLintState;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/linter/gjslint/GjsLintConfiguration";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "linterExeFilePath";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/linter/gjslint/GjsLintConfiguration";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "loadPrivateSettings";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "toXml";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "restoreLinterExeFilePath";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "fromXml";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "savePrivateSettings";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "loadPrivateSettings";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 12: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "toXml";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "storeLinterExeFilePath";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "fromXml";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

