/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterRef;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.linter.AutodetectLinterPackage;
import com.intellij.lang.javascript.linter.ExtendedLinterState;
import com.intellij.lang.javascript.linter.JSLinterUtil;
import com.intellij.lang.javascript.linter.JSLinterView;
import com.intellij.lang.javascript.linter.JSNpmLinterState;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ContextHelpLabel;
import com.intellij.ui.components.JBRadioButton;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ItemListener;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class NewLinterView<TState extends JSNpmLinterState<TState>>
implements JSLinterView<TState> {
    private final JPanel myPanel;
    private final JRadioButton myDisabledRb;
    private final JRadioButton myConfigureAutomaticallyRadioRb;
    private final JRadioButton myConfigureManuallyRb;
    private final Project myProject;
    private final String myConfiguredManuallyPropertyName;
    private boolean myConfiguredManually;

    public NewLinterView(Project project, String toolDisplayName, JComponent configurationPanel, String configFileDescription) {
        this.myConfiguredManuallyPropertyName = "js.linters.configure.manually.selected" + StringUtil.toLowerCase((String)toolDisplayName);
        this.myProject = project;
        this.myDisabledRb = new JBRadioButton(JavaScriptBundle.message((String)"settings.javascript.linters.autodetect.disabled", (Object[])new Object[]{toolDisplayName}));
        this.myConfigureAutomaticallyRadioRb = new JBRadioButton(JavaScriptBundle.message((String)"settings.javascript.linters.autodetect.configure.automatically", (Object[])new Object[]{toolDisplayName}));
        this.myConfigureManuallyRb = new JBRadioButton(JavaScriptBundle.message((String)"settings.javascript.linters.autodetect.configure.manually", (Object[])new Object[]{toolDisplayName}));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.myDisabledRb);
        buttonGroup.add(this.myConfigureAutomaticallyRadioRb);
        buttonGroup.add(this.myConfigureManuallyRb);
        JPanel wrapperPanel = new JPanel(new BorderLayout());
        JPanel configurationWrap = new JPanel(new BorderLayout(0, 0));
        configurationWrap.setBorder((Border)JBUI.Borders.emptyLeft((int)JSLinterUtil.getMarginForRadioButton(this.myConfigureManuallyRb)));
        configurationWrap.add((Component)configurationPanel, "North");
        String detectAutomaticallyHelpText = JavaScriptBundle.message((String)"settings.javascript.linters.autodetect.configure.automatically.help.text", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getFullProductName(), toolDisplayName, configFileDescription});
        JPanel mainPanel = FormBuilder.createFormBuilder().setHorizontalGap(10).setVerticalGap(4).addComponent((JComponent)this.myDisabledRb).addComponent(NewLinterView.createPanelWithHelpLink(this.myConfigureAutomaticallyRadioRb, detectAutomaticallyHelpText)).addComponent((JComponent)this.myConfigureManuallyRb).addComponent((JComponent)configurationWrap).getPanel();
        wrapperPanel.add((Component)mainPanel, "North");
        ItemListener radioButtonListener = e -> {
            if (e.getStateChange() != 1) {
                return;
            }
            boolean enabled = this.myConfigureManuallyRb.isSelected() || this.myConfigureAutomaticallyRadioRb.isSelected();
            this.handleEnabledStatusChanged(enabled);
            boolean isConfigureManuallySelected = this.myConfigureManuallyRb.isSelected();
            configurationWrap.setVisible(isConfigureManuallySelected);
            this.myConfiguredManually = enabled && isConfigureManuallySelected;
        };
        this.myDisabledRb.addItemListener(radioButtonListener);
        this.myConfigureAutomaticallyRadioRb.addItemListener(radioButtonListener);
        this.myConfigureManuallyRb.addItemListener(radioButtonListener);
        this.myPanel = wrapperPanel;
    }

    @NotNull
    public static JComponent createPanelWithHelpLink(@NotNull JRadioButton rb, String text) {
        if (rb == null) {
            NewLinterView.$$$reportNull$$$0(0);
        }
        JPanel panel2 = new JPanel(new FlowLayout(0, 0, 0));
        panel2.add(rb);
        ContextHelpLabel helpLabel = ContextHelpLabel.create((String)text);
        helpLabel.setBorder((Border)JBUI.Borders.emptyLeft((int)10));
        panel2.add((Component)helpLabel);
        JPanel jPanel = panel2;
        if (jPanel == null) {
            NewLinterView.$$$reportNull$$$0(1);
        }
        return jPanel;
    }

    @Override
    @Nullable
    public final JComponent getComponent() {
        return this.myPanel;
    }

    @Override
    public final void setExtendedState(@NotNull ExtendedLinterState<TState> state) {
        if (state == null) {
            NewLinterView.$$$reportNull$$$0(2);
        }
        JSNpmLinterState specificState = (JSNpmLinterState)state.getState();
        if (!state.isEnabled()) {
            this.myDisabledRb.setSelected(true);
        } else if (NewLinterView.isValidAutomaticState(specificState) && !this.getConfiguredManually()) {
            this.myConfigureAutomaticallyRadioRb.setSelected(true);
            this.myConfiguredManually = false;
        } else {
            this.myConfigureManuallyRb.setSelected(true);
            this.myConfiguredManually = true;
        }
        this.setState(specificState);
    }

    public boolean isModified() {
        return this.myConfiguredManually != this.getConfiguredManually();
    }

    @Override
    @NotNull
    public final ExtendedLinterState<TState> getExtendedState() {
        if (this.myDisabledRb.isSelected()) {
            return new ExtendedLinterState<TState>(!this.myDisabledRb.isSelected(), this.getState());
        }
        boolean isConfigureAutomatically = this.myConfigureAutomaticallyRadioRb.isSelected();
        if (isConfigureAutomatically) {
            return new ExtendedLinterState<TState>(true, this.getStateWithConfiguredAutomatically());
        }
        return new ExtendedLinterState<TState>(true, this.getState());
    }

    public void reset() {
        this.myConfiguredManually = this.getConfiguredManually();
        if (!this.myDisabledRb.isSelected()) {
            this.myConfigureManuallyRb.setSelected(this.myConfiguredManually);
        }
    }

    public void apply() {
        this.saveConfiguredManually(this.myConfiguredManually);
    }

    private static boolean isValidAutomaticState(@NotNull JSNpmLinterState state) {
        if (state == null) {
            NewLinterView.$$$reportNull$$$0(3);
        }
        return state.getNodePackageRef() == AutodetectLinterPackage.INSTANCE && state.getInterpreterRef().equals(NodeJsInterpreterRef.createProjectRef());
    }

    private void saveConfiguredManually(boolean value) {
        PropertiesComponent.getInstance((Project)this.myProject).setValue(this.myConfiguredManuallyPropertyName, value);
    }

    private boolean getConfiguredManually() {
        return PropertiesComponent.getInstance((Project)this.myProject).getBoolean(this.myConfiguredManuallyPropertyName, false);
    }

    @NotNull
    protected abstract TState getStateWithConfiguredAutomatically();

    protected abstract void handleEnabledStatusChanged(boolean var1);

    protected abstract void setState(@NotNull TState var1);

    @NotNull
    protected abstract TState getState();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rb";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/linter/NewLinterView";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/linter/NewLinterView";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createPanelWithHelpLink";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createPanelWithHelpLink";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setExtendedState";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isValidAutomaticState";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

