/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspection;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.inspection.JSSuspiciousTypeUtil;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSPrefixExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecma6.EnumConstantValue;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnumField;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeImpl;
import com.intellij.lang.javascript.psi.types.JSResolvableType;
import com.intellij.lang.javascript.psi.types.JSResolvedTypeInfo;
import com.intellij.lang.javascript.psi.types.guard.JSTypeGuardChecker;
import com.intellij.lang.javascript.psi.types.guard.JSTypeGuardUtil;
import com.intellij.lang.javascript.psi.types.guard.TypeScriptTypeRelations;
import com.intellij.lang.javascript.psi.types.primitives.JSBigIntType;
import com.intellij.lang.javascript.psi.types.primitives.JSBooleanType;
import com.intellij.lang.javascript.psi.types.primitives.JSNumberType;
import com.intellij.lang.javascript.psi.types.primitives.JSStringType;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.Processor;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSSuspiciousTypeOfCheck {
    static void checkTypeofGuard(@NotNull ProblemsHolder holder, @NotNull JSBinaryExpression expression, @NotNull JSPrefixExpression typeOfExpr, @NotNull JSLiteralExpression literal, @NotNull IElementType sign, @NotNull ProblemHighlightType problemHighlightType) {
        JSExpression target;
        if (holder == null) {
            JSSuspiciousTypeOfCheck.$$$reportNull$$$0(0);
        }
        if (expression == null) {
            JSSuspiciousTypeOfCheck.$$$reportNull$$$0(1);
        }
        if (typeOfExpr == null) {
            JSSuspiciousTypeOfCheck.$$$reportNull$$$0(2);
        }
        if (literal == null) {
            JSSuspiciousTypeOfCheck.$$$reportNull$$$0(3);
        }
        if (sign == null) {
            JSSuspiciousTypeOfCheck.$$$reportNull$$$0(4);
        }
        if (problemHighlightType == null) {
            JSSuspiciousTypeOfCheck.$$$reportNull$$$0(5);
        }
        if (!((target = JSTypeGuardUtil.getReferenceCandidate(typeOfExpr.getExpression())) instanceof JSReferenceExpression)) {
            return;
        }
        JSType expressionJSType = JSTypeGuardChecker.getExactType(JSResolveUtil.getExpressionJSType(target));
        if (expressionJSType == null) {
            return;
        }
        expressionJSType = expressionJSType.transformTypeHierarchy(JSSuspiciousTypeUtil::getGenericConstraintSelfOrAny);
        if (JSTypeUtils.isAnyType(expressionJSType = JSCompositeTypeImpl.optimizeTypeIfComposite(expressionJSType)) || JSTypeUtils.hasForeignGenericParameter(expressionJSType)) {
            return;
        }
        String value = literal.getStringValue();
        if (!JSSuspiciousTypeOfCheck.isLiteralValue(value)) {
            return;
        }
        JSSuspiciousTypeOfCheck.validateTypeOfType(holder, expression, expressionJSType, value, literal, (JSReferenceExpression)target, sign, problemHighlightType);
    }

    private static void validateTypeOfType(@NotNull ProblemsHolder holder, @NotNull JSBinaryExpression expression, @NotNull JSType expressionJSType, @NotNull String value, @NotNull JSLiteralExpression literal, @NotNull JSReferenceExpression target, @NotNull IElementType sign, @NotNull ProblemHighlightType problemHighlightType) {
        boolean isNegative;
        boolean isStrictNotNull;
        if (holder == null) {
            JSSuspiciousTypeOfCheck.$$$reportNull$$$0(6);
        }
        if (expression == null) {
            JSSuspiciousTypeOfCheck.$$$reportNull$$$0(7);
        }
        if (expressionJSType == null) {
            JSSuspiciousTypeOfCheck.$$$reportNull$$$0(8);
        }
        if (value == null) {
            JSSuspiciousTypeOfCheck.$$$reportNull$$$0(9);
        }
        if (literal == null) {
            JSSuspiciousTypeOfCheck.$$$reportNull$$$0(10);
        }
        if (target == null) {
            JSSuspiciousTypeOfCheck.$$$reportNull$$$0(11);
        }
        if (sign == null) {
            JSSuspiciousTypeOfCheck.$$$reportNull$$$0(12);
        }
        if (problemHighlightType == null) {
            JSSuspiciousTypeOfCheck.$$$reportNull$$$0(13);
        }
        Set<Object> decorators = JSTypeGuardChecker.isNarrowableReference((JSExpression)target) ? JSTypeGuardChecker.getDecoratorsForExpression(target) : Collections.emptySet();
        boolean bl = isStrictNotNull = decorators.containsAll(JSTypeGuardChecker.NOTNULL_UNDEFINED_PRIMITIVE) || JSSuspiciousTypeUtil.isTypeWithStrictNullability(expressionJSType, (PsiElement)literal);
        if (!isStrictNotNull || JSTypeUtils.isAnyType(expressionJSType)) {
            return;
        }
        boolean bl2 = isNegative = sign == JSTokenTypes.NEQEQ || sign == JSTokenTypes.NE;
        if (JSSuspiciousTypeOfCheck.isRedundantTypeOf(expressionJSType, value)) {
            holder.registerProblem((PsiElement)expression, JavaScriptBundle.message((String)(isNegative ? "javascript.falsy.typeof.guard" : "javascript.redundant.typeof.guard"), (Object[])new Object[]{target.getReferenceName(), value}), problemHighlightType, new LocalQuickFix[]{JSSuspiciousTypeUtil.getSimplifyFix((JSExpression)expression, isNegative)});
            return;
        }
        Ref hadOurType = Ref.create((Object)false);
        JSTypeUtils.processExpandedType((Processor<? super JSType>)((Processor)t -> {
            switch (value) {
                case "string": {
                    EnumConstantValue value1;
                    TypeScriptEnumField field;
                    JSResolvedTypeInfo info;
                    if (t instanceof JSStringType) {
                        hadOurType.set((Object)true);
                    }
                    if (!(t instanceof JSResolvableType) || !(info = ((JSResolvableType)t).resolveType()).isEnumLiteral() || (field = info.getDeclarationOfType(TypeScriptEnumField.class)) == null || (value1 = field.getConstantValue()).getStringValue() == null) break;
                    hadOurType.set((Object)true);
                    break;
                }
                case "number": {
                    if (t instanceof JSNumberType) {
                        hadOurType.set((Object)true);
                    }
                    if (t instanceof JSResolvableType) {
                        EnumConstantValue value1;
                        TypeScriptEnumField field;
                        JSResolvedTypeInfo info = ((JSResolvableType)t).resolveType();
                        if (info.isEnum()) {
                            hadOurType.set((Object)true);
                        }
                        if (info.isEnumLiteral() && (field = info.getDeclarationOfType(TypeScriptEnumField.class)) != null && (value1 = field.getConstantValue()).getNumericValue() != null) {
                            hadOurType.set((Object)true);
                        }
                    }
                }
                case "boolean": {
                    if (!(t instanceof JSBooleanType)) break;
                    hadOurType.set((Object)true);
                    break;
                }
                case "bigint": {
                    if (!(t instanceof JSBigIntType)) break;
                    hadOurType.set((Object)true);
                }
            }
            return true;
        }), expressionJSType, false, true, true);
        if (!((Boolean)hadOurType.get()).booleanValue()) {
            holder.registerProblem((PsiElement)expression, JavaScriptBundle.message((String)"javascript.suspicious.typeof.guard", (Object[])new Object[]{target.getReferenceName(), value}), problemHighlightType, new LocalQuickFix[]{JSSuspiciousTypeUtil.getSimplifyFix((JSExpression)expression, !isNegative)});
        }
    }

    private static boolean isLiteralValue(@Nullable String value) {
        if (value == null) {
            return false;
        }
        return "string".equals(value) || "number".equals(value) || "bigint".equals(value) || "boolean".equals(value);
    }

    private static boolean isRedundantTypeOf(@Nullable JSType expressionJSType, @NotNull String value) {
        if (value == null) {
            JSSuspiciousTypeOfCheck.$$$reportNull$$$0(14);
        }
        expressionJSType = JSTypeUtils.unwrapDecorations(expressionJSType);
        switch (value) {
            case "string": {
                return TypeScriptTypeRelations.isTypeOrUnionOf(expressionJSType, JSStringType.class);
            }
            case "number": {
                return TypeScriptTypeRelations.isTypeOrUnionOf(expressionJSType, JSNumberType.class);
            }
            case "bigint": {
                return TypeScriptTypeRelations.isTypeOrUnionOf(expressionJSType, JSBigIntType.class);
            }
            case "boolean": {
                return TypeScriptTypeRelations.isTypeOrUnionOf(expressionJSType, JSBooleanType.class);
            }
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeOfExpr";
                break;
            }
            case 3: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "literal";
                break;
            }
            case 4: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sign";
                break;
            }
            case 5: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problemHighlightType";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressionJSType";
                break;
            }
            case 9: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/inspection/JSSuspiciousTypeOfCheck";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "checkTypeofGuard";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "validateTypeOfType";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "isRedundantTypeOf";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

