/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.completion;

import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.CommaTailType;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.lang.javascript.completion.JSInsertHandler;
import com.intellij.lang.javascript.completion.JSSmartCompletionContributor;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterItem;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.lang.javascript.psi.types.primitives.JSPrimitiveFunctionType;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ProcessingContext;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSSmartCompletionVariantsHandler {
    private static final Key<PsiElement> ourPlaceKey = Key.create((String)"place");

    @Nullable
    static List<LookupElement> getSmartVariants(@NotNull JSReferenceExpression expr) {
        JSSmartCompletionContributor contributor;
        if (expr == null) {
            JSSmartCompletionVariantsHandler.$$$reportNull$$$0(0);
        }
        if ((contributor = (JSSmartCompletionContributor)JSSmartCompletionContributor.EP_NAME.forLanguage(expr.getLanguage())) == null) {
            return null;
        }
        List<LookupElement> variants = contributor.getSmartCompletionVariants(expr);
        return variants != null ? JSSmartCompletionVariantsHandler.wrapVariants(variants, (PsiElement)expr) : null;
    }

    @NotNull
    private static List<LookupElement> wrapVariants(@NotNull List<LookupElement> variants, PsiElement expr) {
        Object nextParameter;
        Object[] parameters;
        int index;
        JSArgumentList argumentList;
        JSParameterItem parameter;
        PsiElement parent;
        if (variants == null) {
            JSSmartCompletionVariantsHandler.$$$reportNull$$$0(1);
        }
        if (!variants.isEmpty() && (parent = expr.getParent()) instanceof JSArgumentList && (parameter = JSResolveUtil.findParameterForUsedArgument((JSExpression)expr, argumentList = (JSArgumentList)parent)) instanceof JSParameter && (index = ArrayUtil.indexOf((Object[])(parameters = ((JSParameterList)((JSParameter)parameter).getParent()).getParameters()), (Object)parameter)) >= 0 && index + 1 < parameters.length && !(nextParameter = parameters[index + 1]).isOptional() && !nextParameter.isRest()) {
            for (LookupElement o : variants) {
                if (o instanceof PrioritizedLookupElement) {
                    o = ((PrioritizedLookupElement)o).getDelegate();
                }
                if (!(o instanceof LookupElement)) continue;
                o.putUserData(JSInsertHandler.FORCED_TAIL_TYPE, (Object)CommaTailType.INSTANCE);
            }
        }
        List<LookupElement> list2 = variants;
        if (list2 == null) {
            JSSmartCompletionVariantsHandler.$$$reportNull$$$0(2);
        }
        return list2;
    }

    public static boolean isAcceptableVariant(PsiElement element, @NotNull JSType expectedType, ProcessingContext processingContext) {
        if (expectedType == null) {
            JSSmartCompletionVariantsHandler.$$$reportNull$$$0(3);
        }
        if (expectedType instanceof JSPrimitiveFunctionType && element instanceof JSFunction && !((JSFunction)element).isGetProperty()) {
            return true;
        }
        JSType elementType = JSTypeImpl.fromElement(element, (PsiElement)processingContext.get(ourPlaceKey));
        if (elementType == null) {
            return false;
        }
        String typeText = elementType.getTypeText();
        Boolean aBoolean = (Boolean)processingContext.get((Object)typeText);
        if (aBoolean == Boolean.TRUE) {
            return true;
        }
        if (aBoolean == Boolean.FALSE) {
            return false;
        }
        boolean result2 = JSTypeUtils.typeCanBeAssignedWithoutCoercion(expectedType, elementType) && expectedType.isDirectlyAssignableType(elementType, processingContext);
        processingContext.put((Object)typeText, (Object)(result2 ? Boolean.TRUE : Boolean.FALSE));
        return result2;
    }

    public static ProcessingContext initProcessingContext(PsiElement place) {
        ProcessingContext processingContext = new ProcessingContext();
        processingContext.put(ourPlaceKey, (Object)place);
        return processingContext;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variants";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/completion/JSSmartCompletionVariantsHandler";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/completion/JSSmartCompletionVariantsHandler";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapVariants";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getSmartVariants";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "wrapVariants";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAcceptableVariant";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

