/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript;

import com.intellij.lang.actionscript.ActionScriptElementTypes;
import com.intellij.lang.ecmascript6.ES6ElementTypes;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSEqualElementType;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.flow.FlowJSElementTypes;
import com.intellij.lang.javascript.nashorn.NashornJSElementTypes;
import com.intellij.lang.javascript.types.JSCaseClauseElementType;
import com.intellij.lang.javascript.types.JSClassElementTypeBase;
import com.intellij.lang.javascript.types.JSCompositeBlockStatementElementType;
import com.intellij.lang.javascript.types.JSDestructuringElementElementType;
import com.intellij.lang.javascript.types.JSDestructuringParameterElementType;
import com.intellij.lang.javascript.types.JSExpressionElementType;
import com.intellij.lang.javascript.types.JSFunctionPropertyElementType;
import com.intellij.lang.javascript.types.JSParameterElementType;
import com.intellij.lang.javascript.types.JSPropertyElementType;
import com.intellij.lang.javascript.types.JSVariableElementType;
import com.intellij.lang.javascript.types.JSWhiteSpaceElementType;
import com.intellij.lang.typescript.TypeScriptElementTypes;
import com.intellij.lang.typescript.TypeScriptStubElementTypes;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;

public class JSExtendedLanguagesTokenSetProvider {
    public static final TokenSet OUR_STUBBED_FILTER = TokenSet.orSet((TokenSet[])new TokenSet[]{TokenSet.create((IElementType[])new IElementType[]{JSStubElementTypes.CLASS, ActionScriptElementTypes.FUNCTION_DECLARATION, JSStubElementTypes.ATTRIBUTE_LIST, JSStubElementTypes.ACTION_SCRIPT_ATTRIBUTE_LIST, JSStubElementTypes.INCLUDE_DIRECTIVE, JSStubElementTypes.ATTRIBUTE, JSStubElementTypes.PACKAGE_STATEMENT}), JSExtendedLanguagesTokenSetProvider.getClassTokenSet(), JSElementTypes.VAR_STATEMENTS});
    public static final TokenSet BLOCK_STATEMENTS = JSExtendedLanguagesTokenSetProvider.getBlockStatementsTokenSet();
    public static final TokenSet STATEMENTS = JSExtendedLanguagesTokenSetProvider.getStatementsTokenSet();
    public static final TokenSet CLASSES = JSExtendedLanguagesTokenSetProvider.getClassTokenSet();
    public static final TokenSet MODULES = TokenSet.create((IElementType[])new IElementType[]{JSStubElementTypes.TYPESCRIPT_MODULE, TypeScriptStubElementTypes.IMPLICIT_MODULE, FlowJSElementTypes.MODULE});
    public static final TokenSet SOURCE_ELEMENTS = TokenSet.orSet((TokenSet[])new TokenSet[]{STATEMENTS, JSElementTypes.FUNCTION_DECLARATIONS, CLASSES, MODULES, TokenSet.create((IElementType[])new IElementType[]{JSStubElementTypes.NAMESPACE_DECLARATION, JSStubElementTypes.INCLUDE_DIRECTIVE, JSStubElementTypes.USE_NAMESPACE_DIRECTIVE, ES6ElementTypes.EXPORT_DECLARATION, ES6ElementTypes.IMPORT_DECLARATION, ES6ElementTypes.EXPORT_DEFAULT_ASSIGNMENT, FlowJSElementTypes.DECLARE_EXPORT_DECLARATION, TypeScriptElementTypes.EXPORT_ASSIGNMENT, JSStubElementTypes.TYPESCRIPT_TYPE_ALIAS})});
    public static final TokenSet SCOPE_ELEMENTS = TokenSet.orSet((TokenSet[])new TokenSet[]{JSElementTypes.FUNCTIONS, CLASSES, MODULES, TokenSet.create((IElementType[])new IElementType[]{TypeScriptStubElementTypes.OBJECT_TYPE, TypeScriptStubElementTypes.FUNCTION_TYPE, FlowJSElementTypes.FUNCTION_TYPE})});
    public static final TokenSet ASSIGNMENT_OPERATIONS = TokenSet.orSet((TokenSet[])new TokenSet[]{JSTokenTypes.ASSIGNMENT_OPERATIONS, JSExtendedLanguagesTokenSetProvider.getEqualSignTokenSet()});
    public static final TokenSet OPERATIONS = TokenSet.orSet((TokenSet[])new TokenSet[]{JSTokenTypes.OPERATIONS, JSExtendedLanguagesTokenSetProvider.getEqualSignTokenSet()});
    public static final TokenSet CASE_CLAUSES = JSExtendedLanguagesTokenSetProvider.getCaseClauseTokenSet();
    public static final TokenSet PROPERTIES = JSExtendedLanguagesTokenSetProvider.getPropertyTokenSet();
    public static final TokenSet PARAMETERS = JSExtendedLanguagesTokenSetProvider.getParametersTokenSet();
    public static final TokenSet VARIABLES = JSExtendedLanguagesTokenSetProvider.getVariablesTokenSet();
    public static final TokenSet ARGUMENT_LISTS = JSExtendedLanguagesTokenSetProvider.getArgumentListTokenSet();
    public static final TokenSet EXPRESSIONS = JSExtendedLanguagesTokenSetProvider.getExpressionsTokenSet();
    public static final TokenSet WHITE_SPACES = JSExtendedLanguagesTokenSetProvider.getWhiteSpacesTokenSet();
    public static final TokenSet MODULE_EMBEDDED_CONTENTS = TokenSet.create((IElementType[])new IElementType[]{JSElementTypes.EMBEDDED_CONTENT_MODULE, JSElementTypes.ES6_EMBEDDED_CONTENT_MODULE, JSElementTypes.JSX_EMBEDDED_CONTENT_MODULE, JSElementTypes.TS_EMBEDDED_CONTENT_MODULE, JSElementTypes.TSX_EMBEDDED_CONTENT_MODULE});
    public static final TokenSet EMBEDDED_CONTENTS = TokenSet.orSet((TokenSet[])new TokenSet[]{TokenSet.create((IElementType[])new IElementType[]{JSElementTypes.EMBEDDED_CONTENT, JSElementTypes.ES6_EMBEDDED_CONTENT, JSElementTypes.JSX_EMBEDDED_CONTENT, JSElementTypes.TS_EMBEDDED_CONTENT, JSElementTypes.TSX_EMBEDDED_CONTENT}), MODULE_EMBEDDED_CONTENTS});
    public static final TokenSet DESTRUCTURING_ELEMENTS = JSExtendedLanguagesTokenSetProvider.getDestructuringElementsTokenSet();
    public static final TokenSet INITIALIZER_OWNERS = TokenSet.orSet((TokenSet[])new TokenSet[]{VARIABLES, DESTRUCTURING_ELEMENTS, TokenSet.create((IElementType[])new IElementType[]{JSElementTypes.EMPTY_EXPRESSION})});
    public static final TokenSet SKIP_WORDS_SCAN_SET = TokenSet.orSet((TokenSet[])new TokenSet[]{TokenSet.create((IElementType[])new IElementType[]{JSTokenTypes.WHITE_SPACE, JSTokenTypes.DOT, JSTokenTypes.SEMICOLON, JSTokenTypes.LBRACE, JSTokenTypes.RBRACE, JSTokenTypes.LPAR, JSTokenTypes.RPAR, JSTokenTypes.COLON, JSTokenTypes.COLON_COLON, JSTokenTypes.ANY_IDENTIFIER, JSTokenTypes.LBRACKET, JSTokenTypes.RBRACKET, JSTokenTypes.DOT_DOT, JSTokenTypes.DOT_DOT_DOT}), TokenSet.andNot((TokenSet)JSTokenTypes.OPERATIONS, (TokenSet)TokenSet.create((IElementType[])new IElementType[]{JSTokenTypes.IS_KEYWORD, JSTokenTypes.AS_KEYWORD, JSTokenTypes.IN_KEYWORD}))});

    private static TokenSet getDestructuringElementsTokenSet() {
        return TokenSet.forAllMatching(t -> t instanceof JSDestructuringElementElementType || t instanceof JSDestructuringParameterElementType);
    }

    private static TokenSet getExpressionsTokenSet() {
        return TokenSet.orSet((TokenSet[])new TokenSet[]{TokenSet.forAllMatching(t -> t instanceof JSExpressionElementType), JSElementTypes.EXPRESSIONS});
    }

    private static TokenSet getWhiteSpacesTokenSet() {
        return TokenSet.orSet((TokenSet[])new TokenSet[]{JSTokenTypes.PARSER_WHITE_SPACE_TOKENS, TokenSet.create((IElementType[])new IElementType[]{JSTokenTypes.XML_TAG_WHITE_SPACE}), TokenSet.forAllMatching(t -> t instanceof JSWhiteSpaceElementType)});
    }

    private static TokenSet getPropertyTokenSet() {
        return TokenSet.forAllMatching(type -> type instanceof JSPropertyElementType || type instanceof JSFunctionPropertyElementType);
    }

    private static TokenSet getClassTokenSet() {
        return TokenSet.forAllMatching(type -> type instanceof JSClassElementTypeBase || type == JSStubElementTypes.TYPESCRIPT_INTERFACE || type == JSStubElementTypes.TYPESCRIPT_ENUM);
    }

    private static TokenSet getCaseClauseTokenSet() {
        return TokenSet.forAllMatching(type -> type instanceof JSCaseClauseElementType);
    }

    private static TokenSet getParametersTokenSet() {
        return TokenSet.orSet((TokenSet[])new TokenSet[]{TokenSet.forAllMatching(type -> type instanceof JSParameterElementType), TokenSet.create((IElementType[])new IElementType[]{JSStubElementTypes.DESTRUCTURING_PARAMETER})});
    }

    private static TokenSet getVariablesTokenSet() {
        TokenSet extendedVariables = TokenSet.forAllMatching(type -> type instanceof JSVariableElementType);
        return TokenSet.orSet((TokenSet[])new TokenSet[]{extendedVariables, JSElementTypes.BODY_VARIABLES, PARAMETERS});
    }

    private static TokenSet getEqualSignTokenSet() {
        return TokenSet.forAllMatching(type -> type instanceof JSEqualElementType);
    }

    private static TokenSet getArgumentListTokenSet() {
        return TokenSet.create((IElementType[])new IElementType[]{JSElementTypes.ARGUMENT_LIST, JSElementTypes.E4X_FILTER_QUERY_ARGUMENT_LIST, NashornJSElementTypes.ARGUMENT_LIST});
    }

    private static TokenSet getBlockStatementsTokenSet() {
        return TokenSet.orSet((TokenSet[])new TokenSet[]{TokenSet.forAllMatching(type -> type instanceof JSCompositeBlockStatementElementType), TokenSet.create((IElementType[])new IElementType[]{JSElementTypes.BLOCK_STATEMENT})});
    }

    private static TokenSet getStatementsTokenSet() {
        return TokenSet.orSet((TokenSet[])new TokenSet[]{BLOCK_STATEMENTS, TokenSet.create((IElementType[])new IElementType[]{JSElementTypes.LABELED_STATEMENT, JSElementTypes.EMPTY_STATEMENT, JSElementTypes.IF_STATEMENT, JSElementTypes.CONTINUE_STATEMENT, JSElementTypes.BREAK_STATEMENT, JSElementTypes.WITH_STATEMENT, JSStubElementTypes.RETURN_STATEMENT, JSElementTypes.THROW_STATEMENT, JSElementTypes.TRY_STATEMENT, JSElementTypes.SWITCH_STATEMENT, JSElementTypes.FOR_IN_STATEMENT, JSElementTypes.FOR_STATEMENT, JSElementTypes.WHILE_STATEMENT, JSElementTypes.DOWHILE_STATEMENT, JSElementTypes.EXPRESSION_STATEMENT, JSElementTypes.LET_STATEMENT, JSStubElementTypes.IMPORT_STATEMENT, JSStubElementTypes.PACKAGE_STATEMENT, JSStubElementTypes.USE_NAMESPACE_DIRECTIVE, JSElementTypes.DEBUGGER_STATEMENT, TypeScriptElementTypes.IMPORT_STATEMENT}), JSElementTypes.VAR_STATEMENTS});
    }
}

