/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ecmascript6.resolve;

import com.intellij.javascript.JSFileReference;
import com.intellij.javascript.JSModuleBaseReference;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.lang.ecmascript6.psi.ES6FromClause;
import com.intellij.lang.ecmascript6.resolve.JSFileReferenceCache;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSStringUtil;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.index.FrameworkIndexingHandler;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSModuleReferenceContributor;
import com.intellij.lang.typescript.psi.TypeScriptExternalModuleReference;
import com.intellij.lang.typescript.resolve.TypeScriptAugmentationUtil;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigService;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ProcessingContext;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSFileReferencesUtil {
    static volatile JSFileReferencesUtil INSTANCE = new JSFileReferencesUtil();

    public static void setInstance(@NotNull JSFileReferencesUtil util) {
        if (util == null) {
            JSFileReferencesUtil.$$$reportNull$$$0(0);
        }
        INSTANCE = util;
    }

    @NotNull
    public static Collection<PsiElement> resolveModuleReferences(@NotNull PsiElement referenceOwner) {
        if (referenceOwner == null) {
            JSFileReferencesUtil.$$$reportNull$$$0(1);
        }
        return JSFileReferencesUtil.resolveModuleReferences(referenceOwner, false);
    }

    @NotNull
    public static Collection<PsiElement> resolveModuleReferences(@NotNull PsiElement referenceOwner, boolean includeUnindexedFiles) {
        if (referenceOwner == null) {
            JSFileReferencesUtil.$$$reportNull$$$0(2);
        }
        Collection<PsiElement> collection = JSFileReferenceCache.getInstance(referenceOwner.getProject()).resolveModuleReferences(referenceOwner, includeUnindexedFiles);
        if (collection == null) {
            JSFileReferencesUtil.$$$reportNull$$$0(3);
        }
        return collection;
    }

    @NotNull
    public static Collection<PsiElement> resolveModuleReference(@Nullable PsiElement scope, @NotNull String refText) {
        if (refText == null) {
            JSFileReferencesUtil.$$$reportNull$$$0(4);
        }
        if (scope == null) {
            List<PsiElement> list2 = Collections.emptyList();
            if (list2 == null) {
                JSFileReferencesUtil.$$$reportNull$$$0(5);
            }
            return list2;
        }
        Collection<PsiElement> collection = JSFileReferenceCache.getInstance(scope.getProject()).resolveModuleReference(scope, refText, false);
        if (collection == null) {
            JSFileReferencesUtil.$$$reportNull$$$0(6);
        }
        return collection;
    }

    @Nullable
    public static String getReferenceModuleText(@NotNull PsiElement element) {
        if (element == null) {
            JSFileReferencesUtil.$$$reportNull$$$0(7);
        }
        if (element instanceof JSLiteralExpression) {
            return element.getText();
        }
        if (element instanceof ES6FromClause) {
            return ((ES6FromClause)element).getReferenceText();
        }
        if (element instanceof TypeScriptExternalModuleReference) {
            return ((TypeScriptExternalModuleReference)element).getReferenceText();
        }
        if (element instanceof TypeScriptModule) {
            return ((TypeScriptModule)element).getExternalModuleText();
        }
        return null;
    }

    public static PsiReference[] createImportExportFromClauseReferences(@NotNull PsiElement host, int offset, @NotNull String quoted, @Nullable PsiReferenceProvider provider) {
        if (host == null) {
            JSFileReferencesUtil.$$$reportNull$$$0(8);
        }
        if (quoted == null) {
            JSFileReferencesUtil.$$$reportNull$$$0(9);
        }
        return JSModuleReferenceContributor.getReferences(JSStringUtil.unquoteStringLiteralValue(quoted), host, offset, provider, false);
    }

    public static boolean isLibraryElement(@NotNull PsiElement context) {
        if (context == null) {
            JSFileReferencesUtil.$$$reportNull$$$0(10);
        }
        if (DumbService.isDumb((Project)context.getProject())) {
            return false;
        }
        ProjectFileIndex index = ProjectRootManager.getInstance((Project)context.getProject()).getFileIndex();
        VirtualFile file2 = PsiUtilCore.getVirtualFile((PsiElement)context);
        return file2 != null && index.isInLibrary(file2);
    }

    @NotNull
    protected Collection<PsiElement> calculateMainModules(@NotNull PsiElement context, @NotNull String unquotedString) {
        if (context == null) {
            JSFileReferencesUtil.$$$reportNull$$$0(11);
        }
        if (unquotedString == null) {
            JSFileReferencesUtil.$$$reportNull$$$0(12);
        }
        return JSFileReferencesUtil.getMostPriorityModules(context, unquotedString, false);
    }

    @NotNull
    public static Collection<PsiElement> getMostPriorityModules(@NotNull PsiElement context, PsiReference @NotNull [] references) {
        if (context == null) {
            JSFileReferencesUtil.$$$reportNull$$$0(13);
        }
        if (references == null) {
            JSFileReferencesUtil.$$$reportNull$$$0(14);
        }
        THashSet results = new THashSet();
        int maxWeight = Integer.MIN_VALUE;
        for (PsiReference reference : references) {
            Collection<PsiElement> currentResults;
            int weight = JSFileReferencesUtil.getReferenceWeight(reference);
            if (maxWeight > weight && results.size() > 0 || (currentResults = JSModuleReferenceContributor.resolveModuleReference(reference)).size() == 0) continue;
            String[] extensions = JSFileReferencesUtil.getExtensions(context);
            for (PsiElement result2 : currentResults) {
                PsiElement current = JSFileReferencesUtil.getModuleForPsiElement(extensions, result2);
                if (current == null || !JSFileReferencesUtil.isValidModule(context, current)) continue;
                if (weight > maxWeight) {
                    results.clear();
                    maxWeight = weight;
                }
                results.add(current);
            }
        }
        THashSet tHashSet = results;
        if (tHashSet == null) {
            JSFileReferencesUtil.$$$reportNull$$$0(15);
        }
        return tHashSet;
    }

    @NotNull
    public static Collection<PsiElement> getMostPriorityModules(@NotNull PsiElement context, @NotNull String path, boolean isCommonJS) {
        if (context == null) {
            JSFileReferencesUtil.$$$reportNull$$$0(16);
        }
        if (path == null) {
            JSFileReferencesUtil.$$$reportNull$$$0(17);
        }
        THashSet results = new THashSet();
        String[] extensions = JSFileReferencesUtil.getExtensions(context);
        THashSet invalidResults = new THashSet();
        int maxWeight = Integer.MIN_VALUE;
        for (JSModuleReferenceContributor contributor : JSModuleReferenceContributor.getSortedExtensions()) {
            Collection<PsiElement> elements;
            int weight;
            if (!contributor.isApplicable(context) || (weight = contributor.getDefaultWeight()) < maxWeight || (elements = contributor.resolveReferences(context, path, isCommonJS)).isEmpty()) continue;
            for (PsiElement result2 : elements) {
                PsiElement current = JSFileReferencesUtil.getModuleForPsiElement(extensions, result2);
                if (current == null) continue;
                boolean isValid = JSFileReferencesUtil.isValidModule(context, current);
                if (isValid) {
                    if (weight > maxWeight) {
                        results.clear();
                        maxWeight = weight;
                    }
                    results.add(current);
                    continue;
                }
                invalidResults.add(current);
            }
        }
        THashSet tHashSet = results.isEmpty() ? invalidResults : results;
        if (tHashSet == null) {
            JSFileReferencesUtil.$$$reportNull$$$0(18);
        }
        return tHashSet;
    }

    private static String @NotNull [] getExtensions(@NotNull PsiElement context) {
        if (context == null) {
            JSFileReferencesUtil.$$$reportNull$$$0(19);
        }
        String[] stringArray = DialectDetector.isTypeScript(context) ? TypeScriptUtil.TYPESCRIPT_EXTENSIONS : JSFileReference.IMPLICIT_EXTENSIONS;
        if (stringArray == null) {
            JSFileReferencesUtil.$$$reportNull$$$0(20);
        }
        return stringArray;
    }

    @Nullable
    public static PsiElement getModuleForPsiElement(String @NotNull [] extensions, @NotNull PsiElement result2) {
        if (result2 == null) {
            JSFileReferencesUtil.$$$reportNull$$$0(21);
        }
        if (extensions == null) {
            JSFileReferencesUtil.$$$reportNull$$$0(22);
        }
        PsiElement current = null;
        if (result2 instanceof PsiFileSystemItem && ((PsiFileSystemItem)result2).isDirectory()) {
            PsiFile file2 = JSFileReferencesUtil.findIndexFile(extensions, (PsiFileSystemItem)result2);
            if (file2 != null) {
                current = file2;
            }
        } else {
            current = JSFileReferencesUtil.findModule(result2);
        }
        return current;
    }

    private static boolean isValidModule(@NotNull PsiElement context, @NotNull PsiElement module) {
        if (context == null) {
            JSFileReferencesUtil.$$$reportNull$$$0(23);
        }
        if (module == null) {
            JSFileReferencesUtil.$$$reportNull$$$0(24);
        }
        if (DialectDetector.isTypeScript(context) && module instanceof TypeScriptModule) {
            return TypeScriptConfigService.Provider.isAccessible(context, module);
        }
        return true;
    }

    private static int getReferenceWeight(@NotNull PsiReference reference) {
        if (reference == null) {
            JSFileReferencesUtil.$$$reportNull$$$0(25);
        }
        if (reference instanceof JSModuleBaseReference) {
            return ((JSModuleBaseReference)reference).getWeight();
        }
        return 0;
    }

    private static PsiElement findModule(PsiElement result2) {
        for (FrameworkIndexingHandler handler : FrameworkIndexingHandler.getIndexingHandlers()) {
            PsiElement processed = handler.findModule(result2);
            if (processed == null) continue;
            return processed;
        }
        return result2;
    }

    @Nullable
    public static PsiFile findIndexFile(String @NotNull [] extensions, @NotNull PsiFileSystemItem result2) {
        VirtualFile virtualFile;
        VirtualFile file2;
        if (result2 == null) {
            JSFileReferencesUtil.$$$reportNull$$$0(26);
        }
        if (extensions == null) {
            JSFileReferencesUtil.$$$reportNull$$$0(27);
        }
        return (file2 = JSFileReferencesUtil.findIndexVirtualFile(extensions, virtualFile = result2.getVirtualFile())) == null ? null : result2.getManager().findFile(file2);
    }

    @Nullable
    public static VirtualFile findIndexVirtualFile(String @NotNull [] extensions, @Nullable VirtualFile directory) {
        if (extensions == null) {
            JSFileReferencesUtil.$$$reportNull$$$0(28);
        }
        if (directory != null) {
            for (String ext : extensions) {
                VirtualFile child = directory.findChild("index" + ext);
                if (child == null) continue;
                return child;
            }
        }
        return null;
    }

    @NotNull
    public static Collection<PsiElement> mergeWithAugmentations(PsiElement context, Collection<PsiElement> modules) {
        Collection<PsiElement> augmentations = TypeScriptAugmentationUtil.getAugmentations(context, modules);
        if (augmentations.isEmpty()) {
            Collection<PsiElement> collection = modules;
            if (collection == null) {
                JSFileReferencesUtil.$$$reportNull$$$0(29);
            }
            return collection;
        }
        ArrayList<PsiElement> result2 = new ArrayList<PsiElement>(modules);
        result2.addAll(augmentations);
        ArrayList<PsiElement> arrayList = result2;
        if (arrayList == null) {
            JSFileReferencesUtil.$$$reportNull$$$0(30);
        }
        return arrayList;
    }

    public static PsiReference[] calcImportExportFromClauseReferences(@NotNull PsiElement element, @Nullable PsiReferenceProvider provider) {
        if (element == null) {
            JSFileReferencesUtil.$$$reportNull$$$0(31);
        }
        return INSTANCE.calcImportExportFromClauseReferencesImpl(element, provider);
    }

    protected PsiReference @NotNull [] calcImportExportFromClauseReferencesImpl(@NotNull PsiElement element, @Nullable PsiReferenceProvider provider) {
        Pair<String, PsiElement> pair;
        if (element == null) {
            JSFileReferencesUtil.$$$reportNull$$$0(32);
        }
        if ((pair = JSPsiImplUtils.getChildStringLiteralWithText(element)) == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                JSFileReferencesUtil.$$$reportNull$$$0(33);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        PsiElement literalExpression = (PsiElement)pair.second;
        String quotedText = (String)pair.first;
        PsiReference[] psiReferenceArray = JSFileReferencesUtil.createImportExportFromClauseReferences(element, literalExpression.getStartOffsetInParent() + 1, quotedText, provider);
        if (psiReferenceArray == null) {
            JSFileReferencesUtil.$$$reportNull$$$0(34);
        }
        return psiReferenceArray;
    }

    @Nullable
    public static String getShortestPathInContexts(@Nullable VirtualFile dstVFile, @NotNull Collection<? extends VirtualFile> contexts, boolean skipParent) {
        if (contexts == null) {
            JSFileReferencesUtil.$$$reportNull$$$0(35);
        }
        if (dstVFile == null || contexts.size() == 0) {
            return null;
        }
        String path = null;
        String parentDirPath = null;
        for (VirtualFile virtualFile : contexts) {
            String candidate;
            if (!VfsUtilCore.isAncestor((VirtualFile)virtualFile, (VirtualFile)dstVFile, (boolean)true) || StringUtil.isEmpty((String)(candidate = VfsUtilCore.getRelativePath((VirtualFile)dstVFile, (VirtualFile)virtualFile, (char)'/')))) continue;
            if (skipParent && virtualFile.equals(dstVFile.getParent())) {
                parentDirPath = candidate;
                continue;
            }
            path = path == null || path.length() > candidate.length() ? candidate : path;
        }
        return path == null ? parentDirPath : path;
    }

    public static boolean startWithLocalPrefix(@NotNull String text) {
        if (text == null) {
            JSFileReferencesUtil.$$$reportNull$$$0(36);
        }
        return text.startsWith("./") || text.startsWith("../");
    }

    @NotNull
    public static String getNodeModuleName(@NotNull String text) {
        String path;
        if (text == null) {
            JSFileReferencesUtil.$$$reportNull$$$0(37);
        }
        if (JSFileReferencesUtil.startWithLocalPrefix(path = JSStringUtil.unquoteStringLiteralValue(text.trim()))) {
            String string = path;
            if (string == null) {
                JSFileReferencesUtil.$$$reportNull$$$0(38);
            }
            return string;
        }
        String[] strings = path.split("/");
        if (strings.length > 1) {
            if (strings[0].startsWith("@")) {
                String string = strings[0] + "/" + strings[1];
                if (string == null) {
                    JSFileReferencesUtil.$$$reportNull$$$0(39);
                }
                return string;
            }
            String string = strings[0];
            if (string == null) {
                JSFileReferencesUtil.$$$reportNull$$$0(40);
            }
            return string;
        }
        String string = strings.length == 0 ? "" : strings[0];
        if (string == null) {
            JSFileReferencesUtil.$$$reportNull$$$0(41);
        }
        return string;
    }

    @NotNull
    public static PsiReferenceProvider getSimpleReferencesPathProvider(final String @NotNull [] extensions) {
        if (extensions == null) {
            JSFileReferencesUtil.$$$reportNull$$$0(42);
        }
        return new PsiReferenceProvider(){

            public PsiReference @NotNull [] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (context == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (element instanceof JsonStringLiteral) {
                    boolean isCaseSensitive = JSFileReferencesUtil.isCaseSensitive(element);
                    String value = ((JsonStringLiteral)element).getValue();
                    FileReference[] fileReferenceArray = new FileReferenceSet(value, element, 1, null, isCaseSensitive){

                        @NotNull
                        public Collection<PsiFileSystemItem> computeDefaultContexts() {
                            if (this.isAbsolutePathReference()) {
                                Collection collection = super.computeDefaultContexts();
                                if (collection == null) {
                                    1.$$$reportNull$$$0(0);
                                }
                                return collection;
                            }
                            Collection collection = this.getParentDirectoryContext();
                            if (collection == null) {
                                1.$$$reportNull$$$0(1);
                            }
                            return collection;
                        }

                        protected boolean isSoft() {
                            return true;
                        }

                        public FileReference createFileReference(TextRange range, int index, String text) {
                            return new JSFileReference(text, index, range, this, extensions){

                                @Override
                                protected boolean isAllowFolders() {
                                    return true;
                                }

                                @Override
                                public String[] getImplicitExtensions() {
                                    return extensions;
                                }
                            };
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ecmascript6/resolve/JSFileReferencesUtil$1$1", "computeDefaultContexts"));
                        }
                    }.getAllReferences();
                    if (fileReferenceArray == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    return fileReferenceArray;
                }
                if (PsiReference.EMPTY_ARRAY == null) {
                    1.$$$reportNull$$$0(3);
                }
                return PsiReference.EMPTY_ARRAY;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 2: 
                    case 3: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 2: 
                    case 3: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "context";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/lang/ecmascript6/resolve/JSFileReferencesUtil$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/lang/ecmascript6/resolve/JSFileReferencesUtil$1";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getReferencesByElement";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getReferencesByElement";
                        break;
                    }
                    case 2: 
                    case 3: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 2: 
                    case 3: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    public static boolean isAcceptableNodeModulesPackageName(@NotNull String moduleName) {
        if (moduleName == null) {
            JSFileReferencesUtil.$$$reportNull$$$0(43);
        }
        if (JSFileReferencesUtil.startWithLocalPrefix(moduleName)) {
            return false;
        }
        if (StringUtil.isEmptyOrSpaces((String)moduleName)) {
            return false;
        }
        boolean haveNamePartInWord = false;
        for (int i = 0; i < moduleName.length(); ++i) {
            char ch = moduleName.charAt(i);
            if (ch == '@' && i > 0) {
                return false;
            }
            boolean namePart = Character.isLetterOrDigit(ch) || ch == '_' || ch == '-' || ch == '@';
            haveNamePartInWord |= namePart;
            if (namePart || ch == '.' || ch == '/') continue;
            return false;
        }
        return haveNamePartInWord;
    }

    public static boolean isCaseSensitive(@NotNull PsiElement context) {
        VirtualFile file2;
        if (context == null) {
            JSFileReferencesUtil.$$$reportNull$$$0(44);
        }
        return (file2 = PsiUtilCore.getVirtualFile((PsiElement)context)) == null ? SystemInfo.isFileSystemCaseSensitive : file2.getFileSystem().isCaseSensitive();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 15: 
            case 18: 
            case 20: 
            case 29: 
            case 30: 
            case 33: 
            case 34: 
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 15: 
            case 18: 
            case 20: 
            case 29: 
            case 30: 
            case 33: 
            case 34: 
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "util";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceOwner";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 15: 
            case 18: 
            case 20: 
            case 29: 
            case 30: 
            case 33: 
            case 34: 
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/ecmascript6/resolve/JSFileReferencesUtil";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refText";
                break;
            }
            case 7: 
            case 31: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "quoted";
                break;
            }
            case 10: 
            case 11: 
            case 13: 
            case 16: 
            case 19: 
            case 23: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unquotedString";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "references";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 21: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 22: 
            case 27: 
            case 28: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensions";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contexts";
                break;
            }
            case 36: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/ecmascript6/resolve/JSFileReferencesUtil";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveModuleReferences";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveModuleReference";
                break;
            }
            case 15: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getMostPriorityModules";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtensions";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "mergeWithAugmentations";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "calcImportExportFromClauseReferencesImpl";
                break;
            }
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeModuleName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setInstance";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "resolveModuleReferences";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 15: 
            case 18: 
            case 20: 
            case 29: 
            case 30: 
            case 33: 
            case 34: 
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "resolveModuleReference";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getReferenceModuleText";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createImportExportFromClauseReferences";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isLibraryElement";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "calculateMainModules";
                break;
            }
            case 13: 
            case 14: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getMostPriorityModules";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getExtensions";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getModuleForPsiElement";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "isValidModule";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getReferenceWeight";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "findIndexFile";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "findIndexVirtualFile";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "calcImportExportFromClauseReferences";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "calcImportExportFromClauseReferencesImpl";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getShortestPathInContexts";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "startWithLocalPrefix";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getNodeModuleName";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getSimpleReferencesPathProvider";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "isAcceptableNodeModulesPackageName";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "isCaseSensitive";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 15: 
            case 18: 
            case 20: 
            case 29: 
            case 30: 
            case 33: 
            case 34: 
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

