/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.library.yarn;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.library.yarn.YarnPnpManager;
import com.intellij.javascript.nodejs.npm.NpmManager;
import com.intellij.javascript.nodejs.npm.NpmUtil;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.text.SemVer;
import java.io.IOException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class YarnPnpNodePackage
extends NodePackage {
    private static final Logger LOG = Logger.getInstance(YarnPnpNodePackage.class);
    private static final Key<Boolean> YARN_RUN_ADDED = Key.create((String)"yarn run configured");
    @NonNls
    private static final String YARN_SCHEME = "yarn:";
    private final String myRelativePathToPackageJson;
    private final String myPackageName;

    private YarnPnpNodePackage(@NotNull String url) {
        if (url == null) {
            YarnPnpNodePackage.$$$reportNull$$$0(0);
        }
        super(url);
        int packageNameDelimiterInd = url.lastIndexOf(58);
        if (packageNameDelimiterInd >= YARN_SCHEME.length()) {
            this.myRelativePathToPackageJson = url.substring(YARN_SCHEME.length(), packageNameDelimiterInd);
            this.myPackageName = url.substring(packageNameDelimiterInd + 1);
        } else {
            this.myRelativePathToPackageJson = url.substring(YARN_SCHEME.length());
            this.myPackageName = "";
        }
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myPackageName;
        if (string == null) {
            YarnPnpNodePackage.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public boolean nameMatches(@NotNull String packageName) {
        if (packageName == null) {
            YarnPnpNodePackage.$$$reportNull$$$0(2);
        }
        return this.myPackageName.equals(packageName);
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public boolean isValid(@NotNull Project project) {
        PackageJsonData data;
        VirtualFile packageJson;
        if (project == null) {
            YarnPnpNodePackage.$$$reportNull$$$0(3);
        }
        if ((packageJson = this.getPackageJson(project)) != null && (data = PackageJsonData.getOrCreate(packageJson)).isDependencyOfAnyType(this.myPackageName)) {
            return YarnPnpManager.getInstance(project).findInstalledPackageDir(packageJson, this.myPackageName) != null;
        }
        return false;
    }

    @Override
    @Nullable
    public SemVer getVersion(@Nullable Project project) {
        VirtualFile dependencyPackageJson;
        VirtualFile dependencyRoot;
        VirtualFile packageJson;
        VirtualFile virtualFile = packageJson = project != null ? this.getPackageJson(project) : null;
        if (packageJson != null && PackageJsonData.getOrCreate(packageJson).isDependencyOfAnyType(this.myPackageName) && (dependencyRoot = YarnPnpManager.getInstance(project).findInstalledPackageDir(packageJson, this.myPackageName)) != null && (dependencyPackageJson = PackageJsonUtil.findChildPackageJsonFile(dependencyRoot)) != null) {
            return PackageJsonData.getOrCreate(dependencyPackageJson).getVersion();
        }
        return null;
    }

    @Override
    @Nullable
    public String getErrorMessage(@NotNull String packageName) {
        if (packageName == null) {
            YarnPnpNodePackage.$$$reportNull$$$0(4);
        }
        String base = packageName + " package: Yarn-installed package format is 'yarn:[relative path to package.json]:[package name]'.";
        if (!this.myRelativePathToPackageJson.endsWith("package.json")) {
            return base + " No path to package.json found.";
        }
        if (this.myPackageName.isEmpty()) {
            return base + " Unspecified package name.";
        }
        return null;
    }

    @Nullable
    public String getPackageJsonPath(@NotNull Project project) {
        VirtualFile projectRoot;
        if (project == null) {
            YarnPnpNodePackage.$$$reportNull$$$0(5);
        }
        if ((projectRoot = ProjectUtil.guessProjectDir((Project)project)) != null) {
            return FileUtil.toSystemIndependentName((String)(projectRoot.getPath() + "/" + this.myRelativePathToPackageJson));
        }
        return null;
    }

    @Nullable
    public VirtualFile getPackageJson(@NotNull Project project) {
        String packageJsonPath;
        if (project == null) {
            YarnPnpNodePackage.$$$reportNull$$$0(6);
        }
        if ((packageJsonPath = this.getPackageJsonPath(project)) != null) {
            return LocalFileSystem.getInstance().findFileByPath(packageJsonPath);
        }
        return null;
    }

    public void addYarnRunToCommandLine(@NotNull GeneralCommandLine commandLine, @NotNull Project project, @Nullable NodeJsInterpreter interpreter, @Nullable String binaryName) throws ExecutionException {
        if (commandLine == null) {
            YarnPnpNodePackage.$$$reportNull$$$0(7);
        }
        if (project == null) {
            YarnPnpNodePackage.$$$reportNull$$$0(8);
        }
        this.addYarnRunToCommandLine(commandLine, project, interpreter, binaryName, true);
    }

    public void addYarnRunToCommandLine(@NotNull GeneralCommandLine commandLine, @NotNull Project project, @Nullable NodeJsInterpreter interpreter, @Nullable String binaryName, boolean canThrowExceptionWithHtml) throws ExecutionException {
        NodePackage yarnPkg;
        if (commandLine == null) {
            YarnPnpNodePackage.$$$reportNull$$$0(9);
        }
        if (project == null) {
            YarnPnpNodePackage.$$$reportNull$$$0(10);
        }
        if ((yarnPkg = NpmManager.getInstance(project).getPackage(interpreter)) == null) {
            throw new ExecutionException("Cannot find project Node.js package manager");
        }
        this.requireYarnPackageManager(project, NpmUtil.isYarnAlikePackage(yarnPkg), canThrowExceptionWithHtml);
        commandLine.addParameter(NpmUtil.getValidNpmCliJsFilePath(yarnPkg));
        commandLine.addParameter("run");
        commandLine.addParameter("--binaries-only");
        String resultBinaryName = binaryName != null ? binaryName : this.guessBinaryName(project);
        commandLine.addParameter(resultBinaryName);
        YARN_RUN_ADDED.set((UserDataHolder)commandLine, (Object)Boolean.TRUE);
    }

    @NotNull
    private String guessBinaryName(@NotNull Project project) {
        if (project == null) {
            YarnPnpNodePackage.$$$reportNull$$$0(11);
        }
        VirtualFile dependencyPackageJson = null;
        try {
            dependencyPackageJson = this.findDependencyPackageJson(project);
        }
        catch (IOException e) {
            LOG.info("Cannot find dependency package.json: " + e.getMessage());
        }
        String string = PackageJsonUtil.guessDefaultBinaryNameOfDependency(dependencyPackageJson, this.myPackageName);
        if (string == null) {
            YarnPnpNodePackage.$$$reportNull$$$0(12);
        }
        return string;
    }

    @NotNull
    private VirtualFile findDependencyPackageJson(@NotNull Project project) throws IOException {
        VirtualFile packageJson;
        if (project == null) {
            YarnPnpNodePackage.$$$reportNull$$$0(13);
        }
        if ((packageJson = this.getPackageJson(project)) == null) {
            throw new IOException("Cannot find package.json declaring " + this.toString());
        }
        VirtualFile dependencyRoot = YarnPnpManager.getInstance(project).findInstalledPackageDir(packageJson, this.myPackageName);
        if (dependencyRoot == null) {
            throw new IOException("Cannot find dependency root for " + this.toString() + " (" + packageJson + ")");
        }
        VirtualFile dependencyPackageJson = PackageJsonUtil.findChildPackageJsonFile(dependencyRoot);
        if (dependencyPackageJson == null) {
            throw new IOException("Cannot find package.json in " + dependencyRoot.getPath());
        }
        VirtualFile virtualFile = dependencyPackageJson;
        if (virtualFile == null) {
            YarnPnpNodePackage.$$$reportNull$$$0(14);
        }
        return virtualFile;
    }

    public void requireYarnPackageManager(@NotNull Project project, boolean yarnPackageManager, boolean htmlSupported) throws ExecutionException {
        if (project == null) {
            YarnPnpNodePackage.$$$reportNull$$$0(15);
        }
        if (!yarnPackageManager) {
            String suffix = htmlSupported ? "<a href=''>package manager</a>" : "package manager";
            throw new NpmManager.InvalidNpmPackageException(project, "Package \"" + this.getSystemIndependentPath() + "\" requires Yarn " + suffix + ".", null);
        }
    }

    public static boolean isWithYarnRun(@NotNull GeneralCommandLine commandLine) {
        if (commandLine == null) {
            YarnPnpNodePackage.$$$reportNull$$$0(16);
        }
        return YARN_RUN_ADDED.get((UserDataHolder)commandLine) == Boolean.TRUE;
    }

    @Nullable
    private String getDependencyPnpLocation(@NotNull Project project) {
        VirtualFile packageJson;
        if (project == null) {
            YarnPnpNodePackage.$$$reportNull$$$0(17);
        }
        if ((packageJson = this.getPackageJson(project)) == null) {
            return null;
        }
        return YarnPnpManager.getInstance(project).getDependencyRequireableLocation(packageJson, this.myPackageName);
    }

    @Override
    @Nullable
    public String getAbsolutePackagePathToRequire(@NotNull Project project) {
        if (project == null) {
            YarnPnpNodePackage.$$$reportNull$$$0(18);
        }
        return this.getDependencyPnpLocation(project);
    }

    @Nullable
    public static YarnPnpNodePackage createFromText(@NotNull String text) {
        if (text == null) {
            YarnPnpNodePackage.$$$reportNull$$$0(19);
        }
        if (text.startsWith(YARN_SCHEME)) {
            return new YarnPnpNodePackage(text);
        }
        return null;
    }

    @Nullable
    public static YarnPnpNodePackage create(@NotNull Project project, @NotNull VirtualFile packageJson, @NotNull String dependencyName, boolean checkIfUnderPnp, boolean checkIfDependencyIsDeclared) {
        if (project == null) {
            YarnPnpNodePackage.$$$reportNull$$$0(20);
        }
        if (packageJson == null) {
            YarnPnpNodePackage.$$$reportNull$$$0(21);
        }
        if (dependencyName == null) {
            YarnPnpNodePackage.$$$reportNull$$$0(22);
        }
        if (!PackageJsonUtil.isPackageJsonFile(packageJson)) {
            return null;
        }
        if (checkIfUnderPnp && !YarnPnpManager.getInstance(project).isUnderPnp(packageJson)) {
            return null;
        }
        if (checkIfDependencyIsDeclared && !PackageJsonData.getOrCreate(packageJson).isDependencyOfAnyType(dependencyName)) {
            return null;
        }
        VirtualFile projectRoot = ProjectUtil.guessProjectDir((Project)project);
        if (projectRoot == null) {
            return null;
        }
        String relativePathToPackageJson = VfsUtilCore.findRelativePath((VirtualFile)projectRoot, (VirtualFile)packageJson, (char)'/');
        if (relativePathToPackageJson == null) {
            return null;
        }
        return new YarnPnpNodePackage(YarnPnpNodePackage.constructUrl(relativePathToPackageJson, dependencyName));
    }

    @NotNull
    private static String constructUrl(@NotNull String relativePathToPackageJson, @NotNull String packageName) {
        if (relativePathToPackageJson == null) {
            YarnPnpNodePackage.$$$reportNull$$$0(23);
        }
        if (packageName == null) {
            YarnPnpNodePackage.$$$reportNull$$$0(24);
        }
        String string = YARN_SCHEME + relativePathToPackageJson + ":" + packageName;
        if (string == null) {
            YarnPnpNodePackage.$$$reportNull$$$0(25);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 12: 
            case 14: 
            case 25: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 12: 
            case 14: 
            case 25: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 1: 
            case 12: 
            case 14: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/library/yarn/YarnPnpNodePackage";
                break;
            }
            case 2: 
            case 4: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: 
            case 9: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageJson";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencyName";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePathToPackageJson";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/library/yarn/YarnPnpNodePackage";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "guessBinaryName";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "findDependencyPackageJson";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "constructUrl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 12: 
            case 14: 
            case 25: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "nameMatches";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isValid";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getErrorMessage";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getPackageJsonPath";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getPackageJson";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addYarnRunToCommandLine";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "guessBinaryName";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "findDependencyPackageJson";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "requireYarnPackageManager";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isWithYarnRun";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getDependencyPnpLocation";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getAbsolutePackagePathToRequire";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createFromText";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "constructUrl";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 12: 
            case 14: 
            case 25: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

