/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.nashorn.smartstep;

import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.actions.JvmSmartStepIntoHandler;
import com.intellij.debugger.actions.SmartStepTarget;
import com.intellij.debugger.engine.MethodFilter;
import com.intellij.javascript.debugger.nashorn.NashornPositionManagerFactory;
import com.intellij.javascript.debugger.nashorn.smartstep.JSSmartStepTarget;
import com.intellij.javascript.debugger.nashorn.smartstep.NashornMethodFilter;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSRecursiveWalkingElementVisitor;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.util.Range;
import com.intellij.util.containers.OrderedSet;
import com.intellij.util.text.CharArrayUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NashornSmartStepIntoHandler
extends JvmSmartStepIntoHandler {
    public boolean isAvailable(SourcePosition position) {
        return NashornPositionManagerFactory.Companion.isNashornApplicable(position);
    }

    @NotNull
    public List<SmartStepTarget> findSmartStepTargets(SourcePosition position) {
        int line = position.getLine();
        if (line < 0) {
            List<SmartStepTarget> list = Collections.emptyList();
            if (list == null) {
                NashornSmartStepIntoHandler.$$$reportNull$$$0(0);
            }
            return list;
        }
        PsiFile file = position.getFile();
        VirtualFile vFile = file.getVirtualFile();
        if (vFile == null) {
            List<SmartStepTarget> list = Collections.emptyList();
            if (list == null) {
                NashornSmartStepIntoHandler.$$$reportNull$$$0(1);
            }
            return list;
        }
        Document doc = FileDocumentManager.getInstance().getDocument(vFile);
        if (doc == null) {
            List<SmartStepTarget> list = Collections.emptyList();
            if (list == null) {
                NashornSmartStepIntoHandler.$$$reportNull$$$0(2);
            }
            return list;
        }
        if (line >= doc.getLineCount()) {
            List<SmartStepTarget> list = Collections.emptyList();
            if (list == null) {
                NashornSmartStepIntoHandler.$$$reportNull$$$0(3);
            }
            return list;
        }
        int startOffset = doc.getLineStartOffset(line);
        final TextRange lineRange = new TextRange(startOffset, doc.getLineEndOffset(line));
        int offset = CharArrayUtil.shiftForward((CharSequence)doc.getCharsSequence(), (int)startOffset, (String)" \t");
        PsiElement element = file.findElementAt(offset);
        if (element != null && !(element instanceof PsiCompiledElement)) {
            PsiElement parent;
            while ((parent = element.getParent()) != null && parent.getTextOffset() >= lineRange.getStartOffset()) {
                element = parent;
            }
            OrderedSet targets = new OrderedSet();
            Range lines = new Range((Comparable)Integer.valueOf(doc.getLineNumber(element.getTextOffset())), (Comparable)Integer.valueOf(doc.getLineNumber(element.getTextOffset() + element.getTextLength())));
            JSRecursiveWalkingElementVisitor methodCollector = new JSRecursiveWalkingElementVisitor((List)targets, lines){
                final /* synthetic */ List val$targets;
                final /* synthetic */ Range val$lines;
                {
                    this.val$targets = list;
                    this.val$lines = range;
                }

                public void visitJSStatement(JSStatement statement) {
                    if (lineRange.intersects(statement.getTextRange())) {
                        super.visitJSStatement(statement);
                    }
                }

                public void visitJSCallExpression(JSCallExpression expression) {
                    PsiElement resolve;
                    JSFunction function = null;
                    JSExpression methodExpression = expression.getMethodExpression();
                    if (methodExpression instanceof JSReferenceExpression && (resolve = ((JSReferenceExpression)methodExpression).resolve()) instanceof JSFunction) {
                        function = (JSFunction)resolve;
                    }
                    this.val$targets.add(new JSSmartStepTarget(expression.getMethodExpression().getText(), (PsiElement)expression, function, false, (Range<Integer>)this.val$lines));
                }
            };
            element.accept((PsiElementVisitor)methodCollector);
            for (PsiElement sibling = element.getNextSibling(); sibling != null && lineRange.intersects(sibling.getTextRange()); sibling = sibling.getNextSibling()) {
                sibling.accept((PsiElementVisitor)methodCollector);
            }
            OrderedSet orderedSet = targets;
            if (orderedSet == null) {
                NashornSmartStepIntoHandler.$$$reportNull$$$0(4);
            }
            return orderedSet;
        }
        List<SmartStepTarget> list = Collections.emptyList();
        if (list == null) {
            NashornSmartStepIntoHandler.$$$reportNull$$$0(5);
        }
        return list;
    }

    @Nullable
    protected MethodFilter createMethodFilter(SmartStepTarget stepTarget) {
        JSFunction function;
        if (stepTarget instanceof JSSmartStepTarget && (function = ((JSSmartStepTarget)stepTarget).getFunction()) != null) {
            return new NashornMethodFilter(function, (Range<Integer>)stepTarget.getCallingExpressionLines());
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/debugger/nashorn/smartstep/NashornSmartStepIntoHandler", "findSmartStepTargets"));
    }
}

