/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webcore.libraries.ui;

import a.g.lb;
import com.intellij.DynamicBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.table.JBTable;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.download.DownloadableFileSetDescription;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.SwingHelper;
import com.intellij.webcore.ModuleHelper;
import com.intellij.webcore.WebCoreBundle;
import com.intellij.webcore.libraries.LangScriptingContextProvider;
import com.intellij.webcore.libraries.ScriptingLibraryManager;
import com.intellij.webcore.libraries.ScriptingLibraryMappings;
import com.intellij.webcore.libraries.ScriptingLibraryModel;
import com.intellij.webcore.libraries.ui.EditLibraryDialog;
import com.intellij.webcore.libraries.ui.ModuleScopeSelectionDialog;
import com.intellij.webcore.libraries.ui.PartlySelectedCheckBoxEditor;
import com.intellij.webcore.libraries.ui.PartlySelectedCheckBoxRenderer;
import com.intellij.webcore.libraries.ui.PerFileMappingsDialogWrapper;
import com.intellij.webcore.libraries.ui.ScriptingContextsConfigurable;
import com.intellij.webcore.libraries.ui.ScriptingLibraryTableModel;
import com.intellij.webcore.libraries.ui.download.DownloadWebLibraryDialog;
import com.intellij.webcore.libraries.ui.download.DownloadableFileSetDescriptionWithUrl;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScriptingLibrariesPanel {
    private JPanel a;
    private JButton b;
    private JButton l;
    private JButton g;
    private JPanel m;
    private JBTable i;
    private JButton f;
    private JButton h;
    private boolean k;
    private final Project j;
    private final LangScriptingContextProvider n;
    private final ScriptingLibraryManager e;
    private final ScriptingLibraryMappings c;
    private final ScriptingLibraryTableModel d;
    private static final long o = lb.a(8032491843652230200L, 1956926942370901435L, MethodHandles.lookup().lookupClass()).a(195085758482514L);

    public ScriptingLibrariesPanel(@NotNull LangScriptingContextProvider provider, @NotNull Project project, @NotNull ScriptingLibraryManager libraryManager) {
        long l2 = o ^ 0x7285E7DC8A7FL;
        if (provider == null) {
            ScriptingLibrariesPanel.a(0);
        }
        if (project == null) {
            ScriptingLibrariesPanel.a(1);
        }
        if (libraryManager == null) {
            ScriptingLibrariesPanel.a(2);
        }
        this.k = false;
        this.j = project;
        this.n = provider;
        this.b();
        this.c = provider.getLibraryMappings(project);
        this.e = libraryManager;
        this.d = new ScriptingLibraryTableModel(libraryManager, this.c);
        this.i.setModel((TableModel)this.d);
        this.i.setRowHeight((int)((double)this.i.getRowHeight() * 1.2));
        JTableHeader jTableHeader = this.i.getTableHeader();
        jTableHeader.setReorderingAllowed(false);
        TableColumn tableColumn = this.i.getColumnModel().getColumn(0);
        ScriptingLibrariesPanel.setColumnWidth(tableColumn, ScriptingLibrariesPanel.a(jTableHeader, tableColumn));
        tableColumn.setCellRenderer(new PartlySelectedCheckBoxRenderer());
        tableColumn.setCellEditor(new PartlySelectedCheckBoxEditor(this));
        this.i.getColumnModel().getColumn(1).setCellRenderer(new LibraryNameCellRenderer());
        SwingHelper.setNoBorderCellRendererFor((TableColumn)this.i.getColumnModel().getColumn(1));
        int n2 = this.i.getFontMetrics(this.i.getFont()).stringWidth(ScriptingLibraryTableModel.getLongestLibraryLevelName()) + JBUIScale.scale((int)10);
        ScriptingLibrariesPanel.setColumnWidth(this.i.getColumnModel().getColumn(2), n2);
        this.i.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e10) {
                if (e10.getKeyChar() == ' ') {
                    int[] nArray = ScriptingLibrariesPanel.this.i.getSelectedRows();
                    boolean bl2 = true;
                    for (int n2 : nArray) {
                        if (ScriptingLibraryTableModel.EnabledState.ON == ScriptingLibrariesPanel.this.d.getValueAt(n2, 0)) continue;
                        bl2 = false;
                    }
                    for (int n2 : nArray) {
                        if (!bl2 && ScriptingLibraryTableModel.EnabledState.ON != ScriptingLibrariesPanel.this.d.getValueAt(n2, 0)) {
                            ScriptingLibrariesPanel.this.d.setValueAt(Boolean.TRUE, n2, 0);
                            continue;
                        }
                        if (!bl2) continue;
                        ScriptingLibrariesPanel.this.d.setValueAt(Boolean.FALSE, n2, 0);
                    }
                }
            }
        });
        this.f.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e10) {
                ScriptingLibrariesPanel.this.a(ScriptingLibrariesPanel.this.getPanel());
            }
        });
        this.h.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e10) {
                ScriptingLibrariesPanel.this.d();
            }
        });
        this.m.setBorder((Border)IdeBorderFactory.createTitledBorder((String)WebCoreBundle.message((String)"library.table.border.title", (Object[])new Object[0]), (boolean)false, (Insets)JBUI.insetsTop((int)8)).setShowLine(false));
        this.b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e10) {
                ScriptingLibraryModel scriptingLibraryModel = ScriptingLibrariesPanel.this.e();
                if (scriptingLibraryModel != null) {
                    ScriptingLibrariesPanel.this.selectLibrary(scriptingLibraryModel.getName());
                }
            }
        });
        this.l.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e10) {
                int[] nArray = ScriptingLibrariesPanel.this.i.getSelectedRows();
                ArrayList<ScriptingLibraryModel> arrayList = new ArrayList<ScriptingLibraryModel>();
                for (int n2 : nArray) {
                    ScriptingLibraryModel scriptingLibraryModel = ScriptingLibrariesPanel.this.d.getLibraryAt(n2);
                    if (scriptingLibraryModel == null || scriptingLibraryModel.isPredefined()) continue;
                    arrayList.add(scriptingLibraryModel);
                }
                Object object = arrayList.iterator();
                while (object.hasNext()) {
                    ScriptingLibraryModel scriptingLibraryModel = (ScriptingLibraryModel)object.next();
                    ScriptingLibrariesPanel.this.c(scriptingLibraryModel.getName());
                }
            }
        });
        this.g.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e10) {
                String string = ScriptingLibrariesPanel.this.d.getLibNameAt(ScriptingLibrariesPanel.this.i.getSelectedRow());
                ScriptingLibrariesPanel.this.b(string);
            }
        });
        this.l.setEnabled(false);
        this.g.setEnabled(false);
        this.i.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e10) {
                ScriptingLibrariesPanel.this.c();
            }
        });
        this.i.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e10) {
                ScriptingLibraryModel scriptingLibraryModel;
                int n2;
                if (e10.getClickCount() == 2 && (n2 = ScriptingLibrariesPanel.this.i.getSelectedRow()) != -1 && (scriptingLibraryModel = ScriptingLibrariesPanel.this.d.getLibraryAt(ScriptingLibrariesPanel.this.i.getSelectedRow())) != null && !scriptingLibraryModel.isPredefined()) {
                    ScriptingLibrariesPanel.this.b(scriptingLibraryModel.getName());
                }
            }
        });
    }

    private static int a(@NotNull JTableHeader jTableHeader, @NotNull TableColumn tableColumn) {
        TableCellRenderer tableCellRenderer;
        if (jTableHeader == null) {
            ScriptingLibrariesPanel.a(3);
        }
        if (tableColumn == null) {
            ScriptingLibrariesPanel.a(4);
        }
        if ((tableCellRenderer = tableColumn.getHeaderRenderer()) == null) {
            tableCellRenderer = jTableHeader.getDefaultRenderer();
        }
        Component component = tableCellRenderer.getTableCellRendererComponent(jTableHeader.getTable(), tableColumn.getHeaderValue(), false, false, -1, tableColumn.getModelIndex());
        int n2 = component.getPreferredSize().width;
        if (component instanceof JComponent) {
            Insets insets = ((JComponent)component).getInsets();
            n2 += Math.max(0, insets.left - insets.right);
        }
        return n2;
    }

    static void setColumnWidth(@NotNull TableColumn column, int width) {
        if (column == null) {
            ScriptingLibrariesPanel.a(5);
        }
        column.setPreferredWidth(width);
        column.setMaxWidth(width);
    }

    @NotNull
    public JPanel getPanel() {
        JPanel jPanel = this.a;
        if (jPanel == null) {
            ScriptingLibrariesPanel.a(6);
        }
        return jPanel;
    }

    private void c(String string) {
        ApplicationManager.getApplication().runWriteAction(() -> this.d.removeLibrary(string));
    }

    private ScriptingLibraryModel e() {
        long l2 = o ^ 0x284264EEC1C1L;
        EditLibraryDialog editLibraryDialog = new EditLibraryDialog(WebCoreBundle.message((String)"library.table.new.dialog.title", (Object[])new Object[0]), this.n, this.j);
        if (editLibraryDialog.showAndGet()) {
            ScriptingLibraryModel scriptingLibraryModel = this.d.createLibrary(editLibraryDialog.getLibName(), VirtualFile.EMPTY_ARRAY, VirtualFile.EMPTY_ARRAY, editLibraryDialog.getDocUrls(), editLibraryDialog.getLibraryLevel(), false);
            scriptingLibraryModel.setSourceFileUrls(editLibraryDialog.getSourceFileUrls());
            scriptingLibraryModel.setCompactFileUrls(editLibraryDialog.getCompactFileUrls());
            scriptingLibraryModel.setFrameworkDescriptor(editLibraryDialog.getSelectedFramework());
            return scriptingLibraryModel;
        }
        return null;
    }

    private void c() {
        int[] nArray;
        boolean bl2;
        int n2 = this.i.getSelectedRowCount();
        boolean bl3 = bl2 = n2 == 1;
        if (bl2) {
            ScriptingLibraryModel scriptingLibraryModel = this.d.getLibraryAt(this.i.getSelectedRow());
            bl2 = scriptingLibraryModel != null && !scriptingLibraryModel.isPredefined();
        }
        this.g.setEnabled(bl2);
        boolean bl4 = n2 > 0;
        for (int n3 : nArray = this.i.getSelectedRows()) {
            ScriptingLibraryModel scriptingLibraryModel = this.d.getLibraryAt(n3);
            if (scriptingLibraryModel == null || !scriptingLibraryModel.isPredefined()) continue;
            bl4 = false;
            break;
        }
        this.l.setEnabled(bl4);
    }

    private void b(String string) {
        ScriptingLibraryModel scriptingLibraryModel;
        EditLibraryDialog editLibraryDialog;
        long l2 = o ^ 0x6E01D0026F9L;
        if (string == null) {
            return;
        }
        ScriptingLibraryModel scriptingLibraryModel2 = this.d.getLibrary(string);
        if (scriptingLibraryModel2 != null && (editLibraryDialog = new EditLibraryDialog(WebCoreBundle.message((String)"library.table.edit.dialog.title", (Object[])new Object[0]), this.n, this.j, scriptingLibraryModel2)).showAndGet() && (scriptingLibraryModel = this.d.updateLibrary(string, editLibraryDialog.getLibName(), VirtualFile.EMPTY_ARRAY, VirtualFile.EMPTY_ARRAY, editLibraryDialog.getDocUrls())) != null) {
            scriptingLibraryModel.setSourceFileUrls(editLibraryDialog.getSourceFileUrls());
            scriptingLibraryModel.setCompactFileUrls(editLibraryDialog.getCompactFileUrls());
            scriptingLibraryModel.setFrameworkDescriptor(editLibraryDialog.getSelectedFramework());
            scriptingLibraryModel.setLibraryLevel(editLibraryDialog.getLibraryLevel());
        }
    }

    public boolean isModified() {
        return this.d.isChanged() || this.k;
    }

    public void resetTable() {
        this.d.resetTable();
        this.k = false;
    }

    public void apply() {
        this.c.updateAssociations(() -> this.g());
    }

    private void g() {
        this.d.applyChanges();
        Map map2 = this.c.getMappings();
        for (ScriptingLibraryModel scriptingLibraryModel : map2.values()) {
            if (!(scriptingLibraryModel instanceof ScriptingLibraryMappings.CompoundLibrary)) continue;
            ((ScriptingLibraryMappings.CompoundLibrary)scriptingLibraryModel).applyChanges();
        }
    }

    private void a(@NotNull Component component) {
        DownloadWebLibraryDialog downloadWebLibraryDialog;
        if (component == null) {
            ScriptingLibrariesPanel.a(7);
        }
        if ((downloadWebLibraryDialog = new DownloadWebLibraryDialog(this.j, this.n)).showAndGet()) {
            DownloadableFileSetDescriptionWithUrl downloadableFileSetDescriptionWithUrl = downloadWebLibraryDialog.getSelection();
            if (downloadableFileSetDescriptionWithUrl == null) {
                return;
            }
            if (this.isModified()) {
                WriteAction.run(() -> {
                    this.apply();
                    this.e.commitChanges();
                });
            }
            downloadableFileSetDescriptionWithUrl.downloadLibrary(this.j, this.n, component, () -> this.a((DownloadableFileSetDescription)downloadableFileSetDescriptionWithUrl));
        }
    }

    private void a(DownloadableFileSetDescription downloadableFileSetDescription) {
        this.d.fireLibTableChanged(true);
        String string = LangScriptingContextProvider.getIdeLibraryName(downloadableFileSetDescription);
        this.selectLibrary(string);
        if (ModuleHelper.getModules((Project)this.j).length > 1) {
            this.configureModules();
        }
    }

    protected void selectLibrary(String libName) {
        int n2 = this.d.getLibraryIndex(libName);
        if (n2 >= 0) {
            this.i.getSelectionModel().setSelectionInterval(n2, n2);
        }
    }

    private void d() {
        long l2 = o ^ 0x325B90478263L;
        this.d.applyMappings();
        ScriptingContextsConfigurable scriptingContextsConfigurable = new ScriptingContextsConfigurable(this.j, this.c);
        PerFileMappingsDialogWrapper perFileMappingsDialogWrapper = new PerFileMappingsDialogWrapper(this.getPanel(), scriptingContextsConfigurable);
        perFileMappingsDialogWrapper.setTitle(WebCoreBundle.message((String)"library.usage_scope.dialog.title", (Object[])new Object[]{this.n.getLanguage().getDisplayName()}));
        if (perFileMappingsDialogWrapper.showAndGet() && scriptingContextsConfigurable.isModified()) {
            this.k = true;
            this.d.fireLibTableChanged(false);
        }
    }

    int configureModules() {
        String string;
        ScriptingLibraryModel scriptingLibraryModel;
        if (ModuleHelper.getModules((Project)this.j).length == 1) {
            return -1;
        }
        int n2 = this.i.getSelectedRow();
        if (n2 >= 0 && (scriptingLibraryModel = this.e.getLibraryByName(string = this.d.getLibNameAt(n2))) != null) {
            if (scriptingLibraryModel.isPredefined()) {
                return -1;
            }
            ModuleScopeSelectionDialog moduleScopeSelectionDialog = new ModuleScopeSelectionDialog(this.j, scriptingLibraryModel.getAssociatedModules(), null, scriptingLibraryModel.getName());
            if (moduleScopeSelectionDialog.showAndGet()) {
                Set<Module> set = moduleScopeSelectionDialog.getSelectedModules();
                if (!scriptingLibraryModel.getAssociatedModules().equals(set)) {
                    scriptingLibraryModel.setAssociatedModules(set);
                    this.c.updateMappings();
                    this.k = true;
                }
                return set.size();
            }
            return scriptingLibraryModel.getAssociatedModules().size();
        }
        return -1;
    }

    private static boolean a(@Nullable ScriptingLibraryModel scriptingLibraryModel) {
        if (scriptingLibraryModel == null) {
            return false;
        }
        return scriptingLibraryModel.getSourceFilePointers().stream().allMatch(virtualFilePointer -> virtualFilePointer.getFile() != null) && scriptingLibraryModel.getCompactFilePointers().stream().allMatch(virtualFilePointer -> virtualFilePointer.getFile() != null);
    }

    private /* synthetic */ void b() {
        JButton jButton;
        JButton jButton2;
        JButton jButton3;
        JButton jButton4;
        JButton jButton5;
        JBTable jBTable;
        JPanel jPanel;
        JPanel jPanel2;
        long l2 = o ^ 0x465C8C0118C7L;
        this.a = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.m = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(7, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel2.add((Component)jPanel, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel.add((Component)jBScrollPane, new GridConstraints(0, 0, 7, 1, 0, 3, 7, 7, null, null, null));
        this.i = jBTable = new JBTable();
        jBTable.setStriped(true);
        jBScrollPane.setViewportView((Component)jBTable);
        this.b = jButton5 = new JButton();
        this.a(jButton5, DynamicBundle.getBundle((String)"messages/WebCoreBundle", ScriptingLibrariesPanel.class).getString("scripting.lib.add"));
        jPanel.add((Component)jButton5, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        this.l = jButton4 = new JButton();
        this.a(jButton4, DynamicBundle.getBundle((String)"messages/WebCoreBundle", ScriptingLibrariesPanel.class).getString("scripting.lib.remove"));
        jPanel.add((Component)jButton4, new GridConstraints(2, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        this.g = jButton3 = new JButton();
        this.a(jButton3, DynamicBundle.getBundle((String)"messages/WebCoreBundle", ScriptingLibrariesPanel.class).getString("scripting.lib.edit"));
        jPanel.add((Component)jButton3, new GridConstraints(1, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(6, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        this.f = jButton2 = new JButton();
        this.a(jButton2, DynamicBundle.getBundle((String)"messages/WebCoreBundle", ScriptingLibrariesPanel.class).getString("library.action.download.name"));
        jButton2.setToolTipText(ResourceBundle.getBundle("messages/WebCoreBundle").getString("library.action.download.tooltip"));
        jPanel.add((Component)jButton2, new GridConstraints(3, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        this.h = jButton = new JButton();
        this.a(jButton, DynamicBundle.getBundle((String)"messages/WebCoreBundle", ScriptingLibrariesPanel.class).getString("library.action.manage_scopes.name"));
        jPanel.add((Component)jButton, new GridConstraints(5, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(4, 1, 1, 1, 0, 2, 1, 0, null, new Dimension(-1, 10), null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.a;
    }

    private /* synthetic */ void a(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl2 = false;
        char c10 = '\u0000';
        int n2 = -1;
        for (int i10 = 0; i10 < string.length(); ++i10) {
            if (string.charAt(i10) == '&') {
                if (++i10 == string.length()) break;
                if (!bl2 && string.charAt(i10) != '&') {
                    bl2 = true;
                    c10 = string.charAt(i10);
                    n2 = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i10));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl2) {
            abstractButton.setMnemonic(c10);
            abstractButton.setDisplayedMnemonicIndex(n2);
        }
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = o ^ 0x68BDE84BDC33L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 6: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryManager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tableHeader";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/webcore/libraries/ui/ScriptingLibrariesPanel";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notificationAreaComponent";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/webcore/libraries/ui/ScriptingLibrariesPanel";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getPanel";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getMinimumWidthToFitColumnTitle";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setColumnWidth";
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "showDownloadDialog";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class LibraryNameCellRenderer
    extends DefaultTableCellRenderer {
        private LibraryNameCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            ScriptingLibraryModel scriptingLibraryModel;
            boolean bl2;
            this.setForeground(null);
            Component component = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (row >= 0 && row < ScriptingLibrariesPanel.this.d.getRowCount() && !(bl2 = ScriptingLibrariesPanel.a(scriptingLibraryModel = ScriptingLibrariesPanel.this.d.getLibraryAt(row))) && !isSelected) {
                this.setForeground((Color)JBColor.red);
            }
            return component;
        }
    }
}

