/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dupLocator.treeHash;

import a.g.lb;
import com.intellij.dupLocator.DupInfo;
import com.intellij.dupLocator.DuplicatesProfile;
import com.intellij.dupLocator.DuplicatesProfileCache;
import com.intellij.dupLocator.DuplocatorState;
import com.intellij.dupLocator.NodeSpecificHasher;
import com.intellij.dupLocator.treeHash.FragmentsCollector;
import com.intellij.dupLocator.treeHash.GroupNodeDescription;
import com.intellij.dupLocator.util.DuplocatorUtil;
import com.intellij.dupLocator.util.PsiFragment;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.usageView.UsageInfo;
import com.thoughtworks.xstream.io.xml.PrettyPrintWriter;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TIntObjectProcedure;
import gnu.trove.TObjectIntHashMap;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.lang.invoke.MethodHandles;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DuplocatorHashCallback
implements FragmentsCollector {
    private static final Logger c;
    private TIntObjectHashMap<List<List<PsiFragment>>> d = new TIntObjectHashMap();
    private final int e;
    private boolean b = false;
    private final int a;
    private static final long f;

    public DuplocatorHashCallback(int bound, int discardCost) {
        this.e = bound;
        this.a = discardCost;
    }

    public DuplocatorHashCallback(int bound, int discardCost, boolean readOnly) {
        this(bound, discardCost);
        this.b = readOnly;
    }

    public DuplocatorHashCallback(int lowerBound) {
        this(lowerBound, 0);
    }

    public void setReadOnly(boolean readOnly) {
        this.b = readOnly;
    }

    public void add(int hash, int cost, PsiFragment frag, NodeSpecificHasher visitor) {
        this.a(hash, cost, frag);
    }

    private void a(int n2, int n3, PsiFragment psiFragment) {
        Object object;
        if (psiFragment == null) {
            this.d.put(n2, new ArrayList());
            return;
        }
        psiFragment.setCost(n3);
        List list2 = (List)this.d.get(n2);
        if (list2 == null) {
            if (!this.b) {
                ArrayList arrayList = new ArrayList();
                ArrayList<PsiFragment> arrayList2 = new ArrayList<PsiFragment>();
                arrayList2.add(psiFragment);
                arrayList.add(arrayList2);
                this.d.put(n2, arrayList);
            }
            return;
        }
        boolean bl2 = false;
        PsiElement[] psiElementArray = psiFragment.getElements();
        int n4 = 0;
        if (this.a >= 0) {
            n4 = this.a;
        } else {
            object = DuplocatorUtil.getDuplocatorState(psiFragment);
            if (object != null) {
                n4 = object.getDiscardCost();
            }
        }
        object = list2.iterator();
        while (object.hasNext() && !bl2) {
            List list3 = (List)object.next();
            PsiFragment psiFragment2 = (PsiFragment)list3.get(0);
            if (!psiFragment2.isEqual(psiElementArray, n4)) continue;
            boolean bl3 = false;
            Iterator iterator = list3.iterator();
            while (iterator.hasNext() && !bl3) {
                PsiFragment psiFragment3 = (PsiFragment)iterator.next();
                if (!psiFragment.intersectsWith(psiFragment3)) continue;
                if (psiFragment3.getCost() < psiFragment.getCost() || psiFragment.contains(psiFragment3)) {
                    iterator.remove();
                    continue;
                }
                bl3 = true;
            }
            if (!bl3) {
                list3.add(psiFragment);
            }
            bl2 = true;
        }
        if (!bl2) {
            object = new ArrayList<PsiFragment>();
            object.add(psiFragment);
            list2.add(object);
        }
    }

    @Override
    public void add(int hash, int cost, PsiFragment frag) {
        int n2;
        if (this.e >= 0) {
            n2 = this.e;
        } else {
            DuplocatorState duplocatorState = DuplocatorUtil.getDuplocatorState(frag);
            if (duplocatorState == null) {
                return;
            }
            n2 = duplocatorState.getLowerBound();
        }
        if (cost >= n2) {
            this.a(hash, cost, frag);
        }
    }

    public DupInfo getInfo() {
        final TObjectIntHashMap tObjectIntHashMap = new TObjectIntHashMap();
        this.d.forEachEntry((TIntObjectProcedure)new TIntObjectProcedure<List<List<PsiFragment>>>(){

            public boolean execute(int hash, List<List<PsiFragment>> listList) {
                for (List<PsiFragment> list2 : listList) {
                    int n2 = list2.size();
                    if (n2 <= 1) continue;
                    PsiFragment[] psiFragmentArray = new PsiFragment[n2];
                    int n3 = 0;
                    for (PsiFragment psiFragment : list2) {
                        psiFragment.markDuplicate();
                        psiFragmentArray[n3++] = psiFragment;
                    }
                    tObjectIntHashMap.put((Object)psiFragmentArray, hash);
                }
                return true;
            }
        });
        this.d = null;
        final Object[] objectArray = tObjectIntHashMap.iterator();
        while (objectArray.hasNext()) {
            objectArray.advance();
            PsiFragment[] psiFragmentArray = (PsiFragment[])objectArray.key();
            c.assertTrue(psiFragmentArray.length > 1);
            boolean bl2 = false;
            for (PsiFragment psiFragment : psiFragmentArray) {
                if (!psiFragment.isNested()) continue;
                bl2 = true;
                break;
            }
            if (!bl2) continue;
            objectArray.remove();
        }
        objectArray = tObjectIntHashMap.keys();
        Arrays.sort(objectArray, (object, object2) -> ((PsiFragment[])object2)[0].getCost() - ((PsiFragment[])object)[0].getCost());
        return new DupInfo(){
            private final TIntObjectHashMap<GroupNodeDescription> a = new TIntObjectHashMap();
            private static final long b = lb.a(2720850516528023126L, -8006641753297263005L, MethodHandles.lookup().lookupClass()).a(58586058941876L);

            @Override
            public int getPatterns() {
                return objectArray.length;
            }

            @Override
            public int getPatternCost(int number) {
                return ((PsiFragment[])objectArray[number])[0].getCost();
            }

            @Override
            public int getPatternDensity(int number) {
                return ((PsiFragment[])objectArray[number]).length;
            }

            @Override
            public PsiFragment[] getFragmentOccurences(int pattern) {
                return (PsiFragment[])objectArray[pattern];
            }

            @Override
            public UsageInfo[] getUsageOccurences(int pattern) {
                PsiFragment[] psiFragmentArray = this.getFragmentOccurences(pattern);
                UsageInfo[] usageInfoArray = new UsageInfo[psiFragmentArray.length];
                for (int i10 = 0; i10 < usageInfoArray.length; ++i10) {
                    usageInfoArray[i10] = psiFragmentArray[i10].getUsageInfo();
                }
                return usageInfoArray;
            }

            @Override
            public int getFileCount(int pattern) {
                if (this.a.containsKey(pattern)) {
                    return ((GroupNodeDescription)this.a.get(pattern)).getFilesCount();
                }
                return this.a(pattern).getFilesCount();
            }

            private GroupNodeDescription a(int n2) {
                Object object;
                PsiFragment[] psiFragmentArray;
                long l2 = b ^ 0x1C205A94CCF8L;
                HashSet<PsiFile> hashSet = new HashSet<PsiFile>();
                for (PsiFragment object22 : psiFragmentArray = this.getFragmentOccurences(n2)) {
                    object = object22.getFile();
                    if (object == null) continue;
                    hashSet.add((PsiFile)object);
                }
                int n3 = hashSet.size();
                PsiFile psiFile = psiFragmentArray[0].getFile();
                DuplicatesProfile duplicatesProfile = DuplicatesProfileCache.getProfile(this, n2);
                String string = duplicatesProfile != null ? duplicatesProfile.getComment(this, n2) : "";
                object = new GroupNodeDescription(n3, psiFile != null ? psiFile.getName() : "unknown", string);
                this.a.put(n2, object);
                return object;
            }

            @Override
            @Nullable
            public String getTitle(int pattern) {
                if (this.getFileCount(pattern) == 1) {
                    if (this.a.containsKey(pattern)) {
                        return ((GroupNodeDescription)this.a.get(pattern)).getTitle();
                    }
                    return this.a(pattern).getTitle();
                }
                return null;
            }

            @Override
            @Nullable
            public String getComment(int pattern) {
                if (this.getFileCount(pattern) == 1) {
                    if (this.a.containsKey(pattern)) {
                        return ((GroupNodeDescription)this.a.get(pattern)).getComment();
                    }
                    return this.a(pattern).getComment();
                }
                return null;
            }

            @Override
            public int getHash(int i10) {
                return tObjectIntHashMap.get((Object)((PsiFragment[])objectArray[i10]));
            }
        };
    }

    public void report(@NotNull Path dir, @NotNull Project project) throws IOException {
        long l2 = f ^ 0x1BBE8D4FD2F9L;
        if (dir == null) {
            DuplocatorHashCallback.a(0);
        }
        if (project == null) {
            DuplocatorHashCallback.a(1);
        }
        int[] nArray = this.d.keys();
        try (BufferedWriter bufferedWriter = Files.newBufferedWriter(dir.resolve("fragments.xml"), new OpenOption[0]);){
            PrettyPrintWriter prettyPrintWriter = new PrettyPrintWriter((Writer)bufferedWriter);
            prettyPrintWriter.startNode("root");
            for (int n2 : nArray) {
                List list2 = (List)this.d.get(n2);
                prettyPrintWriter.startNode("hash");
                prettyPrintWriter.addAttribute("val", String.valueOf(n2));
                for (List list3 : list2) {
                    DuplocatorHashCallback.a(list3, prettyPrintWriter, project, false);
                }
                prettyPrintWriter.endNode();
            }
            prettyPrintWriter.endNode();
            prettyPrintWriter.flush();
        }
        DuplocatorHashCallback.writeDuplicates(dir, project, this.getInfo());
    }

    public static void writeDuplicates(@NotNull Path dir, @NotNull Project project, DupInfo info) throws IOException {
        long l2 = f ^ 0x42F691DB8E1CL;
        if (dir == null) {
            DuplocatorHashCallback.a(2);
        }
        if (project == null) {
            DuplocatorHashCallback.a(3);
        }
        try (BufferedWriter bufferedWriter = Files.newBufferedWriter(dir.resolve("duplicates.xml"), new OpenOption[0]);){
            PrettyPrintWriter prettyPrintWriter = new PrettyPrintWriter((Writer)bufferedWriter);
            prettyPrintWriter.startNode("root");
            int n2 = info.getPatterns();
            for (int i10 = 0; i10 < n2; ++i10) {
                prettyPrintWriter.startNode("duplicate");
                prettyPrintWriter.addAttribute("cost", String.valueOf(info.getPatternCost(i10)));
                prettyPrintWriter.addAttribute("hash", String.valueOf(info.getHash(i10)));
                DuplocatorHashCallback.a(Arrays.asList(info.getFragmentOccurences(i10)), prettyPrintWriter, project, true);
                prettyPrintWriter.endNode();
            }
            prettyPrintWriter.endNode();
            prettyPrintWriter.flush();
        }
    }

    private static void a(List<? extends PsiFragment> list2, PrettyPrintWriter prettyPrintWriter, @NotNull Project project, boolean bl2) {
        long l2 = f ^ 0x5AC68719CDC9L;
        if (project == null) {
            DuplocatorHashCallback.a(4);
        }
        PathMacroManager pathMacroManager = PathMacroManager.getInstance((ComponentManager)project);
        PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)project);
        for (PsiFragment psiFragment : list2) {
            PsiFile psiFile = psiFragment.getFile();
            VirtualFile virtualFile = psiFile != null ? psiFile.getVirtualFile() : null;
            if (virtualFile == null) continue;
            prettyPrintWriter.startNode("fragment");
            prettyPrintWriter.addAttribute("file", pathMacroManager.collapsePath(virtualFile.getUrl()));
            if (bl2) {
                Document document = psiDocumentManager.getDocument(psiFile);
                c.assertTrue(document != null);
                int n2 = psiFragment.getStartOffset();
                int n3 = document.getLineNumber(n2);
                prettyPrintWriter.addAttribute("line", String.valueOf(n3));
                int n4 = document.getLineStartOffset(n3);
                if (StringUtil.isEmptyOrSpaces((String)document.getText().substring(n4, n2))) {
                    n2 = n4;
                }
                prettyPrintWriter.addAttribute("start", String.valueOf(n2));
                prettyPrintWriter.addAttribute("end", String.valueOf(psiFragment.getEndOffset()));
                if (psiFragment.containsMultipleFragments()) {
                    int[][] nArray;
                    for (int[] nArray2 : nArray = psiFragment.getOffsets()) {
                        prettyPrintWriter.startNode("offset");
                        prettyPrintWriter.addAttribute("start", String.valueOf(nArray2[0]));
                        prettyPrintWriter.addAttribute("end", String.valueOf(nArray2[1]));
                        prettyPrintWriter.endNode();
                    }
                }
            }
            prettyPrintWriter.endNode();
        }
    }

    static {
        f = lb.a(8298610644856122399L, 8418170053562232614L, MethodHandles.lookup().lookupClass()).a(170442588760228L);
        c = Logger.getInstance(DuplocatorHashCallback.class);
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        long l2 = f ^ 0x6A479D9F52BFL;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/intellij/dupLocator/treeHash/DuplocatorHashCallback";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "report";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "writeDuplicates";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "writeFragments";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

