/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi;

import com.intellij.database.model.DataType;
import com.intellij.database.model.PsiObject;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlNameElement;
import com.intellij.sql.psi.SqlType;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SqlTableType
extends SqlType {
    @Nullable
    public abstract String getTypeName();

    @NotNull
    public abstract List<PsiObject> getMethods();

    @Nullable
    public abstract PsiElement getTypeElement();

    @Nullable
    public abstract PsiElement getImmediateTypeElement();

    public abstract int getColumnCount();

    public abstract String getColumnName(int var1);

    public abstract boolean isColumnQuoted(int var1);

    public abstract SqlType getColumnType(int var1);

    @NotNull
    public abstract PsiElement getColumnElement(int var1);

    @Nullable
    public abstract PsiElement getSourceColumnElement(int var1);

    @Nullable
    public abstract PsiElement getImmediateSourceColumnElement(int var1);

    @Nullable
    public abstract PsiElement getColumnQualifier(int var1);

    @Nullable
    public abstract String getColumnTypeAlias(int var1);

    public abstract boolean isColumnTypeAliasQuoted(int var1);

    public abstract SqlTableType join(SqlTableType var1);

    public abstract SqlTableType add(SqlTableType var1);

    public abstract SqlTableType subtract(PsiElement var1);

    public abstract SqlTableType alias(String var1, PsiElement var2, @NotNull List<? extends SqlNameElement> var3);

    public abstract SqlTableType aliasByDefs(String var1, PsiElement var2, @NotNull List<? extends SqlDefinition> var3);

    public abstract SqlTableType flattenedAlias(String var1, PsiElement var2, SqlElement var3);

    public abstract SqlTableType concretize(@Nullable SqlType.Category var1);

    @Override
    @NotNull
    public String getDisplayName() {
        StringBuilder sb = new StringBuilder();
        sb.append(StringUtil.notNullize((String)this.getTypeName())).append("(");
        boolean first = true;
        int len = this.getColumnCount();
        for (int i = 0; i < len; ++i) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(this.getColumnDisplayName(i));
        }
        sb.append(")");
        String string = sb.toString();
        if (string == null) {
            SqlTableType.$$$reportNull$$$0(0);
        }
        return string;
    }

    public String getColumnDisplayName(int i) {
        String name = this.getColumnName(i);
        SqlType type = this.getColumnType(i);
        DataType dataType = type.getDataType();
        String typeText = dataType != DataType.UNKNOWN ? ":" + dataType.getSpecification() : (type != UNKNOWN ? ":" + type.getDisplayName() : "");
        return name + typeText;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/SqlTableType", "getDisplayName"));
    }
}

