/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.jdbc.helpers;

import com.intellij.database.remote.jdba.jdbc.dialects.Postgres;
import com.intellij.database.remote.jdbc.helpers.JdbcNativeUtil;
import com.intellij.database.remote.jdbc.helpers.PgGPlumJdbcHelperBase;
import java.sql.Connection;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CRoachJdbcHelper
extends PgGPlumJdbcHelperBase {
    private static final Pattern CR_VERSION_PATTERN = Pattern.compile(" v(\\d+(?:\\.\\d+)*)", 2);

    public CRoachJdbcHelper(@Nullable String version, @Nullable Connection connection) {
        super(Postgres.RDBMS, version, connection);
    }

    public CRoachJdbcHelper() {
        this(null, null);
    }

    @Override
    @NotNull
    public String getDbmsName() {
        return "COCKROACHDB";
    }

    @Override
    public boolean supportsLimitMaxRows() {
        return false;
    }

    @Override
    @Nullable
    public Boolean supportsSavepoints() {
        return false;
    }

    @Override
    @Nullable
    public String parseVersion(@Nullable String version) {
        return CRoachJdbcHelper.extractVersion(version);
    }

    @NotNull
    protected static CRoachJdbcHelper create(@Nullable Connection delegate, @Nullable String productVer) {
        String version = CRoachJdbcHelper.extractVersion(productVer);
        return new CRoachJdbcHelper(version, delegate);
    }

    @Nullable
    public static String extractVersion(@Nullable String str) {
        return JdbcNativeUtil.findVersion(str, CR_VERSION_PATTERN);
    }
}

