/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.jdbc.helpers;

import com.intellij.database.remote.jdba.jdbc.JdbcIntermediateFacade;
import com.intellij.database.remote.jdba.jdbc.dialects.CHouseIntermediateFacade;
import com.intellij.database.remote.jdba.jdbc.dialects.ClickHouse;
import com.intellij.database.remote.jdba.jdbc.dialects.ExasolExceptionRecognizer;
import com.intellij.database.remote.jdbc.RemotePreparedStatement;
import com.intellij.database.remote.jdbc.helpers.JdbcHelper;
import com.intellij.database.remote.jdbc.helpers.JdbcHelperImpl;
import com.intellij.database.remote.jdbc.helpers.JdbcNativeUtil;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import javax.sql.DataSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CHouseJdbcHelper
extends JdbcHelperImpl {
    private static final String CHOUSE_HACKS = "dg.clickhouse.hacks";

    public CHouseJdbcHelper(@Nullable String version, @Nullable Connection connection) {
        super(ClickHouse.RDBMS, version, connection);
    }

    public CHouseJdbcHelper() {
        this(null, null);
    }

    @Override
    @Nullable
    public String parseVersion(@Nullable String version) {
        return CHouseJdbcHelper.extractVersion(version);
    }

    @Override
    @NotNull
    public JdbcIntermediateFacade createFacade(@NotNull DataSource ds) {
        if (ds == null) {
            CHouseJdbcHelper.$$$reportNull$$$0(0);
        }
        return new CHouseIntermediateFacade(ds, 1, false, ExasolExceptionRecognizer.INSTANCE);
    }

    @Override
    protected void setTimestamp(@NotNull RemotePreparedStatement statement, int idx, Timestamp timestamp) throws Exception {
        if (statement == null) {
            CHouseJdbcHelper.$$$reportNull$$$0(1);
        }
        statement.setTimestamp(idx, timestamp);
    }

    @Override
    protected void setTime(@NotNull RemotePreparedStatement statement, int idx, Time time) throws RemoteException, SQLException {
        if (statement == null) {
            CHouseJdbcHelper.$$$reportNull$$$0(2);
        }
        statement.setTime(idx, time);
    }

    @Override
    public char getEscapeChar() {
        return '\\';
    }

    @Override
    @NotNull
    protected String getCharsToEscape() {
        return "%_\\";
    }

    @Override
    public boolean supportsEscape() {
        return false;
    }

    @Override
    public int fixJdbcType(@Nullable String typeName, @Nullable String clazz, int type) {
        if (type == 1111 && "uuid".equalsIgnoreCase(typeName)) {
            return 12;
        }
        return super.fixJdbcType(typeName, clazz, type);
    }

    @Override
    protected boolean isDriverFailsOnType(int jdbcType, String typeName) {
        return super.isDriverFailsOnType(jdbcType, typeName) || jdbcType == 2003;
    }

    @Override
    public void adjustType(@NotNull JdbcHelper.Type e) {
        if (e == null) {
            CHouseJdbcHelper.$$$reportNull$$$0(3);
        }
        String nullable = "Nullable(";
        if (e.typeName != null && e.typeName.startsWith(nullable) && e.typeName.endsWith(")")) {
            e.nullable = true;
            e.typeName = e.typeName.substring(nullable.length(), e.typeName.length() - 1);
        }
        if (!"fixedstring".equalsIgnoreCase(e.typeName)) {
            e.length = -1;
        }
    }

    @Override
    public boolean supportsCalendarInPreparedStatement() {
        return false;
    }

    @Override
    public boolean supportsLimitMaxRows() {
        return false;
    }

    @Override
    @Nullable
    public final JdbcHelperImpl detect(@Nullable Connection delegate, @Nullable String product, @Nullable String productVer) throws Exception {
        if (!JdbcNativeUtil.detectString(product, "ClickHouse")) {
            return null;
        }
        JdbcNativeUtil.logInfo("getDatabaseProductName: " + product);
        return CHouseJdbcHelper.create(delegate, productVer);
    }

    @Override
    public boolean detect(@NotNull Driver driver, @Nullable String url) {
        if (driver == null) {
            CHouseJdbcHelper.$$$reportNull$$$0(4);
        }
        return CHouseJdbcHelper.classNameContains(driver, "clickhouse");
    }

    @Override
    @Nullable
    public final Connection connect(@NotNull Driver driver, String url, @NotNull Properties properties, @NotNull Map<String, Serializable> extra) throws SQLException {
        if (driver == null) {
            CHouseJdbcHelper.$$$reportNull$$$0(5);
        }
        if (properties == null) {
            CHouseJdbcHelper.$$$reportNull$$$0(6);
        }
        if (extra == null) {
            CHouseJdbcHelper.$$$reportNull$$$0(7);
        }
        if ("false".equals(System.getProperty(CHOUSE_HACKS))) {
            return null;
        }
        if (!properties.containsKey("session_id")) {
            String sessionId = "DataGrip_" + UUID.randomUUID().toString();
            properties.setProperty("session_id", sessionId);
            JdbcNativeUtil.logInfo("Generated session_id: " + sessionId);
        }
        return super.connect(driver, url, properties, extra);
    }

    @NotNull
    private static CHouseJdbcHelper create(@Nullable Connection delegate, @Nullable String productVer) throws Exception {
        String versionStr = delegate == null ? productVer : JdbcNativeUtil.getString(delegate, "select version()");
        JdbcNativeUtil.logInfo("version: " + versionStr);
        return new CHouseJdbcHelper(CHouseJdbcHelper.extractVersion(versionStr), delegate);
    }

    @Nullable
    public static String extractVersion(@Nullable String str) {
        return JdbcNativeUtil.findVersion(str, JdbcNativeUtil.DEFAULT_VERSION_PATTERN);
    }

    @Override
    public boolean getAutoCommit(Connection delegate) {
        return true;
    }

    @Override
    public boolean supportsTransactions() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ds";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "driver";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extra";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/remote/jdbc/helpers/CHouseJdbcHelper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createFacade";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "setTimestamp";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "setTime";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "adjustType";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "detect";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "connect";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

