/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.jdba.jdbc.dialects;

import com.intellij.database.remote.jdba.Rdbms;
import com.intellij.database.remote.jdba.core.ConnectionInfo;
import com.intellij.database.remote.jdba.intermediate.DBExceptionRecognizer;
import com.intellij.database.remote.jdba.jdbc.JdbcIntermediateFacade;
import com.intellij.database.remote.jdba.jdbc.JdbcIntermediateSession;
import com.intellij.database.remote.jdba.jdbc.dialects.Sybase;
import com.intellij.database.remote.jdba.jdbc.dialects.SybaseIntermediateSession;
import com.intellij.database.remote.jdba.util.Version;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.Properties;
import java.util.regex.Pattern;
import javax.sql.DataSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SybaseIntermediateFacade
extends JdbcIntermediateFacade {
    static final String CONNECTION_INFO_QUERY = "select db_name(), user_name(), suser_name(), @@version";
    static final Pattern SYBASE_ASE_VERSION_PATTERN = Pattern.compile("/(\\d{2}(\\.\\d{1,3}){1,5})");

    public SybaseIntermediateFacade(@NotNull String connectionString, @Nullable Properties connectionProperties, @NotNull Driver driver, int connectionsLimit, @NotNull DBExceptionRecognizer exceptionRecognizer) {
        if (connectionString == null) {
            SybaseIntermediateFacade.$$$reportNull$$$0(0);
        }
        if (driver == null) {
            SybaseIntermediateFacade.$$$reportNull$$$0(1);
        }
        if (exceptionRecognizer == null) {
            SybaseIntermediateFacade.$$$reportNull$$$0(2);
        }
        super(connectionString, connectionProperties, driver, connectionsLimit, exceptionRecognizer);
    }

    public SybaseIntermediateFacade(@NotNull DataSource dataSource, int connectionsLimit, boolean ownConnections, @NotNull DBExceptionRecognizer exceptionRecognizer) {
        if (dataSource == null) {
            SybaseIntermediateFacade.$$$reportNull$$$0(3);
        }
        if (exceptionRecognizer == null) {
            SybaseIntermediateFacade.$$$reportNull$$$0(4);
        }
        super(dataSource, connectionsLimit, ownConnections, exceptionRecognizer);
    }

    @Override
    @NotNull
    public Rdbms rdbms() {
        Rdbms rdbms = Sybase.RDBMS;
        if (rdbms == null) {
            SybaseIntermediateFacade.$$$reportNull$$$0(5);
        }
        return rdbms;
    }

    @Override
    @NotNull
    protected SybaseIntermediateSession instantiateSession(@NotNull Connection connection, boolean ownConnection) {
        if (connection == null) {
            SybaseIntermediateFacade.$$$reportNull$$$0(6);
        }
        return new SybaseIntermediateSession(this, this.myExceptionRecognizer, connection, ownConnection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConnectionInfo obtainConnectionInfoNatively() {
        String driverVersionStr;
        String rdbmsName;
        String[] env;
        JdbcIntermediateSession session = this.openSession();
        try {
            env = session.queryOneRow(CONNECTION_INFO_QUERY, 4, String.class);
            try {
                DatabaseMetaData md = session.getConnection().getMetaData();
                rdbmsName = md.getDatabaseProductName();
                if (rdbmsName == null) {
                    rdbmsName = session.getConnection().getClass().getName();
                }
                driverVersionStr = md.getDriverVersion();
            }
            catch (SQLException sqle) {
                throw this.getExceptionRecognizer().recognizeException(sqle, "getting versions using JDBC metadata");
            }
        }
        finally {
            session.close();
        }
        Version driverVersion = SybaseIntermediateFacade.extractVersion(driverVersionStr, SIMPLE_VERSION_PATTERN, 1);
        if (env != null) {
            assert (env.length == 4);
            String serverVersionStr = env[3];
            Version serverVersion = SybaseIntermediateFacade.parseServerVersion(serverVersionStr);
            return new ConnectionInfo(rdbmsName, env[0], env[1], env[2], serverVersion, driverVersion);
        }
        return new ConnectionInfo(rdbmsName, null, null, null, Version.ZERO, driverVersion);
    }

    @NotNull
    public static Version parseServerVersion(String serverVersionStr) {
        Version version = SybaseIntermediateFacade.extractVersion(serverVersionStr, SYBASE_ASE_VERSION_PATTERN, 1);
        if (version == null) {
            SybaseIntermediateFacade.$$$reportNull$$$0(7);
        }
        return version;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connectionString";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "driver";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exceptionRecognizer";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/remote/jdba/jdbc/dialects/SybaseIntermediateFacade";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/remote/jdba/jdbc/dialects/SybaseIntermediateFacade";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "rdbms";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "parseServerVersion";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 7: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "instantiateSession";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

