/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.jdba.jdbc.dialects;

import com.intellij.database.remote.jdba.Rdbms;
import com.intellij.database.remote.jdba.core.ConnectionInfo;
import com.intellij.database.remote.jdba.exceptions.OracleTimezoneRegionNotFoundException;
import com.intellij.database.remote.jdba.intermediate.DBExceptionRecognizer;
import com.intellij.database.remote.jdba.jdbc.JdbcIntermediateFacade;
import com.intellij.database.remote.jdba.jdbc.JdbcIntermediateSession;
import com.intellij.database.remote.jdba.jdbc.dialects.Oracle;
import com.intellij.database.remote.jdba.jdbc.dialects.OracleIntermediateSession;
import com.intellij.database.remote.jdba.jdbc.pooling.SimpleDataSource;
import java.sql.Connection;
import java.sql.Driver;
import java.util.Properties;
import javax.sql.DataSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OracleIntermediateFacade
extends JdbcIntermediateFacade {
    private Boolean myCompatibility1882;
    private static final String CONNECTION_INFO_QUERY = "select sys_context('userenv', 'db_name') as database_name,      \n       sys_context('userenv', 'current_schema') as schema_name, \n       user as user_name                                        \nfrom dual                                                       \n";

    public OracleIntermediateFacade(@NotNull String connectionString, @Nullable Properties connectionProperties, @NotNull Driver driver, int connectionsLimit, @NotNull DBExceptionRecognizer exceptionRecognizer) {
        if (connectionString == null) {
            OracleIntermediateFacade.$$$reportNull$$$0(0);
        }
        if (driver == null) {
            OracleIntermediateFacade.$$$reportNull$$$0(1);
        }
        if (exceptionRecognizer == null) {
            OracleIntermediateFacade.$$$reportNull$$$0(2);
        }
        super(connectionString, connectionProperties, driver, connectionsLimit, exceptionRecognizer);
    }

    public OracleIntermediateFacade(@NotNull DataSource dataSource, int connectionsLimit, boolean ownConnections, @NotNull DBExceptionRecognizer exceptionRecognizer) {
        if (dataSource == null) {
            OracleIntermediateFacade.$$$reportNull$$$0(3);
        }
        if (exceptionRecognizer == null) {
            OracleIntermediateFacade.$$$reportNull$$$0(4);
        }
        super(dataSource, connectionsLimit, ownConnections, exceptionRecognizer);
    }

    @Override
    @NotNull
    public Rdbms rdbms() {
        Rdbms rdbms = Oracle.RDBMS;
        if (rdbms == null) {
            OracleIntermediateFacade.$$$reportNull$$$0(5);
        }
        return rdbms;
    }

    @Override
    public synchronized void connect() {
        while (true) {
            try {
                super.connect();
            }
            catch (OracleTimezoneRegionNotFoundException otr) {
                if (this.myCompatibility1882 != null) break;
                DataSource originalDataSource = this.myPool.getOriginalDataSource();
                if (originalDataSource instanceof SimpleDataSource) {
                    SimpleDataSource sds = (SimpleDataSource)originalDataSource;
                    sds.setConnectionProperty("oracle.jdbc.timezoneAsRegion", "false");
                    this.myCompatibility1882 = Boolean.TRUE;
                    continue;
                }
                this.myCompatibility1882 = Boolean.FALSE;
            }
            break;
        }
    }

    @Override
    @NotNull
    protected JdbcIntermediateSession instantiateSession(@NotNull Connection connection, boolean ownConnection) {
        if (connection == null) {
            OracleIntermediateFacade.$$$reportNull$$$0(6);
        }
        return new OracleIntermediateSession(this, this.myExceptionRecognizer, connection, ownConnection);
    }

    @Override
    public ConnectionInfo obtainConnectionInfoNatively() {
        return this.getConnectionInfoSmartly(CONNECTION_INFO_QUERY, SIMPLE_VERSION_PATTERN, 1, SIMPLE_VERSION_PATTERN, 1);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connectionString";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "driver";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exceptionRecognizer";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/remote/jdba/jdbc/dialects/OracleIntermediateFacade";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/remote/jdba/jdbc/dialects/OracleIntermediateFacade";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "rdbms";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "instantiateSession";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

