/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.jdba.jdbc.dialects;

import com.intellij.database.remote.jdba.exceptions.DBException;
import com.intellij.database.remote.jdba.exceptions.NoRowsException;
import com.intellij.database.remote.jdba.exceptions.NoTableOrViewException;
import com.intellij.database.remote.jdba.exceptions.OracleTimezoneRegionNotFoundException;
import com.intellij.database.remote.jdba.jdbc.BaseExceptionRecognizer;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OracleExceptionRecognizer
extends BaseExceptionRecognizer {
    public static final OracleExceptionRecognizer INSTANCE = new OracleExceptionRecognizer();
    private static final Map<Integer, Class<? extends DBException>> simpleExceptionMap = new HashMap<Integer, Class<? extends DBException>>();
    private static final Pattern ORA_ERROR_PATTERN;

    @Override
    @Nullable
    protected DBException recognizeSpecificException(@NotNull SQLException sqle, @Nullable String statementText) {
        Class<? extends DBException> simpleExceptionClass;
        if (sqle == null) {
            OracleExceptionRecognizer.$$$reportNull$$$0(0);
        }
        int errCode = sqle.getErrorCode();
        String errMsg = sqle.getMessage();
        if (errCode == 604 && errMsg != null) {
            errCode = this.parseRealErrCode(errMsg);
        }
        if ((simpleExceptionClass = simpleExceptionMap.get(errCode)) != null) {
            return this.instantiateDBException(simpleExceptionClass, sqle, statementText);
        }
        return null;
    }

    private int parseRealErrCode(@NotNull String errMsg) {
        if (errMsg == null) {
            OracleExceptionRecognizer.$$$reportNull$$$0(1);
        }
        Matcher m = ORA_ERROR_PATTERN.matcher(errMsg);
        boolean found = m.find();
        while (found) {
            int code = Integer.parseInt(m.group(1), 10);
            if (code > 0 && code != 604) {
                return code;
            }
            found = m.find(m.end());
        }
        return 604;
    }

    static {
        simpleExceptionMap.put(942, NoTableOrViewException.class);
        simpleExceptionMap.put(1403, NoRowsException.class);
        simpleExceptionMap.put(1882, OracleTimezoneRegionNotFoundException.class);
        ORA_ERROR_PATTERN = Pattern.compile("ORA-(\\d{5}):");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sqle";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errMsg";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/remote/jdba/jdbc/dialects/OracleExceptionRecognizer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "recognizeSpecificException";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "parseRealErrCode";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

