/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.view;

import com.intellij.DynamicBundle;
import com.intellij.docker.agent.settings.DockerAgentContainerConfig;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.docker.runtimes.DockerApplicationRuntime;
import com.intellij.docker.view.DockerRuntimeEditorBase;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remoteServer.util.Column;
import com.intellij.remoteServer.util.JTableWrapper;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.table.JBTable;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DockerPropertiesRuntimeEditor
extends DockerRuntimeEditorBase {
    private JButton mySaveButton;
    private JPanel myTablePlaceHolder;
    private JLabel myContainerLabel;
    private JPanel myMainPanel;
    private JComboBox myContainerNamesBox;
    private final List<DockerContainerProp> myItems;
    private static final Pattern CONTAINER_NAME_PATTERN = Pattern.compile("^[\\/]?[a-zA-Z0-9_.-]+");
    private final JBTable myPropsTable;

    public DockerPropertiesRuntimeEditor(DockerAgentContainerConfig config, DockerApplicationRuntime applicationRuntime, DockerRuntimeEditorBase.ConfigApplier configApplier) {
        super(DockerBundle.message("DockerPropertiesRuntimeEditor.name", new Object[0]), configApplier);
        this.$$$setupUI$$$();
        this.myPropsTable = new JBTable();
        this.initControls(this.myMainPanel, this.mySaveButton);
        this.myItems = new ArrayList<DockerContainerProp>();
        this.myItems.add(new DockerContainerProp(DockerBundle.message("DockerPropertiesRuntimeEditor.property.image.id", new Object[0]), applicationRuntime.getImageId()));
        String containerId = applicationRuntime.getContainerId();
        if (containerId != null) {
            String[] containerNames;
            this.getContainerNamesBox().removeAllItems();
            String requestedContainerName = config.getContainerName();
            for (String name : containerNames = Optional.ofNullable(applicationRuntime.getContainerNames()).orElseGet(() -> new String[]{requestedContainerName})) {
                this.getContainerNamesBox().addItem(name);
            }
            this.getContainerNamesBox().setSelectedItem(requestedContainerName);
            this.myItems.add(new DockerContainerProp(DockerBundle.message("DockerPropertiesRuntimeEditor.property.container.id", new Object[0]), containerId));
            this.myItems.add(new DockerContainerProp(DockerBundle.message("DockerPropertiesRuntimeEditor.property.container.names", new Object[0]), StringUtil.join((String[])containerNames, (String)"; ")));
        } else {
            this.hideContainerControls();
            String imageTags = StringUtil.join(applicationRuntime.getImageRepoTags(), (String)"; ");
            this.myItems.add(new DockerContainerProp(DockerBundle.message("DockerPropertiesRuntimeEditor.property.image.tags", new Object[0]), imageTags));
            String STATUS_SEPARATOR = "/";
            Supplier<String> ageSupplier = () -> DockerPropertiesRuntimeEditor.getImageAge(applicationRuntime, "/");
            String size = Optional.ofNullable(applicationRuntime.getStatusText()).map(text -> StringUtil.substringAfter((String)text, (String)"/")).orElse(null);
            if (ageSupplier.get() != null && size != null) {
                this.myItems.add(new DockerDynamicProperty(DockerBundle.message("DockerPropertiesRuntimeEditor.property.image.created", new Object[0]), ageSupplier));
                this.myItems.add(new DockerContainerProp(DockerBundle.message("DockerPropertiesRuntimeEditor.property.image.size", new Object[0]), size.trim()));
            }
        }
        JPanel tableEditor = ToolbarDecorator.createDecorator((JTable)this.myPropsTable).addExtraAction(new AnActionButton(DockerBundle.message("DockerPropertiesRuntimeEditor.action.copy.to.clipboard.name", new Object[0]), AllIcons.Actions.Copy){

            public void actionPerformed(@NotNull AnActionEvent e) {
                int selectedIndex;
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((selectedIndex = DockerPropertiesRuntimeEditor.this.myPropsTable.getSelectedRow()) == -1) {
                    return;
                }
                CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(((DockerContainerProp)DockerPropertiesRuntimeEditor.this.myItems.get(selectedIndex)).getValue()));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/docker/view/DockerPropertiesRuntimeEditor$1", "actionPerformed"));
            }
        }).createPanel();
        this.myTablePlaceHolder.add(tableEditor);
        final JTableWrapper propsTableWrapper = new JTableWrapper(this.myPropsTable, (Column[])new ColumnBase[]{new NameColumn(), new ValueColumn()});
        propsTableWrapper.setInputRows(this.myItems);
        boolean hasDynamicProperties = this.myItems.stream().anyMatch(DockerDynamicProperty.class::isInstance);
        if (hasDynamicProperties) {
            new UiNotifyConnector((Component)this.myPropsTable, new Activatable(){

                public void showNotify() {
                    propsTableWrapper.setInputRows(DockerPropertiesRuntimeEditor.this.myItems);
                }

                public void hideNotify() {
                }
            });
        }
    }

    @Override
    protected DockerAgentContainerConfig createConfig() {
        final String containerName = this.myContainerNamesBox.getEditor().getItem().toString();
        if (this.myContainerNamesBox.getItemCount() > 1 && Messages.showYesNoDialog((Component)this.getMainPanel(), (String)DockerBundle.message("DockerPropertiesRuntimeEditor.containers.names.warning.message", new Object[0]), (String)DockerBundle.message("DockerPropertiesRuntimeEditor.containers.names.warning.title", new Object[0]), (Icon)Messages.getWarningIcon()) != 1 || this.myContainerNamesBox.getItemCount() == 1) {
            if (!CONTAINER_NAME_PATTERN.matcher(containerName).matches()) {
                Messages.showErrorDialog((String)(containerName.isEmpty() ? DockerBundle.message("DockerPropertiesRuntimeEditor.container.name.error.empty.message", new Object[0]) : DockerBundle.message("DockerPropertiesRuntimeEditor.container.name.error.invalid.message", containerName)), (String)DockerBundle.message("DockerPropertiesRuntimeEditor.container.name.error.title", new Object[0]));
            } else {
                return new DockerAgentContainerConfig.Adapter(){

                    public String getContainerName() {
                        return StringUtil.nullize((String)containerName);
                    }
                };
            }
        }
        return null;
    }

    private void hideContainerControls() {
        this.myContainerLabel.setVisible(false);
        this.myContainerNamesBox.setVisible(false);
        this.mySaveButton.setVisible(false);
    }

    @Override
    @NotNull
    protected String getContextHelpId() {
        return "reference.docker.runtime.properties";
    }

    private JComboBox<String> getContainerNamesBox() {
        return this.myContainerNamesBox;
    }

    @Nullable
    private static String getImageAge(@NotNull DockerApplicationRuntime imageRuntime, @NotNull String statusSeparator) {
        if (imageRuntime == null) {
            DockerPropertiesRuntimeEditor.$$$reportNull$$$0(0);
        }
        if (statusSeparator == null) {
            DockerPropertiesRuntimeEditor.$$$reportNull$$$0(1);
        }
        return Optional.ofNullable(imageRuntime.getStatusText()).map(text -> StringUtil.substringBefore((String)text, (String)statusSeparator)).orElse(null);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JComboBox jComboBox;
        JPanel jPanel;
        JButton jButton;
        JLabel jLabel;
        JPanel jPanel2;
        this.myMainPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myContainerLabel = jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/DockerBundle", DockerPropertiesRuntimeEditor.class).getString("DockerPropertiesRuntimeEditor.container.name.text"));
        jPanel2.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.mySaveButton = jButton = new JButton();
        this.$$$loadButtonText$$$(jButton, DynamicBundle.getBundle((String)"messages/DockerBundle", DockerPropertiesRuntimeEditor.class).getString("DockerPropertiesRuntimeEditor.save.text"));
        jPanel2.add((Component)jButton, new GridConstraints(0, 2, 1, 1, 4, 0, 3, 0, null, null, null));
        this.myTablePlaceHolder = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(1, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        this.myContainerNamesBox = jComboBox = new JComboBox();
        jComboBox.setEditable(true);
        jPanel2.add(jComboBox, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(180, -1), null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "imageRuntime";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "statusSeparator";
                break;
            }
        }
        objectArray[1] = "com/intellij/docker/view/DockerPropertiesRuntimeEditor";
        objectArray[2] = "getImageAge";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class DockerDynamicProperty
    extends DockerContainerProp {
        private final Supplier<String> myValueProducer;

        DockerDynamicProperty(@NotNull String name, @NotNull Supplier<String> valueProducer) {
            if (name == null) {
                DockerDynamicProperty.$$$reportNull$$$0(0);
            }
            if (valueProducer == null) {
                DockerDynamicProperty.$$$reportNull$$$0(1);
            }
            super(name, valueProducer.get());
            this.myValueProducer = valueProducer;
        }

        @Override
        public String getValue() {
            return this.myValueProducer.get();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "name";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "valueProducer";
                    break;
                }
            }
            objectArray[1] = "com/intellij/docker/view/DockerPropertiesRuntimeEditor$DockerDynamicProperty";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class DockerContainerProp {
        private final String myName;
        private final String myValue;

        DockerContainerProp(String name, String value) {
            this.myName = name;
            this.myValue = value;
        }

        public String getName() {
            return this.myName;
        }

        public String getValue() {
            return this.myValue;
        }
    }

    private static class ValueColumn
    extends ColumnBase {
        ValueColumn() {
            super("Value");
        }

        public Object getColumnValue(DockerContainerProp row) {
            return row.getValue();
        }
    }

    private static class NameColumn
    extends ColumnBase {
        NameColumn() {
            super("Name");
        }

        public Object getColumnValue(DockerContainerProp row) {
            return row.getName();
        }
    }

    private static abstract class ColumnBase
    extends Column<DockerContainerProp> {
        ColumnBase(String name) {
            super(name);
        }
    }
}

