/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.debug;

import com.intellij.docker.DockerDeploymentConfiguration;
import com.intellij.docker.DockerDeploymentStatus;
import com.intellij.docker.debug.DockerContainerWaiter;
import com.intellij.openapi.util.Condition;
import com.intellij.remoteServer.runtime.Deployment;
import com.intellij.remoteServer.runtime.ServerConnection;
import com.intellij.remoteServer.runtime.deployment.DeploymentStatus;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DeploymentStatusWaiter
extends DockerContainerWaiter {
    DeploymentStatusWaiter(@NotNull ServerConnection<DockerDeploymentConfiguration> connection, @NotNull Condition<? super Deployment> deploymentSearch) {
        if (connection == null) {
            DeploymentStatusWaiter.$$$reportNull$$$0(0);
        }
        if (deploymentSearch == null) {
            DeploymentStatusWaiter.$$$reportNull$$$0(1);
        }
        super(connection, deploymentSearch);
    }

    @Override
    public Boolean waitForContainer(long timeout, TimeUnit unit) {
        try {
            DeploymentStatus status = this.waitForNotNull(timeout, unit, DeploymentStatusWaiter::getStatusIfSettled);
            return status == DeploymentStatus.DEPLOYED;
        }
        catch (InterruptedException e) {
            return null;
        }
    }

    @Nullable
    private static DeploymentStatus getStatusIfSettled(Deployment deployment) {
        DeploymentStatus status = deployment.getStatus();
        if (status.isTransition()) {
            return null;
        }
        if (status == DockerDeploymentStatus.CREATED.getStatus()) {
            return null;
        }
        return status;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "connection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "deploymentSearch";
                break;
            }
        }
        objectArray[1] = "com/intellij/docker/debug/DeploymentStatusWaiter";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

